/*
 * The_xmloperator_project Software License, Version 1.7
 *
 * Copyright (c) 2000 - 2003 The_xmloperator_project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *      "This product includes or uses software developped
 *       by The_xmloperator_project (http://www.xmloperator.net/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. Products derived from this software may not be called "xmloperator",
 *    nor may "xmloperator" appear in their name, without prior written
 *    permission. For written permission, please contact
 *    the xmloperator project administrator.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE_XMLOPERATOR_PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * Further information can be found on the project's site
 * (http://www.xmloperator.net/).
 */
package xmltorng.i2s.impl;

import java.util.Map;

import xmltorng.framework.document.relaxng.Name;
import xmltorng.framework.document.relaxng.Pattern;
import xmltorng.framework.document.relaxng.NonEmptyPattern;
import xmltorng.i2s.framework.PatternCategory;
import xmltorng.i2s.framework.AttributesPatternCategory;
import xmltorng.i2s.framework.RepeatableName;
import xmltorng.i2s.util.PatternFactory;
import xmltorng.i2s.impl.AttributesPatternCategoryImpl;

/**
 * The <code>EmptyPatternCategory</code> contains the empty pattern and the
 *   combining of attribute set pattern and text pattern.
 *
 * Formally :
 * attribute ::= <attribute name="QName"> <text/> </attribute>
 * attributes ::= attribute | (<group> attribute+ </group>)
 * content ::= <empty/> | attributes | <text/>
 *   | (<group> attributes </text> </group>)
 */
public final class EmptyPatternCategory implements PatternCategory {
  private final AttributesPatternCategory attributesPatternCategory =
      new AttributesPatternCategoryImpl();
  private boolean hasText = false;

  public EmptyPatternCategory() {
  }

  public AttributesPatternCategory attributesPatternCategory() {
    return attributesPatternCategory;
  }

  public boolean hasText() {
    return hasText;
  }

  /////////////////////////////////
  // PatternCategory implementation
  /////////////////////////////////

  public final Pattern fullPattern(Map fromNameToElementDefinition) {
    Pattern pattern = this.attributesPatternCategory.fullPattern();
    if (pattern.isEmpty())
      return this.hasText ? PatternFactory.textPattern() :
      PatternFactory.emptyPattern();
    if (this.hasText)
      pattern = PatternFactory.group(
          new NonEmptyPattern[]
          {(NonEmptyPattern)pattern, PatternFactory.textPattern()});
    return pattern;
  }

  public boolean addPattern(
      Name[] attributeNames, boolean hasText,
      RepeatableName[] repeatableElementNames) {
    if (repeatableElementNames.length != 0)
      return false;
    if (hasText)
      this.hasText = true;
    this.attributesPatternCategory.addAttributeNames(attributeNames);
    return true;
  }
}
