import RPCConnection
import numpy as np
import time
import scipy.io
import caffe
import skimage
import os
import sys

from SimilarSearcher import SimilarSearcher

from PIL import Image

dataPath = "../data/RTR/"
model_def        = os.path.join( dataPath, "RTR_deploy_fc6.prototxt")
pretrained_model = os.path.join( dataPath, "RTR_iter_25000")
mean_file        = os.path.join( dataPath, "ilsvrc_2012_mean.npy")

imageDim = 256
image_dims = [ imageDim, imageDim]
gpu = True
input_scale = 255
channel_swap = [2,1,0]

# Make classifier.
classifier = caffe.Classifier(model_def, pretrained_model,
            image_dims=image_dims, gpu=gpu, mean_file=mean_file,
            input_scale=input_scale, channel_swap=channel_swap)

searcher = SimilarSearcher( classifier, imageDim, modelData, modelURL)

for line in sys.stdin:
    with open( ) as f:
        image = Image.open( f)
        searcher.pricessImage( image)

