#pragma once
#ifndef RANDOMFEATURE_H
#define RANDOMFEATURE_H

#include "ITubeFeature.h"
#include "ITubeFeatureExtractor.h"

namespace SummarizationFramework
{
namespace TubeFeatures
{
namespace Features
{


class RandomFeature : public ITubeFeature
{
public:
	static FeatureId Id;

	class Extractor;
	typedef cv::Ptr<Extractor> ExtractorPtr;

	RandomFeature() : ITubeFeature(Id)
	{
	}

	RandomFeature(FeatureData data) : ITubeFeature(Id, data)
	{
	}

	virtual ~RandomFeature()
	{
	}
};

typedef cv::Ptr<RandomFeature> RandomFeaturePtr;

class RandomFeature::Extractor : public ITubeFeatureExtractor
{
public:
	Extractor() : ITubeFeatureExtractor()
	{
	}

	virtual ~Extractor()
	{
	}

	virtual void Reset(int size)
	{
	}

	virtual void Next(Frame frame, FrameMask mask, cv::Rect boundingBox)
	{
	}

	virtual ITubeFeaturePtr Finish()
	{
		cv::Mat data(1, 1, CV_64F);
		data.at<double>(0,0) = ((double)(rand()%100))/100;
		return new RandomFeature(data);
	}
};

#ifndef QT
RandomFeature::FeatureId RandomFeature::Id = "random";
#endif


}}}

#endif // RANDOMFEATURE_H
