#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QBoxLayout>
#include <QFileDialog>
#include <QSaveFile>
#include "summvideoselector.h"
#include "summworkerthread.h"
#include "segmentstimeline.h"
#include "cvvideoplayer.h"
#include "playerthread.h"
#include "progressindicator.h"
#include "videocontrols.h"
#include "summmethodselector.h"
#include "windowstate.h"
#include "exportwindow.h"
#include "../SummarizationFramework/Model/VideoSequence.h"
#include "../SummarizationFramework/Model/TubeCollection.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_videoSelector_itemSelected(SummVideoSelectorModelItem *item);
    void on_videoSelector_exportRequested();
    void on_worker_started(SummWorkerThread *thread);
    void on_worker_finished(SummWorkerThread *thread);
    void on_videoControls_play();
    void on_videoControls_stop();
    void on_videoControls_goToStart();
    void on_videoControls_goToEnd();
    void on_videoControls_goBackwards();
    void on_videoControls_goBackwardsFast();
    void on_videoControls_goForwards();
    void on_videoControls_goForwardsFast();
    void on_videoControls_changeSequence(VideoControls::Sequence);
    void on_segmentSelector_cursorMoved(int segmentIdx, double positionSegment, double positionGlobal);
    void on_segmentSelector_segmentClicked(int segmentIdx, double positionSegment, double positionGlobal);
    void on_videoPlayer_positionChanged(int frame);
    void on_playerThread_playbackStarted(PlayerThread *thread);
    void on_playerThread_playbackStopped(PlayerThread *thread);
    void on_playerThread_nextFrameRequested(PlayerThread *thread, bool *requestStop);
    void on_methodSelector_recomputeRequested(SummMethodSelector *selector);

private:
    Ui::MainWindow *ui;
    SummWorkerThread *workerThread;
    PlayerThread *playerThread;
    ProgressIndicator *progressIndicator;
    WindowState *currentState;

    static QColor colorSegmentSumm;
    static QColor colorSegmentOther;

    void setStateSourceVideoOpened(QString video);
    void setStateSummarizedVideoOpened(QString video, SummarizationFramework::Model::TubeCollectionPtr tubes);
    void setStateAllClosed();
    void startWorker(SummAlgorithmCore *method, cv::Mat data, QString filename);
    void acceptOrCreateState(SummVideoSelectorModelItem *item);
    void computeSummarization();

    static SegmentsTimeline::Segments tubesToSegments(SummarizationFramework::Model::TubeCollectionPtr tubes, int videoLength);
    static CvVideoPlayer::PlaySchema tubesToPlaySchema(SummarizationFramework::Model::TubeCollectionPtr tubes);

    virtual void resizeEvent(QResizeEvent *e);
};

#endif // MAINWINDOW_H
