#include "playerthread.h"

PlayerThread::PlayerThread(QObject *parent) : QThread(parent)
{
}

void PlayerThread::startPlayback(PlayerThread::Mode mode, double fps)
{
    this->mode = mode;
    this->fps = fps;
    this->stopRequest = false;
    this->start();
}

void PlayerThread::stopPlayback()
{
    stopRequest = true;
}

PlayerThread::Mode PlayerThread::getMode() const
{
    return mode;
}

double PlayerThread::getFps() const
{
    return fps;
}

void PlayerThread::run()
{
    emit playbackStarted(this);

    while(!stopRequest)
    {
        emit nextFrameRequested(this, &stopRequest);
        msleep(1000.0/fps);
    }

    emit playbackStopped(this);
}
