#ifndef PLAYERTHREAD_H
#define PLAYERTHREAD_H

#include <QThread>

class PlayerThread : public QThread
{
    Q_OBJECT;

public:
    typedef enum
    {
        PLAY_ALL,
        PLAY_SEGMENTS_ONLY
    } Mode;

private:
    Mode mode;
    double fps;
    bool stopRequest;

signals:
    void playbackStarted(PlayerThread *thread);
    void playbackStopped(PlayerThread *thread);
    void nextFrameRequested(PlayerThread *thread, bool *requestStop);

public:
    PlayerThread(QObject *parent = NULL);
    void startPlayback(Mode mode, double fps);
    void stopPlayback();
    Mode getMode() const;
    double getFps() const;

private:
    void run();
};

#endif // PLAYERTHREAD_H
