#ifndef SUMMWORKERTHREAD_H
#define SUMMWORKERTHREAD_H

#include <QThread>
#include "summalgorithmcore.h"

class SummWorkerThread : public QThread
{
    Q_OBJECT;

public:
    typedef enum
    {
        ST_UNPROCESSED,
        ST_PROCESSING,
        ST_DONE,
        ST_ERROR
    } Status;

private:
    SummAlgorithmCore *method;
    cv::Mat data;
    QString filename;
    SummarizationFramework::Model::TubeCollectionPtr tubes;
    Status status;

    void setStatus(Status status);

signals:
    void started(SummWorkerThread *thread);
    void finished(SummWorkerThread *thread);
    void statusChanged(SummWorkerThread *thread, Status status);

public:
    SummWorkerThread(SummAlgorithmCore *method, cv::Mat data, QString filename, QObject *parent = NULL);
    void run();
    void setData(cv::Mat & data, QString filename);
    void setMethod(SummAlgorithmCore *method);
    Status getStatus() const;
    SummarizationFramework::Model::TubeCollectionPtr getTubes() const;
};

#endif // SUMMWORKERTHREAD_H
