#ifndef VIDEOCONTROLS_H
#define VIDEOCONTROLS_H

#include <QWidget>
#include <QDebug>
#include "paramswidgetfixedlengthlm.h"

namespace Ui {
class VideoControls;
}

class VideoControls : public QWidget
{
    Q_OBJECT

private:
    static const QString TOOLTIP_PLAY;
    static const QString TOOLTIP_STOP;
    static const QString TOOLTIP_FORWARDS;
    static const QString TOOLTIP_FORWARDS_FAST;
    static const QString TOOLTIP_BACKWARDS;
    static const QString TOOLTIP_BACKWARDS_FAST;
    static const QString TOOLTIP_GOTO_START;
    static const QString TOOLTIP_GOTO_END;
    static const QString TOOLTIP_CHANGE_SEQUENCE;
    static const QString SEQUENCE_ORIGINAL;
    static const QString SEQUENCE_SUMMARIZED;

public:
    typedef enum
    {
        STATE_IDLE,
        STATE_PLAYING
    } State;

    typedef enum
    {
        SEQ_ORIGINAL,
        SEQ_SUMMARIZED
    } Sequence;

private:
    Ui::VideoControls *ui;
    State state;

public:
    explicit VideoControls(QWidget *parent = 0);
    ~VideoControls();
    void setAutoRepeatDelay(int delay);
    void setAutoRepeat(bool autoRepeat);
    State getState() const;
    void setState(State state);
    Sequence getSequence() const;
    void setSequence(Sequence seq);
    
private:
    void setStateIdle();
    void setStatePlaying();

signals:
    void play();
    void stop();
    void goToStart();
    void goToEnd();
    void goBackwards();
    void goBackwardsFast();
    void goForwards();
    void goForwardsFast();
    void changeSequence(VideoControls::Sequence seq);

private slots:
    void on_btnGoToStart_clicked();
    void on_btnGoBackwardsFast_clicked();
    void on_btnGoBackwards_clicked();
    void on_btnPlay_clicked();
    void on_btnGoForwards_clicked();
    void on_btnGoForwardsFast_clicked();
    void on_btnGoToEnd_clicked();
    void on_cmbChangeSequence_currentIndexChanged(int index);
};

#endif // VIDEOCONTROLS_H
