#include "paramswidgetcoveragedrivenlm.h"
#include "ui_paramswidgetcoveragedrivenlm.h"

ParamsWidgetCoverageDrivenLm::ParamsWidgetCoverageDrivenLm(QWidget *parent) :
    ParamsWidget(parent),
    ui(new Ui::ParamsWidgetCoverageDrivenLm)
{
    ui->setupUi(this);
}

ParamsWidgetCoverageDrivenLm::~ParamsWidgetCoverageDrivenLm()
{
    delete ui;
}

SummAlgorithmParams *ParamsWidgetCoverageDrivenLm::getParams()
{
    CoverageDrivenLmAlgorithmParams *params = new CoverageDrivenLmAlgorithmParams();
    params->segmentLength = ui->segmentLengthInput->value();
    params->segmentCount = ui->segmentsCountInput->value();
    params->featureRowIndex = ui->featureRowInput->value();

    return params;
}

void ParamsWidgetCoverageDrivenLm::setParams(SummAlgorithmParams *params)
{
    CoverageDrivenLmAlgorithmParams *paramsCoverageDriven = (CoverageDrivenLmAlgorithmParams *)params;

    ui->segmentLengthInput->setValue(paramsCoverageDriven->segmentLength);
    ui->segmentsCountInput->setValue(paramsCoverageDriven->segmentCount);
    ui->featureRowInput->setValue(paramsCoverageDriven->featureRowIndex);
}

void ParamsWidgetCoverageDrivenLm::on_segmentLengthInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}

void ParamsWidgetCoverageDrivenLm::on_segmentsCountInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}

void ParamsWidgetCoverageDrivenLm::on_featureRowInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}
