#ifndef SUMMMETHODSELECTOR_H
#define SUMMMETHODSELECTOR_H

#include <QWidget>
#include "summalgorithmcore.h"
#include "paramswidgetfixedlengthlm.h"
#include "paramswidgetcoveragedrivenlm.h"

namespace Ui {
class SummMethodSelectorItem;
class FixedLengthIntervalLmAlgorithmSummMethodSelectorItem;
class SummMethodSelector;
}

/*===== Items =====*/
class SummMethodSelectorItem
{
protected:
    SummAlgorithmCore *method;

public:
    SummMethodSelectorItem();
    SummAlgorithmCore *getMethod() const;
    virtual QString getName() const;
    virtual ParamsWidget *createParamsWidet() const;
    virtual SummAlgorithmCore *createMethod() const;
};

class FixedLengthIntervalLmAlgorithmSummMethodSelectorItem : public SummMethodSelectorItem
{
public:
    FixedLengthIntervalLmAlgorithmSummMethodSelectorItem();
    SummAlgorithmCore *getMethod() const;
    virtual QString getName() const;
    virtual ParamsWidget *createParamsWidet() const;
    virtual SummAlgorithmCore *createMethod() const;
};

class CoverageDrivenLmAlgorithmSummMethodSelectorItem : public SummMethodSelectorItem
{
public:
    CoverageDrivenLmAlgorithmSummMethodSelectorItem();
    SummAlgorithmCore *getMethod() const;
    virtual QString getName() const;
    virtual ParamsWidget *createParamsWidet() const;
    virtual SummAlgorithmCore *createMethod() const;
};


/*===== Widget =====*/
class SummMethodSelector : public QWidget
{
    Q_OBJECT

private:
    ParamsWidget *paramsWidget;
    int nextId;

public:
    explicit SummMethodSelector(QWidget *parent = 0);
    ~SummMethodSelector();
    void addMethod(SummMethodSelectorItem *item);
    SummAlgorithmCore *getMethod();
    void setMethod(SummAlgorithmCore *method);
    void setMethod(unsigned int idx);
    void setAutoRecompute(bool autoRecompute);

signals:
    void recomputeRequested(SummMethodSelector *selector);

private slots:
    void on_algorithmSelector_currentIndexChanged(int index);
    void on_recomputeButton_clicked();
    void on_resetParamsButton_clicked();
    void on_makeDefaultParamsButton_clicked();
    void on_autoRecomputeCheckbox_stateChanged(int arg1);
    void on_paramsWidget_paramsChanged();

private:
    Ui::SummMethodSelector *ui;

    void setParamsWidget(ParamsWidget *paramsWidget);
    SummMethodSelectorItem *getCurrentItem();
};

#endif // SUMMMETHODSELECTOR_H
