#!/usr/bin/env python3
# Generator of graphviz representation of IRI table
# Copyright (C) 2013 Libor Polčák
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import itertools
import sys
from modules.shared.nid import CreateNID

try:
    in_file = sys.argv[1]
except:
    in_file = "irip.content"

print("graph{")
print("K=2;")
print("rankdir=LR;")

all_nids = set([])

colors = {
        "A": "red",
        "B": "blue",
        "C": "green",
        "D": "black",
        }

try:
    with open(in_file) as input:
        for line in input:
            try:
                info = line.strip().split("\t")
                module = info[0]
                nids = info[1:]
                all_nids.update(nids)
                tuples = [a for a in itertools.combinations(nids, 2)]
                for a, b in tuples:
                    print('"%s"--"%s" [label="%s"];' % (a, b, module))
            except:
                pass
except IOError:
    sys.stderr.write("Cannot open %s\n" % in_file)

for nid in all_nids:
    print('"%s" [color="%s"];' % (nid, colors[CreateNID(nid).getIdentifierType()]))

print("}")
