# Class describing interception transferred through HI1
#
# Copyright (C) 2011 Matej Gregr, Michal Kajan, Libor Polcak,
#                    Vladimir Vesely, Petr Kramolis
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


class DHCPStatus:
    
    def __init__(self, dhcp_type="",src_mac="",addr="",time=0, description=""):
        self.msg_type=dhcp_type
        self.src_mac=src_mac
        self.ipaddr=addr
        self.timestamp=time
        self.description=description

    def _hexa_to_mac(self,hex):
        pos = 2
        i = 0
        while (i<5):
            hex = hex[:pos] + ":" +hex[pos:]
            pos=pos+3
            i=i+1;
        return hex

    def __repr__(self):
        #|modul id | ts | iri-type | [(MAC,mac), ...] |
        retval = ""
        parsed_mac = ""

        identifier_type = "MAC"
        if self.src_mac[:2] == "0x":
            identifier_type = "DHCP client ID"
            if self.src_mac[:4] == "0x01" and len(self.src_mac) == 16: #//0x01a8206601746e
                parsed_mac = self._hexa_to_mac(self.src_mac[4:])

        retval = "('dhcp', %s, '%s','%s',[('%s','%s')" % (self.timestamp,
                    self.msg_type,self.description, identifier_type, self.src_mac)

        if self.ipaddr != "" and self.ipaddr != 0:
            retval = retval + (",('IPv4','%s')" % (self.ipaddr))

        if parsed_mac != "":
            retval = retval + (",('MAC','%s')" % (parsed_mac))

        retval = retval + "])"
        return retval
