/*
 * Soubor:  detekce_protokolu.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkci ktera analyzuje prijaty paket a vrati zjistene udaje.
 */

#ifndef _DETEKCE_PROTOKOLU_
#define _DETEKCE_PROTOKOLU_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
// ethernetová hlavicka
#include <net/ethernet.h>
// ipv4
#include <netinet/ip.h>
// ipv6
#include <netinet/ip6.h>
#include <netinet/tcp.h>

#include <pcap/bpf.h>
#include <pcap/sll.h>

#include "my_string.h"
#include "xmpp.h"
#include "irc.h"
#include "oscar.h"
#include "zpracovany_packet.h"

#define IPV6_LENGTH 40
#define IPV6_EXT_LENGTH 8

struct data_packetu ziskej_obsah(const struct pcap_pkthdr *header, const u_char *packet, int link_type);
int podle_portu(const u_char *packet);
void ip_verze_4(const u_char *packet, struct data_packetu *vyfiltrovano_z_packetu);
void ip_verze_6(const u_char *packet, struct data_packetu *vyfiltrovano_z_packetu);
void tcp(const u_char *packet, struct data_packetu *vyfiltrovano_z_packetu, int velikost_dat_v_ip, int delka_ip_hlavicky);
#endif
