/*
 * Soubor:  irc.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkce zpracovavajici irc protokol
 */

#ifndef _IRC_
#define _IRC_

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <limits.h>
 #include <errno.h>

#include "my_string.h"
#include "zpracovany_packet.h"
#include "iri.h"
#include "sprava.h"


struct irc_prikaz
{
	char *prefix;
	char *prikaz;
	char *parametry;
};

void zpracuj_irc(struct data_packetu *zprava, struct sezeni *Sezeni);
void ukonci_irc(struct data_packetu *zprava, struct sezeni *Sezeni);
void zpracuj_prikaz(char *prikaz, struct sezeni *Sezeni, int smer, struct timeval *cas_zachyceni);
void identifikuj_pozadavek(struct irc_prikaz *pozadavek, struct sezeni *Sezeni, int smer, struct timeval *cas_zachyceni);

char *prvni_parametr(char *parametry);
char *druhy_parametr(char *parametry);
int je_cislo(char *retezec);
char *odesilatel_podle_prefixu(char *prefix);
int urci_pocet_kanalu(char *parametry);
char *urci_kanal(char *parametry);

#endif
