/*
 * Soubor:  iri.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkce k vytvoreni a odeslani zprav IRI
 */

#ifndef _IRI_
#define _IRI_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>

#include "zpracovany_packet.h"
#include "sprava.h"
#include "xmpp.h"

#define IRI_REPORT 0
#define IRI_BEGIN 1
#define IRI_CONTINUE 2
#define IRI_END 3

enum TYPY_UDALOSTI
{
	TYP_AUTENTIZACE,
	TYP_PRIHLASEN,
	TYP_PRIJATA_ZPRAVA,
	TYP_ODESLANA_ZPRAVA,
	TYP_PRIJATO_OZNAMENI,
	TYP_ODESLANO_OZNAMENI,
	TYP_ODHLASEN,
	TYP_ONLINE,
	TYP_AWAY,
	TYP_CHAT,
	TYP_DND,
	TYP_NA,
	TYP_OCCUPIED,
	TYP_INVISIBLE,
	TYP_AVAILABLE,
	TYP_BRB,
	TYP_BUSY,
	TYP_NOTATHOME,
	TYP_NOTATDESK,
	TYP_NOTINOFFICE,
	TYP_ONPHONE,
	TYP_ONVACATION,
	TYP_OUTTOLUNCH,
	TYP_STEPPEDOUT,
	TYP_CUSTOM,
	TYP_EVIL,
	TYP_DEPRESSION,
	TYP_ATHOME,
	TYP_ATWORK,
	TYP_LUNCH,
	TYP_PRIPOJENI_KE_KANALU,
	TYP_ODPOJEN_OD_KANALU,
	TYP_PRIPOJENI_K_SERVERU,
	TYP_ZAHAJENA_SIFROVANA_KOMUNIKACE,
	TYP_PROBIHAJICI_SIFROVANA_KOMUNIKACE
};

enum USPECH_AKCE
{
	NEZNAMO,
	USPESNE,
	NEUSPESNE
};

// socket kam se zasílají IRI
int socket_iri;

int otevri_spojeni_pro_iri(void);
void uzavri_spojeni_pro_iri(void);

char *vytvor_iri(int typ_iri, int protokol, struct sezeni *Sezeni, int typ_udalosti, int uspech_udalosti, struct timeval *cas, char *kanal, char *odesilatel, char *prijemce, char *service);
void odesli_iri(char *iri);

#endif
