/*
 * Soubor:  my_string.c
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   soubor obsahujici funkce pro praci s retezci, ktere aplikace potrebuje
 */

#include "my_string.h"

/*
 * zdrojovy retezec je nakopirovan do ciloveho
 */
void kopie_retezce(char *zdroj, char **cil, int length)
{
	*cil = NULL;
	// alokace mista pro ulozeni retezce
	*cil = (char *) malloc(sizeof(char) * (length+1));

	// kopie
	for(int i = 0 ; i < length ; i++)
	{
		(*cil)[i] = zdroj[i];
	}

	// ukoncujici znak
	(*cil)[length] = '\0';
}

/*
 * spoji dva retezce a vrati ukazatel na vysledny.
 * puvodni retezce jsou uvolneny
 */
char *spoj_retezce(char **prvni, int delka_prvniho, char **druhy, int delka_druheho)
{
	char *pomocny;

	// alokace mista pro ulozeni retezce
	pomocny = (char *) malloc(sizeof(char) * (delka_prvniho+delka_druheho+1));

	// kopie prvniho
	for(int i = 0; i < delka_prvniho ; i++)
	{
		pomocny[i] = (*prvni)[i];
	}

	int j = 0;
	// pripojeni druheho
	for(int i = delka_prvniho ; i < (delka_prvniho+delka_druheho) ; i++)
	{
		pomocny[i] = (*druhy)[j++];
	}

	// ukoncujici znak
	pomocny[delka_prvniho+delka_druheho] = '\0';

	// uvolneni puvodnich retezcu
	free(*prvni);
	*prvni = NULL;
	free(*druhy);
	*druhy = NULL;

	return pomocny;
}

/*
 * vrati delku retezce
 */
int delka_retezce(char *str)
{
	int i = 0;
	while(str[i] != '\0')
	{
		i++;
	}

	return i;
}

/*
 * porovna retezce a vrati 1 pokud jsou stejne jinak 0
 */
int porovnani_retezce(char *prvni, char *druhy)
{
	if(prvni == NULL || druhy == NULL)
	{
		return 0;
	}

	if(strcmp(prvni, druhy))
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

