/*
 * Soubor:  zpracovany_packet.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor obsahujici strukturu zachyceneho paketu a definice potrebnych konstant
 */

#ifndef _ZPRACOVANY_PACKET_
#define _ZPRACOVANY_PACKET_

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>

#define NEURCENO 0
#define XMPP_odchozi 1
#define XMPP_prichozi 2
#define IRC_odchozi 3
#define IRC_prichozi 4
#define OSCAR_odchozi 5
#define OSCAR_prichozi 6
#define YMSG_odchozi 7
#define YMSG_prichozi 8

#define odchozi 0
#define prichozi 1

#define IPverze4 4
#define IPverze6 6

// typy podle kterych se urci typ ukazatele na strukturu protokolu
enum TYP
{
	XMPP,
	IRC,
	OSCAR,
	YMSG,
	NEZNAME
};

// typ transportniho protokolu
enum TRANSPORTNI
{
	NEUVEDENO,
	TCP,
	UDP
};

//stav TCP spojeni z pohledu uzitecnoti pro aplikaci
enum TCP_STAV
{
	ZPRACOVAT,
	NEZPRACOVAVAT,
	UKONCENO
};

// struktura obsahuje informace o zachycene komunikaci a vlastni data v podobe
// ukazatele na u_char ktery je potreba pretypovat podle potreby
struct data_packetu
{
	int velikost_dat;
	int typ;
	int smer;
	int transportni_protokol;
	int stav_tcp;
	int verze_ip;
	struct in_addr ipv4_zdroje;
	struct in_addr ipv4_cile;
	struct in6_addr ipv6_zdroje;
	struct in6_addr ipv6_cile;
	int port_zdroje;
	int port_cile;
	struct timeval cas_zachyceni;
	char *data;
};

void inicializace_struktury_dat_packetu(struct data_packetu *data);

#endif

