/*
 * iricore_socket.cpp
 *
 *  Created on: 7.8.2012
 *      Author: Petr Kramolis
 */
// This program is free software; you can redistribute it and/or
// modify it under the terms of the BUT OPEN SOURCE LICENCE
// Version 1 as published by the Brno University of Technology, Antonínská 548/1,
// 601 90, Czech Republic.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// BUT OPEN SOURCE LICENCE (BUTOSL) for more details.
// 
// You should have received a copy of the BUT OPEN SOURCE LICENCE (BUTOSL)
// along with this program; if not, write to the Brno University of Technology,
// Antonínská 548/1, 601 90, Czech Republic.


#include "iricore_socket.h"
#include "lease_table.h"

int unix_socket::send_report(Lease_table_item &item ,time_t timestamp, std::string report_type, std::string description){
	std::ostringstream time;
	std::string buffer;
	int i =0;

	time << timestamp;

	//|modul id | ts | iri-type | [mac, ...] |
	buffer = "('"+_module_name+"','"+ time.str() +"','"+ report_type +"','"+ description +
			"',["+ item.ident_line() +"])\n";
	if(_connect){
		while (send(_s, buffer.c_str() , strlen(buffer.c_str()) , 0) == -1) {
                        connectSocket();
			i++;
			if(i >=5){
				sleep(1);
				break;
			}
		}
	}else{
		std::cout << _module_name << " send: " << buffer << std::endl;
	}
	return 0;
}

