// Copyright (C) FIT VUT
// Petr Lampa <lampa@fit.vutbr.cz>
// $Id$
// vi:set ts=8 sts=8 sw=8:

#ifndef __NDWATCH_COMMON_H__
#define __NDWATCH_COMMON_H__

//
// common includes and definitions
//
#include <string>
#include <iostream>
#include <climits>
using namespace std;

// RFC2460 5.
#define IPV6_MIN_MTU 1280
// selected protocol numbers
enum IPProto { ProtoIPv4=0, ProtoICMP=1, ProtoIGMP=2, ProtoTCP=6, ProtoUDP=17,
	ProtoIPv6=41, ProtoRSVP=42, ProtoGRE=47, ProtoICMPv6=58,
	ProtoPIM=103, ProtoVRRP=112, ProtoL2TP=115, ProtoSCTP=132, 
	ProtoFC=133};

typedef unsigned char Octet;
typedef unsigned short Short;
#if (UINT_MAX <	4294967295L)
typedef unsigned long Word;
#else 
typedef unsigned Word;
#endif

#include "packet.h"

extern int debug;
extern char int_cvt_buf[32];
extern const char *xdigits;

inline const char *cvt_int(Word val)
{
	char *p = int_cvt_buf+31; 
	do { *(--p) = xdigits[val%10]; val /= 10; 
	} while (val); 
	return p;
}

inline const char *cvt_hex(Word val, bool nopref=false)
{
	char *p = int_cvt_buf+31;
	do { *(--p) = xdigits[val & 0xf]; val >>= 4;
	} while (val);
	if (!nopref) {
		*(--p) = 'x';
		*(--p) = '0';
	}
	return p;
}

extern int debug;

#endif
