from threading import Lock
import inspect
import csv

from pyretic.lib.corelib import *
from pyretic.lib.std import *
from pyretic.lib.query import *
from pyretic.examples.routing import *
from pyretic.examples.statistics import *
from pyretic.examples.firewall_resource import *
from pyretic.examples.firewall_groups import *
from pyretic.examples.identitymanagement import *
from pyretic.examples.shared import *
from pyretic.core.runtime import virtual_field

def main():
    # firewall-resources, firewall-groups, routing, statistics, all
    usecase = "all"
    if usecase == "firewall-resources":
        r = routing()
        f = firewall_resource()
        handlers = [f,r]
        identityDetection = identitymanagement(handlers)
        return identityDetection >> f >> r
    elif usecase == "firewall-groups":
        r = routing()
        f = firewall_groups()
        handlers = [f,r]
        identityDetection = identitymanagement(handlers)
        return identityDetection >> r >> f
    elif usecase == "routing":
        r = routing()
        handlers = [r]
        identityDetection = identitymanagement(handlers)
        return identityDetection >> r 
    elif usecase == "statistics":
        s = statistics()
        r = routing()
        handlers = [r, s]
        identityDetection = identitymanagement(handlers)
        return identityDetection >> r >> s
    elif usecase == "all":
        s = statistics()
        r = routing()
        f1 = firewall_resource()
        f2 = firewall_groups()
        handlers = [f1,f2,r,s]
        identityDetection = identitymanagement(handlers)
        return identityDetection >> f1 >> r >> f2 >> s
    

