# -*- coding: utf-8 -*-
# Base class of CC table used in CCTF and CC-IIF
#
# Copyright (C) 2011 Michal Kajan, Libor Polčák, Petr Kramoliš
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

class CCTableBase(object):

    def __init__(self, content):
        """ Constructor

        content
          Iterable of two-tuples (sid, nid) to be initially added to the table
        """
        if self.__class__ is CCTableBase:
            raise NotImplementedError("Abstract class cannot be created")

    def getContent(self):
        """ Returns table content
        
        The content is returned as a list of 2-tuples (sid, nid). It is possible
        to use this list to construct a new CC Table.
        """
        raise NotImplementedError("%s does not override all CCTableBase methods" %
                str(self.__class__))
        return []

    def add(self, sid, nid):
        """ Adds new sid:nid pair to the table

        Returns True if the addition was successful
        """
        raise NotImplementedError("%s does not override all CCTableBase methods" %
                str(self.__class__))
        return False

    def findSID(self, nid):
        """ Returns sid for given nid or None if not found """
        raise NotImplementedError("%s does not override all CCTableBase methods" %
                str(self.__class__))
        return None

    def findNID(self, sid):
        """ Returns nid for given sid or None if not found """
        raise NotImplementedError("%s does not override all CCTableBase methods" %
                str(self.__class__))
        return None

    def remove(self, sid):
        """ Removes sid from the table """
        raise NotImplementedError("%s does not override all CCTableBase methods" %
                str(self.__class__))

    def __repr__(self):
        return "CCTableBase([])"
