#ifndef CORE8X8_H
#define CORE8X8_H

#include "imageptr.h"
#include "vec2.h"

/**
 * @brief Load (directly), transform, and store 8&times;8 fragment of data.
 */
void load_core_save_8x8_fast(
	float *buffer_x,
	float *buffer_y,
	const struct imageptr_t *input,
	struct imageptr_t *llband,
	struct imageptr_t *hlband,
	struct imageptr_t *lhband,
	struct imageptr_t *hhband
);

/**
 * @brief Load (with PSE), transform, and store 8&times;8 fragment of data.
 *
 * @note PSE ... periodic symmetric extension
 */
void load_core_save_8x8_slow(
	float *buffer_x,
	float *buffer_y,
	const struct imageptr_t *input,
	const struct vec2_t local,
	const struct vec2_t size,
	struct imageptr_t *llband,
	struct imageptr_t *hlband,
	struct imageptr_t *lhband,
	struct imageptr_t *hhband
);

/**
 * @brief Load (directly), and transform (horizontal pass only) 8&times;8 fragment of data.
 */
void load_core_8x8_honly_fast(
	float *buffer_y,
	const struct imageptr_t *input
);

/**
 * @brief Load (with PSE), and transform (horizontal pass only) 8&times;8 fragment of data.
 */
void load_core_8x8_honly_slow(
	float *buffer_y,
	const struct imageptr_t *input,
	const struct vec2_t local,
	const struct vec2_t size
);

/**
 * @brief Copy 8&times;8 code-block fragment from four subbands into a single frame.
 */
void save_8x8_debug(
	struct imageptr_t *llband,
	struct imageptr_t *hlband,
	struct imageptr_t *lhband,
	struct imageptr_t *hhband,
	struct imageptr_t *debug,
	const struct vec2_t local
);

#endif
