#ifndef TIMER_H
#define TIMER_H

#include <stdint.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include "system.h"

UNUSED_FUNCTION
static
int64_t timer_get_frequency()
{
	return 1000000000;
}

UNUSED_FUNCTION
static
int64_t timer_get_clock()
{
	struct timespec ts;

	if( clock_gettime(CLOCK_REALTIME, &ts) )
		abort();

	return (int64_t)ts.tv_sec * 1000000000 + ts.tv_nsec;
}

UNUSED_FUNCTION
static
double timer_clock_to_nsec_pel(int64_t clock, long pixels)
{
	return (double)clock / timer_get_frequency() * 1e9 / pixels;
}

UNUSED_FUNCTION
static
double timer_clock_to_msec(int64_t clock)
{
	return (double)clock / timer_get_frequency() * 1e3;
}

#endif
