#include "KeyFrames.h"


namespace vmatch {


const std::string KeyFrames::NODE_TYPE = "type";
const std::string KeyFrames::NODE_DATA = "data";

const std::string KeyFrame::NODE_KEYFRAME = "keyframe";
const std::string KeyFrame::NODE_FRAME_NUMBER = "number";
const std::string KeyFrame::NODE_SEGMENT_ID = "segment";
const std::string KeyFrame::NODE_DESCRIPTOR = "descriptor";


KeyFrame::KeyFrame() {
	this->descriptor = NULL;
	this->frameNumber = 0;
	this->segmentId = UNKNOWN;
}


KeyFrame::KeyFrame(FrameDescriptorPtr descriptor, int frameNumber, int segmentId) {
	this->descriptor = descriptor;
	this->frameNumber = frameNumber;
	this->segmentId = segmentId;
}


int KeyFrame::getFrameNumber() const {
	CV_Assert(frameNumber != UNKNOWN);
	return frameNumber;
}


int KeyFrame::getSegmentId() const {
	return segmentId;
}


void KeyFrame::read(cv::FileNode & nd, FrameDescriptorExtractorPtr extractor) {
	cv::FileNode ndKeyFrame = nd[NODE_KEYFRAME];
	// TODO kontrola

	cv::FileNode ndFrameNumber = ndKeyFrame[NODE_FRAME_NUMBER];
	cv::FileNode ndSegmentId = ndKeyFrame[NODE_SEGMENT_ID];
	cv::FileNode ndDescriptor = ndKeyFrame[NODE_DESCRIPTOR];
	// TODO kontrola

	ndFrameNumber >> frameNumber;
	ndSegmentId >> segmentId;

	descriptor = extractor->createEmptyDescriptor();
	descriptor->read(ndDescriptor);
}


void KeyFrame::write(cv::FileStorage & fs) const {
	fs << NODE_KEYFRAME << "{";
		fs << NODE_FRAME_NUMBER << frameNumber;
		fs << NODE_SEGMENT_ID << segmentId;
		
		fs << NODE_DESCRIPTOR << "{";
		descriptor->write(fs);
		fs << "}";
	fs << "}";
}


FrameDescriptorPtr KeyFrame::getFrameDescriptor() const {
	CV_Assert(descriptor != NULL);
	return descriptor;
}


KeyFrames::KeyFrames() : KeyFramePtrVector() {
	this->descriptorType = FrameDescriptor::UNKNOWN;
}


KeyFrames::KeyFrames(int descriptorType) : KeyFramePtrVector() {
	this->descriptorType = descriptorType;
}


int KeyFrames::getDescriptorType() const {
	return descriptorType;
}


void KeyFrames::read(cv::FileNode & nd) {
	cv::FileNode ndDescriptorType = nd[NODE_TYPE];
	cv::FileNode ndData = nd[NODE_DATA];
	// TODO kontrola

	ndDescriptorType >> descriptorType;
	FrameDescriptorExtractorPtr descriptorExtractor = FrameDescriptorExtractorFactory::create(descriptorType);
	
	clear();
	for(cv::FileNodeIterator it = ndData.begin(); it != ndData.end(); it++) {
		KeyFramePtr kf = new KeyFrame();
		cv::FileNode ndCurrent = *it;
		kf->read(ndCurrent, descriptorExtractor);
		push_back(kf);
	}
}


void KeyFrames::write(cv::FileStorage & fs) const {
	fs << NODE_TYPE << descriptorType;
	
	fs << NODE_DATA << "[";
	for(const_iterator it = this->begin(); it != this->end(); it++) {
		fs << "{";
		(*it)->write(fs);
		fs << "}";
	}
	fs << "]";
}


}