#ifndef _KEYFRAMES_H
#define _KEYFRAMES_H


#include <vector>
#include "FrameDescriptorExtractor.h"


namespace vmatch {


class KeyFrame {
protected:
	static const std::string NODE_KEYFRAME;
	static const std::string NODE_FRAME_NUMBER;
	static const std::string NODE_SEGMENT_ID;
	static const std::string NODE_DESCRIPTOR;

public:
	static const int UNKNOWN = -1;

protected:
	int frameNumber;
	int segmentId;
	FrameDescriptorPtr descriptor;
	
	KeyFrame();

public:
	KeyFrame(FrameDescriptorPtr descriptor, int frameNumber, int segmentId = UNKNOWN);
	int getFrameNumber() const;
	int getSegmentId() const;
	FrameDescriptorPtr getFrameDescriptor() const;
	void read(cv::FileNode & nd, FrameDescriptorExtractorPtr extractor);
	void write(cv::FileStorage & fs) const;

friend class KeyFrames;
};


typedef cv::Ptr<KeyFrame> KeyFramePtr;
typedef std::vector<KeyFramePtr> KeyFramePtrVector;


class KeyFrames : public KeyFramePtrVector {
protected:
	static const std::string NODE_TYPE;
	static const std::string NODE_DATA;

	int descriptorType;

public:
	KeyFrames();
	KeyFrames(int descriptorType);
	int getDescriptorType() const;
	void read(cv::FileNode & nd);
	void write(cv::FileStorage & fs) const;
};


typedef cv::Ptr<KeyFrames> KeyFramesPtr;


}


#endif
