#ifndef _KEYFRAMESEXTRACTOR_H
#define _KEYFRAMESEXTRACTOR_H


#include <map>
#include "KeyFrames.h"
#include "VideoSequence.h"


namespace vmatch {


class KeyFramesExtractor {
public:
	virtual KeyFrames extract(VideoSequencePtr sequence) = 0;
};


typedef cv::Ptr<KeyFramesExtractor> KeyFramesExtractorPtr;


class LinearKeyFramesExtractor : public KeyFramesExtractor {
protected:
	int step;

public:
	LinearKeyFramesExtractor(int step = 1);
	virtual KeyFrames extract(VideoSequencePtr sequence);
	void setStep(int step);
};


class ThresholdKeyFramesExtractor : public KeyFramesExtractor {
protected:
	FrameDescriptorExtractorPtr extractor;
	double threshold;

public:
	ThresholdKeyFramesExtractor(FrameDescriptorExtractorPtr extractor, double threshold);
	virtual KeyFrames extract(VideoSequencePtr sequence);
	void setExtractor(FrameDescriptorExtractorPtr extractor);
	void setThreshold(double threshold);
};


class CascadeKeyFramesExtractor : public KeyFramesExtractor {
protected:
	FrameDescriptorExtractorPtr firstExtractor;
	double thrSimilar;
	double thrDifferent;
	double thrAccept;
	int maxStep;

public:
	CascadeKeyFramesExtractor(FrameDescriptorExtractorPtr firstExtractor, double thrSimilar, double thrDifferent, double thrAccept, int maxStep);
	virtual KeyFrames extract(VideoSequencePtr sequence);
	void setFirstExtractor(FrameDescriptorExtractorPtr firstExtractor);
	void setThresholdSimilar(double thrSimilar);
	void setThresholdDifferenr(double thrDifferent);
	void setThresholdAccept(double thrAccept);
	void setMaxStep(int maxStep);
};


class PresetKeyFramesExtractor : public KeyFramesExtractor {
public:
	typedef std::vector<int> FrameNumbers;

protected:
	FrameNumbers frameNumbers;

public:
	PresetKeyFramesExtractor(FrameNumbers frameNumbers);
	virtual KeyFrames extract(VideoSequencePtr sequence);
	void setFrameNumbers(FrameNumbers frameNumbers);
};


}


#endif
