#ifndef _SEGMENTSCONVERTOR_H
#define _SEGMENTSCONVERTOR_H


#include <vector>
#include "Segments.h"
#include "KeySegments.h"


namespace vmatch {


class FullSegmentsConvertor {
public:
	class FullSegment : public Segment {
	protected:
		bool similar;

	public:
		FullSegment(const Segment & segment);
		FullSegment(int startRef, int endRef, int startQuery, int endQuery, bool similar);
		bool isSimilar() const;
	};

	typedef cv::Ptr<FullSegment> FullSegmentPtr;

	class FullSegments : public std::vector<FullSegmentPtr> {
	public:
		FullSegments();
	};

	typedef cv::Ptr<FullSegments> FullSegmentsPtr;

public:
	FullSegments convert(const Segments & segments);
};


}


#endif
