/*
								+--------------------------------+
								|								 |
								|	  ***	OpenGL 4.0	 ***	 |
								|								 |
								|  Copyright  -tHE SWINe- 2011	 |
								|								 |
								|			OpenGL40.h			 |
								|								 |
								+--------------------------------+
*/

#pragma once
#ifndef __OPENGL40_TOOL_INCLUDED
#define __OPENGL40_TOOL_INCLUDED

/**
 *	@file gl4/OpenGL40.h
 *	@author -tHE SWINe-
 *	@date 2011
 *	@brief OpenGL 4.0 and extensions entry points
 *
 *	This header contains entry points of relevant OpenGL 4 functions / extensions.
 *		It was prepared from gl3.h, available from &lt;http://www.opengl.org&gt;,
 *		from extension registry at &lt;http://www.opengl.org&gt; and from OpenGL function
 *		documentation pages at &lt;http://www.opengl.org/sdk/docs/man4/xhtml/&gt;.
 *
 *	The difference between OpenGL30.h and OpenGL40.h is OpenGL40.h also includes
 *		OpenCL headers to support OpenCL interop (GL_ARB_cl_event).
 *
 *	@date 2009-11-28
 *
 *	core functionality / core extensions:<br>
 *		OpenGL 1.0<br>
 *		OpenGL 1.1<br>
 *		OpenGL 1.2<br>
 *		OpenGL 1.3<br>
 *		OpenGL 1.4<br>
 *		OpenGL 1.5<br>
 *		OpenGL 2.0<br>
 *		OpenGL 2.1<br>
 *		OpenGL 3.0
 *			- GL_ARB_depth_buffer_float
 *			- GL_ARB_framebuffer_object
 *			- GL_ARB_framebuffer_sRGB
 *			- GL_ARB_half_float_vertex
 *			- GL_ARB_map_buffer_range
 *			- GL_ARB_texture_compression_rgtc
 *			- GL_ARB_texture_rg
 *			- GL_ARB_vertex_array_object
 *
 *		OpenGL 3.1
 *			- GL_ARB_texture_buffer_object
 *			- GL_ARB_uniform_buffer_object
 *			- GL_ARB_draw_instanced
 *			- GL_ARB_copy_buffer
 *
 *		OpenGL 3.2
 *			- GL_ARB_depth_clamp
 *			- GL_ARB_draw_elements_base_vertex
 *			- GL_ARB_fragment_coord_conventions
 *			- GL_ARB_provoking_vertex
 *			- GL_ARB_seamless_cube_map
 *			- GL_ARB_sync
 *			- GL_ARB_texture_multisample
 *			- GL_ARB_vertex_array_bgra
 *
 *	present extensions:
 *			- GL_EXT_draw_buffers2			(separate blend enables, separate color masks for mutliple draw buffers)
 *			- GL_ARB_draw_buffers_blend		(different blend equations for multiple draw buffers)
 *			- GL_ARB_sample_shading			(enforced shading for multisample antialiassing)
 *			- GL_ARB_texture_cube_map_array (texture array for cube-maps)
 *			- GL_ARB_texture_gather			(new functions for GLSL, returns x components of four sampled texels, lets shader do it's own filtering, instead of bilinear. without GL_EXT_texture_swizzle it's only monochrome though)
 *			- GL_ARB_texture_query_lod		(new functions for GLSL, returns LOD sampler would use for texture (instead of sampled color))
 *			- GL_EXT_timer_query				(new query object target for GPU timing)
 *			- GL_EXT_gpu_program_parameters (single call to fill multiple GPU program parameters; useless because we do not have programs anymore - only shaders)
 *			- GL_EXT_bindable_uniform			(provides bindable buffers to contain uniform variables, so they don't have to be specified)
 *			- GL_ARB_instanced_arrays			(sets divisor to vertex attributes; when set to n = nonzero, a particular attribute advances every n vertices; similar to direct-x function SetStreamFrequency)
 *			- GL_ARB_shader_texture_lod		(additions to GLSL; contains no new tokens for GL)
 *			- GL_ARB_texture_buffer_object	(new texture type, buffer object is now bindable as large 1D texture; it's unclear how exactly is it used)
 *
 *			- GL_S3_s3tc						(pixel formats)
 *			- GL_EXT_texture_compression_latc	(pixel formats)
 *			- GL_EXT_texture_compression_s3tc	(pixel formats)
 *			- GL_EXT_texture_filter_anisotropic (anisotropic texture filter control)
 *			- GL_EXT_abgr						(ABGR pixel format)
 *
 *	new extensions which are not present yet:
 *		-	GL_ARB_compatibility - a big one, fork of OpenGL 3.1
 *
 *	removed:
 *			- GL_ARB_texture_compression - promoted to core in OpenGL 1.3
 *			- GL_ARB_vertex_blend - relies on deprecated parts of fixed-function pipeline
 *			- GL_ARB_matrix_palette - relies on deprecated parts of fixed-function pipeline
 *			- GL_EXT_compiled_vertex_array - is now obsolete, extension wasn't updated for a long time
 *			- GL_EXT_vertex_array - is obsolete, became core and in turn, became deprecated
 *			- GL_ARB_vertex_program, GL_ARB_fragment_program - deprecated; only shading language 1.30 is supported
 *			- GL_ARB_vertex_shader, GL_ARB_fragment_shader, GL_ARB_shader_object - became core in OpenGL 2.0
 *			- GL_ARB_vertex_buffer_object - became core in OpenGL 1.5
 *			- GL_ARB_pixel_buffer_object - became core in OpenGL 2.1
 *			- GL_ARB_occlusion_query - became core in OpenGL 1.5
 *			- GL_ARB_multitexture - became core in OpenGL 1.3; n_GetMultitextureFuncPointers() was merged into n_GetGL13FuncPointers()
 *			- GL_EXT_packed_depth_stencil - part of GL_ARB_framebuffer_object, which is core in OpenGL 3.0
 *			- GL_EXT_framebuffer_object - part of GL_ARB_framebuffer_object, which is core in OpenGL 3.0
 *			- GL_EXT_draw_instanced - became core in OpenGL 3.1
 *
 *	not present:
 *			- GL_ARB_imaging (part of OpenGL 1.2 core) - seems to be deprecated
 *			- GL_ARB_color_buffer_float - superseded by OpenGL 3.0
 *			- GL_NV_fence - superseded by GL_ARB_sync
 *			- GL_EXT_texture_integer - superseded by OpenGL 3.0
 *			- GL_EXT_gpu_shader4 - superseded by OpenGL 3.0, OpenGL 3.1
 *			- GL_EXT_geometry_shader4 - superseded by GL_ARB_framebuffer_object, OpenGL 3.2
 *			- GL_EXT_texture_array - superseded by GL_ARB_framebuffer_object, OpenGL 3.0
 *			- GL_EXT_texture_buffer_object - superseded by OpenGL 3.1
 *			- GL_EXT_blend_minmax - superseded by GL_ARB_imaging, OpenGL 1.2
 *			- GL_EXT_blend_subtract - superseded by GL_ARB_imaging, OpenGL 1.2
 *			- GL_ARB_geometry_shader4 - superseded by GL_ARB_framebuffer_object, OpenGL 3.2
 *			- GL_ARB_draw_instanced - directly part of OpenGL 3.1 core
 *			- GL_ARB_half_float_pixel - superseded by GL_ARB_half_float_vertex, part of OpenGL 3.0 core
 *			- GL_ARB_texture_float - part of OpenGL 3.0 core
 *			- GL_ARB_pixel_buffer_object - part of OpenGL 2.1 core
 *
 *	@date 2010-09-19
 *
 *	added the following extensions:
 *			- GL_ARB_shading_language_include
 *			- GL_ARB_texture_compression_bptc
 *			- GL_ARB_blend_func_extended
 *			- GL_ARB_explicit_attrib_location
 *			- GL_ARB_occlusion_query2
 *			- GL_ARB_sampler_objects
 *			- GL_ARB_shader_bit_encoding
 *			- GL_ARB_texture_rgb10_a2ui
 *			- GL_ARB_texture_swizzle
 *			- GL_ARB_timer_query
 *			- GL_ARB_vertex_type_2_10_10_10_rev
 *			- GL_ARB_draw_indirect
 *			- GL_ARB_gpu_shader5
 *			- GL_ARB_gpu_shader_fp64
 *			- GL_ARB_shader_subroutine
 *			- GL_ARB_tessellation_shader
 *			- GL_ARB_texture_buffer_object_rgb32
 *			- GL_ARB_transform_feedback2
 *			- GL_ARB_transform_feedback3
 *			- GL_ARB_es2_compatibility
 *			- GL_ARB_get_program_binary
 *			- GL_ARB_separate_shader_objects
 *			- GL_ARB_shader_precision
 *			- GL_ARB_vertex_attrib64bit
 *			- GL_ARB_viewport_array
 *			- GL_ARB_cl_event
 *			- GL_ARB_debug_output
 *			- GL_ARB_robustness
 *			- GL_ARB_shader_stencil_export
 *
 *	@date 2010-10-29
 *
 *	Unified windows detection macro to "\#if defined(_WIN32) || defined(_WIN64)".
 *
 *	@date 2011-07-15
 *
 *	Removed glFramebufferTextureFace(), which was a bug in the documentation. OpenGL 3.2 support
 *	is now reported complete (CGL3ExtensionHandler::n_GetGL32FuncPointers() returns 0,
 *	and not 1 as it did).
 *
 *	Re-organized core functionality (the extensions were all present already):
 *
 *		OpenGL 3.3:
 *			- GL_ARB_shader_bit_encoding
 *			- GL_ARB_blend_func_extended
 *			- GL_ARB_explicit_attrib_location
 *			- GL_ARB_occlusion_query2
 *			- GL_ARB_sampler_objects
 *			- GL_ARB_texture_rgb10_a2ui
 *			- GL_ARB_texture_swizzle
 *			- GL_ARB_timer_query
 *			- GL_ARB_instanced_arrays
 *			- GL_ARB_vertex_type_2_10_10_10_rev
 *
 *		OpenGL 4.0:
 *			- GL_ARB_texture_query_lod
 *			- GL_ARB_draw_indirect
 *			- GL_ARB_gpu_shader5
 *			- GL_ARB_gpu_shader_fp64
 *			- GL_ARB_shader_subroutine
 *			- GL_ARB_tessellation_shader
 *			- GL_ARB_texture_buffer_object_rgb32
 *			- GL_ARB_texture_cube_map_array
 *			- GL_ARB_texture_gather
 *			- GL_ARB_transform_feedback2
 *			- GL_ARB_transform_feedback3
 *
 *		OpenGL 4.1:
 *			- GL_ARB_ES2_compatibility
 *			- GL_ARB_get_program_binary
 *			- GL_ARB_separate_shader_objects
 *			- GL_ARB_shader_precision
 *			- GL_ARB_vertex_attrib_64bit
 *			- GL_ARB_viewport_array
 *
 *	Updated the license information.
 *
 *	@date 2011-07-20
 *
 *	Improved autocheck for statically-linked void functions so if using the user breakpoint,
 *	the code displayed in MSVC is user code (the call that caused the error) and not
 *	OpenGL40.h. This only increases user comfort, the functionality didn't change.
 *
 *	Optimized the code to reduce compilation time.
 *
 *	@date 2011-07-29
 *
 *	Added the "__" prefix to all the switches \#defined or used here.
 *
 *	Added documentation comments to extension guard \#defines and extension __GENERATE_* \#defines.
 *
 *	Added documentation comments to OpenGL enums.
 *
 *	Renamed CGL4ExtensionHandler::b_SupportedWGLExtension() to
 *	CGL4ExtensionHandler::b_SupportedPlatformExtension(). It is now compiled
 *	for both linux and windows.
 *
 *	Removed deprecated tokens.
 *
 *	@date 2011-08-09
 *
 *	Added support for OpenGL 4.2, removed two deprecated tokens.
 *
 *		OpenGL 4.2:
 *			- GL_ARB_texture_compression_bptc
 *			- GL_ARB_compressed_texture_pixel_storage
 *			- GL_ARB_shader_atomic_counters
 *			- GL_ARB_texture_storage
 *			- GL_ARB_transform_feedback_instanced
 *			- GL_ARB_base_instance
 *			- GL_ARB_shader_image_load_store
 *			- GL_ARB_conservative_depth
 *			- GL_ARB_shading_language_420pack
 *			- GL_ARB_internalformat_query
 *			- GL_ARB_map_buffer_alignment
 *			- GL_ARB_shading_language_packing
 *
 *		deprecated:
 *			- GL_NUM_COMPRESSED_TEXTURE_FORMATS
 *			- GL_COMPRESSED_TEXTURE_FORMATS
 *
 *	Also removed some deprecated functions from GL_ARB_robustness.
 *
 *	Added the GL_EXT_direct_state_access extension.
 *
 *	2011-08-15
 *
 *	Added the n_GL_TypeSize() macro, which can be used to determine
 *	OpenGL (internal) datatype size.
 *
 *	Removed some extension features based on the OpenGL deprecation model
 *	(mostly legacy texture formats).
 *
 *	@date 2012-06-19
 *
 *	Added \#pragma once.
 *
 *	@date 2014-05-06
 *
 *	Renamed GL_COPY_READ_BUFFER_BINDING to GL_COPY_READ_BUFFER and
 *	GL_COPY_WRITE_BUFFER_BINDING to GL_COPY_WRITE_BUFFER.
 *
 *	GL_TRANSFORM_FEEDBACK_ACTIVE and GL_TRANSFORM_FEEDBACK_PAUSED
 *	were already renamed to GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE and
 *	GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, respectively.
 *
 *	Added support for OpenGL 4.3, specifically added:
 *		- GL_ARB_arrays_of_arrays (OpenGL Shading Language only)
 *		- GL_ARB_ES3_compatibility
 *		- GL_ARB_clear_buffer_object
 *		- GL_ARB_compute_shader
 *		- GL_ARB_copy_image
 *		- GL_ARB_debug_group
 *		- GL_ARB_debug_label
 *		- GL_ARB_debug_output2
 *		- GL_ARB_debug_output
 *		- GL_ARB_explicit_uniform_location
 *		- GL_ARB_fragment_layer_viewport (OpenGL Shading Language only)
 *		- GL_ARB_framebuffer_no_attachments
 *		- GL_ARB_internalformat_query2
 *		- GL_ARB_invalidate_subdata
 *		- GL_ARB_multi_draw_indirect
 *		- GL_ARB_program_interface_query
 *		- GL_ARB_robust_buffer_access_behavior
 *		- GL_ARB_shader_image_size (OpenGL Shading Language only)
 *		- GL_ARB_shader_storage_buffer_object
 *		- GL_ARB_stencil_texturing
 *		- GL_ARB_texture_buffer_range
 *		- GL_ARB_texture_query_levels
 *		- GL_ARB_texture_storage_multisample
 *		- GL_ARB_texture_view
 *		- GL_ARB_vertex_attrib_binding
 *		- GL_KHR_texture_compression_astc_ldr
 *		- GL_KHR_texture_compression_astc_hdr
 *		- GL_ARB_robustness_isolation
 *
 *	Changed features with respect to the deprecation model:
 *		- added GL_VERTEX_ATTRIB_ARRAY_LONG query token
 *		- removed deprecated GL_UNPACK_LSB_FIRST and GL_PACK_LSB_FIRST 
 *		- GetPointerv() was previously deprecated and now it was added again
 *		- added previously deprecated GL_STACK_OVERFLOW and GL_STACK_UNDERFLOW
 *		- GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS was renamed to
 *		  GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES
 *
 *	Added support for OpenGL 4.4, specifically added:
 *		- GL_ARB_buffer_storage
 *		- GL_ARB_clear_texture
 *		- GL_ARB_enhanced_layouts
 *		- GL_ARB_multi_bind
 *		- GL_ARB_query_buffer_object
 *		- GL_ARB_texture_mirror_clamp_to_edge
 *		- GL_ARB_texture_stencil8
 *		- GL_ARB_vertex_type_10f_11f_11f_rev
 *		- added the GL_MAX_VERTEX_ATTRIB_STRIDE token
 *
 *	Added the following non-core extensions:
 *		- GL_ARB_bindless_texture
 *		- GL_ARB_sparse_texture
 *		- GL_ARB_compute_variable_group_size
 *		- GL_ARB_indirect_parameters
 *		- GL_ARB_seamless_cubemap_per_texture
 *		- GL_ARB_shader_draw_parameters
 *		- GL_ARB_shader_group_vote
 *
 *	@date 2015-03-04
 *
 *	Added support for OpenGL 4.5, specifically added:
 *		- GL_ARB_clip_control
 *		- GL_ARB_cull_distance
 *		- GL_ARB_ES3_1_compatibility
 *		- GL_ARB_conditional_render_inverted
 *		- GL_KHR_context_flush_control
 *		- GL_ARB_derivative_control
 *		- GL_ARB_direct_state_access
 *		- GL_ARB_get_texture_sub_image
 *		- GL_KHR_robustness
 *		- GL_ARB_shader_texture_image_samples
 *		- GL_ARB_texture_barrier
 *
 *	Added the following non-core extensions:
 *		- GL_NV_command_list
 *
 *	Removed GL_EXT_direct_state_access and functions from the interacting extensions.
 *
 */

// license from gl3.h
/*
** Copyright (c) 2007-2011 The Khronos Group Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and/or associated documentation files (the
** "Materials"), to deal in the Materials without restriction, including
** without limitation the rights to use, copy, modify, merge, publish,
** distribute, sublicense, and/or sell copies of the Materials, and to
** permit persons to whom the Materials are furnished to do so, subject to
** the following conditions:
**
** The above copyright notice and this permission notice shall be included
** in all copies or substantial portions of the Materials.
**
** THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
** MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
*/

// license for materials from http://www.opengl.org/sdk/docs/man/xhtml/
/*
** SGI FREE SOFTWARE LICENSE B (Version 2.0, Sept. 18, 2008)
** Copyright (C) 1991-2006 Silicon Graphics, Inc. All Rights Reserved.
** Permission is hereby granted, free of charge, to any person obtaining
** a copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the Software
** is furnished to do so, subject to the following conditions:
**
** The above copyright notice including the dates of first publication and
** either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
** shall be included in all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
** OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
** SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
** WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
** OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
** IN THE SOFTWARE.
**
** Except as contained in this notice, the name of Silicon Graphics, Inc. shall
** not be used in advertising or otherwise to promote the sale, use or other
** dealings in this Software without prior written authorization from
** Silicon Graphics, Inc.
*/

#include <string>
#include <stdio.h>
#include <stdlib.h> // exit()
#include "../Integer.h"
#include "../StlUtils.h"
#if defined(_WIN32) || defined(_WIN64)
#define WIN32_LEAND_AND_MEAN 1
#include <windows.h> // need APIENTRY
#endif // _WIN32 || _WIN64

/*
 *	makes life a little bit easier when including gl.h by mistake
 *
 *	does not include gl.h, defines GL up to 1.1 below, want to prevent gl.h
 *	header inclusion
 */
#if defined(__gl_h_) || defined(__GL_H__) || defined(GL_VERSION_1_1)
#error("gl.h must NOT be included in files using OpenGL40.h")
#endif // __gl_h_ || __GL_H__ || GL_VERSION_1_1

/*
 *	makes life a little bit easier when including glext.h by mistake
 *
 *	glext.h is not included anymore, it does contain significant amount of
 *	deprecated functionality, want to prevent glext.h header inclusion
 */
#if defined(__glext_h_) || defined(GL_GLEXT_VERSION)
#error("glext.h must NOT be included in files using OpenGL40.h")
#endif // __glext_h_ || GL_GLEXT_VERSION

/**
 *	@def __gl_h_
 *	@brief avoids inclusion of gl.h
 */
#define __gl_h_

/**
 *	@def __GL_H__
 *	@brief avoids inclusion of gl.h
 */
#define __GL_H__

/**
 *	@def __glext_h_
 *	@brief avoids inclusion of glext.h
 */
#define __glext_h_

/**
 *	@def __GLEXT_H__
 *	@brief avoids inclusion of glext.h
 */
#define __GLEXT_H__

/**
 *	@def __GL_NULL_FUNCTION_POINTERS
 *	@brief if defined, initializes entry function pointers to null
 *
 *	In case __GL_NULL_FUNCTION_POINTERS is defined (default), all extension function pointers
 *		are initialized to 0, but user never needs to compare individual function values
 *		so it's posible to save some space in executable file by skipping the initialization.
 */
#define __GL_NULL_FUNCTION_POINTERS

/**
 *	@def __GL_FIX_FUNCTION_LINKING_CONFLICTS
 *	@brief avoids function linking conflicts by renaming function pointers, and fixing
 *		names using \#define
 *
 *	Some compilers may contain newer OpenGL libraries than this header requires
 *		(OpenGL 1.1, as supported by Microsoft Visual studio family), so names of function
 *		pointers, such as <tt>glBlendColor</tt> are present in static library, as well as in this
 *		file, causing link-time error. This is fixed by renaming the function, here
 *		<tt>glBlendColor_ptr</tt> would be used, and fixing it by macro, such as <tt>\#define
 *		glBlendColor_ptr glBlendColor</tt>.
 *
 *	@note This must not be changed for files generated with the EXPAND_GLFuncPtrName_MACRO option.
 */
#define __GL_FIX_FUNCTION_LINKING_CONFLICTS

/**
 *	@def __GL_AUTOCHECK
 *	@brief automatically checks for OpenGL errors after every OpenGL function except glGetError()
 *	@note This is only available in debug mode unless __GL_FORCE_AUTOCHECK is defined.
 */
#define __GL_AUTOCHECK

/**
 *	@def __GL_AUTOCHECK_USE_EXCEPTION
 *	@brief if defined, autocheck throws std::runtime_exception if an OpenGL error occurs
 */
//#define __GL_AUTOCHECK_USE_EXCEPTION

/**
 *	@def __GL_AUTOCHECK_USE_BREAKPOINT
 *	@brief if defined, autocheck calls user breakpoint if an OpenGL error occurs
 *	@note This is only available in windows / MSVC and in x86 mode (not x64).
 */
#define __GL_AUTOCHECK_USE_BREAKPOINT

/**
 *	@def __GL_AUTOCHECK_USE_ABORT
 *	@brief if defined, autocheck calls clib's abort() if an OpenGL error occurs
 */
//#define __GL_AUTOCHECK_USE_ABORT

/**
 *	@def __GL_AUTOCHECK_USE_EXIT
 *	@brief if defined, autocheck prints the error to stderr and calls
 *		exit(-1) if an OpenGL error occurs
 *	@note This is default behavior if nothing else is defined.
 */
//#define __GL_AUTOCHECK_USE_EXIT

/**
 *	@brief class for handling OpenGL extensions
 *
 *	Supplies means to get OpenGL function entry point, check extension support, or get
 *	OpenGL version. Functions with name n_Get*FuncPointers() returns number of function
 *	pointers that were not found (zero is success).
 */
class CGL4ExtensionHandler {
public:
	/**
	 *	@brief compares OpenGL version to reference
	 *
	 *	Compares supplied version to current OpenGL implementation version and returns
	 *		true if current version is greater or equal (supplied version is supported).
	 *
	 *	@param[in] n_min_major is reference minimal major version number
	 *	@param[in] n_min_minor is reference minimal minor version number
	 *
	 *	@return Returns true in case OpenGL version is greater or equal to n_min_major.n_min_minor.
	 */
	static bool b_Support_OpenGL(int n_min_major = 4, int n_min_minor = 0);

	/**
	 *	@brief returns OpenGL version
	 *
	 *	Returns OpenGL version as (comparable) integer value.
	 *
	 *	@return Returns OpenGL version as major * 10 + minor (ie. for OpenGL 3.2 returns 32).
	 */
	static int n_OpenGL_Version();

	/**
	 *	@brief returns OpenGL version major
	 *
	 *	@return Returns OpenGL version as major (ie. for OpenGL 3.2 returns 3).
	 */
	static int n_OpenGL_Version_Major();

	/**
	 *	@brief returns OpenGL version minor
	 *
	 *	@return Returns OpenGL version as minor (ie. for OpenGL 3.2 returns 2).
	 */
	static int n_OpenGL_Version_Minor();

	/**
	 *	@brief checks extension support
	 *
	 *	Checks support of a given OpenGL extension, returns true if extension is supported.
	 *
	 *	@param[in] p_s_extension_name is null-terminated string, containing name
	 *		of OpenGL extension encoded in UTF-8
	 *
	 *	@return Returns true in case p_s_extension_name is supported, otherwise false.
	 */
	static bool b_SupportedExtension(const char *p_s_extension_name);

	/**
	 *	@brief gets extension string
	 *
	 *	Since OpenGL 3.0 the classic extension string is no longer supported. OpenGL now
	 *		returns separate names of individual extensions instead (via "indexed"
	 *		::glGetStringi() function).
	 *
	 *		This new behavior is supposed to prevent buffer overruns, as people always seem
	 *		to be copying OpenGL extensions to fixed-size buffers, causing older software
	 *		from times when extension string was shorter to fail on modern hardware.
	 *
	 *		This functions returns "classic" OpenGL extension string in std::string,
	 *		encoded in UTF-8, names of individual extensions are separated by space (' ')
	 *		character.
	 *
	 *	@param[out] r_s_extension_list is a place to write the extension string
	 *
	 *	@return Returns true on success, false on failure (not enough memory).
	 */
	static bool Get_ExtensionString(std::string &r_s_extension_list);

	/**
	 *	@brief checks (platform-specific) windowing system extension support
	 *
	 *	Checks support of a given WGL (GLX) extension, returns true if extension is supported.
	 *
	 *	@param[in] p_s_extension_name is null-terminated string, containing name
	 *		of WGL (GLX) extension encoded in UTF-8
	 *
	 *	@return Returns true in case p_s_extension_name is supported, otherwise false.
	 */
	static bool b_SupportedPlatformExtension(const char *p_s_extension_name);

	/**
	 *	@brief gets entry points of all extensions
	 *
	 *	Gets pointers of function entry points for all supported extensions and OpenGL versions.
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note Note this is aimed at simple and test implementations without
	 *		much need for error checking. it is always better to call individual
	 *		functions, because in case this fails, there's no telling
	 *		which extension exactly failed to initialize.
	 */
	static int n_GetAllSupportedExtensionsFuncPointers();

	/**
	 *	@brief gets entry points of all OpenGL core functions
	 *
	 *	Gets pointers of function entry points for all supported OpenGL versions.
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note Note this is aimed at simple and test implementations without
	 *		much need for error checking. it is always better to call individual
	 *		functions, because in case this fails, there's no telling
	 *		which extension exactly failed to initialize.
	 */
	static int n_GetAllOpenGLCoreFuncPointers();

	/**
	 *	@brief gets entry points of all OpenGL core functions, up to the version specified
	 *
	 *	Gets pointers of function entry points for all supported OpenGL versions, up to the version specified.
	 *
	 *	@param[in] n_major is required OpenGL version major
	 *	@param[in] n_minor is required OpenGL version minor
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note Note this is aimed at simple and test implementations without
	 *		much need for error checking. it is always better to call individual
	 *		functions, because in case this fails, there's no telling
	 *		which extension exactly failed to initialize.
	 */
	static int n_GetOpenGLCoreFuncPointers(int n_major = 3, int n_minor = 3);

	/**
	 *	@brief gets OpenGL 1.2 core function pointers, and sets GLEH_OPENGL_1_2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL12FuncPointers();

	/**
	 *	@brief gets OpenGL 1.3 core function pointers, and sets GLEH_OPENGL_1_3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL13FuncPointers();

	/**
	 *	@brief gets OpenGL 1.4 core function pointers, and sets GLEH_OPENGL_1_4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL14FuncPointers();

	/**
	 *	@brief gets OpenGL 1.5 core function pointers, and sets GLEH_OPENGL_1_5
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL15FuncPointers();

	/**
	 *	@brief gets OpenGL 2.0 core function pointers, and sets GLEH_OPENGL_2_0
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL20FuncPointers();

	/**
	 *	@brief gets OpenGL 2.1 core function pointers, and sets GLEH_OPENGL_2_1
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGL21FuncPointers();

	/**
	 *	@brief gets OpenGL 3.0 core function pointers, and sets GLEH_OPENGL_3_0
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers for the following core extensions as well:
	 *		GL_ARB_framebuffer_object, GL_ARB_map_buffer_range and GL_ARB_vertex_array_object.
	 */
	static int n_GetGL30FuncPointers();

	/**
	 *	@brief gets OpenGL 3.1 core function pointers, and sets GLEH_OPENGL_3_1
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers for the following core extensions as well:
	 *		GL_ARB_uniform_buffer_object, GL_ARB_draw_instanced and GL_ARB_copy_buffer.
	 */
	static int n_GetGL31FuncPointers();

	/**
	 *	@brief gets OpenGL 3.2 core function pointers, and sets GLEH_OPENGL_3_2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers for the following core extensions as well:
	 *		GL_ARB_draw_elements_base_vertex, GL_ARB_provoking_vertex, GL_ARB_sync
	 *		and GL_ARB_texture_multisample.
	 */
	static int n_GetGL32FuncPointers();

	/**
	 *	@brief gets OpenGL 3.3 core function pointers, and sets GLEH_OPENGL_3_3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		GL_ARB_shader_bit_encoding, GL_ARB_blend_func_extended,
	 *		GL_ARB_explicit_attrib_location, GL_ARB_occlusion_query2,
	 *		GL_ARB_sampler_objects, GL_ARB_texture_rgb10_a2ui,
	 *		GL_ARB_texture_swizzle, GL_ARB_timer_query, GL_ARB_instanced_arrays
	 *		and GL_ARB_vertex_type_2_10_10_10_rev.
	 */
	static int n_GetGL33FuncPointers();

	/**
	 *	@brief gets OpenGL 4.0 core function pointers, and sets GLEH_OPENGL_4_0
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		GL_ARB_texture_query_lod, GL_ARB_draw_indirect, GL_ARB_gpu_shader5,
	 *		GL_ARB_gpu_shader_fp64 GL_ARB_shader_subroutine,
	 *		GL_ARB_tessellation_shader, GL_ARB_texture_buffer_object_rgb32,
	 *		GL_ARB_texture_cube_map_array, GL_ARB_texture_gather
	 *		GL_ARB_transform_feedback2 and GL_ARB_transform_feedback3.
	 */
	static int n_GetGL40FuncPointers();

	/**
	 *	@brief gets OpenGL 4.1 core function pointers, and sets GLEH_OPENGL_4_1
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		ARB_ES2_compatibility, ARB_get_program_binary,
	 *		ARB_separate_shader_objects, ARB_shader_precision,
	 *		ARB_vertex_attrib_64bit and ARB_viewport_array.
	 */
	static int n_GetGL41FuncPointers();

	/**
	 *	@brief gets OpenGL 4.2 core function pointers, and sets GLEH_OPENGL_4_2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		ARB_texture_compression_bptc, ARB_compressed_texture_pixel_storage,
	 *		ARB_shader_atomic_counters, ARB_texture_storage, ARB_transform_feedback_instanced,
	 *		ARB_base_instance, ARB_shader_image_load_store, ARB_conservative_depth,
	 *		ARB_shading_language_420pack, ARB_internalformat_query and ARB_map_buffer_alignment.
	 */
	static int n_GetGL42FuncPointers();

	/**
	 *	@brief gets OpenGL 4.3 core function pointers, and sets GLEH_OPENGL_4_3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		ARB_arrays_of_arrays, ARB_ES3_compatibility, ARB_clear_buffer_object,
	 *		ARB_compute_shader, ARB_copy_image, ARB_debug_group, ARB_debug_label,
	 *		ARB_debug_output2, ARB_debug_output, ARB_explicit_uniform_location,
	 *		ARB_fragment_layer_viewport, ARB_framebuffer_no_attachments,
	 *		ARB_internalformat_query2, ARB_invalidate_subdata, ARB_multi_draw_indirect,
	 *		ARB_program_interface_query, ARB_robust_buffer_access_behavior,
	 *		ARB_shader_image_size, ARB_shader_storage_buffer_object,
	 *		ARB_stencil_texturing, ARB_texture_buffer_range, ARB_texture_query_levels,
	 *		ARB_texture_storage_multisample, ARB_texture_view, ARB_vertex_attrib_binding,
	 *		KHR_texture_compression_astc_ldr and ARB_robustness_isolation.
	 */
	static int n_GetGL43FuncPointers();

	/**
	 *	@brief gets OpenGL 4.4 core function pointers, and sets GLEH_OPENGL_4_4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		ARB_buffer_storage, ARB_clear_texture, ARB_enhanced_layouts, ARB_multi_bind,
	 *		ARB_query_buffer_object, ARB_texture_mirror_clamp_to_edge,
	 *		ARB_texture_stencil8 and ARB_vertex_type_10f_11f_11f_rev.
	 */
	static int n_GetGL44FuncPointers();

	/**
	 *	@brief gets OpenGL 4.5 core function pointers, and sets GLEH_OPENGL_4_5
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note This gets function pointers from the following core extensions:
	 *		GL_ARB_clip_control, GL_ARB_clip_control, GL_ARB_cull_distance,
	 *		GL_ARB_ES3_1_compatibility, GL_ARB_conditional_render_inverted,
	 *		GL_KHR_context_flush_control, GL_ARB_derivative_control,
	 *		GL_ARB_direct_state_access, GL_ARB_get_texture_sub_image,
	 *		GL_KHR_robustness, GL_ARB_shader_texture_image_samples and
	 *		GL_ARB_texture_barrier.
	 */
	static int n_GetGL45FuncPointers();

	/**
	 *	@brief gets GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_depth_buffer_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDepthBufferFloatFuncPointers();

	/**
	 *	@brief gets GL_ARB_framebuffer_object (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_framebuffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBFramebufferObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_framebuffer_sRGB
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBFramebufferSRGBFuncPointers();

	/**
	 *	@brief gets GL_ARB_half_float_vertex (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_half_float_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBHalfFloatVertexFuncPointers();

	/**
	 *	@brief gets GL_ARB_map_buffer_range (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_map_buffer_range
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBMapBufferRangeFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_texture_compression_rgtc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureCompressionRGtcFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_rg (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_texture_rg
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureRGFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_array_object (part of OpenGL 3.0 core) function pointers, and sets GLEH_ARB_vertex_array_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBVertexArrayObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) function pointers, and sets GLEH_ARB_uniform_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBUniformBufferObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_instanced (part of OpenGL 3.1 core) function pointers, and sets GLEH_ARB_draw_instanced
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDrawInstancedFuncPointers();

	/**
	 *	@brief gets GL_ARB_copy_buffer (part of OpenGL 3.1 core) function pointers, and sets GLEH_ARB_copy_buffer
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBCopyBufferFuncPointers();

	/**
	 *	@brief gets GL_ARB_depth_clamp (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_depth_clamp
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDepthClampFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_elements_base_vertex (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_draw_elements_base_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDrawElementsBaseVertexFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_coord_conventions (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_fragment_coord_conventions
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBFragmentCoordConventionsFuncPointers();

	/**
	 *	@brief gets GL_ARB_provoking_vertex (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_provoking_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBProvokingVertexFuncPointers();

	/**
	 *	@brief gets GL_ARB_seamless_cube_map (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_seamless_cube_map
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBSeamlessCubeMapFuncPointers();

	/**
	 *	@brief gets GL_ARB_sync (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_sync
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBSyncFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_multisample (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_texture_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureMultisampleFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_array_bgra (part of OpenGL 3.2 core) function pointers, and sets GLEH_ARB_vertex_array_bgra
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBVertexArrayBGRAFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_bit_encoding (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_shader_bit_encoding
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderBitEncodingFuncPointers();

	/**
	 *	@brief gets GL_ARB_blend_func_extended (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_blend_func_extended
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBBlendFuncExtendedFuncPointers();

	/**
	 *	@brief gets GL_ARB_explicit_attrib_location (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_explicit_attrib_location
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBExplicitAttribLocationFuncPointers();

	/**
	 *	@brief gets GL_ARB_occlusion_query2 (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_occlusion_query2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBOcclusionQuery2FuncPointers();

	/**
	 *	@brief gets GL_ARB_sampler_objects (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_sampler_objects
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBSamplerObjectsFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_rgb10_a2ui (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_texture_rgb10_a2ui
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureRGB10A2uiFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_swizzle (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_texture_swizzle
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureSwizzleFuncPointers();

	/**
	 *	@brief gets GL_ARB_timer_query (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_timer_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTimerQueryFuncPointers();

	/**
	 *	@brief gets GL_ARB_instanced_arrays (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_instanced_arrays
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBInstancedArraysFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) function pointers, and sets GLEH_ARB_vertex_type_2_10_10_10_rev
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBVertexType2101010RevFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_query_lod (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_texture_query_lod
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureQueryLodFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_buffers_blend (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_draw_buffers_blend
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDrawBuffersBlendFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_indirect (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_draw_indirect
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDrawIndirectFuncPointers();

	/**
	 *	@brief gets GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_gpu_shader5
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBGPUShader5FuncPointers();

	/**
	 *	@brief gets GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_gpu_shader_fp64
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBGPUShaderFP64FuncPointers();

	/**
	 *	@brief gets GL_ARB_sample_shading (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_sample_shading
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBSampleShadingFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_subroutine (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_shader_subroutine
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBShaderSubroutineFuncPointers();

	/**
	 *	@brief gets GL_ARB_tessellation_shader (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_tessellation_shader
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTessellationShaderFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_buffer_object_rgb32 (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_texture_buffer_object_rgb32
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureBufferObjectRGB32FuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_texture_cube_map_array
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureCubeMapArrayFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_gather (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_texture_gather
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureGatherFuncPointers();

	/**
	 *	@brief gets GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_transform_feedback2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTransformFeedback2FuncPointers();

	/**
	 *	@brief gets GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) function pointers, and sets GLEH_ARB_transform_feedback3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTransformFeedback3FuncPointers();

	/**
	 *	@brief gets GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_ES2_compatibility
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBES2CompatibilityFuncPointers();

	/**
	 *	@brief gets GL_ARB_get_program_binary (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_get_program_binary
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBGetProgramBinaryFuncPointers();

	/**
	 *	@brief gets GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_separate_shader_objects
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBSeparateShaderObjectsFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_precision (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_shader_precision
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderPrecisionFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_attrib_64bit (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_vertex_attrib_64bit
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBVertexAttrib64bitFuncPointers();

	/**
	 *	@brief gets GL_ARB_viewport_array (part of OpenGL 4.1 core) function pointers, and sets GLEH_ARB_viewport_array
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBViewportArrayFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_texture_compression_bptc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureCompressionBptcFuncPointers();

	/**
	 *	@brief gets GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_compressed_texture_pixel_storage
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBCompressedTexturePixelStorageFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_shader_atomic_counters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBShaderAtomicCountersFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_storage (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_texture_storage
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureStorageFuncPointers();

	/**
	 *	@brief gets GL_ARB_transform_feedback_instanced (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_transform_feedback_instanced
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTransformFeedbackInstancedFuncPointers();

	/**
	 *	@brief gets GL_ARB_base_instance (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_base_instance
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBBaseInstanceFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_shader_image_load_store
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBShaderImageLoadStoreFuncPointers();

	/**
	 *	@brief gets GL_ARB_conservative_depth (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_conservative_depth
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBConservativeDepthFuncPointers();

	/**
	 *	@brief gets GL_ARB_shading_language_420pack (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_shading_language_420pack
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShadingLanguage420packFuncPointers();

	/**
	 *	@brief gets GL_ARB_internalformat_query (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_internalformat_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBInternalformatQueryFuncPointers();

	/**
	 *	@brief gets GL_ARB_map_buffer_alignment (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_map_buffer_alignment
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBMapBufferAlignmentFuncPointers();

	/**
	 *	@brief gets GL_ARB_shading_language_packing (part of OpenGL 4.2 core) function pointers, and sets GLEH_ARB_shading_language_packing
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShadingLanguagePackingFuncPointers();

	/**
	 *	@brief gets GL_ARB_arrays_of_arrays (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_arrays_of_arrays
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBArraysOfArraysFuncPointers();

	/**
	 *	@brief gets GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_ES3_compatibility
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBES3CompatibilityFuncPointers();

	/**
	 *	@brief gets GL_ARB_clear_buffer_object (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_clear_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBClearBufferObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_compute_shader (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_compute_shader
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBComputeShaderFuncPointers();

	/**
	 *	@brief gets GL_ARB_copy_image (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_copy_image
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBCopyImageFuncPointers();

	/**
	 *	@brief gets GL_ARB_debug_group (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_debug_group
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDebugGroupFuncPointers();

	/**
	 *	@brief gets GL_ARB_debug_label (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_debug_label
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDebugLabelFuncPointers();

	/**
	 *	@brief gets GL_ARB_debug_output2 (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_debug_output2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDebugOutput2FuncPointers();

	/**
	 *	@brief gets GL_ARB_debug_output (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_debug_output
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDebugOutputFuncPointers();

	/**
	 *	@brief gets GL_ARB_explicit_uniform_location (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_explicit_uniform_location
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBExplicitUniformLocationFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_layer_viewport (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_fragment_layer_viewport
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBFragmentLayerViewportFuncPointers();

	/**
	 *	@brief gets GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_framebuffer_no_attachments
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBFramebufferNoAttachmentsFuncPointers();

	/**
	 *	@brief gets GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_internalformat_query2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBInternalformatQuery2FuncPointers();

	/**
	 *	@brief gets GL_ARB_invalidate_subdata (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_invalidate_subdata
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBInvalidateSubdataFuncPointers();

	/**
	 *	@brief gets GL_ARB_multi_draw_indirect (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_multi_draw_indirect
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBMultiDrawIndirectFuncPointers();

	/**
	 *	@brief gets GL_ARB_program_interface_query (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_program_interface_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBProgramInterfaceQueryFuncPointers();

	/**
	 *	@brief gets GL_ARB_robust_buffer_access_behavior (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_robust_buffer_access_behavior
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBRobustBufferAccessBehaviorFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_image_size (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_shader_image_size
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderImageSizeFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_storage_buffer_object (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_shader_storage_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBShaderStorageBufferObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_stencil_texturing (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_stencil_texturing
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBStencilTexturingFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_buffer_range (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_texture_buffer_range
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureBufferRangeFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_query_levels (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_texture_query_levels
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureQueryLevelsFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_storage_multisample (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_texture_storage_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureStorageMultisampleFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_view (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_texture_view
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureViewFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_attrib_binding (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_vertex_attrib_binding
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBVertexAttribBindingFuncPointers();

	/**
	 *	@brief gets GL_KHR_texture_compression_astc_hdr (part of OpenGL 4.3 core) function pointers, and sets GLEH_KHR_texture_compression_astc_hdr
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetKHRTextureCompressionASTC_HDRFuncPointers();

	/**
	 *	@brief gets GL_ARB_robustness_isolation (part of OpenGL 4.3 core) function pointers, and sets GLEH_ARB_robustness_isolation
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBRobustnessIsolationFuncPointers();

	/**
	 *	@brief gets GL_ARB_buffer_storage (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_buffer_storage
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBBufferStorageFuncPointers();

	/**
	 *	@brief gets GL_ARB_clear_texture (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_clear_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBClearTextureFuncPointers();

	/**
	 *	@brief gets GL_ARB_enhanced_layouts (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_enhanced_layouts
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBEnhancedLayoutsFuncPointers();

	/**
	 *	@brief gets GL_ARB_multi_bind (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_multi_bind
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBMultiBindFuncPointers();

	/**
	 *	@brief gets GL_ARB_query_buffer_object (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_query_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBQueryBufferObjectFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_mirror_clamp_to_edge (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_texture_mirror_clamp_to_edge
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureMirrorClampToEdgeFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_stencil8 (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_texture_stencil8
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBTextureStencil8FuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_type_10f_11f_11f_rev (part of OpenGL 4.4 core) function pointers, and sets GLEH_ARB_vertex_type_10f_11f_11f_rev
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBVertexType10f11f11fRevFuncPointers();

	/**
	 *	@brief gets GL_ARB_clip_control (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_clip_control
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBClipControlFuncPointers();

	/**
	 *	@brief gets GL_ARB_cull_distance (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_cull_distance
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBCullDistanceFuncPointers();

	/**
	 *	@brief gets GL_ARB_ES3_1_compatibility (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_ES3_1_compatibility
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBES31CompatibilityFuncPointers();

	/**
	 *	@brief gets GL_ARB_conditional_render_inverted (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_conditional_render_inverted
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBConditionalRenderInvertedFuncPointers();

	/**
	 *	@brief gets GL_KHR_context_flush_control (part of OpenGL 4.5 core) function pointers, and sets GLEH_KHR_context_flush_control
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetKHRContextFlushControlFuncPointers();

	/**
	 *	@brief gets GL_ARB_derivative_control (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_derivative_control
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBDerivativeControlFuncPointers();

	/**
	 *	@brief gets GL_ARB_direct_state_access (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_direct_state_access
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBDirectStateAccessFuncPointers();

	/**
	 *	@brief gets GL_ARB_get_texture_sub_image (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_get_texture_sub_image
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBGetTextureSubImageFuncPointers();

	/**
	 *	@brief gets GL_KHR_robustness (part of OpenGL 4.5 core) function pointers, and sets GLEH_KHR_robustness
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetKHRRobustnessFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_texture_image_samples (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_shader_texture_image_samples
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderTextureImageSamplesFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_barrier (part of OpenGL 4.5 core) function pointers, and sets GLEH_ARB_texture_barrier
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBTextureBarrierFuncPointers();

	/**
	 *	@brief gets GL_ARB_bindless_texture function pointers, and sets GLEH_ARB_bindless_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBBindlessTextureFuncPointers();

	/**
	 *	@brief gets GL_ARB_sparse_texture function pointers, and sets GLEH_ARB_sparse_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBSparseTextureFuncPointers();

	/**
	 *	@brief gets GL_ARB_compute_variable_group_size function pointers, and sets GLEH_ARB_compute_variable_group_size
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBComputeVariableGroupSizeFuncPointers();

	/**
	 *	@brief gets GL_ARB_indirect_parameters function pointers, and sets GLEH_ARB_indirect_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBIndirectParametersFuncPointers();

	/**
	 *	@brief gets GL_ARB_seamless_cubemap_per_texture function pointers, and sets GLEH_ARB_seamless_cubemap_per_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBSeamlessCubemapPerTextureFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_draw_parameters function pointers, and sets GLEH_ARB_shader_draw_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderDrawParametersFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_group_vote function pointers, and sets GLEH_ARB_shader_group_vote
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderGroupVoteFuncPointers();

	/**
	 *	@brief gets GL_EXT_draw_buffers2 function pointers, and sets GLEH_EXT_draw_buffers2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetEXTDrawBuffers2FuncPointers();

	/**
	 *	@brief gets GL_EXT_gpu_program_parameters function pointers, and sets GLEH_EXT_gpu_program_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetEXTGPUProgramParametersFuncPointers();

	/**
	 *	@brief gets GL_EXT_bindable_uniform function pointers, and sets GLEH_EXT_bindable_uniform
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetEXTBindableUniformFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_texture_lod function pointers, and sets GLEH_ARB_shader_texture_lod
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderTextureLodFuncPointers();

	/**
	 *	@brief gets GL_S3_s3tc function pointers, and sets GLEH_S3_s3tc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetS3_S3TCFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_compression_latc function pointers, and sets GLEH_EXT_texture_compression_latc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetEXTTextureCompressionLATCFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_compression_s3tc function pointers, and sets GLEH_EXT_texture_compression_s3tc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetEXTTextureCompressionS3TCFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_filter_anisotropic function pointers, and sets GLEH_EXT_texture_filter_anisotropic
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetEXTTextureFilterAnisotropicFuncPointers();

	/**
	 *	@brief gets GL_EXT_abgr function pointers, and sets GLEH_EXT_abgr
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetEXTABGRFuncPointers();

	/**
	 *	@brief gets GL_ARB_shading_language_include function pointers, and sets GLEH_ARB_shading_language_include
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBShadingLanguageIncludeFuncPointers();

	/**
	 *	@brief gets GL_ARB_cl_event function pointers, and sets GLEH_ARB_cl_event
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetARBCLEventFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_stencil_export function pointers, and sets GLEH_ARB_shader_stencil_export
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetARBShaderStencilExportFuncPointers();

	/**
	 *	@brief gets GL_NV_command_list function pointers, and sets GLEH_NV_command_list
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetNVCommandListFuncPointers();
};

/**
 *	@def GLFuncPtrName
 *	@brief creates name for an OpenGL entry point
 *	@param[in] f is a name of an OpenGL function
 */
#ifdef __GL_FIX_FUNCTION_LINKING_CONFLICTS
/**
 *	@def __ConCat__
 *
 *	@brief a simple function name concatenation macro
 *
 *	@param[in] a is the first part of the name
 *	@param[in] b is the second part of the name
 */
#define __ConCat__(a,b) a##b
#define GLFuncPtrName(f) __ConCat__(f,_ptr)
#else // __GL_FIX_FUNCTION_LINKING_CONFLICTS
#define GLFuncPtrName(f) f
#endif // __GL_FIX_FUNCTION_LINKING_CONFLICTS

typedef unsigned int GLenum; /**< @brief OpenGL enum */
typedef unsigned char GLboolean; /**< @brief boolean */
typedef unsigned int GLbitfield; /**< @brief bitfield */
typedef signed char GLbyte; /**< @brief byte */
typedef short GLshort; /**< @brief short integer */
typedef int GLint; /**< @brief integer */
typedef int GLsizei; /**< @brief size type */
typedef unsigned char GLubyte; /**< @brief unsigned byte */
typedef unsigned short GLushort; /**< @brief unsigned short integer */
typedef unsigned int GLuint; /**< @brief unsigned integer */
typedef float GLfloat; /**< @brief float */
typedef float GLclampf; /**< @brief clamped float */
typedef double GLdouble; /**< @brief double */
typedef double GLclampd; /**< @brief clamped double */
typedef void GLvoid; /**< @brief void */
// base OpenGL data types

typedef ptrdiff_t GLintptr; /**< @brief integer type capable of holding a pointer */
typedef ptrdiff_t GLsizeiptr; /**< @brief unsigned integer type capable of holding a pointer */
// OpenGL 1.5 data types (GL types for handling large vertex buffer objects)

typedef char GLchar; /**< @brief char */
// OpenGL 2.0 data types (GL type for program/shader text)

typedef ptrdiff_t GLintptrARB; /**< @brief integer type capable of holding a pointer */
typedef ptrdiff_t GLsizeiptrARB; /**< @brief unsigned integer type capable of holding a pointer */
// GL_ARB_vertex_buffer_object data types (GL types for handling large vertex buffer objects)

typedef char GLcharARB; /**< @brief char */
typedef unsigned int GLhandleARB; /**< @brief handle to an object */
// GL_ARB_shader_objects data types (GL types for handling shader object handles and program/shader text)

typedef unsigned short GLhalfARB; /**< @brief half float */
// GL_ARB_half_float_pixel data types ("half" precision (s10e5) float data in host memory)

typedef unsigned short GLhalfNV; /**< @brief half float */
// GL_NV_half_float data types ("half" precision (s10e5) float data in host memory)

typedef int64_t GLint64EXT; /**< @brief 64-bit integer */
typedef uint64_t GLuint64EXT; /**< @brief unsigned 64-bit integer */
// GL_EXT_timer_query data types

typedef int64_t GLint64; /**< @brief 64-bit integer */
typedef uint64_t GLuint64; /**< @brief unsigned 64-bit integer */
typedef struct __GLsync *GLsync; /**< @brief sync object */
// GL_ARB_sync data types

typedef unsigned short GLhalf; /**< @brief half float */
// GL_NV_half_float data types

/**
 *	@def n_GL_TypeSize
 *	@brief determines size of OpenGL data type
 *	@param[in] n_type is OpenGL (internal) data type
 *	@return Returns size of the given type, or 0 in case n_type is not a valid internal type.
 */
#define n_GL_TypeSize(n_type) \
	(((n_type) == GL_DOUBLE)? 8 : \
	((n_type) == GL_FLOAT || (n_type) == GL_INT || (n_type) == GL_UNSIGNED_INT)? 4 : \
	((n_type) == GL_HALF_FLOAT || (n_type) == GL_SHORT || (n_type) == GL_UNSIGNED_SHORT)? 2 : \
	((n_type) == GL_BYTE || (n_type) == GL_UNSIGNED_BYTE)? 1 : 0)

#if defined(_MSC_VER) && !defined(__MWERKS__) && _MSC_VER <= 1200
#include <stddef.h>
typedef ptrdiff_t intptr_t;
#endif // _MSC_VER && !__MWERKS__ && _MSC_VER <= 1200
#include <CL/cl.h>
// intptr_t, cl_context, cl_event

/**
 *	@def ApiEntry
 *	@brief decorator for an OpenGL function
 */
#ifndef APIENTRY
#define ApiEntry
#else // !APIENTRY
#define ApiEntry APIENTRY
#endif // !APIENTRY

/**
 *	@def GLStaticApi
 *	@brief decorator for a statically linked OpenGL function
 */
#ifndef GLStaticApi
#define GLStaticApi extern
#endif // !GLStaticApi

/**
 *	@def GLApi
 *	@brief decorator for a dynamically linked OpenGL function
 */
#if defined(_WIN32) || defined(_WIN64)
#define GLApi __stdcall
#else // _WIN32 || _WIN64
#define GLApi 
#endif // _WIN32 || _WIN64

typedef void (ApiEntry *GLDEBUGPROCARB)(GLenum source, GLenum type,
	GLuint id, GLenum severity, GLsizei length, const GLchar* message,
	GLvoid* userParam); /**< @brief GL_ARB_debug_output callback */
// GL_ARB_debug_output

#include <string>
#include <stdexcept>

#if defined(__GL_AUTOCHECK) && (defined(_DEBUG) || defined(__GL_FORCE_AUTOCHECK))

/**
 *	@def __HAVE_GL_AUTOCHECK
 *	@brief defined in case GL_AUTOCHECK_BLOCK is not empty
 */
#define __HAVE_GL_AUTOCHECK

#ifndef FIX_GL_FUNCTION_LINKING_CONFLICTS
#define __ConCat__(a,b) a##b
#endif // !FIX_GL_FUNCTION_LINKING_CONFLICTS

/**
 *	@def GLAutoCheckFuncPtrName
 *	@brief creates name for a _glachwrap function
 *	@param[in] fn is a name of an OpenGL function
 */
#define GLAutoCheckFuncPtrName(fn) __ConCat__(fn,_glachwrap)

/**
 *	@def GLAutoCheckStaticFuncName
 *	@brief creates name for a _glachwrap function
 *	@param[in] fn is a name of a statically linked OpenGL function
 */
#define GLAutoCheckStaticFuncName(fn) __ConCat__(fn,_glachwrap)

/**
 *	@def GLAutoCheckExtraParams
 *	@brief additional parameters that are needed for the autocheck functions
 */
#define GLAutoCheckExtraParams , __FILE__, __LINE__

/**
 *	@def GLAutoCheckExtraParamsSA
 *	@brief standalone parameters that are needed for the autocheck functions
 */
#define GLAutoCheckExtraParamsSA __FILE__, __LINE__

/**
 *	@def GLAutoCheckFire
 *	@brief OpenGL autocheck error event handler
 *	@param[in] what is exception description
 */
#if defined(__GL_AUTOCHECK_USE_EXCEPTION)
#define GLAutoCheckFire(what) throw std::runtime_error(what)
#elif defined(__GL_AUTOCHECK_USE_BREAKPOINT)
#if defined(_WIN32) || defined(_WIN64) 
#if defined(_M_X64) || defined(_M_AMD64) || defined(_M_IA64) || defined(__x86_64) || defined(__amd64) || defined(__ia64)
#include <intrin.h>
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); __debugbreak(); } while(0)
#else // _M_X64 || _M_AMD64 || _M_IA64 || __x86_64 || __amd64 || __ia64
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); __asm { int 3 } } while(0)
#endif // _M_X64 || _M_AMD64 || _M_IA64 || __x86_64 || __amd64 || __ia64
#else // _WIN32 || _WIN64
#include <signal.h>
#ifdef SIGTRAP
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); raise(SIGTRAP); } while(0)
#else // SIGTRAP
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); abort(); } while(0)
#endif // SIGTRAP
// posix compliant
#endif // _WIN32 || _WIN64
#elif defined(__GL_AUTOCHECK_USE_ABORT)
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); abort(); } while(0)
#else // if defined(__GL_AUTOCHECK_USE_EXIT)
#define GLAutoCheckFire(what) do { fprintf(stderr, "GL_AUTOCHECK: %s\n", (what)); exit(-1); } while(0)
#endif // __GL_AUTOCHECK_USE_EXCEPTION

/**
 *	@def GL_AUTOCHECK_BLOCK
 *
 *	@param[in] p_s_function is the OpenGL function being called
 *	@param[in] p_s_file is name of file of invocation
 *	@param[in] n_line is (one-based) index of source code line of invocation
 *
 *	@brief checks for OpenGL errors and throws std::runtime_error
 *		with error descritption in case any error occured
 *	@note This is only available in debug mode unless __GL_FORCE_AUTOCHECK is defined.
 */
#if defined(__STL_UTILS_INCLUDED)

#define GL_AUTOCHECK_BLOCK(p_s_function,p_s_file,n_line) \
	do { \
		GLenum n_error; \
		if((n_error = glGetError()) == GL_NO_ERROR) \
			break;	\
		std::string s_message; \
		switch(n_error) { \
		case GL_INVALID_ENUM: \
			stl_ut::Format(s_message, "error: file \'" "%s" "\', line %d, function %s()" \
				": OpenGL error: GL_INVALID_ENUM", p_s_file, n_line, p_s_function); \
			GLAutoCheckFire(s_message.c_str()); \
		case GL_INVALID_VALUE: \
			stl_ut::Format(s_message, "error: file \'" "%s" "\', line %d, function %s()" \
				": OpenGL error: GL_INVALID_VALUE", p_s_file, n_line, p_s_function); \
			GLAutoCheckFire(s_message.c_str()); \
		case GL_INVALID_OPERATION: \
			stl_ut::Format(s_message, "error: file \'" "%s" "\', line %d, function %s()" \
				": OpenGL error: GL_INVALID_OPERATION", p_s_file, n_line, p_s_function); \
			GLAutoCheckFire(s_message.c_str()); \
		case GL_OUT_OF_MEMORY: \
			stl_ut::Format(s_message, "error: file \'" "%s" "\', line %d, function %s()" \
				": OpenGL error: GL_OUT_OF_MEMORY", p_s_file, n_line, p_s_function); \
			GLAutoCheckFire(s_message.c_str()); \
		default: \
			stl_ut::Format(s_message, "error: file \'" "%s" "\', line %d, function %s()" \
				": OpenGL error: 0x%04x", p_s_file, n_line, p_s_function, n_error); /* this shouldn't really happen */ \
			GLAutoCheckFire(s_message.c_str()); \
		}; \
	} while(0)
// use stl utils' Format()

#elif defined(_MSC_VER) && !defined(__MWERKS__) && _MSC_VER >= 1400

#define GL_AUTOCHECK_BLOCK(p_s_function,p_s_file,n_line) \
	do { \
		GLenum n_error; \
		if((n_error = glGetError()) != GL_NO_ERROR) { \
			char p_s_buffer[16]; \
			const char *p_s_error; \
			switch(n_error) { \
			case GL_INVALID_ENUM: \
				p_s_error = "GL_INVALID_ENUM"; \
				break; \
			case GL_INVALID_VALUE: \
				p_s_error = "GL_INVALID_VALUE"; \
				break; \
			case GL_INVALID_OPERATION: \
				p_s_error = "GL_INVALID_OPERATION"; \
				break; \
			case GL_OUT_OF_MEMORY: \
				p_s_error = "GL_OUT_OF_MEMORY"; \
				break; \
			default: \
				sprintf(p_s_buffer, "0x%04x", n_error); /* this shouldn't really happen */ \
				p_s_error = p_s_buffer; \
			}; \
			const char *p_s_fmt = "error: file \'%s\', line %d, " \
				"function %s(): OpenGL error: %s"; \
			std::string s_message; \
			s_message.resize(strlen(p_s_fmt) + strlen(p_s_file) + \
				16 + strlen(p_s_function) + strlen(p_s_error)); \
			_snprintf(&s_message[0], s_message.length() * sizeof(char), \
				p_s_fmt, p_s_file, n_line, p_s_function, p_s_error); \
			GLAutoCheckFire(s_message.c_str()); \
		} \
	} while(0)
// use snprintf()

#else // _MSC_VER && !__MWERKS__ && _MSC_VER >= 1400

#define GL_AUTOCHECK_BLOCK(p_s_function,p_s_file,n_line) \
	do { \
		GLenum n_error; \
		if((n_error = glGetError()) != GL_NO_ERROR) { \
			char p_s_buffer[16]; \
			const char *p_s_error; \
			switch(n_error) { \
			case GL_INVALID_ENUM: \
				p_s_error = "GL_INVALID_ENUM"; \
				break; \
			case GL_INVALID_VALUE: \
				p_s_error = "GL_INVALID_VALUE"; \
				break; \
			case GL_INVALID_OPERATION: \
				p_s_error = "GL_INVALID_OPERATION"; \
				break; \
			case GL_OUT_OF_MEMORY: \
				p_s_error = "GL_OUT_OF_MEMORY"; \
				break; \
			default: \
				sprintf(p_s_buffer, "0x%04x", n_error); /* this shouldn't really happen */ \
				p_s_error = p_s_buffer; \
			}; \
			const char *p_s_fmt = "error: file \'%s\', line %d, " \
				"function %s(): OpenGL error: %s"; \
			std::string s_message; \
			s_message.resize(strlen(p_s_fmt) + strlen(p_s_file) + \
				16 + strlen(p_s_function) + strlen(p_s_error)); \
			sprintf(&s_message[0], p_s_fmt, p_s_file, n_line, p_s_function, p_s_error); \
			GLAutoCheckFire(s_message.c_str()); \
		} \
	} while(0)
// use unsafe sprintf()

#endif // _MSC_VER && !__MWERKS__ && _MSC_VER >= 1400

#else // __GL_AUTOCHECK && (_DEBUG || __GL_FORCE_AUTOCHECK)

/**
 *	@def GLAutoCheckFuncPtrName
 *	@brief creates name for a _glachwrap function
 *	@param[in] fn is a name of an OpenGL function
 */
#define GLAutoCheckFuncPtrName(fn) GLFuncPtrName(fn)

/**
 *	@def GLAutoCheckStaticFuncName
 *	@brief creates name for a _glachwrap function
 *	@param[in] fn is a name of a statically linked OpenGL function
 */
#define GLAutoCheckStaticFuncName(fn) fn

/**
 *	@def GLAutoCheckExtraParams
 *	@brief additional parameters that are needed for the autocheck functions
 */
#define GLAutoCheckExtraParams 

/**
 *	@def GLAutoCheckExtraParamsSA
 *	@brief standalone parameters that are needed for the autocheck functions
 */
#define GLAutoCheckExtraParamsSA 

/**
 *	@def GL_AUTOCHECK_BLOCK
 *
 *	@param[in] p_s_function is the OpenGL function being called
 *	@param[in] p_s_file is name of file of invocation
 *	@param[in] n_line is (one-based) index of source code line of invocation
 *
 *	@brief has no effect (_DEBUG or __GL_FORCE_AUTOCHECK are not defined).
 */
#define GL_AUTOCHECK_BLOCK(p_s_function,p_s_file,n_line) do {} while(0)

#endif // __GL_AUTOCHECK && (_DEBUG || __GL_FORCE_AUTOCHECK)

//								--- OpenGL 1.0 ---

/**
 *	@def GL_VERSION_1_0
 *	@brief if defined, OpenGL 1.0 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_0
#define GL_VERSION_1_0 1

/**
 *	@def GLEH_OPENGL_1_0
 *	@brief set if OpenGL 1.0 is supported
 */
#define GLEH_OPENGL_1_0 true

/* AttribMask */
#define GL_DEPTH_BUFFER_BIT											0x00000100 /**< @brief OpenGL 1.0 enum (attrib mask) */
#define GL_STENCIL_BUFFER_BIT										0x00000400 /**< @brief OpenGL 1.0 enum (attrib mask) */
#define GL_COLOR_BUFFER_BIT											0x00004000 /**< @brief OpenGL 1.0 enum (attrib mask) */
/* Boolean */
#define GL_FALSE													0 /**< @brief OpenGL 1.0 enum (boolean) */
#define GL_TRUE														1 /**< @brief OpenGL 1.0 enum (boolean) */
/* BeginMode */
#define GL_POINTS													0x0000 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_LINES													0x0001 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_LINE_LOOP												0x0002 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_LINE_STRIP												0x0003 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_TRIANGLES												0x0004 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_TRIANGLE_STRIP											0x0005 /**< @brief OpenGL 1.0 enum (begin mode) */
#define GL_TRIANGLE_FAN												0x0006 /**< @brief OpenGL 1.0 enum (begin mode) */
/* AlphaFunction */
#define GL_NEVER													0x0200 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_LESS														0x0201 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_EQUAL													0x0202 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_LEQUAL													0x0203 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_GREATER													0x0204 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_NOTEQUAL													0x0205 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_GEQUAL													0x0206 /**< @brief OpenGL 1.0 enum (alpha function) */
#define GL_ALWAYS													0x0207 /**< @brief OpenGL 1.0 enum (alpha function) */
/* BlendingFactorDest */
#define GL_ZERO														0 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_ONE														1 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_SRC_COLOR												0x0300 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_ONE_MINUS_SRC_COLOR										0x0301 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_SRC_ALPHA												0x0302 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_ONE_MINUS_SRC_ALPHA										0x0303 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_DST_ALPHA												0x0304 /**< @brief OpenGL 1.0 enum (blending factor dest) */
#define GL_ONE_MINUS_DST_ALPHA										0x0305 /**< @brief OpenGL 1.0 enum (blending factor dest) */
/* BlendingFactorSrc */
#define GL_DST_COLOR												0x0306 /**< @brief OpenGL 1.0 enum (blending factor src) */
#define GL_ONE_MINUS_DST_COLOR										0x0307 /**< @brief OpenGL 1.0 enum (blending factor src) */
#define GL_SRC_ALPHA_SATURATE										0x0308 /**< @brief OpenGL 1.0 enum (blending factor src) */
/* DrawBufferMode */
#define GL_NONE														0 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_FRONT_LEFT												0x0400 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_FRONT_RIGHT												0x0401 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_BACK_LEFT												0x0402 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_BACK_RIGHT												0x0403 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_FRONT													0x0404 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_BACK														0x0405 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_LEFT														0x0406 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_RIGHT													0x0407 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
#define GL_FRONT_AND_BACK											0x0408 /**< @brief OpenGL 1.0 enum (draw buffer mode) */
/* ErrorCode */
#define GL_NO_ERROR													0 /**< @brief OpenGL 1.0 enum (error code) */
#define GL_INVALID_ENUM												0x0500 /**< @brief OpenGL 1.0 enum (error code) */
#define GL_INVALID_VALUE											0x0501 /**< @brief OpenGL 1.0 enum (error code) */
#define GL_INVALID_OPERATION										0x0502 /**< @brief OpenGL 1.0 enum (error code) */
#define GL_OUT_OF_MEMORY											0x0505 /**< @brief OpenGL 1.0 enum (error code) */
/* FrontFaceDirection */
#define GL_CW														0x0900 /**< @brief OpenGL 1.0 enum (front face direction) */
#define GL_CCW														0x0901 /**< @brief OpenGL 1.0 enum (front face direction) */
/* GetPName */
#define GL_POINT_SIZE												0x0B11 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POINT_SIZE_RANGE											0x0B12 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POINT_SIZE_GRANULARITY									0x0B13 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LINE_SMOOTH												0x0B20 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LINE_WIDTH												0x0B21 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LINE_WIDTH_RANGE											0x0B22 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LINE_WIDTH_GRANULARITY									0x0B23 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_SMOOTH											0x0B41 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_CULL_FACE												0x0B44 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_CULL_FACE_MODE											0x0B45 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_FRONT_FACE												0x0B46 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DEPTH_RANGE												0x0B70 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DEPTH_TEST												0x0B71 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DEPTH_WRITEMASK											0x0B72 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DEPTH_CLEAR_VALUE										0x0B73 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DEPTH_FUNC												0x0B74 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_TEST												0x0B90 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_CLEAR_VALUE										0x0B91 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_FUNC												0x0B92 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_VALUE_MASK										0x0B93 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_FAIL												0x0B94 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_PASS_DEPTH_FAIL									0x0B95 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_PASS_DEPTH_PASS									0x0B96 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_REF												0x0B97 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STENCIL_WRITEMASK										0x0B98 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_VIEWPORT													0x0BA2 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DITHER													0x0BD0 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_BLEND_DST												0x0BE0 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_BLEND_SRC												0x0BE1 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_BLEND													0x0BE2 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LOGIC_OP_MODE											0x0BF0 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_COLOR_LOGIC_OP											0x0BF2 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DRAW_BUFFER												0x0C01 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_READ_BUFFER												0x0C02 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_SCISSOR_BOX												0x0C10 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_SCISSOR_TEST												0x0C11 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_COLOR_CLEAR_VALUE										0x0C22 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_COLOR_WRITEMASK											0x0C23 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_DOUBLEBUFFER												0x0C32 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_STEREO													0x0C33 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_LINE_SMOOTH_HINT											0x0C52 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_SMOOTH_HINT										0x0C53 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_UNPACK_SWAP_BYTES										0x0CF0 /**< @brief OpenGL 1.0 enum (get p name) */
//#define GL_UNPACK_LSB_FIRST										  0x0CF1 // deprecated (in OpenGL 4.3)
#define GL_UNPACK_ROW_LENGTH										0x0CF2 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_UNPACK_SKIP_ROWS											0x0CF3 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_UNPACK_SKIP_PIXELS										0x0CF4 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_UNPACK_ALIGNMENT											0x0CF5 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_PACK_SWAP_BYTES											0x0D00 /**< @brief OpenGL 1.0 enum (get p name) */
//#define GL_PACK_LSB_FIRST											  0x0D01 // deprecated (in OpenGL 4.3)
#define GL_PACK_ROW_LENGTH											0x0D02 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_PACK_SKIP_ROWS											0x0D03 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_PACK_SKIP_PIXELS											0x0D04 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_PACK_ALIGNMENT											0x0D05 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_MAX_TEXTURE_SIZE											0x0D33 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_MAX_VIEWPORT_DIMS										0x0D3A /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_SUBPIXEL_BITS											0x0D50 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_TEXTURE_1D												0x0DE0 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_TEXTURE_2D												0x0DE1 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_OFFSET_UNITS										0x2A00 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_OFFSET_POINT										0x2A01 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_OFFSET_LINE										0x2A02 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_OFFSET_FILL										0x8037 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_POLYGON_OFFSET_FACTOR									0x8038 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_TEXTURE_BINDING_1D										0x8068 /**< @brief OpenGL 1.0 enum (get p name) */
#define GL_TEXTURE_BINDING_2D										0x8069 /**< @brief OpenGL 1.0 enum (get p name) */
/* GetTextureParameter */
#define GL_TEXTURE_WIDTH											0x1000 /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_HEIGHT											0x1001 /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_INTERNAL_FORMAT									0x1003 /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_BORDER_COLOR										0x1004 /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_BORDER											0x1005 /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_RED_SIZE											0x805C /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_GREEN_SIZE										0x805D /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_BLUE_SIZE										0x805E /**< @brief OpenGL 1.0 enum (get texture parameter) */
#define GL_TEXTURE_ALPHA_SIZE										0x805F /**< @brief OpenGL 1.0 enum (get texture parameter) */
/* HintMode */
#define GL_DONT_CARE												0x1100 /**< @brief OpenGL 1.0 enum (hint mode) */
#define GL_FASTEST													0x1101 /**< @brief OpenGL 1.0 enum (hint mode) */
#define GL_NICEST													0x1102 /**< @brief OpenGL 1.0 enum (hint mode) */
/* DataType */
#define GL_BYTE														0x1400 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_UNSIGNED_BYTE											0x1401 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_SHORT													0x1402 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_UNSIGNED_SHORT											0x1403 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_INT														0x1404 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_UNSIGNED_INT												0x1405 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_FLOAT													0x1406 /**< @brief OpenGL 1.0 enum (data type) */
#define GL_DOUBLE													0x140A /**< @brief OpenGL 1.0 enum (data type) */
/* LogicOp */
#define GL_CLEAR													0x1500 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_AND														0x1501 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_AND_REVERSE												0x1502 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_COPY														0x1503 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_AND_INVERTED												0x1504 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_NOOP														0x1505 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_XOR														0x1506 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_OR														0x1507 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_NOR														0x1508 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_EQUIV													0x1509 /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_INVERT													0x150A /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_OR_REVERSE												0x150B /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_COPY_INVERTED											0x150C /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_OR_INVERTED												0x150D /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_NAND														0x150E /**< @brief OpenGL 1.0 enum (logic op) */
#define GL_SET														0x150F /**< @brief OpenGL 1.0 enum (logic op) */
/* MatrixMode (for gl3.h, FBO attachment type) */
#define GL_TEXTURE													0x1702 /**< @brief OpenGL 1.0 enum (matrix mode) */
/* PixelCopyType */
#define GL_COLOR													0x1800 /**< @brief OpenGL 1.0 enum (pixel copy type) */
#define GL_DEPTH													0x1801 /**< @brief OpenGL 1.0 enum (pixel copy type) */
#define GL_STENCIL													0x1802 /**< @brief OpenGL 1.0 enum (pixel copy type) */
/* PixelFormat */
#define GL_STENCIL_INDEX											0x1901 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_DEPTH_COMPONENT											0x1902 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_RED														0x1903 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_GREEN													0x1904 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_BLUE														0x1905 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_ALPHA													0x1906 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_RGB														0x1907 /**< @brief OpenGL 1.0 enum (pixel format) */
#define GL_RGBA														0x1908 /**< @brief OpenGL 1.0 enum (pixel format) */
/* PolygonMode */
#define GL_POINT													0x1B00 /**< @brief OpenGL 1.0 enum (polygon mode) */
#define GL_LINE														0x1B01 /**< @brief OpenGL 1.0 enum (polygon mode) */
#define GL_FILL														0x1B02 /**< @brief OpenGL 1.0 enum (polygon mode) */
/* StencilOp */
#define GL_KEEP														0x1E00 /**< @brief OpenGL 1.0 enum (stencil op) */
#define GL_REPLACE													0x1E01 /**< @brief OpenGL 1.0 enum (stencil op) */
#define GL_INCR														0x1E02 /**< @brief OpenGL 1.0 enum (stencil op) */
#define GL_DECR														0x1E03 /**< @brief OpenGL 1.0 enum (stencil op) */
/* StringName */
#define GL_VENDOR													0x1F00 /**< @brief OpenGL 1.0 enum (string name) */
#define GL_RENDERER													0x1F01 /**< @brief OpenGL 1.0 enum (string name) */
#define GL_VERSION													0x1F02 /**< @brief OpenGL 1.0 enum (string name) */
#define GL_EXTENSIONS												0x1F03 /**< @brief OpenGL 1.0 enum (string name) */
/* TextureMagFilter */
#define GL_NEAREST													0x2600 /**< @brief OpenGL 1.0 enum (texture mag filter) */
#define GL_LINEAR													0x2601 /**< @brief OpenGL 1.0 enum (texture mag filter) */
/* TextureMinFilter */
#define GL_NEAREST_MIPMAP_NEAREST									0x2700 /**< @brief OpenGL 1.0 enum (texture min filter) */
#define GL_LINEAR_MIPMAP_NEAREST									0x2701 /**< @brief OpenGL 1.0 enum (texture min filter) */
#define GL_NEAREST_MIPMAP_LINEAR									0x2702 /**< @brief OpenGL 1.0 enum (texture min filter) */
#define GL_LINEAR_MIPMAP_LINEAR										0x2703 /**< @brief OpenGL 1.0 enum (texture min filter) */
/* TextureParameterName */
#define GL_TEXTURE_MAG_FILTER										0x2800 /**< @brief OpenGL 1.0 enum (texture parameter name) */
#define GL_TEXTURE_MIN_FILTER										0x2801 /**< @brief OpenGL 1.0 enum (texture parameter name) */
#define GL_TEXTURE_WRAP_S											0x2802 /**< @brief OpenGL 1.0 enum (texture parameter name) */
#define GL_TEXTURE_WRAP_T											0x2803 /**< @brief OpenGL 1.0 enum (texture parameter name) */
/* TextureTarget */
#define GL_PROXY_TEXTURE_1D											0x8063 /**< @brief OpenGL 1.0 enum (texture target) */
#define GL_PROXY_TEXTURE_2D											0x8064 /**< @brief OpenGL 1.0 enum (texture target) */
/* TextureWrapMode */
#define GL_REPEAT													0x2901 /**< @brief OpenGL 1.0 enum (texture wrap mode) */
/* PixelInternalFormat */
#define GL_R3_G3_B2													0x2A10 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB4														0x804F /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB5														0x8050 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB8														0x8051 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB10													0x8052 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB12													0x8053 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB16													0x8054 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGBA2													0x8055 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGBA4													0x8056 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB5_A1													0x8057 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGBA8													0x8058 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGB10_A2													0x8059 /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGBA12													0x805A /**< @brief OpenGL 1.0 enum (pixel internal format) */
#define GL_RGBA16													0x805B /**< @brief OpenGL 1.0 enum (pixel internal format) */

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
 *	@brief specify whether front- or back-facing facets can be culled
 *	@param[in] mode Specifies whether front- or back-facing facets are candidates for culling.
 *		Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value
 *		is GL_BACK.
 */
GLStaticApi void ApiEntry glCullFace(GLenum mode);

/**
 *	@brief define front- and back-facing polygons
 *	@param[in] mode Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are
 *		accepted. The initial value is GL_CCW.
 */
GLStaticApi void ApiEntry glFrontFace(GLenum mode);

/**
 *	@brief specify implementation-specific hints
 *	@param[in] target Specifies a symbolic constant indicating the behavior to be controlled.
 *		GL_LINE_SMOOTH_HINT, GL_POLYGON_SMOOTH_HINT, GL_TEXTURE_COMPRESSION_HINT, and
 *		GL_FRAGMENT_SHADER_DERIVATIVE_HINT are accepted.
 *	@param[in] mode Specifies a symbolic constant indicating the desired behavior. GL_FASTEST,
 *		GL_NICEST, and GL_DONT_CARE are accepted.
 */
GLStaticApi void ApiEntry glHint(GLenum target, GLenum mode);

/**
 *	@brief specify the width of rasterized lines
 *	@param[in] width Specifies the width of rasterized lines. The initial value is 1.
 */
GLStaticApi void ApiEntry glLineWidth(float width);

/**
 *	@brief specify the diameter of rasterized points
 *	@param[in] size Specifies the diameter of rasterized points. The initial value is 1.
 */
GLStaticApi void ApiEntry glPointSize(float size);

/**
 *	@brief select a polygon rasterization mode
 *	@param[in] face Specifies the polygons that mode applies to. Must be GL_FRONT_AND_BACK for
 *		front- and back-facing polygons.
 *	@param[in] mode Specifies how polygons will be rasterized. Accepted values are GL_POINT,
 *		GL_LINE, and GL_FILL. The initial value is GL_FILL for both front- and back-facing polygons.
 */
GLStaticApi void ApiEntry glPolygonMode(GLenum face, GLenum mode);

/**
 *	@brief define the scissor box
 *	@param[in] x Specify the lower left corner of the scissor box. Initially (0, 0).
 *	@param[in] y Specify the lower left corner of the scissor box. Initially (0, 0).
 *	@param[in] width Specify the width and height of the scissor box. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 *	@param[in] height Specify the width and height of the scissor box. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 */
GLStaticApi void ApiEntry glScissor(int x, int y, GLsizei width, GLsizei height);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a single-valued texture parameter. pname can be
 *		one of the following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] param Specifies the value of pname.
 */
GLStaticApi void ApiEntry glTexParameterf(GLenum target, GLenum pname, float param);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
GLStaticApi void ApiEntry glTexParameterfv(GLenum target, GLenum pname, const float *params);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a single-valued texture parameter. pname can be
 *		one of the following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] param Specifies the value of pname.
 */
GLStaticApi void ApiEntry glTexParameteri(GLenum target, GLenum pname, int param);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
GLStaticApi void ApiEntry glTexParameteriv(GLenum target, GLenum pname, const int *params);

/**
 *	@brief specify a one-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA, GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA, GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_R3_G3_B2, GL_RED,
 *		GL_RG, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 1024 texels wide. The height of the 1D texture image is 1.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
GLStaticApi void ApiEntry glTexImage1D(GLenum target, int level, int internalFormat, GLsizei width, int border, GLenum format, GLenum type, const void *data);

/**
 *	@brief specify a two-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D,
 *		GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_PROXY_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image. If target is GL_TEXTURE_RECTANGLE or
 *		GL_PROXY_TEXTURE_RECTANGLE, level must be 0.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA, GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA, GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_R3_G3_B2, GL_RED,
 *		GL_RG, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 1024 texels wide.
 *	@param[in] height Specifies the height of the texture image, or the number of layers in a
 *		texture array, in the case of the GL_TEXTURE_1D_ARRAY and GL_PROXY_TEXTURE_1D_ARRAY targets.
 *		All implementations support 2D texture images that are at least 1024 texels high, and
 *		texture arrays that are at least 256 layers deep.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
GLStaticApi void ApiEntry glTexImage2D(GLenum target, int level, int internalFormat, GLsizei width, GLsizei height, int border, GLenum format, GLenum type, const void *data);

/**
 *	@brief specify which color buffers are to be drawn into
 *	@param[in] mode Specifies up to four color buffers to be drawn into. Symbolic constants GL_NONE,
 *		GL_FRONT_LEFT, GL_FRONT_RIGHT, GL_BACK_LEFT, GL_BACK_RIGHT, GL_FRONT, GL_BACK, GL_LEFT,
 *		GL_RIGHT, and GL_FRONT_AND_BACK are accepted. The initial value is GL_FRONT for
 *		single-buffered contexts, and GL_BACK for double-buffered contexts.
 */
GLStaticApi void ApiEntry glDrawBuffer(GLenum mode);

/**
 *	@brief clear buffers to preset values
 *	@param[in] mask Bitwise OR of masks that indicate the buffers to be cleared. The three masks are
 *		GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
 */
GLStaticApi void ApiEntry glClear(GLbitfield mask);

/**
 *	@brief specify clear values for the color buffers
 *	@param[in] red Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] green Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] blue Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] alpha Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 */
GLStaticApi void ApiEntry glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);

/**
 *	@brief specify the clear value for the stencil buffer
 *	@param[in] s Specifies the index used when the stencil buffer is cleared. The initial value is 0.
 */
GLStaticApi void ApiEntry glClearStencil(int s);

/**
 *	@brief specify the clear value for the depth buffer
 *	@param[in] depth Specifies the depth value used when the depth buffer is cleared. The initial
 *		value is 1.
 */
GLStaticApi void ApiEntry glClearDepth(GLclampd depth);

/**
 *	@brief control the front and back writing of individual bits in the stencil planes
 *	@param[in] mask Specifies a bit mask to enable and disable writing of individual bits in the
 *		stencil planes. Initially, the mask is all 1's.
 */
GLStaticApi void ApiEntry glStencilMask(GLuint mask);

/**
 *	@brief enable and disable writing of frame buffer color components
 *	@param[in] red Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] green Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] blue Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] alpha Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 */
GLStaticApi void ApiEntry glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);

/**
 *	@brief enable or disable writing into the depth buffer
 *	@param[in] flag Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE,
 *		depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing
 *		is enabled.
 */
GLStaticApi void ApiEntry glDepthMask(GLboolean flag);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
GLStaticApi void ApiEntry glDisable(GLenum cap);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
GLStaticApi void ApiEntry glEnable(GLenum cap);

/**
 *	@brief block until all GL execution is complete
 */
GLStaticApi void ApiEntry glFinish();

/**
 *	@brief force execution of GL commands in finite time
 */
GLStaticApi void ApiEntry glFlush();

/**
 *	@brief specify pixel arithmetic
 *	@param[in] sfactor Specifies how the red, green, blue, and alpha source blending factors are
 *		computed. The initial value is GL_ONE.
 *	@param[in] dfactor Specifies how the red, green, blue, and alpha destination blending factors
 *		are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR,
 *		GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA,
 *		GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR,
 *		GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial
 *		value is GL_ZERO.
 */
GLStaticApi void ApiEntry glBlendFunc(GLenum sfactor, GLenum dfactor);

/**
 *	@brief specify a logical pixel operation for rendering
 *	@param[in] opcode Specifies a symbolic constant that selects a logical operation. The following
 *		symbols are accepted: GL_CLEAR, GL_SET, GL_COPY, GL_COPY_INVERTED, GL_NOOP, GL_INVERT,
 *		GL_AND, GL_NAND, GL_OR, GL_NOR, GL_XOR, GL_EQUIV, GL_AND_REVERSE, GL_AND_INVERTED,
 *		GL_OR_REVERSE, and GL_OR_INVERTED. The initial value is GL_COPY.
 */
GLStaticApi void ApiEntry glLogicOp(GLenum opcode);

/**
 *	@brief set front and back function and reference value for stencil testing
 *	@param[in] func Specifies the test function. Eight symbolic constants are valid: GL_NEVER,
 *		GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial
 *		value is GL_ALWAYS.
 *	@param[in] ref Specifies the reference value for the stencil test. ref is clamped to the range 0
 *		2 n - 1, where n is the number of bitplanes in the stencil buffer. The initial value is 0.
 *	@param[in] mask Specifies a mask that is ANDed with both the reference value and the stored
 *		stencil value when the test is done. The initial value is all 1's.
 */
GLStaticApi void ApiEntry glStencilFunc(GLenum func, int ref, GLuint mask);

/**
 *	@brief set front and back stencil test actions
 *	@param[in] sfail Specifies the action to take when the stencil test fails. Eight symbolic
 *		constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR,
 *		GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
 *	@param[in] dpfail Specifies the stencil action when the stencil test passes, but the depth test
 *		fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 *	@param[in] dppass Specifies the stencil action when both the stencil test and the depth test
 *		pass, or when the stencil test passes and either there is no depth buffer or depth testing
 *		is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 */
GLStaticApi void ApiEntry glStencilOp(GLenum sfail, GLenum dpfail, GLenum dppass);

/**
 *	@brief specify the value used for depth buffer comparisons
 *	@param[in] func Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS,
 *		GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The
 *		initial value is GL_LESS.
 */
GLStaticApi void ApiEntry glDepthFunc(GLenum func);

/**
 *	@brief set pixel storage modes
 *	@param[in] pname Specifies the symbolic name of the parameter to be set. Six values affect the
 *		packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST,
 *		GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS,
 *		GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from
 *		memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH,
 *		GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES,
 *		and GL_UNPACK_ALIGNMENT.
 *	@param[in] param Specifies the value that pname is set to.
 */
GLStaticApi void ApiEntry glPixelStoref(GLenum pname, float param);

/**
 *	@brief set pixel storage modes
 *	@param[in] pname Specifies the symbolic name of the parameter to be set. Six values affect the
 *		packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST,
 *		GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS,
 *		GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from
 *		memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH,
 *		GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES,
 *		and GL_UNPACK_ALIGNMENT.
 *	@param[in] param Specifies the value that pname is set to.
 */
GLStaticApi void ApiEntry glPixelStorei(GLenum pname, int param);

/**
 *	@brief select a color buffer source for pixels
 *	@param[in] mode Specifies a color buffer. Accepted values are GL_FRONT_LEFT, GL_FRONT_RIGHT,
 *		GL_BACK_LEFT, GL_BACK_RIGHT, GL_FRONT, GL_BACK, GL_LEFT, and GL_RIGHT.
 */
GLStaticApi void ApiEntry glReadBuffer(GLenum mode);

/**
 *	@brief read a block of pixels from the frame buffer
 *	@param[in] x Specify the window coordinates of the first pixel that is read from the frame
 *		buffer. This location is the lower left corner of a rectangular block of pixels.
 *	@param[in] y Specify the window coordinates of the first pixel that is read from the frame
 *		buffer. This location is the lower left corner of a rectangular block of pixels.
 *	@param[in] width Specify the dimensions of the pixel rectangle. width and height of one
 *		correspond to a single pixel.
 *	@param[in] height Specify the dimensions of the pixel rectangle. width and height of one
 *		correspond to a single pixel.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_DEPTH_STENCIL, GL_RED, GL_GREEN, GL_BLUE,
 *		GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE,
 *		GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_HALF_FLOAT, GL_FLOAT,
 *		GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, GL_UNSIGNED_INT_2_10_10_10_REV,
 *		GL_UNSIGNED_INT_24_8, GL_UNSIGNED_INT_10F_11F_11F_REV, GL_UNSIGNED_INT_5_9_9_9_REV, or GL_FLOAT_32_UNSIGNED_INT_24_8_REV.
 *	@param[out] data Returns the pixel data.
 */
GLStaticApi void ApiEntry glReadPixels(int x, int y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *data);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
GLStaticApi void ApiEntry glGetBooleanv(GLenum pname, GLboolean *params);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
GLStaticApi void ApiEntry glGetDoublev(GLenum pname, double *params);

/**
 *	@brief return error information
 */
GLStaticApi GLenum ApiEntry glGetError();

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
GLStaticApi void ApiEntry glGetFloatv(GLenum pname, float *params);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
GLStaticApi void ApiEntry glGetIntegerv(GLenum pname, int *params);

/**
 *	@brief return a string describing the current GL connection
 *	@param[in] name Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, or
 *		GL_SHADING_LANGUAGE_VERSION. Additionally, glGetStringi accepts the GL_EXTENSIONS token.
 */
GLStaticApi const GLubyte *ApiEntry glGetString(GLenum name);

/**
 *	@brief return a texture image
 *	@param[in] target Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D,
 *		GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] format Specifies a pixel format for the returned data. The supported formats are
 *		GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_DEPTH_STENCIL, GL_RED, GL_GREEN, GL_BLUE, GL_RG,
 *		GL_RGB, GL_RGBA, GL_BGR, GL_BGRA, GL_RED_INTEGER, GL_GREEN_INTEGER, GL_BLUE_INTEGER,
 *		GL_RG_INTEGER, GL_RGB_INTEGER, GL_RGBA_INTEGER, GL_BGR_INTEGER, GL_BGRA_INTEGER.
 *	@param[in] type Specifies a pixel type for the returned data. The supported types are
 *		GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_HALF_FLOAT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV,
 *		GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4,
 *		GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV,
 *		GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2,
 *		GL_UNSIGNED_INT_2_10_10_10_REV, GL_UNSIGNED_INT_24_8, GL_UNSIGNED_INT_10F_11F_11F_REV,
 *		GL_UNSIGNED_INT_5_9_9_9_REV, and GL_FLOAT_32_UNSIGNED_INT_24_8_REV.
 *	@param[out] img Returns the texture image. Should be a pointer to an array of the type specified
 *		by type.
 */
GLStaticApi void ApiEntry glGetTexImage(GLenum target, int level, GLenum format, GLenum type, void *img);

/**
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
GLStaticApi void ApiEntry glGetTexParameterfv(GLenum target, GLenum pname, float *params);

/**
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
GLStaticApi void ApiEntry glGetTexParameteriv(GLenum target, GLenum pname, int *params);

/**
 *	@brief return texture parameter values for a specific level of detail
 *	@param[in] target Specifies the symbolic name of the target texture, one of GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_2D_MULTISAMPLE, GL_TEXTURE_2D_MULTISAMPLE_ARRAY,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, GL_PROXY_TEXTURE_1D,
 *		GL_PROXY_TEXTURE_2D, GL_PROXY_TEXTURE_3D, GL_PROXY_TEXTURE_1D_ARRAY,
 *		GL_PROXY_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_RECTANGLE, GL_PROXY_TEXTURE_2D_MULTISAMPLE,
 *		GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, GL_PROXY_TEXTURE_CUBE_MAP, or GL_TEXTURE_BUFFER.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_WIDTH,
 *		GL_TEXTURE_HEIGHT, GL_TEXTURE_DEPTH, GL_TEXTURE_INTERNAL_FORMAT, GL_TEXTURE_BORDER,
 *		GL_TEXTURE_RED_SIZE, GL_TEXTURE_GREEN_SIZE, GL_TEXTURE_BLUE_SIZE, GL_TEXTURE_ALPHA_SIZE,
 *		GL_TEXTURE_DEPTH_SIZE, GL_TEXTURE_COMPRESSED, and GL_TEXTURE_COMPRESSED_IMAGE_SIZE are accepted.
 *	@param[out] params Returns the requested data.
 */
GLStaticApi void ApiEntry glGetTexLevelParameterfv(GLenum target, int level, GLenum pname, float *params);

/**
 *	@brief return texture parameter values for a specific level of detail
 *	@param[in] target Specifies the symbolic name of the target texture, one of GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_2D_MULTISAMPLE, GL_TEXTURE_2D_MULTISAMPLE_ARRAY,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, GL_PROXY_TEXTURE_1D,
 *		GL_PROXY_TEXTURE_2D, GL_PROXY_TEXTURE_3D, GL_PROXY_TEXTURE_1D_ARRAY,
 *		GL_PROXY_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_RECTANGLE, GL_PROXY_TEXTURE_2D_MULTISAMPLE,
 *		GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, GL_PROXY_TEXTURE_CUBE_MAP, or GL_TEXTURE_BUFFER.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_WIDTH,
 *		GL_TEXTURE_HEIGHT, GL_TEXTURE_DEPTH, GL_TEXTURE_INTERNAL_FORMAT, GL_TEXTURE_BORDER,
 *		GL_TEXTURE_RED_SIZE, GL_TEXTURE_GREEN_SIZE, GL_TEXTURE_BLUE_SIZE, GL_TEXTURE_ALPHA_SIZE,
 *		GL_TEXTURE_DEPTH_SIZE, GL_TEXTURE_COMPRESSED, and GL_TEXTURE_COMPRESSED_IMAGE_SIZE are accepted.
 *	@param[out] params Returns the requested data.
 */
GLStaticApi void ApiEntry glGetTexLevelParameteriv(GLenum target, int level, GLenum pname, int *params);

/**
 *	@brief test whether a capability is enabled
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
GLStaticApi GLboolean ApiEntry glIsEnabled(GLenum cap);

/**
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates
 *	@param[in] nearVal Specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0.
 *	@param[in] farVal Specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1.
 */
GLStaticApi void ApiEntry glDepthRange(GLclampd nearVal, GLclampd farVal);

/**
 *	@brief set the viewport
 *	@param[in] x Specify the lower left corner of the viewport rectangle, in pixels. The initial
 *		value is (0,0).
 *	@param[in] y Specify the lower left corner of the viewport rectangle, in pixels. The initial
 *		value is (0,0).
 *	@param[in] width Specify the width and height of the viewport. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 *	@param[in] height Specify the width and height of the viewport. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 */
GLStaticApi void ApiEntry glViewport(int x, int y, GLsizei width, GLsizei height);

#ifdef __cplusplus
}
#endif // __cplusplus

#ifdef __HAVE_GL_AUTOCHECK

inline void glCullFace_glachwrap(GLenum mode) { glCullFace(mode); }
inline void glFrontFace_glachwrap(GLenum mode) { glFrontFace(mode); }
inline void glHint_glachwrap(GLenum target, GLenum mode) { glHint(target,mode); }
inline void glLineWidth_glachwrap(float width) { glLineWidth(width); }
inline void glPointSize_glachwrap(float size) { glPointSize(size); }
inline void glPolygonMode_glachwrap(GLenum face, GLenum mode) { glPolygonMode(face,mode); }
inline void glScissor_glachwrap(int x, int y, GLsizei width, GLsizei height) { glScissor(x,y,width,height); }
inline void glTexParameterf_glachwrap(GLenum target, GLenum pname, float param) { glTexParameterf(target,pname,param); }
inline void glTexParameterfv_glachwrap(GLenum target, GLenum pname, const float *params) { glTexParameterfv(target,pname,params); }
inline void glTexParameteri_glachwrap(GLenum target, GLenum pname, int param) { glTexParameteri(target,pname,param); }
inline void glTexParameteriv_glachwrap(GLenum target, GLenum pname, const int *params) { glTexParameteriv(target,pname,params); }
inline void glTexImage1D_glachwrap(GLenum target, int level, int internalFormat, GLsizei width, int border, GLenum format, GLenum type, const void *data) { glTexImage1D(target,level,internalFormat,width,border,format,type,data); }
inline void glTexImage2D_glachwrap(GLenum target, int level, int internalFormat, GLsizei width, GLsizei height, int border, GLenum format, GLenum type, const void *data) { glTexImage2D(target,level,internalFormat,width,height,border,format,type,data); }
inline void glDrawBuffer_glachwrap(GLenum mode) { glDrawBuffer(mode); }
inline void glClear_glachwrap(GLbitfield mask) { glClear(mask); }
inline void glClearColor_glachwrap(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) { glClearColor(red,green,blue,alpha); }
inline void glClearStencil_glachwrap(int s) { glClearStencil(s); }
inline void glClearDepth_glachwrap(GLclampd depth) { glClearDepth(depth); }
inline void glStencilMask_glachwrap(GLuint mask) { glStencilMask(mask); }
inline void glColorMask_glachwrap(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) { glColorMask(red,green,blue,alpha); }
inline void glDepthMask_glachwrap(GLboolean flag) { glDepthMask(flag); }
inline void glDisable_glachwrap(GLenum cap) { glDisable(cap); }
inline void glEnable_glachwrap(GLenum cap) { glEnable(cap); }
inline void glFinish_glachwrap() { glFinish(); }
inline void glFlush_glachwrap() { glFlush(); }
inline void glBlendFunc_glachwrap(GLenum sfactor, GLenum dfactor) { glBlendFunc(sfactor,dfactor); }
inline void glLogicOp_glachwrap(GLenum opcode) { glLogicOp(opcode); }
inline void glStencilFunc_glachwrap(GLenum func, int ref, GLuint mask) { glStencilFunc(func,ref,mask); }
inline void glStencilOp_glachwrap(GLenum sfail, GLenum dpfail, GLenum dppass) { glStencilOp(sfail,dpfail,dppass); }
inline void glDepthFunc_glachwrap(GLenum func) { glDepthFunc(func); }
inline void glPixelStoref_glachwrap(GLenum pname, float param) { glPixelStoref(pname,param); }
inline void glPixelStorei_glachwrap(GLenum pname, int param) { glPixelStorei(pname,param); }
inline void glReadBuffer_glachwrap(GLenum mode) { glReadBuffer(mode); }
inline void glReadPixels_glachwrap(int x, int y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *data) { glReadPixels(x,y,width,height,format,type,data); }
inline void glGetBooleanv_glachwrap(GLenum pname, GLboolean *params) { glGetBooleanv(pname,params); }
inline void glGetDoublev_glachwrap(GLenum pname, double *params) { glGetDoublev(pname,params); }
//inline GLenum glGetError_glachwrap(const char *p_s_filename, int n_line) { GLenum result = glGetError(); GL_AUTOCHECK_BLOCK("glGetError", p_s_filename, n_line); return result; }
inline void glGetFloatv_glachwrap(GLenum pname, float *params) { glGetFloatv(pname,params); }
inline void glGetIntegerv_glachwrap(GLenum pname, int *params) { glGetIntegerv(pname,params); }
inline const GLubyte *glGetString_glachwrap(GLenum name, const char *p_s_filename, int n_line) { const GLubyte *result = glGetString(name); GL_AUTOCHECK_BLOCK("glGetString", p_s_filename, n_line); return result; }
inline void glGetTexImage_glachwrap(GLenum target, int level, GLenum format, GLenum type, void *img) { glGetTexImage(target,level,format,type,img); }
inline void glGetTexParameterfv_glachwrap(GLenum target, GLenum pname, float *params) { glGetTexParameterfv(target,pname,params); }
inline void glGetTexParameteriv_glachwrap(GLenum target, GLenum pname, int *params) { glGetTexParameteriv(target,pname,params); }
inline void glGetTexLevelParameterfv_glachwrap(GLenum target, int level, GLenum pname, float *params) { glGetTexLevelParameterfv(target,level,pname,params); }
inline void glGetTexLevelParameteriv_glachwrap(GLenum target, int level, GLenum pname, int *params) { glGetTexLevelParameteriv(target,level,pname,params); }
inline GLboolean glIsEnabled_glachwrap(GLenum cap, const char *p_s_filename, int n_line) { GLboolean result = glIsEnabled(cap); GL_AUTOCHECK_BLOCK("glIsEnabled", p_s_filename, n_line); return result; }
inline void glDepthRange_glachwrap(GLclampd nearVal, GLclampd farVal) { glDepthRange(nearVal,farVal); }
inline void glViewport_glachwrap(int x, int y, GLsizei width, GLsizei height) { glViewport(x,y,width,height); }

/**
 *	@def glCullFace
 *	@brief specify whether front- or back-facing facets can be culled
 *	@param[in] mode Specifies whether front- or back-facing facets are candidates for culling.
 *		Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value
 *		is GL_BACK.
 */
#define glCullFace(mode) do { glCullFace_glachwrap(mode); GL_AUTOCHECK_BLOCK("glCullFace", __FILE__, __LINE__); } while(0)

/**
 *	@def glFrontFace
 *	@brief define front- and back-facing polygons
 *	@param[in] mode Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are
 *		accepted. The initial value is GL_CCW.
 */
#define glFrontFace(mode) do { glFrontFace_glachwrap(mode); GL_AUTOCHECK_BLOCK("glFrontFace", __FILE__, __LINE__); } while(0)

/**
 *	@def glHint
 *	@brief specify implementation-specific hints
 *	@param[in] target Specifies a symbolic constant indicating the behavior to be controlled.
 *		GL_LINE_SMOOTH_HINT, GL_POLYGON_SMOOTH_HINT, GL_TEXTURE_COMPRESSION_HINT, and
 *		GL_FRAGMENT_SHADER_DERIVATIVE_HINT are accepted.
 *	@param[in] mode Specifies a symbolic constant indicating the desired behavior. GL_FASTEST,
 *		GL_NICEST, and GL_DONT_CARE are accepted.
 */
#define glHint(target,mode) do { glHint_glachwrap(target, mode); GL_AUTOCHECK_BLOCK("glHint", __FILE__, __LINE__); } while(0)

/**
 *	@def glLineWidth
 *	@brief specify the width of rasterized lines
 *	@param[in] width Specifies the width of rasterized lines. The initial value is 1.
 */
#define glLineWidth(width) do { glLineWidth_glachwrap(width); GL_AUTOCHECK_BLOCK("glLineWidth", __FILE__, __LINE__); } while(0)

/**
 *	@def glPointSize
 *	@brief specify the diameter of rasterized points
 *	@param[in] size Specifies the diameter of rasterized points. The initial value is 1.
 */
#define glPointSize(size) do { glPointSize_glachwrap(size); GL_AUTOCHECK_BLOCK("glPointSize", __FILE__, __LINE__); } while(0)

/**
 *	@def glPolygonMode
 *	@brief select a polygon rasterization mode
 *	@param[in] face Specifies the polygons that mode applies to. Must be GL_FRONT_AND_BACK for
 *		front- and back-facing polygons.
 *	@param[in] mode Specifies how polygons will be rasterized. Accepted values are GL_POINT,
 *		GL_LINE, and GL_FILL. The initial value is GL_FILL for both front- and back-facing polygons.
 */
#define glPolygonMode(face,mode) do { glPolygonMode_glachwrap(face, mode); GL_AUTOCHECK_BLOCK("glPolygonMode", __FILE__, __LINE__); } while(0)

/**
 *	@def glScissor
 *	@brief define the scissor box
 *	@param[in] x Specify the lower left corner of the scissor box. Initially (0, 0).
 *	@param[in] y Specify the lower left corner of the scissor box. Initially (0, 0).
 *	@param[in] width Specify the width and height of the scissor box. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 *	@param[in] height Specify the width and height of the scissor box. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 */
#define glScissor(x,y,width,height) do { glScissor_glachwrap(x, y, width, height); GL_AUTOCHECK_BLOCK("glScissor", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameterf
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a single-valued texture parameter. pname can be
 *		one of the following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] param Specifies the value of pname.
 */
#define glTexParameterf(target,pname,param) do { glTexParameterf_glachwrap(target, pname, param); GL_AUTOCHECK_BLOCK("glTexParameterf", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameterfv
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
#define glTexParameterfv(target,pname,params) do { glTexParameterfv_glachwrap(target, pname, params); GL_AUTOCHECK_BLOCK("glTexParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameteri
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a single-valued texture parameter. pname can be
 *		one of the following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] param Specifies the value of pname.
 */
#define glTexParameteri(target,pname,param) do { glTexParameteri_glachwrap(target, pname, param); GL_AUTOCHECK_BLOCK("glTexParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameteriv
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
#define glTexParameteriv(target,pname,params) do { glTexParameteriv_glachwrap(target, pname, params); GL_AUTOCHECK_BLOCK("glTexParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexImage1D
 *	@brief specify a one-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA, GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA, GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_R3_G3_B2, GL_RED,
 *		GL_RG, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 1024 texels wide. The height of the 1D texture image is 1.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexImage1D(target,level,internalFormat,width,border,format,type,data) do { glTexImage1D_glachwrap(target, level, internalFormat, width, border, format, type, data); GL_AUTOCHECK_BLOCK("glTexImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexImage2D
 *	@brief specify a two-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D,
 *		GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_PROXY_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image. If target is GL_TEXTURE_RECTANGLE or
 *		GL_PROXY_TEXTURE_RECTANGLE, level must be 0.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA, GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA, GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_R3_G3_B2, GL_RED,
 *		GL_RG, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 1024 texels wide.
 *	@param[in] height Specifies the height of the texture image, or the number of layers in a
 *		texture array, in the case of the GL_TEXTURE_1D_ARRAY and GL_PROXY_TEXTURE_1D_ARRAY targets.
 *		All implementations support 2D texture images that are at least 1024 texels high, and
 *		texture arrays that are at least 256 layers deep.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexImage2D(target,level,internalFormat,width,height,border,format,type,data) do { glTexImage2D_glachwrap(target, level, internalFormat, width, height, border, format, type, data); GL_AUTOCHECK_BLOCK("glTexImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawBuffer
 *	@brief specify which color buffers are to be drawn into
 *	@param[in] mode Specifies up to four color buffers to be drawn into. Symbolic constants GL_NONE,
 *		GL_FRONT_LEFT, GL_FRONT_RIGHT, GL_BACK_LEFT, GL_BACK_RIGHT, GL_FRONT, GL_BACK, GL_LEFT,
 *		GL_RIGHT, and GL_FRONT_AND_BACK are accepted. The initial value is GL_FRONT for
 *		single-buffered contexts, and GL_BACK for double-buffered contexts.
 */
#define glDrawBuffer(mode) do { glDrawBuffer_glachwrap(mode); GL_AUTOCHECK_BLOCK("glDrawBuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glClear
 *	@brief clear buffers to preset values
 *	@param[in] mask Bitwise OR of masks that indicate the buffers to be cleared. The three masks are
 *		GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
 */
#define glClear(mask) do { glClear_glachwrap(mask); GL_AUTOCHECK_BLOCK("glClear", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearColor
 *	@brief specify clear values for the color buffers
 *	@param[in] red Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] green Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] blue Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 *	@param[in] alpha Specify the red, green, blue, and alpha values used when the color buffers are
 *		cleared. The initial values are all 0.
 */
#define glClearColor(red,green,blue,alpha) do { glClearColor_glachwrap(red, green, blue, alpha); GL_AUTOCHECK_BLOCK("glClearColor", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearStencil
 *	@brief specify the clear value for the stencil buffer
 *	@param[in] s Specifies the index used when the stencil buffer is cleared. The initial value is 0.
 */
#define glClearStencil(s) do { glClearStencil_glachwrap(s); GL_AUTOCHECK_BLOCK("glClearStencil", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearDepth
 *	@brief specify the clear value for the depth buffer
 *	@param[in] depth Specifies the depth value used when the depth buffer is cleared. The initial
 *		value is 1.
 */
#define glClearDepth(depth) do { glClearDepth_glachwrap(depth); GL_AUTOCHECK_BLOCK("glClearDepth", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilMask
 *	@brief control the front and back writing of individual bits in the stencil planes
 *	@param[in] mask Specifies a bit mask to enable and disable writing of individual bits in the
 *		stencil planes. Initially, the mask is all 1's.
 */
#define glStencilMask(mask) do { glStencilMask_glachwrap(mask); GL_AUTOCHECK_BLOCK("glStencilMask", __FILE__, __LINE__); } while(0)

/**
 *	@def glColorMask
 *	@brief enable and disable writing of frame buffer color components
 *	@param[in] red Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] green Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] blue Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] alpha Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 */
#define glColorMask(red,green,blue,alpha) do { glColorMask_glachwrap(red, green, blue, alpha); GL_AUTOCHECK_BLOCK("glColorMask", __FILE__, __LINE__); } while(0)

/**
 *	@def glDepthMask
 *	@brief enable or disable writing into the depth buffer
 *	@param[in] flag Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE,
 *		depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing
 *		is enabled.
 */
#define glDepthMask(flag) do { glDepthMask_glachwrap(flag); GL_AUTOCHECK_BLOCK("glDepthMask", __FILE__, __LINE__); } while(0)

/**
 *	@def glDisable
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
#define glDisable(cap) do { glDisable_glachwrap(cap); GL_AUTOCHECK_BLOCK("glDisable", __FILE__, __LINE__); } while(0)

/**
 *	@def glEnable
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
#define glEnable(cap) do { glEnable_glachwrap(cap); GL_AUTOCHECK_BLOCK("glEnable", __FILE__, __LINE__); } while(0)

/**
 *	@def glFinish
 *	@brief block until all GL execution is complete
 */
#define glFinish() do { glFinish_glachwrap(); GL_AUTOCHECK_BLOCK("glFinish", __FILE__, __LINE__); } while(0)

/**
 *	@def glFlush
 *	@brief force execution of GL commands in finite time
 */
#define glFlush() do { glFlush_glachwrap(); GL_AUTOCHECK_BLOCK("glFlush", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlendFunc
 *	@brief specify pixel arithmetic
 *	@param[in] sfactor Specifies how the red, green, blue, and alpha source blending factors are
 *		computed. The initial value is GL_ONE.
 *	@param[in] dfactor Specifies how the red, green, blue, and alpha destination blending factors
 *		are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR,
 *		GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA,
 *		GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR,
 *		GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial
 *		value is GL_ZERO.
 */
#define glBlendFunc(sfactor,dfactor) do { glBlendFunc_glachwrap(sfactor, dfactor); GL_AUTOCHECK_BLOCK("glBlendFunc", __FILE__, __LINE__); } while(0)

/**
 *	@def glLogicOp
 *	@brief specify a logical pixel operation for rendering
 *	@param[in] opcode Specifies a symbolic constant that selects a logical operation. The following
 *		symbols are accepted: GL_CLEAR, GL_SET, GL_COPY, GL_COPY_INVERTED, GL_NOOP, GL_INVERT,
 *		GL_AND, GL_NAND, GL_OR, GL_NOR, GL_XOR, GL_EQUIV, GL_AND_REVERSE, GL_AND_INVERTED,
 *		GL_OR_REVERSE, and GL_OR_INVERTED. The initial value is GL_COPY.
 */
#define glLogicOp(opcode) do { glLogicOp_glachwrap(opcode); GL_AUTOCHECK_BLOCK("glLogicOp", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilFunc
 *	@brief set front and back function and reference value for stencil testing
 *	@param[in] func Specifies the test function. Eight symbolic constants are valid: GL_NEVER,
 *		GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial
 *		value is GL_ALWAYS.
 *	@param[in] ref Specifies the reference value for the stencil test. ref is clamped to the range 0
 *		2 n - 1, where n is the number of bitplanes in the stencil buffer. The initial value is 0.
 *	@param[in] mask Specifies a mask that is ANDed with both the reference value and the stored
 *		stencil value when the test is done. The initial value is all 1's.
 */
#define glStencilFunc(func,ref,mask) do { glStencilFunc_glachwrap(func, ref, mask); GL_AUTOCHECK_BLOCK("glStencilFunc", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilOp
 *	@brief set front and back stencil test actions
 *	@param[in] sfail Specifies the action to take when the stencil test fails. Eight symbolic
 *		constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR,
 *		GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
 *	@param[in] dpfail Specifies the stencil action when the stencil test passes, but the depth test
 *		fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 *	@param[in] dppass Specifies the stencil action when both the stencil test and the depth test
 *		pass, or when the stencil test passes and either there is no depth buffer or depth testing
 *		is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 */
#define glStencilOp(sfail,dpfail,dppass) do { glStencilOp_glachwrap(sfail, dpfail, dppass); GL_AUTOCHECK_BLOCK("glStencilOp", __FILE__, __LINE__); } while(0)

/**
 *	@def glDepthFunc
 *	@brief specify the value used for depth buffer comparisons
 *	@param[in] func Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS,
 *		GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The
 *		initial value is GL_LESS.
 */
#define glDepthFunc(func) do { glDepthFunc_glachwrap(func); GL_AUTOCHECK_BLOCK("glDepthFunc", __FILE__, __LINE__); } while(0)

/**
 *	@def glPixelStoref
 *	@brief set pixel storage modes
 *	@param[in] pname Specifies the symbolic name of the parameter to be set. Six values affect the
 *		packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST,
 *		GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS,
 *		GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from
 *		memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH,
 *		GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES,
 *		and GL_UNPACK_ALIGNMENT.
 *	@param[in] param Specifies the value that pname is set to.
 */
#define glPixelStoref(pname,param) do { glPixelStoref_glachwrap(pname, param); GL_AUTOCHECK_BLOCK("glPixelStoref", __FILE__, __LINE__); } while(0)

/**
 *	@def glPixelStorei
 *	@brief set pixel storage modes
 *	@param[in] pname Specifies the symbolic name of the parameter to be set. Six values affect the
 *		packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST,
 *		GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS,
 *		GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from
 *		memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH,
 *		GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES,
 *		and GL_UNPACK_ALIGNMENT.
 *	@param[in] param Specifies the value that pname is set to.
 */
#define glPixelStorei(pname,param) do { glPixelStorei_glachwrap(pname, param); GL_AUTOCHECK_BLOCK("glPixelStorei", __FILE__, __LINE__); } while(0)

/**
 *	@def glReadBuffer
 *	@brief select a color buffer source for pixels
 *	@param[in] mode Specifies a color buffer. Accepted values are GL_FRONT_LEFT, GL_FRONT_RIGHT,
 *		GL_BACK_LEFT, GL_BACK_RIGHT, GL_FRONT, GL_BACK, GL_LEFT, and GL_RIGHT.
 */
#define glReadBuffer(mode) do { glReadBuffer_glachwrap(mode); GL_AUTOCHECK_BLOCK("glReadBuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glReadPixels
 *	@brief read a block of pixels from the frame buffer
 *	@param[in] x Specify the window coordinates of the first pixel that is read from the frame
 *		buffer. This location is the lower left corner of a rectangular block of pixels.
 *	@param[in] y Specify the window coordinates of the first pixel that is read from the frame
 *		buffer. This location is the lower left corner of a rectangular block of pixels.
 *	@param[in] width Specify the dimensions of the pixel rectangle. width and height of one
 *		correspond to a single pixel.
 *	@param[in] height Specify the dimensions of the pixel rectangle. width and height of one
 *		correspond to a single pixel.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_DEPTH_STENCIL, GL_RED, GL_GREEN, GL_BLUE,
 *		GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE,
 *		GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_HALF_FLOAT, GL_FLOAT,
 *		GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, GL_UNSIGNED_INT_2_10_10_10_REV,
 *		GL_UNSIGNED_INT_24_8, GL_UNSIGNED_INT_10F_11F_11F_REV, GL_UNSIGNED_INT_5_9_9_9_REV, or GL_FLOAT_32_UNSIGNED_INT_24_8_REV.
 *	@param[out] data Returns the pixel data.
 */
#define glReadPixels(x,y,width,height,format,type,data) do { glReadPixels_glachwrap(x, y, width, height, format, type, data); GL_AUTOCHECK_BLOCK("glReadPixels", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetBooleanv
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
#define glGetBooleanv(pname,params) do { glGetBooleanv_glachwrap(pname, params); GL_AUTOCHECK_BLOCK("glGetBooleanv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetDoublev
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
#define glGetDoublev(pname,params) do { glGetDoublev_glachwrap(pname, params); GL_AUTOCHECK_BLOCK("glGetDoublev", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFloatv
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
#define glGetFloatv(pname,params) do { glGetFloatv_glachwrap(pname, params); GL_AUTOCHECK_BLOCK("glGetFloatv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetIntegerv
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[out] params Returns the value or values of the specified parameter.
 */
#define glGetIntegerv(pname,params) do { glGetIntegerv_glachwrap(pname, params); GL_AUTOCHECK_BLOCK("glGetIntegerv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetString
 *	@brief return a string describing the current GL connection
 *	@param[in] name Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, or
 *		GL_SHADING_LANGUAGE_VERSION. Additionally, glGetStringi accepts the GL_EXTENSIONS token.
 */
#define glGetString(name) glGetString_glachwrap(name, __FILE__, __LINE__)

/**
 *	@def glGetTexImage
 *	@brief return a texture image
 *	@param[in] target Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D,
 *		GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] format Specifies a pixel format for the returned data. The supported formats are
 *		GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_DEPTH_STENCIL, GL_RED, GL_GREEN, GL_BLUE, GL_RG,
 *		GL_RGB, GL_RGBA, GL_BGR, GL_BGRA, GL_RED_INTEGER, GL_GREEN_INTEGER, GL_BLUE_INTEGER,
 *		GL_RG_INTEGER, GL_RGB_INTEGER, GL_RGBA_INTEGER, GL_BGR_INTEGER, GL_BGRA_INTEGER.
 *	@param[in] type Specifies a pixel type for the returned data. The supported types are
 *		GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_HALF_FLOAT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV,
 *		GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4,
 *		GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV,
 *		GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2,
 *		GL_UNSIGNED_INT_2_10_10_10_REV, GL_UNSIGNED_INT_24_8, GL_UNSIGNED_INT_10F_11F_11F_REV,
 *		GL_UNSIGNED_INT_5_9_9_9_REV, and GL_FLOAT_32_UNSIGNED_INT_24_8_REV.
 *	@param[out] img Returns the texture image. Should be a pointer to an array of the type specified
 *		by type.
 */
#define glGetTexImage(target,level,format,type,img) do { glGetTexImage_glachwrap(target, level, format, type, img); GL_AUTOCHECK_BLOCK("glGetTexImage", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexParameterfv
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
#define glGetTexParameterfv(target,pname,params) do { glGetTexParameterfv_glachwrap(target, pname, params); GL_AUTOCHECK_BLOCK("glGetTexParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexParameteriv
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
#define glGetTexParameteriv(target,pname,params) do { glGetTexParameteriv_glachwrap(target, pname, params); GL_AUTOCHECK_BLOCK("glGetTexParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexLevelParameterfv
 *	@brief return texture parameter values for a specific level of detail
 *	@param[in] target Specifies the symbolic name of the target texture, one of GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_2D_MULTISAMPLE, GL_TEXTURE_2D_MULTISAMPLE_ARRAY,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, GL_PROXY_TEXTURE_1D,
 *		GL_PROXY_TEXTURE_2D, GL_PROXY_TEXTURE_3D, GL_PROXY_TEXTURE_1D_ARRAY,
 *		GL_PROXY_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_RECTANGLE, GL_PROXY_TEXTURE_2D_MULTISAMPLE,
 *		GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, GL_PROXY_TEXTURE_CUBE_MAP, or GL_TEXTURE_BUFFER.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_WIDTH,
 *		GL_TEXTURE_HEIGHT, GL_TEXTURE_DEPTH, GL_TEXTURE_INTERNAL_FORMAT, GL_TEXTURE_BORDER,
 *		GL_TEXTURE_RED_SIZE, GL_TEXTURE_GREEN_SIZE, GL_TEXTURE_BLUE_SIZE, GL_TEXTURE_ALPHA_SIZE,
 *		GL_TEXTURE_DEPTH_SIZE, GL_TEXTURE_COMPRESSED, and GL_TEXTURE_COMPRESSED_IMAGE_SIZE are accepted.
 *	@param[out] params Returns the requested data.
 */
#define glGetTexLevelParameterfv(target,level,pname,params) do { glGetTexLevelParameterfv_glachwrap(target, level, pname, params); GL_AUTOCHECK_BLOCK("glGetTexLevelParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexLevelParameteriv
 *	@brief return texture parameter values for a specific level of detail
 *	@param[in] target Specifies the symbolic name of the target texture, one of GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_2D_MULTISAMPLE, GL_TEXTURE_2D_MULTISAMPLE_ARRAY,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, GL_PROXY_TEXTURE_1D,
 *		GL_PROXY_TEXTURE_2D, GL_PROXY_TEXTURE_3D, GL_PROXY_TEXTURE_1D_ARRAY,
 *		GL_PROXY_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_RECTANGLE, GL_PROXY_TEXTURE_2D_MULTISAMPLE,
 *		GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, GL_PROXY_TEXTURE_CUBE_MAP, or GL_TEXTURE_BUFFER.
 *	@param[in] level Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_WIDTH,
 *		GL_TEXTURE_HEIGHT, GL_TEXTURE_DEPTH, GL_TEXTURE_INTERNAL_FORMAT, GL_TEXTURE_BORDER,
 *		GL_TEXTURE_RED_SIZE, GL_TEXTURE_GREEN_SIZE, GL_TEXTURE_BLUE_SIZE, GL_TEXTURE_ALPHA_SIZE,
 *		GL_TEXTURE_DEPTH_SIZE, GL_TEXTURE_COMPRESSED, and GL_TEXTURE_COMPRESSED_IMAGE_SIZE are accepted.
 *	@param[out] params Returns the requested data.
 */
#define glGetTexLevelParameteriv(target,level,pname,params) do { glGetTexLevelParameteriv_glachwrap(target, level, pname, params); GL_AUTOCHECK_BLOCK("glGetTexLevelParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsEnabled
 *	@brief test whether a capability is enabled
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 */
#define glIsEnabled(cap) glIsEnabled_glachwrap(cap, __FILE__, __LINE__)

/**
 *	@def glDepthRange
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates
 *	@param[in] nearVal Specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0.
 *	@param[in] farVal Specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1.
 */
#define glDepthRange(nearVal,farVal) do { glDepthRange_glachwrap(nearVal, farVal); GL_AUTOCHECK_BLOCK("glDepthRange", __FILE__, __LINE__); } while(0)

/**
 *	@def glViewport
 *	@brief set the viewport
 *	@param[in] x Specify the lower left corner of the viewport rectangle, in pixels. The initial
 *		value is (0,0).
 *	@param[in] y Specify the lower left corner of the viewport rectangle, in pixels. The initial
 *		value is (0,0).
 *	@param[in] width Specify the width and height of the viewport. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 *	@param[in] height Specify the width and height of the viewport. When a GL context is first
 *		attached to a window, width and height are set to the dimensions of that window.
 */
#define glViewport(x,y,width,height) do { glViewport_glachwrap(x, y, width, height); GL_AUTOCHECK_BLOCK("glViewport", __FILE__, __LINE__); } while(0)

#endif // __HAVE_GL_AUTOCHECK

#endif // !GL_VERSION_1_0

//								--- ~OpenGL 1.0 ---

//								--- OpenGL 1.1 ---

/**
 *	@def GL_VERSION_1_1
 *	@brief if defined, OpenGL 1.1 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_1
#define GL_VERSION_1_1 1

/**
 *	@def GLEH_OPENGL_1_1
 *	@brief set if OpenGL 1.1 is supported
 */
#define GLEH_OPENGL_1_1 true

// no new tokens

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] first Specifies the starting index in the enabled arrays.
 *	@param[in] count Specifies the number of indices to be rendered.
 */
GLStaticApi void ApiEntry glDrawArrays(GLenum mode, int first, GLsizei count);

/**
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] count Specifies the number of elements to be rendered.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 */
GLStaticApi void ApiEntry glDrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices);

//GLStaticApi void ApiEntry glGetPointerv(GLenum pname, void **params); // deprecated

/**
 *	@brief set the scale and units used to calculate depth values
 *	@param[in] factor Specifies a scale factor that is used to create a variable depth offset for
 *		each polygon. The initial value is 0.
 *	@param[in] units Is multiplied by an implementation-specific value to create a constant depth
 *		offset. The initial value is 0.
 */
GLStaticApi void ApiEntry glPolygonOffset(float factor, float units);

/**
 *	@brief copy pixels into a 1D texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the internal format of the texture. Must be one of the
 *		following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB,
 *		GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] x Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] width Specifies the width of the texture image. Must be 0 or 2 n + 2 border for some
 *		integer n. The height of the texture image is 1.
 *	@param[in] border Specifies the width of the border. Must be either 0 or 1.
 */
GLStaticApi void ApiEntry glCopyTexImage1D(GLenum target, int level, GLenum internalformat, int x, int y, GLsizei width, int border);

/**
 *	@brief copy pixels into a 2D texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the internal format of the texture. Must be one of the
 *		following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB,
 *		GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture image. Must be 0 or 2 n + 2 border for some
 *		integer n.
 *	@param[in] height Specifies the height of the texture image. Must be 0 or 2 m + 2 border for
 *		some integer m.
 *	@param[in] border Specifies the width of the border. Must be either 0 or 1.
 */
GLStaticApi void ApiEntry glCopyTexImage2D(GLenum target, int level, GLenum internalformat, int x, int y, GLsizei width, GLsizei height, int border);

/**
 *	@brief copy a one-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies the texel offset within the texture array.
 *	@param[in] x Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 */
GLStaticApi void ApiEntry glCopyTexSubImage1D(GLenum target, int level, int xoffset, int x, int y, GLsizei width);

/**
 *	@brief copy a two-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 */
GLStaticApi void ApiEntry glCopyTexSubImage2D(GLenum target, int level, int xoffset, int yoffset, int x, int y, GLsizei width, GLsizei height);

/**
 *	@brief specify a one-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
GLStaticApi void ApiEntry glTexSubImage1D(GLenum target, int level, int xoffset, GLsizei width, GLenum format, GLenum type, const void *data);

/**
 *	@brief specify a two-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
GLStaticApi void ApiEntry glTexSubImage2D(GLenum target, int level, int xoffset, int yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *data);

/**
 *	@brief bind a named texture to a texturing target
 *	@param[in] target Specifies the target to which the texture is bound. Must be either
 *		GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP, GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY.
 *	@param[in] texture Specifies the name of a texture.
 */
GLStaticApi void ApiEntry glBindTexture(GLenum target, GLuint texture);

/**
 *	@brief delete named textures
 *	@param[in] n Specifies the number of textures to be deleted.
 *	@param[in] textures Specifies an array of textures to be deleted.
 */
GLStaticApi void ApiEntry glDeleteTextures(GLsizei n, const GLuint *textures);

/**
 *	@brief generate texture names
 *	@param[in] n Specifies the number of texture names to be generated.
 *	@param[out] textures Specifies an array in which the generated texture names are stored.
 */
GLStaticApi void ApiEntry glGenTextures(GLsizei n, GLuint *textures);

/**
 *	@brief determine if a name corresponds to a texture
 *	@param[in] texture Specifies a value that may be the name of a texture.
 */
GLStaticApi GLboolean ApiEntry glIsTexture(GLuint texture);

#ifdef __cplusplus
}
#endif // __cplusplus

#ifdef __HAVE_GL_AUTOCHECK

inline void glDrawArrays_glachwrap(GLenum mode, int first, GLsizei count) { glDrawArrays(mode,first,count); }
inline void glDrawElements_glachwrap(GLenum mode, GLsizei count, GLenum type, const void *indices) { glDrawElements(mode,count,type,indices); }
//inline void glGetPointerv_glachwrap(GLenum pname, void **params) { glGetPointerv(pname,params); } // deprecated
inline void glPolygonOffset_glachwrap(float factor, float units) { glPolygonOffset(factor,units); }
inline void glCopyTexImage1D_glachwrap(GLenum target, int level, GLenum internalformat, int x, int y, GLsizei width, int border) { glCopyTexImage1D(target,level,internalformat,x,y,width,border); }
inline void glCopyTexImage2D_glachwrap(GLenum target, int level, GLenum internalformat, int x, int y, GLsizei width, GLsizei height, int border) { glCopyTexImage2D(target,level,internalformat,x,y,width,height,border); }
inline void glCopyTexSubImage1D_glachwrap(GLenum target, int level, int xoffset, int x, int y, GLsizei width) { glCopyTexSubImage1D(target,level,xoffset,x,y,width); }
inline void glCopyTexSubImage2D_glachwrap(GLenum target, int level, int xoffset, int yoffset, int x, int y, GLsizei width, GLsizei height) { glCopyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height); }
inline void glTexSubImage1D_glachwrap(GLenum target, int level, int xoffset, GLsizei width, GLenum format, GLenum type, const void *data) { glTexSubImage1D(target,level,xoffset,width,format,type,data); }
inline void glTexSubImage2D_glachwrap(GLenum target, int level, int xoffset, int yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *data) { glTexSubImage2D(target,level,xoffset,yoffset,width,height,format,type,data); }
inline void glBindTexture_glachwrap(GLenum target, GLuint texture) { glBindTexture(target,texture); }
inline void glDeleteTextures_glachwrap(GLsizei n, const GLuint *textures) { glDeleteTextures(n,textures); }
inline void glGenTextures_glachwrap(GLsizei n, GLuint *textures) { glGenTextures(n,textures); }
inline GLboolean glIsTexture_glachwrap(GLuint texture, const char *p_s_filename, int n_line) { GLboolean result = glIsTexture(texture); GL_AUTOCHECK_BLOCK("glIsTexture", p_s_filename, n_line); return result; }

/**
 *	@def glDrawArrays
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] first Specifies the starting index in the enabled arrays.
 *	@param[in] count Specifies the number of indices to be rendered.
 */
#define glDrawArrays(mode,first,count) do { glDrawArrays_glachwrap(mode, first, count); GL_AUTOCHECK_BLOCK("glDrawArrays", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElements
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] count Specifies the number of elements to be rendered.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 */
#define glDrawElements(mode,count,type,indices) do { glDrawElements_glachwrap(mode, count, type, indices); GL_AUTOCHECK_BLOCK("glDrawElements", __FILE__, __LINE__); } while(0)

//#define glGetPointerv(pname,params) do { glGetPointerv_glachwrap(pname, params); GL_AUTOCHECK_BLOCK("glGetPointerv", __FILE__, __LINE__); } while(0) // deprecated

/**
 *	@def glPolygonOffset
 *	@brief set the scale and units used to calculate depth values
 *	@param[in] factor Specifies a scale factor that is used to create a variable depth offset for
 *		each polygon. The initial value is 0.
 *	@param[in] units Is multiplied by an implementation-specific value to create a constant depth
 *		offset. The initial value is 0.
 */
#define glPolygonOffset(factor,units) do { glPolygonOffset_glachwrap(factor, units); GL_AUTOCHECK_BLOCK("glPolygonOffset", __FILE__, __LINE__); } while(0)

/**
 *	@def glCopyTexImage1D
 *	@brief copy pixels into a 1D texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the internal format of the texture. Must be one of the
 *		following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB,
 *		GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] x Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] width Specifies the width of the texture image. Must be 0 or 2 n + 2 border for some
 *		integer n. The height of the texture image is 1.
 *	@param[in] border Specifies the width of the border. Must be either 0 or 1.
 */
#define glCopyTexImage1D(target,level,internalformat,x,y,width,border) do { glCopyTexImage1D_glachwrap(target, level, internalformat, x, y, width, border); GL_AUTOCHECK_BLOCK("glCopyTexImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCopyTexImage2D
 *	@brief copy pixels into a 2D texture image
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the internal format of the texture. Must be one of the
 *		following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB,
 *		GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT,
 *		GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB,
 *		GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2,
 *		GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8,
 *		GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture image. Must be 0 or 2 n + 2 border for some
 *		integer n.
 *	@param[in] height Specifies the height of the texture image. Must be 0 or 2 m + 2 border for
 *		some integer m.
 *	@param[in] border Specifies the width of the border. Must be either 0 or 1.
 */
#define glCopyTexImage2D(target,level,internalformat,x,y,width,height,border) do { glCopyTexImage2D_glachwrap(target, level, internalformat, x, y, width, height, border); GL_AUTOCHECK_BLOCK("glCopyTexImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCopyTexSubImage1D
 *	@brief copy a one-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies the texel offset within the texture array.
 *	@param[in] x Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the left corner of the row of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 */
#define glCopyTexSubImage1D(target,level,xoffset,x,y,width) do { glCopyTexSubImage1D_glachwrap(target, level, xoffset, x, y, width); GL_AUTOCHECK_BLOCK("glCopyTexSubImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCopyTexSubImage2D
 *	@brief copy a two-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 */
#define glCopyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height) do { glCopyTexSubImage2D_glachwrap(target, level, xoffset, yoffset, x, y, width, height); GL_AUTOCHECK_BLOCK("glCopyTexSubImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexSubImage1D
 *	@brief specify a one-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexSubImage1D(target,level,xoffset,width,format,type,data) do { glTexSubImage1D_glachwrap(target, level, xoffset, width, format, type, data); GL_AUTOCHECK_BLOCK("glTexSubImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexSubImage2D
 *	@brief specify a two-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexSubImage2D(target,level,xoffset,yoffset,width,height,format,type,data) do { glTexSubImage2D_glachwrap(target, level, xoffset, yoffset, width, height, format, type, data); GL_AUTOCHECK_BLOCK("glTexSubImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindTexture
 *	@brief bind a named texture to a texturing target
 *	@param[in] target Specifies the target to which the texture is bound. Must be either
 *		GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP, GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY.
 *	@param[in] texture Specifies the name of a texture.
 */
#define glBindTexture(target,texture) do { glBindTexture_glachwrap(target, texture); GL_AUTOCHECK_BLOCK("glBindTexture", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteTextures
 *	@brief delete named textures
 *	@param[in] n Specifies the number of textures to be deleted.
 *	@param[in] textures Specifies an array of textures to be deleted.
 */
#define glDeleteTextures(n,textures) do { glDeleteTextures_glachwrap(n, textures); GL_AUTOCHECK_BLOCK("glDeleteTextures", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenTextures
 *	@brief generate texture names
 *	@param[in] n Specifies the number of texture names to be generated.
 *	@param[out] textures Specifies an array in which the generated texture names are stored.
 */
#define glGenTextures(n,textures) do { glGenTextures_glachwrap(n, textures); GL_AUTOCHECK_BLOCK("glGenTextures", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsTexture
 *	@brief determine if a name corresponds to a texture
 *	@param[in] texture Specifies a value that may be the name of a texture.
 */
#define glIsTexture(texture) glIsTexture_glachwrap(texture, __FILE__, __LINE__)

#endif // __HAVE_GL_AUTOCHECK

#endif // !GL_VERSION_1_1

//								--- ~OpenGL 1.1 ---

//								--- OpenGL 1.2 ---

/**
 *	@def GL_VERSION_1_2
 *	@brief if defined, OpenGL 1.2 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_2
#define GL_VERSION_1_2 1

/**
 *	@def __GENERATE_GL_12__
 *	@brief if defined, code to initialize OpenGL 1.2 entry points is compiled
 */
#define __GENERATE_GL_12__

extern bool GLEH_OPENGL_1_2; /**< @brief set if OpenGL 1.2 is supported */

#define GL_UNSIGNED_BYTE_3_3_2										0x8032 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_4_4_4_4									0x8033 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_5_5_5_1									0x8034 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_INT_8_8_8_8										0x8035 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_INT_10_10_10_2									0x8036 /**< @brief OpenGL 1.2 enum */
//#define GL_RESCALE_NORMAL											  0x803A // deprecated
#define GL_TEXTURE_BINDING_3D										0x806A /**< @brief OpenGL 1.2 enum */
#define GL_PACK_SKIP_IMAGES											0x806B /**< @brief OpenGL 1.2 enum */
#define GL_PACK_IMAGE_HEIGHT										0x806C /**< @brief OpenGL 1.2 enum */
#define GL_UNPACK_SKIP_IMAGES										0x806D /**< @brief OpenGL 1.2 enum */
#define GL_UNPACK_IMAGE_HEIGHT										0x806E /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_3D												0x806F /**< @brief OpenGL 1.2 enum */
#define GL_PROXY_TEXTURE_3D											0x8070 /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_DEPTH											0x8071 /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_WRAP_R											0x8072 /**< @brief OpenGL 1.2 enum */
#define GL_MAX_3D_TEXTURE_SIZE										0x8073 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_BYTE_2_3_3_REV									0x8362 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_5_6_5										0x8363 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_5_6_5_REV									0x8364 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_4_4_4_4_REV								0x8365 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_SHORT_1_5_5_5_REV								0x8366 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_INT_8_8_8_8_REV									0x8367 /**< @brief OpenGL 1.2 enum */
#define GL_UNSIGNED_INT_2_10_10_10_REV								0x8368 /**< @brief OpenGL 1.2 enum */
#define GL_BGR														0x80E0 /**< @brief OpenGL 1.2 enum */
#define GL_BGRA														0x80E1 /**< @brief OpenGL 1.2 enum */
#define GL_MAX_ELEMENTS_VERTICES									0x80E8 /**< @brief OpenGL 1.2 enum */
#define GL_MAX_ELEMENTS_INDICES										0x80E9 /**< @brief OpenGL 1.2 enum */
#define GL_CLAMP_TO_EDGE											0x812F /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_MIN_LOD											0x813A /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_MAX_LOD											0x813B /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_BASE_LEVEL										0x813C /**< @brief OpenGL 1.2 enum */
#define GL_TEXTURE_MAX_LEVEL										0x813D /**< @brief OpenGL 1.2 enum */
//#define GL_LIGHT_MODEL_COLOR_CONTROL								  0x81F8 // deprecated
//#define GL_SINGLE_COLOR											  0x81F9 // deprecated
//#define GL_SEPARATE_SPECULAR_COLOR								  0x81FA // deprecated
#define GL_SMOOTH_POINT_SIZE_RANGE									0x0B12 /**< @brief OpenGL 1.2 enum */
#define GL_SMOOTH_POINT_SIZE_GRANULARITY							0x0B13 /**< @brief OpenGL 1.2 enum */
#define GL_SMOOTH_LINE_WIDTH_RANGE									0x0B22 /**< @brief OpenGL 1.2 enum */
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY							0x0B23 /**< @brief OpenGL 1.2 enum */
//#define GL_ALIASED_POINT_SIZE_RANGE								  0x846D // deprecated
#define GL_ALIASED_LINE_WIDTH_RANGE									0x846E /**< @brief OpenGL 1.2 enum */

/**
 *	@brief set the blend color
 *	@param[in] red specify the components of GL_BLEND_COLOR
 *	@param[in] green specify the components of GL_BLEND_COLOR
 *	@param[in] blue specify the components of GL_BLEND_COLOR
 *	@param[in] alpha specify the components of GL_BLEND_COLOR
 */
extern void (GLApi *GLFuncPtrName(glBlendColor))(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);

/**
 *	@brief specify the equation used for both the RGB blend equation and the Alpha blend equation
 *	@param[in] mode specifies how source and destination colors are combined. It must be
 *		GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 */
extern void (GLApi *GLFuncPtrName(glBlendEquation))(GLenum mode);

/**
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] start Specifies the minimum array index contained in indices.
 *	@param[in] end Specifies the maximum array index contained in indices.
 *	@param[in] count Specifies the number of elements to be rendered.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 */
extern void (GLApi *GLFuncPtrName(glDrawRangeElements))(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices);

/**
 *	@brief specify a three-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be one of GL_TEXTURE_3D,
 *		GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the n th mipmap reduction image.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_RGBA32F, GL_RGBA32I, GL_RGBA32UI, GL_RGBA16,
 *		GL_RGBA16F, GL_RGBA16I, GL_RGBA16UI, GL_RGBA8, GL_RGBA8UI, GL_SRGB8_ALPHA8, GL_RGB10_A2,
 *		GL_RGBA10_A2UI, GL_R11_G11_B10F, GL_RG32F, GL_RG32I, GL_RG32UI, GL_RG16, GL_RG16F,
 *		GL_RGB16I, GL_RGB16UI, GL_RG8, GL_RG8I, GL_RG8UI, GL_R23F, GL_R32I, GL_R32UI, GL_R16F,
 *		GL_R16I, GL_R16UI, GL_R8, GL_R8I, GL_R8UI, GL_RGBA16_UNORM, GL_RGBA8_SNORM, GL_RGB32F,
 *		GL_RGB32I, GL_RGB32UI, GL_RGB16_SNORM, GL_RGB16F, GL_RGB16I, GL_RGB16UI, GL_RGB16,
 *		GL_RGB8_SNORM, GL_RGB8, GL_RGB8I, GL_RGB8UI, GL_SRGB8, GL_RGB9_E5, GL_RG16_SNORM,
 *		GL_RG8_SNORM, GL_COMPRESSED_RG_RGTC2, GL_COMPRESSED_SIGNED_RG_RGTC2, GL_R16_SNORM,
 *		GL_R8_SNORM, GL_COMPRESSED_RED_RGTC1, GL_COMPRESSED_SIGNED_RED_RGTC1, GL_DEPTH_COMPONENT32F,
 *		GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT16, GL_DEPTH32F_STENCIL8, GL_DEPTH24_STENCIL8.
 *	@param[in] width Specifies the width of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 3D
 *		texture images that are at least 256 texels high.
 *	@param[in] depth Specifies the depth of the texture image, or the number of layers in a texture
 *		array. All implementations support 3D texture images that are at least 256 texels deep, and
 *		texture arrays that are at least 256 layers deep.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glTexImage3D))(GLenum target, int level, int internalFormat, GLsizei width, GLsizei height, GLsizei depth, int border, GLenum format, GLenum type, const void *data);

/**
 *	@brief specify a three-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] depth Specifies the depth of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glTexSubImage3D))(GLenum target, int level, int xoffset, int yoffset, int zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data);

/**
 *	@brief copy a three-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 */
extern void (GLApi *GLFuncPtrName(glCopyTexSubImage3D))(GLenum target, int level, int xoffset, int yoffset, int zoffset, int x, int y, GLsizei width, GLsizei height);

/**
 *	@def glBlendColor
 *	@brief set the blend color
 *	@param[in] red specify the components of GL_BLEND_COLOR
 *	@param[in] green specify the components of GL_BLEND_COLOR
 *	@param[in] blue specify the components of GL_BLEND_COLOR
 *	@param[in] alpha specify the components of GL_BLEND_COLOR
 */
#define glBlendColor(red,green,blue,alpha) do { GLFuncPtrName(glBlendColor)(red, green, blue, alpha); GL_AUTOCHECK_BLOCK("glBlendColor", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlendEquation
 *	@brief specify the equation used for both the RGB blend equation and the Alpha blend equation
 *	@param[in] mode specifies how source and destination colors are combined. It must be
 *		GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 */
#define glBlendEquation(mode) do { GLFuncPtrName(glBlendEquation)(mode); GL_AUTOCHECK_BLOCK("glBlendEquation", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawRangeElements
 *	@brief render primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] start Specifies the minimum array index contained in indices.
 *	@param[in] end Specifies the maximum array index contained in indices.
 *	@param[in] count Specifies the number of elements to be rendered.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 */
#define glDrawRangeElements(mode,start,end,count,type,indices) do { GLFuncPtrName(glDrawRangeElements)(mode, start, end, count, type, indices); GL_AUTOCHECK_BLOCK("glDrawRangeElements", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexImage3D
 *	@brief specify a three-dimensional texture image
 *	@param[in] target Specifies the target texture. Must be one of GL_TEXTURE_3D,
 *		GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the n th mipmap reduction image.
 *	@param[in] internalFormat Specifies the number of color components in the texture. Must be one
 *		of the following symbolic constants: GL_RGBA32F, GL_RGBA32I, GL_RGBA32UI, GL_RGBA16,
 *		GL_RGBA16F, GL_RGBA16I, GL_RGBA16UI, GL_RGBA8, GL_RGBA8UI, GL_SRGB8_ALPHA8, GL_RGB10_A2,
 *		GL_RGBA10_A2UI, GL_R11_G11_B10F, GL_RG32F, GL_RG32I, GL_RG32UI, GL_RG16, GL_RG16F,
 *		GL_RGB16I, GL_RGB16UI, GL_RG8, GL_RG8I, GL_RG8UI, GL_R23F, GL_R32I, GL_R32UI, GL_R16F,
 *		GL_R16I, GL_R16UI, GL_R8, GL_R8I, GL_R8UI, GL_RGBA16_UNORM, GL_RGBA8_SNORM, GL_RGB32F,
 *		GL_RGB32I, GL_RGB32UI, GL_RGB16_SNORM, GL_RGB16F, GL_RGB16I, GL_RGB16UI, GL_RGB16,
 *		GL_RGB8_SNORM, GL_RGB8, GL_RGB8I, GL_RGB8UI, GL_SRGB8, GL_RGB9_E5, GL_RG16_SNORM,
 *		GL_RG8_SNORM, GL_COMPRESSED_RG_RGTC2, GL_COMPRESSED_SIGNED_RG_RGTC2, GL_R16_SNORM,
 *		GL_R8_SNORM, GL_COMPRESSED_RED_RGTC1, GL_COMPRESSED_SIGNED_RED_RGTC1, GL_DEPTH_COMPONENT32F,
 *		GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT16, GL_DEPTH32F_STENCIL8, GL_DEPTH24_STENCIL8.
 *	@param[in] width Specifies the width of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 3D
 *		texture images that are at least 256 texels high.
 *	@param[in] depth Specifies the depth of the texture image, or the number of layers in a texture
 *		array. All implementations support 3D texture images that are at least 256 texels deep, and
 *		texture arrays that are at least 256 layers deep.
 *	@param[in] border This value must be 0.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexImage3D(target,level,internalFormat,width,height,depth,border,format,type,data) do { GLFuncPtrName(glTexImage3D)(target, level, internalFormat, width, height, depth, border, format, type, data); GL_AUTOCHECK_BLOCK("glTexImage3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexSubImage3D
 *	@brief specify a three-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] depth Specifies the depth of the texture subimage.
 *	@param[in] format Specifies the format of the pixel data. The following symbolic values are
 *		accepted: GL_RED, GL_RG, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
 *	@param[in] type Specifies the data type of the pixel data. The following symbolic values are
 *		accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT,
 *		GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5,
 *		GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV,
 *		GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8,
 *		GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
 *	@param[in] data Specifies a pointer to the image data in memory.
 */
#define glTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,data) do { GLFuncPtrName(glTexSubImage3D)(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data); GL_AUTOCHECK_BLOCK("glTexSubImage3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCopyTexSubImage3D
 *	@brief copy a three-dimensional texture subimage
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] x Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] y Specify the window coordinates of the lower left corner of the rectangular region
 *		of pixels to be copied.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 */
#define glCopyTexSubImage3D(target,level,xoffset,yoffset,zoffset,x,y,width,height) do { GLFuncPtrName(glCopyTexSubImage3D)(target, level, xoffset, yoffset, zoffset, x, y, width, height); GL_AUTOCHECK_BLOCK("glCopyTexSubImage3D", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_1_2

//								--- ~OpenGL 1.2 ---

//								--- GL_ARB_imaging (part of OpenGL 1.2 core) ---

/**
 *	@def GL_ARB_imaging
 *	@brief if defined, GL_ARB_imaging (part of OpenGL 1.2 core) entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_ARB_imaging
#define GL_ARB_imaging 1

/**
 *	@def __GENERATE_GL_ARB_imaging__
 *	@brief if defined, code to initialize GL_ARB_imaging (part of OpenGL 1.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_imaging__

extern bool GLEH_ARB_imaging; /**< set if GL_ARB_imaging is supported */

#define GL_CONSTANT_COLOR				  0x8001 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_ONE_MINUS_CONSTANT_COLOR		  0x8002 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_CONSTANT_ALPHA				  0x8003 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_ONE_MINUS_CONSTANT_ALPHA		  0x8004 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_BLEND_COLOR					  0x8005 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_FUNC_ADD						  0x8006 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_MIN							  0x8007 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_MAX							  0x8008 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_BLEND_EQUATION				  0x8009 /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_FUNC_SUBTRACT				  0x800A /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */
#define GL_FUNC_REVERSE_SUBTRACT		  0x800B /**< @brief GL_ARB_imaging (part of OpenGL 1.2 core) enum (extended blending) */

// it is unclear whether this is deprecated (it seems to be)
/*#define GL_CONVOLUTION_1D					0x8010
#define GL_CONVOLUTION_2D				  0x8011
#define GL_SEPARABLE_2D					  0x8012
#define GL_CONVOLUTION_BORDER_MODE		  0x8013
#define GL_CONVOLUTION_FILTER_SCALE		  0x8014
#define GL_CONVOLUTION_FILTER_BIAS		  0x8015
#define GL_REDUCE						  0x8016
#define GL_CONVOLUTION_FORMAT			  0x8017
#define GL_CONVOLUTION_WIDTH			  0x8018
#define GL_CONVOLUTION_HEIGHT			  0x8019
#define GL_MAX_CONVOLUTION_WIDTH		  0x801A
#define GL_MAX_CONVOLUTION_HEIGHT		  0x801B
#define GL_POST_CONVOLUTION_RED_SCALE	  0x801C
#define GL_POST_CONVOLUTION_GREEN_SCALE	  0x801D
#define GL_POST_CONVOLUTION_BLUE_SCALE	  0x801E
#define GL_POST_CONVOLUTION_ALPHA_SCALE	  0x801F
#define GL_POST_CONVOLUTION_RED_BIAS	  0x8020
#define GL_POST_CONVOLUTION_GREEN_BIAS	  0x8021
#define GL_POST_CONVOLUTION_BLUE_BIAS	  0x8022
#define GL_POST_CONVOLUTION_ALPHA_BIAS	  0x8023
#define GL_HISTOGRAM					  0x8024
#define GL_PROXY_HISTOGRAM				  0x8025
#define GL_HISTOGRAM_WIDTH				  0x8026
#define GL_HISTOGRAM_FORMAT				  0x8027
#define GL_HISTOGRAM_RED_SIZE			  0x8028
#define GL_HISTOGRAM_GREEN_SIZE			  0x8029
#define GL_HISTOGRAM_BLUE_SIZE			  0x802A
#define GL_HISTOGRAM_ALPHA_SIZE			  0x802B
#define GL_HISTOGRAM_LUMINANCE_SIZE		  0x802C
#define GL_HISTOGRAM_SINK				  0x802D
#define GL_MINMAX						  0x802E
#define GL_MINMAX_FORMAT				  0x802F
#define GL_MINMAX_SINK					  0x8030
#define GL_TABLE_TOO_LARGE				  0x8031
#define GL_COLOR_MATRIX					  0x80B1
#define GL_COLOR_MATRIX_STACK_DEPTH		  0x80B2
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH	  0x80B3
#define GL_POST_COLOR_MATRIX_RED_SCALE	  0x80B4
#define GL_POST_COLOR_MATRIX_GREEN_SCALE  0x80B5
#define GL_POST_COLOR_MATRIX_BLUE_SCALE	  0x80B6
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE  0x80B7
#define GL_POST_COLOR_MATRIX_RED_BIAS	  0x80B8
#define GL_POST_COLOR_MATRIX_GREEN_BIAS	  0x80B9
#define GL_POST_COLOR_MATRIX_BLUE_BIAS	  0x80BA
#define GL_POST_COLOR_MATRIX_ALPHA_BIAS	  0x80BB
#define GL_COLOR_TABLE					  0x80D0
#define GL_POST_CONVOLUTION_COLOR_TABLE	  0x80D1
#define GL_POST_COLOR_MATRIX_COLOR_TABLE  0x80D2
#define GL_PROXY_COLOR_TABLE			  0x80D3
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE 0x80D4
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE 0x80D5
#define GL_COLOR_TABLE_SCALE			  0x80D6
#define GL_COLOR_TABLE_BIAS				  0x80D7
#define GL_COLOR_TABLE_FORMAT			  0x80D8
#define GL_COLOR_TABLE_WIDTH			  0x80D9
#define GL_COLOR_TABLE_RED_SIZE			  0x80DA
#define GL_COLOR_TABLE_GREEN_SIZE		  0x80DB
#define GL_COLOR_TABLE_BLUE_SIZE		  0x80DC
#define GL_COLOR_TABLE_ALPHA_SIZE		  0x80DD
#define GL_COLOR_TABLE_LUMINANCE_SIZE	  0x80DE
#define GL_COLOR_TABLE_INTENSITY_SIZE	  0x80DF
#define GL_CONSTANT_BORDER				  0x8151
#define GL_REPLICATE_BORDER				  0x8153
#define GL_CONVOLUTION_BORDER_COLOR		  0x8154*/

// it is unclear whether this is deprecated (it seems to be)
/*extern void (GLApi *GLFuncPtrName(glColorTable))(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glColorTableParameterfv))(GLenum, GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glColorTableParameteriv))(GLenum, GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glCopyColorTable))(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetColorTable))(GLenum, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetColorTableParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetColorTableParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glColorSubTable))(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCopyColorSubTable))(GLenum, GLsizei, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glConvolutionFilter1D))(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glConvolutionFilter2D))(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glConvolutionParameterf))(GLenum, GLenum, GLfloat);
extern void (GLApi *GLFuncPtrName(glConvolutionParameterfv))(GLenum, GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glConvolutionParameteri))(GLenum, GLenum, GLint);
extern void (GLApi *GLFuncPtrName(glConvolutionParameteriv))(GLenum, GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glCopyConvolutionFilter1D))(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glCopyConvolutionFilter2D))(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetConvolutionFilter))(GLenum, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetConvolutionParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetConvolutionParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetSeparableFilter))(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*);
extern void (GLApi *GLFuncPtrName(glSeparableFilter2D))(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetHistogram))(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetHistogramParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetHistogramParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetMinmax))(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetMinmaxParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetMinmaxParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glHistogram))(GLenum, GLsizei, GLenum, GLboolean);
extern void (GLApi *GLFuncPtrName(glMinmax))(GLenum, GLenum, GLboolean);
extern void (GLApi *GLFuncPtrName(glResetHistogram))(GLenum);
extern void (GLApi *GLFuncPtrName(glResetMinmax))(GLenum);*/

// it is unclear whether this is deprecated (it seems to be)
/*#define glColorTable GLFuncPtrName(glColorTable)
#define glColorTableParameterfv GLFuncPtrName(glColorTableParameterfv)
#define glColorTableParameteriv GLFuncPtrName(glColorTableParameteriv)
#define glCopyColorTable GLFuncPtrName(glCopyColorTable)
#define glGetColorTable GLFuncPtrName(glGetColorTable)
#define glGetColorTableParameterfv GLFuncPtrName(glGetColorTableParameterfv)
#define glGetColorTableParameteriv GLFuncPtrName(glGetColorTableParameteriv)
#define glColorSubTable GLFuncPtrName(glColorSubTable)
#define glCopyColorSubTable GLFuncPtrName(glCopyColorSubTable)
#define glConvolutionFilter1D GLFuncPtrName(glConvolutionFilter1D)
#define glConvolutionFilter2D GLFuncPtrName(glConvolutionFilter2D)
#define glConvolutionParameterf GLFuncPtrName(glConvolutionParameterf)
#define glConvolutionParameterfv GLFuncPtrName(glConvolutionParameterfv)
#define glConvolutionParameteri GLFuncPtrName(glConvolutionParameteri)
#define glConvolutionParameteriv GLFuncPtrName(glConvolutionParameteriv)
#define glCopyConvolutionFilter1D GLFuncPtrName(glCopyConvolutionFilter1D)
#define glCopyConvolutionFilter2D GLFuncPtrName(glCopyConvolutionFilter2D)
#define glGetConvolutionFilter GLFuncPtrName(glGetConvolutionFilter)
#define glGetConvolutionParameterfv GLFuncPtrName(glGetConvolutionParameterfv)
#define glGetConvolutionParameteriv GLFuncPtrName(glGetConvolutionParameteriv)
#define glGetSeparableFilter GLFuncPtrName(glGetSeparableFilter)
#define glSeparableFilter2D GLFuncPtrName(glSeparableFilter2D)
#define glGetHistogram GLFuncPtrName(glGetHistogram)
#define glGetHistogramParameterfv GLFuncPtrName(glGetHistogramParameterfv)
#define glGetHistogramParameteriv GLFuncPtrName(glGetHistogramParameteriv)
#define glGetMinmax GLFuncPtrName(glGetMinmax)
#define glGetMinmaxParameterfv GLFuncPtrName(glGetMinmaxParameterfv)
#define glGetMinmaxParameteriv GLFuncPtrName(glGetMinmaxParameteriv)
#define glHistogram GLFuncPtrName(glHistogram)
#define glMinmax GLFuncPtrName(glMinmax)
#define glResetHistogram GLFuncPtrName(glResetHistogram)
#define glResetMinmax GLFuncPtrName(glResetMinmax)*/

#endif // !GL_ARB_imaging

//								--- ~GL_ARB_imaging (part of OpenGL 1.2 core) ---

//								--- OpenGL 1.3 ---

/**
 *	@def GL_VERSION_1_3
 *	@brief if defined, OpenGL 1.3 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_3
#define GL_VERSION_1_3 1

/**
 *	@def __GENERATE_GL_13__
 *	@brief if defined, code to initialize OpenGL 1.3 entry points is compiled
 */
#define __GENERATE_GL_13__

extern bool GLEH_OPENGL_1_3; /**< @brief set if OpenGL 1.3 is supported */

#define GL_TEXTURE0													0x84C0 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE1													0x84C1 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE2													0x84C2 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE3													0x84C3 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE4													0x84C4 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE5													0x84C5 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE6													0x84C6 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE7													0x84C7 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE8													0x84C8 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE9													0x84C9 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE10												0x84CA /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE11												0x84CB /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE12												0x84CC /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE13												0x84CD /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE14												0x84CE /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE15												0x84CF /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE16												0x84D0 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE17												0x84D1 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE18												0x84D2 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE19												0x84D3 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE20												0x84D4 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE21												0x84D5 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE22												0x84D6 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE23												0x84D7 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE24												0x84D8 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE25												0x84D9 /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE26												0x84DA /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE27												0x84DB /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE28												0x84DC /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE29												0x84DD /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE30												0x84DE /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_TEXTURE31												0x84DF /**< @brief OpenGL 1.3 enum (texture unit name) */
#define GL_ACTIVE_TEXTURE											0x84E0 /**< @brief OpenGL 1.3 enum (multitexture) */
//#define GL_CLIENT_ACTIVE_TEXTURE									  0x84E1 // deprecated
//#define GL_MAX_TEXTURE_UNITS										  0x84E2 // deprecated
//#define GL_TRANSPOSE_MODELVIEW_MATRIX								  0x84E3 // deprecated
//#define GL_TRANSPOSE_PROJECTION_MATRIX							  0x84E4 // deprecated
//#define GL_TRANSPOSE_TEXTURE_MATRIX								  0x84E5 // deprecated
//#define GL_TRANSPOSE_COLOR_MATRIX									  0x84E6 // deprecated
#define GL_MULTISAMPLE												0x809D /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_ALPHA_TO_COVERAGE									0x809E /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_ALPHA_TO_ONE										0x809F /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_COVERAGE											0x80A0 /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_BUFFERS											0x80A8 /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLES													0x80A9 /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_COVERAGE_VALUE									0x80AA /**< @brief OpenGL 1.3 enum */
#define GL_SAMPLE_COVERAGE_INVERT									0x80AB /**< @brief OpenGL 1.3 enum */
//#define GL_MULTISAMPLE_BIT										  0x20000000 // deprecated
//#define GL_NORMAL_MAP												  0x8511 // deprecated
//#define GL_REFLECTION_MAP											  0x8512 // deprecated
#define GL_TEXTURE_CUBE_MAP											0x8513 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_BINDING_CUBE_MAP									0x8514 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X								0x8515 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X								0x8516 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y								0x8517 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y								0x8518 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z								0x8519 /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z								0x851A /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_PROXY_TEXTURE_CUBE_MAP									0x851B /**< @brief OpenGL 1.3 enum (cube map textures) */
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE								0x851C /**< @brief OpenGL 1.3 enum (cube map textures) */
//#define GL_COMPRESSED_ALPHA										  0x84E9 // deprecated
//#define GL_COMPRESSED_LUMINANCE									  0x84EA // deprecated
//#define GL_COMPRESSED_LUMINANCE_ALPHA								  0x84EB // deprecated
//#define GL_COMPRESSED_INTENSITY									  0x84EC // deprecated
#define GL_COMPRESSED_RGB											0x84ED /**< @brief OpenGL 1.3 enum (texture compression) */
#define GL_COMPRESSED_RGBA											0x84EE /**< @brief OpenGL 1.3 enum (texture compression) */
#define GL_TEXTURE_COMPRESSION_HINT									0x84EF /**< @brief OpenGL 1.3 enum (texture compression) */
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE							0x86A0 /**< @brief OpenGL 1.3 enum (texture compression) */
#define GL_TEXTURE_COMPRESSED										0x86A1 /**< @brief OpenGL 1.3 enum (texture compression) */
//#define GL_NUM_COMPRESSED_TEXTURE_FORMATS							  0x86A2 // deprecated as of OpenGL 4.2
//#define GL_COMPRESSED_TEXTURE_FORMATS								  0x86A3 // deprecated as of OpenGL 4.2
#define GL_CLAMP_TO_BORDER											0x812D /**< @brief OpenGL 1.3 enum (texture clamp mode) */
//#define GL_COMBINE												  0x8570 // deprecated
//#define GL_COMBINE_RGB											  0x8571 // deprecated
//#define GL_COMBINE_ALPHA											  0x8572 // deprecated
//#define GL_SOURCE0_RGB											  0x8580 // deprecated
//#define GL_SOURCE1_RGB											  0x8581 // deprecated
//#define GL_SOURCE2_RGB											  0x8582 // deprecated
//#define GL_SOURCE0_ALPHA											  0x8588 // deprecated
//#define GL_SOURCE1_ALPHA											  0x8589 // deprecated
//#define GL_SOURCE2_ALPHA											  0x858A // deprecated
//#define GL_OPERAND0_RGB											  0x8590 // deprecated
//#define GL_OPERAND1_RGB											  0x8591 // deprecated
//#define GL_OPERAND2_RGB											  0x8592 // deprecated
//#define GL_OPERAND0_ALPHA											  0x8598 // deprecated
//#define GL_OPERAND1_ALPHA											  0x8599 // deprecated
//#define GL_OPERAND2_ALPHA											  0x859A // deprecated
//#define GL_RGB_SCALE												  0x8573 // deprecated
//#define GL_ADD_SIGNED												  0x8574 // deprecated
//#define GL_INTERPOLATE											  0x8575 // deprecated
//#define GL_SUBTRACT												  0x84E7 // deprecated
//#define GL_CONSTANT												  0x8576 // deprecated
//#define GL_PRIMARY_COLOR											  0x8577 // deprecated
//#define GL_PREVIOUS												  0x8578 // deprecated
//#define GL_DOT3_RGB												  0x86AE // deprecated
//#define GL_DOT3_RGBA												  0x86AF // deprecated

/**
 *	@brief select active texture unit
 *	@param[in] texture Specifies which texture unit to make active. The number of texture units is
 *		implementation dependent, but must be at least 80. texture must be one of GL_TEXTURE i,
 *		where i ranges from 0 ( GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
 */
extern void (GLApi *GLFuncPtrName(glActiveTexture))(GLenum texture);

/**
 *	@brief specify multisample coverage parameters
 *	@param[in] value Specify a single floating-point sample coverage value. The value is clamped to
 *		the range 0 1. The initial value is 1.0.
 *	@param[in] invert Specify a single boolean value representing if the coverage masks should be
 *		inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
 */
extern void (GLApi *GLFuncPtrName(glSampleCoverage))(GLclampf value, GLboolean invert);

/**
 *	@brief specify a three-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D,
 *		GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels high.
 *	@param[in] depth Specifies the depth of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels deep.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexImage3D))(GLenum target, int level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, int border, GLsizei imageSize, const void *data);

/**
 *	@brief specify a two-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D,
 *		GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support 2D
 *		texture images that are at least 64 texels wide and cube-mapped texture images that are at
 *		least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 2D
 *		texture images that are at least 64 texels high and cube-mapped texture images that are at
 *		least 16 texels high.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexImage2D))(GLenum target, int level, GLenum internalformat, GLsizei width, GLsizei height, int border, GLsizei imageSize, const void *data);

/**
 *	@brief specify a one-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 64 texels wide. The height of the 1D texture image is 1.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexImage1D))(GLenum target, int level, GLenum internalformat, GLsizei width, int border, GLsizei imageSize, const void *data);

/**
 *	@brief specify a three-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] depth Specifies the depth of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage3D))(GLenum target, int level, int xoffset, int yoffset, int zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data);

/**
 *	@brief specify a two-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage2D))(GLenum target, int level, int xoffset, int yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data);

/**
 *	@brief specify a one-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage1D))(GLenum target, int level, int xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data);

/**
 *	@brief return a compressed texture image
 *	@param[in] target Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D,
 *		GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
 *	@param[in] lod Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[out] img Returns the compressed texture image.
 */
extern void (GLApi *GLFuncPtrName(glGetCompressedTexImage))(GLenum target, int lod, void *img);

// functions below are deprecated
/*extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixf))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixd))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixf))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixd))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glClientActiveTexture))(GLenum);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1d))(GLenum, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1f))(GLenum, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1i))(GLenum, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1s))(GLenum, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2d))(GLenum, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2f))(GLenum, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2i))(GLenum, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2s))(GLenum, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3d))(GLenum, GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3f))(GLenum, GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3i))(GLenum, GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3s))(GLenum, GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4d))(GLenum, GLdouble, GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4f))(GLenum, GLfloat, GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4i))(GLenum, GLint, GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4s))(GLenum, GLshort, GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4sv))(GLenum, const GLshort*);*/

/**
 *	@def glActiveTexture
 *	@brief select active texture unit
 *	@param[in] texture Specifies which texture unit to make active. The number of texture units is
 *		implementation dependent, but must be at least 80. texture must be one of GL_TEXTURE i,
 *		where i ranges from 0 ( GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
 */
#define glActiveTexture(texture) do { GLFuncPtrName(glActiveTexture)(texture); GL_AUTOCHECK_BLOCK("glActiveTexture", __FILE__, __LINE__); } while(0)

/**
 *	@def glSampleCoverage
 *	@brief specify multisample coverage parameters
 *	@param[in] value Specify a single floating-point sample coverage value. The value is clamped to
 *		the range 0 1. The initial value is 1.0.
 *	@param[in] invert Specify a single boolean value representing if the coverage masks should be
 *		inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
 */
#define glSampleCoverage(value,invert) do { GLFuncPtrName(glSampleCoverage)(value, invert); GL_AUTOCHECK_BLOCK("glSampleCoverage", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexImage3D
 *	@brief specify a three-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D,
 *		GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels high.
 *	@param[in] depth Specifies the depth of the texture image. All implementations support 3D
 *		texture images that are at least 16 texels deep.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexImage3D(target,level,internalformat,width,height,depth,border,imageSize,data) do { GLFuncPtrName(glCompressedTexImage3D)(target, level, internalformat, width, height, depth, border, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexImage3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexImage2D
 *	@brief specify a two-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D,
 *		GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z,
 *		GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support 2D
 *		texture images that are at least 64 texels wide and cube-mapped texture images that are at
 *		least 16 texels wide.
 *	@param[in] height Specifies the height of the texture image. All implementations support 2D
 *		texture images that are at least 64 texels high and cube-mapped texture images that are at
 *		least 16 texels high.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexImage2D(target,level,internalformat,width,height,border,imageSize,data) do { GLFuncPtrName(glCompressedTexImage2D)(target, level, internalformat, width, height, border, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexImage1D
 *	@brief specify a one-dimensional texture image in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] internalformat Specifies the format of the compressed image data stored at address data.
 *	@param[in] width Specifies the width of the texture image. All implementations support texture
 *		images that are at least 64 texels wide. The height of the 1D texture image is 1.
 *	@param[in] border This value must be 0.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexImage1D(target,level,internalformat,width,border,imageSize,data) do { GLFuncPtrName(glCompressedTexImage1D)(target, level, internalformat, width, border, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexSubImage3D
 *	@brief specify a three-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_3D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] zoffset Specifies a texel offset in the z direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] depth Specifies the depth of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data) do { GLFuncPtrName(glCompressedTexSubImage3D)(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexSubImage3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexSubImage2D
 *	@brief specify a two-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_2D,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] yoffset Specifies a texel offset in the y direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] height Specifies the height of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,imageSize,data) do { GLFuncPtrName(glCompressedTexSubImage2D)(target, level, xoffset, yoffset, width, height, format, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexSubImage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompressedTexSubImage1D
 *	@brief specify a one-dimensional texture subimage in a compressed format
 *	@param[in] target Specifies the target texture. Must be GL_TEXTURE_1D.
 *	@param[in] level Specifies the level-of-detail number. Level 0 is the base image level. Level n
 *		is the nth mipmap reduction image.
 *	@param[in] xoffset Specifies a texel offset in the x direction within the texture array.
 *	@param[in] width Specifies the width of the texture subimage.
 *	@param[in] format Specifies the format of the compressed image data stored at address data.
 *	@param[in] imageSize Specifies the number of unsigned bytes of image data starting at the
 *		address specified by data.
 *	@param[in] data Specifies a pointer to the compressed image data in memory.
 */
#define glCompressedTexSubImage1D(target,level,xoffset,width,format,imageSize,data) do { GLFuncPtrName(glCompressedTexSubImage1D)(target, level, xoffset, width, format, imageSize, data); GL_AUTOCHECK_BLOCK("glCompressedTexSubImage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetCompressedTexImage
 *	@brief return a compressed texture image
 *	@param[in] target Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D,
 *		GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
 *		GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
 *	@param[in] lod Specifies the level-of-detail number of the desired image. Level 0 is the base
 *		image level. Level n is the nth mipmap reduction image.
 *	@param[out] img Returns the compressed texture image.
 */
#define glGetCompressedTexImage(target,lod,img) do { GLFuncPtrName(glGetCompressedTexImage)(target, lod, img); GL_AUTOCHECK_BLOCK("glGetCompressedTexImage", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_1_3

//								--- ~OpenGL 1.3 ---

//								--- OpenGL 1.4 ---

/**
 *	@def GL_VERSION_1_4
 *	@brief if defined, OpenGL 1.4 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_4
#define GL_VERSION_1_4 1

/**
 *	@def __GENERATE_GL_14__
 *	@brief if defined, code to initialize OpenGL 1.4 entry points is compiled
 */
#define __GENERATE_GL_14__

extern bool GLEH_OPENGL_1_4; /**< @brief set if OpenGL 1.4 is supported */

#define GL_BLEND_DST_RGB											0x80C8 /**< @brief OpenGL 1.4 enum */
#define GL_BLEND_SRC_RGB											0x80C9 /**< @brief OpenGL 1.4 enum */
#define GL_BLEND_DST_ALPHA											0x80CA /**< @brief OpenGL 1.4 enum */
#define GL_BLEND_SRC_ALPHA											0x80CB /**< @brief OpenGL 1.4 enum */
//#define GL_POINT_SIZE_MIN											  0x8126 // deprecated
//#define GL_POINT_SIZE_MAX											  0x8127 // deprecated
#define GL_POINT_FADE_THRESHOLD_SIZE								0x8128 /**< @brief OpenGL 1.4 enum */
//#define GL_POINT_DISTANCE_ATTENUATION								  0x8129 // deprecated
//#define GL_GENERATE_MIPMAP										  0x8191 // deprecated
//#define GL_GENERATE_MIPMAP_HINT									  0x8192 // deprecated
#define GL_DEPTH_COMPONENT16										0x81A5 /**< @brief OpenGL 1.4 enum */
#define GL_DEPTH_COMPONENT24										0x81A6 /**< @brief OpenGL 1.4 enum */
#define GL_DEPTH_COMPONENT32										0x81A7 /**< @brief OpenGL 1.4 enum */
#define GL_MIRRORED_REPEAT											0x8370 /**< @brief OpenGL 1.4 enum */
//#define GL_FOG_COORDINATE_SOURCE									  0x8450 // deprecated
//#define GL_FOG_COORDINATE											  0x8451 // deprecated
//#define GL_FRAGMENT_DEPTH											  0x8452 // deprecated
//#define GL_CURRENT_FOG_COORDINATE									  0x8453 // deprecated
//#define GL_FOG_COORDINATE_ARRAY_TYPE								  0x8454 // deprecated
//#define GL_FOG_COORDINATE_ARRAY_STRIDE							  0x8455 // deprecated
//#define GL_FOG_COORDINATE_ARRAY_POINTER							  0x8456 // deprecated
//#define GL_FOG_COORDINATE_ARRAY									  0x8457 // deprecated
//#define GL_COLOR_SUM												  0x8458 // deprecated
//#define GL_CURRENT_SECONDARY_COLOR								  0x8459 // deprecated
//#define GL_SECONDARY_COLOR_ARRAY_SIZE								  0x845A // deprecated
//#define GL_SECONDARY_COLOR_ARRAY_TYPE								  0x845B // deprecated
//#define GL_SECONDARY_COLOR_ARRAY_STRIDE							  0x845C // deprecated
//#define GL_SECONDARY_COLOR_ARRAY_POINTER							  0x845D // deprecated
//#define GL_SECONDARY_COLOR_ARRAY									  0x845E // deprecated
#define GL_MAX_TEXTURE_LOD_BIAS										0x84FD /**< @brief OpenGL 1.4 enum */
//#define GL_TEXTURE_FILTER_CONTROL									  0x8500 // deprecated
//#define GL_TEXTURE_LOD_BIAS										  0x8501 // deprecated
#define GL_INCR_WRAP												0x8507 /**< @brief OpenGL 1.4 enum */
#define GL_DECR_WRAP												0x8508 /**< @brief OpenGL 1.4 enum */
#define GL_TEXTURE_DEPTH_SIZE										0x884A /**< @brief OpenGL 1.4 enum */
//#define GL_DEPTH_TEXTURE_MODE										  0x884B // deprecated
#define GL_TEXTURE_COMPARE_MODE										0x884C /**< @brief OpenGL 1.4 enum */
#define GL_TEXTURE_COMPARE_FUNC										0x884D /**< @brief OpenGL 1.4 enum */
//#define GL_COMPARE_R_TO_TEXTURE									  0x884E // deprecated (in OpenGL 3.0, use GL_COMPARE_REF_TO_TEXTURE)

/**
 *	@brief specify pixel arithmetic for RGB and alpha components separately
 *	@param[in] srcRGB Specifies how the red, green, and blue blending factors are computed. The
 *		initial value is GL_ONE.
 *	@param[in] dstRGB Specifies how the red, green, and blue destination blending factors are
 *		computed. The initial value is GL_ZERO.
 *	@param[in] srcAlpha Specified how the alpha source blending factor is computed. The initial
 *		value is GL_ONE.
 *	@param[in] dstAlpha Specified how the alpha destination blending factor is computed. The initial
 *		value is GL_ZERO.
 */
extern void (GLApi *GLFuncPtrName(glBlendFuncSeparate))(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

// functions below are deprecated
/*extern void (GLApi *GLFuncPtrName(glFogCoordf))(GLfloat);
extern void (GLApi *GLFuncPtrName(glFogCoordfv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glFogCoordd))(GLdouble);
extern void (GLApi *GLFuncPtrName(glFogCoorddv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glFogCoordPointer))(GLenum, GLsizei, const GLvoid*);*/

/**
 *	@brief render multiple sets of primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[out] first Points to an array of starting indices in the enabled arrays.
 *	@param[out] count Points to an array of the number of indices to be rendered.
 *	@param[in] primcount Specifies the size of the first and count
 */
extern void (GLApi *GLFuncPtrName(glMultiDrawArrays))(GLenum mode, int *first, GLsizei *count, GLsizei primcount);

/**
 *	@brief render multiple sets of primitives by specifying indices of array data elements
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] count Points to an array of the elements counts.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 *	@param[in] primcount Specifies the size of the count array.
 */
extern void (GLApi *GLFuncPtrName(glMultiDrawElements))(GLenum mode, const GLsizei *count, GLenum type, const void **indices, GLsizei primcount);

/**
 *	@brief specify point parameters
 *	@param[in] pname Specifies a single-valued point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] param Specifies the value that pname will be set to.
 */
extern void (GLApi *GLFuncPtrName(glPointParameterf))(GLenum pname, float param);

/**
 *	@brief specify point parameters
 *	@param[in] pname Specifies a point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] params Specifies the value to be assigned to pname..
 */
extern void (GLApi *GLFuncPtrName(glPointParameterfv))(GLenum pname, const float *params);

/**
 *	@brief specify point parameters
 *	@param[in] pname Specifies a single-valued point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] param Specifies the value that pname will be set to.
 */
extern void (GLApi *GLFuncPtrName(glPointParameteri))(GLenum pname, int param);

/**
 *	@brief specify point parameters
 *	@param[in] pname Specifies a point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] params Specifies the value to be assigned to pname..
 */
extern void (GLApi *GLFuncPtrName(glPointParameteriv))(GLenum pname, const int *params);

// functions below are deprecated
/*extern void (GLApi *GLFuncPtrName(glSecondaryColor3b))(GLbyte, GLbyte, GLbyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3bv))(const GLbyte*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3d))(GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3f))(GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3i))(GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3s))(GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3sv))(const GLshort*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ub))(GLubyte, GLubyte, GLubyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ubv))(const GLubyte*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ui))(GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3uiv))(const GLuint*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3us))(GLushort, GLushort, GLushort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3usv))(const GLushort*);
extern void (GLApi *GLFuncPtrName(glSecondaryColorPointer))(GLint, GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glWindowPos2d))(GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glWindowPos2dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glWindowPos2f))(GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glWindowPos2fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glWindowPos2i))(GLint, GLint);
extern void (GLApi *GLFuncPtrName(glWindowPos2iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glWindowPos2s))(GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glWindowPos2sv))(const GLshort*);
extern void (GLApi *GLFuncPtrName(glWindowPos3d))(GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glWindowPos3dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glWindowPos3f))(GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glWindowPos3fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glWindowPos3i))(GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glWindowPos3iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glWindowPos3s))(GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glWindowPos3sv))(const GLshort*);*/

/**
 *	@def glBlendFuncSeparate
 *	@brief specify pixel arithmetic for RGB and alpha components separately
 *	@param[in] srcRGB Specifies how the red, green, and blue blending factors are computed. The
 *		initial value is GL_ONE.
 *	@param[in] dstRGB Specifies how the red, green, and blue destination blending factors are
 *		computed. The initial value is GL_ZERO.
 *	@param[in] srcAlpha Specified how the alpha source blending factor is computed. The initial
 *		value is GL_ONE.
 *	@param[in] dstAlpha Specified how the alpha destination blending factor is computed. The initial
 *		value is GL_ZERO.
 */
#define glBlendFuncSeparate(srcRGB,dstRGB,srcAlpha,dstAlpha) do { GLFuncPtrName(glBlendFuncSeparate)(srcRGB, dstRGB, srcAlpha, dstAlpha); GL_AUTOCHECK_BLOCK("glBlendFuncSeparate", __FILE__, __LINE__); } while(0)

/**
 *	@def glMultiDrawArrays
 *	@brief render multiple sets of primitives from array data
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[out] first Points to an array of starting indices in the enabled arrays.
 *	@param[out] count Points to an array of the number of indices to be rendered.
 *	@param[in] primcount Specifies the size of the first and count
 */
#define glMultiDrawArrays(mode,first,count,primcount) do { GLFuncPtrName(glMultiDrawArrays)(mode, first, count, primcount); GL_AUTOCHECK_BLOCK("glMultiDrawArrays", __FILE__, __LINE__); } while(0)

/**
 *	@def glMultiDrawElements
 *	@brief render multiple sets of primitives by specifying indices of array data elements
 *	@param[in] mode Specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
 *	@param[in] count Points to an array of the elements counts.
 *	@param[in] type Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
 *	@param[in] indices Specifies a pointer to the location where the indices are stored.
 *	@param[in] primcount Specifies the size of the count array.
 */
#define glMultiDrawElements(mode,count,type,indices,primcount) do { GLFuncPtrName(glMultiDrawElements)(mode, count, type, indices, primcount); GL_AUTOCHECK_BLOCK("glMultiDrawElements", __FILE__, __LINE__); } while(0)

/**
 *	@def glPointParameterf
 *	@brief specify point parameters
 *	@param[in] pname Specifies a single-valued point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] param Specifies the value that pname will be set to.
 */
#define glPointParameterf(pname,param) do { GLFuncPtrName(glPointParameterf)(pname, param); GL_AUTOCHECK_BLOCK("glPointParameterf", __FILE__, __LINE__); } while(0)

/**
 *	@def glPointParameterfv
 *	@brief specify point parameters
 *	@param[in] pname Specifies a point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] params Specifies the value to be assigned to pname..
 */
#define glPointParameterfv(pname,params) do { GLFuncPtrName(glPointParameterfv)(pname, params); GL_AUTOCHECK_BLOCK("glPointParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glPointParameteri
 *	@brief specify point parameters
 *	@param[in] pname Specifies a single-valued point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] param Specifies the value that pname will be set to.
 */
#define glPointParameteri(pname,param) do { GLFuncPtrName(glPointParameteri)(pname, param); GL_AUTOCHECK_BLOCK("glPointParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glPointParameteriv
 *	@brief specify point parameters
 *	@param[in] pname Specifies a point parameter. GL_POINT_FADE_THRESHOLD_SIZE, and
 *		GL_POINT_SPRITE_COORD_ORIGIN are accepted.
 *	@param[in] params Specifies the value to be assigned to pname..
 */
#define glPointParameteriv(pname,params) do { GLFuncPtrName(glPointParameteriv)(pname, params); GL_AUTOCHECK_BLOCK("glPointParameteriv", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_1_4

//								--- ~OpenGL 1.4 ---

//								--- OpenGL 1.5 ---

/**
 *	@def GL_VERSION_1_5
 *	@brief if defined, OpenGL 1.5 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_1_5
#define GL_VERSION_1_5 1

/**
 *	@def __GENERATE_GL_15__
 *	@brief if defined, code to initialize OpenGL 1.5 entry points is compiled
 */
#define __GENERATE_GL_15__

extern bool GLEH_OPENGL_1_5; /**< @brief set if OpenGL 1.5 is supported */

#define GL_BUFFER_SIZE												0x8764 /**< @brief OpenGL 1.5 enum */
#define GL_BUFFER_USAGE												0x8765 /**< @brief OpenGL 1.5 enum */
#define GL_QUERY_COUNTER_BITS										0x8864 /**< @brief OpenGL 1.5 enum */
#define GL_CURRENT_QUERY											0x8865 /**< @brief OpenGL 1.5 enum */
#define GL_QUERY_RESULT												0x8866 /**< @brief OpenGL 1.5 enum */
#define GL_QUERY_RESULT_AVAILABLE									0x8867 /**< @brief OpenGL 1.5 enum */
#define GL_ARRAY_BUFFER												0x8892 /**< @brief OpenGL 1.5 enum */
#define GL_ELEMENT_ARRAY_BUFFER										0x8893 /**< @brief OpenGL 1.5 enum */
#define GL_ARRAY_BUFFER_BINDING										0x8894 /**< @brief OpenGL 1.5 enum */
#define GL_ELEMENT_ARRAY_BUFFER_BINDING								0x8895 /**< @brief OpenGL 1.5 enum */
//#define GL_VERTEX_ARRAY_BUFFER_BINDING							  0x8896 // deprecated
//#define GL_NORMAL_ARRAY_BUFFER_BINDING							  0x8897 // deprecated
//#define GL_COLOR_ARRAY_BUFFER_BINDING								  0x8898 // deprecated
//#define GL_INDEX_ARRAY_BUFFER_BINDING								  0x8899 // deprecated
//#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING						  0x889A // deprecated
//#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING							  0x889B // deprecated
//#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING					  0x889C // deprecated
//#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING					  0x889D // deprecated
//#define GL_WEIGHT_ARRAY_BUFFER_BINDING							  0x889E // deprecated
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING						0x889F /**< @brief OpenGL 1.5 enum */
#define GL_READ_ONLY												0x88B8 /**< @brief OpenGL 1.5 enum */
#define GL_WRITE_ONLY												0x88B9 /**< @brief OpenGL 1.5 enum */
#define GL_READ_WRITE												0x88BA /**< @brief OpenGL 1.5 enum */
#define GL_BUFFER_ACCESS											0x88BB /**< @brief OpenGL 1.5 enum */
#define GL_BUFFER_MAPPED											0x88BC /**< @brief OpenGL 1.5 enum */
#define GL_BUFFER_MAP_POINTER										0x88BD /**< @brief OpenGL 1.5 enum */
#define GL_STREAM_DRAW												0x88E0 /**< @brief OpenGL 1.5 enum */
#define GL_STREAM_READ												0x88E1 /**< @brief OpenGL 1.5 enum */
#define GL_STREAM_COPY												0x88E2 /**< @brief OpenGL 1.5 enum */
#define GL_STATIC_DRAW												0x88E4 /**< @brief OpenGL 1.5 enum */
#define GL_STATIC_READ												0x88E5 /**< @brief OpenGL 1.5 enum */
#define GL_STATIC_COPY												0x88E6 /**< @brief OpenGL 1.5 enum */
#define GL_DYNAMIC_DRAW												0x88E8 /**< @brief OpenGL 1.5 enum */
#define GL_DYNAMIC_READ												0x88E9 /**< @brief OpenGL 1.5 enum */
#define GL_DYNAMIC_COPY												0x88EA /**< @brief OpenGL 1.5 enum */
#define GL_SAMPLES_PASSED											0x8914 /**< @brief OpenGL 1.5 enum */
//#define GL_FOG_COORD_SRC											  GL_FOG_COORDINATE_SOURCE // deprecated
//#define GL_FOG_COORD												  GL_FOG_COORDINATE // deprecated
//#define GL_CURRENT_FOG_COORD										  GL_CURRENT_FOG_COORDINATE // deprecated
//#define GL_FOG_COORD_ARRAY_TYPE									  GL_FOG_COORDINATE_ARRAY_TYPE // deprecated
//#define GL_FOG_COORD_ARRAY_STRIDE									  GL_FOG_COORDINATE_ARRAY_STRIDE // deprecated
//#define GL_FOG_COORD_ARRAY_POINTER								  GL_FOG_COORDINATE_ARRAY_POINTER // deprecated
//#define GL_FOG_COORD_ARRAY										  GL_FOG_COORDINATE_ARRAY // deprecated
//#define GL_FOG_COORD_ARRAY_BUFFER_BINDING							  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING // deprecated
//#define GL_SRC0_RGB												  GL_SOURCE0_RGB // deprecated
//#define GL_SRC1_RGB												  GL_SOURCE1_RGB // deprecated
//#define GL_SRC2_RGB												  GL_SOURCE2_RGB // deprecated
//#define GL_SRC0_ALPHA												  GL_SOURCE0_ALPHA // deprecated
//#define GL_SRC1_ALPHA												  GL_SOURCE1_ALPHA // deprecated
//#define GL_SRC2_ALPHA												  GL_SOURCE2_ALPHA // deprecated

/**
 *	@brief generate query object names
 *	@param[in] n Specifies the number of query object names to be generated.
 *	@param[out] ids Specifies an array in which the generated query object names are stored.
 */
extern void (GLApi *GLFuncPtrName(glGenQueries))(GLsizei n, GLuint *ids);

/**
 *	@brief delete named query objects
 *	@param[in] n Specifies the number of query objects to be deleted.
 *	@param[in] ids Specifies an array of query objects to be deleted.
 */
extern void (GLApi *GLFuncPtrName(glDeleteQueries))(GLsizei n, const GLuint *ids);

/**
 *	@brief determine if a name corresponds to a query object
 *	@param[in] id Specifies a value that may be the name of a query object.
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsQuery))(GLuint id);

/**
 *	@brief delimit the boundaries of a query object
 *	@param[in] target Specifies the target type of query object established between glBeginQuery and
 *		the subsequent glEndQuery. The symbolic constant must be one of GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
 *	@param[in] id Specifies the name of a query object.
 */
extern void (GLApi *GLFuncPtrName(glBeginQuery))(GLenum target, GLuint id);

/**
 *	@brief delimit the boundaries of a query object
 *	@param[in] target Specifies the target type of query object to be concluded. The symbolic
 *		constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
 */
extern void (GLApi *GLFuncPtrName(glEndQuery))(GLenum target);

/**
 *	@brief return parameters of a query object target
 *	@param[in] target Specifies a query object target. Must be GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
 *		GL_TIME_ELAPSED, or GL_TIMESTAMP.
 *	@param[in] pname Specifies the symbolic name of a query object target parameter. Accepted values
 *		are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetQueryiv))(GLenum target, GLenum pname, int *params);

/**
 *	@brief return parameters of a query object
 *	@param[in] id Specifies the name of a query object.
 *	@param[in] pname Specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetQueryObjectiv))(GLuint id, GLenum pname, int *params);

/**
 *	@brief return parameters of a query object
 *	@param[in] id Specifies the name of a query object.
 *	@param[in] pname Specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetQueryObjectuiv))(GLuint id, GLenum pname, GLuint *params);

/**
 *	@brief bind a named buffer object
 *	@param[in] target Specifies the target to which the buffer object is bound. The symbolic
 *		constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER,
 *		GL_DRAW_INDIRECT_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER,
 *		GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] buffer Specifies the name of a buffer object.
 */
extern void (GLApi *GLFuncPtrName(glBindBuffer))(GLenum target, GLuint buffer);

/**
 *	@brief delete named buffer objects
 *	@param[in] n Specifies the number of buffer objects to be deleted.
 *	@param[in] buffers Specifies an array of buffer objects to be deleted.
 */
extern void (GLApi *GLFuncPtrName(glDeleteBuffers))(GLsizei n, const GLuint *buffers);

/**
 *	@brief generate buffer object names
 *	@param[in] n Specifies the number of buffer object names to be generated.
 *	@param[out] buffers Specifies an array in which the generated buffer object names are stored.
 */
extern void (GLApi *GLFuncPtrName(glGenBuffers))(GLsizei n, GLuint *buffers);

/**
 *	@brief determine if a name corresponds to a buffer object
 *	@param[in] buffer Specifies a value that may be the name of a buffer object.
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsBuffer))(GLuint buffer);

/**
 *	@brief creates and initializes a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] size Specifies the size in bytes of the buffer object's new data store.
 *	@param[in] data Specifies a pointer to data that will be copied into the data store for
 *		initialization, or NULL if no data is to be copied.
 *	@param[in] usage Specifies the expected usage pattern of the data store. The symbolic constant
 *		must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ,
 *		GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
 */
extern void (GLApi *GLFuncPtrName(glBufferData))(GLenum target, GLsizeiptr size, const void *data, GLenum usage);

/**
 *	@brief updates a subset of a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] offset Specifies the offset into the buffer object's data store where data
 *		replacement will begin, measured in bytes.
 *	@param[in] size Specifies the size in bytes of the data store region being replaced.
 *	@param[in] data Specifies a pointer to the new data that will be copied into the data store.
 */
extern void (GLApi *GLFuncPtrName(glBufferSubData))(GLenum target, GLintptr offset, GLsizeiptr size, const void *data);

/**
 *	@brief returns a subset of a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] offset Specifies the offset into the buffer object's data store from which data will
 *		be returned, measured in bytes.
 *	@param[in] size Specifies the size in bytes of the data store region being returned.
 *	@param[out] data Specifies a pointer to the location where buffer object data is returned.
 */
extern void (GLApi *GLFuncPtrName(glGetBufferSubData))(GLenum target, GLintptr offset, GLsizeiptr size, void *data);

/**
 *	@brief map a buffer object's data store
 *	@param[in] target Specifies the target buffer object being mapped. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] access Specifies the access policy, indicating whether it will be possible to read
 *		from, write to, or both read from and write to the buffer object's mapped data store. The
 *		symbolic constant must be GL_READ_ONLY, GL_WRITE_ONLY, or GL_READ_WRITE.
 */
extern void* (GLApi *GLFuncPtrName(glMapBuffer))(GLenum target, GLenum access);

/**
 *	@brief map a buffer object's data store
 *	@param[in] target Specifies the target buffer object being unmapped. The symbolic constant must
 *		be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 */
extern GLboolean (GLApi *GLFuncPtrName(glUnmapBuffer))(GLenum target);

/**
 *	@brief return parameters of a buffer object
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] value Specifies the symbolic name of a buffer object parameter. Accepted values are
 *		GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
 *	@param[out] data Returns the requested parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetBufferParameteriv))(GLenum target, GLenum value, int *data);

/**
 *	@brief return the pointer to a mapped buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] pname Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
 *	@param[out] params Returns the pointer value specified by pname.
 */
extern void (GLApi *GLFuncPtrName(glGetBufferPointerv))(GLenum target, GLenum pname, void **params);

inline GLboolean glIsQuery_glachwrap(GLuint id, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsQuery)(id); GL_AUTOCHECK_BLOCK("glIsQuery", p_s_filename, n_line); return result; }
inline GLboolean glIsBuffer_glachwrap(GLuint buffer, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsBuffer)(buffer); GL_AUTOCHECK_BLOCK("glIsBuffer", p_s_filename, n_line); return result; }
inline void *glMapBuffer_glachwrap(GLenum target, GLenum access, const char *p_s_filename, int n_line) { void *result = GLFuncPtrName(glMapBuffer)(target,access); GL_AUTOCHECK_BLOCK("glMapBuffer", p_s_filename, n_line); return result; }
inline GLboolean glUnmapBuffer_glachwrap(GLenum target, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glUnmapBuffer)(target); GL_AUTOCHECK_BLOCK("glUnmapBuffer", p_s_filename, n_line); return result; }

/**
 *	@def glGenQueries
 *	@brief generate query object names
 *	@param[in] n Specifies the number of query object names to be generated.
 *	@param[out] ids Specifies an array in which the generated query object names are stored.
 */
#define glGenQueries(n,ids) do { GLFuncPtrName(glGenQueries)(n, ids); GL_AUTOCHECK_BLOCK("glGenQueries", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteQueries
 *	@brief delete named query objects
 *	@param[in] n Specifies the number of query objects to be deleted.
 *	@param[in] ids Specifies an array of query objects to be deleted.
 */
#define glDeleteQueries(n,ids) do { GLFuncPtrName(glDeleteQueries)(n, ids); GL_AUTOCHECK_BLOCK("glDeleteQueries", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsQuery
 *	@brief determine if a name corresponds to a query object
 *	@param[in] id Specifies a value that may be the name of a query object.
 */
#define glIsQuery(id) GLAutoCheckFuncPtrName(glIsQuery)(id GLAutoCheckExtraParams)

/**
 *	@def glBeginQuery
 *	@brief delimit the boundaries of a query object
 *	@param[in] target Specifies the target type of query object established between glBeginQuery and
 *		the subsequent glEndQuery. The symbolic constant must be one of GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
 *	@param[in] id Specifies the name of a query object.
 */
#define glBeginQuery(target,id) do { GLFuncPtrName(glBeginQuery)(target, id); GL_AUTOCHECK_BLOCK("glBeginQuery", __FILE__, __LINE__); } while(0)

/**
 *	@def glEndQuery
 *	@brief delimit the boundaries of a query object
 *	@param[in] target Specifies the target type of query object to be concluded. The symbolic
 *		constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
 */
#define glEndQuery(target) do { GLFuncPtrName(glEndQuery)(target); GL_AUTOCHECK_BLOCK("glEndQuery", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryiv
 *	@brief return parameters of a query object target
 *	@param[in] target Specifies a query object target. Must be GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
 *		GL_TIME_ELAPSED, or GL_TIMESTAMP.
 *	@param[in] pname Specifies the symbolic name of a query object target parameter. Accepted values
 *		are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
 *	@param[out] params Returns the requested data.
 */
#define glGetQueryiv(target,pname,params) do { GLFuncPtrName(glGetQueryiv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryObjectiv
 *	@brief return parameters of a query object
 *	@param[in] id Specifies the name of a query object.
 *	@param[in] pname Specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
 *	@param[out] params Returns the requested data.
 */
#define glGetQueryObjectiv(id,pname,params) do { GLFuncPtrName(glGetQueryObjectiv)(id, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryObjectiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryObjectuiv
 *	@brief return parameters of a query object
 *	@param[in] id Specifies the name of a query object.
 *	@param[in] pname Specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
 *	@param[out] params Returns the requested data.
 */
#define glGetQueryObjectuiv(id,pname,params) do { GLFuncPtrName(glGetQueryObjectuiv)(id, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryObjectuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindBuffer
 *	@brief bind a named buffer object
 *	@param[in] target Specifies the target to which the buffer object is bound. The symbolic
 *		constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER,
 *		GL_DRAW_INDIRECT_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER,
 *		GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] buffer Specifies the name of a buffer object.
 */
#define glBindBuffer(target,buffer) do { GLFuncPtrName(glBindBuffer)(target, buffer); GL_AUTOCHECK_BLOCK("glBindBuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteBuffers
 *	@brief delete named buffer objects
 *	@param[in] n Specifies the number of buffer objects to be deleted.
 *	@param[in] buffers Specifies an array of buffer objects to be deleted.
 */
#define glDeleteBuffers(n,buffers) do { GLFuncPtrName(glDeleteBuffers)(n, buffers); GL_AUTOCHECK_BLOCK("glDeleteBuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenBuffers
 *	@brief generate buffer object names
 *	@param[in] n Specifies the number of buffer object names to be generated.
 *	@param[out] buffers Specifies an array in which the generated buffer object names are stored.
 */
#define glGenBuffers(n,buffers) do { GLFuncPtrName(glGenBuffers)(n, buffers); GL_AUTOCHECK_BLOCK("glGenBuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsBuffer
 *	@brief determine if a name corresponds to a buffer object
 *	@param[in] buffer Specifies a value that may be the name of a buffer object.
 */
#define glIsBuffer(buffer) GLAutoCheckFuncPtrName(glIsBuffer)(buffer GLAutoCheckExtraParams)

/**
 *	@def glBufferData
 *	@brief creates and initializes a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] size Specifies the size in bytes of the buffer object's new data store.
 *	@param[in] data Specifies a pointer to data that will be copied into the data store for
 *		initialization, or NULL if no data is to be copied.
 *	@param[in] usage Specifies the expected usage pattern of the data store. The symbolic constant
 *		must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ,
 *		GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
 */
#define glBufferData(target,size,data,usage) do { GLFuncPtrName(glBufferData)(target, size, data, usage); GL_AUTOCHECK_BLOCK("glBufferData", __FILE__, __LINE__); } while(0)

/**
 *	@def glBufferSubData
 *	@brief updates a subset of a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] offset Specifies the offset into the buffer object's data store where data
 *		replacement will begin, measured in bytes.
 *	@param[in] size Specifies the size in bytes of the data store region being replaced.
 *	@param[in] data Specifies a pointer to the new data that will be copied into the data store.
 */
#define glBufferSubData(target,offset,size,data) do { GLFuncPtrName(glBufferSubData)(target, offset, size, data); GL_AUTOCHECK_BLOCK("glBufferSubData", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetBufferSubData
 *	@brief returns a subset of a buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] offset Specifies the offset into the buffer object's data store from which data will
 *		be returned, measured in bytes.
 *	@param[in] size Specifies the size in bytes of the data store region being returned.
 *	@param[out] data Specifies a pointer to the location where buffer object data is returned.
 */
#define glGetBufferSubData(target,offset,size,data) do { GLFuncPtrName(glGetBufferSubData)(target, offset, size, data); GL_AUTOCHECK_BLOCK("glGetBufferSubData", __FILE__, __LINE__); } while(0)

/**
 *	@def glMapBuffer
 *	@brief map a buffer object's data store
 *	@param[in] target Specifies the target buffer object being mapped. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] access Specifies the access policy, indicating whether it will be possible to read
 *		from, write to, or both read from and write to the buffer object's mapped data store. The
 *		symbolic constant must be GL_READ_ONLY, GL_WRITE_ONLY, or GL_READ_WRITE.
 */
#define glMapBuffer(target,access) GLAutoCheckFuncPtrName(glMapBuffer)(target, access GLAutoCheckExtraParams)

/**
 *	@def glUnmapBuffer
 *	@brief map a buffer object's data store
 *	@param[in] target Specifies the target buffer object being unmapped. The symbolic constant must
 *		be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 */
#define glUnmapBuffer(target) GLAutoCheckFuncPtrName(glUnmapBuffer)(target GLAutoCheckExtraParams)

/**
 *	@def glGetBufferParameteriv
 *	@brief return parameters of a buffer object
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] value Specifies the symbolic name of a buffer object parameter. Accepted values are
 *		GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
 *	@param[out] data Returns the requested parameter.
 */
#define glGetBufferParameteriv(target,value,data) do { GLFuncPtrName(glGetBufferParameteriv)(target, value, data); GL_AUTOCHECK_BLOCK("glGetBufferParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetBufferPointerv
 *	@brief return the pointer to a mapped buffer object's data store
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] pname Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
 *	@param[out] params Returns the pointer value specified by pname.
 */
#define glGetBufferPointerv(target,pname,params) do { GLFuncPtrName(glGetBufferPointerv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetBufferPointerv", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_1_5

//								--- ~OpenGL 1.5 ---

//								--- OpenGL 2.0 ---

/**
 *	@def GL_VERSION_2_0
 *	@brief if defined, OpenGL 2.0 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_2_0
#define GL_VERSION_2_0 1

/**
 *	@def __GENERATE_GL_20__
 *	@brief if defined, code to initialize OpenGL 2.0 entry points is compiled
 */
#define __GENERATE_GL_20__

extern bool GLEH_OPENGL_2_0; /**< @brief set if OpenGL 2.0 is supported */

#define GL_BLEND_EQUATION_RGB										0x8009 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED								0x8622 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_SIZE									0x8623 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE								0x8624 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_TYPE									0x8625 /**< @brief OpenGL 2.0 enum */
#define GL_CURRENT_VERTEX_ATTRIB									0x8626 /**< @brief OpenGL 2.0 enum */
//#define GL_VERTEX_PROGRAM_POINT_SIZE								  0x8642 // deprecated (in OpenGL 3.2; use GL_PROGRAM_POINT_SIZE)
//#define GL_VERTEX_PROGRAM_TWO_SIDE								  0x8643 // deprecated
#define GL_VERTEX_ATTRIB_ARRAY_POINTER								0x8645 /**< @brief OpenGL 2.0 enum */
//#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING						  0x889F // deprecated
#define GL_STENCIL_BACK_FUNC										0x8800 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_FAIL										0x8801 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL								0x8802 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_PASS_DEPTH_PASS								0x8803 /**< @brief OpenGL 2.0 enum */
#define GL_MAX_DRAW_BUFFERS											0x8824 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER0												0x8825 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER1												0x8826 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER2												0x8827 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER3												0x8828 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER4												0x8829 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER5												0x882A /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER6												0x882B /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER7												0x882C /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER8												0x882D /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER9												0x882E /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER10											0x882F /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER11											0x8830 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER12											0x8831 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER13											0x8832 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER14											0x8833 /**< @brief OpenGL 2.0 enum */
#define GL_DRAW_BUFFER15											0x8834 /**< @brief OpenGL 2.0 enum */
#define GL_BLEND_EQUATION_ALPHA										0x883D /**< @brief OpenGL 2.0 enum */
#define GL_MAX_VERTEX_ATTRIBS										0x8869 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED							0x886A /**< @brief OpenGL 2.0 enum */
#define GL_MAX_TEXTURE_IMAGE_UNITS									0x8872 /**< @brief OpenGL 2.0 enum */
#define GL_FRAGMENT_SHADER											0x8B30 /**< @brief OpenGL 2.0 enum */
#define GL_VERTEX_SHADER											0x8B31 /**< @brief OpenGL 2.0 enum */
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS							0x8B49 /**< @brief OpenGL 2.0 enum */
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS							0x8B4A /**< @brief OpenGL 2.0 enum */
//#define GL_MAX_VARYING_FLOATS										  0x8B4B // deprecated
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS							0x8B4C /**< @brief OpenGL 2.0 enum */
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS							0x8B4D /**< @brief OpenGL 2.0 enum */
//#define GL_MAX_TEXTURE_COORDS										  0x8871 // deprecated
#define GL_SHADER_TYPE												0x8B4F /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_VEC2												0x8B50 /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_VEC3												0x8B51 /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_VEC4												0x8B52 /**< @brief OpenGL 2.0 enum */
#define GL_INT_VEC2													0x8B53 /**< @brief OpenGL 2.0 enum */
#define GL_INT_VEC3													0x8B54 /**< @brief OpenGL 2.0 enum */
#define GL_INT_VEC4													0x8B55 /**< @brief OpenGL 2.0 enum */
#define GL_BOOL														0x8B56 /**< @brief OpenGL 2.0 enum */
#define GL_BOOL_VEC2												0x8B57 /**< @brief OpenGL 2.0 enum */
#define GL_BOOL_VEC3												0x8B58 /**< @brief OpenGL 2.0 enum */
#define GL_BOOL_VEC4												0x8B59 /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_MAT2												0x8B5A /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_MAT3												0x8B5B /**< @brief OpenGL 2.0 enum */
#define GL_FLOAT_MAT4												0x8B5C /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_1D												0x8B5D /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_2D												0x8B5E /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_3D												0x8B5F /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_CUBE												0x8B60 /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_1D_SHADOW										0x8B61 /**< @brief OpenGL 2.0 enum */
#define GL_SAMPLER_2D_SHADOW										0x8B62 /**< @brief OpenGL 2.0 enum */
#define GL_DELETE_STATUS											0x8B80 /**< @brief OpenGL 2.0 enum */
#define GL_COMPILE_STATUS											0x8B81 /**< @brief OpenGL 2.0 enum */
#define GL_LINK_STATUS												0x8B82 /**< @brief OpenGL 2.0 enum */
#define GL_VALIDATE_STATUS											0x8B83 /**< @brief OpenGL 2.0 enum */
#define GL_INFO_LOG_LENGTH											0x8B84 /**< @brief OpenGL 2.0 enum */
#define GL_ATTACHED_SHADERS											0x8B85 /**< @brief OpenGL 2.0 enum */
#define GL_ACTIVE_UNIFORMS											0x8B86 /**< @brief OpenGL 2.0 enum */
#define GL_ACTIVE_UNIFORM_MAX_LENGTH								0x8B87 /**< @brief OpenGL 2.0 enum */
#define GL_SHADER_SOURCE_LENGTH										0x8B88 /**< @brief OpenGL 2.0 enum */
#define GL_ACTIVE_ATTRIBUTES										0x8B89 /**< @brief OpenGL 2.0 enum */
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH								0x8B8A /**< @brief OpenGL 2.0 enum */
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT							0x8B8B /**< @brief OpenGL 2.0 enum */
#define GL_SHADING_LANGUAGE_VERSION									0x8B8C /**< @brief OpenGL 2.0 enum */
#define GL_CURRENT_PROGRAM											0x8B8D /**< @brief OpenGL 2.0 enum */
//#define GL_POINT_SPRITE											  0x8861 // deprecated
//#define GL_COORD_REPLACE											  0x8862 // deprecated
#define GL_POINT_SPRITE_COORD_ORIGIN								0x8CA0 /**< @brief OpenGL 2.0 enum */
#define GL_LOWER_LEFT												0x8CA1 /**< @brief OpenGL 2.0 enum */
#define GL_UPPER_LEFT												0x8CA2 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_REF											0x8CA3 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_VALUE_MASK									0x8CA4 /**< @brief OpenGL 2.0 enum */
#define GL_STENCIL_BACK_WRITEMASK									0x8CA5 /**< @brief OpenGL 2.0 enum */

/**
 *	@brief set the RGB blend equation and the alpha blend equation separately
 *	@param[in] modeRGB specifies the RGB blend equation, how the red, green, and blue components of
 *		the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 *	@param[in] modeAlpha specifies the alpha blend equation, how the alpha component of the source
 *		and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 */
extern void (GLApi *GLFuncPtrName(glBlendEquationSeparate))(GLenum modeRGB, GLenum modeAlpha);

/**
 *	@brief Specifies a list of color buffers to be drawn into
 *	@param[in] n Specifies the number of buffers in bufs.
 *	@param[in] bufs Points to an array of symbolic constants specifying the buffers into which
 *		fragment colors or data values will be written.
 */
extern void (GLApi *GLFuncPtrName(glDrawBuffers))(GLsizei n, const GLenum *bufs);

/**
 *	@brief set front and/or back stencil test actions
 *	@param[in] face Specifies whether front and/or back stencil state is updated. Three symbolic
 *		constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] sfail Specifies the action to take when the stencil test fails. Eight symbolic
 *		constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR,
 *		GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
 *	@param[in] dpfail Specifies the stencil action when the stencil test passes, but the depth test
 *		fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 *	@param[in] dppass Specifies the stencil action when both the stencil test and the depth test
 *		pass, or when the stencil test passes and either there is no depth buffer or depth testing
 *		is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 */
extern void (GLApi *GLFuncPtrName(glStencilOpSeparate))(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);

/**
 *	@brief set front and/or back function and reference value for stencil testing
 *	@param[in] face Specifies whether front and/or back stencil state is updated. Three symbolic
 *		constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] func Specifies the test function. Eight symbolic constants are valid: GL_NEVER,
 *		GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial
 *		value is GL_ALWAYS.
 *	@param[in] ref Specifies the reference value for the stencil test. ref is clamped to the range 0
 *		2 n - 1, where n is the number of bitplanes in the stencil buffer. The initial value is 0.
 *	@param[in] mask Specifies a mask that is ANDed with both the reference value and the stored
 *		stencil value when the test is done. The initial value is all 1's.
 */
extern void (GLApi *GLFuncPtrName(glStencilFuncSeparate))(GLenum face, GLenum func, int ref, GLuint mask);

/**
 *	@brief control the front and/or back writing of individual bits in the stencil planes
 *	@param[in] face Specifies whether the front and/or back stencil writemask is updated. Three
 *		symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] mask Specifies a bit mask to enable and disable writing of individual bits in the
 *		stencil planes. Initially, the mask is all 1's.
 */
extern void (GLApi *GLFuncPtrName(glStencilMaskSeparate))(GLenum face, GLuint mask);

/**
 *	@brief Attaches a shader object to a program object
 *	@param[in] program Specifies the program object to which a shader object will be attached.
 *	@param[in] shader Specifies the shader object that is to be attached.
 */
extern void (GLApi *GLFuncPtrName(glAttachShader))(GLuint program, GLuint shader);

/**
 *	@brief Associates a generic vertex attribute index with a named attribute variable
 *	@param[in] program Specifies the handle of the program object in which the association is to be made.
 *	@param[in] index Specifies the index of the generic vertex attribute to be bound.
 *	@param[in] name Specifies a null terminated string containing the name of the vertex shader
 *		attribute variable to which index is to be bound.
 */
extern void (GLApi *GLFuncPtrName(glBindAttribLocation))(GLuint program, GLuint index, const GLchar *name);

/**
 *	@brief Compiles a shader object
 *	@param[in] shader Specifies the shader object to be compiled.
 */
extern void (GLApi *GLFuncPtrName(glCompileShader))(GLuint shader);

/**
 *	@brief Creates a program object
 */
extern GLuint (GLApi *GLFuncPtrName(glCreateProgram))();

/**
 *	@brief Creates a shader object
 *	@param[in] shaderType Specifies the type of shader to be created. Must be one of
 *		GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER, or GL_FRAGMENT_SHADER.
 */
extern GLuint (GLApi *GLFuncPtrName(glCreateShader))(GLenum shaderType);

/**
 *	@brief Deletes a program object
 *	@param[in] program Specifies the program object to be deleted.
 */
extern void (GLApi *GLFuncPtrName(glDeleteProgram))(GLuint program);

/**
 *	@brief Deletes a shader object
 *	@param[in] shader Specifies the shader object to be deleted.
 */
extern void (GLApi *GLFuncPtrName(glDeleteShader))(GLuint shader);

/**
 *	@brief Detaches a shader object from a program object to which it is attached
 *	@param[in] program Specifies the program object from which to detach the shader object.
 *	@param[in] shader Specifies the shader object to be detached.
 */
extern void (GLApi *GLFuncPtrName(glDetachShader))(GLuint program, GLuint shader);

/**
 *	@brief Enable or disable a generic vertex attribute array
 *	@param[in] index Specifies the index of the generic vertex attribute to be enabled or disabled.
 */
extern void (GLApi *GLFuncPtrName(glDisableVertexAttribArray))(GLuint index);

/**
 *	@brief Enable or disable a generic vertex attribute array
 *	@param[in] index Specifies the index of the generic vertex attribute to be enabled or disabled.
 */
extern void (GLApi *GLFuncPtrName(glEnableVertexAttribArray))(GLuint index);

/**
 *	@brief Returns information about an active attribute variable for the specified program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] index Specifies the index of the attribute variable to be queried.
 *	@param[in] bufSize Specifies the maximum number of characters OpenGL is allowed to write in the
 *		character buffer indicated by name.
 *	@param[out] length Returns the number of characters actually written by OpenGL in the string
 *		indicated by name (excluding the null terminator) if a value other than NULL is passed.
 *	@param[out] size Returns the size of the attribute variable.
 *	@param[out] type Returns the data type of the attribute variable.
 *	@param[out] name Returns a null terminated string containing the name of the attribute variable.
 */
extern void (GLApi *GLFuncPtrName(glGetActiveAttrib))(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);

/**
 *	@brief Returns information about an active uniform variable for the specified program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] index Specifies the index of the uniform variable to be queried.
 *	@param[in] bufSize Specifies the maximum number of characters OpenGL is allowed to write in the
 *		character buffer indicated by name.
 *	@param[out] length Returns the number of characters actually written by OpenGL in the string
 *		indicated by name (excluding the null terminator) if a value other than NULL is passed.
 *	@param[out] size Returns the size of the uniform variable.
 *	@param[out] type Returns the data type of the uniform variable.
 *	@param[out] name Returns a null terminated string containing the name of the uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glGetActiveUniform))(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);

/**
 *	@brief Returns the handles of the shader objects attached to a program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] maxCount Specifies the size of the array for storing the returned object names.
 *	@param[out] count Returns the number of names actually returned in objects.
 *	@param[out] shaders Specifies an array that is used to return the names of attached shader objects.
 */
extern void (GLApi *GLFuncPtrName(glGetAttachedShaders))(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders);

/**
 *	@brief Returns the location of an attribute variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] name Points to a null terminated string containing the name of the attribute variable
 *		whose location is to be queried.
 */
extern int (GLApi *GLFuncPtrName(glGetAttribLocation))(GLuint program, const GLchar *name);

/**
 *	@brief Returns a parameter from a program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] pname Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS,
 *		GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS,
 *		GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS,
 *		GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH,
 *		GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE,
 *		GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH,
 *		GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
 *	@param[out] params Returns the requested object parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetProgramiv))(GLuint program, GLenum pname, int *params);

/**
 *	@brief Returns the information log for a program object
 *	@param[in] program Specifies the program object whose information log is to be queried.
 *	@param[in] maxLength Specifies the size of the character buffer for storing the returned
 *		information log.
 *	@param[out] length Returns the length of the string returned in infoLog (excluding the null terminator).
 *	@param[out] infoLog Specifies an array of characters that is used to return the information log.
 */
extern void (GLApi *GLFuncPtrName(glGetProgramInfoLog))(GLuint program, GLsizei maxLength, GLsizei *length, GLchar *infoLog);

/**
 *	@brief Returns a parameter from a shader object
 *	@param[in] shader Specifies the shader object to be queried.
 *	@param[in] pname Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE,
 *		GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
 *	@param[out] params Returns the requested object parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetShaderiv))(GLuint shader, GLenum pname, int *params);

/**
 *	@brief Returns the information log for a shader object
 *	@param[in] shader Specifies the shader object whose information log is to be queried.
 *	@param[in] maxLength Specifies the size of the character buffer for storing the returned
 *		information log.
 *	@param[out] length Returns the length of the string returned in infoLog (excluding the null terminator).
 *	@param[out] infoLog Specifies an array of characters that is used to return the information log.
 */
extern void (GLApi *GLFuncPtrName(glGetShaderInfoLog))(GLuint shader, GLsizei maxLength, GLsizei *length, GLchar *infoLog);

/**
 *	@brief Replaces the source code in a shader object
 *	@param[in] shader Specifies the handle of the shader object whose source code is to be replaced.
 *	@param[in] count Specifies the number of elements in the string and length arrays.
 *	@param[in] string Specifies an array of pointers to strings containing the source code to be
 *		loaded into the shader.
 *	@param[in] length Specifies an array of string lengths.
 */
extern void (GLApi *GLFuncPtrName(glShaderSource))(GLuint shader, GLsizei count, const GLchar **string, const int *length);

/**
 *	@brief Returns the location of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] name Points to a null terminated string containing the name of the uniform variable
 *		whose location is to be queried.
 */
extern int (GLApi *GLFuncPtrName(glGetUniformLocation))(GLuint program, const GLchar *name);

/**
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glGetUniformfv))(GLuint program, int location, float *params);

/**
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glGetUniformiv))(GLuint program, int location, int *params);

/**
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribdv))(GLuint index, GLenum pname, double *params);

/**
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribfv))(GLuint index, GLenum pname, float *params);

/**
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribiv))(GLuint index, GLenum pname, int *params);

/**
 *	@brief return the address of the specified generic vertex attribute pointer
 *	@param[in] index Specifies the generic vertex attribute parameter to be returned.
 *	@param[in] pname Specifies the symbolic name of the generic vertex attribute parameter to be
 *		returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
 *	@param[out] pointer Returns the pointer value.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribPointerv))(GLuint index, GLenum pname, void **pointer);

/**
 *	@brief Determines if a name corresponds to a program object
 *	@param[in] program Specifies a potential program object.
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsProgram))(GLuint program);

/**
 *	@brief Determines if a name corresponds to a shader object
 *	@param[in] shader Specifies a potential shader object.
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsShader))(GLuint shader);

/**
 *	@brief Links a program object
 *	@param[in] program Specifies the handle of the program object to be linked.
 */
extern void (GLApi *GLFuncPtrName(glLinkProgram))(GLuint program);

/**
 *	@brief Returns the source code string from a shader object
 *	@param[in] shader Specifies the shader object to be queried.
 *	@param[in] bufSize Specifies the size of the character buffer for storing the returned source
 *		code string.
 *	@param[out] length Returns the length of the string returned in source (excluding the null terminator).
 *	@param[out] source Specifies an array of characters that is used to return the source code string.
 */
extern void (GLApi *GLFuncPtrName(glGetShaderSource))(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);

/**
 *	@brief Installs a program object as part of current rendering state
 *	@param[in] program Specifies the handle of the program object whose executables are to be used
 *		as part of current rendering state.
 */
extern void (GLApi *GLFuncPtrName(glUseProgram))(GLuint program);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1f))(int location, float v0);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2f))(int location, float v0, float v1);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3f))(int location, float v0, float v1, float v2);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4f))(int location, float v0, float v1, float v2, float v3);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1i))(int location, int v0);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2i))(int location, int v0, int v1);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3i))(int location, int v0, int v1, int v2);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4i))(int location, int v0, int v1, int v2, int v3);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1fv))(int location, GLsizei count, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2fv))(int location, GLsizei count, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3fv))(int location, GLsizei count, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4fv))(int location, GLsizei count, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1iv))(int location, GLsizei count, const int *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2iv))(int location, GLsizei count, const int *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3iv))(int location, GLsizei count, const int *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4iv))(int location, GLsizei count, const int *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Validates a program object
 *	@param[in] program Specifies the handle of the program object to be validated.
 */
extern void (GLApi *GLFuncPtrName(glValidateProgram))(GLuint program);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1d))(GLuint index, double v0);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dv))(GLuint index, const double *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1f))(GLuint index, float v0);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fv))(GLuint index, const float *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1s))(GLuint index, short v0);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib1sv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2d))(GLuint index, double v0, double v1);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dv))(GLuint index, const double *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2f))(GLuint index, float v0, float v1);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fv))(GLuint index, const float *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2s))(GLuint index, short v0, short v1);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib2sv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3d))(GLuint index, double v0, double v1, double v2);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dv))(GLuint index, const double *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3f))(GLuint index, float v0, float v1, float v2);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fv))(GLuint index, const float *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3s))(GLuint index, short v0, short v1, short v2);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib3sv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nbv))(GLuint index, const GLbyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Niv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nsv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nub))(GLuint index, GLubyte v0, GLubyte v1, GLubyte v2, GLubyte v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nubv))(GLuint index, const GLubyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nuiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nusv))(GLuint index, const GLushort *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4bv))(GLuint index, const GLbyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4d))(GLuint index, double v0, double v1, double v2, double v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dv))(GLuint index, const double *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4f))(GLuint index, float v0, float v1, float v2, float v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fv))(GLuint index, const float *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4iv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4s))(GLuint index, short v0, short v1, short v2, short v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4sv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubv))(GLuint index, const GLubyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4uiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttrib4usv))(GLuint index, const GLushort *v);

/**
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] size Specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4.
 *	@param[in] type Specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT.
 *	@param[in] normalized For glVertexAttribPointer , specifies whether fixed-point data values
 *		should be normalized ( GL_TRUE ) or converted directly as fixed-point values ( GL_FALSE)
 *		when they are accessed.
 *	@param[in] stride Specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0.
 *	@param[in] pointer Specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribPointer))(GLuint index, int size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer);

inline GLuint glCreateProgram_glachwrap(const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glCreateProgram)(); GL_AUTOCHECK_BLOCK("glCreateProgram", p_s_filename, n_line); return result; }
inline GLuint glCreateShader_glachwrap(GLenum shaderType, const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glCreateShader)(shaderType); GL_AUTOCHECK_BLOCK("glCreateShader", p_s_filename, n_line); return result; }
inline int glGetAttribLocation_glachwrap(GLuint program, const GLchar *name, const char *p_s_filename, int n_line) { int result = GLFuncPtrName(glGetAttribLocation)(program,name); GL_AUTOCHECK_BLOCK("glGetAttribLocation", p_s_filename, n_line); return result; }
inline int glGetUniformLocation_glachwrap(GLuint program, const GLchar *name, const char *p_s_filename, int n_line) { int result = GLFuncPtrName(glGetUniformLocation)(program,name); GL_AUTOCHECK_BLOCK("glGetUniformLocation", p_s_filename, n_line); return result; }
inline GLboolean glIsProgram_glachwrap(GLuint program, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsProgram)(program); GL_AUTOCHECK_BLOCK("glIsProgram", p_s_filename, n_line); return result; }
inline GLboolean glIsShader_glachwrap(GLuint shader, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsShader)(shader); GL_AUTOCHECK_BLOCK("glIsShader", p_s_filename, n_line); return result; }

/**
 *	@def glBlendEquationSeparate
 *	@brief set the RGB blend equation and the alpha blend equation separately
 *	@param[in] modeRGB specifies the RGB blend equation, how the red, green, and blue components of
 *		the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 *	@param[in] modeAlpha specifies the alpha blend equation, how the alpha component of the source
 *		and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
 */
#define glBlendEquationSeparate(modeRGB,modeAlpha) do { GLFuncPtrName(glBlendEquationSeparate)(modeRGB, modeAlpha); GL_AUTOCHECK_BLOCK("glBlendEquationSeparate", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawBuffers
 *	@brief Specifies a list of color buffers to be drawn into
 *	@param[in] n Specifies the number of buffers in bufs.
 *	@param[in] bufs Points to an array of symbolic constants specifying the buffers into which
 *		fragment colors or data values will be written.
 */
#define glDrawBuffers(n,bufs) do { GLFuncPtrName(glDrawBuffers)(n, bufs); GL_AUTOCHECK_BLOCK("glDrawBuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilOpSeparate
 *	@brief set front and/or back stencil test actions
 *	@param[in] face Specifies whether front and/or back stencil state is updated. Three symbolic
 *		constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] sfail Specifies the action to take when the stencil test fails. Eight symbolic
 *		constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR,
 *		GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
 *	@param[in] dpfail Specifies the stencil action when the stencil test passes, but the depth test
 *		fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 *	@param[in] dppass Specifies the stencil action when both the stencil test and the depth test
 *		pass, or when the stencil test passes and either there is no depth buffer or depth testing
 *		is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
 */
#define glStencilOpSeparate(face,sfail,dpfail,dppass) do { GLFuncPtrName(glStencilOpSeparate)(face, sfail, dpfail, dppass); GL_AUTOCHECK_BLOCK("glStencilOpSeparate", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilFuncSeparate
 *	@brief set front and/or back function and reference value for stencil testing
 *	@param[in] face Specifies whether front and/or back stencil state is updated. Three symbolic
 *		constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] func Specifies the test function. Eight symbolic constants are valid: GL_NEVER,
 *		GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial
 *		value is GL_ALWAYS.
 *	@param[in] ref Specifies the reference value for the stencil test. ref is clamped to the range 0
 *		2 n - 1, where n is the number of bitplanes in the stencil buffer. The initial value is 0.
 *	@param[in] mask Specifies a mask that is ANDed with both the reference value and the stored
 *		stencil value when the test is done. The initial value is all 1's.
 */
#define glStencilFuncSeparate(face,func,ref,mask) do { GLFuncPtrName(glStencilFuncSeparate)(face, func, ref, mask); GL_AUTOCHECK_BLOCK("glStencilFuncSeparate", __FILE__, __LINE__); } while(0)

/**
 *	@def glStencilMaskSeparate
 *	@brief control the front and/or back writing of individual bits in the stencil planes
 *	@param[in] face Specifies whether the front and/or back stencil writemask is updated. Three
 *		symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
 *	@param[in] mask Specifies a bit mask to enable and disable writing of individual bits in the
 *		stencil planes. Initially, the mask is all 1's.
 */
#define glStencilMaskSeparate(face,mask) do { GLFuncPtrName(glStencilMaskSeparate)(face, mask); GL_AUTOCHECK_BLOCK("glStencilMaskSeparate", __FILE__, __LINE__); } while(0)

/**
 *	@def glAttachShader
 *	@brief Attaches a shader object to a program object
 *	@param[in] program Specifies the program object to which a shader object will be attached.
 *	@param[in] shader Specifies the shader object that is to be attached.
 */
#define glAttachShader(program,shader) do { GLFuncPtrName(glAttachShader)(program, shader); GL_AUTOCHECK_BLOCK("glAttachShader", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindAttribLocation
 *	@brief Associates a generic vertex attribute index with a named attribute variable
 *	@param[in] program Specifies the handle of the program object in which the association is to be made.
 *	@param[in] index Specifies the index of the generic vertex attribute to be bound.
 *	@param[in] name Specifies a null terminated string containing the name of the vertex shader
 *		attribute variable to which index is to be bound.
 */
#define glBindAttribLocation(program,index,name) do { GLFuncPtrName(glBindAttribLocation)(program, index, name); GL_AUTOCHECK_BLOCK("glBindAttribLocation", __FILE__, __LINE__); } while(0)

/**
 *	@def glCompileShader
 *	@brief Compiles a shader object
 *	@param[in] shader Specifies the shader object to be compiled.
 */
#define glCompileShader(shader) do { GLFuncPtrName(glCompileShader)(shader); GL_AUTOCHECK_BLOCK("glCompileShader", __FILE__, __LINE__); } while(0)

/**
 *	@def glCreateProgram
 *	@brief Creates a program object
 */
#define glCreateProgram() GLAutoCheckFuncPtrName(glCreateProgram)(GLAutoCheckExtraParamsSA)

/**
 *	@def glCreateShader
 *	@brief Creates a shader object
 *	@param[in] shaderType Specifies the type of shader to be created. Must be one of
 *		GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER, or GL_FRAGMENT_SHADER.
 */
#define glCreateShader(shaderType) GLAutoCheckFuncPtrName(glCreateShader)(shaderType GLAutoCheckExtraParams)

/**
 *	@def glDeleteProgram
 *	@brief Deletes a program object
 *	@param[in] program Specifies the program object to be deleted.
 */
#define glDeleteProgram(program) do { GLFuncPtrName(glDeleteProgram)(program); GL_AUTOCHECK_BLOCK("glDeleteProgram", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteShader
 *	@brief Deletes a shader object
 *	@param[in] shader Specifies the shader object to be deleted.
 */
#define glDeleteShader(shader) do { GLFuncPtrName(glDeleteShader)(shader); GL_AUTOCHECK_BLOCK("glDeleteShader", __FILE__, __LINE__); } while(0)

/**
 *	@def glDetachShader
 *	@brief Detaches a shader object from a program object to which it is attached
 *	@param[in] program Specifies the program object from which to detach the shader object.
 *	@param[in] shader Specifies the shader object to be detached.
 */
#define glDetachShader(program,shader) do { GLFuncPtrName(glDetachShader)(program, shader); GL_AUTOCHECK_BLOCK("glDetachShader", __FILE__, __LINE__); } while(0)

/**
 *	@def glDisableVertexAttribArray
 *	@brief Enable or disable a generic vertex attribute array
 *	@param[in] index Specifies the index of the generic vertex attribute to be enabled or disabled.
 */
#define glDisableVertexAttribArray(index) do { GLFuncPtrName(glDisableVertexAttribArray)(index); GL_AUTOCHECK_BLOCK("glDisableVertexAttribArray", __FILE__, __LINE__); } while(0)

/**
 *	@def glEnableVertexAttribArray
 *	@brief Enable or disable a generic vertex attribute array
 *	@param[in] index Specifies the index of the generic vertex attribute to be enabled or disabled.
 */
#define glEnableVertexAttribArray(index) do { GLFuncPtrName(glEnableVertexAttribArray)(index); GL_AUTOCHECK_BLOCK("glEnableVertexAttribArray", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveAttrib
 *	@brief Returns information about an active attribute variable for the specified program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] index Specifies the index of the attribute variable to be queried.
 *	@param[in] bufSize Specifies the maximum number of characters OpenGL is allowed to write in the
 *		character buffer indicated by name.
 *	@param[out] length Returns the number of characters actually written by OpenGL in the string
 *		indicated by name (excluding the null terminator) if a value other than NULL is passed.
 *	@param[out] size Returns the size of the attribute variable.
 *	@param[out] type Returns the data type of the attribute variable.
 *	@param[out] name Returns a null terminated string containing the name of the attribute variable.
 */
#define glGetActiveAttrib(program,index,bufSize,length,size,type,name) do { GLFuncPtrName(glGetActiveAttrib)(program, index, bufSize, length, size, type, name); GL_AUTOCHECK_BLOCK("glGetActiveAttrib", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveUniform
 *	@brief Returns information about an active uniform variable for the specified program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] index Specifies the index of the uniform variable to be queried.
 *	@param[in] bufSize Specifies the maximum number of characters OpenGL is allowed to write in the
 *		character buffer indicated by name.
 *	@param[out] length Returns the number of characters actually written by OpenGL in the string
 *		indicated by name (excluding the null terminator) if a value other than NULL is passed.
 *	@param[out] size Returns the size of the uniform variable.
 *	@param[out] type Returns the data type of the uniform variable.
 *	@param[out] name Returns a null terminated string containing the name of the uniform variable.
 */
#define glGetActiveUniform(program,index,bufSize,length,size,type,name) do { GLFuncPtrName(glGetActiveUniform)(program, index, bufSize, length, size, type, name); GL_AUTOCHECK_BLOCK("glGetActiveUniform", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetAttachedShaders
 *	@brief Returns the handles of the shader objects attached to a program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] maxCount Specifies the size of the array for storing the returned object names.
 *	@param[out] count Returns the number of names actually returned in objects.
 *	@param[out] shaders Specifies an array that is used to return the names of attached shader objects.
 */
#define glGetAttachedShaders(program,maxCount,count,shaders) do { GLFuncPtrName(glGetAttachedShaders)(program, maxCount, count, shaders); GL_AUTOCHECK_BLOCK("glGetAttachedShaders", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetAttribLocation
 *	@brief Returns the location of an attribute variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] name Points to a null terminated string containing the name of the attribute variable
 *		whose location is to be queried.
 */
#define glGetAttribLocation(program,name) GLAutoCheckFuncPtrName(glGetAttribLocation)(program, name GLAutoCheckExtraParams)

/**
 *	@def glGetProgramiv
 *	@brief Returns a parameter from a program object
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] pname Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS,
 *		GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS,
 *		GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS,
 *		GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH,
 *		GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE,
 *		GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH,
 *		GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
 *	@param[out] params Returns the requested object parameter.
 */
#define glGetProgramiv(program,pname,params) do { GLFuncPtrName(glGetProgramiv)(program, pname, params); GL_AUTOCHECK_BLOCK("glGetProgramiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetProgramInfoLog
 *	@brief Returns the information log for a program object
 *	@param[in] program Specifies the program object whose information log is to be queried.
 *	@param[in] maxLength Specifies the size of the character buffer for storing the returned
 *		information log.
 *	@param[out] length Returns the length of the string returned in infoLog (excluding the null terminator).
 *	@param[out] infoLog Specifies an array of characters that is used to return the information log.
 */
#define glGetProgramInfoLog(program,maxLength,length,infoLog) do { GLFuncPtrName(glGetProgramInfoLog)(program, maxLength, length, infoLog); GL_AUTOCHECK_BLOCK("glGetProgramInfoLog", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetShaderiv
 *	@brief Returns a parameter from a shader object
 *	@param[in] shader Specifies the shader object to be queried.
 *	@param[in] pname Specifies the object parameter. Accepted symbolic names are GL_SHADER_TYPE,
 *		GL_DELETE_STATUS, GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, GL_SHADER_SOURCE_LENGTH.
 *	@param[out] params Returns the requested object parameter.
 */
#define glGetShaderiv(shader,pname,params) do { GLFuncPtrName(glGetShaderiv)(shader, pname, params); GL_AUTOCHECK_BLOCK("glGetShaderiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetShaderInfoLog
 *	@brief Returns the information log for a shader object
 *	@param[in] shader Specifies the shader object whose information log is to be queried.
 *	@param[in] maxLength Specifies the size of the character buffer for storing the returned
 *		information log.
 *	@param[out] length Returns the length of the string returned in infoLog (excluding the null terminator).
 *	@param[out] infoLog Specifies an array of characters that is used to return the information log.
 */
#define glGetShaderInfoLog(shader,maxLength,length,infoLog) do { GLFuncPtrName(glGetShaderInfoLog)(shader, maxLength, length, infoLog); GL_AUTOCHECK_BLOCK("glGetShaderInfoLog", __FILE__, __LINE__); } while(0)

/**
 *	@def glShaderSource
 *	@brief Replaces the source code in a shader object
 *	@param[in] shader Specifies the handle of the shader object whose source code is to be replaced.
 *	@param[in] count Specifies the number of elements in the string and length arrays.
 *	@param[in] string Specifies an array of pointers to strings containing the source code to be
 *		loaded into the shader.
 *	@param[in] length Specifies an array of string lengths.
 */
#define glShaderSource(shader,count,string,length) do { GLFuncPtrName(glShaderSource)(shader, count, string, length); GL_AUTOCHECK_BLOCK("glShaderSource", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformLocation
 *	@brief Returns the location of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] name Points to a null terminated string containing the name of the uniform variable
 *		whose location is to be queried.
 */
#define glGetUniformLocation(program,name) GLAutoCheckFuncPtrName(glGetUniformLocation)(program, name GLAutoCheckExtraParams)

/**
 *	@def glGetUniformfv
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
#define glGetUniformfv(program,location,params) do { GLFuncPtrName(glGetUniformfv)(program, location, params); GL_AUTOCHECK_BLOCK("glGetUniformfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformiv
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
#define glGetUniformiv(program,location,params) do { GLFuncPtrName(glGetUniformiv)(program, location, params); GL_AUTOCHECK_BLOCK("glGetUniformiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribdv
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
#define glGetVertexAttribdv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribdv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribdv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribfv
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
#define glGetVertexAttribfv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribfv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribiv
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
#define glGetVertexAttribiv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribiv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribPointerv
 *	@brief return the address of the specified generic vertex attribute pointer
 *	@param[in] index Specifies the generic vertex attribute parameter to be returned.
 *	@param[in] pname Specifies the symbolic name of the generic vertex attribute parameter to be
 *		returned. Must be GL_VERTEX_ATTRIB_ARRAY_POINTER.
 *	@param[out] pointer Returns the pointer value.
 */
#define glGetVertexAttribPointerv(index,pname,pointer) do { GLFuncPtrName(glGetVertexAttribPointerv)(index, pname, pointer); GL_AUTOCHECK_BLOCK("glGetVertexAttribPointerv", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsProgram
 *	@brief Determines if a name corresponds to a program object
 *	@param[in] program Specifies a potential program object.
 */
#define glIsProgram(program) GLAutoCheckFuncPtrName(glIsProgram)(program GLAutoCheckExtraParams)

/**
 *	@def glIsShader
 *	@brief Determines if a name corresponds to a shader object
 *	@param[in] shader Specifies a potential shader object.
 */
#define glIsShader(shader) GLAutoCheckFuncPtrName(glIsShader)(shader GLAutoCheckExtraParams)

/**
 *	@def glLinkProgram
 *	@brief Links a program object
 *	@param[in] program Specifies the handle of the program object to be linked.
 */
#define glLinkProgram(program) do { GLFuncPtrName(glLinkProgram)(program); GL_AUTOCHECK_BLOCK("glLinkProgram", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetShaderSource
 *	@brief Returns the source code string from a shader object
 *	@param[in] shader Specifies the shader object to be queried.
 *	@param[in] bufSize Specifies the size of the character buffer for storing the returned source
 *		code string.
 *	@param[out] length Returns the length of the string returned in source (excluding the null terminator).
 *	@param[out] source Specifies an array of characters that is used to return the source code string.
 */
#define glGetShaderSource(shader,bufSize,length,source) do { GLFuncPtrName(glGetShaderSource)(shader, bufSize, length, source); GL_AUTOCHECK_BLOCK("glGetShaderSource", __FILE__, __LINE__); } while(0)

/**
 *	@def glUseProgram
 *	@brief Installs a program object as part of current rendering state
 *	@param[in] program Specifies the handle of the program object whose executables are to be used
 *		as part of current rendering state.
 */
#define glUseProgram(program) do { GLFuncPtrName(glUseProgram)(program); GL_AUTOCHECK_BLOCK("glUseProgram", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1f
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform1f(location,v0) do { GLFuncPtrName(glUniform1f)(location, v0); GL_AUTOCHECK_BLOCK("glUniform1f", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2f
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform2f(location,v0,v1) do { GLFuncPtrName(glUniform2f)(location, v0, v1); GL_AUTOCHECK_BLOCK("glUniform2f", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3f
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform3f(location,v0,v1,v2) do { GLFuncPtrName(glUniform3f)(location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glUniform3f", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4f
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform4f(location,v0,v1,v2,v3) do { GLFuncPtrName(glUniform4f)(location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glUniform4f", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1i
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform1i(location,v0) do { GLFuncPtrName(glUniform1i)(location, v0); GL_AUTOCHECK_BLOCK("glUniform1i", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2i
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform2i(location,v0,v1) do { GLFuncPtrName(glUniform2i)(location, v0, v1); GL_AUTOCHECK_BLOCK("glUniform2i", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3i
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform3i(location,v0,v1,v2) do { GLFuncPtrName(glUniform3i)(location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glUniform3i", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4i
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform4i(location,v0,v1,v2,v3) do { GLFuncPtrName(glUniform4i)(location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glUniform4i", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform1fv(location,count,value) do { GLFuncPtrName(glUniform1fv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform1fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform2fv(location,count,value) do { GLFuncPtrName(glUniform2fv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform3fv(location,count,value) do { GLFuncPtrName(glUniform3fv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform4fv(location,count,value) do { GLFuncPtrName(glUniform4fv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1iv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform1iv(location,count,value) do { GLFuncPtrName(glUniform1iv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform1iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2iv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform2iv(location,count,value) do { GLFuncPtrName(glUniform2iv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform2iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3iv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform3iv(location,count,value) do { GLFuncPtrName(glUniform3iv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform3iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4iv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform4iv(location,count,value) do { GLFuncPtrName(glUniform4iv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform4iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix2fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix2fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix3fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix4fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glValidateProgram
 *	@brief Validates a program object
 *	@param[in] program Specifies the handle of the program object to be validated.
 */
#define glValidateProgram(program) do { GLFuncPtrName(glValidateProgram)(program); GL_AUTOCHECK_BLOCK("glValidateProgram", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1d
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib1d(index,v0) do { GLFuncPtrName(glVertexAttrib1d)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttrib1d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1dv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib1dv(index,v) do { GLFuncPtrName(glVertexAttrib1dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib1dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1f
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib1f(index,v0) do { GLFuncPtrName(glVertexAttrib1f)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttrib1f", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1fv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib1fv(index,v) do { GLFuncPtrName(glVertexAttrib1fv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib1fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1s
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib1s(index,v0) do { GLFuncPtrName(glVertexAttrib1s)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttrib1s", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib1sv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib1sv(index,v) do { GLFuncPtrName(glVertexAttrib1sv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib1sv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2d
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib2d(index,v0,v1) do { GLFuncPtrName(glVertexAttrib2d)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttrib2d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2dv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib2dv(index,v) do { GLFuncPtrName(glVertexAttrib2dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2f
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib2f(index,v0,v1) do { GLFuncPtrName(glVertexAttrib2f)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttrib2f", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2fv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib2fv(index,v) do { GLFuncPtrName(glVertexAttrib2fv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2s
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib2s(index,v0,v1) do { GLFuncPtrName(glVertexAttrib2s)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttrib2s", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib2sv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib2sv(index,v) do { GLFuncPtrName(glVertexAttrib2sv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib2sv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3d
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib3d(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttrib3d)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttrib3d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3dv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib3dv(index,v) do { GLFuncPtrName(glVertexAttrib3dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3f
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib3f(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttrib3f)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttrib3f", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3fv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib3fv(index,v) do { GLFuncPtrName(glVertexAttrib3fv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3s
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib3s(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttrib3s)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttrib3s", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib3sv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib3sv(index,v) do { GLFuncPtrName(glVertexAttrib3sv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib3sv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nbv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Nbv(index,v) do { GLFuncPtrName(glVertexAttrib4Nbv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nbv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Niv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Niv(index,v) do { GLFuncPtrName(glVertexAttrib4Niv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Niv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nsv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Nsv(index,v) do { GLFuncPtrName(glVertexAttrib4Nsv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nsv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nub
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib4Nub(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttrib4Nub)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nub", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nubv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Nubv(index,v) do { GLFuncPtrName(glVertexAttrib4Nubv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nubv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nuiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Nuiv(index,v) do { GLFuncPtrName(glVertexAttrib4Nuiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4Nusv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4Nusv(index,v) do { GLFuncPtrName(glVertexAttrib4Nusv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4Nusv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4bv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4bv(index,v) do { GLFuncPtrName(glVertexAttrib4bv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4bv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4d
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib4d(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttrib4d)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttrib4d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4dv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4dv(index,v) do { GLFuncPtrName(glVertexAttrib4dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4f
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib4f(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttrib4f)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttrib4f", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4fv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4fv(index,v) do { GLFuncPtrName(glVertexAttrib4fv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4iv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4iv(index,v) do { GLFuncPtrName(glVertexAttrib4iv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4s
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttrib4s(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttrib4s)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttrib4s", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4sv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4sv(index,v) do { GLFuncPtrName(glVertexAttrib4sv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4sv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4ubv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4ubv(index,v) do { GLFuncPtrName(glVertexAttrib4ubv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4ubv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4uiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4uiv(index,v) do { GLFuncPtrName(glVertexAttrib4uiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttrib4usv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttrib4usv(index,v) do { GLFuncPtrName(glVertexAttrib4usv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttrib4usv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribPointer
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] size Specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4.
 *	@param[in] type Specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT.
 *	@param[in] normalized For glVertexAttribPointer , specifies whether fixed-point data values
 *		should be normalized ( GL_TRUE ) or converted directly as fixed-point values ( GL_FALSE)
 *		when they are accessed.
 *	@param[in] stride Specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0.
 *	@param[in] pointer Specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0.
 */
#define glVertexAttribPointer(index,size,type,normalized,stride,pointer) do { GLFuncPtrName(glVertexAttribPointer)(index, size, type, normalized, stride, pointer); GL_AUTOCHECK_BLOCK("glVertexAttribPointer", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_2_0

//								--- ~OpenGL 2.0 ---

//								--- OpenGL 2.1 ---

/**
 *	@def GL_VERSION_2_1
 *	@brief if defined, OpenGL 2.1 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_2_1
#define GL_VERSION_2_1 1

/**
 *	@def __GENERATE_GL_21__
 *	@brief if defined, code to initialize OpenGL 2.1 entry points is compiled
 */
#define __GENERATE_GL_21__

extern bool GLEH_OPENGL_2_1; /**< @brief set if OpenGL 2.1 is supported */

//#define GL_CURRENT_RASTER_SECONDARY_COLOR							  0x845F // deprecated
#define GL_PIXEL_PACK_BUFFER										0x88EB /**< @brief OpenGL 2.1 enum */
#define GL_PIXEL_UNPACK_BUFFER										0x88EC /**< @brief OpenGL 2.1 enum */
#define GL_PIXEL_PACK_BUFFER_BINDING								0x88ED /**< @brief OpenGL 2.1 enum */
#define GL_PIXEL_UNPACK_BUFFER_BINDING								0x88EF /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT2x3												0x8B65 /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT2x4												0x8B66 /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT3x2												0x8B67 /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT3x4												0x8B68 /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT4x2												0x8B69 /**< @brief OpenGL 2.1 enum */
#define GL_FLOAT_MAT4x3												0x8B6A /**< @brief OpenGL 2.1 enum */
#define GL_SRGB														0x8C40 /**< @brief OpenGL 2.1 enum */
#define GL_SRGB8													0x8C41 /**< @brief OpenGL 2.1 enum */
#define GL_SRGB_ALPHA												0x8C42 /**< @brief OpenGL 2.1 enum */
#define GL_SRGB8_ALPHA8												0x8C43 /**< @brief OpenGL 2.1 enum */
//#define GL_SLUMINANCE_ALPHA										  0x8C44 // deprecated
//#define GL_SLUMINANCE8_ALPHA8										  0x8C45 // deprecated
//#define GL_SLUMINANCE												  0x8C46 // deprecated
//#define GL_SLUMINANCE8											  0x8C47 // deprecated
#define GL_COMPRESSED_SRGB											0x8C48 /**< @brief OpenGL 2.1 enum */
#define GL_COMPRESSED_SRGB_ALPHA									0x8C49 /**< @brief OpenGL 2.1 enum */
//#define GL_COMPRESSED_SLUMINANCE									  0x8C4A // deprecated
//#define GL_COMPRESSED_SLUMINANCE_ALPHA							  0x8C4B // deprecated

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2x3fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x2fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2x4fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x2fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x4fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x3fv))(int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@def glUniformMatrix2x3fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix2x3fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2x3fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2x3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3x2fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix3x2fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3x2fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3x2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix2x4fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix2x4fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2x4fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2x4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4x2fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix4x2fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4x2fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4x2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3x4fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix3x4fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3x4fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3x4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4x3fv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices.
 *	@param[in] transpose Specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniformMatrix4x3fv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4x3fv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4x3fv", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_2_1

//								--- ~OpenGL 2.1 ---

//								--- OpenGL 3.0 ---

/**
 *	@def GL_VERSION_3_0
 *	@brief if defined, OpenGL 3.0 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_3_0
#define GL_VERSION_3_0 1

/**
 *	@def __GENERATE_GL_30__
 *	@brief if defined, code to initialize OpenGL 3.0 entry points is compiled
 */
#define __GENERATE_GL_30__

extern bool GLEH_OPENGL_3_0; /**< @brief set if OpenGL 3.0 is supported */

#define GL_COMPARE_REF_TO_TEXTURE									0x884E /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE0											0x3000 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE1											0x3001 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE2											0x3002 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE3											0x3003 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE4											0x3004 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE5											0x3005 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE6											0x3006 /**< @brief OpenGL 3.0 enum */
#define GL_CLIP_DISTANCE7											0x3007 /**< @brief OpenGL 3.0 enum */
#define GL_MAX_CLIP_DISTANCES										0x0D32 /**< @brief OpenGL 3.0 enum */
#define GL_MAJOR_VERSION											0x821B /**< @brief OpenGL 3.0 enum */
#define GL_MINOR_VERSION											0x821C /**< @brief OpenGL 3.0 enum */
#define GL_NUM_EXTENSIONS											0x821D /**< @brief OpenGL 3.0 enum */
#define GL_CONTEXT_FLAGS											0x821E /**< @brief OpenGL 3.0 enum */
#define GL_DEPTH_BUFFER												0x8223 /**< @brief OpenGL 3.0 enum */
#define GL_STENCIL_BUFFER											0x8224 /**< @brief OpenGL 3.0 enum */
#define GL_COMPRESSED_RED											0x8225 /**< @brief OpenGL 3.0 enum */
#define GL_COMPRESSED_RG											0x8226 /**< @brief OpenGL 3.0 enum */
#define GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT						0x0001 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA32F													0x8814 /**< @brief OpenGL 3.0 enum */
#define GL_RGB32F													0x8815 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA16F													0x881A /**< @brief OpenGL 3.0 enum */
#define GL_RGB16F													0x881B /**< @brief OpenGL 3.0 enum */
#define GL_VERTEX_ATTRIB_ARRAY_INTEGER								0x88FD /**< @brief OpenGL 3.0 enum */
#define GL_MAX_ARRAY_TEXTURE_LAYERS									0x88FF /**< @brief OpenGL 3.0 enum */
#define GL_MIN_PROGRAM_TEXEL_OFFSET									0x8904 /**< @brief OpenGL 3.0 enum */
#define GL_MAX_PROGRAM_TEXEL_OFFSET									0x8905 /**< @brief OpenGL 3.0 enum */
#define GL_CLAMP_READ_COLOR											0x891C /**< @brief OpenGL 3.0 enum */
#define GL_FIXED_ONLY												0x891D /**< @brief OpenGL 3.0 enum */
//#define GL_MAX_VARYING_COMPONENTS									  0x8B4B // deprecated (in OpenGL 3.2)
#define GL_TEXTURE_1D_ARRAY											0x8C18 /**< @brief OpenGL 3.0 enum */
#define GL_PROXY_TEXTURE_1D_ARRAY									0x8C19 /**< @brief OpenGL 3.0 enum */
#define GL_TEXTURE_2D_ARRAY											0x8C1A /**< @brief OpenGL 3.0 enum */
#define GL_PROXY_TEXTURE_2D_ARRAY									0x8C1B /**< @brief OpenGL 3.0 enum */
#define GL_TEXTURE_BINDING_1D_ARRAY									0x8C1C /**< @brief OpenGL 3.0 enum */
#define GL_TEXTURE_BINDING_2D_ARRAY									0x8C1D /**< @brief OpenGL 3.0 enum */
#define GL_R11F_G11F_B10F											0x8C3A /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_10F_11F_11F_REV								0x8C3B /**< @brief OpenGL 3.0 enum */
#define GL_RGB9_E5													0x8C3D /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_5_9_9_9_REV									0x8C3E /**< @brief OpenGL 3.0 enum */
#define GL_TEXTURE_SHARED_SIZE										0x8C3F /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH					0x8C76 /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE							0x8C7F /**< @brief OpenGL 3.0 enum */
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS				0x8C80 /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_VARYINGS								0x8C83 /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_BUFFER_START							0x8C84 /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE							0x8C85 /**< @brief OpenGL 3.0 enum */
#define GL_PRIMITIVES_GENERATED										0x8C87 /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN					0x8C88 /**< @brief OpenGL 3.0 enum */
#define GL_RASTERIZER_DISCARD										0x8C89 /**< @brief OpenGL 3.0 enum */
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS			0x8C8A /**< @brief OpenGL 3.0 enum */
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS					0x8C8B /**< @brief OpenGL 3.0 enum */
#define GL_INTERLEAVED_ATTRIBS										0x8C8C /**< @brief OpenGL 3.0 enum */
#define GL_SEPARATE_ATTRIBS											0x8C8D /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_BUFFER								0x8C8E /**< @brief OpenGL 3.0 enum */
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING						0x8C8F /**< @brief OpenGL 3.0 enum */
#define GL_RGBA32UI													0x8D70 /**< @brief OpenGL 3.0 enum */
#define GL_RGB32UI													0x8D71 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA16UI													0x8D76 /**< @brief OpenGL 3.0 enum */
#define GL_RGB16UI													0x8D77 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA8UI													0x8D7C /**< @brief OpenGL 3.0 enum */
#define GL_RGB8UI													0x8D7D /**< @brief OpenGL 3.0 enum */
#define GL_RGBA32I													0x8D82 /**< @brief OpenGL 3.0 enum */
#define GL_RGB32I													0x8D83 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA16I													0x8D88 /**< @brief OpenGL 3.0 enum */
#define GL_RGB16I													0x8D89 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA8I													0x8D8E /**< @brief OpenGL 3.0 enum */
#define GL_RGB8I													0x8D8F /**< @brief OpenGL 3.0 enum */
#define GL_RED_INTEGER												0x8D94 /**< @brief OpenGL 3.0 enum */
#define GL_GREEN_INTEGER											0x8D95 /**< @brief OpenGL 3.0 enum */
#define GL_BLUE_INTEGER												0x8D96 /**< @brief OpenGL 3.0 enum */
#define GL_RGB_INTEGER												0x8D98 /**< @brief OpenGL 3.0 enum */
#define GL_RGBA_INTEGER												0x8D99 /**< @brief OpenGL 3.0 enum */
#define GL_BGR_INTEGER												0x8D9A /**< @brief OpenGL 3.0 enum */
#define GL_BGRA_INTEGER												0x8D9B /**< @brief OpenGL 3.0 enum */
#define GL_SAMPLER_1D_ARRAY											0x8DC0 /**< @brief OpenGL 3.0 enum */
#define GL_SAMPLER_2D_ARRAY											0x8DC1 /**< @brief OpenGL 3.0 enum */
#define GL_SAMPLER_1D_ARRAY_SHADOW									0x8DC3 /**< @brief OpenGL 3.0 enum */
#define GL_SAMPLER_2D_ARRAY_SHADOW									0x8DC4 /**< @brief OpenGL 3.0 enum */
#define GL_SAMPLER_CUBE_SHADOW										0x8DC5 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_VEC2										0x8DC6 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_VEC3										0x8DC7 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_VEC4										0x8DC8 /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_1D											0x8DC9 /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_2D											0x8DCA /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_3D											0x8DCB /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_CUBE											0x8DCC /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_1D_ARRAY										0x8DCE /**< @brief OpenGL 3.0 enum */
#define GL_INT_SAMPLER_2D_ARRAY										0x8DCF /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_1D									0x8DD1 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_2D									0x8DD2 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_3D									0x8DD3 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_CUBE								0x8DD4 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_1D_ARRAY							0x8DD6 /**< @brief OpenGL 3.0 enum */
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY							0x8DD7 /**< @brief OpenGL 3.0 enum */
#define GL_QUERY_WAIT												0x8E13 /**< @brief OpenGL 3.0 enum */
#define GL_QUERY_NO_WAIT											0x8E14 /**< @brief OpenGL 3.0 enum */
#define GL_QUERY_BY_REGION_WAIT										0x8E15 /**< @brief OpenGL 3.0 enum */
#define GL_QUERY_BY_REGION_NO_WAIT									0x8E16 /**< @brief OpenGL 3.0 enum */
#define GL_BUFFER_ACCESS_FLAGS										0x911F /**< @brief OpenGL 3.0 enum */
#define GL_BUFFER_MAP_LENGTH										0x9120 /**< @brief OpenGL 3.0 enum */
#define GL_BUFFER_MAP_OFFSET										0x9121 /**< @brief OpenGL 3.0 enum */
/* Reuse tokens from ARB_depth_buffer_float */
/* Reuse tokens from ARB_framebuffer_object */
/* Reuse tokens from ARB_framebuffer_sRGB */
/* Reuse tokens from ARB_half_float_vertex */
/* Reuse tokens from ARB_map_buffer_range */
/* Reuse tokens from ARB_texture_compression_rgtc */
/* Reuse tokens from ARB_texture_rg */
/* Reuse tokens from ARB_vertex_array_object */

/* OpenGL 3.0 also reuses entry points from these extensions: */
/* ARB_framebuffer_object */
/* ARB_map_buffer_range */
/* ARB_vertex_array_object */

/**
 *	@brief enable and disable writing of frame buffer color components
 *	@param[in] buf For glColorMaski, specifies the index of the draw buffer whose color mask to set.
 *	@param[in] red Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] green Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] blue Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] alpha Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 */
extern void (GLApi *GLFuncPtrName(glColorMaski))(GLuint buf, GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetBooleani_v))(GLenum pname, GLuint index, GLboolean *data);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetIntegeri_v))(GLenum pname, GLuint index, int *data);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the swtich to enable.
 */
extern void (GLApi *GLFuncPtrName(glEnablei))(GLenum cap, GLuint index);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the swtich to disable.
 */
extern void (GLApi *GLFuncPtrName(glDisablei))(GLenum cap, GLuint index);

/**
 *	@brief test whether a capability is enabled
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the capability.
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsEnabledi))(GLenum cap, GLuint index);

/**
 *	@brief start transform feedback operation
 *	@param[in] primitiveMode Specify the output type of the primitives that will be recorded into
 *		the buffer objects that are bound for transform feedback.
 */
extern void (GLApi *GLFuncPtrName(glBeginTransformFeedback))(GLenum primitiveMode);

/**
 *	@brief start transform feedback operation
 */
extern void (GLApi *GLFuncPtrName(glEndTransformFeedback))();

/**
 *	@brief bind a range within a buffer object to an indexed buffer target
 *	@param[in] target Specify the target of the bind operation. target must be either
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] index Specify the index of the binding point within the array specified by target.
 *	@param[in] buffer The name of a buffer object to bind to the specified binding point.
 *	@param[in] offset The starting offset in basic machine units into the buffer object buffer.
 *	@param[in] size The amount of data in machine units that can be read from the buffet object
 *		while used as an indexed target.
 */
extern void (GLApi *GLFuncPtrName(glBindBufferRange))(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);

/**
 *	@brief bind a buffer object to an indexed buffer target
 *	@param[in] target Specify the target of the bind operation. target must be either
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] index Specify the index of the binding point within the array specified by target.
 *	@param[in] buffer The name of a buffer object to bind to the specified binding point.
 */
extern void (GLApi *GLFuncPtrName(glBindBufferBase))(GLenum target, GLuint index, GLuint buffer);

/**
 *	@brief specify values to record in transform feedback buffers
 *	@param[in] program The name of the target program object.
 *	@param[in] count The number of varying variables used for transform feedback.
 *	@param[in] varyings An array of count zero-terminated strings specifying the names of the
 *		varying variables to use for transform feedback.
 *	@param[in] bufferMode Identifies the mode used to capture the varying variables when transform
 *		feedback is active. bufferMode must be GL_INTERLEAVED_ATTRIBS or GL_SEPARATE_ATTRIBS.
 */
extern void (GLApi *GLFuncPtrName(glTransformFeedbackVaryings))(GLuint program, GLsizei count, const GLchar **varyings, GLenum bufferMode);

/**
 *	@brief retrieve information about varying variables selected for transform feedback
 *	@param[in] program The name of the target program object.
 *	@param[in] index The index of the varying variable whose information to retrieve.
 *	@param[in] bufSize The maximum number of characters, including the null terminator, that may be
 *		written into name.
 *	@param[out] length The address of a variable which will receive the number of characters written
 *		into name, excluding the null-terminator. If length is NULL no length is returned.
 *	@param[out] size The address of a variable that will receive the size of the varying.
 *	@param[out] type The address of a variable that will recieve the type of the varying.
 *	@param[out] name The address of a buffer into which will be written the name of the varying.
 */
extern void (GLApi *GLFuncPtrName(glGetTransformFeedbackVarying))(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);

/**
 *	@brief specify whether data read via
 *	@param[in] target Target for color clamping. target must be GL_CLAMP_READ_COLOR.
 *	@param[in] clamp Specifies whether to apply color clamping. clamp must be GL_TRUE or GL_FALSE.
 */
extern void (GLApi *GLFuncPtrName(glClampColor))(GLenum target, GLenum clamp);

/**
 *	@brief start conditional rendering
 *	@param[in] id Specifies the name of an occlusion query object whose results are used to
 *		determine if the rendering commands are discarded.
 *	@param[in] mode Specifies how glBeginConditionalRender interprets the results of the occlusion query.
 */
extern void (GLApi *GLFuncPtrName(glBeginConditionalRender))(GLuint id, GLenum mode);

/**
 *	@brief start conditional rendering
 */
extern void (GLApi *GLFuncPtrName(glEndConditionalRender))();

/**
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] size Specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4.
 *	@param[in] type Specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT.
 *	@param[in] stride Specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0.
 *	@param[in] pointer Specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribIPointer))(GLuint index, int size, GLenum type, GLsizei stride, const void *pointer);

/**
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribIiv))(GLuint index, GLenum pname, int *params);

/**
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribIuiv))(GLuint index, GLenum pname, GLuint *params);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI1i))(GLuint index, int v0);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI2i))(GLuint index, int v0, int v1);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI3i))(GLuint index, int v0, int v1, int v2);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4i))(GLuint index, int v0, int v1, int v2, int v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI1ui))(GLuint index, GLuint v0);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI2ui))(GLuint index, GLuint v0, GLuint v1);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI3ui))(GLuint index, GLuint v0, GLuint v1, GLuint v2);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4ui))(GLuint index, GLuint v0, GLuint v1, GLuint v2, GLuint v3);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI1iv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI2iv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI3iv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4iv))(GLuint index, const int *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI1uiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI2uiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI3uiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4uiv))(GLuint index, const GLuint *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4bv))(GLuint index, const GLbyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4sv))(GLuint index, const short *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4ubv))(GLuint index, const GLubyte *v);

/**
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribI4usv))(GLuint index, const GLushort *v);

/**
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glGetUniformuiv))(GLuint program, int location, GLuint *params);

/**
 *	@brief bind a user-defined varying out variable to a fragment shader color number
 *	@param[in] program The name of the program containing varying out variable whose binding to modify
 *	@param[in] colorNumber The color number to bind the user-defined varying out variable to
 *	@param[in] name The name of the user-defined varying out variable whose binding to modify
 */
extern void (GLApi *GLFuncPtrName(glBindFragDataLocation))(GLuint program, GLuint colorNumber, const GLchar *name);

/**
 *	@brief query the bindings of color numbers to user-defined varying out variables
 *	@param[in] program The name of the program containing varying out variable whose binding to query
 *	@param[in] name The name of the user-defined varying out variable whose binding to query
 */
extern int (GLApi *GLFuncPtrName(glGetFragDataLocation))(GLuint program, const GLchar *name);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1ui))(int location, GLuint v0);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2ui))(int location, GLuint v0, GLuint v1);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3ui))(int location, GLuint v0, GLuint v1, GLuint v2);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4ui))(int location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform1uiv))(int location, GLsizei count, const GLuint *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform2uiv))(int location, GLsizei count, const GLuint *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform3uiv))(int location, GLsizei count, const GLuint *value);

/**
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
extern void (GLApi *GLFuncPtrName(glUniform4uiv))(int location, GLsizei count, const GLuint *value);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
extern void (GLApi *GLFuncPtrName(glTexParameterIiv))(GLenum target, GLenum pname, const int *params);

/**
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
extern void (GLApi *GLFuncPtrName(glTexParameterIuiv))(GLenum target, GLenum pname, const GLuint *params);

/**
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
extern void (GLApi *GLFuncPtrName(glGetTexParameterIiv))(GLenum target, GLenum pname, int *params);

/**
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
extern void (GLApi *GLFuncPtrName(glGetTexParameterIuiv))(GLenum target, GLenum pname, GLuint *params);

/**
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
extern void (GLApi *GLFuncPtrName(glClearBufferiv))(GLenum buffer, int drawBuffer, const int *value);

/**
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
extern void (GLApi *GLFuncPtrName(glClearBufferuiv))(GLenum buffer, int drawBuffer, const GLuint *value);

/**
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
extern void (GLApi *GLFuncPtrName(glClearBufferfv))(GLenum buffer, int drawBuffer, const float *value);

/**
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] depth The value to clear a depth render buffer to.
 *	@param[in] stencil The value to clear a stencil render buffer to.
 */
extern void (GLApi *GLFuncPtrName(glClearBufferfi))(GLenum buffer, int drawBuffer, float depth, int stencil);

/**
 *	@brief return a string describing the current GL connection
 *	@param[in] name Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, or
 *		GL_SHADING_LANGUAGE_VERSION. Additionally, glGetStringi accepts the GL_EXTENSIONS token.
 *	@param[in] index For glGetStringi, specifies the index of the string to return.
 */
extern const GLubyte* (GLApi *GLFuncPtrName(glGetStringi))(GLenum name, GLuint index);

inline GLboolean glIsEnabledi_glachwrap(GLenum cap, GLuint index, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsEnabledi)(cap,index); GL_AUTOCHECK_BLOCK("glIsEnabledi", p_s_filename, n_line); return result; }
inline int glGetFragDataLocation_glachwrap(GLuint program, const GLchar *name, const char *p_s_filename, int n_line) { int result = GLFuncPtrName(glGetFragDataLocation)(program,name); GL_AUTOCHECK_BLOCK("glGetFragDataLocation", p_s_filename, n_line); return result; }
inline const GLubyte *glGetStringi_glachwrap(GLenum name, GLuint index, const char *p_s_filename, int n_line) { const GLubyte *result = GLFuncPtrName(glGetStringi)(name,index); GL_AUTOCHECK_BLOCK("glGetStringi", p_s_filename, n_line); return result; }

/**
 *	@def glColorMaski
 *	@brief enable and disable writing of frame buffer color components
 *	@param[in] buf For glColorMaski, specifies the index of the draw buffer whose color mask to set.
 *	@param[in] red Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] green Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] blue Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 *	@param[in] alpha Specify whether red, green, blue, and alpha are to be written into the frame
 *		buffer. The initial values are all GL_TRUE, indicating that the color components are written.
 */
#define glColorMaski(buf,red,green,blue,alpha) do { GLFuncPtrName(glColorMaski)(buf, red, green, blue, alpha); GL_AUTOCHECK_BLOCK("glColorMaski", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetBooleani_v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
#define glGetBooleani_v(pname,index,data) do { GLFuncPtrName(glGetBooleani_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetBooleani_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetIntegeri_v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
#define glGetIntegeri_v(pname,index,data) do { GLFuncPtrName(glGetIntegeri_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetIntegeri_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glEnablei
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the swtich to enable.
 */
#define glEnablei(cap,index) do { GLFuncPtrName(glEnablei)(cap, index); GL_AUTOCHECK_BLOCK("glEnablei", __FILE__, __LINE__); } while(0)

/**
 *	@def glDisablei
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the swtich to disable.
 */
#define glDisablei(cap,index) do { GLFuncPtrName(glDisablei)(cap, index); GL_AUTOCHECK_BLOCK("glDisablei", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsEnabledi
 *	@brief test whether a capability is enabled
 *	@param[in] cap Specifies a symbolic constant indicating a GL capability.
 *	@param[in] index Specifies the index of the capability.
 */
#define glIsEnabledi(cap,index) GLAutoCheckFuncPtrName(glIsEnabledi)(cap, index GLAutoCheckExtraParams)

/**
 *	@def glBeginTransformFeedback
 *	@brief start transform feedback operation
 *	@param[in] primitiveMode Specify the output type of the primitives that will be recorded into
 *		the buffer objects that are bound for transform feedback.
 */
#define glBeginTransformFeedback(primitiveMode) do { GLFuncPtrName(glBeginTransformFeedback)(primitiveMode); GL_AUTOCHECK_BLOCK("glBeginTransformFeedback", __FILE__, __LINE__); } while(0)

/**
 *	@def glEndTransformFeedback
 *	@brief start transform feedback operation
 */
#define glEndTransformFeedback() do { GLFuncPtrName(glEndTransformFeedback)(); GL_AUTOCHECK_BLOCK("glEndTransformFeedback", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindBufferRange
 *	@brief bind a range within a buffer object to an indexed buffer target
 *	@param[in] target Specify the target of the bind operation. target must be either
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] index Specify the index of the binding point within the array specified by target.
 *	@param[in] buffer The name of a buffer object to bind to the specified binding point.
 *	@param[in] offset The starting offset in basic machine units into the buffer object buffer.
 *	@param[in] size The amount of data in machine units that can be read from the buffet object
 *		while used as an indexed target.
 */
#define glBindBufferRange(target,index,buffer,offset,size) do { GLFuncPtrName(glBindBufferRange)(target, index, buffer, offset, size); GL_AUTOCHECK_BLOCK("glBindBufferRange", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindBufferBase
 *	@brief bind a buffer object to an indexed buffer target
 *	@param[in] target Specify the target of the bind operation. target must be either
 *		GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
 *	@param[in] index Specify the index of the binding point within the array specified by target.
 *	@param[in] buffer The name of a buffer object to bind to the specified binding point.
 */
#define glBindBufferBase(target,index,buffer) do { GLFuncPtrName(glBindBufferBase)(target, index, buffer); GL_AUTOCHECK_BLOCK("glBindBufferBase", __FILE__, __LINE__); } while(0)

/**
 *	@def glTransformFeedbackVaryings
 *	@brief specify values to record in transform feedback buffers
 *	@param[in] program The name of the target program object.
 *	@param[in] count The number of varying variables used for transform feedback.
 *	@param[in] varyings An array of count zero-terminated strings specifying the names of the
 *		varying variables to use for transform feedback.
 *	@param[in] bufferMode Identifies the mode used to capture the varying variables when transform
 *		feedback is active. bufferMode must be GL_INTERLEAVED_ATTRIBS or GL_SEPARATE_ATTRIBS.
 */
#define glTransformFeedbackVaryings(program,count,varyings,bufferMode) do { GLFuncPtrName(glTransformFeedbackVaryings)(program, count, varyings, bufferMode); GL_AUTOCHECK_BLOCK("glTransformFeedbackVaryings", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTransformFeedbackVarying
 *	@brief retrieve information about varying variables selected for transform feedback
 *	@param[in] program The name of the target program object.
 *	@param[in] index The index of the varying variable whose information to retrieve.
 *	@param[in] bufSize The maximum number of characters, including the null terminator, that may be
 *		written into name.
 *	@param[out] length The address of a variable which will receive the number of characters written
 *		into name, excluding the null-terminator. If length is NULL no length is returned.
 *	@param[out] size The address of a variable that will receive the size of the varying.
 *	@param[out] type The address of a variable that will recieve the type of the varying.
 *	@param[out] name The address of a buffer into which will be written the name of the varying.
 */
#define glGetTransformFeedbackVarying(program,index,bufSize,length,size,type,name) do { GLFuncPtrName(glGetTransformFeedbackVarying)(program, index, bufSize, length, size, type, name); GL_AUTOCHECK_BLOCK("glGetTransformFeedbackVarying", __FILE__, __LINE__); } while(0)

/**
 *	@def glClampColor
 *	@brief specify whether data read via
 *	@param[in] target Target for color clamping. target must be GL_CLAMP_READ_COLOR.
 *	@param[in] clamp Specifies whether to apply color clamping. clamp must be GL_TRUE or GL_FALSE.
 */
#define glClampColor(target,clamp) do { GLFuncPtrName(glClampColor)(target, clamp); GL_AUTOCHECK_BLOCK("glClampColor", __FILE__, __LINE__); } while(0)

/**
 *	@def glBeginConditionalRender
 *	@brief start conditional rendering
 *	@param[in] id Specifies the name of an occlusion query object whose results are used to
 *		determine if the rendering commands are discarded.
 *	@param[in] mode Specifies how glBeginConditionalRender interprets the results of the occlusion query.
 */
#define glBeginConditionalRender(id,mode) do { GLFuncPtrName(glBeginConditionalRender)(id, mode); GL_AUTOCHECK_BLOCK("glBeginConditionalRender", __FILE__, __LINE__); } while(0)

/**
 *	@def glEndConditionalRender
 *	@brief start conditional rendering
 */
#define glEndConditionalRender() do { GLFuncPtrName(glEndConditionalRender)(); GL_AUTOCHECK_BLOCK("glEndConditionalRender", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribIPointer
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] size Specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4.
 *	@param[in] type Specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT.
 *	@param[in] stride Specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0.
 *	@param[in] pointer Specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0.
 */
#define glVertexAttribIPointer(index,size,type,stride,pointer) do { GLFuncPtrName(glVertexAttribIPointer)(index, size, type, stride, pointer); GL_AUTOCHECK_BLOCK("glVertexAttribIPointer", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribIiv
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
#define glGetVertexAttribIiv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribIiv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribIiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribIuiv
 *	@brief Return a generic vertex attribute parameter
 *	@param[in] index Specifies the generic vertex attribute parameter to be queried.
 *	@param[in] pname Specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB.
 *	@param[out] params Returns the requested data.
 */
#define glGetVertexAttribIuiv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribIuiv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribIuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI1i
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI1i(index,v0) do { GLFuncPtrName(glVertexAttribI1i)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttribI1i", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI2i
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI2i(index,v0,v1) do { GLFuncPtrName(glVertexAttribI2i)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttribI2i", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI3i
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI3i(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttribI3i)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttribI3i", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4i
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI4i(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttribI4i)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttribI4i", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI1ui
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI1ui(index,v0) do { GLFuncPtrName(glVertexAttribI1ui)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttribI1ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI2ui
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI2ui(index,v0,v1) do { GLFuncPtrName(glVertexAttribI2ui)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttribI2ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI3ui
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI3ui(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttribI3ui)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttribI3ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4ui
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v1 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v2 Specifies the new values to be used for the specified vertex attribute.
 *	@param[in] v3 Specifies the new values to be used for the specified vertex attribute.
 */
#define glVertexAttribI4ui(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttribI4ui)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttribI4ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI1iv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI1iv(index,v) do { GLFuncPtrName(glVertexAttribI1iv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI1iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI2iv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI2iv(index,v) do { GLFuncPtrName(glVertexAttribI2iv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI2iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI3iv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI3iv(index,v) do { GLFuncPtrName(glVertexAttribI3iv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI3iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4iv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4iv(index,v) do { GLFuncPtrName(glVertexAttribI4iv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI1uiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI1uiv(index,v) do { GLFuncPtrName(glVertexAttribI1uiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI1uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI2uiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI2uiv(index,v) do { GLFuncPtrName(glVertexAttribI2uiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI2uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI3uiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI3uiv(index,v) do { GLFuncPtrName(glVertexAttribI3uiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI3uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4uiv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4uiv(index,v) do { GLFuncPtrName(glVertexAttribI4uiv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4bv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4bv(index,v) do { GLFuncPtrName(glVertexAttribI4bv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4bv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4sv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4sv(index,v) do { GLFuncPtrName(glVertexAttribI4sv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4sv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4ubv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4ubv(index,v) do { GLFuncPtrName(glVertexAttribI4ubv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4ubv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribI4usv
 *	@brief Specifies the value of a generic vertex attribute
 *	@param[in] index Specifies the index of the generic vertex attribute to be modified.
 *	@param[in] v Specifies a pointer to an array of values to be used for the generic vertex attribute.
 */
#define glVertexAttribI4usv(index,v) do { GLFuncPtrName(glVertexAttribI4usv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribI4usv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformuiv
 *	@brief Returns the value of a uniform variable
 *	@param[in] program Specifies the program object to be queried.
 *	@param[in] location Specifies the location of the uniform variable to be queried.
 *	@param[out] params Returns the value of the specified uniform variable.
 */
#define glGetUniformuiv(program,location,params) do { GLFuncPtrName(glGetUniformuiv)(program, location, params); GL_AUTOCHECK_BLOCK("glGetUniformuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glBindFragDataLocation
 *	@brief bind a user-defined varying out variable to a fragment shader color number
 *	@param[in] program The name of the program containing varying out variable whose binding to modify
 *	@param[in] colorNumber The color number to bind the user-defined varying out variable to
 *	@param[in] name The name of the user-defined varying out variable whose binding to modify
 */
#define glBindFragDataLocation(program,colorNumber,name) do { GLFuncPtrName(glBindFragDataLocation)(program, colorNumber, name); GL_AUTOCHECK_BLOCK("glBindFragDataLocation", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFragDataLocation
 *	@brief query the bindings of color numbers to user-defined varying out variables
 *	@param[in] program The name of the program containing varying out variable whose binding to query
 *	@param[in] name The name of the user-defined varying out variable whose binding to query
 */
#define glGetFragDataLocation(program,name) GLAutoCheckFuncPtrName(glGetFragDataLocation)(program, name GLAutoCheckExtraParams)

/**
 *	@def glUniform1ui
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform1ui(location,v0) do { GLFuncPtrName(glUniform1ui)(location, v0); GL_AUTOCHECK_BLOCK("glUniform1ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2ui
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform2ui(location,v0,v1) do { GLFuncPtrName(glUniform2ui)(location, v0, v1); GL_AUTOCHECK_BLOCK("glUniform2ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3ui
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform3ui(location,v0,v1,v2) do { GLFuncPtrName(glUniform3ui)(location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glUniform3ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4ui
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform variable to be modified.
 *	@param[in] v0 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v1 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v2 Specifies the new values to be used for the specified uniform variable.
 *	@param[in] v3 Specifies the new values to be used for the specified uniform variable.
 */
#define glUniform4ui(location,v0,v1,v2,v3) do { GLFuncPtrName(glUniform4ui)(location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glUniform4ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1uiv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform1uiv(location,count,value) do { GLFuncPtrName(glUniform1uiv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform1uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2uiv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform2uiv(location,count,value) do { GLFuncPtrName(glUniform2uiv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform2uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3uiv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform3uiv(location,count,value) do { GLFuncPtrName(glUniform3uiv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform3uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4uiv
 *	@brief Specify the value of a uniform variable for the current program object
 *	@param[in] location Specifies the location of the uniform value to be modified.
 *	@param[in] count Specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array.
 *	@param[in] value Specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable.
 */
#define glUniform4uiv(location,count,value) do { GLFuncPtrName(glUniform4uiv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform4uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameterIiv
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
#define glTexParameterIiv(target,pname,params) do { GLFuncPtrName(glTexParameterIiv)(target, pname, params); GL_AUTOCHECK_BLOCK("glTexParameterIiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexParameterIuiv
 *	@brief set texture parameters
 *	@param[in] target Specifies the target texture, which must be either GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY,
 *		GL_TEXTURE_RECTANGLE, or GL_TEXTURE_CUBE_MAP.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. pname can be one of the
 *		following: GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_SWIZZLE_R,
 *		GL_TEXTURE_SWIZZLE_G, GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R.
 *	@param[in] params Specifies a pointer to an array where the value or values of pname are stored.
 */
#define glTexParameterIuiv(target,pname,params) do { GLFuncPtrName(glTexParameterIuiv)(target, pname, params); GL_AUTOCHECK_BLOCK("glTexParameterIuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexParameterIiv
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
#define glGetTexParameterIiv(target,pname,params) do { GLFuncPtrName(glGetTexParameterIiv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetTexParameterIiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetTexParameterIuiv
 *	@brief return texture parameter values
 *	@param[in] target Specifies the symbolic name of the target texture. GL_TEXTURE_1D,
 *		GL_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D,
 *		GL_TEXTURE_RECTANGLE, and GL_TEXTURE_CUBE_MAP are accepted.
 *	@param[in] pname Specifies the symbolic name of a texture parameter. GL_TEXTURE_BASE_LEVEL,
 *		GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC,
 *		GL_TEXTURE_LOD_BIAS, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_SWIZZLE_R, GL_TEXTURE_SWIZZLE_G,
 *		GL_TEXTURE_SWIZZLE_B, GL_TEXTURE_SWIZZLE_A, GL_TEXTURE_SWIZZLE_RGBA, GL_TEXTURE_WRAP_S,
 *		GL_TEXTURE_WRAP_T, and GL_TEXTURE_WRAP_R are accepted.
 *	@param[out] params Returns the texture parameters.
 */
#define glGetTexParameterIuiv(target,pname,params) do { GLFuncPtrName(glGetTexParameterIuiv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetTexParameterIuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearBufferiv
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
#define glClearBufferiv(buffer,drawBuffer,value) do { GLFuncPtrName(glClearBufferiv)(buffer, drawBuffer, value); GL_AUTOCHECK_BLOCK("glClearBufferiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearBufferuiv
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
#define glClearBufferuiv(buffer,drawBuffer,value) do { GLFuncPtrName(glClearBufferuiv)(buffer, drawBuffer, value); GL_AUTOCHECK_BLOCK("glClearBufferuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearBufferfv
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] value For color buffers, a pointer to a four-element vector specifying R, G, B and A
 *		values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear
 *		the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
 */
#define glClearBufferfv(buffer,drawBuffer,value) do { GLFuncPtrName(glClearBufferfv)(buffer, drawBuffer, value); GL_AUTOCHECK_BLOCK("glClearBufferfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearBufferfi
 *	@brief clear individual buffers of the currently bound draw framebuffer
 *	@param[in] buffer Specify the buffer to clear.
 *	@param[in] drawBuffer Specify a particular draw buffer to clear.
 *	@param[in] depth The value to clear a depth render buffer to.
 *	@param[in] stencil The value to clear a stencil render buffer to.
 */
#define glClearBufferfi(buffer,drawBuffer,depth,stencil) do { GLFuncPtrName(glClearBufferfi)(buffer, drawBuffer, depth, stencil); GL_AUTOCHECK_BLOCK("glClearBufferfi", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetStringi
 *	@brief return a string describing the current GL connection
 *	@param[in] name Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, or
 *		GL_SHADING_LANGUAGE_VERSION. Additionally, glGetStringi accepts the GL_EXTENSIONS token.
 *	@param[in] index For glGetStringi, specifies the index of the string to return.
 */
#define glGetStringi(name,index) GLAutoCheckFuncPtrName(glGetStringi)(name, index GLAutoCheckExtraParams)

#endif // !GL_VERSION_3_0

//								--- ~OpenGL 3.0 ---

//								--- GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_depth_buffer_float
 *	@brief if defined, GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_depth_buffer_float
#define GL_ARB_depth_buffer_float 1

extern bool GLEH_ARB_depth_buffer_float; /**< @brief set if GL_ARB_depth_buffer_float is supported */

#define GL_DEPTH_COMPONENT32F										0x8cac /**< @brief GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) enum **/
#define GL_DEPTH32F_STENCIL8										0x8cad /**< @brief GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) enum **/
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV							0x8dad /**< @brief GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_depth_buffer_float

//								--- ~GL_ARB_depth_buffer_float (part of OpenGL 3.0 core) ---

//								--- GL_ARB_framebuffer_object (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_framebuffer_object
 *	@brief if defined, GL_ARB_framebuffer_object (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_framebuffer_object
#define GL_ARB_framebuffer_object 1

/**
 *	@def __GENERATE_GL_ARB_framebuffer_object
 *	@brief if defined, code to initialize GL_ARB_framebuffer_object (part of OpenGL 3.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_framebuffer_object

extern bool GLEH_ARB_framebuffer_object; /**< @brief set if GL_ARB_framebuffer_object is supported */

#define GL_FRAMEBUFFER												0x8d40 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_READ_FRAMEBUFFER											0x8ca8 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DRAW_FRAMEBUFFER											0x8ca9 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER												0x8d41 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_STENCIL_INDEX1											0x8d46 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_STENCIL_INDEX4											0x8d47 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_STENCIL_INDEX8											0x8d48 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_STENCIL_INDEX16											0x8d49 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_WIDTH										0x8d42 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_HEIGHT										0x8d43 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_INTERNAL_FORMAT								0x8d44 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_RED_SIZE									0x8d50 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_GREEN_SIZE									0x8d51 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_BLUE_SIZE									0x8d52 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_ALPHA_SIZE									0x8d53 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_DEPTH_SIZE									0x8d54 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_STENCIL_SIZE								0x8d55 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_SAMPLES										0x8cab /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE						0x8cd0 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME						0x8cd1 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL						0x8cd2 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE				0x8cd3 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER						0x8cd4 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING					0x8210 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE					0x8211 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE							0x8212 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE						0x8213 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE							0x8214 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE						0x8215 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE						0x8216 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE						0x8217 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
//#define GL_SRGB													  0x8c40 // (defined above)
#define GL_UNSIGNED_NORMALIZED										0x8c17 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_DEFAULT										0x8218 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_INDEX													0x8222 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT0										0x8ce0 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT1										0x8ce1 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT2										0x8ce2 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT3										0x8ce3 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT4										0x8ce4 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT5										0x8ce5 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT6										0x8ce6 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT7										0x8ce7 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT8										0x8ce8 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT9										0x8ce9 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT10										0x8cea /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT11										0x8ceb /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT12										0x8cec /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT13										0x8ced /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT14										0x8cee /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_COLOR_ATTACHMENT15										0x8cef /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DEPTH_ATTACHMENT											0x8d00 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_STENCIL_ATTACHMENT										0x8d20 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DEPTH_STENCIL_ATTACHMENT									0x821a /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_MAX_SAMPLES												0x8d57 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_COMPLETE										0x8cd5 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT						0x8cd6 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT				0x8cd7 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER						0x8cdb /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER						0x8cdc /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_UNSUPPORTED									0x8cdd /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE						0x8d56 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_UNDEFINED									0x8219 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_BINDING										0x8ca6 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DRAW_FRAMEBUFFER_BINDING									0x8ca6 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_READ_FRAMEBUFFER_BINDING									0x8caa /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_RENDERBUFFER_BINDING										0x8ca7 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_MAX_COLOR_ATTACHMENTS									0x8cdf /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_MAX_RENDERBUFFER_SIZE									0x84e8 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_INVALID_FRAMEBUFFER_OPERATION							0x0506 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DEPTH_STENCIL											0x84f9 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_UNSIGNED_INT_24_8										0x84fa /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_DEPTH24_STENCIL8											0x88f0 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/
#define GL_TEXTURE_STENCIL_SIZE										0x88f1 /**< @brief GL_ARB_framebuffer_object (part of OpenGL 3.0 core) enum **/

/**
 *	@brief determine if a name corresponds to a renderbuffer object
 *	@param[in] renderbuffer specifies a value that may be the name of a renderbuffer object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsRenderbuffer))(GLuint renderbuffer);

/**
 *	@brief bind a renderbuffer to a renderbuffer target
 *	@param[in] target specifies the renderbuffer target of the binding operation. target must be GL_RENDERBUFFER
 *	@param[in] renderbuffer specifies the name of the renderbuffer object to bind
 */
extern void (GLApi *GLFuncPtrName(glBindRenderbuffer))(GLenum target, GLuint renderbuffer);

/**
 *	@brief delete renderbuffer objects
 *	@param[in] n specifies the number of renderbuffer objects to be deleted
 *	@param[in] renderbuffers a pointer to an array containing n renderbuffer objects to be deleted
 */
extern void (GLApi *GLFuncPtrName(glDeleteRenderbuffers))(GLsizei n, const GLuint *renderbuffers);

/**
 *	@brief generate renderbuffer object names
 *	@param[in] n specifies the number of renderbuffer object names to generate
 *	@param[out] renderbuffers specifies an array in which the generated renderbuffer object names
 *		are stored
 */
extern void (GLApi *GLFuncPtrName(glGenRenderbuffers))(GLsizei n, GLuint *renderbuffers);

/**
 *	@brief establish data storage, format and dimensions of a renderbuffer object's image
 *	@param[in] target specifies a binding to which the target of the allocation and must be GL_RENDERBUFFER
 *	@param[in] internalformat specifies the internal format to use for the renderbuffer object's image
 *	@param[in] width specifies the width of the renderbuffer, in pixels
 *	@param[in] height specifies the height of the renderbuffer, in pixels
 */
extern void (GLApi *GLFuncPtrName(glRenderbufferStorage))(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);

/**
 *	@brief establish data storage, format, dimensions and sample count of a renderbuffer object's image
 *	@param[in] target specifies a binding to which the target of the allocation and must be GL_RENDERBUFFER
 *	@param[in] samples specifies the number of samples to be used for the renderbuffer object's storage
 *	@param[in] internalformat specifies the internal format to use for the renderbuffer object's image
 *	@param[in] width specifies the width of the renderbuffer, in pixels
 *	@param[in] height specifies the height of the renderbuffer, in pixels
 */
extern void (GLApi *GLFuncPtrName(glRenderbufferStorageMultisample))(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);

/**
 *	@brief retrieve information about a bound renderbuffer object
 *	@param[in] target specifies the target of the query operation. target must be GL_RENDERBUFFER
 *	@param[in] pname specifies the parameter whose value to retrieve from the renderbuffer bound to target
 *	@param[out] params specifies the address of an array to receive the value of the queried parameter
 */
extern void (GLApi *GLFuncPtrName(glGetRenderbufferParameteriv))(GLenum target, GLenum pname, int *params);

/**
 *	@brief determine if a name corresponds to a framebuffer object
 *	@param[in] framebuffer specifies a value that may be the name of a framebuffer object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsFramebuffer))(GLuint framebuffer);

/**
 *	@brief bind a framebuffer to a framebuffer target
 *	@param[in] target specifies the framebuffer target of the binding operation
 *	@param[in] framebuffer specifies the name of the framebuffer object to bind
 */
extern void (GLApi *GLFuncPtrName(glBindFramebuffer))(GLenum target, GLuint framebuffer);

/**
 *	@brief delete framebuffer objects
 *	@param[in] n specifies the number of framebuffer objects to be deleted
 *	@param[in] framebuffers a pointer to an array containing n framebuffer objects to be deleted
 */
extern void (GLApi *GLFuncPtrName(glDeleteFramebuffers))(GLsizei n, const GLuint *framebuffers);

/**
 *	@brief generate framebuffer object names
 *	@param[in] n specifies the number of framebuffer object names to generate
 *	@param[out] ids specifies an array in which the generated framebuffer object names are stored
 */
extern void (GLApi *GLFuncPtrName(glGenFramebuffers))(GLsizei n, GLuint *ids);

/**
 *	@brief check the completeness status of a framebuffer
 *	@param[in] target specify the target of the framebuffer completeness check
 */
extern GLenum (GLApi *GLFuncPtrName(glCheckFramebufferStatus))(GLenum target);

/**
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 */
extern void (GLApi *GLFuncPtrName(glFramebufferTexture1D))(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, int level);

/**
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 */
extern void (GLApi *GLFuncPtrName(glFramebufferTexture2D))(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, int level);

/**
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 *	@param[in] layer specifies the layer of 3D or layered texture to attach
 */
extern void (GLApi *GLFuncPtrName(glFramebufferTexture3D))(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, int level, int layer);

/**
 *	@brief attach a single layer of a texture to a framebuffer
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 *	@param[in] layer specifies the layer of texture to attach
 */
extern void (GLApi *GLFuncPtrName(glFramebufferTextureLayer))(GLenum target, GLenum attachment, GLuint texture, int level, int layer);

/**
 *	@brief attach a renderbuffer as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer
 *	@param[in] renderbuffertarget specifies the renderbuffer target and must be GL_RENDERBUFFER
 *	@param[in] renderbuffer specifies the name of an existing renderbuffer object of type
 *		renderbuffertarget to attach
 */
extern void (GLApi *GLFuncPtrName(glFramebufferRenderbuffer))(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);

/**
 *	@brief return attachment parameters of a framebuffer object
 *	@param[in] target specifies the target framebuffer object. The symbolic constant must be GL_FRAMEBUFFER
 *	@param[in] attachment specifies the symbolic name of a framebuffer object attachment point.
 *		Accepted values are GL_COLOR_ATTACHMENT0, GL_DEPTH_ATTACHMENT, and GL_STENCIL_ATTACHMENT
 *	@param[in] pname specifies the symbolic name of a framebuffer object attachment parameter.
 *		Accepted values are GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE,
 *		GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME, GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL, and GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
 *	@param[out] params returns the requested parameter
 */
extern void (GLApi *GLFuncPtrName(glGetFramebufferAttachmentParameteriv))(GLenum target, GLenum attachment, GLenum pname, int *params);

/**
 *	@brief copy a block of pixels from the read framebuffer to the draw framebuffer
 *	@param[in] srcX0 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcY0 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcX1 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcY1 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] dstX0 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstY0 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstX1 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstY1 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] mask the bitwise OR of the flags indicating which buffers are to be copied. The
 *		allowed flags are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT and GL_STENCIL_BUFFER_BIT
 *	@param[in] filter specifies the interpolation to be applied if the image is stretched. Must be
 *		GL_NEAREST or GL_LINEAR
 */
extern void (GLApi *GLFuncPtrName(glBlitFramebuffer))(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, GLbitfield mask, GLenum filter);

/**
 *	@brief generate mipmaps for a specified texture target
 *	@param[in] target specifies the target to which the texture whose mimaps to generate is bound.
 *		target must be GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY,
 *		GL_TEXTURE_2D_ARRAY or GL_TEXTURE_CUBE_MAP
 */
extern void (GLApi *GLFuncPtrName(glGenerateMipmap))(GLenum target);

inline GLboolean glIsRenderbuffer_glachwrap(GLuint renderbuffer, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsRenderbuffer)(renderbuffer); GL_AUTOCHECK_BLOCK("glIsRenderbuffer", p_s_filename, n_line); return result; }
inline GLboolean glIsFramebuffer_glachwrap(GLuint framebuffer, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsFramebuffer)(framebuffer); GL_AUTOCHECK_BLOCK("glIsFramebuffer", p_s_filename, n_line); return result; }
inline GLenum glCheckFramebufferStatus_glachwrap(GLenum target, const char *p_s_filename, int n_line) { GLenum result = GLFuncPtrName(glCheckFramebufferStatus)(target); GL_AUTOCHECK_BLOCK("glCheckFramebufferStatus", p_s_filename, n_line); return result; }

/**
 *	@def glIsRenderbuffer
 *	@brief determine if a name corresponds to a renderbuffer object
 *	@param[in] renderbuffer specifies a value that may be the name of a renderbuffer object
 */
#define glIsRenderbuffer(renderbuffer) GLAutoCheckFuncPtrName(glIsRenderbuffer)(renderbuffer GLAutoCheckExtraParams)

/**
 *	@def glBindRenderbuffer
 *	@brief bind a renderbuffer to a renderbuffer target
 *	@param[in] target specifies the renderbuffer target of the binding operation. target must be GL_RENDERBUFFER
 *	@param[in] renderbuffer specifies the name of the renderbuffer object to bind
 */
#define glBindRenderbuffer(target,renderbuffer) do { GLFuncPtrName(glBindRenderbuffer)(target, renderbuffer); GL_AUTOCHECK_BLOCK("glBindRenderbuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteRenderbuffers
 *	@brief delete renderbuffer objects
 *	@param[in] n specifies the number of renderbuffer objects to be deleted
 *	@param[in] renderbuffers a pointer to an array containing n renderbuffer objects to be deleted
 */
#define glDeleteRenderbuffers(n,renderbuffers) do { GLFuncPtrName(glDeleteRenderbuffers)(n, renderbuffers); GL_AUTOCHECK_BLOCK("glDeleteRenderbuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenRenderbuffers
 *	@brief generate renderbuffer object names
 *	@param[in] n specifies the number of renderbuffer object names to generate
 *	@param[out] renderbuffers specifies an array in which the generated renderbuffer object names
 *		are stored
 */
#define glGenRenderbuffers(n,renderbuffers) do { GLFuncPtrName(glGenRenderbuffers)(n, renderbuffers); GL_AUTOCHECK_BLOCK("glGenRenderbuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glRenderbufferStorage
 *	@brief establish data storage, format and dimensions of a renderbuffer object's image
 *	@param[in] target specifies a binding to which the target of the allocation and must be GL_RENDERBUFFER
 *	@param[in] internalformat specifies the internal format to use for the renderbuffer object's image
 *	@param[in] width specifies the width of the renderbuffer, in pixels
 *	@param[in] height specifies the height of the renderbuffer, in pixels
 */
#define glRenderbufferStorage(target,internalformat,width,height) do { GLFuncPtrName(glRenderbufferStorage)(target, internalformat, width, height); GL_AUTOCHECK_BLOCK("glRenderbufferStorage", __FILE__, __LINE__); } while(0)

/**
 *	@def glRenderbufferStorageMultisample
 *	@brief establish data storage, format, dimensions and sample count of a renderbuffer object's image
 *	@param[in] target specifies a binding to which the target of the allocation and must be GL_RENDERBUFFER
 *	@param[in] samples specifies the number of samples to be used for the renderbuffer object's storage
 *	@param[in] internalformat specifies the internal format to use for the renderbuffer object's image
 *	@param[in] width specifies the width of the renderbuffer, in pixels
 *	@param[in] height specifies the height of the renderbuffer, in pixels
 */
#define glRenderbufferStorageMultisample(target,samples,internalformat,width,height) do { GLFuncPtrName(glRenderbufferStorageMultisample)(target, samples, internalformat, width, height); GL_AUTOCHECK_BLOCK("glRenderbufferStorageMultisample", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetRenderbufferParameteriv
 *	@brief retrieve information about a bound renderbuffer object
 *	@param[in] target specifies the target of the query operation. target must be GL_RENDERBUFFER
 *	@param[in] pname specifies the parameter whose value to retrieve from the renderbuffer bound to target
 *	@param[out] params specifies the address of an array to receive the value of the queried parameter
 */
#define glGetRenderbufferParameteriv(target,pname,params) do { GLFuncPtrName(glGetRenderbufferParameteriv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetRenderbufferParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsFramebuffer
 *	@brief determine if a name corresponds to a framebuffer object
 *	@param[in] framebuffer specifies a value that may be the name of a framebuffer object
 */
#define glIsFramebuffer(framebuffer) GLAutoCheckFuncPtrName(glIsFramebuffer)(framebuffer GLAutoCheckExtraParams)

/**
 *	@def glBindFramebuffer
 *	@brief bind a framebuffer to a framebuffer target
 *	@param[in] target specifies the framebuffer target of the binding operation
 *	@param[in] framebuffer specifies the name of the framebuffer object to bind
 */
#define glBindFramebuffer(target,framebuffer) do { GLFuncPtrName(glBindFramebuffer)(target, framebuffer); GL_AUTOCHECK_BLOCK("glBindFramebuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteFramebuffers
 *	@brief delete framebuffer objects
 *	@param[in] n specifies the number of framebuffer objects to be deleted
 *	@param[in] framebuffers a pointer to an array containing n framebuffer objects to be deleted
 */
#define glDeleteFramebuffers(n,framebuffers) do { GLFuncPtrName(glDeleteFramebuffers)(n, framebuffers); GL_AUTOCHECK_BLOCK("glDeleteFramebuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenFramebuffers
 *	@brief generate framebuffer object names
 *	@param[in] n specifies the number of framebuffer object names to generate
 *	@param[out] ids specifies an array in which the generated framebuffer object names are stored
 */
#define glGenFramebuffers(n,ids) do { GLFuncPtrName(glGenFramebuffers)(n, ids); GL_AUTOCHECK_BLOCK("glGenFramebuffers", __FILE__, __LINE__); } while(0)

/**
 *	@def glCheckFramebufferStatus
 *	@brief check the completeness status of a framebuffer
 *	@param[in] target specify the target of the framebuffer completeness check
 */
#define glCheckFramebufferStatus(target) GLAutoCheckFuncPtrName(glCheckFramebufferStatus)(target GLAutoCheckExtraParams)

/**
 *	@def glFramebufferTexture1D
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 */
#define glFramebufferTexture1D(target,attachment,textarget,texture,level) do { GLFuncPtrName(glFramebufferTexture1D)(target, attachment, textarget, texture, level); GL_AUTOCHECK_BLOCK("glFramebufferTexture1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glFramebufferTexture2D
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 */
#define glFramebufferTexture2D(target,attachment,textarget,texture,level) do { GLFuncPtrName(glFramebufferTexture2D)(target, attachment, textarget, texture, level); GL_AUTOCHECK_BLOCK("glFramebufferTexture2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glFramebufferTexture3D
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] textarget for glFramebufferTexture1D, glFramebufferTexture2D and
 *		glFramebufferTexture3D, specifies what type of texture is expected in the texture parameter,
 *		or for cube map textures, which face is to be attached
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 *	@param[in] layer specifies the layer of 3D or layered texture to attach
 */
#define glFramebufferTexture3D(target,attachment,textarget,texture,level,layer) do { GLFuncPtrName(glFramebufferTexture3D)(target, attachment, textarget, texture, level, layer); GL_AUTOCHECK_BLOCK("glFramebufferTexture3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glFramebufferTextureLayer
 *	@brief attach a single layer of a texture to a framebuffer
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT
 *	@param[in] texture specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment
 *	@param[in] level specifies the mipmap level of texture to attach
 *	@param[in] layer specifies the layer of texture to attach
 */
#define glFramebufferTextureLayer(target,attachment,texture,level,layer) do { GLFuncPtrName(glFramebufferTextureLayer)(target, attachment, texture, level, layer); GL_AUTOCHECK_BLOCK("glFramebufferTextureLayer", __FILE__, __LINE__); } while(0)

/**
 *	@def glFramebufferRenderbuffer
 *	@brief attach a renderbuffer as a logical buffer to the currently bound framebuffer object
 *	@param[in] target specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER
 *	@param[in] attachment specifies the attachment point of the framebuffer
 *	@param[in] renderbuffertarget specifies the renderbuffer target and must be GL_RENDERBUFFER
 *	@param[in] renderbuffer specifies the name of an existing renderbuffer object of type
 *		renderbuffertarget to attach
 */
#define glFramebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer) do { GLFuncPtrName(glFramebufferRenderbuffer)(target, attachment, renderbuffertarget, renderbuffer); GL_AUTOCHECK_BLOCK("glFramebufferRenderbuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFramebufferAttachmentParameteriv
 *	@brief return attachment parameters of a framebuffer object
 *	@param[in] target specifies the target framebuffer object. The symbolic constant must be GL_FRAMEBUFFER
 *	@param[in] attachment specifies the symbolic name of a framebuffer object attachment point.
 *		Accepted values are GL_COLOR_ATTACHMENT0, GL_DEPTH_ATTACHMENT, and GL_STENCIL_ATTACHMENT
 *	@param[in] pname specifies the symbolic name of a framebuffer object attachment parameter.
 *		Accepted values are GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE,
 *		GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME, GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL, and GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
 *	@param[out] params returns the requested parameter
 */
#define glGetFramebufferAttachmentParameteriv(target,attachment,pname,params) do { GLFuncPtrName(glGetFramebufferAttachmentParameteriv)(target, attachment, pname, params); GL_AUTOCHECK_BLOCK("glGetFramebufferAttachmentParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlitFramebuffer
 *	@brief copy a block of pixels from the read framebuffer to the draw framebuffer
 *	@param[in] srcX0 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcY0 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcX1 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] srcY1 specify the bounds of the source rectangle within the read buffer of the read framebuffer
 *	@param[in] dstX0 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstY0 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstX1 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] dstY1 specify the bounds of the destination rectangle within the write buffer of the
 *		write framebuffer
 *	@param[in] mask the bitwise OR of the flags indicating which buffers are to be copied. The
 *		allowed flags are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT and GL_STENCIL_BUFFER_BIT
 *	@param[in] filter specifies the interpolation to be applied if the image is stretched. Must be
 *		GL_NEAREST or GL_LINEAR
 */
#define glBlitFramebuffer(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter) do { GLFuncPtrName(glBlitFramebuffer)(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter); GL_AUTOCHECK_BLOCK("glBlitFramebuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenerateMipmap
 *	@brief generate mipmaps for a specified texture target
 *	@param[in] target specifies the target to which the texture whose mimaps to generate is bound.
 *		target must be GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY,
 *		GL_TEXTURE_2D_ARRAY or GL_TEXTURE_CUBE_MAP
 */
#define glGenerateMipmap(target) do { GLFuncPtrName(glGenerateMipmap)(target); GL_AUTOCHECK_BLOCK("glGenerateMipmap", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_framebuffer_object

//								--- ~GL_ARB_framebuffer_object (part of OpenGL 3.0 core) ---

//								--- GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_framebuffer_sRGB
 *	@brief if defined, GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_framebuffer_sRGB
#define GL_ARB_framebuffer_sRGB 1

extern bool GLEH_ARB_framebuffer_sRGB; /**< @brief set if GL_ARB_framebuffer_sRGB is supported */

#define GL_GLX_FRAMEBUFFER_SRGB_CAPABLE								0x20b2 /**< @brief GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) enum **/
#define GL_WGL_FRAMEBUFFER_SRGB_CAPABLE								0x20a9 /**< @brief GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) enum **/
#define GL_FRAMEBUFFER_SRGB											0x8db9 /**< @brief GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_framebuffer_sRGB

//								--- ~GL_ARB_framebuffer_sRGB (part of OpenGL 3.0 core) ---

//								--- GL_ARB_half_float_vertex (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_half_float_vertex
 *	@brief if defined, GL_ARB_half_float_vertex (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_half_float_vertex
#define GL_ARB_half_float_vertex 1

extern bool GLEH_ARB_half_float_vertex; /**< @brief set if GL_ARB_half_float_vertex is supported */

#define GL_HALF_FLOAT												0x140b /**< @brief GL_ARB_half_float_vertex (part of OpenGL 3.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_half_float_vertex

//								--- ~GL_ARB_half_float_vertex (part of OpenGL 3.0 core) ---

//								--- GL_ARB_map_buffer_range (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_map_buffer_range
 *	@brief if defined, GL_ARB_map_buffer_range (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_map_buffer_range
#define GL_ARB_map_buffer_range 1

/**
 *	@def __GENERATE_GL_ARB_map_buffer_range
 *	@brief if defined, code to initialize GL_ARB_map_buffer_range (part of OpenGL 3.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_map_buffer_range

extern bool GLEH_ARB_map_buffer_range; /**< @brief set if GL_ARB_map_buffer_range is supported */

#define GL_MAP_READ_BIT												0x0001 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/
#define GL_MAP_WRITE_BIT											0x0002 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/
#define GL_MAP_INVALIDATE_RANGE_BIT									0x0004 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/
#define GL_MAP_INVALIDATE_BUFFER_BIT								0x0008 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/
#define GL_MAP_FLUSH_EXPLICIT_BIT									0x0010 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/
#define GL_MAP_UNSYNCHRONIZED_BIT									0x0020 /**< @brief GL_ARB_map_buffer_range (part of OpenGL 3.0 core) enum **/

/**
 *	@brief map a section of a buffer object's data store
 *	@param[in] target specifies a binding to which the target buffer is bound
 *	@param[in] offset specifies a the starting offset within the buffer of the range to be mapped
 *	@param[in] length specifies a length of the range to be mapped
 *	@param[in] access specifies a combination of access flags indicating the desired access to the range
 */
extern void* (GLApi *GLFuncPtrName(glMapBufferRange))(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);

/**
 *	@brief indicate modifications to a range of a mapped buffer
 *	@param[in] target specifies the target of the flush operation. target must be GL_ARRAY_BUFFER,
 *		GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER,
 *		GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER
 *	@param[in] offset specifies the start of the buffer subrange, in basic machine units
 *	@param[in] length specifies the length of the buffer subrange, in basic machine units
 */
extern void (GLApi *GLFuncPtrName(glFlushMappedBufferRange))(GLenum target, GLintptr offset, GLsizeiptr length);

inline void *glMapBufferRange_glachwrap(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access, const char *p_s_filename, int n_line) { void *result = GLFuncPtrName(glMapBufferRange)(target,offset,length,access); GL_AUTOCHECK_BLOCK("glMapBufferRange", p_s_filename, n_line); return result; }

/**
 *	@def glMapBufferRange
 *	@brief map a section of a buffer object's data store
 *	@param[in] target specifies a binding to which the target buffer is bound
 *	@param[in] offset specifies a the starting offset within the buffer of the range to be mapped
 *	@param[in] length specifies a length of the range to be mapped
 *	@param[in] access specifies a combination of access flags indicating the desired access to the range
 */
#define glMapBufferRange(target,offset,length,access) GLAutoCheckFuncPtrName(glMapBufferRange)(target, offset, length, access GLAutoCheckExtraParams)

/**
 *	@def glFlushMappedBufferRange
 *	@brief indicate modifications to a range of a mapped buffer
 *	@param[in] target specifies the target of the flush operation. target must be GL_ARRAY_BUFFER,
 *		GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER,
 *		GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER
 *	@param[in] offset specifies the start of the buffer subrange, in basic machine units
 *	@param[in] length specifies the length of the buffer subrange, in basic machine units
 */
#define glFlushMappedBufferRange(target,offset,length) do { GLFuncPtrName(glFlushMappedBufferRange)(target, offset, length); GL_AUTOCHECK_BLOCK("glFlushMappedBufferRange", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_map_buffer_range

//								--- ~GL_ARB_map_buffer_range (part of OpenGL 3.0 core) ---

//								--- GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_texture_compression_rgtc
 *	@brief if defined, GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_texture_compression_rgtc
#define GL_ARB_texture_compression_rgtc 1

extern bool GLEH_ARB_texture_compression_rgtc; /**< @brief set if GL_ARB_texture_compression_rgtc is supported */

#define GL_COMPRESSED_RED_RGTC1										0x8dbb /**< @brief GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) enum **/
#define GL_COMPRESSED_SIGNED_RED_RGTC1								0x8dbc /**< @brief GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) enum **/
#define GL_COMPRESSED_RG_RGTC2										0x8dbd /**< @brief GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) enum **/
#define GL_COMPRESSED_SIGNED_RG_RGTC2								0x8dbe /**< @brief GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_compression_rgtc

//								--- ~GL_ARB_texture_compression_rgtc (part of OpenGL 3.0 core) ---

//								--- GL_ARB_texture_rg (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_texture_rg
 *	@brief if defined, GL_ARB_texture_rg (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_texture_rg
#define GL_ARB_texture_rg 1

extern bool GLEH_ARB_texture_rg; /**< @brief set if GL_ARB_texture_rg is supported */

#define GL_R8														0x8229 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R16														0x822a /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG8														0x822b /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG16														0x822c /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R16F														0x822d /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R32F														0x822e /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG16F													0x822f /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG32F													0x8230 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R8I														0x8231 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R8UI														0x8232 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R16I														0x8233 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R16UI													0x8234 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R32I														0x8235 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_R32UI													0x8236 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG8I														0x8237 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG8UI													0x8238 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG16I													0x8239 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG16UI													0x823a /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG32I													0x823b /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG32UI													0x823c /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RED														0x1903 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG														0x8227 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_COMPRESSED_RED											0x8225 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_COMPRESSED_RG											0x8226 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/
#define GL_RG_INTEGER												0x8228 /**< @brief GL_ARB_texture_rg (part of OpenGL 3.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_rg

//								--- ~GL_ARB_texture_rg (part of OpenGL 3.0 core) ---

//								--- GL_ARB_vertex_array_object (part of OpenGL 3.0 core) ---

/**
 *	@def GL_ARB_vertex_array_object
 *	@brief if defined, GL_ARB_vertex_array_object (part of OpenGL 3.0 core) entry points are available
 */
#ifndef GL_ARB_vertex_array_object
#define GL_ARB_vertex_array_object 1

/**
 *	@def __GENERATE_GL_ARB_vertex_array_object
 *	@brief if defined, code to initialize GL_ARB_vertex_array_object (part of OpenGL 3.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_vertex_array_object

extern bool GLEH_ARB_vertex_array_object; /**< @brief set if GL_ARB_vertex_array_object is supported */

#define GL_VERTEX_ARRAY_BINDING										0x85b5 /**< @brief GL_ARB_vertex_array_object (part of OpenGL 3.0 core) enum **/

/**
 *	@brief bind a vertex array object
 *	@param[in] array specifies the name of the vertex array to bind
 */
extern void (GLApi *GLFuncPtrName(glBindVertexArray))(GLuint array);

/**
 *	@brief delete vertex array objects
 *	@param[in] n specifies the number of vertex array objects to be deleted
 *	@param[in] arrays specifies the address of an array containing the n names of the objects to be deleted
 */
extern void (GLApi *GLFuncPtrName(glDeleteVertexArrays))(GLsizei n, const GLuint *arrays);

/**
 *	@brief generate vertex array object names
 *	@param[in] n specifies the number of vertex array object names to generate
 *	@param[out] arrays specifies an array in which the generated vertex array object names are stored
 */
extern void (GLApi *GLFuncPtrName(glGenVertexArrays))(GLsizei n, GLuint *arrays);

/**
 *	@brief determine if a name corresponds to a vertex array object
 *	@param[in] array specifies a value that may be the name of a vertex array object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsVertexArray))(GLuint array);

inline GLboolean glIsVertexArray_glachwrap(GLuint array, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsVertexArray)(array); GL_AUTOCHECK_BLOCK("glIsVertexArray", p_s_filename, n_line); return result; }

/**
 *	@def glBindVertexArray
 *	@brief bind a vertex array object
 *	@param[in] array specifies the name of the vertex array to bind
 */
#define glBindVertexArray(array) do { GLFuncPtrName(glBindVertexArray)(array); GL_AUTOCHECK_BLOCK("glBindVertexArray", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteVertexArrays
 *	@brief delete vertex array objects
 *	@param[in] n specifies the number of vertex array objects to be deleted
 *	@param[in] arrays specifies the address of an array containing the n names of the objects to be deleted
 */
#define glDeleteVertexArrays(n,arrays) do { GLFuncPtrName(glDeleteVertexArrays)(n, arrays); GL_AUTOCHECK_BLOCK("glDeleteVertexArrays", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenVertexArrays
 *	@brief generate vertex array object names
 *	@param[in] n specifies the number of vertex array object names to generate
 *	@param[out] arrays specifies an array in which the generated vertex array object names are stored
 */
#define glGenVertexArrays(n,arrays) do { GLFuncPtrName(glGenVertexArrays)(n, arrays); GL_AUTOCHECK_BLOCK("glGenVertexArrays", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsVertexArray
 *	@brief determine if a name corresponds to a vertex array object
 *	@param[in] array specifies a value that may be the name of a vertex array object
 */
#define glIsVertexArray(array) GLAutoCheckFuncPtrName(glIsVertexArray)(array GLAutoCheckExtraParams)

#endif // !GL_ARB_vertex_array_object

//								--- ~GL_ARB_vertex_array_object (part of OpenGL 3.0 core) ---

//								--- OpenGL 3.1 ---

/**
 *	@def GL_VERSION_3_1
 *	@brief if defined, OpenGL 3.1 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_3_1
#define GL_VERSION_3_1 1

/**
 *	@def __GENERATE_GL_31__
 *	@brief if defined, code to initialize OpenGL 3.1 entry points is compiled
 */
#define __GENERATE_GL_31__

extern bool GLEH_OPENGL_3_1; /**< @brief set if OpenGL 3.1 is supported */

#define GL_SAMPLER_2D_RECT											0x8B63 /**< @brief OpenGL 3.1 enum */
#define GL_SAMPLER_2D_RECT_SHADOW									0x8B64 /**< @brief OpenGL 3.1 enum */
#define GL_SAMPLER_BUFFER											0x8DC2 /**< @brief OpenGL 3.1 enum */
#define GL_INT_SAMPLER_2D_RECT										0x8DCD /**< @brief OpenGL 3.1 enum */
#define GL_INT_SAMPLER_BUFFER										0x8DD0 /**< @brief OpenGL 3.1 enum */
#define GL_UNSIGNED_INT_SAMPLER_2D_RECT								0x8DD5 /**< @brief OpenGL 3.1 enum */
#define GL_UNSIGNED_INT_SAMPLER_BUFFER								0x8DD8 /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_BUFFER											0x8C2A /**< @brief OpenGL 3.1 enum */
#define GL_MAX_TEXTURE_BUFFER_SIZE									0x8C2B /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_BINDING_BUFFER									0x8C2C /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING						0x8C2D /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_BUFFER_FORMAT									0x8C2E /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_RECTANGLE										0x84F5 /**< @brief OpenGL 3.1 enum */
#define GL_TEXTURE_BINDING_RECTANGLE								0x84F6 /**< @brief OpenGL 3.1 enum */
#define GL_PROXY_TEXTURE_RECTANGLE									0x84F7 /**< @brief OpenGL 3.1 enum */
#define GL_MAX_RECTANGLE_TEXTURE_SIZE								0x84F8 /**< @brief OpenGL 3.1 enum */
#define GL_RED_SNORM												0x8F90 /**< @brief OpenGL 3.1 enum */
#define GL_RG_SNORM													0x8F91 /**< @brief OpenGL 3.1 enum */
#define GL_RGB_SNORM												0x8F92 /**< @brief OpenGL 3.1 enum */
#define GL_RGBA_SNORM												0x8F93 /**< @brief OpenGL 3.1 enum */
#define GL_R8_SNORM													0x8F94 /**< @brief OpenGL 3.1 enum */
#define GL_RG8_SNORM												0x8F95 /**< @brief OpenGL 3.1 enum */
#define GL_RGB8_SNORM												0x8F96 /**< @brief OpenGL 3.1 enum */
#define GL_RGBA8_SNORM												0x8F97 /**< @brief OpenGL 3.1 enum */
#define GL_R16_SNORM												0x8F98 /**< @brief OpenGL 3.1 enum */
#define GL_RG16_SNORM												0x8F99 /**< @brief OpenGL 3.1 enum */
#define GL_RGB16_SNORM												0x8F9A /**< @brief OpenGL 3.1 enum */
#define GL_RGBA16_SNORM												0x8F9B /**< @brief OpenGL 3.1 enum */
#define GL_SIGNED_NORMALIZED										0x8F9C /**< @brief OpenGL 3.1 enum */
#define GL_PRIMITIVE_RESTART										0x8F9D /**< @brief OpenGL 3.1 enum */
#define GL_PRIMITIVE_RESTART_INDEX									0x8F9E /**< @brief OpenGL 3.1 enum */

/* Reuse tokens from ARB_copy_buffer */
/* Would reuse tokens from ARB_draw_instanced, but it has none */
/* Reuse tokens from ARB_uniform_buffer_object */

/**
 *	@brief attach the storage for a buffer object to the active buffer texture
 *	@param[in] target Specifies the target of the operation and must be GL_TEXTURE_BUFFER.
 *	@param[in] internalFormat Specifies the internal format of the data in the store belonging to buffer.
 *	@param[in] buffer Specifies the name of the buffer object whose storage to attach to the active
 *		buffer texture.
 */
extern void (GLApi *GLFuncPtrName(glTexBuffer))(GLenum target, GLenum internalFormat, GLuint buffer);

/**
 *	@brief specify the primitive restart index
 *	@param[in] index Specifies the value to be interpreted as the primitive restart index.
 */
extern void (GLApi *GLFuncPtrName(glPrimitiveRestartIndex))(GLuint index);

/**
 *	@def glTexBuffer
 *	@brief attach the storage for a buffer object to the active buffer texture
 *	@param[in] target Specifies the target of the operation and must be GL_TEXTURE_BUFFER.
 *	@param[in] internalFormat Specifies the internal format of the data in the store belonging to buffer.
 *	@param[in] buffer Specifies the name of the buffer object whose storage to attach to the active
 *		buffer texture.
 */
#define glTexBuffer(target,internalFormat,buffer) do { GLFuncPtrName(glTexBuffer)(target, internalFormat, buffer); GL_AUTOCHECK_BLOCK("glTexBuffer", __FILE__, __LINE__); } while(0)

/**
 *	@def glPrimitiveRestartIndex
 *	@brief specify the primitive restart index
 *	@param[in] index Specifies the value to be interpreted as the primitive restart index.
 */
#define glPrimitiveRestartIndex(index) do { GLFuncPtrName(glPrimitiveRestartIndex)(index); GL_AUTOCHECK_BLOCK("glPrimitiveRestartIndex", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_3_1

//								--- ~OpenGL 3.1 ---

//								--- GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) ---

/**
 *	@def GL_ARB_uniform_buffer_object
 *	@brief if defined, GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) entry points are available
 */
#ifndef GL_ARB_uniform_buffer_object
#define GL_ARB_uniform_buffer_object 1

/**
 *	@def __GENERATE_GL_ARB_uniform_buffer_object
 *	@brief if defined, code to initialize GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_uniform_buffer_object

extern bool GLEH_ARB_uniform_buffer_object; /**< @brief set if GL_ARB_uniform_buffer_object is supported */

#define GL_UNIFORM_BUFFER											0x8a11 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BUFFER_BINDING									0x8a28 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BUFFER_START										0x8a29 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BUFFER_SIZE										0x8a2a /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_VERTEX_UNIFORM_BLOCKS								0x8a2b /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS								0x8a2c /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS								0x8a2d /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_COMBINED_UNIFORM_BLOCKS								0x8a2e /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_UNIFORM_BUFFER_BINDINGS								0x8a2f /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_UNIFORM_BLOCK_SIZE									0x8a30 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS					0x8a31 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS					0x8a32 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS					0x8a33 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT							0x8a34 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH						0x8a35 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_ACTIVE_UNIFORM_BLOCKS									0x8a36 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_TYPE												0x8a37 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_SIZE												0x8a38 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_NAME_LENGTH										0x8a39 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_INDEX										0x8a3a /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_OFFSET											0x8a3b /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_ARRAY_STRIDE										0x8a3c /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_MATRIX_STRIDE									0x8a3d /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_IS_ROW_MAJOR										0x8a3e /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_BINDING									0x8a3f /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_DATA_SIZE									0x8a40 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_NAME_LENGTH								0x8a41 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS							0x8a42 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES						0x8a43 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER				0x8a44 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER				0x8a45 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER				0x8a46 /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/
#define GL_INVALID_INDEX											0xffffffffu /**< @brief GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) enum **/

/**
 *	@brief retrieve the index of a named uniform block
 *	@param[in] program specifies the name of a program containing uniforms whose indices to query
 *	@param[in] uniformCount specifies the number of uniforms whose indices to query
 *	@param[in] uniformNames specifies the address of an array of pointers to buffers containing the
 *		names of the queried uniforms
 *	@param[out] uniformIndices specifies the address of an array that will receive the indices of
 *		the uniforms
 */
extern void (GLApi *GLFuncPtrName(glGetUniformIndices))(GLuint program, GLsizei uniformCount, const GLchar **uniformNames, GLuint *uniformIndices);

/**
 *	@brief returns information about several active uniform variables for the specified program object
 *	@param[in] program specifies the program object to be queried
 *	@param[in] uniformCount specifies both the number of elements in the array of indices
 *		uniformIndices and the number of parameters written to params upon successful return
 *	@param[in] uniformIndices specifies the address of an array of uniformCount integers containing
 *		the indices of uniforms within program whose parameter pname pname
 *	@param[in] pname specifies the property of the each uniform in uniformIndices that should be
 *		written into the corresponding element of params
 *	@param[out] params specifies the address of an array of uniformCount integers which are to
 *		receive the value of pname for each uniform in uniformIndices
 */
extern void (GLApi *GLFuncPtrName(glGetActiveUniformsiv))(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, int *params);

/**
 *	@brief query the name of an active uniform
 *	@param[in] program specifies the program containing the active uniform index uniformIndex
 *	@param[in] uniformIndex specifies the index of the active uniform whose name to query
 *	@param[in] bufSize specifies the size of the buffer, in units of GLchar, of the buffer whose
 *		address is specified in uniformName
 *	@param[out] length specifies the address of a variable that will receive the number of
 *		characters that were or would have been written to the buffer addressed by uniformName
 *	@param[out] uniformName specifies the address of a buffer into which the GL will place the name
 *		of the active uniform at uniformIndex within program
 */
extern void (GLApi *GLFuncPtrName(glGetActiveUniformName))(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);

/**
 *	@brief retrieve the index of a named uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockName specifies the address an array of characters to containing the name
 *		of the uniform block whose index to retrieve
 */
extern GLuint (GLApi *GLFuncPtrName(glGetUniformBlockIndex))(GLuint program, const GLchar *uniformBlockName);

/**
 *	@brief query information about an active uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockIndex specifies the index of the uniform block within program
 *	@param[in] pname specifies the name of the parameter to query
 *	@param[out] params specifies the address of a variable to receive the result of the query
 */
extern void (GLApi *GLFuncPtrName(glGetActiveUniformBlockiv))(GLuint program, GLuint uniformBlockIndex, GLenum pname, int *params);

/**
 *	@brief retrieve the name of an active uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockIndex specifies the index of the uniform block within program
 *	@param[in] bufSize specifies the size of the buffer addressed by uniformBlockName
 *	@param[out] length specifies the address of a variable to receive the number of characters that
 *		were written to uniformBlockName
 *	@param[out] uniformBlockName specifies the address an array of characters to receive the name of
 *		the uniform block at uniformBlockIndex
 */
extern void (GLApi *GLFuncPtrName(glGetActiveUniformBlockName))(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
//extern void (GLApi *GLFuncPtrName(glBindBufferRange))(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size); // defined above
//extern void (GLApi *GLFuncPtrName(glBindBufferBase))(GLenum target, GLuint index, GLuint buffer); // defined above
//extern void (GLApi *GLFuncPtrName(glGetIntegeri_v))(GLenum pname, GLuint index, int *data); // defined above

/**
 *	@brief assign a binding point to an active uniform block
 *	@param[in] program the name of a program object containing the active uniform block whose
 *		binding to assign
 *	@param[in] uniformBlockIndex the index of the active uniform block within program whose binding
 *		to assign
 *	@param[in] uniformBlockBinding specifies the binding point to which to bind the uniform block
 *		with index uniformBlockIndex within program
 */
extern void (GLApi *GLFuncPtrName(glUniformBlockBinding))(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);

inline GLuint glGetUniformBlockIndex_glachwrap(GLuint program, const GLchar *uniformBlockName, const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glGetUniformBlockIndex)(program,uniformBlockName); GL_AUTOCHECK_BLOCK("glGetUniformBlockIndex", p_s_filename, n_line); return result; }

/**
 *	@def glGetUniformIndices
 *	@brief retrieve the index of a named uniform block
 *	@param[in] program specifies the name of a program containing uniforms whose indices to query
 *	@param[in] uniformCount specifies the number of uniforms whose indices to query
 *	@param[in] uniformNames specifies the address of an array of pointers to buffers containing the
 *		names of the queried uniforms
 *	@param[out] uniformIndices specifies the address of an array that will receive the indices of
 *		the uniforms
 */
#define glGetUniformIndices(program,uniformCount,uniformNames,uniformIndices) do { GLFuncPtrName(glGetUniformIndices)(program, uniformCount, uniformNames, uniformIndices); GL_AUTOCHECK_BLOCK("glGetUniformIndices", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveUniformsiv
 *	@brief returns information about several active uniform variables for the specified program object
 *	@param[in] program specifies the program object to be queried
 *	@param[in] uniformCount specifies both the number of elements in the array of indices
 *		uniformIndices and the number of parameters written to params upon successful return
 *	@param[in] uniformIndices specifies the address of an array of uniformCount integers containing
 *		the indices of uniforms within program whose parameter pname pname
 *	@param[in] pname specifies the property of the each uniform in uniformIndices that should be
 *		written into the corresponding element of params
 *	@param[out] params specifies the address of an array of uniformCount integers which are to
 *		receive the value of pname for each uniform in uniformIndices
 */
#define glGetActiveUniformsiv(program,uniformCount,uniformIndices,pname,params) do { GLFuncPtrName(glGetActiveUniformsiv)(program, uniformCount, uniformIndices, pname, params); GL_AUTOCHECK_BLOCK("glGetActiveUniformsiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveUniformName
 *	@brief query the name of an active uniform
 *	@param[in] program specifies the program containing the active uniform index uniformIndex
 *	@param[in] uniformIndex specifies the index of the active uniform whose name to query
 *	@param[in] bufSize specifies the size of the buffer, in units of GLchar, of the buffer whose
 *		address is specified in uniformName
 *	@param[out] length specifies the address of a variable that will receive the number of
 *		characters that were or would have been written to the buffer addressed by uniformName
 *	@param[out] uniformName specifies the address of a buffer into which the GL will place the name
 *		of the active uniform at uniformIndex within program
 */
#define glGetActiveUniformName(program,uniformIndex,bufSize,length,uniformName) do { GLFuncPtrName(glGetActiveUniformName)(program, uniformIndex, bufSize, length, uniformName); GL_AUTOCHECK_BLOCK("glGetActiveUniformName", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformBlockIndex
 *	@brief retrieve the index of a named uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockName specifies the address an array of characters to containing the name
 *		of the uniform block whose index to retrieve
 */
#define glGetUniformBlockIndex(program,uniformBlockName) GLAutoCheckFuncPtrName(glGetUniformBlockIndex)(program, uniformBlockName GLAutoCheckExtraParams)

/**
 *	@def glGetActiveUniformBlockiv
 *	@brief query information about an active uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockIndex specifies the index of the uniform block within program
 *	@param[in] pname specifies the name of the parameter to query
 *	@param[out] params specifies the address of a variable to receive the result of the query
 */
#define glGetActiveUniformBlockiv(program,uniformBlockIndex,pname,params) do { GLFuncPtrName(glGetActiveUniformBlockiv)(program, uniformBlockIndex, pname, params); GL_AUTOCHECK_BLOCK("glGetActiveUniformBlockiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveUniformBlockName
 *	@brief retrieve the name of an active uniform block
 *	@param[in] program specifies the name of a program containing the uniform block
 *	@param[in] uniformBlockIndex specifies the index of the uniform block within program
 *	@param[in] bufSize specifies the size of the buffer addressed by uniformBlockName
 *	@param[out] length specifies the address of a variable to receive the number of characters that
 *		were written to uniformBlockName
 *	@param[out] uniformBlockName specifies the address an array of characters to receive the name of
 *		the uniform block at uniformBlockIndex
 */
#define glGetActiveUniformBlockName(program,uniformBlockIndex,bufSize,length,uniformBlockName) do { GLFuncPtrName(glGetActiveUniformBlockName)(program, uniformBlockIndex, bufSize, length, uniformBlockName); GL_AUTOCHECK_BLOCK("glGetActiveUniformBlockName", __FILE__, __LINE__); } while(0)
//#define glBindBufferRange(target,index,buffer,offset,size) do { GLFuncPtrName(glBindBufferRange)(target, index, buffer, offset, size); GL_AUTOCHECK_BLOCK("glBindBufferRange", __FILE__, __LINE__); } while(0)
//#define glBindBufferBase(target,index,buffer) do { GLFuncPtrName(glBindBufferBase)(target, index, buffer); GL_AUTOCHECK_BLOCK("glBindBufferBase", __FILE__, __LINE__); } while(0)
//#define glGetIntegeri_v(pname,index,data) do { GLFuncPtrName(glGetIntegeri_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetIntegeri_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformBlockBinding
 *	@brief assign a binding point to an active uniform block
 *	@param[in] program the name of a program object containing the active uniform block whose
 *		binding to assign
 *	@param[in] uniformBlockIndex the index of the active uniform block within program whose binding
 *		to assign
 *	@param[in] uniformBlockBinding specifies the binding point to which to bind the uniform block
 *		with index uniformBlockIndex within program
 */
#define glUniformBlockBinding(program,uniformBlockIndex,uniformBlockBinding) do { GLFuncPtrName(glUniformBlockBinding)(program, uniformBlockIndex, uniformBlockBinding); GL_AUTOCHECK_BLOCK("glUniformBlockBinding", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_uniform_buffer_object

//								--- ~GL_ARB_uniform_buffer_object (part of OpenGL 3.1 core) ---

//								--- GL_ARB_draw_instanced (part of OpenGL 3.1 core) ---

/**
 *	@def GL_ARB_draw_instanced
 *	@brief if defined, GL_ARB_draw_instanced (part of OpenGL 3.1 core) entry points are available
 */
#ifndef GL_ARB_draw_instanced
#define GL_ARB_draw_instanced 1

/**
 *	@def __GENERATE_GL_ARB_draw_instanced
 *	@brief if defined, code to initialize GL_ARB_draw_instanced (part of OpenGL 3.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_draw_instanced

extern bool GLEH_ARB_draw_instanced; /**< @brief set if GL_ARB_draw_instanced is supported */

// no new tokens

/**
 *	@brief draw multiple instances of a range of elements
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] first specifies the starting index in the enabled arrays
 *	@param[in] count specifies the number of indices to be rendered
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 */
extern void (GLApi *GLFuncPtrName(glDrawArraysInstanced))(GLenum mode, int first, GLsizei count, GLsizei primcount);

/**
 *	@brief draw multiple instances of a set of elements
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsInstanced))(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount);

/**
 *	@def glDrawArraysInstanced
 *	@brief draw multiple instances of a range of elements
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] first specifies the starting index in the enabled arrays
 *	@param[in] count specifies the number of indices to be rendered
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 */
#define glDrawArraysInstanced(mode,first,count,primcount) do { GLFuncPtrName(glDrawArraysInstanced)(mode, first, count, primcount); GL_AUTOCHECK_BLOCK("glDrawArraysInstanced", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElementsInstanced
 *	@brief draw multiple instances of a set of elements
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 */
#define glDrawElementsInstanced(mode,count,type,indices,primcount) do { GLFuncPtrName(glDrawElementsInstanced)(mode, count, type, indices, primcount); GL_AUTOCHECK_BLOCK("glDrawElementsInstanced", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_draw_instanced

//								--- ~GL_ARB_draw_instanced (part of OpenGL 3.1 core) ---

//								--- GL_ARB_copy_buffer (part of OpenGL 3.1 core) ---

/**
 *	@def GL_ARB_copy_buffer
 *	@brief if defined, GL_ARB_copy_buffer (part of OpenGL 3.1 core) entry points are available
 */
#ifndef GL_ARB_copy_buffer
#define GL_ARB_copy_buffer 1

/**
 *	@def __GENERATE_GL_ARB_copy_buffer
 *	@brief if defined, code to initialize GL_ARB_copy_buffer (part of OpenGL 3.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_copy_buffer

extern bool GLEH_ARB_copy_buffer; /**< @brief set if GL_ARB_copy_buffer is supported */

#define GL_COPY_READ_BUFFER_BINDING									0x8f36 /**< @brief GL_ARB_copy_buffer (part of OpenGL 3.1 core) enum **/
#define GL_COPY_WRITE_BUFFER_BINDING								0x8f37 /**< @brief GL_ARB_copy_buffer (part of OpenGL 3.1 core) enum **/

/**
 *	@brief copy part of the data store of a buffer object to the data store of another buffer object
 *	@param[in] readtarget specifies the target from whose data store data should be read
 *	@param[in] writetarget specifies the target to whose data store data should be written
 *	@param[in] readoffset specifies the offset, in basic machine units, within the data store of
 *		readtarget from which data should be read
 *	@param[in] writeoffset specifies the offset, in basic machine units, within the data store of
 *		writetarget to which data should be written
 *	@param[in] size specifies the size, in basic machine units, of the data to be copied from
 *		readtarget to writetarget
 */
extern void (GLApi *GLFuncPtrName(glCopyBufferSubData))(GLenum readtarget, GLenum writetarget, GLintptr readoffset, GLintptr writeoffset, GLsizeiptr size);

/**
 *	@def glCopyBufferSubData
 *	@brief copy part of the data store of a buffer object to the data store of another buffer object
 *	@param[in] readtarget specifies the target from whose data store data should be read
 *	@param[in] writetarget specifies the target to whose data store data should be written
 *	@param[in] readoffset specifies the offset, in basic machine units, within the data store of
 *		readtarget from which data should be read
 *	@param[in] writeoffset specifies the offset, in basic machine units, within the data store of
 *		writetarget to which data should be written
 *	@param[in] size specifies the size, in basic machine units, of the data to be copied from
 *		readtarget to writetarget
 */
#define glCopyBufferSubData(readtarget,writetarget,readoffset,writeoffset,size) do { GLFuncPtrName(glCopyBufferSubData)(readtarget, writetarget, readoffset, writeoffset, size); GL_AUTOCHECK_BLOCK("glCopyBufferSubData", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_copy_buffer

//								--- ~GL_ARB_copy_buffer (part of OpenGL 3.1 core) ---

//								--- OpenGL 3.2 ---

/**
 *	@def GL_VERSION_3_2
 *	@brief if defined, OpenGL 3.2 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_3_2
#define GL_VERSION_3_2 1

/**
 *	@def __GENERATE_GL_32__
 *	@brief if defined, code to initialize OpenGL 3.2 entry points is compiled
 */
#define __GENERATE_GL_32__

extern bool GLEH_OPENGL_3_2; /**< @brief set if OpenGL 3.2 is supported */

#define GL_CONTEXT_CORE_PROFILE_BIT									0x00000001 /**< @brief OpenGL 3.2 enum */
#define GL_CONTEXT_COMPATIBILITY_PROFILE_BIT						0x00000002 /**< @brief OpenGL 3.2 enum */
#define GL_LINES_ADJACENCY											0x000A /**< @brief OpenGL 3.2 enum */
#define GL_LINE_STRIP_ADJACENCY										0x000B /**< @brief OpenGL 3.2 enum */
#define GL_TRIANGLES_ADJACENCY										0x000C /**< @brief OpenGL 3.2 enum */
#define GL_TRIANGLE_STRIP_ADJACENCY									0x000D /**< @brief OpenGL 3.2 enum */
#define GL_PROGRAM_POINT_SIZE										0x8642 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS							0x8C29 /**< @brief OpenGL 3.2 enum */
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED							0x8DA7 /**< @brief OpenGL 3.2 enum */
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS						0x8DA8 /**< @brief OpenGL 3.2 enum */
#define GL_GEOMETRY_SHADER											0x8DD9 /**< @brief OpenGL 3.2 enum */
#define GL_GEOMETRY_VERTICES_OUT									0x8916 /**< @brief OpenGL 3.2 enum */
#define GL_GEOMETRY_INPUT_TYPE										0x8917 /**< @brief OpenGL 3.2 enum */
#define GL_GEOMETRY_OUTPUT_TYPE										0x8918 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS							0x8DDF /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES								0x8DE0 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS						0x8DE1 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_VERTEX_OUTPUT_COMPONENTS								0x9122 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS							0x9123 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS							0x9124 /**< @brief OpenGL 3.2 enum */
#define GL_MAX_FRAGMENT_INPUT_COMPONENTS							0x9125 /**< @brief OpenGL 3.2 enum */
#define GL_CONTEXT_PROFILE_MASK										0x9126 /**< @brief OpenGL 3.2 enum */
/* reuse GL_MAX_VARYING_COMPONENTS (OpenGL 3.0 core) */
/* reuse GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER (GL_ARB_framebuffer_object) */
/* Reuse tokens from ARB_depth_clamp */
/* Would reuse tokens from ARB_draw_elements_base_vertex, but it has none */
/* Would reuse tokens from ARB_fragment_coord_conventions, but it has none */
/* Reuse tokens from ARB_provoking_vertex */
/* Reuse tokens from ARB_seamless_cube_map */
/* Reuse tokens from ARB_sync */
/* Reuse tokens from ARB_texture_multisample */
/* Don't need to reuse tokens from ARB_vertex_array_bgra since they're already in 1.2 core */

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetInteger64i_v))(GLenum pname, GLuint index, GLint64 *data);

/**
 *	@brief return parameters of a buffer object
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] value Specifies the symbolic name of a buffer object parameter. Accepted values are
 *		GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
 *	@param[out] data Returns the requested parameter.
 */
extern void (GLApi *GLFuncPtrName(glGetBufferParameteri64v))(GLenum target, GLenum value, GLint64 *data);

/**
 *	@brief specify a parameter for a program object
 *	@param[in] program Specifies the name of a program object whose parameter to modify.
 *	@param[in] pname Specifies the name of the parameter to modify.
 *	@param[in] value Specifies the new value of the parameter specified by pname for program.
 */
extern void (GLApi *GLFuncPtrName(glProgramParameteri))(GLuint program, GLenum pname, int value);

/**
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
 *	@param[in] attachment Specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
 *	@param[in] texture Specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment.
 *	@param[in] level Specifies the mipmap level of texture to attach.
 */
extern void (GLApi *GLFuncPtrName(glFramebufferTexture))(GLenum target, GLenum attachment, GLuint texture, int level);

/**
 *	@def glGetInteger64i_v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname Specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted.
 *	@param[in] index Specifies the index of the particular element being queried.
 *	@param[out] data Returns the value or values of the specified parameter.
 */
#define glGetInteger64i_v(pname,index,data) do { GLFuncPtrName(glGetInteger64i_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetInteger64i_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetBufferParameteri64v
 *	@brief return parameters of a buffer object
 *	@param[in] target Specifies the target buffer object. The symbolic constant must be
 *		GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER,
 *		GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER,
 *		GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
 *	@param[in] value Specifies the symbolic name of a buffer object parameter. Accepted values are
 *		GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
 *	@param[out] data Returns the requested parameter.
 */
#define glGetBufferParameteri64v(target,value,data) do { GLFuncPtrName(glGetBufferParameteri64v)(target, value, data); GL_AUTOCHECK_BLOCK("glGetBufferParameteri64v", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramParameteri
 *	@brief specify a parameter for a program object
 *	@param[in] program Specifies the name of a program object whose parameter to modify.
 *	@param[in] pname Specifies the name of the parameter to modify.
 *	@param[in] value Specifies the new value of the parameter specified by pname for program.
 */
#define glProgramParameteri(program,pname,value) do { GLFuncPtrName(glProgramParameteri)(program, pname, value); GL_AUTOCHECK_BLOCK("glProgramParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glFramebufferTexture
 *	@brief attach a level of a texture object as a logical buffer to the currently bound framebuffer object
 *	@param[in] target Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER,
 *		GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
 *	@param[in] attachment Specifies the attachment point of the framebuffer. attachment must be
 *		GL_COLOR_ATTACHMENT i, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
 *	@param[in] texture Specifies the texture object to attach to the framebuffer attachment point
 *		named by attachment.
 *	@param[in] level Specifies the mipmap level of texture to attach.
 */
#define glFramebufferTexture(target,attachment,texture,level) do { GLFuncPtrName(glFramebufferTexture)(target, attachment, texture, level); GL_AUTOCHECK_BLOCK("glFramebufferTexture", __FILE__, __LINE__); } while(0)

#endif // !GL_VERSION_3_2

//								--- ~OpenGL 3.2 ---

//								--- GL_ARB_depth_clamp (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_depth_clamp
 *	@brief if defined, GL_ARB_depth_clamp (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_depth_clamp
#define GL_ARB_depth_clamp 1

extern bool GLEH_ARB_depth_clamp; /**< @brief set if GL_ARB_depth_clamp is supported */

#define GL_DEPTH_CLAMP												0x864f /**< @brief GL_ARB_depth_clamp (part of OpenGL 3.2 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_depth_clamp

//								--- ~GL_ARB_depth_clamp (part of OpenGL 3.2 core) ---

//								--- GL_ARB_draw_elements_base_vertex (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_draw_elements_base_vertex
 *	@brief if defined, GL_ARB_draw_elements_base_vertex (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_draw_elements_base_vertex
#define GL_ARB_draw_elements_base_vertex 1

/**
 *	@def __GENERATE_GL_ARB_draw_elements_base_vertex
 *	@brief if defined, code to initialize GL_ARB_draw_elements_base_vertex (part of OpenGL 3.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_draw_elements_base_vertex

extern bool GLEH_ARB_draw_elements_base_vertex; /**< @brief set if GL_ARB_draw_elements_base_vertex is supported */

// no new tokens

/**
 *	@brief render primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsBaseVertex))(GLenum mode, GLsizei count, GLenum type, void *indices, int basevertex);

/**
 *	@brief render primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] start specifies the minimum array index contained in indices
 *	@param[in] end specifies the maximum array index contained in indices
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
extern void (GLApi *GLFuncPtrName(glDrawRangeElementsBaseVertex))(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, void *indices, int basevertex);

/**
 *	@brief render multiple instances of a set of primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the indexed geometry that should be drawn
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedBaseVertex))(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, int basevertex);

/**
 *	@brief render multiple sets of primitives by specifying indices of array data elements and an index to apply to each index
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[out] count points to an array of the elements counts
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the size of the count array
 *	@param[out] basevertex specifies a pointer to the location where the base vertices are stored
 */
extern void (GLApi *GLFuncPtrName(glMultiDrawElementsBaseVertex))(GLenum mode, GLsizei *count, GLenum type, void **indices, GLsizei primcount, int *basevertex);

/**
 *	@def glDrawElementsBaseVertex
 *	@brief render primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
#define glDrawElementsBaseVertex(mode,count,type,indices,basevertex) do { GLFuncPtrName(glDrawElementsBaseVertex)(mode, count, type, indices, basevertex); GL_AUTOCHECK_BLOCK("glDrawElementsBaseVertex", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawRangeElementsBaseVertex
 *	@brief render primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] start specifies the minimum array index contained in indices
 *	@param[in] end specifies the maximum array index contained in indices
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
#define glDrawRangeElementsBaseVertex(mode,start,end,count,type,indices,basevertex) do { GLFuncPtrName(glDrawRangeElementsBaseVertex)(mode, start, end, count, type, indices, basevertex); GL_AUTOCHECK_BLOCK("glDrawRangeElementsBaseVertex", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElementsInstancedBaseVertex
 *	@brief render multiple instances of a set of primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the indexed geometry that should be drawn
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 */
#define glDrawElementsInstancedBaseVertex(mode,count,type,indices,primcount,basevertex) do { GLFuncPtrName(glDrawElementsInstancedBaseVertex)(mode, count, type, indices, primcount, basevertex); GL_AUTOCHECK_BLOCK("glDrawElementsInstancedBaseVertex", __FILE__, __LINE__); } while(0)

/**
 *	@def glMultiDrawElementsBaseVertex
 *	@brief render multiple sets of primitives by specifying indices of array data elements and an index to apply to each index
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[out] count points to an array of the elements counts
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[out] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the size of the count array
 *	@param[out] basevertex specifies a pointer to the location where the base vertices are stored
 */
#define glMultiDrawElementsBaseVertex(mode,count,type,indices,primcount,basevertex) do { GLFuncPtrName(glMultiDrawElementsBaseVertex)(mode, count, type, indices, primcount, basevertex); GL_AUTOCHECK_BLOCK("glMultiDrawElementsBaseVertex", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_draw_elements_base_vertex

//								--- ~GL_ARB_draw_elements_base_vertex (part of OpenGL 3.2 core) ---

//								--- GL_ARB_fragment_coord_conventions (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_fragment_coord_conventions
 *	@brief if defined, GL_ARB_fragment_coord_conventions (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_fragment_coord_conventions
#define GL_ARB_fragment_coord_conventions 1

extern bool GLEH_ARB_fragment_coord_conventions; /**< @brief set if GL_ARB_fragment_coord_conventions is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_fragment_coord_conventions

//								--- ~GL_ARB_fragment_coord_conventions (part of OpenGL 3.2 core) ---

//								--- GL_ARB_provoking_vertex (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_provoking_vertex
 *	@brief if defined, GL_ARB_provoking_vertex (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_provoking_vertex
#define GL_ARB_provoking_vertex 1

/**
 *	@def __GENERATE_GL_ARB_provoking_vertex
 *	@brief if defined, code to initialize GL_ARB_provoking_vertex (part of OpenGL 3.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_provoking_vertex

extern bool GLEH_ARB_provoking_vertex; /**< @brief set if GL_ARB_provoking_vertex is supported */

#define GL_FIRST_VERTEX_CONVENTION									0x8e4d /**< @brief GL_ARB_provoking_vertex (part of OpenGL 3.2 core) enum **/
#define GL_LAST_VERTEX_CONVENTION									0x8e4e /**< @brief GL_ARB_provoking_vertex (part of OpenGL 3.2 core) enum **/
#define GL_PROVOKING_VERTEX											0x8e4f /**< @brief GL_ARB_provoking_vertex (part of OpenGL 3.2 core) enum **/
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION					0x8e4c /**< @brief GL_ARB_provoking_vertex (part of OpenGL 3.2 core) enum **/

/**
 *	@brief specifiy the vertex to be used as the source of data for flat shaded varyings
 *	@param[in] provokeMode specifies the vertex to be used as the source of data for flat shaded varyings
 */
extern void (GLApi *GLFuncPtrName(glProvokingVertex))(GLenum provokeMode);

/**
 *	@def glProvokingVertex
 *	@brief specifiy the vertex to be used as the source of data for flat shaded varyings
 *	@param[in] provokeMode specifies the vertex to be used as the source of data for flat shaded varyings
 */
#define glProvokingVertex(provokeMode) do { GLFuncPtrName(glProvokingVertex)(provokeMode); GL_AUTOCHECK_BLOCK("glProvokingVertex", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_provoking_vertex

//								--- ~GL_ARB_provoking_vertex (part of OpenGL 3.2 core) ---

//								--- GL_ARB_seamless_cube_map (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_seamless_cube_map
 *	@brief if defined, GL_ARB_seamless_cube_map (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_seamless_cube_map
#define GL_ARB_seamless_cube_map 1

extern bool GLEH_ARB_seamless_cube_map; /**< @brief set if GL_ARB_seamless_cube_map is supported */

#define GL_TEXTURE_CUBE_MAP_SEAMLESS								0x884f /**< @brief GL_ARB_seamless_cube_map (part of OpenGL 3.2 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_seamless_cube_map

//								--- ~GL_ARB_seamless_cube_map (part of OpenGL 3.2 core) ---

//								--- GL_ARB_sync (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_sync
 *	@brief if defined, GL_ARB_sync (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_sync
#define GL_ARB_sync 1

/**
 *	@def __GENERATE_GL_ARB_sync
 *	@brief if defined, code to initialize GL_ARB_sync (part of OpenGL 3.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_sync

extern bool GLEH_ARB_sync; /**< @brief set if GL_ARB_sync is supported */

#define GL_MAX_SERVER_WAIT_TIMEOUT									0x9111 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_OBJECT_TYPE												0x9112 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_CONDITION											0x9113 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_STATUS												0x9114 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_FLAGS												0x9115 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_FENCE												0x9116 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_GPU_COMMANDS_COMPLETE								0x9117 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_UNSIGNALED												0x9118 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SIGNALED													0x9119 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_SYNC_FLUSH_COMMANDS_BIT									0x00000001 /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_TIMEOUT_IGNORED											0xffffffffffffffffull /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_ALREADY_SIGNALED											0x911a /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_TIMEOUT_EXPIRED											0x911b /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_CONDITION_SATISFIED										0x911c /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/
#define GL_WAIT_FAILED												0x911d /**< @brief GL_ARB_sync (part of OpenGL 3.2 core) enum **/

/**
 *	@brief create a new sync object and insert it into the GL command stream
 *	@param[in] condition specifies the condition that must be met to set the sync object's state to
 *		signaled. condition must be GL_SYNC_GPU_COMMANDS_COMPLETE
 *	@param[in] flags specifies a bitwise combination of flags controlling the behavior of the sync
 *		object. No flags are presently defined for this operation and flags must be zero.[ 1 ]
 */
extern GLsync (GLApi *GLFuncPtrName(glFenceSync))(GLenum condition, GLbitfield flags);

/**
 *	@brief determine if a name corresponds to a sync object
 *	@param[in] sync specifies a value that may be the name of a sync object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsSync))(GLsync sync);

/**
 *	@brief delete a sync object
 *	@param[in] sync the sync object to be deleted
 */
extern void (GLApi *GLFuncPtrName(glDeleteSync))(GLsync sync);

/**
 *	@brief block and wait for a sync object to become signaled
 *	@param[in] sync the sync object whose status to wait on
 *	@param[in] flags a bitfield controlling the command flushing behavior. flags may be GL_SYNC_FLUSH_COMMANDS_BIT
 *	@param[in] timeout the timeout, specified in nanoseconds, for which the implementation should
 *		wait for sync to become signaled
 */
extern GLenum (GLApi *GLFuncPtrName(glClientWaitSync))(GLsync sync, GLbitfield flags, GLuint64 timeout);

/**
 *	@brief instruct the GL server to block until the specified sync object becomes signaled
 *	@param[in] sync specifies the sync object whose status to wait on
 *	@param[in] flags a bitfield controlling the command flushing behavior. flags may be zero
 *	@param[in] timeout specifies the timeout that the server should wait before continuing. timeout
 *		must be GL_TIMEOUT_IGNORED
 */
extern void (GLApi *GLFuncPtrName(glWaitSync))(GLsync sync, GLbitfield flags, GLuint64 timeout);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[out] params returns the value or values of the specified parameter
 */
extern void (GLApi *GLFuncPtrName(glGetInteger64v))(GLenum pname, GLint64 *params);

/**
 *	@brief query the properties of a sync object
 *	@param[in] sync specifies the sync object whose properties to query
 *	@param[in] pname specifies the parameter whose value to retrieve from the sync object specified
 *		in sync
 *	@param[in] bufSize specifies the size of the buffer whose address is given in values
 *	@param[out] length specifies the address of an variable to receive the number of integers placed
 *		in values
 *	@param[out] values specifies the address of an array to receive the values of the queried parameter
 */
extern void (GLApi *GLFuncPtrName(glGetSynciv))(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, int *values);

inline GLsync glFenceSync_glachwrap(GLenum condition, GLbitfield flags, const char *p_s_filename, int n_line) { GLsync result = GLFuncPtrName(glFenceSync)(condition,flags); GL_AUTOCHECK_BLOCK("glFenceSync", p_s_filename, n_line); return result; }
inline GLboolean glIsSync_glachwrap(GLsync sync, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsSync)(sync); GL_AUTOCHECK_BLOCK("glIsSync", p_s_filename, n_line); return result; }
inline GLenum glClientWaitSync_glachwrap(GLsync sync, GLbitfield flags, GLuint64 timeout, const char *p_s_filename, int n_line) { GLenum result = GLFuncPtrName(glClientWaitSync)(sync,flags,timeout); GL_AUTOCHECK_BLOCK("glClientWaitSync", p_s_filename, n_line); return result; }

/**
 *	@def glFenceSync
 *	@brief create a new sync object and insert it into the GL command stream
 *	@param[in] condition specifies the condition that must be met to set the sync object's state to
 *		signaled. condition must be GL_SYNC_GPU_COMMANDS_COMPLETE
 *	@param[in] flags specifies a bitwise combination of flags controlling the behavior of the sync
 *		object. No flags are presently defined for this operation and flags must be zero.[ 1 ]
 */
#define glFenceSync(condition,flags) GLAutoCheckFuncPtrName(glFenceSync)(condition, flags GLAutoCheckExtraParams)

/**
 *	@def glIsSync
 *	@brief determine if a name corresponds to a sync object
 *	@param[in] sync specifies a value that may be the name of a sync object
 */
#define glIsSync(sync) GLAutoCheckFuncPtrName(glIsSync)(sync GLAutoCheckExtraParams)

/**
 *	@def glDeleteSync
 *	@brief delete a sync object
 *	@param[in] sync the sync object to be deleted
 */
#define glDeleteSync(sync) do { GLFuncPtrName(glDeleteSync)(sync); GL_AUTOCHECK_BLOCK("glDeleteSync", __FILE__, __LINE__); } while(0)

/**
 *	@def glClientWaitSync
 *	@brief block and wait for a sync object to become signaled
 *	@param[in] sync the sync object whose status to wait on
 *	@param[in] flags a bitfield controlling the command flushing behavior. flags may be GL_SYNC_FLUSH_COMMANDS_BIT
 *	@param[in] timeout the timeout, specified in nanoseconds, for which the implementation should
 *		wait for sync to become signaled
 */
#define glClientWaitSync(sync,flags,timeout) GLAutoCheckFuncPtrName(glClientWaitSync)(sync, flags, timeout GLAutoCheckExtraParams)

/**
 *	@def glWaitSync
 *	@brief instruct the GL server to block until the specified sync object becomes signaled
 *	@param[in] sync specifies the sync object whose status to wait on
 *	@param[in] flags a bitfield controlling the command flushing behavior. flags may be zero
 *	@param[in] timeout specifies the timeout that the server should wait before continuing. timeout
 *		must be GL_TIMEOUT_IGNORED
 */
#define glWaitSync(sync,flags,timeout) do { GLFuncPtrName(glWaitSync)(sync, flags, timeout); GL_AUTOCHECK_BLOCK("glWaitSync", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetInteger64v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[out] params returns the value or values of the specified parameter
 */
#define glGetInteger64v(pname,params) do { GLFuncPtrName(glGetInteger64v)(pname, params); GL_AUTOCHECK_BLOCK("glGetInteger64v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetSynciv
 *	@brief query the properties of a sync object
 *	@param[in] sync specifies the sync object whose properties to query
 *	@param[in] pname specifies the parameter whose value to retrieve from the sync object specified
 *		in sync
 *	@param[in] bufSize specifies the size of the buffer whose address is given in values
 *	@param[out] length specifies the address of an variable to receive the number of integers placed
 *		in values
 *	@param[out] values specifies the address of an array to receive the values of the queried parameter
 */
#define glGetSynciv(sync,pname,bufSize,length,values) do { GLFuncPtrName(glGetSynciv)(sync, pname, bufSize, length, values); GL_AUTOCHECK_BLOCK("glGetSynciv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_sync

//								--- ~GL_ARB_sync (part of OpenGL 3.2 core) ---

//								--- GL_ARB_texture_multisample (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_texture_multisample
 *	@brief if defined, GL_ARB_texture_multisample (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_texture_multisample
#define GL_ARB_texture_multisample 1

/**
 *	@def __GENERATE_GL_ARB_texture_multisample
 *	@brief if defined, code to initialize GL_ARB_texture_multisample (part of OpenGL 3.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_texture_multisample

extern bool GLEH_ARB_texture_multisample; /**< @brief set if GL_ARB_texture_multisample is supported */

#define GL_SAMPLE_POSITION											0x8e50 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_SAMPLE_MASK												0x8e51 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_SAMPLE_MASK_VALUE										0x8e52 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_2D_MULTISAMPLE									0x9100 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE								0x9101 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY								0x9102 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY						0x9103 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_MAX_SAMPLE_MASK_WORDS									0x8e59 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_MAX_COLOR_TEXTURE_SAMPLES								0x910e /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_MAX_DEPTH_TEXTURE_SAMPLES								0x910f /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_MAX_INTEGER_SAMPLES										0x9110 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE							0x9104 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY						0x9105 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_SAMPLES											0x9106 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS							0x9107 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_SAMPLER_2D_MULTISAMPLE									0x9108 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_INT_SAMPLER_2D_MULTISAMPLE								0x9109 /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE						0x910a /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY								0x910b /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY							0x910c /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY				0x910d /**< @brief GL_ARB_texture_multisample (part of OpenGL 3.2 core) enum **/

/**
 *	@brief establish the data storage, format, dimensions, and number of samples of a multisample texture's image
 *	@param[in] target specifies the target of the operation. target must be
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_PROXY_TEXTURE_2D_MULTISAMPLE
 *	@param[in] samples the number of samples in the multisample texture's image
 *	@param[in] internalformat the internal format to be used to store the multisample texture's
 *		image. internalformat must specify a color-renderable, depth-renderable, or
 *		stencil-renderable format
 *	@param[in] width the width of the multisample texture's image, in texels
 *	@param[in] height the height of the multisample texture's image, in texels
 *	@param[in] fixedsamplelocations specifies whether the image will use identical sample locations
 *		and the same number of samples for all texels in the image, and the sample locations will
 *		not depend on the internal format or size of the image
 */
extern void (GLApi *GLFuncPtrName(glTexImage2DMultisample))(GLenum target, GLsizei samples, int internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);

/**
 *	@brief establish the data storage, format, dimensions, and number of samples of a multisample texture's image
 *	@param[in] target specifies the target of the operation. target must be
 *		GL_TEXTURE_2D_MULTISAMPLE_ARRAY or GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] samples the number of samples in the multisample texture's image
 *	@param[in] internalformat the internal format to be used to store the multisample texture's
 *		image. internalformat must specify a color-renderable, depth-renderable, or
 *		stencil-renderable format
 *	@param[in] width the width of the multisample texture's image, in texels
 *	@param[in] height the height of the multisample texture's image, in texels
 *	@param[in] depth the depth of the multisample texture's image, in texels
 *	@param[in] fixedsamplelocations specifies whether the image will use identical sample locations
 *		and the same number of samples for all texels in the image, and the sample locations will
 *		not depend on the internal format or size of the image
 */
extern void (GLApi *GLFuncPtrName(glTexImage3DMultisample))(GLenum target, GLsizei samples, int internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);

/**
 *	@brief retrieve the location of a sample
 *	@param[in] pname specifies the sample parameter name. pname must be GL_SAMPLE_POSITION
 *	@param[in] index specifies the index of the sample whose position to query
 *	@param[out] val specifies the address of an array to receive the position of the sample
 */
extern void (GLApi *GLFuncPtrName(glGetMultisamplefv))(GLenum pname, GLuint index, float *val);

/**
 *	@brief set the value of a sub-word of the sample mask
 *	@param[in] maskNumber specifies which 32-bit sub-word of the sample mask to update
 *	@param[in] mask specifies the new value of the mask sub-word
 */
extern void (GLApi *GLFuncPtrName(glSampleMaski))(GLuint maskNumber, GLbitfield mask);

/**
 *	@def glTexImage2DMultisample
 *	@brief establish the data storage, format, dimensions, and number of samples of a multisample texture's image
 *	@param[in] target specifies the target of the operation. target must be
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_PROXY_TEXTURE_2D_MULTISAMPLE
 *	@param[in] samples the number of samples in the multisample texture's image
 *	@param[in] internalformat the internal format to be used to store the multisample texture's
 *		image. internalformat must specify a color-renderable, depth-renderable, or
 *		stencil-renderable format
 *	@param[in] width the width of the multisample texture's image, in texels
 *	@param[in] height the height of the multisample texture's image, in texels
 *	@param[in] fixedsamplelocations specifies whether the image will use identical sample locations
 *		and the same number of samples for all texels in the image, and the sample locations will
 *		not depend on the internal format or size of the image
 */
#define glTexImage2DMultisample(target,samples,internalformat,width,height,fixedsamplelocations) do { GLFuncPtrName(glTexImage2DMultisample)(target, samples, internalformat, width, height, fixedsamplelocations); GL_AUTOCHECK_BLOCK("glTexImage2DMultisample", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexImage3DMultisample
 *	@brief establish the data storage, format, dimensions, and number of samples of a multisample texture's image
 *	@param[in] target specifies the target of the operation. target must be
 *		GL_TEXTURE_2D_MULTISAMPLE_ARRAY or GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] samples the number of samples in the multisample texture's image
 *	@param[in] internalformat the internal format to be used to store the multisample texture's
 *		image. internalformat must specify a color-renderable, depth-renderable, or
 *		stencil-renderable format
 *	@param[in] width the width of the multisample texture's image, in texels
 *	@param[in] height the height of the multisample texture's image, in texels
 *	@param[in] depth the depth of the multisample texture's image, in texels
 *	@param[in] fixedsamplelocations specifies whether the image will use identical sample locations
 *		and the same number of samples for all texels in the image, and the sample locations will
 *		not depend on the internal format or size of the image
 */
#define glTexImage3DMultisample(target,samples,internalformat,width,height,depth,fixedsamplelocations) do { GLFuncPtrName(glTexImage3DMultisample)(target, samples, internalformat, width, height, depth, fixedsamplelocations); GL_AUTOCHECK_BLOCK("glTexImage3DMultisample", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetMultisamplefv
 *	@brief retrieve the location of a sample
 *	@param[in] pname specifies the sample parameter name. pname must be GL_SAMPLE_POSITION
 *	@param[in] index specifies the index of the sample whose position to query
 *	@param[out] val specifies the address of an array to receive the position of the sample
 */
#define glGetMultisamplefv(pname,index,val) do { GLFuncPtrName(glGetMultisamplefv)(pname, index, val); GL_AUTOCHECK_BLOCK("glGetMultisamplefv", __FILE__, __LINE__); } while(0)

/**
 *	@def glSampleMaski
 *	@brief set the value of a sub-word of the sample mask
 *	@param[in] maskNumber specifies which 32-bit sub-word of the sample mask to update
 *	@param[in] mask specifies the new value of the mask sub-word
 */
#define glSampleMaski(maskNumber,mask) do { GLFuncPtrName(glSampleMaski)(maskNumber, mask); GL_AUTOCHECK_BLOCK("glSampleMaski", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_texture_multisample

//								--- ~GL_ARB_texture_multisample (part of OpenGL 3.2 core) ---

//								--- GL_ARB_vertex_array_bgra (part of OpenGL 3.2 core) ---

/**
 *	@def GL_ARB_vertex_array_bgra
 *	@brief if defined, GL_ARB_vertex_array_bgra (part of OpenGL 3.2 core) entry points are available
 */
#ifndef GL_ARB_vertex_array_bgra
#define GL_ARB_vertex_array_bgra 1

extern bool GLEH_ARB_vertex_array_bgra; /**< @brief set if GL_ARB_vertex_array_bgra is supported */

//#define GL_BGRA													  0x80e1 // (defined above)

// no new procedures or functions

#endif // !GL_ARB_vertex_array_bgra

//								--- ~GL_ARB_vertex_array_bgra (part of OpenGL 3.2 core) ---

//								--- OpenGL 3.3 ---

/**
 *	@def GL_VERSION_3_3
 *	@brief if defined, OpenGL 3.3 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_3_3
#define GL_VERSION_3_3 1

/**
 *	@def __GENERATE_GL_33__
 *	@brief if defined, code to initialize OpenGL 3.3 entry points is compiled
 */
#define __GENERATE_GL_33__

extern bool GLEH_OPENGL_3_3; /**< @brief set if OpenGL 3.3 is supported */

#endif // !GL_VERSION_3_3

//								--- ~OpenGL 3.3 ---

//								--- GL_ARB_shader_bit_encoding (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_shader_bit_encoding
 *	@brief if defined, GL_ARB_shader_bit_encoding (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_shader_bit_encoding
#define GL_ARB_shader_bit_encoding 1

extern bool GLEH_ARB_shader_bit_encoding; /**< @brief set if GL_ARB_shader_bit_encoding is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_shader_bit_encoding

//								--- ~GL_ARB_shader_bit_encoding (part of OpenGL 3.3 core) ---

//								--- GL_ARB_blend_func_extended (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_blend_func_extended
 *	@brief if defined, GL_ARB_blend_func_extended (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_blend_func_extended
#define GL_ARB_blend_func_extended 1

/**
 *	@def __GENERATE_GL_ARB_blend_func_extended
 *	@brief if defined, code to initialize GL_ARB_blend_func_extended (part of OpenGL 3.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_blend_func_extended

extern bool GLEH_ARB_blend_func_extended; /**< @brief set if GL_ARB_blend_func_extended is supported */

#define GL_SRC1_COLOR												0x88f9 /**< @brief GL_ARB_blend_func_extended (part of OpenGL 3.3 core) enum **/
#define GL_ONE_MINUS_SRC1_COLOR										0x88fa /**< @brief GL_ARB_blend_func_extended (part of OpenGL 3.3 core) enum **/
#define GL_ONE_MINUS_SRC1_ALPHA										0x88fb /**< @brief GL_ARB_blend_func_extended (part of OpenGL 3.3 core) enum **/
#define GL_MAX_DUAL_SOURCE_DRAW_BUFFERS								0x88fc /**< @brief GL_ARB_blend_func_extended (part of OpenGL 3.3 core) enum **/

/**
 *	@brief bind a user-defined varying out variable to a fragment shader color number and index
 *	@param[in] program the name of the program containing varying out variable whose binding to modify
 *	@param[in] colorNumber the color number to bind the user-defined varying out variable to
 *	@param[in] index the index of the color input to bind the user-defined varying out variable to
 *	@param[in] name the name of the user-defined varying out variable whose binding to modify
 */
extern void (GLApi *GLFuncPtrName(glBindFragDataLocationIndexed))(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);

/**
 *	@brief query the bindings of color indices to user-defined varying out variables
 *	@param[in] program the name of the program containing varying out variable whose binding to query
 *	@param[in] name the name of the user-defined varying out variable whose index to query
 */
extern int (GLApi *GLFuncPtrName(glGetFragDataIndex))(GLuint program, const GLchar *name);

inline int glGetFragDataIndex_glachwrap(GLuint program, const GLchar *name, const char *p_s_filename, int n_line) { int result = GLFuncPtrName(glGetFragDataIndex)(program,name); GL_AUTOCHECK_BLOCK("glGetFragDataIndex", p_s_filename, n_line); return result; }

/**
 *	@def glBindFragDataLocationIndexed
 *	@brief bind a user-defined varying out variable to a fragment shader color number and index
 *	@param[in] program the name of the program containing varying out variable whose binding to modify
 *	@param[in] colorNumber the color number to bind the user-defined varying out variable to
 *	@param[in] index the index of the color input to bind the user-defined varying out variable to
 *	@param[in] name the name of the user-defined varying out variable whose binding to modify
 */
#define glBindFragDataLocationIndexed(program,colorNumber,index,name) do { GLFuncPtrName(glBindFragDataLocationIndexed)(program, colorNumber, index, name); GL_AUTOCHECK_BLOCK("glBindFragDataLocationIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFragDataIndex
 *	@brief query the bindings of color indices to user-defined varying out variables
 *	@param[in] program the name of the program containing varying out variable whose binding to query
 *	@param[in] name the name of the user-defined varying out variable whose index to query
 */
#define glGetFragDataIndex(program,name) GLAutoCheckFuncPtrName(glGetFragDataIndex)(program, name GLAutoCheckExtraParams)

#endif // !GL_ARB_blend_func_extended

//								--- ~GL_ARB_blend_func_extended (part of OpenGL 3.3 core) ---

//								--- GL_ARB_explicit_attrib_location (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_explicit_attrib_location
 *	@brief if defined, GL_ARB_explicit_attrib_location (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_explicit_attrib_location
#define GL_ARB_explicit_attrib_location 1

extern bool GLEH_ARB_explicit_attrib_location; /**< @brief set if GL_ARB_explicit_attrib_location is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_explicit_attrib_location

//								--- ~GL_ARB_explicit_attrib_location (part of OpenGL 3.3 core) ---

//								--- GL_ARB_occlusion_query2 (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_occlusion_query2
 *	@brief if defined, GL_ARB_occlusion_query2 (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_occlusion_query2
#define GL_ARB_occlusion_query2 1

extern bool GLEH_ARB_occlusion_query2; /**< @brief set if GL_ARB_occlusion_query2 is supported */

#define GL_ANY_SAMPLES_PASSED										0x8c2f /**< @brief GL_ARB_occlusion_query2 (part of OpenGL 3.3 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_occlusion_query2

//								--- ~GL_ARB_occlusion_query2 (part of OpenGL 3.3 core) ---

//								--- GL_ARB_sampler_objects (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_sampler_objects
 *	@brief if defined, GL_ARB_sampler_objects (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_sampler_objects
#define GL_ARB_sampler_objects 1

/**
 *	@def __GENERATE_GL_ARB_sampler_objects
 *	@brief if defined, code to initialize GL_ARB_sampler_objects (part of OpenGL 3.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_sampler_objects

extern bool GLEH_ARB_sampler_objects; /**< @brief set if GL_ARB_sampler_objects is supported */

#define GL_SAMPLER_BINDING											0x8919 /**< @brief GL_ARB_sampler_objects (part of OpenGL 3.3 core) enum **/

/**
 *	@brief generate sampler object names
 *	@param[in] n specifies the number of sampler object names to generate
 *	@param[out] samplers specifies an array in which the generated sampler object names are stored
 */
extern void (GLApi *GLFuncPtrName(glGenSamplers))(GLsizei n, GLuint *samplers);

/**
 *	@brief delete named sampler objects
 *	@param[in] n specifies the number of sampler objects to be deleted
 *	@param[in] ids specifies an array of sampler objects to be deleted
 */
extern void (GLApi *GLFuncPtrName(glDeleteSamplers))(GLsizei n, const GLuint *ids);

/**
 *	@brief determine if a name corresponds to a sampler object
 *	@param[in] id specifies a value that may be the name of a sampler object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsSampler))(GLuint id);

/**
 *	@brief bind a named sampler to a texturing target
 *	@param[in] unit specifies the index of the texture unit to which the sampler is bound
 *	@param[in] sampler specifies the name of a sampler
 */
extern void (GLApi *GLFuncPtrName(glBindSampler))(GLuint unit, GLuint sampler);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a single-valued sampler parameter. pname can be
 *		one of the following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] param specifies the value of pname
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameteri))(GLuint sampler, GLenum pname, int param);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a single-valued sampler parameter. pname can be
 *		one of the following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] param specifies the value of pname
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameterf))(GLuint sampler, GLenum pname, float param);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameteriv))(GLuint sampler, GLenum pname, const int *params);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameterfv))(GLuint sampler, GLenum pname, const float *params);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameterIiv))(GLuint sampler, GLenum pname, const int *params);

/**
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
extern void (GLApi *GLFuncPtrName(glSamplerParameterIuiv))(GLuint sampler, GLenum pname, const GLuint *params);

/**
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
extern void (GLApi *GLFuncPtrName(glGetSamplerParameteriv))(GLuint sampler, GLenum pname, int *params);

/**
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
extern void (GLApi *GLFuncPtrName(glGetSamplerParameterfv))(GLuint sampler, GLenum pname, float *params);

/**
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
extern void (GLApi *GLFuncPtrName(glGetSamplerParameterIiv))(GLuint sampler, GLenum pname, int *params);

/**
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
extern void (GLApi *GLFuncPtrName(glGetSamplerParameterIuiv))(GLuint sampler, GLenum pname, GLuint *params);

inline GLboolean glIsSampler_glachwrap(GLuint id, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsSampler)(id); GL_AUTOCHECK_BLOCK("glIsSampler", p_s_filename, n_line); return result; }

/**
 *	@def glGenSamplers
 *	@brief generate sampler object names
 *	@param[in] n specifies the number of sampler object names to generate
 *	@param[out] samplers specifies an array in which the generated sampler object names are stored
 */
#define glGenSamplers(n,samplers) do { GLFuncPtrName(glGenSamplers)(n, samplers); GL_AUTOCHECK_BLOCK("glGenSamplers", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteSamplers
 *	@brief delete named sampler objects
 *	@param[in] n specifies the number of sampler objects to be deleted
 *	@param[in] ids specifies an array of sampler objects to be deleted
 */
#define glDeleteSamplers(n,ids) do { GLFuncPtrName(glDeleteSamplers)(n, ids); GL_AUTOCHECK_BLOCK("glDeleteSamplers", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsSampler
 *	@brief determine if a name corresponds to a sampler object
 *	@param[in] id specifies a value that may be the name of a sampler object
 */
#define glIsSampler(id) GLAutoCheckFuncPtrName(glIsSampler)(id GLAutoCheckExtraParams)

/**
 *	@def glBindSampler
 *	@brief bind a named sampler to a texturing target
 *	@param[in] unit specifies the index of the texture unit to which the sampler is bound
 *	@param[in] sampler specifies the name of a sampler
 */
#define glBindSampler(unit,sampler) do { GLFuncPtrName(glBindSampler)(unit, sampler); GL_AUTOCHECK_BLOCK("glBindSampler", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameteri
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a single-valued sampler parameter. pname can be
 *		one of the following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] param specifies the value of pname
 */
#define glSamplerParameteri(sampler,pname,param) do { GLFuncPtrName(glSamplerParameteri)(sampler, pname, param); GL_AUTOCHECK_BLOCK("glSamplerParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameterf
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a single-valued sampler parameter. pname can be
 *		one of the following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] param specifies the value of pname
 */
#define glSamplerParameterf(sampler,pname,param) do { GLFuncPtrName(glSamplerParameterf)(sampler, pname, param); GL_AUTOCHECK_BLOCK("glSamplerParameterf", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameteriv
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
#define glSamplerParameteriv(sampler,pname,params) do { GLFuncPtrName(glSamplerParameteriv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glSamplerParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameterfv
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
#define glSamplerParameterfv(sampler,pname,params) do { GLFuncPtrName(glSamplerParameterfv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glSamplerParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameterIiv
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
#define glSamplerParameterIiv(sampler,pname,params) do { GLFuncPtrName(glSamplerParameterIiv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glSamplerParameterIiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glSamplerParameterIuiv
 *	@brief set sampler parameters
 *	@param[in] sampler specifies the sampler object whose parameter to modify
 *	@param[in] pname specifies the symbolic name of a sampler parameter. pname can be one of the
 *		following: GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_MIN_FILTER,
 *		GL_TEXTURE_MAG_FILTER, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD,
 *		GL_TEXTURE_LOD_BIAS GL_TEXTURE_COMPARE_MODE, or GL_TEXTURE_COMPARE_FUNC
 *	@param[in] params specifies a pointer to an array where the value or values of pname are stored
 */
#define glSamplerParameterIuiv(sampler,pname,params) do { GLFuncPtrName(glSamplerParameterIuiv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glSamplerParameterIuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetSamplerParameteriv
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
#define glGetSamplerParameteriv(sampler,pname,params) do { GLFuncPtrName(glGetSamplerParameteriv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glGetSamplerParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetSamplerParameterfv
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
#define glGetSamplerParameterfv(sampler,pname,params) do { GLFuncPtrName(glGetSamplerParameterfv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glGetSamplerParameterfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetSamplerParameterIiv
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
#define glGetSamplerParameterIiv(sampler,pname,params) do { GLFuncPtrName(glGetSamplerParameterIiv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glGetSamplerParameterIiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetSamplerParameterIuiv
 *	@brief return sampler parameter values
 *	@param[in] sampler specifies name of the sampler object from which to retrieve parameters
 *	@param[in] pname specifies the symbolic name of a sampler parameter. GL_TEXTURE_MAG_FILTER,
 *		GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_LOD_BIAS,
 *		GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR,
 *		GL_TEXTURE_COMPARE_MODE, and GL_TEXTURE_COMPARE_FUNC are accepted
 *	@param[out] params returns the sampler parameters
 */
#define glGetSamplerParameterIuiv(sampler,pname,params) do { GLFuncPtrName(glGetSamplerParameterIuiv)(sampler, pname, params); GL_AUTOCHECK_BLOCK("glGetSamplerParameterIuiv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_sampler_objects

//								--- ~GL_ARB_sampler_objects (part of OpenGL 3.3 core) ---

//								--- GL_ARB_texture_rgb10_a2ui (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_texture_rgb10_a2ui
 *	@brief if defined, GL_ARB_texture_rgb10_a2ui (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_texture_rgb10_a2ui
#define GL_ARB_texture_rgb10_a2ui 1

extern bool GLEH_ARB_texture_rgb10_a2ui; /**< @brief set if GL_ARB_texture_rgb10_a2ui is supported */

#define GL_RGB10_A2UI												0x906f /**< @brief GL_ARB_texture_rgb10_a2ui (part of OpenGL 3.3 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_rgb10_a2ui

//								--- ~GL_ARB_texture_rgb10_a2ui (part of OpenGL 3.3 core) ---

//								--- GL_ARB_texture_swizzle (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_texture_swizzle
 *	@brief if defined, GL_ARB_texture_swizzle (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_texture_swizzle
#define GL_ARB_texture_swizzle 1

extern bool GLEH_ARB_texture_swizzle; /**< @brief set if GL_ARB_texture_swizzle is supported */

#define GL_TEXTURE_SWIZZLE_R										0x8e42 /**< @brief GL_ARB_texture_swizzle (part of OpenGL 3.3 core) enum **/
#define GL_TEXTURE_SWIZZLE_G										0x8e43 /**< @brief GL_ARB_texture_swizzle (part of OpenGL 3.3 core) enum **/
#define GL_TEXTURE_SWIZZLE_B										0x8e44 /**< @brief GL_ARB_texture_swizzle (part of OpenGL 3.3 core) enum **/
#define GL_TEXTURE_SWIZZLE_A										0x8e45 /**< @brief GL_ARB_texture_swizzle (part of OpenGL 3.3 core) enum **/
#define GL_TEXTURE_SWIZZLE_RGBA										0x8e46 /**< @brief GL_ARB_texture_swizzle (part of OpenGL 3.3 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_swizzle

//								--- ~GL_ARB_texture_swizzle (part of OpenGL 3.3 core) ---

//								--- GL_ARB_timer_query (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_timer_query
 *	@brief if defined, GL_ARB_timer_query (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_timer_query
#define GL_ARB_timer_query 1

/**
 *	@def __GENERATE_GL_ARB_timer_query
 *	@brief if defined, code to initialize GL_ARB_timer_query (part of OpenGL 3.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_timer_query

extern bool GLEH_ARB_timer_query; /**< @brief set if GL_ARB_timer_query is supported */

#define GL_TIME_ELAPSED												0x88bf /**< @brief GL_ARB_timer_query (part of OpenGL 3.3 core) enum **/
#define GL_TIMESTAMP												0x8e28 /**< @brief GL_ARB_timer_query (part of OpenGL 3.3 core) enum **/

/**
 *	@brief record the GL time into a query object after all previous commands have reached the GL server but have not yet necessarily executed
 *	@param[in] id specify the name of a query object into which to record the GL time
 *	@param[in] target specify the counter to query. target must be GL_TIMESTAMP
 */
extern void (GLApi *GLFuncPtrName(glQueryCounter))(GLuint id, GLenum target);

/**
 *	@brief return parameters of a query object
 *	@param[in] id specifies the name of a query object
 *	@param[in] pname specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE
 *	@param[out] params returns the requested data
 */
extern void (GLApi *GLFuncPtrName(glGetQueryObjecti64v))(GLuint id, GLenum pname, GLint64 *params);

/**
 *	@brief return parameters of a query object
 *	@param[in] id specifies the name of a query object
 *	@param[in] pname specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE
 *	@param[out] params returns the requested data
 */
extern void (GLApi *GLFuncPtrName(glGetQueryObjectui64v))(GLuint id, GLenum pname, GLuint64 *params);

/**
 *	@def glQueryCounter
 *	@brief record the GL time into a query object after all previous commands have reached the GL server but have not yet necessarily executed
 *	@param[in] id specify the name of a query object into which to record the GL time
 *	@param[in] target specify the counter to query. target must be GL_TIMESTAMP
 */
#define glQueryCounter(id,target) do { GLFuncPtrName(glQueryCounter)(id, target); GL_AUTOCHECK_BLOCK("glQueryCounter", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryObjecti64v
 *	@brief return parameters of a query object
 *	@param[in] id specifies the name of a query object
 *	@param[in] pname specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE
 *	@param[out] params returns the requested data
 */
#define glGetQueryObjecti64v(id,pname,params) do { GLFuncPtrName(glGetQueryObjecti64v)(id, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryObjecti64v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryObjectui64v
 *	@brief return parameters of a query object
 *	@param[in] id specifies the name of a query object
 *	@param[in] pname specifies the symbolic name of a query object parameter. Accepted values are
 *		GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE
 *	@param[out] params returns the requested data
 */
#define glGetQueryObjectui64v(id,pname,params) do { GLFuncPtrName(glGetQueryObjectui64v)(id, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryObjectui64v", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_timer_query

//								--- ~GL_ARB_timer_query (part of OpenGL 3.3 core) ---

//								--- GL_ARB_instanced_arrays (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_instanced_arrays
 *	@brief if defined, GL_ARB_instanced_arrays (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_instanced_arrays
#define GL_ARB_instanced_arrays 1

/**
 *	@def __GENERATE_GL_ARB_instanced_arrays
 *	@brief if defined, code to initialize GL_ARB_instanced_arrays (part of OpenGL 3.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_instanced_arrays

extern bool GLEH_ARB_instanced_arrays; /**< @brief set if GL_ARB_instanced_arrays is supported */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR								0x88fe /**< @brief GL_ARB_instanced_arrays (part of OpenGL 3.3 core) enum **/

/**
 *	@brief modify the rate at which generic vertex attributes advance during instanced rendering
 *	@param[in] index specify the index of the generic vertex attribute
 *	@param[in] divisor specify the number of instances that will pass between updates of the generic
 *		attribute at slot index
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribDivisor))(GLuint index, GLuint divisor);

/**
 *	@def glVertexAttribDivisor
 *	@brief modify the rate at which generic vertex attributes advance during instanced rendering
 *	@param[in] index specify the index of the generic vertex attribute
 *	@param[in] divisor specify the number of instances that will pass between updates of the generic
 *		attribute at slot index
 */
#define glVertexAttribDivisor(index,divisor) do { GLFuncPtrName(glVertexAttribDivisor)(index, divisor); GL_AUTOCHECK_BLOCK("glVertexAttribDivisor", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_instanced_arrays

//								--- ~GL_ARB_instanced_arrays (part of OpenGL 3.3 core) ---

//								--- GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) ---

/**
 *	@def GL_ARB_vertex_type_2_10_10_10_rev
 *	@brief if defined, GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) entry points are available
 */
#ifndef GL_ARB_vertex_type_2_10_10_10_rev
#define GL_ARB_vertex_type_2_10_10_10_rev 1

/**
 *	@def __GENERATE_GL_ARB_vertex_type_2_10_10_10_rev
 *	@brief if defined, code to initialize GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_vertex_type_2_10_10_10_rev

extern bool GLEH_ARB_vertex_type_2_10_10_10_rev; /**< @brief set if GL_ARB_vertex_type_2_10_10_10_rev is supported */

#define GL_UNSIGNED_INT_2_10_10_10_REV								0x8368 /**< @brief GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) enum (existing core enum) **/
#define GL_INT_2_10_10_10_REV										0x8d9f /**< @brief GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) enum **/

//extern void (GLApi *GLFuncPtrName(glVertexP2ui))(GLenum type, GLuint value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glVertexP3ui))(GLenum type, GLuint value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glVertexP4ui))(GLenum type, GLuint value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glVertexP2uiv))(GLenum type, const GLuint *value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glVertexP3uiv))(GLenum type, const GLuint *value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glVertexP4uiv))(GLenum type, const GLuint *value); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP1ui))(GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP2ui))(GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP3ui))(GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP4ui))(GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP1uiv))(GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP2uiv))(GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP3uiv))(GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glTexCoordP4uiv))(GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP1ui))(GLenum texture, GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP2ui))(GLenum texture, GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP3ui))(GLenum texture, GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP4ui))(GLenum texture, GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP1uiv))(GLenum texture, GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP2uiv))(GLenum texture, GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP3uiv))(GLenum texture, GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glMultiTexCoordP4uiv))(GLenum texture, GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glNormalP3ui))(GLenum type, GLuint coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glNormalP3uiv))(GLenum type, const GLuint *coords); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glColorP3ui))(GLenum type, GLuint color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glColorP4ui))(GLenum type, GLuint color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glColorP3uiv))(GLenum type, const GLuint *color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glColorP4uiv))(GLenum type, const GLuint *color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glSecondaryColorP3ui))(GLenum type, GLuint color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)
//extern void (GLApi *GLFuncPtrName(glSecondaryColorP3uiv))(GLenum type, const GLuint *color); // deprecated as of OpenGL 3.0 (fixed-function vertex processing)

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP1ui))(GLuint index, GLenum type, GLboolean normalized, GLuint value);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP2ui))(GLuint index, GLenum type, GLboolean normalized, GLuint value);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP3ui))(GLuint index, GLenum type, GLboolean normalized, GLuint value);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP4ui))(GLuint index, GLenum type, GLboolean normalized, GLuint value);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP1uiv))(GLuint index, GLenum type, GLboolean normalized, const GLuint *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP2uiv))(GLuint index, GLenum type, GLboolean normalized, const GLuint *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP3uiv))(GLuint index, GLenum type, GLboolean normalized, const GLuint *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribP4uiv))(GLuint index, GLenum type, GLboolean normalized, const GLuint *v);

//#define glVertexP2ui(type,value) do { GLFuncPtrName(glVertexP2ui)(type, value); GL_AUTOCHECK_BLOCK("glVertexP2ui", __FILE__, __LINE__); } while(0)
//#define glVertexP3ui(type,value) do { GLFuncPtrName(glVertexP3ui)(type, value); GL_AUTOCHECK_BLOCK("glVertexP3ui", __FILE__, __LINE__); } while(0)
//#define glVertexP4ui(type,value) do { GLFuncPtrName(glVertexP4ui)(type, value); GL_AUTOCHECK_BLOCK("glVertexP4ui", __FILE__, __LINE__); } while(0)
//#define glVertexP2uiv(type,value) do { GLFuncPtrName(glVertexP2uiv)(type, value); GL_AUTOCHECK_BLOCK("glVertexP2uiv", __FILE__, __LINE__); } while(0)
//#define glVertexP3uiv(type,value) do { GLFuncPtrName(glVertexP3uiv)(type, value); GL_AUTOCHECK_BLOCK("glVertexP3uiv", __FILE__, __LINE__); } while(0)
//#define glVertexP4uiv(type,value) do { GLFuncPtrName(glVertexP4uiv)(type, value); GL_AUTOCHECK_BLOCK("glVertexP4uiv", __FILE__, __LINE__); } while(0)
//#define glTexCoordP1ui(type,coords) do { GLFuncPtrName(glTexCoordP1ui)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP1ui", __FILE__, __LINE__); } while(0)
//#define glTexCoordP2ui(type,coords) do { GLFuncPtrName(glTexCoordP2ui)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP2ui", __FILE__, __LINE__); } while(0)
//#define glTexCoordP3ui(type,coords) do { GLFuncPtrName(glTexCoordP3ui)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP3ui", __FILE__, __LINE__); } while(0)
//#define glTexCoordP4ui(type,coords) do { GLFuncPtrName(glTexCoordP4ui)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP4ui", __FILE__, __LINE__); } while(0)
//#define glTexCoordP1uiv(type,coords) do { GLFuncPtrName(glTexCoordP1uiv)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP1uiv", __FILE__, __LINE__); } while(0)
//#define glTexCoordP2uiv(type,coords) do { GLFuncPtrName(glTexCoordP2uiv)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP2uiv", __FILE__, __LINE__); } while(0)
//#define glTexCoordP3uiv(type,coords) do { GLFuncPtrName(glTexCoordP3uiv)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP3uiv", __FILE__, __LINE__); } while(0)
//#define glTexCoordP4uiv(type,coords) do { GLFuncPtrName(glTexCoordP4uiv)(type, coords); GL_AUTOCHECK_BLOCK("glTexCoordP4uiv", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP1ui(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP1ui)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP1ui", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP2ui(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP2ui)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP2ui", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP3ui(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP3ui)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP3ui", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP4ui(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP4ui)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP4ui", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP1uiv(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP1uiv)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP1uiv", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP2uiv(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP2uiv)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP2uiv", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP3uiv(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP3uiv)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP3uiv", __FILE__, __LINE__); } while(0)
//#define glMultiTexCoordP4uiv(texture,type,coords) do { GLFuncPtrName(glMultiTexCoordP4uiv)(texture, type, coords); GL_AUTOCHECK_BLOCK("glMultiTexCoordP4uiv", __FILE__, __LINE__); } while(0)
//#define glNormalP3ui(type,coords) do { GLFuncPtrName(glNormalP3ui)(type, coords); GL_AUTOCHECK_BLOCK("glNormalP3ui", __FILE__, __LINE__); } while(0)
//#define glNormalP3uiv(type,coords) do { GLFuncPtrName(glNormalP3uiv)(type, coords); GL_AUTOCHECK_BLOCK("glNormalP3uiv", __FILE__, __LINE__); } while(0)
//#define glColorP3ui(type,color) do { GLFuncPtrName(glColorP3ui)(type, color); GL_AUTOCHECK_BLOCK("glColorP3ui", __FILE__, __LINE__); } while(0)
//#define glColorP4ui(type,color) do { GLFuncPtrName(glColorP4ui)(type, color); GL_AUTOCHECK_BLOCK("glColorP4ui", __FILE__, __LINE__); } while(0)
//#define glColorP3uiv(type,color) do { GLFuncPtrName(glColorP3uiv)(type, color); GL_AUTOCHECK_BLOCK("glColorP3uiv", __FILE__, __LINE__); } while(0)
//#define glColorP4uiv(type,color) do { GLFuncPtrName(glColorP4uiv)(type, color); GL_AUTOCHECK_BLOCK("glColorP4uiv", __FILE__, __LINE__); } while(0)
//#define glSecondaryColorP3ui(type,color) do { GLFuncPtrName(glSecondaryColorP3ui)(type, color); GL_AUTOCHECK_BLOCK("glSecondaryColorP3ui", __FILE__, __LINE__); } while(0)
//#define glSecondaryColorP3uiv(type,color) do { GLFuncPtrName(glSecondaryColorP3uiv)(type, color); GL_AUTOCHECK_BLOCK("glSecondaryColorP3uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP1ui
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
#define glVertexAttribP1ui(index,type,normalized,value) do { GLFuncPtrName(glVertexAttribP1ui)(index, type, normalized, value); GL_AUTOCHECK_BLOCK("glVertexAttribP1ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP2ui
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
#define glVertexAttribP2ui(index,type,normalized,value) do { GLFuncPtrName(glVertexAttribP2ui)(index, type, normalized, value); GL_AUTOCHECK_BLOCK("glVertexAttribP2ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP3ui
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
#define glVertexAttribP3ui(index,type,normalized,value) do { GLFuncPtrName(glVertexAttribP3ui)(index, type, normalized, value); GL_AUTOCHECK_BLOCK("glVertexAttribP3ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP4ui
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] value specifies the new packed value to be used for the specified vertex attribute
 */
#define glVertexAttribP4ui(index,type,normalized,value) do { GLFuncPtrName(glVertexAttribP4ui)(index, type, normalized, value); GL_AUTOCHECK_BLOCK("glVertexAttribP4ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP1uiv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribP1uiv(index,type,normalized,v) do { GLFuncPtrName(glVertexAttribP1uiv)(index, type, normalized, v); GL_AUTOCHECK_BLOCK("glVertexAttribP1uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP2uiv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribP2uiv(index,type,normalized,v) do { GLFuncPtrName(glVertexAttribP2uiv)(index, type, normalized, v); GL_AUTOCHECK_BLOCK("glVertexAttribP2uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP3uiv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribP3uiv(index,type,normalized,v) do { GLFuncPtrName(glVertexAttribP3uiv)(index, type, normalized, v); GL_AUTOCHECK_BLOCK("glVertexAttribP3uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribP4uiv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] type type of packing used on the data. This parameter must be GL_INT_10_10_10_2 or
 *		GL_UNSIGNED_INT_10_10_10_2 to specify signed or unsigned data, respectively
 *	@param[in] normalized if GL_TRUE, then the values are to be converted to floating point values
 *		by normalizing. Otherwise, they are converted directly to floating point values
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribP4uiv(index,type,normalized,v) do { GLFuncPtrName(glVertexAttribP4uiv)(index, type, normalized, v); GL_AUTOCHECK_BLOCK("glVertexAttribP4uiv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_vertex_type_2_10_10_10_rev

//								--- ~GL_ARB_vertex_type_2_10_10_10_rev (part of OpenGL 3.3 core) ---

//								--- OpenGL 4.0 ---

/**
 *	@def GL_VERSION_4_0
 *	@brief if defined, OpenGL 4.0 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_4_0
#define GL_VERSION_4_0 1

/**
 *	@def __GENERATE_GL_40__
 *	@brief if defined, code to initialize OpenGL 4.0 entry points is compiled
 */
#define __GENERATE_GL_40__

extern bool GLEH_OPENGL_4_0; /**< @brief set if OpenGL 4.0 is supported */

#endif // !GL_VERSION_4_0

//								--- ~OpenGL 4.0 ---

//								--- GL_ARB_texture_query_lod (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_texture_query_lod
 *	@brief if defined, GL_ARB_texture_query_lod (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_texture_query_lod
#define GL_ARB_texture_query_lod 1

extern bool GLEH_ARB_texture_query_lod; /**< @brief set if GL_ARB_texture_query_lod is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_texture_query_lod

//								--- ~GL_ARB_texture_query_lod (part of OpenGL 4.0 core) ---

//								--- GL_ARB_draw_buffers_blend (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_draw_buffers_blend
 *	@brief if defined, GL_ARB_draw_buffers_blend (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_draw_buffers_blend
#define GL_ARB_draw_buffers_blend 1

/**
 *	@def __GENERATE_GL_ARB_draw_buffers_blend
 *	@brief if defined, code to initialize GL_ARB_draw_buffers_blend (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_draw_buffers_blend

extern bool GLEH_ARB_draw_buffers_blend; /**< @brief set if GL_ARB_draw_buffers_blend is supported */

// no new tokens

/**
 *	@brief specify the equation used for both the RGB blend equation and the Alpha blend equation
 *	@param[in] buf for glBlendEquationi, specifies the index of the draw buffer for which to set the
 *		blend equation
 *	@param[in] mode specifies how source and destination colors are combined. It must be
 *		GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 */
extern void (GLApi *GLFuncPtrName(glBlendEquationi))(GLuint buf, GLenum mode);

/**
 *	@brief set the RGB blend equation and the alpha blend equation separately
 *	@param[in] buf for glBlendEquationSeparatei, specifies the index of the draw buffer for which to
 *		set the blend equations
 *	@param[in] modeRGB specifies the RGB blend equation, how the red, green, and blue components of
 *		the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 *	@param[in] modeAlpha specifies the alpha blend equation, how the alpha component of the source
 *		and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 */
extern void (GLApi *GLFuncPtrName(glBlendEquationSeparatei))(GLuint buf, GLenum modeRGB, GLenum modeAlpha);

/**
 *	@brief specify pixel arithmetic
 *	@param[in] buf for glBlendFunci, specifies the index of the draw buffer for which to set the
 *		blend function
 *	@param[in] sfactor specifies how the red, green, blue, and alpha source blending factors are
 *		computed. The initial value is GL_ONE
 *	@param[in] dfactor specifies how the red, green, blue, and alpha destination blending factors
 *		are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR,
 *		GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA,
 *		GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR,
 *		GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial
 *		value is GL_ZERO
 */
extern void (GLApi *GLFuncPtrName(glBlendFunci))(GLuint buf, GLenum sfactor, GLenum dfactor);

/**
 *	@brief specify pixel arithmetic for RGB and alpha components separately
 *	@param[in] buf for glBlendFuncSeparatei, specifies the index of the draw buffer for which to set
 *		the blend functions
 *	@param[in] srcRGB specifies how the red, green, and blue blending factors are computed. The
 *		initial value is GL_ONE
 *	@param[in] dstRGB specifies how the red, green, and blue destination blending factors are
 *		computed. The initial value is GL_ZERO
 *	@param[in] srcAlpha specified how the alpha source blending factor is computed. The initial
 *		value is GL_ONE
 *	@param[in] dstAlpha specified how the alpha destination blending factor is computed. The initial
 *		value is GL_ZERO
 */
extern void (GLApi *GLFuncPtrName(glBlendFuncSeparatei))(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

/**
 *	@def glBlendEquationi
 *	@brief specify the equation used for both the RGB blend equation and the Alpha blend equation
 *	@param[in] buf for glBlendEquationi, specifies the index of the draw buffer for which to set the
 *		blend equation
 *	@param[in] mode specifies how source and destination colors are combined. It must be
 *		GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 */
#define glBlendEquationi(buf,mode) do { GLFuncPtrName(glBlendEquationi)(buf, mode); GL_AUTOCHECK_BLOCK("glBlendEquationi", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlendEquationSeparatei
 *	@brief set the RGB blend equation and the alpha blend equation separately
 *	@param[in] buf for glBlendEquationSeparatei, specifies the index of the draw buffer for which to
 *		set the blend equations
 *	@param[in] modeRGB specifies the RGB blend equation, how the red, green, and blue components of
 *		the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 *	@param[in] modeAlpha specifies the alpha blend equation, how the alpha component of the source
 *		and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT,
 *		GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX
 */
#define glBlendEquationSeparatei(buf,modeRGB,modeAlpha) do { GLFuncPtrName(glBlendEquationSeparatei)(buf, modeRGB, modeAlpha); GL_AUTOCHECK_BLOCK("glBlendEquationSeparatei", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlendFunci
 *	@brief specify pixel arithmetic
 *	@param[in] buf for glBlendFunci, specifies the index of the draw buffer for which to set the
 *		blend function
 *	@param[in] sfactor specifies how the red, green, blue, and alpha source blending factors are
 *		computed. The initial value is GL_ONE
 *	@param[in] dfactor specifies how the red, green, blue, and alpha destination blending factors
 *		are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR,
 *		GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA,
 *		GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR,
 *		GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial
 *		value is GL_ZERO
 */
#define glBlendFunci(buf,sfactor,dfactor) do { GLFuncPtrName(glBlendFunci)(buf, sfactor, dfactor); GL_AUTOCHECK_BLOCK("glBlendFunci", __FILE__, __LINE__); } while(0)

/**
 *	@def glBlendFuncSeparatei
 *	@brief specify pixel arithmetic for RGB and alpha components separately
 *	@param[in] buf for glBlendFuncSeparatei, specifies the index of the draw buffer for which to set
 *		the blend functions
 *	@param[in] srcRGB specifies how the red, green, and blue blending factors are computed. The
 *		initial value is GL_ONE
 *	@param[in] dstRGB specifies how the red, green, and blue destination blending factors are
 *		computed. The initial value is GL_ZERO
 *	@param[in] srcAlpha specified how the alpha source blending factor is computed. The initial
 *		value is GL_ONE
 *	@param[in] dstAlpha specified how the alpha destination blending factor is computed. The initial
 *		value is GL_ZERO
 */
#define glBlendFuncSeparatei(buf,srcRGB,dstRGB,srcAlpha,dstAlpha) do { GLFuncPtrName(glBlendFuncSeparatei)(buf, srcRGB, dstRGB, srcAlpha, dstAlpha); GL_AUTOCHECK_BLOCK("glBlendFuncSeparatei", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_draw_buffers_blend

//								--- ~GL_ARB_draw_buffers_blend (part of OpenGL 4.0 core) ---

//								--- GL_ARB_draw_indirect (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_draw_indirect
 *	@brief if defined, GL_ARB_draw_indirect (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_draw_indirect
#define GL_ARB_draw_indirect 1

/**
 *	@def __GENERATE_GL_ARB_draw_indirect
 *	@brief if defined, code to initialize GL_ARB_draw_indirect (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_draw_indirect

extern bool GLEH_ARB_draw_indirect; /**< @brief set if GL_ARB_draw_indirect is supported */

#define GL_DRAW_INDIRECT_BUFFER										0x8f3f /**< @brief GL_ARB_draw_indirect (part of OpenGL 4.0 core) enum **/
#define GL_DRAW_INDIRECT_BUFFER_BINDING								0x8f43 /**< @brief GL_ARB_draw_indirect (part of OpenGL 4.0 core) enum **/

/**
 *	@brief render primitives from array data, taking parameters from memory
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] indirect specifies the address of a structure containing the draw parameters
 */
extern void (GLApi *GLFuncPtrName(glDrawArraysIndirect))(GLenum mode, const void *indirect);

/**
 *	@brief render indexed primitives from array data, taking parameters from memory
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] type specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding
 *	@param[in] indirect specifies the address of a structure containing the draw parameters
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsIndirect))(GLenum mode, GLenum type, const void *indirect);

/**
 *	@def glDrawArraysIndirect
 *	@brief render primitives from array data, taking parameters from memory
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] indirect specifies the address of a structure containing the draw parameters
 */
#define glDrawArraysIndirect(mode,indirect) do { GLFuncPtrName(glDrawArraysIndirect)(mode, indirect); GL_AUTOCHECK_BLOCK("glDrawArraysIndirect", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElementsIndirect
 *	@brief render indexed primitives from array data, taking parameters from memory
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] type specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding
 *	@param[in] indirect specifies the address of a structure containing the draw parameters
 */
#define glDrawElementsIndirect(mode,type,indirect) do { GLFuncPtrName(glDrawElementsIndirect)(mode, type, indirect); GL_AUTOCHECK_BLOCK("glDrawElementsIndirect", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_draw_indirect

//								--- ~GL_ARB_draw_indirect (part of OpenGL 4.0 core) ---

//								--- GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_gpu_shader5
 *	@brief if defined, GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_gpu_shader5
#define GL_ARB_gpu_shader5 1

extern bool GLEH_ARB_gpu_shader5; /**< @brief set if GL_ARB_gpu_shader5 is supported */

#define GL_GEOMETRY_SHADER_INVOCATIONS								0x887f /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/
#define GL_MAX_GEOMETRY_SHADER_INVOCATIONS							0x8e5a /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/
#define GL_MIN_FRAGMENT_INTERPOLATION_OFFSET						0x8e5b /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/
#define GL_MAX_FRAGMENT_INTERPOLATION_OFFSET						0x8e5c /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/
#define GL_FRAGMENT_INTERPOLATION_OFFSET_BITS						0x8e5d /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/
#define GL_MAX_VERTEX_STREAMS										0x8e71 /**< @brief GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_gpu_shader5

//								--- ~GL_ARB_gpu_shader5 (part of OpenGL 4.0 core) ---

//								--- GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_gpu_shader_fp64
 *	@brief if defined, GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_gpu_shader_fp64
#define GL_ARB_gpu_shader_fp64 1

/**
 *	@def __GENERATE_GL_ARB_gpu_shader_fp64
 *	@brief if defined, code to initialize GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_gpu_shader_fp64

extern bool GLEH_ARB_gpu_shader_fp64; /**< @brief set if GL_ARB_gpu_shader_fp64 is supported */

#define GL_DOUBLE_VEC2												0x8ffc /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_VEC3												0x8ffd /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_VEC4												0x8ffe /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT2												0x8f46 /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT3												0x8f47 /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT4												0x8f48 /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT2x3											0x8f49 /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT2x4											0x8f4a /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT3x2											0x8f4b /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT3x4											0x8f4c /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT4x2											0x8f4d /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/
#define GL_DOUBLE_MAT4x3											0x8f4e /**< @brief GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) enum **/

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform1d))(int location, double v0);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform2d))(int location, double v0, double v1);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform3d))(int location, double v0, double v1, double v2);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform4d))(int location, double v0, double v1, double v2, double v3);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform1dv))(int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform2dv))(int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform3dv))(int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniform4dv))(int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2x3dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix2x4dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x2dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x4dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x2dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x3dv))(int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief returns the value of a uniform variable
 *	@param[in] program specifies the program object to be queried
 *	@param[in] location specifies the location of the uniform variable to be queried
 *	@param[out] params returns the value of the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glGetUniformdv))(GLuint program, int location, double *params);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1d))(GLuint program, int location, double v0);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2d))(GLuint program, int location, double v0, double v1);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3d))(GLuint program, int location, double v0, double v1, double v2);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4d))(GLuint program, int location, double v0, double v1, double v2, double v3);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1dv))(GLuint program, int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2dv))(GLuint program, int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3dv))(GLuint program, int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4dv))(GLuint program, int location, GLsizei count, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value);

/**
 *	@def glUniform1d
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
#define glUniform1d(location,v0) do { GLFuncPtrName(glUniform1d)(location, v0); GL_AUTOCHECK_BLOCK("glUniform1d", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2d
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
#define glUniform2d(location,v0,v1) do { GLFuncPtrName(glUniform2d)(location, v0, v1); GL_AUTOCHECK_BLOCK("glUniform2d", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3d
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
#define glUniform3d(location,v0,v1,v2) do { GLFuncPtrName(glUniform3d)(location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glUniform3d", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4d
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
#define glUniform4d(location,v0,v1,v2,v3) do { GLFuncPtrName(glUniform4d)(location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glUniform4d", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform1dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniform1dv(location,count,value) do { GLFuncPtrName(glUniform1dv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform1dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform2dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniform2dv(location,count,value) do { GLFuncPtrName(glUniform2dv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform3dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniform3dv(location,count,value) do { GLFuncPtrName(glUniform3dv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniform4dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniform4dv(location,count,value) do { GLFuncPtrName(glUniform4dv)(location, count, value); GL_AUTOCHECK_BLOCK("glUniform4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix2dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix2dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix3dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix4dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix2x3dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix2x3dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2x3dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2x3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix2x4dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix2x4dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix2x4dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix2x4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3x2dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix3x2dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3x2dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3x2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix3x4dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix3x4dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix3x4dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix3x4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4x2dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix4x2dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4x2dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4x2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformMatrix4x3dv
 *	@brief specify the value of a uniform variable for the current program object
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glUniformMatrix4x3dv(location,count,transpose,value) do { GLFuncPtrName(glUniformMatrix4x3dv)(location, count, transpose, value); GL_AUTOCHECK_BLOCK("glUniformMatrix4x3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformdv
 *	@brief returns the value of a uniform variable
 *	@param[in] program specifies the program object to be queried
 *	@param[in] location specifies the location of the uniform variable to be queried
 *	@param[out] params returns the value of the specified uniform variable
 */
#define glGetUniformdv(program,location,params) do { GLFuncPtrName(glGetUniformdv)(program, location, params); GL_AUTOCHECK_BLOCK("glGetUniformdv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1d
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform1d(program,location,v0) do { GLFuncPtrName(glProgramUniform1d)(program, location, v0); GL_AUTOCHECK_BLOCK("glProgramUniform1d", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2d
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform2d(program,location,v0,v1) do { GLFuncPtrName(glProgramUniform2d)(program, location, v0, v1); GL_AUTOCHECK_BLOCK("glProgramUniform2d", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3d
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform3d(program,location,v0,v1,v2) do { GLFuncPtrName(glProgramUniform3d)(program, location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glProgramUniform3d", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4d
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform4d(program,location,v0,v1,v2,v3) do { GLFuncPtrName(glProgramUniform4d)(program, location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glProgramUniform4d", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform1dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform1dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform1dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform2dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform2dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform3dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform3dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform4dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform4dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2x3dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2x3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2x4dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2x4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3x2dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3x2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3x4dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3x4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4x2dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4x2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4x3dv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4x3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x3dv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_gpu_shader_fp64

//								--- ~GL_ARB_gpu_shader_fp64 (part of OpenGL 4.0 core) ---

//								--- GL_ARB_sample_shading (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_sample_shading
 *	@brief if defined, GL_ARB_sample_shading (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_sample_shading
#define GL_ARB_sample_shading 1

/**
 *	@def __GENERATE_GL_ARB_sample_shading
 *	@brief if defined, code to initialize GL_ARB_sample_shading (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_sample_shading

extern bool GLEH_ARB_sample_shading; /**< @brief set if GL_ARB_sample_shading is supported */

#define GL_SAMPLE_SHADING											0x8c36 /**< @brief GL_ARB_sample_shading (part of OpenGL 4.0 core) enum **/
#define GL_MIN_SAMPLE_SHADING_VALUE									0x8c37 /**< @brief GL_ARB_sample_shading (part of OpenGL 4.0 core) enum **/

/**
 *	@brief specifies minimum rate at which sample shaing takes place
 *	@param[in] value specifies the rate at which samples are shaded within each covered pixel
 */
extern void (GLApi *GLFuncPtrName(glMinSampleShading))(GLclampf value);

/**
 *	@def glMinSampleShading
 *	@brief specifies minimum rate at which sample shaing takes place
 *	@param[in] value specifies the rate at which samples are shaded within each covered pixel
 */
#define glMinSampleShading(value) do { GLFuncPtrName(glMinSampleShading)(value); GL_AUTOCHECK_BLOCK("glMinSampleShading", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_sample_shading

//								--- ~GL_ARB_sample_shading (part of OpenGL 4.0 core) ---

//								--- GL_ARB_shader_subroutine (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_shader_subroutine
 *	@brief if defined, GL_ARB_shader_subroutine (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_shader_subroutine
#define GL_ARB_shader_subroutine 1

/**
 *	@def __GENERATE_GL_ARB_shader_subroutine
 *	@brief if defined, code to initialize GL_ARB_shader_subroutine (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_shader_subroutine

extern bool GLEH_ARB_shader_subroutine; /**< @brief set if GL_ARB_shader_subroutine is supported */

#define GL_ACTIVE_SUBROUTINES										0x8de5 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_ACTIVE_SUBROUTINE_UNIFORMS								0x8de6 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS						0x8e47 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_ACTIVE_SUBROUTINE_MAX_LENGTH								0x8e48 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH						0x8e49 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_MAX_SUBROUTINES											0x8de7 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS							0x8de8 /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_NUM_COMPATIBLE_SUBROUTINES								0x8e4a /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/
#define GL_COMPATIBLE_SUBROUTINES									0x8e4b /**< @brief GL_ARB_shader_subroutine (part of OpenGL 4.0 core) enum **/

/**
 *	@brief retrieve the location of a subroutine uniform of a given shader stage within a program
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] name specifies the name of the subroutine uniform whose index to query
 */
extern int (GLApi *GLFuncPtrName(glGetSubroutineUniformLocation))(GLuint program, GLenum shadertype, const GLchar *name);

/**
 *	@brief retrieve the index of a subroutine uniform of a given shader stage within a program
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] name specifies the name of the subroutine uniform whose index to query
 */
extern GLuint (GLApi *GLFuncPtrName(glGetSubroutineIndex))(GLuint program, GLenum shadertype, const GLchar *name);

/**
 *	@brief query a property of an active shader subroutine uniform
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] pname specifies the parameter of the shader subroutine uniform to query. pname must
 *		be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH
 *	@param[out] values specifies the address of a into which the queried value or values will be placed
 */
extern void (GLApi *GLFuncPtrName(glGetActiveSubroutineUniformiv))(GLuint program, GLenum shadertype, GLuint index, GLenum pname, int *values);

/**
 *	@brief query the name of an active shader subroutine uniform
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] bufsize specifies the size of the buffer whose address is given in name
 *	@param[out] length specifies the address of a variable into which is written the number of
 *		characters copied into name
 *	@param[out] name specifies the address of a buffer that will receive the name of the specified
 *		shader subroutine uniform
 */
extern void (GLApi *GLFuncPtrName(glGetActiveSubroutineUniformName))(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);

/**
 *	@brief query the name of an active shader subroutine
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query the subroutine name
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] bufsize specifies the size of the buffer whose address is given in name
 *	@param[out] length specifies the address of a variable which is to receive the length of the
 *		shader subroutine uniform name
 *	@param[out] name specifies the address of an array into which the name of the shader subroutine
 *		uniform will be written
 */
extern void (GLApi *GLFuncPtrName(glGetActiveSubroutineName))(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);

/**
 *	@brief load active subroutine uniforms
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] count specifies the number of uniform indices stored in indices
 *	@param[in] indices specifies the address of an array holding the indices to load into the shader
 *		subroutine variables
 */
extern void (GLApi *GLFuncPtrName(glUniformSubroutinesuiv))(GLenum shadertype, GLsizei count, const GLuint *indices);

/**
 *	@brief retrieve the value of a subroutine uniform of a given shader stage of the current program
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] location specifies the location of the subroutine uniform
 *	@param[out] values specifies the address of a variable to receive the value or values of the
 *		subroutine uniform
 */
extern void (GLApi *GLFuncPtrName(glGetUniformSubroutineuiv))(GLenum shadertype, int location, GLuint *values);

/**
 *	@brief retrieve properties of a program object corresponding to a specified shader stage
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] pname specifies the parameter of the shader to query. pname must be
 *		GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS,
 *		GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH
 *	@param[out] values specifies the address of a variable into which the queried value or values
 *		will be placed
 */
extern void (GLApi *GLFuncPtrName(glGetProgramStageiv))(GLuint program, GLenum shadertype, GLenum pname, int *values);

inline int glGetSubroutineUniformLocation_glachwrap(GLuint program, GLenum shadertype, const GLchar *name, const char *p_s_filename, int n_line) { int result = GLFuncPtrName(glGetSubroutineUniformLocation)(program,shadertype,name); GL_AUTOCHECK_BLOCK("glGetSubroutineUniformLocation", p_s_filename, n_line); return result; }
inline GLuint glGetSubroutineIndex_glachwrap(GLuint program, GLenum shadertype, const GLchar *name, const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glGetSubroutineIndex)(program,shadertype,name); GL_AUTOCHECK_BLOCK("glGetSubroutineIndex", p_s_filename, n_line); return result; }

/**
 *	@def glGetSubroutineUniformLocation
 *	@brief retrieve the location of a subroutine uniform of a given shader stage within a program
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] name specifies the name of the subroutine uniform whose index to query
 */
#define glGetSubroutineUniformLocation(program,shadertype,name) GLAutoCheckFuncPtrName(glGetSubroutineUniformLocation)(program, shadertype, name GLAutoCheckExtraParams)

/**
 *	@def glGetSubroutineIndex
 *	@brief retrieve the index of a subroutine uniform of a given shader stage within a program
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] name specifies the name of the subroutine uniform whose index to query
 */
#define glGetSubroutineIndex(program,shadertype,name) GLAutoCheckFuncPtrName(glGetSubroutineIndex)(program, shadertype, name GLAutoCheckExtraParams)

/**
 *	@def glGetActiveSubroutineUniformiv
 *	@brief query a property of an active shader subroutine uniform
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] pname specifies the parameter of the shader subroutine uniform to query. pname must
 *		be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH
 *	@param[out] values specifies the address of a into which the queried value or values will be placed
 */
#define glGetActiveSubroutineUniformiv(program,shadertype,index,pname,values) do { GLFuncPtrName(glGetActiveSubroutineUniformiv)(program, shadertype, index, pname, values); GL_AUTOCHECK_BLOCK("glGetActiveSubroutineUniformiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveSubroutineUniformName
 *	@brief query the name of an active shader subroutine uniform
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] bufsize specifies the size of the buffer whose address is given in name
 *	@param[out] length specifies the address of a variable into which is written the number of
 *		characters copied into name
 *	@param[out] name specifies the address of a buffer that will receive the name of the specified
 *		shader subroutine uniform
 */
#define glGetActiveSubroutineUniformName(program,shadertype,index,bufsize,length,name) do { GLFuncPtrName(glGetActiveSubroutineUniformName)(program, shadertype, index, bufsize, length, name); GL_AUTOCHECK_BLOCK("glGetActiveSubroutineUniformName", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetActiveSubroutineName
 *	@brief query the name of an active shader subroutine
 *	@param[in] program specifies the name of the program containing the subroutine
 *	@param[in] shadertype specifies the shader stage from which to query the subroutine name
 *	@param[in] index specifies the index of the shader subroutine uniform
 *	@param[in] bufsize specifies the size of the buffer whose address is given in name
 *	@param[out] length specifies the address of a variable which is to receive the length of the
 *		shader subroutine uniform name
 *	@param[out] name specifies the address of an array into which the name of the shader subroutine
 *		uniform will be written
 */
#define glGetActiveSubroutineName(program,shadertype,index,bufsize,length,name) do { GLFuncPtrName(glGetActiveSubroutineName)(program, shadertype, index, bufsize, length, name); GL_AUTOCHECK_BLOCK("glGetActiveSubroutineName", __FILE__, __LINE__); } while(0)

/**
 *	@def glUniformSubroutinesuiv
 *	@brief load active subroutine uniforms
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] count specifies the number of uniform indices stored in indices
 *	@param[in] indices specifies the address of an array holding the indices to load into the shader
 *		subroutine variables
 */
#define glUniformSubroutinesuiv(shadertype,count,indices) do { GLFuncPtrName(glUniformSubroutinesuiv)(shadertype, count, indices); GL_AUTOCHECK_BLOCK("glUniformSubroutinesuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetUniformSubroutineuiv
 *	@brief retrieve the value of a subroutine uniform of a given shader stage of the current program
 *	@param[in] shadertype specifies the shader stage from which to query for subroutine uniform
 *		index. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] location specifies the location of the subroutine uniform
 *	@param[out] values specifies the address of a variable to receive the value or values of the
 *		subroutine uniform
 */
#define glGetUniformSubroutineuiv(shadertype,location,values) do { GLFuncPtrName(glGetUniformSubroutineuiv)(shadertype, location, values); GL_AUTOCHECK_BLOCK("glGetUniformSubroutineuiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetProgramStageiv
 *	@brief retrieve properties of a program object corresponding to a specified shader stage
 *	@param[in] program specifies the name of the program containing shader stage
 *	@param[in] shadertype specifies the shader stage from which to query for the subroutine
 *		parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER,
 *		GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] pname specifies the parameter of the shader to query. pname must be
 *		GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS,
 *		GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH
 *	@param[out] values specifies the address of a variable into which the queried value or values
 *		will be placed
 */
#define glGetProgramStageiv(program,shadertype,pname,values) do { GLFuncPtrName(glGetProgramStageiv)(program, shadertype, pname, values); GL_AUTOCHECK_BLOCK("glGetProgramStageiv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_shader_subroutine

//								--- ~GL_ARB_shader_subroutine (part of OpenGL 4.0 core) ---

//								--- GL_ARB_tessellation_shader (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_tessellation_shader
 *	@brief if defined, GL_ARB_tessellation_shader (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_tessellation_shader
#define GL_ARB_tessellation_shader 1

/**
 *	@def __GENERATE_GL_ARB_tessellation_shader
 *	@brief if defined, code to initialize GL_ARB_tessellation_shader (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_tessellation_shader

extern bool GLEH_ARB_tessellation_shader; /**< @brief set if GL_ARB_tessellation_shader is supported */

#define GL_PATCHES													0x000e /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_PATCH_VERTICES											0x8e72 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_PATCH_DEFAULT_INNER_LEVEL								0x8e73 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_PATCH_DEFAULT_OUTER_LEVEL								0x8e74 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_CONTROL_OUTPUT_VERTICES								0x8e75 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_GEN_MODE											0x8e76 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_GEN_SPACING											0x8e77 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_GEN_VERTEX_ORDER									0x8e78 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_GEN_POINT_MODE										0x8e79 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_ISOLINES													0x8e7a /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_FRACTIONAL_ODD											0x8e7b /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_FRACTIONAL_EVEN											0x8e7c /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_PATCH_VERTICES										0x8e7d /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_GEN_LEVEL										0x8e7e /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS						0x8e7f /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS					0x8e80 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS						0x8e81 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS					0x8e82 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS						0x8e83 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_PATCH_COMPONENTS								0x8e84 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS					0x8e85 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS					0x8e86 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS							0x8e89 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS						0x8e8a /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_CONTROL_INPUT_COMPONENTS						0x886c /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS						0x886d /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS				0x8e1e /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS			0x8e1f /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER			0x84f0 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER		0x84f1 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_EVALUATION_SHADER									0x8e87 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/
#define GL_TESS_CONTROL_SHADER										0x8e88 /**< @brief GL_ARB_tessellation_shader (part of OpenGL 4.0 core) enum **/

/**
 *	@brief specifies the parameters for patch primitives
 *	@param[in] pname specifies the name of the parameter to set. The symbolc constants
 *		GL_PATCH_VERTICES, GL_PATCH_DEFAULT_OUTER_LEVEL, and GL_PATCH_DEFAULT_INNER_LEVEL are accepted
 *	@param[in] value specifies the new value for the parameter given by pname
 */
extern void (GLApi *GLFuncPtrName(glPatchParameteri))(GLenum pname, int value);

/**
 *	@brief specifies the parameters for patch primitives
 *	@param[in] pname specifies the name of the parameter to set. The symbolc constants
 *		GL_PATCH_VERTICES, GL_PATCH_DEFAULT_OUTER_LEVEL, and GL_PATCH_DEFAULT_INNER_LEVEL are accepted
 *	@param[in] values specifies the address of an array containing the new values for the parameter
 *		given by pname
 */
extern void (GLApi *GLFuncPtrName(glPatchParameterfv))(GLenum pname, const float *values);

/**
 *	@def glPatchParameteri
 *	@brief specifies the parameters for patch primitives
 *	@param[in] pname specifies the name of the parameter to set. The symbolc constants
 *		GL_PATCH_VERTICES, GL_PATCH_DEFAULT_OUTER_LEVEL, and GL_PATCH_DEFAULT_INNER_LEVEL are accepted
 *	@param[in] value specifies the new value for the parameter given by pname
 */
#define glPatchParameteri(pname,value) do { GLFuncPtrName(glPatchParameteri)(pname, value); GL_AUTOCHECK_BLOCK("glPatchParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glPatchParameterfv
 *	@brief specifies the parameters for patch primitives
 *	@param[in] pname specifies the name of the parameter to set. The symbolc constants
 *		GL_PATCH_VERTICES, GL_PATCH_DEFAULT_OUTER_LEVEL, and GL_PATCH_DEFAULT_INNER_LEVEL are accepted
 *	@param[in] values specifies the address of an array containing the new values for the parameter
 *		given by pname
 */
#define glPatchParameterfv(pname,values) do { GLFuncPtrName(glPatchParameterfv)(pname, values); GL_AUTOCHECK_BLOCK("glPatchParameterfv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_tessellation_shader

//								--- ~GL_ARB_tessellation_shader (part of OpenGL 4.0 core) ---

//								--- GL_ARB_texture_buffer_object_rgb32 (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_texture_buffer_object_rgb32
 *	@brief if defined, GL_ARB_texture_buffer_object_rgb32 (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_texture_buffer_object_rgb32
#define GL_ARB_texture_buffer_object_rgb32 1

extern bool GLEH_ARB_texture_buffer_object_rgb32; /**< @brief set if GL_ARB_texture_buffer_object_rgb32 is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_texture_buffer_object_rgb32

//								--- ~GL_ARB_texture_buffer_object_rgb32 (part of OpenGL 4.0 core) ---

//								--- GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_texture_cube_map_array
 *	@brief if defined, GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_texture_cube_map_array
#define GL_ARB_texture_cube_map_array 1

extern bool GLEH_ARB_texture_cube_map_array; /**< @brief set if GL_ARB_texture_cube_map_array is supported */

#define GL_TEXTURE_CUBE_MAP_ARRAY									0x9009 /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY							0x900a /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_PROXY_TEXTURE_CUBE_MAP_ARRAY								0x900b /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_SAMPLER_CUBE_MAP_ARRAY									0x900c /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW							0x900d /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_INT_SAMPLER_CUBE_MAP_ARRAY								0x900e /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/
#define GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY						0x900f /**< @brief GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_cube_map_array

//								--- ~GL_ARB_texture_cube_map_array (part of OpenGL 4.0 core) ---

//								--- GL_ARB_texture_gather (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_texture_gather
 *	@brief if defined, GL_ARB_texture_gather (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_texture_gather
#define GL_ARB_texture_gather 1

extern bool GLEH_ARB_texture_gather; /**< @brief set if GL_ARB_texture_gather is supported */

#define GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET						0x8e5e /**< @brief GL_ARB_texture_gather (part of OpenGL 4.0 core) enum **/
#define GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET						0x8e5f /**< @brief GL_ARB_texture_gather (part of OpenGL 4.0 core) enum **/
#define GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS					0x8f9f /**< @brief GL_ARB_texture_gather (part of OpenGL 4.0 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_gather

//								--- ~GL_ARB_texture_gather (part of OpenGL 4.0 core) ---

//								--- GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_transform_feedback2
 *	@brief if defined, GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_transform_feedback2
#define GL_ARB_transform_feedback2 1

/**
 *	@def __GENERATE_GL_ARB_transform_feedback2
 *	@brief if defined, code to initialize GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_transform_feedback2

extern bool GLEH_ARB_transform_feedback2; /**< @brief set if GL_ARB_transform_feedback2 is supported */

#define GL_TRANSFORM_FEEDBACK										0x8e22 /**< @brief GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) enum **/
#define GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED							0x8e23 /**< @brief GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) enum **/
#define GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE							0x8e24 /**< @brief GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) enum **/
#define GL_TRANSFORM_FEEDBACK_BINDING								0x8e25 /**< @brief GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) enum **/

/**
 *	@brief bind a transform feedback object
 *	@param[in] target specifies the target to which to bind the transform feedback object id. target
 *		must be GL_TRANSFORM_FEEDBACK
 *	@param[in] id specifies the name of a transform feedback object reserved by glGenTransformFeedbacks
 */
extern void (GLApi *GLFuncPtrName(glBindTransformFeedback))(GLenum target, GLuint id);

/**
 *	@brief delete transform feedback objects
 *	@param[in] n specifies the number of transform feedback objects to delete
 *	@param[in] ids specifies an array of names of transform feedback objects to delete
 */
extern void (GLApi *GLFuncPtrName(glDeleteTransformFeedbacks))(GLsizei n, const GLuint *ids);

/**
 *	@brief reserve transform feedback object names
 *	@param[in] n specifies the number of transform feedback object names to reserve
 *	@param[out] ids specifies an array of into which the reserved names will be written
 */
extern void (GLApi *GLFuncPtrName(glGenTransformFeedbacks))(GLsizei n, GLuint *ids);

/**
 *	@brief determine if a name corresponds to a transform feedback object
 *	@param[in] id specifies a value that may be the name of a transform feedback object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsTransformFeedback))(GLuint id);

/**
 *	@brief pause transform feedback operations
 */
extern void (GLApi *GLFuncPtrName(glPauseTransformFeedback))();

/**
 *	@brief resume transform feedback operations
 */
extern void (GLApi *GLFuncPtrName(glResumeTransformFeedback))();

/**
 *	@brief render primitives using a count derived from a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 */
extern void (GLApi *GLFuncPtrName(glDrawTransformFeedback))(GLenum mode, GLuint id);

inline GLboolean glIsTransformFeedback_glachwrap(GLuint id, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsTransformFeedback)(id); GL_AUTOCHECK_BLOCK("glIsTransformFeedback", p_s_filename, n_line); return result; }

/**
 *	@def glBindTransformFeedback
 *	@brief bind a transform feedback object
 *	@param[in] target specifies the target to which to bind the transform feedback object id. target
 *		must be GL_TRANSFORM_FEEDBACK
 *	@param[in] id specifies the name of a transform feedback object reserved by glGenTransformFeedbacks
 */
#define glBindTransformFeedback(target,id) do { GLFuncPtrName(glBindTransformFeedback)(target, id); GL_AUTOCHECK_BLOCK("glBindTransformFeedback", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteTransformFeedbacks
 *	@brief delete transform feedback objects
 *	@param[in] n specifies the number of transform feedback objects to delete
 *	@param[in] ids specifies an array of names of transform feedback objects to delete
 */
#define glDeleteTransformFeedbacks(n,ids) do { GLFuncPtrName(glDeleteTransformFeedbacks)(n, ids); GL_AUTOCHECK_BLOCK("glDeleteTransformFeedbacks", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenTransformFeedbacks
 *	@brief reserve transform feedback object names
 *	@param[in] n specifies the number of transform feedback object names to reserve
 *	@param[out] ids specifies an array of into which the reserved names will be written
 */
#define glGenTransformFeedbacks(n,ids) do { GLFuncPtrName(glGenTransformFeedbacks)(n, ids); GL_AUTOCHECK_BLOCK("glGenTransformFeedbacks", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsTransformFeedback
 *	@brief determine if a name corresponds to a transform feedback object
 *	@param[in] id specifies a value that may be the name of a transform feedback object
 */
#define glIsTransformFeedback(id) GLAutoCheckFuncPtrName(glIsTransformFeedback)(id GLAutoCheckExtraParams)

/**
 *	@def glPauseTransformFeedback
 *	@brief pause transform feedback operations
 */
#define glPauseTransformFeedback() do { GLFuncPtrName(glPauseTransformFeedback)(); GL_AUTOCHECK_BLOCK("glPauseTransformFeedback", __FILE__, __LINE__); } while(0)

/**
 *	@def glResumeTransformFeedback
 *	@brief resume transform feedback operations
 */
#define glResumeTransformFeedback() do { GLFuncPtrName(glResumeTransformFeedback)(); GL_AUTOCHECK_BLOCK("glResumeTransformFeedback", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawTransformFeedback
 *	@brief render primitives using a count derived from a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 */
#define glDrawTransformFeedback(mode,id) do { GLFuncPtrName(glDrawTransformFeedback)(mode, id); GL_AUTOCHECK_BLOCK("glDrawTransformFeedback", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_transform_feedback2

//								--- ~GL_ARB_transform_feedback2 (part of OpenGL 4.0 core) ---

//								--- GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) ---

/**
 *	@def GL_ARB_transform_feedback3
 *	@brief if defined, GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) entry points are available
 */
#ifndef GL_ARB_transform_feedback3
#define GL_ARB_transform_feedback3 1

/**
 *	@def __GENERATE_GL_ARB_transform_feedback3
 *	@brief if defined, code to initialize GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_transform_feedback3

extern bool GLEH_ARB_transform_feedback3; /**< @brief set if GL_ARB_transform_feedback3 is supported */

#define GL_MAX_TRANSFORM_FEEDBACK_BUFFERS							0x8e70 /**< @brief GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) enum **/
//#define GL_MAX_VERTEX_STREAMS										  0x8e71 // (defined above)

/**
 *	@brief render primitives using a count derived from a specifed stream of a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] stream specifies the index of the transform feedback stream from which to retrieve a
 *		primitive count
 */
extern void (GLApi *GLFuncPtrName(glDrawTransformFeedbackStream))(GLenum mode, GLuint id, GLuint stream);

/**
 *	@brief delimit the boundaries of a query object on an indexed target
 *	@param[in] target specifies the target type of query object established between
 *		glBeginQueryIndexed and the subsequent glEndQueryIndexed. The symbolic constant must be one
 *		of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED
 *	@param[in] index specifies the index of the query target upon which to begin the query
 *	@param[in] id specifies the name of a query object
 */
extern void (GLApi *GLFuncPtrName(glBeginQueryIndexed))(GLenum target, GLuint index, GLuint id);

/**
 *	@brief delimit the boundaries of a query object on an indexed target
 *	@param[in] target specifies the target type of query object to be concluded. The symbolic
 *		constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED
 *	@param[in] index specifies the index of the query target upon which to end the query
 */
extern void (GLApi *GLFuncPtrName(glEndQueryIndexed))(GLenum target, GLuint index);

/**
 *	@brief return parameters of an indexed query object target
 *	@param[in] target specifies a query object target. Must be GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
 *		GL_TIME_ELAPSED, or GL_TIMESTAMP
 *	@param[in] index specifies the index of the query object target
 *	@param[in] pname specifies the symbolic name of a query object target parameter. Accepted values
 *		are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS
 *	@param[out] params returns the requested data
 */
extern void (GLApi *GLFuncPtrName(glGetQueryIndexediv))(GLenum target, GLuint index, GLenum pname, int *params);

/**
 *	@def glDrawTransformFeedbackStream
 *	@brief render primitives using a count derived from a specifed stream of a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] stream specifies the index of the transform feedback stream from which to retrieve a
 *		primitive count
 */
#define glDrawTransformFeedbackStream(mode,id,stream) do { GLFuncPtrName(glDrawTransformFeedbackStream)(mode, id, stream); GL_AUTOCHECK_BLOCK("glDrawTransformFeedbackStream", __FILE__, __LINE__); } while(0)

/**
 *	@def glBeginQueryIndexed
 *	@brief delimit the boundaries of a query object on an indexed target
 *	@param[in] target specifies the target type of query object established between
 *		glBeginQueryIndexed and the subsequent glEndQueryIndexed. The symbolic constant must be one
 *		of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED
 *	@param[in] index specifies the index of the query target upon which to begin the query
 *	@param[in] id specifies the name of a query object
 */
#define glBeginQueryIndexed(target,index,id) do { GLFuncPtrName(glBeginQueryIndexed)(target, index, id); GL_AUTOCHECK_BLOCK("glBeginQueryIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glEndQueryIndexed
 *	@brief delimit the boundaries of a query object on an indexed target
 *	@param[in] target specifies the target type of query object to be concluded. The symbolic
 *		constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED,
 *		GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED
 *	@param[in] index specifies the index of the query target upon which to end the query
 */
#define glEndQueryIndexed(target,index) do { GLFuncPtrName(glEndQueryIndexed)(target, index); GL_AUTOCHECK_BLOCK("glEndQueryIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetQueryIndexediv
 *	@brief return parameters of an indexed query object target
 *	@param[in] target specifies a query object target. Must be GL_SAMPLES_PASSED,
 *		GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
 *		GL_TIME_ELAPSED, or GL_TIMESTAMP
 *	@param[in] index specifies the index of the query object target
 *	@param[in] pname specifies the symbolic name of a query object target parameter. Accepted values
 *		are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS
 *	@param[out] params returns the requested data
 */
#define glGetQueryIndexediv(target,index,pname,params) do { GLFuncPtrName(glGetQueryIndexediv)(target, index, pname, params); GL_AUTOCHECK_BLOCK("glGetQueryIndexediv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_transform_feedback3

//								--- ~GL_ARB_transform_feedback3 (part of OpenGL 4.0 core) ---

//								--- OpenGL 4.1 ---

/**
 *	@def GL_VERSION_4_1
 *	@brief if defined, OpenGL 4.1 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_4_1
#define GL_VERSION_4_1 1

/**
 *	@def __GENERATE_GL_41__
 *	@brief if defined, code to initialize OpenGL 4.1 entry points is compiled
 */
#define __GENERATE_GL_41__

extern bool GLEH_OPENGL_4_1; /**< @brief set if OpenGL 4.1 is supported */

#endif // !GL_VERSION_4_1

//								--- ~OpenGL 4.1 ---

//								--- GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_ES2_compatibility
 *	@brief if defined, GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_ES2_compatibility
#define GL_ARB_ES2_compatibility 1

/**
 *	@def __GENERATE_GL_ARB_ES2_compatibility
 *	@brief if defined, code to initialize GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_ES2_compatibility

extern bool GLEH_ARB_ES2_compatibility; /**< @brief set if GL_ARB_ES2_compatibility is supported */

#define GL_SHADER_COMPILER											0x8dfa /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_SHADER_BINARY_FORMATS									0x8df8 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_NUM_SHADER_BINARY_FORMATS								0x8df9 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_MAX_VERTEX_UNIFORM_VECTORS								0x8dfb /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_MAX_VARYING_VECTORS										0x8dfc /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS								0x8dfd /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_IMPLEMENTATION_COLOR_READ_TYPE							0x8b9a /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_IMPLEMENTATION_COLOR_READ_FORMAT							0x8b9b /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_FIXED													0x140c /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_LOW_FLOAT												0x8df0 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_MEDIUM_FLOAT												0x8df1 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_HIGH_FLOAT												0x8df2 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_LOW_INT													0x8df3 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_MEDIUM_INT												0x8df4 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/
#define GL_HIGH_INT													0x8df5 /**< @brief GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) enum **/

/**
 *	@brief release resources consumed by the implementation's shader compiler
 */
extern void (GLApi *GLFuncPtrName(glReleaseShaderCompiler))();

/**
 *	@brief load pre-compiled shader binaries
 *	@param[in] count specifies the number of shader object handles contained in shaders
 *	@param[in] shaders specifies the address of an array of shader handles into which to load
 *		pre-compiled shader binaries
 *	@param[in] binaryFormat specifies the format of the shader binaries contained in binary
 *	@param[in] binary specifies the address of an array of bytes containing pre-compiled binary
 *		shader code
 *	@param[in] length specifies the length of the array whose address is given in binary
 */
extern void (GLApi *GLFuncPtrName(glShaderBinary))(GLsizei count, const GLuint *shaders, GLenum binaryFormat, const void *binary, GLsizei length);

/**
 *	@brief retrieve the range and precision for numeric formats supported by the shader compiler
 *	@param[in] shaderType specifies the type of shader whose precision to query. shaderType must be
 *		GL_VERTEX_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] precisionType specifies the numeric format whose precision and range to query
 *	@param[out] range specifies the address of array of two integers into which encodings of the
 *		implementation's numeric range are returned
 *	@param[out] precision specifies the address of an integer into which the numeric precision of
 *		the implementation is written
 */
extern void (GLApi *GLFuncPtrName(glGetShaderPrecisionFormat))(GLenum shaderType, GLenum precisionType, int *range, int *precision);

/**
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates
 *	@param[in] nearVal specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0
 *	@param[in] farVal specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1
 */
extern void (GLApi *GLFuncPtrName(glDepthRangef))(GLclampf nearVal, GLclampf farVal);

/**
 *	@brief specify the clear value for the depth buffer
 *	@param[in] depth specifies the depth value used when the depth buffer is cleared. The initial
 *		value is 1
 */
extern void (GLApi *GLFuncPtrName(glClearDepthf))(GLclampf depth);

/**
 *	@def glReleaseShaderCompiler
 *	@brief release resources consumed by the implementation's shader compiler
 */
#define glReleaseShaderCompiler() do { GLFuncPtrName(glReleaseShaderCompiler)(); GL_AUTOCHECK_BLOCK("glReleaseShaderCompiler", __FILE__, __LINE__); } while(0)

/**
 *	@def glShaderBinary
 *	@brief load pre-compiled shader binaries
 *	@param[in] count specifies the number of shader object handles contained in shaders
 *	@param[in] shaders specifies the address of an array of shader handles into which to load
 *		pre-compiled shader binaries
 *	@param[in] binaryFormat specifies the format of the shader binaries contained in binary
 *	@param[in] binary specifies the address of an array of bytes containing pre-compiled binary
 *		shader code
 *	@param[in] length specifies the length of the array whose address is given in binary
 */
#define glShaderBinary(count,shaders,binaryFormat,binary,length) do { GLFuncPtrName(glShaderBinary)(count, shaders, binaryFormat, binary, length); GL_AUTOCHECK_BLOCK("glShaderBinary", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetShaderPrecisionFormat
 *	@brief retrieve the range and precision for numeric formats supported by the shader compiler
 *	@param[in] shaderType specifies the type of shader whose precision to query. shaderType must be
 *		GL_VERTEX_SHADER or GL_FRAGMENT_SHADER
 *	@param[in] precisionType specifies the numeric format whose precision and range to query
 *	@param[out] range specifies the address of array of two integers into which encodings of the
 *		implementation's numeric range are returned
 *	@param[out] precision specifies the address of an integer into which the numeric precision of
 *		the implementation is written
 */
#define glGetShaderPrecisionFormat(shaderType,precisionType,range,precision) do { GLFuncPtrName(glGetShaderPrecisionFormat)(shaderType, precisionType, range, precision); GL_AUTOCHECK_BLOCK("glGetShaderPrecisionFormat", __FILE__, __LINE__); } while(0)

/**
 *	@def glDepthRangef
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates
 *	@param[in] nearVal specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0
 *	@param[in] farVal specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1
 */
#define glDepthRangef(nearVal,farVal) do { GLFuncPtrName(glDepthRangef)(nearVal, farVal); GL_AUTOCHECK_BLOCK("glDepthRangef", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearDepthf
 *	@brief specify the clear value for the depth buffer
 *	@param[in] depth specifies the depth value used when the depth buffer is cleared. The initial
 *		value is 1
 */
#define glClearDepthf(depth) do { GLFuncPtrName(glClearDepthf)(depth); GL_AUTOCHECK_BLOCK("glClearDepthf", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_ES2_compatibility

//								--- ~GL_ARB_ES2_compatibility (part of OpenGL 4.1 core) ---

//								--- GL_ARB_get_program_binary (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_get_program_binary
 *	@brief if defined, GL_ARB_get_program_binary (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_get_program_binary
#define GL_ARB_get_program_binary 1

/**
 *	@def __GENERATE_GL_ARB_get_program_binary
 *	@brief if defined, code to initialize GL_ARB_get_program_binary (part of OpenGL 4.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_get_program_binary

extern bool GLEH_ARB_get_program_binary; /**< @brief set if GL_ARB_get_program_binary is supported */

#define GL_PROGRAM_BINARY_RETRIEVABLE_HINT							0x8257 /**< @brief GL_ARB_get_program_binary (part of OpenGL 4.1 core) enum **/
#define GL_PROGRAM_BINARY_LENGTH									0x8741 /**< @brief GL_ARB_get_program_binary (part of OpenGL 4.1 core) enum **/
#define GL_NUM_PROGRAM_BINARY_FORMATS								0x87fe /**< @brief GL_ARB_get_program_binary (part of OpenGL 4.1 core) enum **/
#define GL_PROGRAM_BINARY_FORMATS									0x87ff /**< @brief GL_ARB_get_program_binary (part of OpenGL 4.1 core) enum **/

/**
 *	@brief return a binary representation of a program object's compiled and linked executable source
 *	@param[in] program specifies the name of a program object whose binary representation to retrieve
 *	@param[in] bufSize specifies the size of the buffer whose address is given by binary
 *	@param[out] length specifies the address of a variable to receive the number of bytes written
 *		into binary
 *	@param[out] binaryFormat specifies the address of a variable to receive a token indicating the
 *		format of the binary data returned by the GL
 *	@param[out] binary specifies the address an array into which the GL will return program's binary representation
 */
extern void (GLApi *GLFuncPtrName(glGetProgramBinary))(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary);

/**
 *	@brief load a program object with a program binary
 *	@param[in] program specifies the name of a program object into which to load a program binary
 *	@param[in] binaryFormat specifies the format of the binary data in binary
 *	@param[in] binary specifies the address an array containing the binary to be loaded into program
 *	@param[in] length specifies the number of bytes contained in binary
 */
extern void (GLApi *GLFuncPtrName(glProgramBinary))(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length);
//extern void (GLApi *GLFuncPtrName(glProgramParameteri))(GLuint program, GLenum pname, int value); // defined above

/**
 *	@def glGetProgramBinary
 *	@brief return a binary representation of a program object's compiled and linked executable source
 *	@param[in] program specifies the name of a program object whose binary representation to retrieve
 *	@param[in] bufSize specifies the size of the buffer whose address is given by binary
 *	@param[out] length specifies the address of a variable to receive the number of bytes written
 *		into binary
 *	@param[out] binaryFormat specifies the address of a variable to receive a token indicating the
 *		format of the binary data returned by the GL
 *	@param[out] binary specifies the address an array into which the GL will return program's binary representation
 */
#define glGetProgramBinary(program,bufSize,length,binaryFormat,binary) do { GLFuncPtrName(glGetProgramBinary)(program, bufSize, length, binaryFormat, binary); GL_AUTOCHECK_BLOCK("glGetProgramBinary", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramBinary
 *	@brief load a program object with a program binary
 *	@param[in] program specifies the name of a program object into which to load a program binary
 *	@param[in] binaryFormat specifies the format of the binary data in binary
 *	@param[in] binary specifies the address an array containing the binary to be loaded into program
 *	@param[in] length specifies the number of bytes contained in binary
 */
#define glProgramBinary(program,binaryFormat,binary,length) do { GLFuncPtrName(glProgramBinary)(program, binaryFormat, binary, length); GL_AUTOCHECK_BLOCK("glProgramBinary", __FILE__, __LINE__); } while(0)
//#define glProgramParameteri(program,pname,value) do { GLFuncPtrName(glProgramParameteri)(program, pname, value); GL_AUTOCHECK_BLOCK("glProgramParameteri", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_get_program_binary

//								--- ~GL_ARB_get_program_binary (part of OpenGL 4.1 core) ---

//								--- GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_separate_shader_objects
 *	@brief if defined, GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_separate_shader_objects
#define GL_ARB_separate_shader_objects 1

/**
 *	@def __GENERATE_GL_ARB_separate_shader_objects
 *	@brief if defined, code to initialize GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_separate_shader_objects

extern bool GLEH_ARB_separate_shader_objects; /**< @brief set if GL_ARB_separate_shader_objects is supported */

#define GL_VERTEX_SHADER_BIT										0x00000001 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_FRAGMENT_SHADER_BIT										0x00000002 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_GEOMETRY_SHADER_BIT										0x00000004 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_TESS_CONTROL_SHADER_BIT									0x00000008 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_TESS_EVALUATION_SHADER_BIT								0x00000010 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_ALL_SHADER_BITS											0xffffffffu /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_PROGRAM_SEPARABLE										0x8258 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_ACTIVE_PROGRAM											0x8259 /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/
#define GL_PROGRAM_PIPELINE_BINDING									0x825a /**< @brief GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) enum **/

/**
 *	@brief bind stages of a program object to a program pipeline
 *	@param[in] pipeline specifies the program pipeline object to which to bind stages from program
 *	@param[in] stages specifies a set of program stages to bind to the program pipeline object
 *	@param[in] program specifies the program object containing the shader executables to use in pipeline
 */
extern void (GLApi *GLFuncPtrName(glUseProgramStages))(GLuint pipeline, GLbitfield stages, GLuint program);

/**
 *	@brief set the active program object for a program pipeline object
 *	@param[in] pipeline specifies the program pipeline object to set the active program object for
 *	@param[in] program specifies the program object to set as the active program pipeline object pipeline
 */
extern void (GLApi *GLFuncPtrName(glActiveShaderProgram))(GLuint pipeline, GLuint program);

/**
 *	@brief create a stand-alone program from an array of null-terminated source code strings
 *	@param[in] type specifies the type of shader to create
 *	@param[in] count specifies the number of source code strings in the array strings
 *	@param[in] strings specifies the address of an array of pointers to source code strings from
 *		which to create the program object
 */
extern GLuint (GLApi *GLFuncPtrName(glCreateShaderProgramv))(GLenum type, GLsizei count, const GLchar **strings);

/**
 *	@brief bind a program pipeline to the current context
 *	@param[in] pipeline specifies the name of the pipeline object to bind to the context
 */
extern void (GLApi *GLFuncPtrName(glBindProgramPipeline))(GLuint pipeline);

/**
 *	@brief delete program pipeline objects
 *	@param[in] n specifies the number of program pipeline objects to delete
 *	@param[in] pipelines specifies an array of names of program pipeline objects to delete
 */
extern void (GLApi *GLFuncPtrName(glDeleteProgramPipelines))(GLsizei n, const GLuint *pipelines);

/**
 *	@brief reserve program pipeline object names
 *	@param[in] n specifies the number of program pipeline object names to reserve
 *	@param[out] pipelines specifies an array of into which the reserved names will be written
 */
extern void (GLApi *GLFuncPtrName(glGenProgramPipelines))(GLsizei n, GLuint *pipelines);

/**
 *	@brief determine if a name corresponds to a program pipeline object
 *	@param[in] pipeline specifies a value that may be the name of a program pipeline object
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsProgramPipeline))(GLuint pipeline);
//extern void (GLApi *GLFuncPtrName(glProgramParameteri))(GLuint program, GLenum pname, int value); // defined above

/**
 *	@brief retrieve properties of a program pipeline object
 *	@param[in] pipeline specifies the name of a program pipeline object whose parameter retrieve
 *	@param[in] pname specifies the name of the parameter to retrieve
 *	@param[out] params specifies the address of a variable into which will be written the value or
 *		values of pname for pipeline
 */
extern void (GLApi *GLFuncPtrName(glGetProgramPipelineiv))(GLuint pipeline, GLenum pname, int *params);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1i))(GLuint program, int location, int v0);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2i))(GLuint program, int location, int v0, int v1);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3i))(GLuint program, int location, int v0, int v1, int v2);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4i))(GLuint program, int location, int v0, int v1, int v2, int v3);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1ui))(GLuint program, int location, GLuint v0);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2ui))(GLuint program, int location, GLuint v0, GLuint v1);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3ui))(GLuint program, int location, GLuint v0, GLuint v1, GLuint v2);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4ui))(GLuint program, int location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1f))(GLuint program, int location, float v0);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2f))(GLuint program, int location, float v0, float v1);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3f))(GLuint program, int location, float v0, float v1, float v2);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4f))(GLuint program, int location, float v0, float v1, float v2, float v3);
//extern void (GLApi *GLFuncPtrName(glProgramUniform1d))(GLuint program, int location, double v0); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform2d))(GLuint program, int location, double v0, double v1); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform3d))(GLuint program, int location, double v0, double v1, double v2); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform4d))(GLuint program, int location, double v0, double v1, double v2, double v3); // defined above

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1iv))(GLuint program, int location, GLsizei count, const int *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2iv))(GLuint program, int location, GLsizei count, const int *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3iv))(GLuint program, int location, GLsizei count, const int *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4iv))(GLuint program, int location, GLsizei count, const int *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1uiv))(GLuint program, int location, GLsizei count, const GLuint *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2uiv))(GLuint program, int location, GLsizei count, const GLuint *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3uiv))(GLuint program, int location, GLsizei count, const GLuint *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4uiv))(GLuint program, int location, GLsizei count, const GLuint *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform1fv))(GLuint program, int location, GLsizei count, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform2fv))(GLuint program, int location, GLsizei count, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform3fv))(GLuint program, int location, GLsizei count, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniform4fv))(GLuint program, int location, GLsizei count, const float *value);
//extern void (GLApi *GLFuncPtrName(glProgramUniform1dv))(GLuint program, int location, GLsizei count, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform2dv))(GLuint program, int location, GLsizei count, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform3dv))(GLuint program, int location, GLsizei count, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniform4dv))(GLuint program, int location, GLsizei count, const double *value); // defined above

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x3fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x2fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x4fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x2fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x4fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);

/**
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x3fv))(GLuint program, int location, GLsizei count, GLboolean transpose, const float *value);
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x2dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x4dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above
//extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x3dv))(GLuint program, int location, GLsizei count, GLboolean transpose, const double *value); // defined above

/**
 *	@brief validate a program pipeline object against current GL state
 *	@param[in] pipeline specifies the name of a program pipeline object to validate
 */
extern void (GLApi *GLFuncPtrName(glValidateProgramPipeline))(GLuint pipeline);

/**
 *	@brief retrieve the info log string from a program pipeline object
 *	@param[in] pipeline specifies the name of a program pipeline object from which to retrieve the
 *		info log
 *	@param[in] bufSize specifies the maximum number of characters, including the null terminator,
 *		that may be written into infoLog
 *	@param[out] length specifies the address of a variable into which will be written the number of
 *		characters written into infoLog
 *	@param[out] infoLog specifies the address of an array of characters into which will be written
 *		the info log for pipeline
 */
extern void (GLApi *GLFuncPtrName(glGetProgramPipelineInfoLog))(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);

inline GLuint glCreateShaderProgramv_glachwrap(GLenum type, GLsizei count, const GLchar **strings, const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glCreateShaderProgramv)(type,count,strings); GL_AUTOCHECK_BLOCK("glCreateShaderProgramv", p_s_filename, n_line); return result; }
inline GLboolean glIsProgramPipeline_glachwrap(GLuint pipeline, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsProgramPipeline)(pipeline); GL_AUTOCHECK_BLOCK("glIsProgramPipeline", p_s_filename, n_line); return result; }

/**
 *	@def glUseProgramStages
 *	@brief bind stages of a program object to a program pipeline
 *	@param[in] pipeline specifies the program pipeline object to which to bind stages from program
 *	@param[in] stages specifies a set of program stages to bind to the program pipeline object
 *	@param[in] program specifies the program object containing the shader executables to use in pipeline
 */
#define glUseProgramStages(pipeline,stages,program) do { GLFuncPtrName(glUseProgramStages)(pipeline, stages, program); GL_AUTOCHECK_BLOCK("glUseProgramStages", __FILE__, __LINE__); } while(0)

/**
 *	@def glActiveShaderProgram
 *	@brief set the active program object for a program pipeline object
 *	@param[in] pipeline specifies the program pipeline object to set the active program object for
 *	@param[in] program specifies the program object to set as the active program pipeline object pipeline
 */
#define glActiveShaderProgram(pipeline,program) do { GLFuncPtrName(glActiveShaderProgram)(pipeline, program); GL_AUTOCHECK_BLOCK("glActiveShaderProgram", __FILE__, __LINE__); } while(0)

/**
 *	@def glCreateShaderProgramv
 *	@brief create a stand-alone program from an array of null-terminated source code strings
 *	@param[in] type specifies the type of shader to create
 *	@param[in] count specifies the number of source code strings in the array strings
 *	@param[in] strings specifies the address of an array of pointers to source code strings from
 *		which to create the program object
 */
#define glCreateShaderProgramv(type,count,strings) GLAutoCheckFuncPtrName(glCreateShaderProgramv)(type, count, strings GLAutoCheckExtraParams)

/**
 *	@def glBindProgramPipeline
 *	@brief bind a program pipeline to the current context
 *	@param[in] pipeline specifies the name of the pipeline object to bind to the context
 */
#define glBindProgramPipeline(pipeline) do { GLFuncPtrName(glBindProgramPipeline)(pipeline); GL_AUTOCHECK_BLOCK("glBindProgramPipeline", __FILE__, __LINE__); } while(0)

/**
 *	@def glDeleteProgramPipelines
 *	@brief delete program pipeline objects
 *	@param[in] n specifies the number of program pipeline objects to delete
 *	@param[in] pipelines specifies an array of names of program pipeline objects to delete
 */
#define glDeleteProgramPipelines(n,pipelines) do { GLFuncPtrName(glDeleteProgramPipelines)(n, pipelines); GL_AUTOCHECK_BLOCK("glDeleteProgramPipelines", __FILE__, __LINE__); } while(0)

/**
 *	@def glGenProgramPipelines
 *	@brief reserve program pipeline object names
 *	@param[in] n specifies the number of program pipeline object names to reserve
 *	@param[out] pipelines specifies an array of into which the reserved names will be written
 */
#define glGenProgramPipelines(n,pipelines) do { GLFuncPtrName(glGenProgramPipelines)(n, pipelines); GL_AUTOCHECK_BLOCK("glGenProgramPipelines", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsProgramPipeline
 *	@brief determine if a name corresponds to a program pipeline object
 *	@param[in] pipeline specifies a value that may be the name of a program pipeline object
 */
#define glIsProgramPipeline(pipeline) GLAutoCheckFuncPtrName(glIsProgramPipeline)(pipeline GLAutoCheckExtraParams)
//#define glProgramParameteri(program,pname,value) do { GLFuncPtrName(glProgramParameteri)(program, pname, value); GL_AUTOCHECK_BLOCK("glProgramParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetProgramPipelineiv
 *	@brief retrieve properties of a program pipeline object
 *	@param[in] pipeline specifies the name of a program pipeline object whose parameter retrieve
 *	@param[in] pname specifies the name of the parameter to retrieve
 *	@param[out] params specifies the address of a variable into which will be written the value or
 *		values of pname for pipeline
 */
#define glGetProgramPipelineiv(pipeline,pname,params) do { GLFuncPtrName(glGetProgramPipelineiv)(pipeline, pname, params); GL_AUTOCHECK_BLOCK("glGetProgramPipelineiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1i
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform1i(program,location,v0) do { GLFuncPtrName(glProgramUniform1i)(program, location, v0); GL_AUTOCHECK_BLOCK("glProgramUniform1i", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2i
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform2i(program,location,v0,v1) do { GLFuncPtrName(glProgramUniform2i)(program, location, v0, v1); GL_AUTOCHECK_BLOCK("glProgramUniform2i", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3i
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform3i(program,location,v0,v1,v2) do { GLFuncPtrName(glProgramUniform3i)(program, location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glProgramUniform3i", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4i
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform4i(program,location,v0,v1,v2,v3) do { GLFuncPtrName(glProgramUniform4i)(program, location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glProgramUniform4i", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1ui
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform1ui(program,location,v0) do { GLFuncPtrName(glProgramUniform1ui)(program, location, v0); GL_AUTOCHECK_BLOCK("glProgramUniform1ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2ui
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform2ui(program,location,v0,v1) do { GLFuncPtrName(glProgramUniform2ui)(program, location, v0, v1); GL_AUTOCHECK_BLOCK("glProgramUniform2ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3ui
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform3ui(program,location,v0,v1,v2) do { GLFuncPtrName(glProgramUniform3ui)(program, location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glProgramUniform3ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4ui
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform4ui(program,location,v0,v1,v2,v3) do { GLFuncPtrName(glProgramUniform4ui)(program, location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glProgramUniform4ui", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1f
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform1f(program,location,v0) do { GLFuncPtrName(glProgramUniform1f)(program, location, v0); GL_AUTOCHECK_BLOCK("glProgramUniform1f", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2f
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform2f(program,location,v0,v1) do { GLFuncPtrName(glProgramUniform2f)(program, location, v0, v1); GL_AUTOCHECK_BLOCK("glProgramUniform2f", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3f
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform3f(program,location,v0,v1,v2) do { GLFuncPtrName(glProgramUniform3f)(program, location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glProgramUniform3f", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4f
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform variable to be modified
 *	@param[in] v0 specifies the new values to be used for the specified uniform variable
 *	@param[in] v1 specifies the new values to be used for the specified uniform variable
 *	@param[in] v2 specifies the new values to be used for the specified uniform variable
 *	@param[in] v3 specifies the new values to be used for the specified uniform variable
 */
#define glProgramUniform4f(program,location,v0,v1,v2,v3) do { GLFuncPtrName(glProgramUniform4f)(program, location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glProgramUniform4f", __FILE__, __LINE__); } while(0)
//#define glProgramUniform1d(program,location,v0) do { GLFuncPtrName(glProgramUniform1d)(program, location, v0); GL_AUTOCHECK_BLOCK("glProgramUniform1d", __FILE__, __LINE__); } while(0)
//#define glProgramUniform2d(program,location,v0,v1) do { GLFuncPtrName(glProgramUniform2d)(program, location, v0, v1); GL_AUTOCHECK_BLOCK("glProgramUniform2d", __FILE__, __LINE__); } while(0)
//#define glProgramUniform3d(program,location,v0,v1,v2) do { GLFuncPtrName(glProgramUniform3d)(program, location, v0, v1, v2); GL_AUTOCHECK_BLOCK("glProgramUniform3d", __FILE__, __LINE__); } while(0)
//#define glProgramUniform4d(program,location,v0,v1,v2,v3) do { GLFuncPtrName(glProgramUniform4d)(program, location, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glProgramUniform4d", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1iv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform1iv(program,location,count,value) do { GLFuncPtrName(glProgramUniform1iv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform1iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2iv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform2iv(program,location,count,value) do { GLFuncPtrName(glProgramUniform2iv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform2iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3iv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform3iv(program,location,count,value) do { GLFuncPtrName(glProgramUniform3iv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform3iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4iv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform4iv(program,location,count,value) do { GLFuncPtrName(glProgramUniform4iv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform4iv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1uiv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform1uiv(program,location,count,value) do { GLFuncPtrName(glProgramUniform1uiv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform1uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2uiv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform2uiv(program,location,count,value) do { GLFuncPtrName(glProgramUniform2uiv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform2uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3uiv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform3uiv(program,location,count,value) do { GLFuncPtrName(glProgramUniform3uiv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform3uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4uiv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform4uiv(program,location,count,value) do { GLFuncPtrName(glProgramUniform4uiv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform4uiv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform1fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform1fv(program,location,count,value) do { GLFuncPtrName(glProgramUniform1fv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform1fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform2fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform2fv(program,location,count,value) do { GLFuncPtrName(glProgramUniform2fv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform3fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform3fv(program,location,count,value) do { GLFuncPtrName(glProgramUniform3fv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniform4fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of elements that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array, and 1 or more if it is an array
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniform4fv(program,location,count,value) do { GLFuncPtrName(glProgramUniform4fv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform4fv", __FILE__, __LINE__); } while(0)
//#define glProgramUniform1dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform1dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform1dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniform2dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform2dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform2dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniform3dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform3dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform3dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniform4dv(program,location,count,value) do { GLFuncPtrName(glProgramUniform4dv)(program, location, count, value); GL_AUTOCHECK_BLOCK("glProgramUniform4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4fv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2x3fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2x3fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x3fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x3fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3x2fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3x2fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x2fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix2x4fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix2x4fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x4fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4x2fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4x2fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x2fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x2fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix3x4fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix3x4fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x4fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x4fv", __FILE__, __LINE__); } while(0)

/**
 *	@def glProgramUniformMatrix4x3fv
 *	@brief specify the value of a uniform variable for a specified program object
 *	@param[in] program specifies the handle of the program containing the uniform variable to be modified
 *	@param[in] location specifies the location of the uniform value to be modified
 *	@param[in] count specifies the number of matrices that are to be modified. This should be 1 if
 *		the targeted uniform variable is not an array of matrices, and 1 or more if it is an array
 *		of matrices
 *	@param[in] transpose specifies whether to transpose the matrix as the values are loaded into the
 *		uniform variable
 *	@param[in] value specifies a pointer to an array of count values that will be used to update the
 *		specified uniform variable
 */
#define glProgramUniformMatrix4x3fv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x3fv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x3fv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix2x3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x3dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix3x2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x2dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix2x4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix2x4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix2x4dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix4x2dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x2dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x2dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix3x4dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix3x4dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix3x4dv", __FILE__, __LINE__); } while(0)
//#define glProgramUniformMatrix4x3dv(program,location,count,transpose,value) do { GLFuncPtrName(glProgramUniformMatrix4x3dv)(program, location, count, transpose, value); GL_AUTOCHECK_BLOCK("glProgramUniformMatrix4x3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glValidateProgramPipeline
 *	@brief validate a program pipeline object against current GL state
 *	@param[in] pipeline specifies the name of a program pipeline object to validate
 */
#define glValidateProgramPipeline(pipeline) do { GLFuncPtrName(glValidateProgramPipeline)(pipeline); GL_AUTOCHECK_BLOCK("glValidateProgramPipeline", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetProgramPipelineInfoLog
 *	@brief retrieve the info log string from a program pipeline object
 *	@param[in] pipeline specifies the name of a program pipeline object from which to retrieve the
 *		info log
 *	@param[in] bufSize specifies the maximum number of characters, including the null terminator,
 *		that may be written into infoLog
 *	@param[out] length specifies the address of a variable into which will be written the number of
 *		characters written into infoLog
 *	@param[out] infoLog specifies the address of an array of characters into which will be written
 *		the info log for pipeline
 */
#define glGetProgramPipelineInfoLog(pipeline,bufSize,length,infoLog) do { GLFuncPtrName(glGetProgramPipelineInfoLog)(pipeline, bufSize, length, infoLog); GL_AUTOCHECK_BLOCK("glGetProgramPipelineInfoLog", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_separate_shader_objects

//								--- ~GL_ARB_separate_shader_objects (part of OpenGL 4.1 core) ---

//								--- GL_ARB_shader_precision (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_shader_precision
 *	@brief if defined, GL_ARB_shader_precision (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_shader_precision
#define GL_ARB_shader_precision 1

extern bool GLEH_ARB_shader_precision; /**< @brief set if GL_ARB_shader_precision is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_shader_precision

//								--- ~GL_ARB_shader_precision (part of OpenGL 4.1 core) ---

//								--- GL_ARB_vertex_attrib_64bit (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_vertex_attrib_64bit
 *	@brief if defined, GL_ARB_vertex_attrib_64bit (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_vertex_attrib_64bit
#define GL_ARB_vertex_attrib_64bit 1

/**
 *	@def __GENERATE_GL_ARB_vertex_attrib_64bit
 *	@brief if defined, code to initialize GL_ARB_vertex_attrib_64bit (part of OpenGL 4.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_vertex_attrib_64bit

extern bool GLEH_ARB_vertex_attrib_64bit; /**< @brief set if GL_ARB_vertex_attrib_64bit is supported */

//#define GL_DOUBLE_VEC2											  0x8ffc // (defined above)
//#define GL_DOUBLE_VEC3											  0x8ffd // (defined above)
//#define GL_DOUBLE_VEC4											  0x8ffe // (defined above)
//#define GL_DOUBLE_MAT2											  0x8f46 // (defined above)
//#define GL_DOUBLE_MAT3											  0x8f47 // (defined above)
//#define GL_DOUBLE_MAT4											  0x8f48 // (defined above)
//#define GL_DOUBLE_MAT2x3											  0x8f49 // (defined above)
//#define GL_DOUBLE_MAT2x4											  0x8f4a // (defined above)
//#define GL_DOUBLE_MAT3x2											  0x8f4b // (defined above)
//#define GL_DOUBLE_MAT3x4											  0x8f4c // (defined above)
//#define GL_DOUBLE_MAT4x2											  0x8f4d // (defined above)
//#define GL_DOUBLE_MAT4x3											  0x8f4e // (defined above)

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL1d))(GLuint index, double v0);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL2d))(GLuint index, double v0, double v1);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v2 specifies the new values to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL3d))(GLuint index, double v0, double v1, double v2);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v2 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v3 specifies the new values to be used for the specified vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL4d))(GLuint index, double v0, double v1, double v2, double v3);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL1dv))(GLuint index, const double *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL2dv))(GLuint index, const double *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL3dv))(GLuint index, const double *v);

/**
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribL4dv))(GLuint index, const double *v);

/**
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] size specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4
 *	@param[in] type specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT
 *	@param[in] stride specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0
 *	@param[in] pointer specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0
 */
extern void (GLApi *GLFuncPtrName(glVertexAttribLPointer))(GLuint index, int size, GLenum type, GLsizei stride, const void *pointer);

/**
 *	@brief return a generic vertex attribute parameter
 *	@param[in] index specifies the generic vertex attribute parameter to be queried
 *	@param[in] pname specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB
 *	@param[out] params returns the requested data
 */
extern void (GLApi *GLFuncPtrName(glGetVertexAttribLdv))(GLuint index, GLenum pname, double *params);
//extern void (GLApi *GLFuncPtrName(glVertexArrayVertexAttribLOffsetEXT))(GLuint vaobj, GLuint buffer, GLuint index, int size, GLenum type, GLsizei stride, GLintptr offset); // deprecated as of OpenGL 4.5 (in favor of ARB_direct_state_access)

/**
 *	@def glVertexAttribL1d
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 */
#define glVertexAttribL1d(index,v0) do { GLFuncPtrName(glVertexAttribL1d)(index, v0); GL_AUTOCHECK_BLOCK("glVertexAttribL1d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL2d
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 */
#define glVertexAttribL2d(index,v0,v1) do { GLFuncPtrName(glVertexAttribL2d)(index, v0, v1); GL_AUTOCHECK_BLOCK("glVertexAttribL2d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL3d
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v2 specifies the new values to be used for the specified vertex attribute
 */
#define glVertexAttribL3d(index,v0,v1,v2) do { GLFuncPtrName(glVertexAttribL3d)(index, v0, v1, v2); GL_AUTOCHECK_BLOCK("glVertexAttribL3d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL4d
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v0 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v1 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v2 specifies the new values to be used for the specified vertex attribute
 *	@param[in] v3 specifies the new values to be used for the specified vertex attribute
 */
#define glVertexAttribL4d(index,v0,v1,v2,v3) do { GLFuncPtrName(glVertexAttribL4d)(index, v0, v1, v2, v3); GL_AUTOCHECK_BLOCK("glVertexAttribL4d", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL1dv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribL1dv(index,v) do { GLFuncPtrName(glVertexAttribL1dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribL1dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL2dv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribL2dv(index,v) do { GLFuncPtrName(glVertexAttribL2dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribL2dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL3dv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribL3dv(index,v) do { GLFuncPtrName(glVertexAttribL3dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribL3dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribL4dv
 *	@brief specifies the value of a generic vertex attribute
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] v specifies a pointer to an array of values to be used for the generic vertex attribute
 */
#define glVertexAttribL4dv(index,v) do { GLFuncPtrName(glVertexAttribL4dv)(index, v); GL_AUTOCHECK_BLOCK("glVertexAttribL4dv", __FILE__, __LINE__); } while(0)

/**
 *	@def glVertexAttribLPointer
 *	@brief define an array of generic vertex attribute data
 *	@param[in] index specifies the index of the generic vertex attribute to be modified
 *	@param[in] size specifies the number of components per generic vertex attribute. Must be 1, 2,
 *		3, 4. Additionally, the symbolic constant GL_BGRA is accepted by glVertexAttribPointer. The
 *		initial value is 4
 *	@param[in] type specifies the data type of each component in the array. The symbolic constants
 *		GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, and GL_UNSIGNED_INT are
 *		accepted by both functions. Additionally GL_HALF_FLOAT, GL_FLOAT, GL_DOUBLE, GL_FIXED,
 *		GL_INT_2_10_10_10_REV, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted by
 *		glVertexAttribPointer. The initial value is GL_FLOAT
 *	@param[in] stride specifies the byte offset between consecutive generic vertex attributes. If
 *		stride is 0, the generic vertex attributes are understood to be tightly packed in the array.
 *		The initial value is 0
 *	@param[in] pointer specifies a offset of the first component of the first generic vertex
 *		attribute in the array in the data store of the buffer currently bound to the
 *		GL_ARRAY_BUFFER target. The initial value is 0
 */
#define glVertexAttribLPointer(index,size,type,stride,pointer) do { GLFuncPtrName(glVertexAttribLPointer)(index, size, type, stride, pointer); GL_AUTOCHECK_BLOCK("glVertexAttribLPointer", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetVertexAttribLdv
 *	@brief return a generic vertex attribute parameter
 *	@param[in] index specifies the generic vertex attribute parameter to be queried
 *	@param[in] pname specifies the symbolic name of the vertex attribute parameter to be queried.
 *		Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED,
 *		GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE,
 *		GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, GL_VERTEX_ATTRIB_ARRAY_INTEGER,
 *		GL_VERTEX_ATTRIB_ARRAY_DIVISOR, or GL_CURRENT_VERTEX_ATTRIB
 *	@param[out] params returns the requested data
 */
#define glGetVertexAttribLdv(index,pname,params) do { GLFuncPtrName(glGetVertexAttribLdv)(index, pname, params); GL_AUTOCHECK_BLOCK("glGetVertexAttribLdv", __FILE__, __LINE__); } while(0)
//#define glVertexArrayVertexAttribLOffsetEXT(vaobj,buffer,index,size,type,stride,offset) do { GLFuncPtrName(glVertexArrayVertexAttribLOffsetEXT)(vaobj, buffer, index, size, type, stride, offset); GL_AUTOCHECK_BLOCK("glVertexArrayVertexAttribLOffsetEXT", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_vertex_attrib_64bit

//								--- ~GL_ARB_vertex_attrib_64bit (part of OpenGL 4.1 core) ---

//								--- GL_ARB_viewport_array (part of OpenGL 4.1 core) ---

/**
 *	@def GL_ARB_viewport_array
 *	@brief if defined, GL_ARB_viewport_array (part of OpenGL 4.1 core) entry points are available
 */
#ifndef GL_ARB_viewport_array
#define GL_ARB_viewport_array 1

/**
 *	@def __GENERATE_GL_ARB_viewport_array
 *	@brief if defined, code to initialize GL_ARB_viewport_array (part of OpenGL 4.1 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_viewport_array

extern bool GLEH_ARB_viewport_array; /**< @brief set if GL_ARB_viewport_array is supported */

#define GL_MAX_VIEWPORTS											0x825b /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/
#define GL_VIEWPORT_SUBPIXEL_BITS									0x825c /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/
#define GL_VIEWPORT_BOUNDS_RANGE									0x825d /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/
#define GL_LAYER_PROVOKING_VERTEX									0x825e /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/
#define GL_VIEWPORT_INDEX_PROVOKING_VERTEX							0x825f /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/
//#define GL_SCISSOR_BOX											  0x0c10 // (defined above)
//#define GL_VIEWPORT												  0x0ba2 // (defined above)
//#define GL_DEPTH_RANGE											  0x0b70 // (defined above)
//#define GL_SCISSOR_TEST											  0x0c11 // (defined above)
//#define GL_FIRST_VERTEX_CONVENTION								  0x8e4d // (defined above)
//#define GL_LAST_VERTEX_CONVENTION									  0x8e4e // (defined above)
//#define GL_PROVOKING_VERTEX										  0x8e4f // (defined above)
#define GL_UNDEFINED_VERTEX											0x8260 /**< @brief GL_ARB_viewport_array (part of OpenGL 4.1 core) enum **/

/**
 *	@brief set multiple viewports
 *	@param[in] first specify the first viewport to set
 *	@param[in] count specify the number of viewports to set
 *	@param[in] v specify the address of an array containing the viewport parameters
 */
extern void (GLApi *GLFuncPtrName(glViewportArrayv))(GLuint first, GLsizei count, const float *v);

/**
 *	@brief set a specified viewport
 *	@param[in] index specify the first viewport to set
 *	@param[in] x for glViewportIndexedf, specifies the lower left corner of the viewport rectangle,
 *		in pixels. The initial value is (0,0)
 *	@param[in] y for glViewportIndexedf, specifies the lower left corner of the viewport rectangle,
 *		in pixels. The initial value is (0,0)
 *	@param[in] w for glViewportIndexedf, specifies the width and height of the viewport. When a GL
 *		context is first attached to a window, width and height are set to the dimensions of that window
 *	@param[in] h for glViewportIndexedf, specifies the width and height of the viewport. When a GL
 *		context is first attached to a window, width and height are set to the dimensions of that window
 */
extern void (GLApi *GLFuncPtrName(glViewportIndexedf))(GLuint index, float x, float y, float w, float h);

/**
 *	@brief set a specified viewport
 *	@param[in] index specify the first viewport to set
 *	@param[in] v for glViewportIndexedfv, specifies the address of an array containing the viewport parameters
 */
extern void (GLApi *GLFuncPtrName(glViewportIndexedfv))(GLuint index, const float *v);

/**
 *	@brief define the scissor box for multiple viewports
 *	@param[in] first specifies the index of the first viewport whose scissor box to modify
 *	@param[in] count specifies the number of scissor boxes to modify
 *	@param[in] v specifies the address of an array containing the left, bottom, width and height of
 *		each scissor box, in that order
 */
extern void (GLApi *GLFuncPtrName(glScissorArrayv))(GLuint first, GLsizei count, const int *v);

/**
 *	@brief define the scissor box for a specific viewport
 *	@param[in] index specifies the index of the viewport whose scissor box to modify
 *	@param[in] left specify the coordinate of the bottom left corner of the scissor box, in pixels
 *	@param[in] bottom specify the coordinate of the bottom left corner of the scissor box, in pixels
 *	@param[in] width specify ths dimensions of the scissor box, in pixels
 *	@param[in] height specify ths dimensions of the scissor box, in pixels
 */
extern void (GLApi *GLFuncPtrName(glScissorIndexed))(GLuint index, int left, int bottom, GLsizei width, GLsizei height);

/**
 *	@brief define the scissor box for a specific viewport
 *	@param[in] index specifies the index of the viewport whose scissor box to modify
 *	@param[in] v for glScissorIndexedv, specifies the address of an array containing the left,
 *		bottom, width and height of each scissor box, in that order
 */
extern void (GLApi *GLFuncPtrName(glScissorIndexedv))(GLuint index, const int *v);

/**
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
 *	@param[in] first specifies the index of the first viewport whose depth range to update
 *	@param[in] count specifies the number of viewports whose depth range to update
 *	@param[in] v specifies the address of an array containing the near and far values for the depth
 *		range of each modified viewport
 */
extern void (GLApi *GLFuncPtrName(glDepthRangeArrayv))(GLuint first, GLsizei count, const GLclampd *v);

/**
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates for a specified viewport
 *	@param[in] index specifies the index of the viewport whose depth range to update
 *	@param[in] nearVal specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0
 *	@param[in] farVal specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1
 */
extern void (GLApi *GLFuncPtrName(glDepthRangeIndexed))(GLuint index, GLclampd nearVal, GLclampd farVal);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
extern void (GLApi *GLFuncPtrName(glGetFloati_v))(GLenum pname, GLuint index, float *data);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
extern void (GLApi *GLFuncPtrName(glGetDoublei_v))(GLenum pname, GLuint index, double *data);

/**
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexediv))(GLenum pname, GLuint index, int *data);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the swtich to enable
 */
extern void (GLApi *GLFuncPtrName(glEnableIndexed))(GLenum cap, GLuint index);

/**
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the swtich to disable
 */
extern void (GLApi *GLFuncPtrName(glDisableIndexed))(GLenum cap, GLuint index);

/**
 *	@brief test whether a capability is enabled
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the capability
 */
extern GLboolean (GLApi *GLFuncPtrName(glIsEnabledIndexed))(GLenum cap, GLuint index);

inline GLboolean glIsEnabledIndexed_glachwrap(GLenum cap, GLuint index, const char *p_s_filename, int n_line) { GLboolean result = GLFuncPtrName(glIsEnabledIndexed)(cap,index); GL_AUTOCHECK_BLOCK("glIsEnabledIndexed", p_s_filename, n_line); return result; }

/**
 *	@def glViewportArrayv
 *	@brief set multiple viewports
 *	@param[in] first specify the first viewport to set
 *	@param[in] count specify the number of viewports to set
 *	@param[in] v specify the address of an array containing the viewport parameters
 */
#define glViewportArrayv(first,count,v) do { GLFuncPtrName(glViewportArrayv)(first, count, v); GL_AUTOCHECK_BLOCK("glViewportArrayv", __FILE__, __LINE__); } while(0)

/**
 *	@def glViewportIndexedf
 *	@brief set a specified viewport
 *	@param[in] index specify the first viewport to set
 *	@param[in] x for glViewportIndexedf, specifies the lower left corner of the viewport rectangle,
 *		in pixels. The initial value is (0,0)
 *	@param[in] y for glViewportIndexedf, specifies the lower left corner of the viewport rectangle,
 *		in pixels. The initial value is (0,0)
 *	@param[in] w for glViewportIndexedf, specifies the width and height of the viewport. When a GL
 *		context is first attached to a window, width and height are set to the dimensions of that window
 *	@param[in] h for glViewportIndexedf, specifies the width and height of the viewport. When a GL
 *		context is first attached to a window, width and height are set to the dimensions of that window
 */
#define glViewportIndexedf(index,x,y,w,h) do { GLFuncPtrName(glViewportIndexedf)(index, x, y, w, h); GL_AUTOCHECK_BLOCK("glViewportIndexedf", __FILE__, __LINE__); } while(0)

/**
 *	@def glViewportIndexedfv
 *	@brief set a specified viewport
 *	@param[in] index specify the first viewport to set
 *	@param[in] v for glViewportIndexedfv, specifies the address of an array containing the viewport parameters
 */
#define glViewportIndexedfv(index,v) do { GLFuncPtrName(glViewportIndexedfv)(index, v); GL_AUTOCHECK_BLOCK("glViewportIndexedfv", __FILE__, __LINE__); } while(0)

/**
 *	@def glScissorArrayv
 *	@brief define the scissor box for multiple viewports
 *	@param[in] first specifies the index of the first viewport whose scissor box to modify
 *	@param[in] count specifies the number of scissor boxes to modify
 *	@param[in] v specifies the address of an array containing the left, bottom, width and height of
 *		each scissor box, in that order
 */
#define glScissorArrayv(first,count,v) do { GLFuncPtrName(glScissorArrayv)(first, count, v); GL_AUTOCHECK_BLOCK("glScissorArrayv", __FILE__, __LINE__); } while(0)

/**
 *	@def glScissorIndexed
 *	@brief define the scissor box for a specific viewport
 *	@param[in] index specifies the index of the viewport whose scissor box to modify
 *	@param[in] left specify the coordinate of the bottom left corner of the scissor box, in pixels
 *	@param[in] bottom specify the coordinate of the bottom left corner of the scissor box, in pixels
 *	@param[in] width specify ths dimensions of the scissor box, in pixels
 *	@param[in] height specify ths dimensions of the scissor box, in pixels
 */
#define glScissorIndexed(index,left,bottom,width,height) do { GLFuncPtrName(glScissorIndexed)(index, left, bottom, width, height); GL_AUTOCHECK_BLOCK("glScissorIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glScissorIndexedv
 *	@brief define the scissor box for a specific viewport
 *	@param[in] index specifies the index of the viewport whose scissor box to modify
 *	@param[in] v for glScissorIndexedv, specifies the address of an array containing the left,
 *		bottom, width and height of each scissor box, in that order
 */
#define glScissorIndexedv(index,v) do { GLFuncPtrName(glScissorIndexedv)(index, v); GL_AUTOCHECK_BLOCK("glScissorIndexedv", __FILE__, __LINE__); } while(0)

/**
 *	@def glDepthRangeArrayv
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
 *	@param[in] first specifies the index of the first viewport whose depth range to update
 *	@param[in] count specifies the number of viewports whose depth range to update
 *	@param[in] v specifies the address of an array containing the near and far values for the depth
 *		range of each modified viewport
 */
#define glDepthRangeArrayv(first,count,v) do { GLFuncPtrName(glDepthRangeArrayv)(first, count, v); GL_AUTOCHECK_BLOCK("glDepthRangeArrayv", __FILE__, __LINE__); } while(0)

/**
 *	@def glDepthRangeIndexed
 *	@brief specify mapping of depth values from normalized device coordinates to window coordinates for a specified viewport
 *	@param[in] index specifies the index of the viewport whose depth range to update
 *	@param[in] nearVal specifies the mapping of the near clipping plane to window coordinates. The
 *		initial value is 0
 *	@param[in] farVal specifies the mapping of the far clipping plane to window coordinates. The
 *		initial value is 1
 */
#define glDepthRangeIndexed(index,nearVal,farVal) do { GLFuncPtrName(glDepthRangeIndexed)(index, nearVal, farVal); GL_AUTOCHECK_BLOCK("glDepthRangeIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFloati_v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
#define glGetFloati_v(pname,index,data) do { GLFuncPtrName(glGetFloati_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetFloati_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetDoublei_v
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
#define glGetDoublei_v(pname,index,data) do { GLFuncPtrName(glGetDoublei_v)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetDoublei_v", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetIntegerIndexediv
 *	@brief return the value or values of a selected parameter
 *	@param[in] pname specifies the parameter value to be returned. The symbolic constants in the
 *		list below are accepted
 *	@param[in] index specifies the index of the particular element being queried
 *	@param[out] data returns the value or values of the specified parameter
 */
#define glGetIntegerIndexediv(pname,index,data) do { GLFuncPtrName(glGetIntegerIndexediv)(pname, index, data); GL_AUTOCHECK_BLOCK("glGetIntegerIndexediv", __FILE__, __LINE__); } while(0)

/**
 *	@def glEnableIndexed
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the swtich to enable
 */
#define glEnableIndexed(cap,index) do { GLFuncPtrName(glEnableIndexed)(cap, index); GL_AUTOCHECK_BLOCK("glEnableIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glDisableIndexed
 *	@brief enable or disable server-side GL capabilities
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the swtich to disable
 */
#define glDisableIndexed(cap,index) do { GLFuncPtrName(glDisableIndexed)(cap, index); GL_AUTOCHECK_BLOCK("glDisableIndexed", __FILE__, __LINE__); } while(0)

/**
 *	@def glIsEnabledIndexed
 *	@brief test whether a capability is enabled
 *	@param[in] cap specifies a symbolic constant indicating a GL capability
 *	@param[in] index specifies the index of the capability
 */
#define glIsEnabledIndexed(cap,index) GLAutoCheckFuncPtrName(glIsEnabledIndexed)(cap, index GLAutoCheckExtraParams)

#endif // !GL_ARB_viewport_array

//								--- ~GL_ARB_viewport_array (part of OpenGL 4.1 core) ---

//								--- OpenGL 4.2 ---

/**
 *	@def GL_VERSION_4_2
 *	@brief if defined, OpenGL 4.2 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_4_2
#define GL_VERSION_4_2 1

/**
 *	@def __GENERATE_GL_42__
 *	@brief if defined, code to initialize OpenGL 4.2 entry points is compiled
 */
#define __GENERATE_GL_42__

extern bool GLEH_OPENGL_4_2; /**< @brief set if OpenGL 4.2 is supported */

#endif // !GL_VERSION_4_2

//								--- ~OpenGL 4.2 ---

//								--- GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_texture_compression_bptc
 *	@brief if defined, GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_texture_compression_bptc
#define GL_ARB_texture_compression_bptc 1

extern bool GLEH_ARB_texture_compression_bptc; /**< @brief set if GL_ARB_texture_compression_bptc is supported */

#define GL_COMPRESSED_RGBA_BPTC_UNORM								0x8e8c /**< @brief GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) enum **/
#define GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM							0x8e8d /**< @brief GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) enum **/
#define GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT							0x8e8e /**< @brief GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) enum **/
#define GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT						0x8e8f /**< @brief GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_texture_compression_bptc

//								--- ~GL_ARB_texture_compression_bptc (part of OpenGL 4.2 core) ---

//								--- GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_compressed_texture_pixel_storage
 *	@brief if defined, GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_compressed_texture_pixel_storage
#define GL_ARB_compressed_texture_pixel_storage 1

extern bool GLEH_ARB_compressed_texture_pixel_storage; /**< @brief set if GL_ARB_compressed_texture_pixel_storage is supported */

#define GL_UNPACK_COMPRESSED_BLOCK_WIDTH							0x9127 /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_UNPACK_COMPRESSED_BLOCK_HEIGHT							0x9128 /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_UNPACK_COMPRESSED_BLOCK_DEPTH							0x9129 /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_UNPACK_COMPRESSED_BLOCK_SIZE								0x912a /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_PACK_COMPRESSED_BLOCK_WIDTH								0x912b /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_PACK_COMPRESSED_BLOCK_HEIGHT								0x912c /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_PACK_COMPRESSED_BLOCK_DEPTH								0x912d /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/
#define GL_PACK_COMPRESSED_BLOCK_SIZE								0x912e /**< @brief GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_compressed_texture_pixel_storage

//								--- ~GL_ARB_compressed_texture_pixel_storage (part of OpenGL 4.2 core) ---

//								--- GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_shader_atomic_counters
 *	@brief if defined, GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_shader_atomic_counters
#define GL_ARB_shader_atomic_counters 1

/**
 *	@def __GENERATE_GL_ARB_shader_atomic_counters
 *	@brief if defined, code to initialize GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_shader_atomic_counters

extern bool GLEH_ARB_shader_atomic_counters; /**< @brief set if GL_ARB_shader_atomic_counters is supported */

#define GL_ATOMIC_COUNTER_BUFFER									0x92c0 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_BINDING							0x92c1 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_START								0x92c2 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_SIZE								0x92c3 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE							0x92c4 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS				0x92c5 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES		0x92c6 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER		0x92c7 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER	0x92c8 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER 0x92c9 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER		0x92ca /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER		0x92cb /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS						0x92cc /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS					0x92cd /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS				0x92ce /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS						0x92cf /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS						0x92d0 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS						0x92d1 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_VERTEX_ATOMIC_COUNTERS								0x92d2 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS							0x92d3 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS						0x92d4 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_GEOMETRY_ATOMIC_COUNTERS								0x92d5 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_FRAGMENT_ATOMIC_COUNTERS								0x92d6 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_COMBINED_ATOMIC_COUNTERS								0x92d7 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE							0x92d8 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS						0x92dc /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_ACTIVE_ATOMIC_COUNTER_BUFFERS							0x92d9 /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX						0x92da /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_ATOMIC_COUNTER								0x92db /**< @brief GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) enum **/

/**
 *	@brief retrieve information about the set of active atomic counter buffers for a program
 *	@param[in] program the name of a program object from which to retrieve information
 *	@param[in] bufferIndex specifies index of an active atomic counter buffer
 *	@param[in] pname specifies which parameter of the atomic counter buffer to retrieve
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
extern void (GLApi *GLFuncPtrName(glGetActiveAtomicCounterBufferiv))(GLuint program, GLuint bufferIndex, GLenum pname, int *params);

/**
 *	@def glGetActiveAtomicCounterBufferiv
 *	@brief retrieve information about the set of active atomic counter buffers for a program
 *	@param[in] program the name of a program object from which to retrieve information
 *	@param[in] bufferIndex specifies index of an active atomic counter buffer
 *	@param[in] pname specifies which parameter of the atomic counter buffer to retrieve
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
#define glGetActiveAtomicCounterBufferiv(program,bufferIndex,pname,params) do { GLFuncPtrName(glGetActiveAtomicCounterBufferiv)(program, bufferIndex, pname, params); GL_AUTOCHECK_BLOCK("glGetActiveAtomicCounterBufferiv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_shader_atomic_counters

//								--- ~GL_ARB_shader_atomic_counters (part of OpenGL 4.2 core) ---

//								--- GL_ARB_texture_storage (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_texture_storage
 *	@brief if defined, GL_ARB_texture_storage (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_texture_storage
#define GL_ARB_texture_storage 1

/**
 *	@def __GENERATE_GL_ARB_texture_storage
 *	@brief if defined, code to initialize GL_ARB_texture_storage (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_texture_storage

extern bool GLEH_ARB_texture_storage; /**< @brief set if GL_ARB_texture_storage is supported */

#define GL_TEXTURE_IMMUTABLE_FORMAT									0x912f /**< @brief GL_ARB_texture_storage (part of OpenGL 4.2 core) enum **/
//#define GL_ALPHA8_EXT												  0x803c // deprecated as of OpenGL 3.0 (legacy internal pixel format)
//#define GL_LUMINANCE8_EXT											  0x8040 // deprecated as of OpenGL 3.0 (legacy internal pixel format)
//#define GL_LUMINANCE8_ALPHA8_EXT									  0x8045 // deprecated as of OpenGL 3.0 (legacy internal pixel format)

/**
 *	@brief simultaneously specify storage for all levels of a one-dimensional texture
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTexStorage1D))(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);

/**
 *	@brief simultaneously specify storage for all levels of a two-dimensional or one-dimensional array texture
 *	@param[in] target specify the target of the operation. target must be one of GL_TEXTURE_2D,
 *		GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_PROXY_TEXTURE_RECTANGLE, or GL_PROXY_TEXTURE_CUBE_MAP
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTexStorage2D))(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);

/**
 *	@brief simultaneously specify storage for all levels of a three-dimensional, two-dimensional array or cube-map array texture
 *	@param[in] target specify the target of the operation. target must be one of GL_TEXTURE_3D,
 *		GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_2D_ARRAY, GL_TEXTURE_CUBE_ARRAY,
 *		or GL_PROXY_TEXTURE_CUBE_ARRAY
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 *	@param[in] depth specifies the depth of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTexStorage3D))(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);

/**
 *	@brief simultaneously specify storage for all levels of a one-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTextureStorage1DEXT))(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);

/**
 *	@brief simultaneously specify storage for all levels of a two-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTextureStorage2DEXT))(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);

/**
 *	@brief simultaneously specify storage for all levels of a three-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 *	@param[in] depth specifies the depth of the texture, in texels
 */
extern void (GLApi *GLFuncPtrName(glTextureStorage3DEXT))(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);

/**
 *	@def glTexStorage1D
 *	@brief simultaneously specify storage for all levels of a one-dimensional texture
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 */
#define glTexStorage1D(target,levels,internalformat,width) do { GLFuncPtrName(glTexStorage1D)(target, levels, internalformat, width); GL_AUTOCHECK_BLOCK("glTexStorage1D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexStorage2D
 *	@brief simultaneously specify storage for all levels of a two-dimensional or one-dimensional array texture
 *	@param[in] target specify the target of the operation. target must be one of GL_TEXTURE_2D,
 *		GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_RECTANGLE,
 *		GL_PROXY_TEXTURE_RECTANGLE, or GL_PROXY_TEXTURE_CUBE_MAP
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 */
#define glTexStorage2D(target,levels,internalformat,width,height) do { GLFuncPtrName(glTexStorage2D)(target, levels, internalformat, width, height); GL_AUTOCHECK_BLOCK("glTexStorage2D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTexStorage3D
 *	@brief simultaneously specify storage for all levels of a three-dimensional, two-dimensional array or cube-map array texture
 *	@param[in] target specify the target of the operation. target must be one of GL_TEXTURE_3D,
 *		GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY, GL_PROXY_TEXTURE_2D_ARRAY, GL_TEXTURE_CUBE_ARRAY,
 *		or GL_PROXY_TEXTURE_CUBE_ARRAY
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 *	@param[in] depth specifies the depth of the texture, in texels
 */
#define glTexStorage3D(target,levels,internalformat,width,height,depth) do { GLFuncPtrName(glTexStorage3D)(target, levels, internalformat, width, height, depth); GL_AUTOCHECK_BLOCK("glTexStorage3D", __FILE__, __LINE__); } while(0)

/**
 *	@def glTextureStorage1DEXT
 *	@brief simultaneously specify storage for all levels of a one-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 */
#define glTextureStorage1DEXT(texture,target,levels,internalformat,width) do { GLFuncPtrName(glTextureStorage1DEXT)(texture, target, levels, internalformat, width); GL_AUTOCHECK_BLOCK("glTextureStorage1DEXT", __FILE__, __LINE__); } while(0)

/**
 *	@def glTextureStorage2DEXT
 *	@brief simultaneously specify storage for all levels of a two-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 */
#define glTextureStorage2DEXT(texture,target,levels,internalformat,width,height) do { GLFuncPtrName(glTextureStorage2DEXT)(texture, target, levels, internalformat, width, height); GL_AUTOCHECK_BLOCK("glTextureStorage2DEXT", __FILE__, __LINE__); } while(0)

/**
 *	@def glTextureStorage3DEXT
 *	@brief simultaneously specify storage for all levels of a three-dimensional texture
 *	@param[in] texture specify the texture object of the operation
 *	@param[in] target specify the target of the operation. target must be either GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D
 *	@param[in] levels specify the number of texture levels
 *	@param[in] internalformat specifies the sized internal format to be used to store texture image data
 *	@param[in] width specifies the width of the texture, in texels
 *	@param[in] height specifies the height of the texture, in texels
 *	@param[in] depth specifies the depth of the texture, in texels
 */
#define glTextureStorage3DEXT(texture,target,levels,internalformat,width,height,depth) do { GLFuncPtrName(glTextureStorage3DEXT)(texture, target, levels, internalformat, width, height, depth); GL_AUTOCHECK_BLOCK("glTextureStorage3DEXT", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_texture_storage

//								--- ~GL_ARB_texture_storage (part of OpenGL 4.2 core) ---

//								--- GL_ARB_transform_feedback_instanced (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_transform_feedback_instanced
 *	@brief if defined, GL_ARB_transform_feedback_instanced (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_transform_feedback_instanced
#define GL_ARB_transform_feedback_instanced 1

/**
 *	@def __GENERATE_GL_ARB_transform_feedback_instanced
 *	@brief if defined, code to initialize GL_ARB_transform_feedback_instanced (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_transform_feedback_instanced

extern bool GLEH_ARB_transform_feedback_instanced; /**< @brief set if GL_ARB_transform_feedback_instanced is supported */

// no new tokens

/**
 *	@brief render multiple instances of primitives using a count derived from a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] primcount specifies the number of instances of the geometry to render
 */
extern void (GLApi *GLFuncPtrName(glDrawTransformFeedbackInstanced))(GLenum mode, GLuint id, GLsizei primcount);

/**
 *	@brief render multiple instances of primitives using a count derived from a specifed stream of a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] stream specifies the index of the transform feedback stream from which to retrieve a
 *		primitive count
 *	@param[in] primcount specifies the number of instances of the geometry to render
 */
extern void (GLApi *GLFuncPtrName(glDrawTransformFeedbackStreamInstanced))(GLenum mode, GLuint id, GLuint stream, GLsizei primcount);

/**
 *	@def glDrawTransformFeedbackInstanced
 *	@brief render multiple instances of primitives using a count derived from a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] primcount specifies the number of instances of the geometry to render
 */
#define glDrawTransformFeedbackInstanced(mode,id,primcount) do { GLFuncPtrName(glDrawTransformFeedbackInstanced)(mode, id, primcount); GL_AUTOCHECK_BLOCK("glDrawTransformFeedbackInstanced", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawTransformFeedbackStreamInstanced
 *	@brief render multiple instances of primitives using a count derived from a specifed stream of a transform feedback object
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted
 *	@param[in] id specifies the name of a transform feedback object from which to retrieve a
 *		primitive count
 *	@param[in] stream specifies the index of the transform feedback stream from which to retrieve a
 *		primitive count
 *	@param[in] primcount specifies the number of instances of the geometry to render
 */
#define glDrawTransformFeedbackStreamInstanced(mode,id,stream,primcount) do { GLFuncPtrName(glDrawTransformFeedbackStreamInstanced)(mode, id, stream, primcount); GL_AUTOCHECK_BLOCK("glDrawTransformFeedbackStreamInstanced", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_transform_feedback_instanced

//								--- ~GL_ARB_transform_feedback_instanced (part of OpenGL 4.2 core) ---

//								--- GL_ARB_base_instance (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_base_instance
 *	@brief if defined, GL_ARB_base_instance (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_base_instance
#define GL_ARB_base_instance 1

/**
 *	@def __GENERATE_GL_ARB_base_instance
 *	@brief if defined, code to initialize GL_ARB_base_instance (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_base_instance

extern bool GLEH_ARB_base_instance; /**< @brief set if GL_ARB_base_instance is supported */

// no new tokens

/**
 *	@brief draw multiple instances of a range of elements with offset applied to instanced attributes
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] first specifies the starting index in the enabled arrays
 *	@param[in] count specifies the number of indices to be rendered
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
extern void (GLApi *GLFuncPtrName(glDrawArraysInstancedBaseInstance))(GLenum mode, int first, GLsizei count, GLsizei primcount, GLuint baseinstance);

/**
 *	@brief draw multiple instances of a set of elements with offset applied to instanced attributes
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedBaseInstance))(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, GLuint baseinstance);

/**
 *	@brief render multiple instances of a set of primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the indexed geometry that should be drawn
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedBaseVertexBaseInstance))(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, int basevertex, GLuint baseinstance);

/**
 *	@def glDrawArraysInstancedBaseInstance
 *	@brief draw multiple instances of a range of elements with offset applied to instanced attributes
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] first specifies the starting index in the enabled arrays
 *	@param[in] count specifies the number of indices to be rendered
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
#define glDrawArraysInstancedBaseInstance(mode,first,count,primcount,baseinstance) do { GLFuncPtrName(glDrawArraysInstancedBaseInstance)(mode, first, count, primcount, baseinstance); GL_AUTOCHECK_BLOCK("glDrawArraysInstancedBaseInstance", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElementsInstancedBaseInstance
 *	@brief draw multiple instances of a set of elements with offset applied to instanced attributes
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY,
 *		GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY,
 *		GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the specified range of indices to be rendered
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
#define glDrawElementsInstancedBaseInstance(mode,count,type,indices,primcount,baseinstance) do { GLFuncPtrName(glDrawElementsInstancedBaseInstance)(mode, count, type, indices, primcount, baseinstance); GL_AUTOCHECK_BLOCK("glDrawElementsInstancedBaseInstance", __FILE__, __LINE__); } while(0)

/**
 *	@def glDrawElementsInstancedBaseVertexBaseInstance
 *	@brief render multiple instances of a set of primitives from array data with a per-element offset
 *	@param[in] mode specifies what kind of primitives to render. Symbolic constants GL_POINTS,
 *		GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES,
 *		GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY,
 *		GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted
 *	@param[in] count specifies the number of elements to be rendered
 *	@param[in] type specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE,
 *		GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT
 *	@param[in] indices specifies a pointer to the location where the indices are stored
 *	@param[in] primcount specifies the number of instances of the indexed geometry that should be drawn
 *	@param[in] basevertex specifies a constant that should be added to each element of indices when
 *		chosing elements from the enabled vertex arrays
 *	@param[in] baseinstance specifies the base instance for use in fetching instanced vertex attributes
 */
#define glDrawElementsInstancedBaseVertexBaseInstance(mode,count,type,indices,primcount,basevertex,baseinstance) do { GLFuncPtrName(glDrawElementsInstancedBaseVertexBaseInstance)(mode, count, type, indices, primcount, basevertex, baseinstance); GL_AUTOCHECK_BLOCK("glDrawElementsInstancedBaseVertexBaseInstance", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_base_instance

//								--- ~GL_ARB_base_instance (part of OpenGL 4.2 core) ---

//								--- GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_shader_image_load_store
 *	@brief if defined, GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_shader_image_load_store
#define GL_ARB_shader_image_load_store 1

/**
 *	@def __GENERATE_GL_ARB_shader_image_load_store
 *	@brief if defined, code to initialize GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_shader_image_load_store

extern bool GLEH_ARB_shader_image_load_store; /**< @brief set if GL_ARB_shader_image_load_store is supported */

#define GL_MAX_IMAGE_UNITS											0x8f38 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
//#define GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS			  0x8f39 // deprecated as of OpenGL 4.3 (renamed to GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES)
#define GL_MAX_IMAGE_SAMPLES										0x906d /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_VERTEX_IMAGE_UNIFORMS								0x90ca /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS							0x90cb /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS						0x90cc /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_GEOMETRY_IMAGE_UNIFORMS								0x90cd /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_FRAGMENT_IMAGE_UNIFORMS								0x90ce /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_MAX_COMBINED_IMAGE_UNIFORMS								0x90cf /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_NAME										0x8f3a /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_LEVEL										0x8f3b /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_LAYERED									0x8f3c /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_LAYER										0x8f3d /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_ACCESS										0x8f3e /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BINDING_FORMAT										0x906e /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT							0x00000001 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_ELEMENT_ARRAY_BARRIER_BIT								0x00000002 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNIFORM_BARRIER_BIT										0x00000004 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_TEXTURE_FETCH_BARRIER_BIT								0x00000008 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_SHADER_IMAGE_ACCESS_BARRIER_BIT							0x00000020 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_COMMAND_BARRIER_BIT										0x00000040 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_PIXEL_BUFFER_BARRIER_BIT									0x00000080 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_TEXTURE_UPDATE_BARRIER_BIT								0x00000100 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_BUFFER_UPDATE_BARRIER_BIT								0x00000200 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_FRAMEBUFFER_BARRIER_BIT									0x00000400 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_TRANSFORM_FEEDBACK_BARRIER_BIT							0x00000800 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_ATOMIC_COUNTER_BARRIER_BIT								0x00001000 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_ALL_BARRIER_BITS											0xffffffffu /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_1D													0x904c /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_2D													0x904d /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_3D													0x904e /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_2D_RECT											0x904f /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_CUBE												0x9050 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_BUFFER												0x9051 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_1D_ARRAY											0x9052 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_2D_ARRAY											0x9053 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_CUBE_MAP_ARRAY										0x9054 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_2D_MULTISAMPLE										0x9055 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_2D_MULTISAMPLE_ARRAY								0x9056 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_1D												0x9057 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_2D												0x9058 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_3D												0x9059 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_2D_RECT										0x905a /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_CUBE											0x905b /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_BUFFER											0x905c /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_1D_ARRAY										0x905d /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_2D_ARRAY										0x905e /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_CUBE_MAP_ARRAY									0x905f /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_2D_MULTISAMPLE									0x9060 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY							0x9061 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_1D									0x9062 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_2D									0x9063 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_3D									0x9064 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_2D_RECT								0x9065 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_CUBE									0x9066 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_BUFFER								0x9067 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_1D_ARRAY								0x9068 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_2D_ARRAY								0x9069 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY						0x906a /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE						0x906b /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY					0x906c /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_FORMAT_COMPATIBILITY_TYPE							0x90c7 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE						0x90c8 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS						0x90c9 /**< @brief GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) enum **/

/**
 *	@brief bind a level of a texture to an image unit
 *	@param[in] unit specifies the index of the image unit to which to bind the texture
 *	@param[in] texture specifies the name of the texture to bind to the image unit
 *	@param[in] level specifies the level of the texture that is to be bound
 *	@param[in] layered specifies whether a layered texture binding is to be established
 *	@param[in] layer if layered is GL_FALSE, specifies the layer of texture to be bound to the image
 *		unit. Ignored otherwise
 *	@param[in] access specifies a token indicating the type of access that will be performed on the image
 *	@param[in] format specifies the format that the elements of the image will be treated as for the
 *		purposes of formatted stores
 */
extern void (GLApi *GLFuncPtrName(glBindImageTexture))(GLuint unit, GLuint texture, int level, GLboolean layered, int layer, GLenum access, GLenum format);

/**
 *	@brief defines a barrier ordering memory transactions
 *	@param[in] barriers specifies the barriers to insert. Must be a bitwise combination of
 *		GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT, GL_ELEMENT_ARRAY_BARRIER_BIT, GL_UNIFORM_BARRIER_BIT,
 *		GL_TEXTURE_FETCH_BARRIER_BIT, GL_SHADER_IMAGE_ACCESS_BARRIER_BIT, GL_COMMAND_BARRIER_BIT,
 *		GL_PIXEL_BUFFER_BARRIER_BIT, GL_TEXTURE_UPDATE_BARRIER_BIT, GL_BUFFER_UPDATE_BARRIER_BIT,
 *		GL_FRAMEBUFFER_BARRIER_BIT, GL_TRANSFORM_FEEDBACK_BARRIER_BIT,
 *		GL_ATOMIC_COUNTER_BARRIER_BIT, or GL_SHADER_STORAGE_BARRIER_BIT. If the special value
 *		GL_ALL_BARRIER_BITS is specified, all supported barriers will be inserted
 */
extern void (GLApi *GLFuncPtrName(glMemoryBarrier))(GLbitfield barriers);

/**
 *	@def glBindImageTexture
 *	@brief bind a level of a texture to an image unit
 *	@param[in] unit specifies the index of the image unit to which to bind the texture
 *	@param[in] texture specifies the name of the texture to bind to the image unit
 *	@param[in] level specifies the level of the texture that is to be bound
 *	@param[in] layered specifies whether a layered texture binding is to be established
 *	@param[in] layer if layered is GL_FALSE, specifies the layer of texture to be bound to the image
 *		unit. Ignored otherwise
 *	@param[in] access specifies a token indicating the type of access that will be performed on the image
 *	@param[in] format specifies the format that the elements of the image will be treated as for the
 *		purposes of formatted stores
 */
#define glBindImageTexture(unit,texture,level,layered,layer,access,format) do { GLFuncPtrName(glBindImageTexture)(unit, texture, level, layered, layer, access, format); GL_AUTOCHECK_BLOCK("glBindImageTexture", __FILE__, __LINE__); } while(0)

/**
 *	@def glMemoryBarrier
 *	@brief defines a barrier ordering memory transactions
 *	@param[in] barriers specifies the barriers to insert. Must be a bitwise combination of
 *		GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT, GL_ELEMENT_ARRAY_BARRIER_BIT, GL_UNIFORM_BARRIER_BIT,
 *		GL_TEXTURE_FETCH_BARRIER_BIT, GL_SHADER_IMAGE_ACCESS_BARRIER_BIT, GL_COMMAND_BARRIER_BIT,
 *		GL_PIXEL_BUFFER_BARRIER_BIT, GL_TEXTURE_UPDATE_BARRIER_BIT, GL_BUFFER_UPDATE_BARRIER_BIT,
 *		GL_FRAMEBUFFER_BARRIER_BIT, GL_TRANSFORM_FEEDBACK_BARRIER_BIT,
 *		GL_ATOMIC_COUNTER_BARRIER_BIT, or GL_SHADER_STORAGE_BARRIER_BIT. If the special value
 *		GL_ALL_BARRIER_BITS is specified, all supported barriers will be inserted
 */
#define glMemoryBarrier(barriers) do { GLFuncPtrName(glMemoryBarrier)(barriers); GL_AUTOCHECK_BLOCK("glMemoryBarrier", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_shader_image_load_store

//								--- ~GL_ARB_shader_image_load_store (part of OpenGL 4.2 core) ---

//								--- GL_ARB_conservative_depth (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_conservative_depth
 *	@brief if defined, GL_ARB_conservative_depth (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_conservative_depth
#define GL_ARB_conservative_depth 1

extern bool GLEH_ARB_conservative_depth; /**< @brief set if GL_ARB_conservative_depth is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_conservative_depth

//								--- ~GL_ARB_conservative_depth (part of OpenGL 4.2 core) ---

//								--- GL_ARB_shading_language_420pack (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_shading_language_420pack
 *	@brief if defined, GL_ARB_shading_language_420pack (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_shading_language_420pack
#define GL_ARB_shading_language_420pack 1

extern bool GLEH_ARB_shading_language_420pack; /**< @brief set if GL_ARB_shading_language_420pack is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_shading_language_420pack

//								--- ~GL_ARB_shading_language_420pack (part of OpenGL 4.2 core) ---

//								--- GL_ARB_internalformat_query (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_internalformat_query
 *	@brief if defined, GL_ARB_internalformat_query (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_internalformat_query
#define GL_ARB_internalformat_query 1

/**
 *	@def __GENERATE_GL_ARB_internalformat_query
 *	@brief if defined, code to initialize GL_ARB_internalformat_query (part of OpenGL 4.2 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_internalformat_query

extern bool GLEH_ARB_internalformat_query; /**< @brief set if GL_ARB_internalformat_query is supported */

#define GL_NUM_SAMPLE_COUNTS										0x9380 /**< @brief GL_ARB_internalformat_query (part of OpenGL 4.2 core) enum **/

/**
 *	@brief retrieve information about implementation-dependent support for internal formats
 *	@param[in] target indicates the usage of the internal format. target must be GL_TEXTURE_1D,
 *		GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP,
 *		GL_TEXTURE_CUBE_MAP_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_BUFFER, GL_RENDERBUFFER,
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] internalformat specifies the internal format about which to retrieve information
 *	@param[in] pname specifies the type of information to query
 *	@param[in] bufSize specifies the maximum number of basic machine units that may be written to
 *		params by the function
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
extern void (GLApi *GLFuncPtrName(glGetInternalformativ))(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, int *params);

/**
 *	@def glGetInternalformativ
 *	@brief retrieve information about implementation-dependent support for internal formats
 *	@param[in] target indicates the usage of the internal format. target must be GL_TEXTURE_1D,
 *		GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP,
 *		GL_TEXTURE_CUBE_MAP_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_BUFFER, GL_RENDERBUFFER,
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] internalformat specifies the internal format about which to retrieve information
 *	@param[in] pname specifies the type of information to query
 *	@param[in] bufSize specifies the maximum number of basic machine units that may be written to
 *		params by the function
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
#define glGetInternalformativ(target,internalformat,pname,bufSize,params) do { GLFuncPtrName(glGetInternalformativ)(target, internalformat, pname, bufSize, params); GL_AUTOCHECK_BLOCK("glGetInternalformativ", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_internalformat_query

//								--- ~GL_ARB_internalformat_query (part of OpenGL 4.2 core) ---

//								--- GL_ARB_map_buffer_alignment (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_map_buffer_alignment
 *	@brief if defined, GL_ARB_map_buffer_alignment (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_map_buffer_alignment
#define GL_ARB_map_buffer_alignment 1

extern bool GLEH_ARB_map_buffer_alignment; /**< @brief set if GL_ARB_map_buffer_alignment is supported */

#define GL_MIN_MAP_BUFFER_ALIGNMENT									0x90bc /**< @brief GL_ARB_map_buffer_alignment (part of OpenGL 4.2 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_map_buffer_alignment

//								--- ~GL_ARB_map_buffer_alignment (part of OpenGL 4.2 core) ---

//								--- GL_ARB_shading_language_packing (part of OpenGL 4.2 core) ---

/**
 *	@def GL_ARB_shading_language_packing
 *	@brief if defined, GL_ARB_shading_language_packing (part of OpenGL 4.2 core) entry points are available
 */
#ifndef GL_ARB_shading_language_packing
#define GL_ARB_shading_language_packing 1

extern bool GLEH_ARB_shading_language_packing; /**< @brief set if GL_ARB_shading_language_packing is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_shading_language_packing

//								--- ~GL_ARB_shading_language_packing (part of OpenGL 4.2 core) ---

//								--- OpenGL 4.3 ---

/**
 *	@def GL_VERSION_4_3
 *	@brief if defined, OpenGL 4.3 entry points are available
 *	@note This does not necessarily mean it is also supported.
 */
#ifndef GL_VERSION_4_3
#define GL_VERSION_4_3 1

/**
 *	@def __GENERATE_GL_43__
 *	@brief if defined, code to initialize OpenGL 4.3 entry points is compiled
 */
#define __GENERATE_GL_43__

extern bool GLEH_OPENGL_4_3; /**< @brief set if OpenGL 4.3 is supported */

#define GL_VERTEX_ATTRIB_ARRAY_LONG		  0x874E /**< @brief OpenGL 4.3 enum (see Bug 8272) */
#define GL_STACK_OVERFLOW				  0x0503 /**< @brief OpenGL 4.3 enum (undeprecated) */
#define GL_STACK_UNDERFLOW				  0x0504 /**< @brief OpenGL 4.3 enum (undeprecated) */

// no new procedures or functions

#endif // !GL_VERSION_4_3

//								--- ~OpenGL 4.3 ---

//								--- GL_ARB_arrays_of_arrays (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_arrays_of_arrays
 *	@brief if defined, GL_ARB_arrays_of_arrays (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_arrays_of_arrays
#define GL_ARB_arrays_of_arrays 1

extern bool GLEH_ARB_arrays_of_arrays; /**< @brief set if GL_ARB_arrays_of_arrays is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_arrays_of_arrays

//								--- ~GL_ARB_arrays_of_arrays (part of OpenGL 4.3 core) ---

//								--- GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_ES3_compatibility
 *	@brief if defined, GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_ES3_compatibility
#define GL_ARB_ES3_compatibility 1

extern bool GLEH_ARB_ES3_compatibility; /**< @brief set if GL_ARB_ES3_compatibility is supported */

#define GL_COMPRESSED_RGB8_ETC2										0x9274 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_SRGB8_ETC2									0x9275 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2					0x9276 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2				0x9277 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_RGBA8_ETC2_EAC								0x9278 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC							0x9279 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_R11_EAC										0x9270 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_SIGNED_R11_EAC								0x9271 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_RG11_EAC										0x9272 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_COMPRESSED_SIGNED_RG11_EAC								0x9273 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_PRIMITIVE_RESTART_FIXED_INDEX							0x8d69 /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_ANY_SAMPLES_PASSED_CONSERVATIVE							0x8d6a /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_MAX_ELEMENT_INDEX										0x8d6b /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_IMMUTABLE_LEVELS									0x82df /**< @brief GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_ES3_compatibility

//								--- ~GL_ARB_ES3_compatibility (part of OpenGL 4.3 core) ---

//								--- GL_ARB_clear_buffer_object (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_clear_buffer_object
 *	@brief if defined, GL_ARB_clear_buffer_object (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_clear_buffer_object
#define GL_ARB_clear_buffer_object 1

/**
 *	@def __GENERATE_GL_ARB_clear_buffer_object
 *	@brief if defined, code to initialize GL_ARB_clear_buffer_object (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_clear_buffer_object

extern bool GLEH_ARB_clear_buffer_object; /**< @brief set if GL_ARB_clear_buffer_object is supported */

// no new tokens

/**
 *	@brief fill a buffer object's data store with a fixed value
 *	@param[in] target specify the target of the operation. target must be one of the global buffer
 *		binding targets
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
extern void (GLApi *GLFuncPtrName(glClearBufferData))(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data);

/**
 *	@brief fill all or part of buffer object's data store with a fixed value
 *	@param[in] target specify the target of the operation. target must be one of the global buffer
 *		binding targets
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] offset the offset, in basic machine units into the buffer object's data store at
 *		which to start filling
 *	@param[in] size the size, in basic machine units of the range of the data store to fill
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
extern void (GLApi *GLFuncPtrName(glClearBufferSubData))(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);

/**
 *	@brief fill a buffer object's data store with a fixed value
 *	@param[in] buffer specifies the name of the buffer object for glClearNamedBufferData
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
extern void (GLApi *GLFuncPtrName(glClearNamedBufferDataEXT))(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data);

/**
 *	@brief fill all or part of buffer object's data store with a fixed value
 *	@param[in] buffer specifies the name of the buffer object for glClearNamedBufferSubData
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] offset the offset in basic machine units into the buffer object's data store at which
 *		to start filling
 *	@param[in] size the size in basic machine units of the range of the data store to fill
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
extern void (GLApi *GLFuncPtrName(glClearNamedBufferSubDataEXT))(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);

/**
 *	@def glClearBufferData
 *	@brief fill a buffer object's data store with a fixed value
 *	@param[in] target specify the target of the operation. target must be one of the global buffer
 *		binding targets
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
#define glClearBufferData(target,internalformat,format,type,data) do { GLFuncPtrName(glClearBufferData)(target, internalformat, format, type, data); GL_AUTOCHECK_BLOCK("glClearBufferData", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearBufferSubData
 *	@brief fill all or part of buffer object's data store with a fixed value
 *	@param[in] target specify the target of the operation. target must be one of the global buffer
 *		binding targets
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] offset the offset, in basic machine units into the buffer object's data store at
 *		which to start filling
 *	@param[in] size the size, in basic machine units of the range of the data store to fill
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
#define glClearBufferSubData(target,internalformat,offset,size,format,type,data) do { GLFuncPtrName(glClearBufferSubData)(target, internalformat, offset, size, format, type, data); GL_AUTOCHECK_BLOCK("glClearBufferSubData", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearNamedBufferDataEXT
 *	@brief fill a buffer object's data store with a fixed value
 *	@param[in] buffer specifies the name of the buffer object for glClearNamedBufferData
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
#define glClearNamedBufferDataEXT(buffer,internalformat,format,type,data) do { GLFuncPtrName(glClearNamedBufferDataEXT)(buffer, internalformat, format, type, data); GL_AUTOCHECK_BLOCK("glClearNamedBufferDataEXT", __FILE__, __LINE__); } while(0)

/**
 *	@def glClearNamedBufferSubDataEXT
 *	@brief fill all or part of buffer object's data store with a fixed value
 *	@param[in] buffer specifies the name of the buffer object for glClearNamedBufferSubData
 *	@param[in] internalformat the internal format with which the data will be stored in the buffer object
 *	@param[in] offset the offset in basic machine units into the buffer object's data store at which
 *		to start filling
 *	@param[in] size the size in basic machine units of the range of the data store to fill
 *	@param[in] format the format of the data in memory addressed by data
 *	@param[in] type the type of the data in memory addressed by data
 *	@param[in] data the address of a memory location storing the data to be replicated into the
 *		buffer's data store
 */
#define glClearNamedBufferSubDataEXT(buffer,internalformat,offset,size,format,type,data) do { GLFuncPtrName(glClearNamedBufferSubDataEXT)(buffer, internalformat, offset, size, format, type, data); GL_AUTOCHECK_BLOCK("glClearNamedBufferSubDataEXT", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_clear_buffer_object

//								--- ~GL_ARB_clear_buffer_object (part of OpenGL 4.3 core) ---

//								--- GL_ARB_compute_shader (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_compute_shader
 *	@brief if defined, GL_ARB_compute_shader (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_compute_shader
#define GL_ARB_compute_shader 1

/**
 *	@def __GENERATE_GL_ARB_compute_shader
 *	@brief if defined, code to initialize GL_ARB_compute_shader (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_compute_shader

extern bool GLEH_ARB_compute_shader; /**< @brief set if GL_ARB_compute_shader is supported */

#define GL_COMPUTE_SHADER											0x91b9 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_UNIFORM_BLOCKS								0x91bb /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS							0x91bc /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_IMAGE_UNIFORMS								0x91bd /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_SHARED_MEMORY_SIZE							0x8262 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_UNIFORM_COMPONENTS							0x8263 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS						0x8264 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_ATOMIC_COUNTERS								0x8265 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS					0x8266 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS						0x90eb /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_WORK_GROUP_COUNT								0x91be /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMPUTE_WORK_GROUP_SIZE								0x91bf /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_COMPUTE_WORK_GROUP_SIZE									0x8267 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER				0x90ec /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER		0x90ed /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_DISPATCH_INDIRECT_BUFFER									0x90ee /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_DISPATCH_INDIRECT_BUFFER_BINDING							0x90ef /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/
#define GL_COMPUTE_SHADER_BIT										0x00000020 /**< @brief GL_ARB_compute_shader (part of OpenGL 4.3 core) enum **/

/**
 *	@brief launch one or more compute work groups
 *	@param[in] num_groups_x the number of work groups to be launched in the X dimension
 *	@param[in] num_groups_y the number of work groups to be launched in the Y dimension
 *	@param[in] num_groups_z the number of work groups to be launched in the Z dimension
 */
extern void (GLApi *GLFuncPtrName(glDispatchCompute))(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);

/**
 *	@brief launch one or more compute work groups using parameters stored in a buffer
 *	@param[in] indirect the offset into the buffer object currently bound to the
 *		GL_DISPATCH_INDIRECT_BUFFER buffer target at which the dispatch parameters are stored
 */
extern void (GLApi *GLFuncPtrName(glDispatchComputeIndirect))(GLintptr indirect);

/**
 *	@def glDispatchCompute
 *	@brief launch one or more compute work groups
 *	@param[in] num_groups_x the number of work groups to be launched in the X dimension
 *	@param[in] num_groups_y the number of work groups to be launched in the Y dimension
 *	@param[in] num_groups_z the number of work groups to be launched in the Z dimension
 */
#define glDispatchCompute(num_groups_x,num_groups_y,num_groups_z) do { GLFuncPtrName(glDispatchCompute)(num_groups_x, num_groups_y, num_groups_z); GL_AUTOCHECK_BLOCK("glDispatchCompute", __FILE__, __LINE__); } while(0)

/**
 *	@def glDispatchComputeIndirect
 *	@brief launch one or more compute work groups using parameters stored in a buffer
 *	@param[in] indirect the offset into the buffer object currently bound to the
 *		GL_DISPATCH_INDIRECT_BUFFER buffer target at which the dispatch parameters are stored
 */
#define glDispatchComputeIndirect(indirect) do { GLFuncPtrName(glDispatchComputeIndirect)(indirect); GL_AUTOCHECK_BLOCK("glDispatchComputeIndirect", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_compute_shader

//								--- ~GL_ARB_compute_shader (part of OpenGL 4.3 core) ---

//								--- GL_ARB_copy_image (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_copy_image
 *	@brief if defined, GL_ARB_copy_image (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_copy_image
#define GL_ARB_copy_image 1

/**
 *	@def __GENERATE_GL_ARB_copy_image
 *	@brief if defined, code to initialize GL_ARB_copy_image (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_copy_image

extern bool GLEH_ARB_copy_image; /**< @brief set if GL_ARB_copy_image is supported */

// no new tokens

/**
 *	@brief perform a raw data copy between two images
 *	@param[in] srcName the name of a texture or renderbuffer object from which to copy
 *	@param[in] srcTarget the target representing the namespace of the source name srcName
 *	@param[in] srcLevel the mipmap level to read from the source
 *	@param[in] srcX the X coordinate of the left edge of the souce region to copy
 *	@param[in] srcY the Y coordinate of the top edge of the souce region to copy
 *	@param[in] srcZ the Z coordinate of the near edge of the souce region to copy
 *	@param[in] dstName the name of a texture or renderbuffer object to which to copy
 *	@param[in] dstTarget the target representing the namespace of the destination name dstName
 *	@param[in] dstLevel the mipmap level to write to the destination
 *	@param[in] dstX the X coordinate of the left edge of the destination region
 *	@param[in] dstY the Y coordinate of the top edge of the destination region
 *	@param[in] dstZ the Z coordinate of the near edge of the destination region
 *	@param[in] srcWidth the width of the region to be copied
 *	@param[in] srcHeight the height of the region to be copied
 *	@param[in] srcDepth the depth of the region to be copied
 */
extern void (GLApi *GLFuncPtrName(glCopyImageSubData))(GLuint srcName, GLenum srcTarget, int srcLevel, int srcX, int srcY, int srcZ, GLuint dstName, GLenum dstTarget, int dstLevel, int dstX, int dstY, int dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);

/**
 *	@def glCopyImageSubData
 *	@brief perform a raw data copy between two images
 *	@param[in] srcName the name of a texture or renderbuffer object from which to copy
 *	@param[in] srcTarget the target representing the namespace of the source name srcName
 *	@param[in] srcLevel the mipmap level to read from the source
 *	@param[in] srcX the X coordinate of the left edge of the souce region to copy
 *	@param[in] srcY the Y coordinate of the top edge of the souce region to copy
 *	@param[in] srcZ the Z coordinate of the near edge of the souce region to copy
 *	@param[in] dstName the name of a texture or renderbuffer object to which to copy
 *	@param[in] dstTarget the target representing the namespace of the destination name dstName
 *	@param[in] dstLevel the mipmap level to write to the destination
 *	@param[in] dstX the X coordinate of the left edge of the destination region
 *	@param[in] dstY the Y coordinate of the top edge of the destination region
 *	@param[in] dstZ the Z coordinate of the near edge of the destination region
 *	@param[in] srcWidth the width of the region to be copied
 *	@param[in] srcHeight the height of the region to be copied
 *	@param[in] srcDepth the depth of the region to be copied
 */
#define glCopyImageSubData(srcName,srcTarget,srcLevel,srcX,srcY,srcZ,dstName,dstTarget,dstLevel,dstX,dstY,dstZ,srcWidth,srcHeight,srcDepth) do { GLFuncPtrName(glCopyImageSubData)(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth); GL_AUTOCHECK_BLOCK("glCopyImageSubData", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_copy_image

//								--- ~GL_ARB_copy_image (part of OpenGL 4.3 core) ---

//								--- GL_ARB_debug_group (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_debug_group
 *	@brief if defined, GL_ARB_debug_group (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_debug_group
#define GL_ARB_debug_group 1

extern bool GLEH_ARB_debug_group; /**< @brief set if GL_ARB_debug_group is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_debug_group

//								--- ~GL_ARB_debug_group (part of OpenGL 4.3 core) ---

//								--- GL_ARB_debug_label (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_debug_label
 *	@brief if defined, GL_ARB_debug_label (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_debug_label
#define GL_ARB_debug_label 1

extern bool GLEH_ARB_debug_label; /**< @brief set if GL_ARB_debug_label is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_debug_label

//								--- ~GL_ARB_debug_label (part of OpenGL 4.3 core) ---

//								--- GL_ARB_debug_output2 (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_debug_output2
 *	@brief if defined, GL_ARB_debug_output2 (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_debug_output2
#define GL_ARB_debug_output2 1

extern bool GLEH_ARB_debug_output2; /**< @brief set if GL_ARB_debug_output2 is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_debug_output2

//								--- ~GL_ARB_debug_output2 (part of OpenGL 4.3 core) ---

//								--- GL_ARB_debug_output (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_debug_output
 *	@brief if defined, GL_ARB_debug_output (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_debug_output
#define GL_ARB_debug_output 1

/**
 *	@def __GENERATE_GL_ARB_debug_output
 *	@brief if defined, code to initialize GL_ARB_debug_output (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_debug_output

extern bool GLEH_ARB_debug_output; /**< @brief set if GL_ARB_debug_output is supported */

#define GL_DEBUG_OUTPUT_SYNCHRONOUS									0x8242 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_MAX_DEBUG_MESSAGE_LENGTH									0x9143 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_MAX_DEBUG_LOGGED_MESSAGES								0x9144 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_LOGGED_MESSAGES									0x9145 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH							0x8243 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_CALLBACK_FUNCTION									0x8244 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_CALLBACK_USER_PARAM								0x8245 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_API											0x8246 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM								0x8247 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_SHADER_COMPILER								0x8248 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_THIRD_PARTY									0x8249 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_APPLICATION									0x824a /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SOURCE_OTHER										0x824b /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_ERROR											0x824c /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR							0x824d /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR							0x824e /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_PORTABILITY									0x824f /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_PERFORMANCE									0x8250 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_TYPE_OTHER											0x8251 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SEVERITY_HIGH										0x9146 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SEVERITY_MEDIUM									0x9147 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/
#define GL_DEBUG_SEVERITY_LOW										0x9148 /**< @brief GL_ARB_debug_output (part of OpenGL 4.3 core) enum **/

/**
 *	@brief control the reporting of debug messages in a debug context
 *	@param[in] source the source of debug messages to enable or disable
 *	@param[in] type the type of debug messages to enable or disable
 *	@param[in] severity the severity of debug messages to enable or disable
 *	@param[in] count the length of the array ids
 *	@param[in] ids the address of an array of unsigned integers contianing the ids of the messages
 *		to enable or disable
 *	@param[in] enabled a Boolean flag determining whether the selected messages should be enabled or disabled
 */
extern void (GLApi *GLFuncPtrName(glDebugMessageControl))(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);

/**
 *	@brief inject an application-supplied message into the debug message queue
 *	@param[in] source the source of the debug message to insert
 *	@param[in] type the type of the debug message insert
 *	@param[in] id the user-supplied identifier of the message to insert
 *	@param[in] severity the severity of the debug messages to insert
 *	@param[in] length the length string contained in the character array whose address is given by message
 *	@param[in] message the address of a character array containing the message to insert
 */
extern void (GLApi *GLFuncPtrName(glDebugMessageInsert))(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *message);

/**
 *	@brief specify a callback to receive debugging messages from the GL
 *	@param[in] callback the address of a callback function that will be called when a debug message
 *		is generated
 *	@param[out] userParam a user supplied pointer that will be passed on each invocation of callback
 */
extern void (GLApi *GLFuncPtrName(glDebugMessageCallback))(GLDEBUGPROCARB callback, void *userParam);

/**
 *	@brief retrieve messages from the debug message log
 *	@param[in] count the number of debug messages to retrieve from the log
 *	@param[in] bufSize the size of the buffer whose address is given by messageLog
 *	@param[out] sources the address of an array of variables to receive the sources of the retrieved messages
 *	@param[out] types the address of an array of variables to receive the types of the retrieved messages
 *	@param[out] ids the address of an array of unsigned integers to receive the ids of the retrieved messages
 *	@param[out] severities the address of an array of variables to receive the severites of the
 *		retrieved messages
 *	@param[out] lengths the address of an array of variables to receive the lengths of the received messages
 *	@param[out] messageLog the address of an array of characters that will receive the messages
 */
extern GLuint (GLApi *GLFuncPtrName(glGetDebugMessageLog))(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);

/**
 *	@brief return the address of the specified pointer
 *	@param[in] pname specifies the array or buffer pointer to be returned. Symbolic constants
 *		GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER,
 *		GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER,
 *		GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER,
 *		GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted
 *	@param[out] params returns the pointer value specified by pname
 */
extern void (GLApi *GLFuncPtrName(glGetPointerv))(GLenum pname, void **params);

inline GLuint glGetDebugMessageLog_glachwrap(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char *p_s_filename, int n_line) { GLuint result = GLFuncPtrName(glGetDebugMessageLog)(count,bufSize,sources,types,ids,severities,lengths,messageLog); GL_AUTOCHECK_BLOCK("glGetDebugMessageLog", p_s_filename, n_line); return result; }

/**
 *	@def glDebugMessageControl
 *	@brief control the reporting of debug messages in a debug context
 *	@param[in] source the source of debug messages to enable or disable
 *	@param[in] type the type of debug messages to enable or disable
 *	@param[in] severity the severity of debug messages to enable or disable
 *	@param[in] count the length of the array ids
 *	@param[in] ids the address of an array of unsigned integers contianing the ids of the messages
 *		to enable or disable
 *	@param[in] enabled a Boolean flag determining whether the selected messages should be enabled or disabled
 */
#define glDebugMessageControl(source,type,severity,count,ids,enabled) do { GLFuncPtrName(glDebugMessageControl)(source, type, severity, count, ids, enabled); GL_AUTOCHECK_BLOCK("glDebugMessageControl", __FILE__, __LINE__); } while(0)

/**
 *	@def glDebugMessageInsert
 *	@brief inject an application-supplied message into the debug message queue
 *	@param[in] source the source of the debug message to insert
 *	@param[in] type the type of the debug message insert
 *	@param[in] id the user-supplied identifier of the message to insert
 *	@param[in] severity the severity of the debug messages to insert
 *	@param[in] length the length string contained in the character array whose address is given by message
 *	@param[in] message the address of a character array containing the message to insert
 */
#define glDebugMessageInsert(source,type,id,severity,length,message) do { GLFuncPtrName(glDebugMessageInsert)(source, type, id, severity, length, message); GL_AUTOCHECK_BLOCK("glDebugMessageInsert", __FILE__, __LINE__); } while(0)

/**
 *	@def glDebugMessageCallback
 *	@brief specify a callback to receive debugging messages from the GL
 *	@param[in] callback the address of a callback function that will be called when a debug message
 *		is generated
 *	@param[out] userParam a user supplied pointer that will be passed on each invocation of callback
 */
#define glDebugMessageCallback(callback,userParam) do { GLFuncPtrName(glDebugMessageCallback)(callback, userParam); GL_AUTOCHECK_BLOCK("glDebugMessageCallback", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetDebugMessageLog
 *	@brief retrieve messages from the debug message log
 *	@param[in] count the number of debug messages to retrieve from the log
 *	@param[in] bufSize the size of the buffer whose address is given by messageLog
 *	@param[out] sources the address of an array of variables to receive the sources of the retrieved messages
 *	@param[out] types the address of an array of variables to receive the types of the retrieved messages
 *	@param[out] ids the address of an array of unsigned integers to receive the ids of the retrieved messages
 *	@param[out] severities the address of an array of variables to receive the severites of the
 *		retrieved messages
 *	@param[out] lengths the address of an array of variables to receive the lengths of the received messages
 *	@param[out] messageLog the address of an array of characters that will receive the messages
 */
#define glGetDebugMessageLog(count,bufSize,sources,types,ids,severities,lengths,messageLog) GLAutoCheckFuncPtrName(glGetDebugMessageLog)(count, bufSize, sources, types, ids, severities, lengths, messageLog GLAutoCheckExtraParams)

/**
 *	@def glGetPointerv
 *	@brief return the address of the specified pointer
 *	@param[in] pname specifies the array or buffer pointer to be returned. Symbolic constants
 *		GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER,
 *		GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER,
 *		GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER,
 *		GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted
 *	@param[out] params returns the pointer value specified by pname
 */
#define glGetPointerv(pname,params) do { GLFuncPtrName(glGetPointerv)(pname, params); GL_AUTOCHECK_BLOCK("glGetPointerv", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_debug_output

//								--- ~GL_ARB_debug_output (part of OpenGL 4.3 core) ---

//								--- GL_ARB_explicit_uniform_location (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_explicit_uniform_location
 *	@brief if defined, GL_ARB_explicit_uniform_location (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_explicit_uniform_location
#define GL_ARB_explicit_uniform_location 1

extern bool GLEH_ARB_explicit_uniform_location; /**< @brief set if GL_ARB_explicit_uniform_location is supported */

#define GL_MAX_UNIFORM_LOCATIONS									0x826e /**< @brief GL_ARB_explicit_uniform_location (part of OpenGL 4.3 core) enum **/

// no new procedures or functions

#endif // !GL_ARB_explicit_uniform_location

//								--- ~GL_ARB_explicit_uniform_location (part of OpenGL 4.3 core) ---

//								--- GL_ARB_fragment_layer_viewport (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_fragment_layer_viewport
 *	@brief if defined, GL_ARB_fragment_layer_viewport (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_fragment_layer_viewport
#define GL_ARB_fragment_layer_viewport 1

extern bool GLEH_ARB_fragment_layer_viewport; /**< @brief set if GL_ARB_fragment_layer_viewport is supported */

// no new tokens

// no new procedures or functions

#endif // !GL_ARB_fragment_layer_viewport

//								--- ~GL_ARB_fragment_layer_viewport (part of OpenGL 4.3 core) ---

//								--- GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_framebuffer_no_attachments
 *	@brief if defined, GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_framebuffer_no_attachments
#define GL_ARB_framebuffer_no_attachments 1

/**
 *	@def __GENERATE_GL_ARB_framebuffer_no_attachments
 *	@brief if defined, code to initialize GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_framebuffer_no_attachments

extern bool GLEH_ARB_framebuffer_no_attachments; /**< @brief set if GL_ARB_framebuffer_no_attachments is supported */

#define GL_FRAMEBUFFER_DEFAULT_WIDTH								0x9310 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_DEFAULT_HEIGHT								0x9311 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_DEFAULT_LAYERS								0x9312 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_DEFAULT_SAMPLES								0x9313 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS				0x9314 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_MAX_FRAMEBUFFER_WIDTH									0x9315 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_MAX_FRAMEBUFFER_HEIGHT									0x9316 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_MAX_FRAMEBUFFER_LAYERS									0x9317 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/
#define GL_MAX_FRAMEBUFFER_SAMPLES									0x9318 /**< @brief GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) enum **/

/**
 *	@brief set a named parameter of a framebuffer
 *	@param[in] target the target of the operation, which must be GL_READ_FRAMEBUFFER,
 *		GL_DRAW_FRAMEBUFFER or GL_FRAMEBUFFER
 *	@param[in] pname a token indicating the parameter to be modified
 *	@param[in] param the new value for the parameter named pname
 */
extern void (GLApi *GLFuncPtrName(glFramebufferParameteri))(GLenum target, GLenum pname, int param);

/**
 *	@brief retrieve a named parameter from a framebuffer
 *	@param[in] target the target of the operation, which must be GL_READ_FRAMEBUFFER,
 *		GL_DRAW_FRAMEBUFFER or GL_FRAMEBUFFER
 *	@param[in] pname a token indicating the parameter to be retrieved
 *	@param[out] params the address of a variable to receive the value of the parameter named pname
 */
extern void (GLApi *GLFuncPtrName(glGetFramebufferParameteriv))(GLenum target, GLenum pname, int *params);

/**
 *	@brief set a named parameter of a framebuffer object
 *	@param[in] framebuffer specifies the name of the framebuffer object for glNamedFramebufferParameteri
 *	@param[in] pname specifies the framebuffer parameter to be modified
 *	@param[in] param the new value for the parameter named pname
 */
extern void (GLApi *GLFuncPtrName(glNamedFramebufferParameteriEXT))(GLuint framebuffer, GLenum pname, int param);

/**
 *	@brief query a named parameter of a framebuffer object
 *	@param[in] framebuffer specifies the name of the framebuffer object for glGetNamedFramebufferParameteriv
 *	@param[in] pname specifies the parameter of the framebuffer object to query
 *	@param[out] params returns the value of parameter pname for the framebuffer object
 */
extern void (GLApi *GLFuncPtrName(glGetNamedFramebufferParameterivEXT))(GLuint framebuffer, GLenum pname, int *params);

/**
 *	@def glFramebufferParameteri
 *	@brief set a named parameter of a framebuffer
 *	@param[in] target the target of the operation, which must be GL_READ_FRAMEBUFFER,
 *		GL_DRAW_FRAMEBUFFER or GL_FRAMEBUFFER
 *	@param[in] pname a token indicating the parameter to be modified
 *	@param[in] param the new value for the parameter named pname
 */
#define glFramebufferParameteri(target,pname,param) do { GLFuncPtrName(glFramebufferParameteri)(target, pname, param); GL_AUTOCHECK_BLOCK("glFramebufferParameteri", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetFramebufferParameteriv
 *	@brief retrieve a named parameter from a framebuffer
 *	@param[in] target the target of the operation, which must be GL_READ_FRAMEBUFFER,
 *		GL_DRAW_FRAMEBUFFER or GL_FRAMEBUFFER
 *	@param[in] pname a token indicating the parameter to be retrieved
 *	@param[out] params the address of a variable to receive the value of the parameter named pname
 */
#define glGetFramebufferParameteriv(target,pname,params) do { GLFuncPtrName(glGetFramebufferParameteriv)(target, pname, params); GL_AUTOCHECK_BLOCK("glGetFramebufferParameteriv", __FILE__, __LINE__); } while(0)

/**
 *	@def glNamedFramebufferParameteriEXT
 *	@brief set a named parameter of a framebuffer object
 *	@param[in] framebuffer specifies the name of the framebuffer object for glNamedFramebufferParameteri
 *	@param[in] pname specifies the framebuffer parameter to be modified
 *	@param[in] param the new value for the parameter named pname
 */
#define glNamedFramebufferParameteriEXT(framebuffer,pname,param) do { GLFuncPtrName(glNamedFramebufferParameteriEXT)(framebuffer, pname, param); GL_AUTOCHECK_BLOCK("glNamedFramebufferParameteriEXT", __FILE__, __LINE__); } while(0)

/**
 *	@def glGetNamedFramebufferParameterivEXT
 *	@brief query a named parameter of a framebuffer object
 *	@param[in] framebuffer specifies the name of the framebuffer object for glGetNamedFramebufferParameteriv
 *	@param[in] pname specifies the parameter of the framebuffer object to query
 *	@param[out] params returns the value of parameter pname for the framebuffer object
 */
#define glGetNamedFramebufferParameterivEXT(framebuffer,pname,params) do { GLFuncPtrName(glGetNamedFramebufferParameterivEXT)(framebuffer, pname, params); GL_AUTOCHECK_BLOCK("glGetNamedFramebufferParameterivEXT", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_framebuffer_no_attachments

//								--- ~GL_ARB_framebuffer_no_attachments (part of OpenGL 4.3 core) ---

//								--- GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_internalformat_query2
 *	@brief if defined, GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_internalformat_query2
#define GL_ARB_internalformat_query2 1

/**
 *	@def __GENERATE_GL_ARB_internalformat_query2
 *	@brief if defined, code to initialize GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_internalformat_query2

extern bool GLEH_ARB_internalformat_query2; /**< @brief set if GL_ARB_internalformat_query2 is supported */

//#define GL_TEXTURE_1D												  0x0de0 // (defined above)
//#define GL_TEXTURE_1D_ARRAY										  0x8c18 // (defined above)
//#define GL_TEXTURE_2D												  0x0de1 // (defined above)
//#define GL_TEXTURE_2D_ARRAY										  0x8c1a // (defined above)
//#define GL_TEXTURE_3D												  0x806f // (defined above)
//#define GL_TEXTURE_CUBE_MAP										  0x8513 // (defined above)
//#define GL_TEXTURE_CUBE_MAP_ARRAY									  0x9009 // (defined above)
//#define GL_TEXTURE_RECTANGLE										  0x84f5 // (defined above)
//#define GL_TEXTURE_BUFFER											  0x8c2a // (defined above)
//#define GL_RENDERBUFFER											  0x8d41 // (defined above)
//#define GL_TEXTURE_2D_MULTISAMPLE									  0x9100 // (defined above)
//#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY							  0x9102 // (defined above)
//#define GL_SAMPLES												  0x80a9 // (defined above)
//#define GL_NUM_SAMPLE_COUNTS										  0x9380 // (defined above)
#define GL_INTERNALFORMAT_SUPPORTED									0x826f /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_PREFERRED									0x8270 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_RED_SIZE									0x8271 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_GREEN_SIZE								0x8272 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_BLUE_SIZE									0x8273 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_ALPHA_SIZE								0x8274 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_DEPTH_SIZE								0x8275 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_STENCIL_SIZE								0x8276 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_SHARED_SIZE								0x8277 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_RED_TYPE									0x8278 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_GREEN_TYPE								0x8279 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_BLUE_TYPE									0x827a /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_ALPHA_TYPE								0x827b /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_DEPTH_TYPE								0x827c /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_INTERNALFORMAT_STENCIL_TYPE								0x827d /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MAX_WIDTH												0x827e /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MAX_HEIGHT												0x827f /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MAX_DEPTH												0x8280 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MAX_LAYERS												0x8281 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MAX_COMBINED_DIMENSIONS									0x8282 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_COLOR_COMPONENTS											0x8283 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_DEPTH_COMPONENTS											0x8284 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_STENCIL_COMPONENTS										0x8285 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_COLOR_RENDERABLE											0x8286 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_DEPTH_RENDERABLE											0x8287 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_STENCIL_RENDERABLE										0x8288 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_RENDERABLE									0x8289 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_RENDERABLE_LAYERED							0x828a /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FRAMEBUFFER_BLEND										0x828b /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_READ_PIXELS												0x828c /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_READ_PIXELS_FORMAT										0x828d /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_READ_PIXELS_TYPE											0x828e /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_IMAGE_FORMAT										0x828f /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_IMAGE_TYPE										0x8290 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_GET_TEXTURE_IMAGE_FORMAT									0x8291 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_GET_TEXTURE_IMAGE_TYPE									0x8292 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MIPMAP													0x8293 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_MANUAL_GENERATE_MIPMAP									0x8294 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_AUTO_GENERATE_MIPMAP										0x8295 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_COLOR_ENCODING											0x8296 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SRGB_READ												0x8297 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SRGB_WRITE												0x8298 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SRGB_DECODE												0x8299 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FILTER													0x829a /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VERTEX_TEXTURE											0x829b /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TESS_CONTROL_TEXTURE										0x829c /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TESS_EVALUATION_TEXTURE									0x829d /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_GEOMETRY_TEXTURE											0x829e /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FRAGMENT_TEXTURE											0x829f /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_COMPUTE_TEXTURE											0x82a0 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_SHADOW											0x82a1 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_GATHER											0x82a2 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_GATHER_SHADOW									0x82a3 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SHADER_IMAGE_LOAD										0x82a4 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SHADER_IMAGE_STORE										0x82a5 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SHADER_IMAGE_ATOMIC										0x82a6 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_TEXEL_SIZE											0x82a7 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_COMPATIBILITY_CLASS								0x82a8 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_PIXEL_FORMAT										0x82a9 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_PIXEL_TYPE											0x82aa /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
//#define GL_IMAGE_FORMAT_COMPATIBILITY_TYPE						  0x90c7 // (defined above)
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST						0x82ac /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST					0x82ad /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE						0x82ae /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE					0x82af /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
//#define GL_TEXTURE_COMPRESSED										  0x86a1 // (defined above)
#define GL_TEXTURE_COMPRESSED_BLOCK_WIDTH							0x82b1 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT							0x82b2 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_COMPRESSED_BLOCK_SIZE							0x82b3 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_CLEAR_BUFFER												0x82b4 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_TEXTURE_VIEW												0x82b5 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_COMPATIBILITY_CLASS									0x82b6 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_FULL_SUPPORT												0x82b7 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_CAVEAT_SUPPORT											0x82b8 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_4_X_32										0x82b9 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_2_X_32										0x82ba /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_1_X_32										0x82bb /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_4_X_16										0x82bc /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_2_X_16										0x82bd /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_1_X_16										0x82be /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_4_X_8										0x82bf /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_2_X_8										0x82c0 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_1_X_8										0x82c1 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_11_11_10										0x82c2 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_IMAGE_CLASS_10_10_10_2									0x82c3 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_128_BITS										0x82c4 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_96_BITS										0x82c5 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_64_BITS										0x82c6 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_48_BITS										0x82c7 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_32_BITS										0x82c8 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_24_BITS										0x82c9 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_16_BITS										0x82ca /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_8_BITS										0x82cb /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_S3TC_DXT1_RGB									0x82cc /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_S3TC_DXT1_RGBA								0x82cd /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_S3TC_DXT3_RGBA								0x82ce /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_S3TC_DXT5_RGBA								0x82cf /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_RGTC1_RED										0x82d0 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_RGTC2_RG										0x82d1 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_BPTC_UNORM									0x82d2 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/
#define GL_VIEW_CLASS_BPTC_FLOAT									0x82d3 /**< @brief GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) enum **/

/**
 *	@brief retrieve information about implementation-dependent support for internal formats
 *	@param[in] target indicates the usage of the internal format. target must be GL_TEXTURE_1D,
 *		GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP,
 *		GL_TEXTURE_CUBE_MAP_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_BUFFER, GL_RENDERBUFFER,
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] internalformat specifies the internal format about which to retrieve information
 *	@param[in] pname specifies the type of information to query
 *	@param[in] bufSize specifies the maximum number of basic machine units that may be written to
 *		params by the function
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
extern void (GLApi *GLFuncPtrName(glGetInternalformati64v))(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);

/**
 *	@def glGetInternalformati64v
 *	@brief retrieve information about implementation-dependent support for internal formats
 *	@param[in] target indicates the usage of the internal format. target must be GL_TEXTURE_1D,
 *		GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP,
 *		GL_TEXTURE_CUBE_MAP_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_BUFFER, GL_RENDERBUFFER,
 *		GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY
 *	@param[in] internalformat specifies the internal format about which to retrieve information
 *	@param[in] pname specifies the type of information to query
 *	@param[in] bufSize specifies the maximum number of basic machine units that may be written to
 *		params by the function
 *	@param[out] params specifies the address of a variable into which to write the retrieved information
 */
#define glGetInternalformati64v(target,internalformat,pname,bufSize,params) do { GLFuncPtrName(glGetInternalformati64v)(target, internalformat, pname, bufSize, params); GL_AUTOCHECK_BLOCK("glGetInternalformati64v", __FILE__, __LINE__); } while(0)

#endif // !GL_ARB_internalformat_query2

//								--- ~GL_ARB_internalformat_query2 (part of OpenGL 4.3 core) ---

//								--- GL_ARB_invalidate_subdata (part of OpenGL 4.3 core) ---

/**
 *	@def GL_ARB_invalidate_subdata
 *	@brief if defined, GL_ARB_invalidate_subdata (part of OpenGL 4.3 core) entry points are available
 */
#ifndef GL_ARB_invalidate_subdata
#define GL_ARB_invalidate_subdata 1

/**
 *	@def __GENERATE_GL_ARB_invalidate_subdata
 *	@brief if defined, code to initialize GL_ARB_invalidate_subdata (part of OpenGL 4.3 core) entry points is compiled
 */
#define __GENERATE_GL_ARB_invalidate_subdata

extern bool GLEH_ARB_invalidate_subdata; /**< @brief set if GL_ARB_invalidate_subdata is supported */

// no new tokens

/**
 *	@brief invalidate a region of a texture image
 *	@param[in] texture the name of a texture object a subregion of which to invalidate
 *	@param[in] level the level of detail of the texture object within which the region resides
 *	@param[in] xoffset the X offset of the region to be invalidated
 *	@param[in] yoffset the Y offset of the region to be invalidated
 *	@param[in] zoffset the Z offset of the region to be invalidated
 *	@param[in] width the width of the region to be invalidated
 *	@param[in] height the height of the region to be invalidated
 *	@param[in] depth the depth of the region to be invalidated
 */
extern void (GLApi *GLFuncPtrName(glInvalidateTexSubImage))(GLuint texture, int level, int xoffset, int yoffset, int zoffset, GLsizei width, GLsizei height, GLsizei depth);

/**
 *	@brief invalidate the entirety a texture image
 *	@param[in] texture the name of a texture object to invalidate
 *	@param[in] level the level of detail of the texture object to invalidate
 */
extern void (GLApi *GLFuncPtrName(glInvalidateTexImage))(GLuint texture, int level);

/**
 *	@brief invalidate a region of a buffer object's data store
 *	@param[in] buffer the name of a buffer object, a subrange of whose data store to invalidate
 *	@param[in] offset the offset within the buffer's data store of the start of the range to be invalidated
 *	@param[in] length the length of the range within the buffer's data store to be invalidated
 */
extern void (GLApi *GLFuncPtrName(glInvalidateBufferSubData))(GLuint buffer, GLintptr offset, GLsizeiptr length);

/**
 *	@brief invalidate the content of a buffer object's data store
 *	@param[in] buffer the name of a buffer object whose data store to invalidate
 */
extern void (GLApi *GLFuncPtrName(glInvalidateBufferData))(GLuint buffer);

/**
 *	@brief invalidate the content some or all of a framebuffer object's attachments
 *	@param[in] target the target to which the framebuffer is attached. target must be
 *		GL_FRAMEBUFFER, GL_DRAW_FRAMEBUFFER, or GL_READ_FRAMEBUFFER
 *	@param[in] numAttachments the number of entries in the attachments array
 *	@param[in] attachments the address of an array identifying the attachments to be invalidated
 */
extern void (GLApi *GLFuncPtrName(glInvalidateFramebuffer))(GLenum target, GLsizei numAttachments, const GLenum *attachments);

/**
 *	@brief invalidate the content of a region of some or all of a framebuffer object's attachments
 *	@param[in] target the target to which the framebuffer is attached. target must be
 *		GL_FRAMEBUFFER, GL_DRAW_FRAMEBUFFER, or GL_READ_FRAMEBUFFER
 *	@param[in] numAttachments the number of entries in the attachments array
 *	@param[in] attachments the address of an array identifying the attachments to be invalidated
 *	@param[in] x the X offset of the region to be invalidated
 *	@param[in] y the Y offset of the region to be invalidated
 *	@param[in] width the width of the region to be invalidated
 *	@param[in] height the height of the region to be invalidated
 */
extern void (GLApi *GLFuncPtrName(glInvalidateSubFramebuffer))(GLenum target, GLsizei numAttachments, const GLenum *attachments, int x, int y, GLsizei width, GLsizei height);

/**
 *	@def glInvalidateTexSubImage
 *	@brief invalidate a region of a texture image
 *	@param[in] texture the name of a texture object a subregion of which to invalidate
 *	@param[in] level the level of detail of the texture object within which the region resides
 *	@param[in] xoffset the X offset of the region to be invalidated
 *	@param[in] yoffset the Y offset of the region to be invalidated
 *	@param[in] zoffset the Z offset of the region to be invalidated
 *	@param[in] width the width of the region to be invalidated
 *	@param[in] height the height of the region to be invalidated
 *	@param[in] depth the depth of the region to be invalidated
 */
#define glInvalidateTexSubImage(texture,level,xoffset,yoffset,zoffset,width,height,depth) do { GLFuncPtrName(glInvalidateTexSubImage)(texture, level, xoffset, yoffset, zoffset, width, height, depth); GL_AUTOCHECK_BLOCK("glInvalidateTexSubImage", __FILE__, __LINE__); } while(0)

/**
 *	@def glInvalidateTexImage
 *	@brief invalidate the entirety a texture image
 *	@param[in] texture the name of a texture object to invalidate
 *	@param[in] level the level of detail of the texture object to invalidate
 */
#define glInvalidateTexImage(texture,level) do { GLFuncPtrName(glInvalidateTexImage)(texture, level); GL_AUTOCHECK_BLOCK("glInvalidateTexImage", __FILE__, __LINE__); } while(0)

/**
 *	@def glI