/*
								+-----------------------------------+
								|                                   |
								|  ***  Auth / security utils  ***  |
								|                                   |
								|   Copyright   -tHE SWINe- 2015   |
								|                                   |
								|           AuthUtils.cpp           |
								|                                   |
								+-----------------------------------+
*/

/**
 *	@file AuthUtils.cpp
 *	@brief authentication and security utilities
 *	@author -tHE SWINe-
 *	@date 2015-03-21
 */

#include "AuthUtils.h"

/*
 *								=== ~platform utils ===
 */

#if defined(_WIN32) || defined(_WIN64)
#define NOMINMAX
#include <windows.h>
#include <wincrypt.h>

static class CWinCrypt {
protected:
	HCRYPTPROV m_h_crypt;

public:
	CWinCrypt()
	{
		CryptAcquireContext(&m_h_crypt, 0, 0, PROV_RSA_FULL, CRYPT_SILENT);
	}

	~CWinCrypt()
	{
		CryptReleaseContext(m_h_crypt, 0);
	}

	HCRYPTPROV h_Crypt()
	{
		return m_h_crypt;
	}
} _win_crypt; // win32 random number generator initializer

#else // _WIN32 || _WIN64

//#include <random.h> // unix random generator (don't have?)

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h> // sleep()
static void Sleep(int n_millis)
{
	struct timespec t_time;
	memset(&t_time, 0, sizeof(t_time));
	t_time.tv_sec = n_millis / 1000;
	t_time.tv_nsec = (n_millis % 1000) * 1000000;
	nanosleep(&t_time, NULL);
}

#endif // _WIN32 || _WIN64

template <class CType>
static bool GenRand(const CType &r_n_random)
{
#if defined(_WIN32) || defined(_WIN64)
	return CryptGenRandom(_win_crypt.h_Crypt(), sizeof(CType), (BYTE*)&r_n_random) != 0;
#else // _WIN32 || _WIN64
#if 0
	return !get_random_bytes(&r_n_random, sizeof(CType));
#elif 1
	static const char *p_s_randpath = "/dev/random";
	int fp = open(p_s_randpath, O_RDONLY);
	if(fp < 0)
		return false;
	// open as read only

	uint32_t r_n_random;
	if(read(fp, &r_n_random, sizeof(CType)) < 0) {
		close(fp);
		return false;
	}
	// get random data

	return true;
#else // 0
#error "fatal error: no suitable secure random number generator implementation"
	return false; // t_odo - replace by a secure random number generator
#endif // 0
#endif // _WIN32 || _WIN64
}

/*
 *								=== ~platform utils ===
 */

/*
 *								=== CSafeRandom ===
 */

uint32_t CSafeRandom::n_Rand32() // throw(std::runtime_error)
{
	uint32_t n;
	if(!GenRand(n))
		throw std::runtime_error("CSafeRandom::GenRand() failed");
	return n;
}

uint64_t CSafeRandom::n_Rand64() // throw(std::runtime_error)
{
	uint64_t n;
	if(!GenRand(n))
		throw std::runtime_error("CSafeRandom::GenRand() failed");
	return n;
}

/*
 *								=== ~CSafeRandom ===
 */
