#ifndef _VIDEOCOMPARER_H
#define _VIDEOCOMPARER_H


#include "SimilarityMatrix.h"
#include "VideoSequence.h"
#include "KeyFramesExtractor.h"


namespace vmatch {


class VideoComparer {
protected:
	cv::Mat createSimilarityMatrixData(const KeyFrames & kfRef, const KeyFrames & kfQuery) const;
	virtual SimilarityMatrix compareFunc(const KeyFrames & kfRef, const KeyFrames & kfQuery) = 0;

public:
	VideoComparer();
	SimilarityMatrix compare(const KeyFrames & kfRef, const KeyFrames & kfQuery);
};


typedef cv::Ptr<VideoComparer> VideoComparerPtr;


class LSHVideoComparer : public VideoComparer {
protected:
	cv::Mat getDescriptorsMat(const KeyFrames & kf) const;
	virtual SimilarityMatrix compareFunc(const KeyFrames & kfRef, const KeyFrames & kfQuery);

	int countToFind;


public:
	LSHVideoComparer(int CountToFind = 5);
	void setCountToFind(int countToFind);
};


class BruteForceVideoComparer : public VideoComparer {
protected:
	virtual SimilarityMatrix compareFunc(const KeyFrames & kfRef, const KeyFrames & kfQuery);
	
public:
	BruteForceVideoComparer();
};


}


#endif
