#include "VideoMatcher.h"

#include "UberLame_src/Timer.h"

extern bool b_use_autocorr;

namespace vmatch {


VideoMatcher::VideoMatcher(VideoSequenceDataSource::Config config) {
	this->dataSource = VideoSequenceDataSource::create(config);
}


VideoMatcher::VideoMatcher(VideoSequenceDataSourcePtr dataSource) {
	CV_Assert(dataSource != NULL);
	this->dataSource = dataSource;
}

double f_video_time, f_matrix_time, f_matrix_time2;
int length_ref, length_qry;

Segments VideoMatcher::match(const std::string & ref, const std::string & query) {
	CTimer all;

	CV_Assert(ref != "");
	CV_Assert(query != "");

	CTimer t;

	VideoSequenceDataPtr dataRef = dataSource->getSequenceData(ref);
	VideoSequenceDataPtr dataQry = dataSource->getSequenceData(query);

	length_ref = dataRef->getMetaData().length; // in frames
	length_qry = dataQry->getMetaData().length; // in frames

	BruteForceVideoComparer videoComparer;
	NeedlemanWunschSegmentsExtractor segmentsExtractor;

	KeyFrames A = dataRef->getKeyFrames(), B = dataQry->getKeyFrames();

	f_video_time = t.f_Time();

	vmatch::SimilarityMatrix similarityMatrix = videoComparer.compare(A, B);
	// todo - use the GPU similarity here ;)

	vmatch::SimilarityMatrix selfA = videoComparer.compare(A, A);
	vmatch::SimilarityMatrix selfB = videoComparer.compare(B, B);

	f_matrix_time = t.f_Time() - f_video_time;

	if(b_use_autocorr) {
		{
			cv::Mat frame, frame1, frame2;
			vmatch::SimilarityMatrix selfAi = selfA.inv();
			selfAi.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("selfA-inv.png", frame2);
		}
		{
			cv::Mat frame, frame1, frame2;
			vmatch::SimilarityMatrix selfBi = selfB.inv();
			selfBi.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("selfB-inv.png", frame2);
		}
		{
			cv::Mat frame, frame1, frame2;
			selfA.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("selfA.png", frame2);
		}
		{
			cv::Mat frame, frame1, frame2;
			selfB.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("selfB.png", frame2);
		}
		{
			cv::Mat frame, frame1, frame2;
			similarityMatrix.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("similarityMatrix.png", frame2);
		}
		cv::Mat temp = selfA.inv() * (cv::Mat)similarityMatrix; // lol, opencv expression template fail
		similarityMatrix = (cv::Mat)(temp * selfB.inv());
		similarityMatrix.normalize();
		{
			cv::Mat frame, frame1, frame2;
			similarityMatrix.render(frame);
			cv::cvtColor(frame, frame1, CV_GRAY2BGR);
			const float scl = 4;
			cv::resize(frame1, frame2, cv::Size(0, 0), scl, scl, cv::INTER_NEAREST);
			cv::imwrite("similarityMatrixAuto.png", frame2);
		}
	}
	// do this

	f_matrix_time2 = t.f_Time() - f_video_time - f_matrix_time;

	/*similarityMatrix.normalize();
	cv::Mat frojm;
	similarityMatrix.render(frojm);

	cv::namedWindow("smat", cv::WINDOW_NORMAL);
	cv::resizeWindow("smat", 512, 512);
	cv::imshow("smat", frojm);
	cv::waitKey(0);*/

 	Segments segments = segmentsExtractor.extract(similarityMatrix, dataRef, dataQry);

	double f_total_time = all.f_Time();

	FILE *p_fw;
	if((p_fw = fopen("timing_logs.txt", "a"))) {
		fprintf(p_fw, "%s;%.5f;%d;%d;%.5f;%.5f\n", ref.c_str(), f_total_time,
			similarityMatrix.rows, similarityMatrix.cols,
			dataRef->getMetaData().length / dataRef->getMetaData().fps,
			dataQry->getMetaData().length / dataQry->getMetaData().fps);
		fclose(p_fw);
	} else
		fprintf(stderr, "error: failed to write log\n");

	return segments;
}


}
