#include "VideoSequenceData.h"


namespace vmatch {


const std::string VideoSequenceData::NODE_VIDEOSEQUENCE = "sequence";
const std::string VideoSequenceData::NODE_KEYFRAMES = "keyframes";
const std::string VideoSequenceData::NODE_METADATA = "meta";
const std::string VideoSequenceData::NODE_ADDITIONAL = "additional";


VideoSequenceData::VideoSequenceData() {
	init();
}


VideoSequenceData::VideoSequenceData(const KeyFrames keyFrames, const VideoSequence::MetaData metaData, const VideoSequenceData::Additional additional) {
	init();
	
	this->keyFrames = keyFrames;
	this->metaData = metaData;
	this->additional = additional;
	this->readOk = true;
}


VideoSequenceData::VideoSequenceData(const std::string & filename) {
	init();	
	read(filename);
}


void VideoSequenceData::init() {
	readOk = false;
}


void VideoSequenceData::read(cv::FileNode & nd) {
	if(nd.empty()) {
		CV_Error(CV_StsParseError, "Invalid input file.");
	}

	cv::FileNode ndKeyFrames = nd[NODE_KEYFRAMES];
	cv::FileNode ndMetaData = nd[NODE_METADATA];
	cv::FileNode ndAdditional = nd[NODE_ADDITIONAL];

	if(ndKeyFrames.empty() || ndMetaData.empty() || ndAdditional.empty()) {
		CV_Error(CV_StsParseError, "Invalid input file.");
	}

	keyFrames.read(ndKeyFrames);
	metaData.read(ndMetaData);
	additional.read(ndAdditional);

	readOk = true;
}


void VideoSequenceData::read(const std::string & filename) {
	cv::FileStorage fs(filename, cv::FileStorage::READ);
#ifdef linux
	read(fs[NODE_VIDEOSEQUENCE]);
#else
	read((cv::FileNode &)(fs[NODE_VIDEOSEQUENCE]));
#endif
}


void VideoSequenceData::write(cv::FileStorage & fs) const {
	CV_Assert(readOk);

	fs << NODE_VIDEOSEQUENCE << "{";

		fs << NODE_KEYFRAMES << "{";
		keyFrames.write(fs);
		fs << "}";

		fs << NODE_METADATA << "{";
		metaData.write(fs);
		fs << "}";

		fs << NODE_ADDITIONAL << "{";
		additional.write(fs);
		fs << "}";

	fs << "}";
}


void VideoSequenceData::write(const std::string & filename) const {
	cv::FileStorage fs(filename, cv::FileStorage::WRITE);
	write(fs);
}


KeyFrames VideoSequenceData::getKeyFrames() const {
	CV_Assert(readOk);
	return keyFrames;
}


VideoSequence::MetaData VideoSequenceData::getMetaData() const {
	CV_Assert(readOk);
	return metaData;
}


VideoSequenceData::Additional VideoSequenceData::getAdditional() const {
	CV_Assert(readOk);
	return additional;
}


VideoSequenceData::Additional::Additional() {
}


void VideoSequenceData::Additional::read(cv::FileNode & nd) {
}


void VideoSequenceData::Additional::write(cv::FileStorage & fs) const {
}


}
