#ifndef _VIDEOSEQUENCEDATASOURCE_H
#define _VIDEOSEQUENCEDATASOURCE_H


#include "VideoSequenceData.h"
#include "FrameDescriptorExtractor.h"
#include "KeyFramesExtractor.h"


namespace vmatch {


class VideoSequenceDataSource;
class ColHistVideoSequenceDataSource;
typedef cv::Ptr<VideoSequenceDataSource> VideoSequenceDataSourcePtr;


class VideoSequenceDataSource {
private:
	static const std::string EXT_PREPROCESSED_1;
	static const std::string EXT_PREPROCESSED_2;

public:
	typedef enum {
		CONF_COLHIST
	} Config;

private:
	FrameDescriptorExtractorPtr frameDescriptorExtractor;
	KeyFramesExtractorPtr keyFramesExtractor;

protected:
	VideoSequenceDataSource();
	bool isPreprocessedLocal(const std::string & name) const;

public:
	VideoSequenceDataSource(FrameDescriptorExtractorPtr frameDescriptorExtractor, KeyFramesExtractorPtr keyFramesExtractor);
	FrameDescriptorExtractorPtr getFrameDescriptorExtractor();
	void setFrameDescriptorExtractor(FrameDescriptorExtractorPtr frameDescriptorExtractor);
	KeyFramesExtractorPtr getKeyFramesExtractor();
	void setKeyFramesExtractor(KeyFramesExtractorPtr keyFramesExtractor);
	
	VideoSequenceDataPtr getSequenceData(std::string name);
	virtual VideoSequenceDataPtr getSequenceDataLocal(std::string name);
#ifdef VTAPI
	virtual VideoSequenceDataPtr getSequenceDataVt(std::string name) = 0;
#endif

	static VideoSequenceDataSourcePtr create(Config config);
};


class ColHistVideoSequenceDataSource : public VideoSequenceDataSource {
public:
	ColHistVideoSequenceDataSource();
#ifdef VTAPI
	virtual VideoSequenceDataPtr getSequenceDataVt(std::string name);
#endif
};



}


#endif
