/*
								+----------------------------------+
								|                                  |
								| ***  Random generator model  *** |
								|                                  |
								|   Copyright  -tHE SWINe- 2007   |
								|                                  |
								|            RandSafe.h            |
								|                                  |
								+----------------------------------+
*/

#pragma once
#ifndef __CRYPTOSAFE_RANDOM_GENERATORS_INCLUDED
#define __CRYPTOSAFE_RANDOM_GENERATORS_INCLUDED

/**
 *	@file RandSafe.h
 *	@brief cryptographically safe random generator
 *	@date 2007
 *	@author -tHE SWINe-
 */

#include "Integer.h"
#include "RandGen.h" // the generator model

/**
 *	@brief cryptographically secure random number generator
 */
template <bool b_use_virtual_interface = true>
class CSafeRandom : public CRandomGeneratorFloatImpl<
	CSafeRandom<b_use_virtual_interface>, b_use_virtual_interface> {
public:
	/**
	 *	@brief random number generator traits, stored as enum
	 */
	enum {
		b_seedable = false, /**< @brief seed not ignored flag */
		b_64bit_rand = true, /**< @brief 64-bit random number capability flag */
		b_crypto_safe = true, /**< @brief cryptographically safe flag */
		b_fast_floats = false /**< @brief fast (possibly lower quality) floating point random number generation flag */
	};

public:
	/**
	 *	@brief seed function, provided for compatibility with other generators (has no effect)
	 *	@param[in] n_seed is random generator seed (unused)
	 */
	inline void Seed(unsigned int UNUSED(n_seed))
	{}

	/**
	 *	@brief seed function, provided for compatibility with other generators (has no effect)
	 *	@param[in] n_seed is random generator seed (unused)
	 */
	inline void Seed64(uint64_t UNUSED(n_seed))
	{}

	/**
	 *	@brief generates a 32-bit unsigned random number
	 *	@return Returns the generated random number.
	 *	@note This function throws std::runtime_error on generator error.
	 */
	uint32_t n_Rand32(); // throw(std::runtime_error)

	/**
	 *	@brief generates a 64-bit unsigned random number
	 *	@return Returns the generated random number.
	 *	@note This function throws std::runtime_error on generator error.
	 */
	uint64_t n_Rand64(); // throw(std::runtime_error)
};

#endif // !__CRYPTOSAFE_RANDOM_GENERATORS_INCLUDED
