#ifndef __CL_KERNEL_STATIC_ASSERT_INCLUDED
#define __CL_KERNEL_STATIC_ASSERT_INCLUDED

/**
 *	@def CONCAT2
 *	@brief inner macro for token pasting (use \ref CONCAT instead)
 */
#define CONCAT2(pre,post) pre##post

/**
 *	@def CONCAT
 *	@brief macro for token pasting
 */
#define CONCAT(pre,post) CONCAT2(pre, post)

/**
 *	@def EXPAND
 *	@brief macro for explicit token expansion before token pasting
 */
#define EXPAND(x) x

/**
 *	@def STATIC_ASSERT
 *
 *	@param[in] b_condition is asserted condition (must be a compile-time constant)
 *	@param[in] message_token is message token (use upper-case, must be a valid "C" identifier)
 *
 *	@brief static assertion macro
 */
#define STATIC_ASSERT(b_condition,message_token) \
	typedef struct { int message_token[(b_condition)? 1 : -1]; } CONCAT(static_assertion_helper_, __COUNTER__)
//	typedef struct { int message_token[!!(b_condition)]; } CONCAT(static_assertion_helper_, __COUNTER__) // new NVIDIA drivers ignore 0-size arrays
//	typedef struct { int message_token : !!(b_condition); } CONCAT(static_assertion_helper_, __COUNTER__) // new NVIDIA drivers won't compile bitfields anymore

#endif // !__CL_KERNEL_STATIC_ASSERT_INCLUDED
