/**
 *	@file e:\my-projects\UberLame_src\gpgpu\kernels\\ScanReducev3Src.h
 *	@brief file in header, generated from 'e:\my-projects\UberLame_src\gpgpu\kernels\ScanReducev3.c'
 *		using BWT / RLE / Huff / Base85 pipe
 *	@date 2016-07-18 10:12:26
 *	@author FileToHeader v2.03 (built Jun 30 2016)
 */

#pragma once
#ifndef __E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SCANREDUCEV3_C_FILE_IN_HEADER_INCLUDED
#define __E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SCANREDUCEV3_C_FILE_IN_HEADER_INCLUDED

/**
 *	@brief file in header, generated from 'e:\my-projects\UberLame_src\gpgpu\kernels\ScanReducev3.c'
 */
class CScanReducev3 {
public:
	/**
	 *	@brief gets size of the data
	 *	@return Returns size of the data, in bytes, not including the terminating zero.
	 */
	static inline size_t n_Size()
	{
		return 65731; // original file 143043 B
	}

	/**
	 *	@brief determines whether the stored string is dynamically allocated
	 *	@return Returns true if the caller of p_Data() needs to free the memory.
	 */
	static inline bool b_Dynamic()
	{
		return true;
	}

	/**
	 *	@brief gets CRC
	 *	@return Returns CRC32 of the stored data.
	 *	@note The stored CRC may differ from the original file if data processing was enabled.
	 */
	static inline uint32_t n_CRC32()
	{
		return 0xacf3dc70; // original file 0x8a301505
	}

	/**
	 *	@brief gets data
	 *
	 *	@return Returns data of the file on success, 0 on failure (not enough memory).
	 *
	 *	@note The data (despite it may be binary), is additionally null terminated to make
	 *		it easier to use (the terminating null is not counted in n_Size()).
	 *	@note See also b_Dynamic().
	 */
	static inline char *p_Data()
	{
		const char *p_s_base85 = "~0RR910RR910ssI21^@s62LJ#73IG5A4gdfE4gdfE6aWAK8UO$Q9{>OV3;+NC8~^|"
			"S~~009C81Oo;K2@MDj5egLy3l0+y7ZMaD9T^)I9~dDo948(l|0x<ZD<Ul*Br_&GJ25OpQ9md{K{-oJDljg0Hcw"
			"YKM>Ik*Q%PlAb3A!feQj@FVS!ROK6_(8m6=dVS&6H4adLcTX^}{mhdOv,@mox<u~v3ye|m7!bni~1skghqM2)q"
			"jequ(8vyb=tg;cFtT$5gExon%A#mURfpVisj<LB+6Zom1bv+AEq^>J{GOBs1oc7mub=>#Vr!l{fz5MBUk0&$se"
			"kchUBh,quHT1Z4!15lDV7YNp^rSK9Ln1UBk1TBLlq,i<O,~;X62+4dT5U65=2~1.T$sk_1DgwyNfgny^fp=8K^"
			"ez#ioMgT72v-b~jFv>yq6&s+f(WnwMvAm(tO-OH{zE0WWVVep{vgy<CckKDFI;9.Mw0(ID1!gwWUv,7lbC6*Fw"
			"kFUW.!r{7fGCM#c<5OjA$.NApvxs+#mH&Z-xJ8mO!+Uq6w!jLK2wCU@}xMND{Qg2@!20FzUnkm-8<;(OJfIxMo"
			"=rLo<w)(hMw&P=PO4XfNj(m7^t))Lli4kLXzp%A}^5at#G=%$ycLyhAeH4MM~rZ7h&-HqpFmA*iTAQfCEILJ))"
			"$SPYg%GC+kwUgeOFXvux@%jCse8ODr#QNE)3!%0wRrw70n7|yp1_9c=U;ijfaC{7C@vR.7m6sEwH5ftG!A^oqD"
			"nEDIYC4kaXB#E|.3@*W>yG!JQGW!Pvn>1Q%W>B)>p&5+H!BiG-Q!hx8ZV+4,xJ_(^NJw2nMNnp3g_KA0FJK;L<"
			"j#zcMFLGY#Sz7<Su~;!B+Zm,oo^I,goOsQ9%!4FvnjJUDuU8MNjNp8h#*Kqp,2tpSO{1G+6rSOfXtj4W31jVK+"
			"7Wdf|{5|#COo_z=RQ;A&gq2B_^QBX$<>A4(M6tG)jLg$b#_(PPztU;f)M,ADsU)e9!L(6PTkgSk7YeCexJ&JzA"
			"yqSTP4PRR,l-4}oKZRY*xoAd8xk1Ti&eTSEK7_LT!ujYUHik_svUnPVX~(4_%f5TMC91{Oq<Nn8-Ap&=nX-f~b"
			"0)Rw0wXg)za0a_7o%Ap&9rV+>)#;Z_iuXrgid;wH-q#ps(l4%=UBd{YdQ#4=nBoqZ,JCbmu!A#L#$-McaH>-r)"
			")QcgM7#{)-Eug&s&I;gZnjo0IK<+{(^z9&pP+q7$0J}&llY|^2Kvx_LBru(#wvvekxEkUY3wT1&lzRc@UWm4c="
			"Nc^G2RNfk;8,{t9l_isP@95qdV{z{!Zik<Cq76O6-u$04>qRg5ier.p,{E4X*sJPhA5D&IFMM*rU-+C=5Z#bGR"
			"GN6wKU9ZVoO4)dzA;|2{{BOEI^.,ci9W&W.ROB.u9yms1=|+0kS#MAY>*.Axsp;wK*n4KA0y3*g^KGp6.O2oIk"
			"WL|6jrvce9|>-o#*wHySqc&-+DWzn3|T!;}>PcmY~yxIVt<9d)=H%xXY^,Q+6**dUQ>83.K@+8&#OD~w~,NAn8"
			"<uiic5>i;49Hmv_spPp*.5h0pnFXhK0mQw,5k%-6Jpx^SXq,#1B>T3S5yo-t$9-K;dNQc<hkm#|QA=-wlL-{lp"
			"-d#}BQb-e)NJBY}Ifw)%3CrAs1.z+,2wV%87Q*-$1e_C)%q-yi!5<(qki1zK@D(UZptcgQ8z5%|LI_kOz^V;#3"
			"ZKic7pP<U4@i&HsV._(d|YKMgdBsGFpM^W+8p==lMas|Bniw=ZVnlQW)s>OOo#Q0v}!Afcft-yM2*1N7{rfr^$"
			"X.@a>NQ(5|Mv*><yj{AE@Jf9MuNEB<BXSP(3=c%!Wa+$RV6-o2YLZb23=QNw26w0umu<3;T~y!N^47<1v)OzGC"
			"3cHTTfvVGXS05B1bJs2f~%kX2kWFPM_!JT)Nl&5@!<huIHFCmM8fG(;eKjY>fgKu!^<qk16,f#a;^l_L~I4-HW"
			"oFkp<f0^DkgKoH403TA|ad$59;1V-Z&N+Hzdxv-$ncolQwc%xF0CSgIy#R!5W5uP!GUL2$m2(b)Dh^-+P@YKgx"
			"dmy(B-yLT!{Wybj(7$2C#_v=%TtUXD+$y9zGHec4M#hO0F_Ak+U);uJpP;~2nUr!XShmA9V-_S.<{>#f!C#n$Y"
			"BfSLAdhZgnq~5#P8|+eWE}n12;d$30q,$*BHXG%M$7^ZW8oqh4{VD.P*n;!DFmn%xF;obe^w4-iICFDV5Uki8i"
			"kT3ECSku93ha.T1I$a4.v8^P;>vwgMr4H(s_6gkbwyZ%~47)p(n~+*Dr,ToX~_KBj*Njq_Q!$,hV.l)uURoo||"
			"QsiFE=zAg&J,Biy)U-l45^3ShGe;,S)XJ2FnpleCg$Ly7|EBF91psf>NHAk_z{eF9{-NIV{)M-K~)4rc~%vY_}"
			"7T*_f&%RGe5coIY<P,;+9#*wC#lg-T0e$qKjoE^<;^uqIi7{=p^Sb+pO#P|@Lqn(9QiI8PT9G1SRx$VY!*cO42"
			"XFwqG8HD6Mkf.BO4h&c#km~UWPCC#b2osm1(V9PX+q{NQ6G@^XBrqWnaG8);A.Od}2DF3*^.^7ug0!+0B-z3_%"
			"zpsj%48CcfE~g+$T+A$l5vul>4>=mH3%q^Tnx#OGDA5AWaa4tLV>RU=D>nD9LAuA%Q#0O98Iq}zA2Dovk3,K%m"
			"Nb$@QmwuWH>|1Le6^*TpZA>;asPzXx<f.Ghkz=xJLVlWr@Kts<IioTqxm(F%B}@i!km~g~Y94+%do,z!gSi-46"
			"D^x9bD^;oSNJA}0r+PJssu|9r6rTXGU$SQ0.JV5S2lf#0{fp(N8}35YEbpl!I#iw0HI90qK*m$1Q^!Bp=!f)EJ"
			"bP)as~)Rz#<<hsK(z|;ieC4t=MFHJ@wqDT.S>m$o<FeYj{#vBj8s(2S)aiQlmL_pZ04r4w6;Woe(Lc347c@sn4"
			"qR)#mz5_-K@sF(uOK}IaI5q&P7r0qaRR!2dh4D-pVDvAuIK#L#LT(AdZVAmyL^zLF.l}zQ*953oiw3|l$c5$.2"
			"J1o.1ROG;Dux&XI7XnH6NFrCYe+@QHK2Daas+5JM{5LyoE8As1-n8OAlg--vd~t7;~UA9LUxj{zRN*cU$,Pdh3"
			"F!k!RSf>7cXGM=b4WY6MN>s9)zM3$ROkpsxnmy)MjksCA@3b7)GJqbIZ<6DtD7rkTW2Hq-Zw>JBJT+XNS}a+!@"
			"JO8t^6MHCMnBz&NclSQ5l#K!prYAhxEh3M9Cr,.*ubGE@n;SuvU}3C{W!B5{~xgqfyZgbM&|fZj4tfZIuT0dbA"
			"Z%cPefv#Md(;H.=aA<z4%%u)nP%r$VhBWPi1EoTzW5~weH8OT6hu,S_#km|G+;8u{xZi5sE8inkEH@*#MH{}}k"
			"={isMjrz;5A^PWkm_huYfd!z+!D$6BUjdHpJ.tvnSi.pe1CC~IX$J454)+PJ(g1,UeyA&qUBb~h3x&{YNI5@K-"
			"S<KjHGisO6F6GE2Ymt%qJ$sy#evlilJNYJOqN+8AG<FC4nY*5dIq*MF-;O8a!Ma}7Y_}gufQGt>14@^v.p+P95"
			"gs<s7=B;L1bt,5RmDGGlFJPVFsl-kg=6P+-gP4(H#a%<.#p-b2G;9P|3_-5%pyoPIoomAmR+cl<Tna^#mL{L_{"
			"AYnui*,;H.YXk*0J!I&|i!W-JPYz{bAAy;7rtFp!Y6gsKy9ry3SbgYa4m<(v4msJPKo8J0surnN9pA~9z*aX@2"
			"J15_5$$}l!SstV9+LY}xQM#4Kx+Tb#SQQ8x&Tt1ac<X98+3pfKN@(@D#NFiwjkT3R~<Pq*#tqx@o4.,NY25TI~"
			"#)yZZWNmWmL3qm,3v~%@2B1cP90)M5H6w1M=^RxHE-~Z~gyAO(9I+u;LsB~Agb%nQXf80#Q(kJQ@*q^rX)Me_h"
			"OPk<2&!.Ks7G)!1ku;(m+fOcM_H^)y3<B&XU4rx>77YBf}qe;JMu(i+).jDl%Xg_I=Ibu7=;KM9mZcA#&x9YUa"
			"JfwBqed7@@u!V{Eb4$qAAaBT0Ab$$(Tf=#UH.lNNpoSy-}1LWfvfi8=9-HHhAVU(^lYj8W5;&b2bbg5GjX71QA"
			"z0Dsvtk0.8;Fh4~M6X77s0mkqRT1;%RPGYE4ffiBQa3nC6S!pIcogvda-)0o5|M}wWj7G6bYPZ9=!P!$UhiDVc"
			"!N~EeC4quq4LjzngiV9u~<e<j8L2n6MK^M812WmoaYe-IP<g+6uFP-H0r$gezK!zChOT;8.Jz*A5<z^Dl5hD=q"
			"dckE*D{~i!pRmSlSPa>&IJwPd.3V;FKI53YyPe4Albl&$#^BcmBB.0.aAyYE9Ijbuw,)+pdrdcgpf&CYIoyOBf"
			"=,-K%5jXEDNygALJ&ATo%lyJ6a<_!Ih#1zFD*,4mk>gvA}#0KdILqBQY.WkX*EF;A.CopVSqiObL(@;xxt3G8X"
			"%*M;T4p_3<AqS,$NG{i-Y7GxEe1q$uliZ4Km2YXL3#oW,rapD@N}tjR-)2RF.)kd>9(j8sdQj*v{s>k,LurL-j"
			"v}%OND0!&8R.jn14Npq#%;68#j&F>$eJkdlp0jbImo3x.PkJ.RKYNt3A56-a0n1)HD,fYwTdkB5XF45jN3#FpT"
			"LkYacQ9B4*{C_@pn6P@n>UsO{,r0X)KY8T(F.mG7eT}F#k6M}G!qa,ttaK>RejiEWIxooBAx-T)kyQW_l<,Q#."
			"$(A8dyswj_<RRr3jK|6d6+v$#fq&p1x%2@z$xvjogk}r-#-5ifOMtrI)qvRMm}hbhPGyk@XQ<Xg)*+nbv@_Zr%"
			"R)AiaK8Yt!hiam&&fLXb<dbD.d,8raW1G.Q0BlrcL=ye#)fwqGJ1SbfL<HJXkIib#&G2gE*Y>0U=hGHIB{S@T-"
			"yMfgSgnf1TZwr%|b#9.i$<^f^deCP%^gxtfv..L&D*UgdDRFvE0>II;JEDToafzp~1Y@FyRCWa|Mtyn)uuj92C"
			"hR4zC1-oP!GDNEE.2nNWXA5x6%0-XBT9U,vEPOF_4T&>6$qsV_)7sRB+>AE%%.Ee|C^+8kf19s=m>s7GAaxA7f"
			"&.oAj9F;Hm0AeJ==+DrX,qR>=0Dit!VW).U}#*sNl9yWt^1Nwp6P|.sIt5E-CLEMK|e}{N+brOIng3b#7X@bCJ"
			"X^,~|R+q&BR)bm^T)$vAs6(_)YUT^hW92.qA-u=u40y}ja86l~=P{UkbtNEajL.~y82Ew3kW%6r3oQn5s<V)Y,"
			"@y~exK,p_2pwJsBQR41F_M,CYP6CFTxvmmPq!4NS*Y-x${MC>3438TIpzpG0@NZUE(%&SX5oXGn9@)v;U7@doF"
			"p1TPH}vJpun&qS-5Qp!#u,HV4UUGkZF#l879g)M&i>kooyu_WL~H&fjI;xG1eeuF{b=uGN{Xn(g<ffKh|qJ1+Z"
			"K~VBiFtmT<ksiqc|.giX&5vH_qmc&3nqFVG65,~={1R6bWTSRu|QbFaP793a4%xE.wf7#J>NWuc#7N,w)n;OF}"
			"!IZL+.Lh2!$P8=>0b6%k5I70K5)4jwTp+h;mCJ}O2*,##B_z7ZyYVe4oGg2%G5HWK%cyfgDa#3R&Nj4@f4CZa%"
			".Rz&MCk,huusK6RmQXcEA(GA)x!0&1iG2}ZoW4Ng+CynaG%#WsD9%D6nFthfTVfXyH1*-.9PtSp-*yE@VBK(T!"
			"1C@KGY0,sxIqIOmr>r5;u~zl#*)C&=W-$oUeg0G#wIRbq<}M=Q4KVpMg%aK2nuDE1fw)kg^idx+|fJD1|emn7="
			"xY6#-O|^OC+&NT}#+P*6D>ZYuk~WCJ2FWaTW#PCm~W3AdIRXa.oC49-DeDEQl{HPQPB9zR_+8dQX7tb6ZRjW(K"
			"s@fdUXZxYzEWjqEG*xX<2jgN-RvmG2nfSq0J9+$UTRkrl4.(L9_qI6,2~N@0yd*>Hw(5>asPxJklp5U4YmoLK}"
			"}!frM(sL423<2$%T&b;3gLj0eBC}kUtSV_I0fubyn6-y(0rq~zQ;FQ6fGgL5g#(;EMUtLqhCk*ZpaE<|uq!lc4"
			"8bu*23lVcicq$O0Y91K8L5x~TF=qrp!xs*W0y)S,X9nmbkqe6ua3.0D31CAZc>+Ae=rj#5Y8GZVGeyJ5;NG#KA"
			",pb&oZ#y(;D$COS;5R(HQ|%-hU-HsLROk44E0CG;o)*zzQDhD6,;QGd9EAI&K.Sav~QVYLLzWg1<W6H!F<5;1@"
			"=KqXsR07h7ttZh$GjT.ftQ=LxMw$FeDA6B;jL&P=rL|I&q+|1yEkN(Om}u5Rm9-.FQH~T!bB)#57m!kc.aRgU7"
			"gojij*%9Zcs)LJ%PWa}<OMfU}pR33~ww27X|Lq2k&@<U7uLcm}ZUoudaRFn7-AoII{(|1t6h#!u,Q@QchXpsHW"
			"Ocf<B~2Z6|5Ck25Ihvjd.GK|PDw2YOc5V9S9(JjdMTqAJU$NvzW!Sw#H)-|E<ahJdlt|ak3=V>Sh@Z1*c2l51N"
			"4fz@o*b8x,!BCY$Q<Bsiv@G0y;Lcy9Bx(6V,;6Cy(;_$)USu,KY6#K_;O_8{N3,IaY-sDORt#.p=98ZzHYH9Fl"
			"ZJ_hJ)pWzKrj5sa0flctizlE>yY!3)(!vhjZOoAv-gN_9k>HfZd~qJX^{SKSOez.Tnn^4PM~Rmm..tN3ph4JF)"
			",{PV6%n3;U)#$2vmoSMaJ5y61XY2Zgr41F=mr#rOP@9k#L6@u3@YsM6Ll{fqw~pA,HIyWKIEgmRvarl9*r8dI4"
			"Yx;,QD@){;ytf;2N|2QfdR@fLT{irPbfPBSl1ltEA+<0YhmX2=zwxWT+ejX=S)<#PRDtd}t>LZ4_Y*h5*9hBFR"
			")30M;8KA{h$DiXjKxDP;H_-Js|aA~+9Qdt7,0lecjUUC^8iI8(0flVOXAq#>$Aq#>#11pAZ9.<pZLzsQUrVDsO"
			"AfMI_S{7<5cdi-na!DEf_-W({=>_x-2$M3K27-AErJQI_B3VL9pp=1ngGOF(vq>+P=_Ry+HPCOl=*a6@dD7T&h"
			"lDv.(ZUrufjPy@NGuEv@xtYn8O<JWvBufWkY(Zz3y^WXQeB|ihNpkr2KNE7FP7v-+2k)q<SGV@!N2c>bdBowFj"
			"kC{nvj!tY%<xT*4d>lfI+kE49&EY3f~ZG.IjS=.gH2maE8F><O>{@uz#!@DndlQ@sEE1mLsb<69pBFm.*Ji!b7"
			"ZCFejjB(nC}UsahF%f.7#hW6kf9@a;192x~0Z5x9iPbf1K5_k1Lr6$p3FiO728_z=KX5X7_28m<QXC7K+kUXsX"
			"+DuUb)xFczQQO*(A9Ijb$2|w$NCiezbdBZD%KgtV94h{x!+GeB+$}l(3Ar^1_3~v}KJO<58gqotb8|MaaSP(+^"
			"NFja@^3*JH{YS<P!WeY|*c7y}2Lkd9HS>_TTf(3Hg5C.xLDOv;o(@68<%}U*5c+,F17{@=R2etl2+Siu*KjXzX"
			"v;,F#%Q.!g8z_Y+X7b&n<pT{T0-J82)NNx3mh!&g8HD;88&cUs5gvl+#M(Q16*Q)@X,NZ(Qi;1W;vo33gEI~8-"
			"|>28Xnu1rt1y#2{=pf16)}XLA#ih<4)pHB|i|.uNck7;mb2$l<^6W%(jB@15gzRF.C5yJ.9UPaB(<C12!QY26*"
			"<3#iC.6.,egT1=tgyE-|Cwak*^u1AdU5z,OvvL!<2wiN(Sjs!Nm,ILT=RoE1iB=LpmzXe&W&B!P4s33re%f_x#"
			"z.gRM9JQIwYAX-AohK(atzYtH@CA,sZ*9iAXSPy_VP({ITf|&)urr_fD!C(!LH9}wFS<B0b9mK1lCj{YZg1|0t"
			"Sr@3V&1nb,aD$u(WJL%YIe*4RBD84k.F{)ExQIYC@r}}cVi6OKl5o}9Nd{ZX;D#aZmSz~UagK9vI,;<V^*.-U_"
			"f$KT4hx7zH}IMuY|=O.f^)4PUl8G-7SdRnu9*$SyMpVDOqd&3GnlZV5t*Sy4j+wRLIU-JPiZCxm_~t0g+0O.WV"
			"k{b0d^KB2KP=fUSbGbBpjb;H|vnZ+v*LndkHv0cxH0M5{<z}2K&ZnKp87G0^SvHeZfzv8Kw}p9^sU*4UP@}0$("
			".,$f$99T#@-B0P=Vk=;=KHuLIfi@&;h$K#(K}e@2qb#g$VfnY=r$8;Z+Tfi56KHx1X^sSF9^ONbg_JBC~K5Zph"
			"IJI+dHa#J<qiKtykfz^Qo),HFn!BmuTA-snxH{vufgW3xD1CQ&3JwUeN8MkQZKWHaF%7vZ(+z)!DK22v(CkSo@"
			"#t^_{oD~8y2+$,mhQm.@A~61N^tjMY3)Km1ArdnzVkhOGQ}zff6v3zqBE}HkP-MMANeRJvqcZFug=jTMA$f=)Z"
			"v}8Jz+Hrp%cvXuBP8S(EGA3#Mcb0rAVN$hIsQnDfdobcF}&.C,cpJSb&3hhGifoB(E*kL8JaB@vUPQPIMmS0LK"
			"osrgr*UgU!-V8X1HR9G8$ga0M2)!3S{._A#9l^8EB!a#DS2}XB}A-!.<UlbM+qA7<PF>jL-;T;wP{lvd#.VC=-"
			"t7@<bd$;7$_zaZbWJ=x}K.VnQg+Dim,>frbxjVJd{KCCYXB*9KS}.eSc>m}ZTJ@fn;b;GES{BfcbY@)Bk_.Js6"
			"KV%QDhrNQCt2bm{}r!~~~o2b-gI-D(X7oOjohET_FPuwr3bJw|fbeiF+fiTWm=8j>=1hLpz*}iVi3nD@i,{5@g"
			"fYHbmL0}2NI41<)stVBevyBK,K^asr(h{i;5##fOXc3rMP*#kVz*Gfj>VT>WgDwXSz7Si6vsBE,CCk^#wdV*BP"
			"X}vaX8Fg9KzOs|L6(b)7UW}qWZ|0Qf~F!6oN5O5EZrouIWJHZq>v{GRL6j=k;PmPaE!rRU#!v{$&Im4mRzxFDO"
			"udn$.A}&UTopl;|b(Tgf9KDtl;DcT57W1@O|0.T5Dy{cN!gbMmtC|MqsT4Q<Vr2fQUvbjFTl73ve.bnKV;_If@"
			"X>w3xaRG+f1)Q6l3sT#^N(vMiK#9r%pVAGtKD8cLbG#3nSxrf;Y>ePCafK_=QVR2e4(;HnA1RK07StK~S*nhTW"
			"+;-Z;aGb)<dGGxl)4jXPc*BQofoMcO,7gwkqZZcnFk_6zYYw8drAa>vp0s)D$JjUIxNn>l};Gf|.2PsZ,{T#e@"
			",5F-8e,d+fQ=Db@a0~=2;HnAB5)zrfga|;Ek{knM3BhCw0t_mWK&}PGA2*N|@)(,23nInsXto~#4%5@!3#tpm9"
			"*hBC3Bg<npw0,#5c33kptg+_&>mh8TxKmLN!.EnVSx**mH~bM-6tV^lu)EIg_sQ%m|46d+7tZ1*aT)1a8(a)_z"
			"5v$+!Jt@)-1R^4@0iY7!b^ml}I6dk_b}.xdaZTNipu!u@Ho6GJ}>RB|=IAcR{LxYJ.JvOCt!uOtB#@F_NGs1ya"
			"U~MRF2AoV^JPA(Eg%;7(&0Ay}plfJ20m2G|hn4Az8yu!1o01!_auhHen9(7zyGycG5VJ_A.MVId+o0{viL+(8$"
			"*nFOTdkrh%AS|&PXTL>Z!Si>RF2L{O0fgnU,NrAua1-u~PIhxoK1REUDv21S)S}n$6%$hN6r+Ex95+#h#f>}lk"
			"NzVU(gdN%rBs;;.CKp-@AhM(ostW=f30w>21)PEx2q!E+mO!ut,9@12lDHP|TxEzt{NVKrY7OEvKy<RvopJ+o4"
			"Q!lc.)DO3cN;Qu6bMAtK%Bh@6N7(XQefE)W.mp~t,~0y,yl&CYdY8H2K*ywU-Jyp=pf|&xOf~b=|8B}s1yVc><"
			"C;E;UT132qAsq|7Y3yu,>1s=k}Z|pnO(,f4UIp4L%}TJ|aJ^5blDwAwm%wAck;VC+h{d28ss{N&90rrlEZS|7d"
			"Jh!up+lflM)|ErVRWak>}U87>jGH<)c%,GQ=5#q)-rpfxeHY!##t;o%zX-2snD^M#IMQU%@$U,s|DJ.9U%X=gk"
			"HvMfYQ&J5!+<P6_1Wl)D8a=3dn2<IW*FmP%Rp(+-B$uqAZmNf.0W.(|kmr2YXPu~vbAS*$3g4hdSTT&Gjq2BNU"
			"@&iy8*9G<gWHi@wvL+<-nzS*P^PxV%3,cQ|sBmfnI4lS-t_HvrMzb{mcmk9T34;9KxdGh0985!aN2KTl-37=CX"
			"f|+M!$oWvFCmKJ1T%ti6(30o;@A+=2X)eaP)5.k-&Q%gPn;n@,5YIFg$!;ajcsu*V9KDXSz|DqWUv,02K9sA|L"
			"DK*nhi<JP>.G|&o5vr@,C9&NNOtKqp*ZY_z57**co)6#z}<Vh#rJ6n$9v.2LDrB9.ZkTP>rEyF$>0_CIsOdi8B"
			"k~8^XL{Is)VfX9VL$GzR%W.g.NGkVlNNS>Rdl1)edWoM|;lX9t)wn6MyKAca#h1XwDPXb(~hmIF;py,V&u2qTu"
			"D(>1^loxxfbI7i<FP*._+1>G|,1z_Dle;~,+m.{Et{kX-7I4z-nt_yfC>=|EBzN10*lDvF+PwEd#g5xjQ5b)QG"
			"KLtoRZ~OsTNe,OfZa|N!Hp%$Gwg+Z#SOWT>wt}cGFkhIG>Lt>Dpd0zZbP9HonWmmGyLoCH_Kn2~gLDS>1!yV+C"
			"_xI*lAv%o4gqok,eBxE$Jivm-$b$@#IOt8lStv=3VveGC~2px8C)B*hF#LjMO|A%Zy+w{SwXXNRD,tfOczP;kc"
			"M@zXlnJt*PvaTGv^I1Hr@+NW+4mEHjQo.JmBAWCG~^T!bt_)(q15kU~trHr}##@xzHGXz;JW|>IG;g1;Pqoy<l"
			"I!H!,>s!Fk9bR20MD&K+6J8%FTp3R}X.5PSygRT)|ILRSSkP7r=D.{*xqI8cEF0uu^+0S~k@Q|N=>6XOMdV^D8"
			"|DdY&$BY;NY9-!TU>Gy_&C=0q2<O@7Ont=a!AG9ITR6NxSsvQ0xo{*lB8O3mK><%yBArX0rF$U}o_kgn|CjBSz"
			"2JS;1P}UbrG;ARfwIGF35E,Ku1mM2NCkWJ&48DLhK{<;OK-dhIm=!@#A2|jSkV4!tSr^1SIveZ<jmd8YavjXk@"
			"COF)ySfkg!Y)GZ$hihk{6QW-+xdgJGW^0q&T2>ykfs~.gF~u<a9,~P,hn@>Ap.W{AhI#9qj}#s.jfMz@CUnqH_"
			"#z6e1P2n7Y&XP&K=u=+k#%eYX77$<_rGF$#8<s3veoe^}%Et+#8UFqLeIy33|b+z(bU$tP6}5LnXouXeSvipj!"
			"(NGWWqy768,*+;!U&FqsHun&l9ID1ru}%tR1UYwdytLJ<@p41^{VAq.1J#6;knEx0.53;c#zrWNA|TpnIP>drU"
			"2yVVNkC5D1d8h_kFyi#Nl%Tio9hqT9,FvD6hwasWkV;$-=2XK2xOs)a5z!LEc%k+mAbZl|b8gz,-I4l8d8D)Ss"
			"=^OFO)f+dpP>0zGI4lOz+k(sjJ%pkh7L7RlFu&ji;TpwIgOJfFU_mroWV3{3G;-J#m{(v!_sv$EL3yNKL.=-6a"
			"|N5iH3&E_5L.1R)Tm;#d#uVXXhCo#OGtcWat@AQ;P4Q<x9Ec84P620,GVj5hWRj{T|kZjnuAvw1vi6K6N36-hp"
			"-da5a~Z,G4TX<gdDL5T1ajda9hE2pJ2U&h0;(L+6ChU*cpA,UcldWmWHcAR5)B}WZ<e8{ZjoQLmYu~5}ClJ5}_"
			"=DS;2i1G~fs~)ECwb)CpWzma$M3K~x)<8Nsa#oF|+kLQxXhGHI8y2pxApoEN.gQXd$uAsE.05fhD>If@V^G0-}"
			"gCp32#zD0zb(G.OS3S%ME$RRm3LC,wZ8H.o;F!KheEyiXLFuS1F5>3|E1ZE3qVhF{{6@(egQ!r9B2I>X4A.k!C"
			"5x668M&OLXHw1TtZW=96jL0NAFwP0W83Le3a6JMJ5%Um;oRS3XuB@0OKxaDOFqmW!2aA}*QHp0TWjTq<5QeFHL"
			"M)p|Ma^sx2OvSq5W|0*vCx)qdV--SMVr.dCmKrv4Ab60h~OLC7rYVj1aJqaE;9It7x)Bw0e4JTLKebUm*&nHTo"
			"K_Rc^!i--vBrN0Uyj}fPw^hfjBOcpk$mY{}5b(FI<E$la@e2_5r36s5gKk;t6CFaDJ2Zf<LfX)J&I2{s6KC{ou"
			"KR>H}^Ic>*^A={iq@IQ#+H;f({,m~r%&0,<Xr17AHMjSDP7PBK&>piVP2pxnfn$y,AR!BjlE!pfF)j5pB.fA<O"
			"8Luo1no*-}78rf$I|7aF+R)zk!L-@>g9+00.hdY9(S.,21jc!{3Oozy7<_-;|k{Fc6U#mjMp!=JPA}<>K0V<YA"
			"B+d=mAM{!cXf^~jO,Ia&ups8UNlde!XmNG~Fb1e64tt4ufej{v2xO^%D}lV{eIX!D;t(Yof~YEjz!|}.25@SF)"
			"Ec1)ggJ.<!a#^jghA7SsR#>jHt>d%zRaR9FhzzE.5HOs;R+2Xxr~A!strQVwjrn&)HwDYmW&ky@K!q_3=cX2&R"
			"-OWw85qdV5UJYPuC57fY=0Z1%N&Sd>vjg9Q-rsJi}MNP_t-RP*n@uv&z|t)FaqlqTzL;W%%k8sSXME^M*d4M,$"
			"nq%l)q^1>^;2E--_HIRSkzRUrXw87c-=lJo-b5<sm5K!$SoL4j{1%b|3hVA;.R_(Qqa9uHK#d#AKv@C,UQDI2N"
			"Me-K;398.P^8Bm5LmV)&,_Klfu5Bcg1!W<MVLGo$i2mItAHt+-5Nd#>LKx_jZLR2#^7;^Fu_fFp#1zWuXaj&iu"
			"*bUe>JAP2DL)rQvPN3iKg,boks3p,5w1tAHD1!VX63T.45tu^YPD;@2pkc@osRU}yGv4aL0%uYf<jz_9jk_oD1"
			"3237a##$e3BgdY6(ZoA6M}GQgJ2mrGloA*Gx7vI;G2h6(FXqD=d,}bf>#Wc17D~zU+FPI5{5=BAqvrw{c)n&Lq"
			"E(G{cwk%D>DATg}SC{fPn(1>=KAaA,uqi,@x3V3SmE-YuB(5@B(nYhGc;Qd4Wti+!KUc%!>-^Qpm.A5-8yZB>^"
			"drMvFnFGe-lSV.;oKCmVT;Nenm67,Qd1l0;sBy<$$oeKH7Mf(Tq;XOI<1L.c6;At51$aic(Qs11QA1ZWRKQ!tQ"
			"$P_h#Tph}@;0QV4aZY+ZX+6w~6pl*Ow8Rs-V_k(O2DZ$*;AV7hf8+bLNMqDAw$Q%x8jNk}~mk2HpUz9b>7a0a2"
			"fIje85OOw>NK+2|Lf$e6YlAgHQw-fF&I{);,aq|G^cbZ;(PaWT!rvHUP,SZ4HUVcL2RrT_*I@@Ar2Zh(<5{2R2"
			"4@I<atL2QE6^D2Amaac&bEc_LCoACj&p$t0t9n(0-+AFKL|>pW0JD-M_^x2*W(Sf4f;Zv1>Gb<$^!i1qon>LSK"
			"#g$_>hG&8^nP*CJgfg;Lc)%A!Hrgg8wjlZW*(dG6dkcgW|XsN&bLpg8pz+1wd^fhR~G8,m4Ge{;3Pv|5S!UZ3W"
			"s2pqv%}s0(Ov_6Dm#aE;BouqVhvK)M1M!-AwU5$Qi{X#V4n;&|*CU&3aKjDpI7$c4nF5bzDayQPVR5912$1-z6"
			"I8jTgy3C7K3OCZ8m0-!07LZNyR6Pge&;Xu.|0XcdJ3V_=|a}3Qumf&tMjL1a4kcZ$E#1OrJR0v!c=LveDV~~LR"
			"27WJC9)uCO#*Y<AAl3We-&kujc*gd8P8)yR6YLAH1u@n@wt|=,oCpvgLZC144K|h_>{KL#wh%.Og6#-<!zJh$4"
			"!_71psHenPyh";
		return (char*)p_Decode_BWT_MTF_RLE_Huff_Base85(p_s_base85, 65731, 20129, 11475);
	}

protected:
	/**
	 *	@brief decompression routine
	 *
	 *	@param[in] p_s_base85 is null-terminated string containing Base-85 encoded compressed data
	 *	@param[in] n_data_size is size of the decompressed data
	 *	@param[in] n_huff_stage_size is size of the compressed data before Huffman encoding
	 *	@param[in] n_bwt_primary_index is primary index for the BWT algorithm
	 *
	 *	@return Returns pointer to the decompressed data on success, 0 on failure.
	 *
	 *	@note The data (although it may be binary), is additionally null terminated.
	 */
	static uint8_t *p_Decode_BWT_MTF_RLE_Huff_Base85(const char *p_s_base85,
		size_t n_data_size, size_t n_huff_stage_size, uint32_t n_bwt_primary_index)
	{
		size_t n_base85_length = strlen(p_s_base85), n_base85_size = 0;
		int p_b85_ic_tab[128] = {0};
		{
			for(int i = 0, j = -10, k = 55, l = -62; i < 85; ++ i, ++ j, ++ k, ++ l)
				p_b85_ic_tab[(j < 0)? k - 7 : (l < 0)? k + j / 26 * 6 : "!#$%&()*+-;<=>.@^_,{|}~"[l]] = i;
			const char *p_s_src = p_s_base85, *p_s_end = p_s_base85 + n_base85_length;
			for(size_t n_diff, n_rem = n_base85_length; p_s_src < p_s_end;
			   p_s_src += n_diff * 4 + 1, n_rem -= n_diff * 4 + 1)
				n_base85_size += (n_diff = (p_b85_ic_tab[*p_s_src] == 84))? 4 : min(n_rem, size_t(5)) - 1;
		}
		size_t n_prehuff_size = max(n_base85_size, n_data_size);
		size_t n_temp_buffer_size = max(n_prehuff_size + n_huff_stage_size,
			n_data_size * (1 + sizeof(uint32_t)));

		uint8_t *p_temp_buffer, *p_data;
		if(!(p_temp_buffer = new(std::nothrow) uint8_t[n_temp_buffer_size]) ||
		   !(p_data = new(std::nothrow) uint8_t[n_data_size + 1])) {
			if(p_temp_buffer)
				delete[] p_temp_buffer;
			return 0;
		}
		p_data[n_data_size] = 0; // null-terminate the data

		{
			uint8_t *p_dst = p_temp_buffer - 1;
			const char *p_s_src = p_s_base85, *p_s_end = p_s_base85 + n_base85_length;
			for(size_t n_rem = n_base85_length; p_s_src != p_s_end; -- n_rem, ++ p_s_src) {
				if(p_b85_ic_tab[*p_s_src] != 84) {
					uint32_t n_block = uint32_t(min(n_rem, size_t(5))), n_code = 0;
					_ASSERTE(n_block >= 2);
					for(unsigned int i = 0; i < 5; p_s_src += ((++ i < n_block)? 1 : 0))
						n_code = n_code * 85 + ((i < n_block)? p_b85_ic_tab[*p_s_src] : 84);
					for(unsigned int i = 1; i < n_block; ++ i, -- n_rem)
						*(++ p_dst) = n_code >> (8 * (4 - i));
				} else
					*(uint32_t*)((p_dst += 4) - 3) = 0;
			}
		}
		{
			const uint8_t *p_huff_src = p_temp_buffer, *p_huff_end = p_huff_src + n_base85_size;
			_ASSERTE(p_huff_src + 16 * sizeof(int32_t) <= p_huff_end);
			const int32_t *p_code_num = (const int32_t*)p_huff_src;
			int p_max_code[16], p_table_off[16], n_code_num = 0;
			for(int i = 0, n_code_word = 0; i < 16; ++ i, n_code_word <<= 1) {
				p_table_off[i] = (n_code_num += p_code_num[i]) - (n_code_word += p_code_num[i]);
				p_max_code[i] = n_code_word;
			}
			const uint8_t *p_symbol = (p_huff_src += 16 * sizeof(int32_t));
			_ASSERTE(p_huff_src + n_code_num <= p_huff_end);
			p_huff_src += n_code_num - 1;
			uint8_t *p_dest = p_temp_buffer + n_prehuff_size, *p_end = p_dest + n_huff_stage_size;
			for(uint8_t n_byte = 0, n_bit_num = 7; p_dest != p_end; ++ p_dest, n_byte <<= 1) {
				for(int i = 0, n_code = 0;; ++ i, n_byte <<= 1) {
					_ASSERTE(i < 16);
					if(!((++ n_bit_num) & 7)) { // every 8
						_ASSERTE(p_huff_src < p_huff_end);
						n_byte = *(++ p_huff_src);
					}
					n_code = (n_code << 1) | (n_byte >> 7);
					if(n_code < p_max_code[i]) {
						_ASSERTE(n_code >= p_max_code[i] - p_code_num[i]); // n_code >= p_min_code[i]
						*p_dest = p_symbol[n_code + p_table_off[i]];
						break;
					}
				}
			}
		}
		{
			const uint8_t *p_rle_src = p_temp_buffer + n_prehuff_size,
				*p_src_end = p_rle_src + n_huff_stage_size;
			for(uint8_t *p_rle_dest = p_temp_buffer; p_rle_src != p_src_end;) {
				uint8_t n_code = *p_rle_src;
				bool b_compressed = n_code & 1;
				int n_run_length = (n_code >> 1) + 2;
				_ASSERTE(p_rle_src + ((b_compressed)? 2 : n_run_length) <= p_src_end);
				for(; -- n_run_length; ++ p_rle_dest)
					*p_rle_dest = (b_compressed)? p_rle_src[1] : *(++ p_rle_src);
				p_rle_src += int(1 << ((b_compressed)? 1 : 0)); // fix an x64 warning here
			}
		}
		{
			uint8_t p_buckets[256] = {0}; // each bucket value encoded as offset to its index
			uint8_t *p_data = p_temp_buffer, *p_end = p_temp_buffer + n_data_size;
			for(; p_data != p_end; ++ p_data) {
				uint8_t n_index = *p_data;
				*p_data = p_buckets[n_index] + n_index;
				for(int i = n_index; i != 0; -- i)
					p_buckets[i] = p_buckets[i - 1] - 1;
				if(n_index)
					p_buckets[0] = *p_data;
			}
		}
		{
			uint32_t p_buckets[257] = {0}, *p_index_list = (uint32_t*)(p_temp_buffer + n_data_size);
			const uint8_t *p_src = p_temp_buffer, *p_end = p_temp_buffer + n_data_size;
			for(uint32_t *p_dest_idx = p_index_list; p_src != p_end; ++ p_src, ++ p_dest_idx)
				*p_dest_idx = (++ p_buckets[*p_src + 1]) - 1; // start accumulating in bucket 1
 			for(int i = 1; i < 255; ++ i) // exclusive prefix sum
				p_buckets[i + 1] += p_buckets[i];
			uint8_t *p_dest = p_data + n_data_size - 1, *p_begin_1 = p_data - 1;
			for(uint32_t i = n_bwt_primary_index; p_dest != p_begin_1; -- p_dest,
			   i = p_index_list[i] + p_buckets[p_temp_buffer[i]])
				*p_dest = p_temp_buffer[i];
		}
		_ASSERTE(!p_data[n_data_size]); // make sure the terminating null was not overwritten

		delete[] p_temp_buffer;
		
		return p_data;
	}
};

#endif // !__E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SCANREDUCEV3_C_FILE_IN_HEADER_INCLUDED
