/*
 * python_spec.hpp
 *
 *  Created on: 2. 11. 2017
 *      Author: nosko
 */

#ifndef PYTHON_SPEC_HPP_
#define PYTHON_SPEC_HPP_

#include <stdint.h>
#include <opencv2/core/core.hpp>



uint32_t pixelMapping[256] = {0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,217,218,219,220,221,222,223,224,225,226,227,228,229,231,232,233,234,235,236,237,238,239,240,242,243,244,245,246,247,248,249,250,252,253,254,255};


float pixelMappingFX[256] = {0.0,0.1,0.1,0.1,0.1,0.1,0.0189051704,1.0703672249,2.1205322031,3.1694131708,4.2170231943,5.2633753395,6.3084826727,7.3523582597,8.3950151667,9.4364664598,10.476725205,11.5158044685,12.5537173162,13.5904768143,14.6260960288,15.6605880258,16.6939658714,17.7262426316,18.7574313725,19.7875451602,20.8165970608,21.8446001403,22.8715674649,23.8975121005,24.9224471132,25.9463855692,26.9693405344,27.9913250751,29.0123522571,30.0324351467,31.0515868099,32.0698203127,33.0871487212,34.1035851015,35.1191425197,36.1338340418,37.147672734,38.1606716622,39.1728438926,40.1842024912,41.1947605241,42.2045310574,43.2135271571,44.2217618894,45.2292483202,46.2359995157,47.242028542,48.247348465,49.2519723509,50.2559132658,51.2591842757,52.2617984466,53.2637688448,54.2651085362,55.2658305868,56.2659480629,57.2654740304,58.2644215555,59.2628037041,60.2606335424,61.2579241365,62.2546885524,63.2509398561,64.2466911138,65.2419553916,
								66.2367457554,67.2310752714,68.2249570057,69.2184040243,70.2114293932,71.2040461787,72.1962674466,73.1881062632,74.1795756944,75.1706888064,76.1614586653,77.151898337,78.1420208877,79.1318393834,80.1213668902,81.1106164742,82.0996012015,83.0883341381,84.07682835,85.0650969035,86.0531528645,87.0410092991,88.0286792734,89.0161758535,90.0035121054,90.9907010951,91.9777558889,92.9646895527,93.9515151526,94.9382457548,95.9248944251,96.9114742299,97.897998235,98.8844795066,99.8709311107,100.8573661135,101.843797581,102.8302385792,103.8167021743,104.8032014323,105.7897494192,106.7763592013,107.7630438444,108.7498164148,109.7366899784,110.7236776013,111.7107923497,112.6980472896,113.685455487,114.6730300081,115.6607839188,116.6487302853,117.6368821737,118.62525265,119.6138547803,120.6027016307,121.5918062672,122.5811817558,123.5708411628,124.5607975541,125.5510639959,126.5416535541,127.5325792949,128.5238542844,
								129.5154915886,130.5075042735,131.4999054053,132.49270805,133.4859252738,134.4795701426,135.4736557225,136.4681950797,137.4632012801,138.4586873899,139.4546664752,140.4511516019,141.4481558362,142.4456922442,143.4437738919,144.4424138454,145.4416251707,146.441420934,147.4418142013,148.4428180386,149.4444455122,150.4467096879,151.4496236319,152.4532004103,153.4574530892,154.4623947345,155.4680384125,156.4743971891,157.4814841304,158.4893123025,159.4978947716,160.5072446035,161.5173748645,162.5282986205,163.5400289377,164.5525788822,165.5659615199,166.580189917,167.5952771396,168.6112362537,169.6280803254,170.6458224207,171.6644756058,172.6840529467,173.7045675095,174.7260323602,175.748460565,176.7718651899,177.7962593009,178.8216559641,179.8480682457,180.8755092117,181.9039919281,182.933529461,183.9641348766,184.9958212408,186.0286016198,187.0624890796,188.0974966862,189.1336375059,190.1709246046,191.2093710483,
								192.2489899033,193.2897942355,194.331797111,195.3750115959,196.4194507563,197.4651276582,198.5120553678,199.560246951,200.6097154739,201.6604740027,202.7125356034,203.7659133421,204.8206202848,205.8766694976,206.9340740466,207.9928469978,209.0530014174,210.1145503714,211.1775069259,212.2418841469,213.3076951005,214.3749528528,215.4436704699,216.5138610178,217.5855375626,218.6587131704,219.7334009073,220.8096138393,221.8873650324,222.9666675529,224.0475344666,225.1299788398,226.2140137385,227.2996522287,228.3869073765,229.4757922481,230.5663199094,231.6585034265,232.7523558656,233.8478902927,234.9451197738,236.044057375,237.1447161625,238.2471092022,239.3512495603,240.4571503028,241.5648244957,242.6742852053,243.7855454975,244.8986184383,246.013517094,247.1302545305,248.248843814,249.3692980104,250.4916301859,251.6158534065,252.7419807384,253.8700252475,255};



static float getExpRatio(unsigned int exp1, unsigned int exp2)
{
	float expRatio1 = -0.000000123563234*(float)exp1*(float)exp1 + 0.210800563245259*(float)exp1 + 17.676542876285300;
	float expRatio2 = -0.000000123563234*(float)exp2*(float)exp2 + 0.210800563245259*(float)exp2 + 17.676542876285300;
	return MAX(expRatio2, expRatio1) / MIN(expRatio2, expRatio1);
}


static void colorCorrection(cv::Mat& mat)
{
	for (int y = 0; y < mat.rows; y++)
	{
		for (int x = 0; x < mat.cols; x++)
		{
				float b = (float)mat.at<cv::Vec3f>(y, x)[0];
				float g = (float)mat.at<cv::Vec3f>(y, x)[1];
				float r = (float)mat.at<cv::Vec3f>(y, x)[2];
				mat.at<cv::Vec3f>(y, x)[2] =  MAX(0.0, MIN(255.0, (1.0*r -3.9e-07*g -3.9e-07*b)) );
				mat.at<cv::Vec3f>(y, x)[1] = MAX(0.0, MIN(255.0, (-3.9e-07*r + 0.74*g + 0.28*b)) );
				mat.at<cv::Vec3f>(y, x)[0] = MAX(0.0, MIN(255.0, (0.04*r -0.12*g + 1.2*b)) );
		}
	}
}

#endif /* PYTHON_SPEC_HPP_ */
