/*
 * Decompiled with CFR 0.152.
 */
package com.msd.gin.halyard.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public final class HalyardTableUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] CF_NAME = "e".getBytes(UTF8);
    private static final String MD_ALGORITHM = "SHA1";
    public static final byte SPO_PREFIX = 0;
    public static final byte POS_PREFIX = 1;
    public static final byte OSP_PREFIX = 2;
    public static final byte CSPO_PREFIX = 3;
    public static final byte CPOS_PREFIX = 4;
    public static final byte COSP_PREFIX = 5;
    private static final int PREFIXES = 3;
    private static final byte[] START_KEY = new byte[20];
    static final byte[] STOP_KEY = new byte[20];
    private static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM;
    private static final DataBlockEncoding DEFAULT_DATABLOCK_ENCODING;
    private static final String REGION_MAX_FILESIZE = "10000000000";
    private static final String REGION_SPLIT_POLICY = "org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy";
    private static final ThreadLocal<MessageDigest> MD;

    static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static HTable getTable(Configuration config, String tableName, boolean create, int splitBits) throws IOException {
        return HalyardTableUtils.getTable(config, tableName, create, splitBits < 0 ? (byte[][])null : HalyardTableUtils.calculateSplits(splitBits));
    }

    public static HTable getTable(Configuration config, String tableName, boolean create, byte[][] splits) throws IOException {
        Configuration cfg = HBaseConfiguration.create((Configuration)config);
        cfg.setLong("hbase.client.scanner.timeout.period", 3600000L);
        if (create) {
            try (Connection con = ConnectionFactory.createConnection((Configuration)config);
                 Admin admin = con.getAdmin();){
                if (!admin.tableExists(TableName.valueOf((String)tableName))) {
                    HTableDescriptor td = new HTableDescriptor(TableName.valueOf((String)tableName));
                    td.addFamily(HalyardTableUtils.createColumnFamily());
                    admin.createTable(td, splits);
                }
            }
        }
        HTable table = new HTable(cfg, tableName);
        table.setAutoFlushTo(false);
        return table;
    }

    public static HTable truncateTable(HTable table) throws IOException {
        Configuration conf = table.getConfiguration();
        byte[][] presplits = table.getRegionLocator().getStartKeys();
        if (presplits.length > 0 && presplits[0].length == 0) {
            presplits = (byte[][])Arrays.copyOfRange(presplits, 1, presplits.length);
        }
        HTableDescriptor desc = table.getTableDescriptor();
        table.close();
        try (Connection con = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = con.getAdmin();){
            admin.disableTable(desc.getTableName());
            admin.deleteTable(desc.getTableName());
            admin.createTable(desc, presplits);
        }
        return HalyardTableUtils.getTable(conf, desc.getTableName().getNameAsString(), false, 0);
    }

    static byte[][] calculateSplits(int splitBits) {
        TreeSet<byte[]> splitKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        splitKeys.add(new byte[]{1});
        splitKeys.add(new byte[]{2});
        splitKeys.add(new byte[]{3});
        splitKeys.add(new byte[]{4});
        splitKeys.add(new byte[]{5});
        HalyardTableUtils.addSplits(splitKeys, new byte[]{0}, splitBits);
        HalyardTableUtils.addSplits(splitKeys, new byte[]{1}, splitBits);
        HalyardTableUtils.addSplits(splitKeys, new byte[]{2}, splitBits);
        return (byte[][])splitKeys.toArray((T[])new byte[splitKeys.size()][]);
    }

    private static void addSplits(TreeSet<byte[]> splitKeys, byte[] prefix, int splitBits) {
        int splitStep;
        if (splitBits == 0) {
            return;
        }
        if (splitBits < 0 || splitBits > 16) {
            throw new IllegalArgumentException("Illegal nunmber of split bits");
        }
        for (int i = splitStep = 1 << 16 - splitBits; i <= 65535; i += splitStep) {
            byte[] bb = Arrays.copyOf(prefix, prefix.length + 2);
            bb[prefix.length] = (byte)(i >> 8 & 0xFF);
            bb[prefix.length + 1] = (byte)(i & 0xFF);
            splitKeys.add(bb);
        }
    }

    public static KeyValue[] toKeyValues(Resource subj, IRI pred, Value obj, Resource context, boolean delete, long timestamp) {
        byte[] sb = NTriplesUtil.toNTriplesString((Resource)subj).getBytes(UTF8);
        byte[] pb = NTriplesUtil.toNTriplesString((IRI)pred).getBytes(UTF8);
        byte[] ob = NTriplesUtil.toNTriplesString((Value)obj).getBytes(UTF8);
        byte[] cb = context == null ? new byte[]{} : NTriplesUtil.toNTriplesString((Resource)context).getBytes(UTF8);
        byte[] sKey = HalyardTableUtils.hashKey(sb);
        byte[] pKey = HalyardTableUtils.hashKey(pb);
        byte[] oKey = HalyardTableUtils.hashKey(ob);
        byte[] cq = ByteBuffer.allocate(sb.length + pb.length + ob.length + cb.length + 12).putInt(sb.length).putInt(pb.length).putInt(ob.length).put(sb).put(pb).put(ob).put(cb).array();
        KeyValue[] kv = new KeyValue[context == null ? 3 : 6];
        KeyValue.Type type = delete ? KeyValue.Type.DeleteColumn : KeyValue.Type.Put;
        timestamp <<= 1;
        if (!delete) {
            timestamp |= 1L;
        }
        kv[0] = new KeyValue(HalyardTableUtils.concat((byte)0, false, sKey, pKey, oKey), CF_NAME, cq, timestamp, type, EMPTY);
        kv[1] = new KeyValue(HalyardTableUtils.concat((byte)1, false, pKey, oKey, sKey), CF_NAME, cq, timestamp, type, EMPTY);
        kv[2] = new KeyValue(HalyardTableUtils.concat((byte)2, false, oKey, sKey, pKey), CF_NAME, cq, timestamp, type, EMPTY);
        if (context != null) {
            byte[] cKey = HalyardTableUtils.hashKey(cb);
            kv[3] = new KeyValue(HalyardTableUtils.concat((byte)3, false, cKey, sKey, pKey, oKey), CF_NAME, cq, timestamp, type, EMPTY);
            kv[4] = new KeyValue(HalyardTableUtils.concat((byte)4, false, cKey, pKey, oKey, sKey), CF_NAME, cq, timestamp, type, EMPTY);
            kv[5] = new KeyValue(HalyardTableUtils.concat((byte)5, false, cKey, oKey, sKey, pKey), CF_NAME, cq, timestamp, type, EMPTY);
        }
        return kv;
    }

    public static Scan scan(Resource subj, IRI pred, Value obj, Resource ctx) {
        return HalyardTableUtils.scan(HalyardTableUtils.hashKey((Value)subj), HalyardTableUtils.hashKey((Value)pred), HalyardTableUtils.hashKey(obj), HalyardTableUtils.hashKey((Value)ctx));
    }

    public static Scan scan(byte[] subjHash, byte[] predHash, byte[] objHash, byte[] ctxHash) {
        if (ctxHash == null) {
            if (subjHash == null) {
                if (predHash == null) {
                    if (objHash == null) {
                        return HalyardTableUtils.scan(HalyardTableUtils.concat((byte)0, false, new byte[0][]), HalyardTableUtils.concat((byte)0, true, STOP_KEY, STOP_KEY, STOP_KEY));
                    }
                    return HalyardTableUtils.scan((byte)2, objHash);
                }
                if (objHash == null) {
                    return HalyardTableUtils.scan((byte)1, predHash);
                }
                return HalyardTableUtils.scan((byte)1, predHash, objHash);
            }
            if (predHash == null) {
                if (objHash == null) {
                    return HalyardTableUtils.scan((byte)0, subjHash);
                }
                return HalyardTableUtils.scan((byte)2, objHash, subjHash);
            }
            if (objHash == null) {
                return HalyardTableUtils.scan((byte)0, subjHash, predHash);
            }
            return HalyardTableUtils.scan((byte)0, subjHash, predHash, objHash);
        }
        if (subjHash == null) {
            if (predHash == null) {
                if (objHash == null) {
                    return HalyardTableUtils.scan((byte)3, ctxHash);
                }
                return HalyardTableUtils.scan((byte)5, ctxHash, objHash);
            }
            if (objHash == null) {
                return HalyardTableUtils.scan((byte)4, ctxHash, predHash);
            }
            return HalyardTableUtils.scan((byte)4, ctxHash, predHash, objHash);
        }
        if (predHash == null) {
            if (objHash == null) {
                return HalyardTableUtils.scan((byte)3, ctxHash, subjHash);
            }
            return HalyardTableUtils.scan((byte)5, ctxHash, objHash, subjHash);
        }
        if (objHash == null) {
            return HalyardTableUtils.scan((byte)3, ctxHash, subjHash, predHash);
        }
        return HalyardTableUtils.scan((byte)3, ctxHash, subjHash, predHash, objHash);
    }

    public static List<Statement> parseStatements(Result res) {
        ArrayList<Statement> st = new ArrayList<Statement>();
        if (res.rawCells() != null) {
            for (Cell c : res.rawCells()) {
                ByteBuffer bb = ByteBuffer.wrap(c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength());
                byte[] sb = new byte[bb.getInt()];
                byte[] pb = new byte[bb.getInt()];
                byte[] ob = new byte[bb.getInt()];
                bb.get(sb);
                bb.get(pb);
                bb.get(ob);
                byte[] cb = new byte[bb.remaining()];
                bb.get(cb);
                SimpleValueFactory vf = SimpleValueFactory.getInstance();
                st.add(vf.createStatement(NTriplesUtil.parseResource((String)new String(sb, UTF8), (ValueFactory)vf), NTriplesUtil.parseURI((String)new String(pb, UTF8), (ValueFactory)vf), NTriplesUtil.parseValue((String)new String(ob, UTF8), (ValueFactory)vf), cb.length == 0 ? null : NTriplesUtil.parseResource((String)new String(cb, UTF8), (ValueFactory)vf)));
            }
        }
        return st;
    }

    public static Scan scan(byte[] startRow, byte[] stopRow) {
        Scan scan = new Scan();
        scan.addFamily(CF_NAME);
        scan.setMaxVersions(1);
        scan.setAllowPartialResults(true);
        scan.setBatch(10);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        return scan;
    }

    public static byte[] concat(byte prefix, boolean trailingZero, byte[] ... fragments) {
        int i = 1;
        for (byte[] fr : fragments) {
            i += fr.length;
        }
        byte[] res = new byte[trailingZero ? i + 1 : i];
        res[0] = prefix;
        i = 1;
        for (byte[] fr : fragments) {
            System.arraycopy(fr, 0, res, i, fr.length);
            i += fr.length;
        }
        if (trailingZero) {
            res[res.length - 1] = 0;
        }
        return res;
    }

    private static HColumnDescriptor createColumnFamily() {
        return new HColumnDescriptor(CF_NAME).setMaxVersions(1).setBlockCacheEnabled(true).setBloomFilterType(BloomType.ROW).setCompressionType(DEFAULT_COMPRESSION_ALGORITHM).setDataBlockEncoding(DEFAULT_DATABLOCK_ENCODING).setCacheBloomsOnWrite(true).setCacheDataOnWrite(true).setCacheIndexesOnWrite(true).setKeepDeletedCells(KeepDeletedCells.FALSE).setValue("MAX_FILESIZE", REGION_MAX_FILESIZE).setValue("SPLIT_POLICY", REGION_SPLIT_POLICY);
    }

    public static byte[] hashKey(byte[] key) {
        MessageDigest md = MD.get();
        try {
            md.update(key);
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            md.reset();
        }
    }

    public static byte[] hashKey(Value v) {
        return v == null ? null : HalyardTableUtils.hashKey(NTriplesUtil.toNTriplesString((Value)v).getBytes(UTF8));
    }

    private static Scan scan(byte prefix, byte[] key1) {
        return HalyardTableUtils.scan(HalyardTableUtils.concat(prefix, false, new byte[][]{key1}), HalyardTableUtils.concat(prefix, true, key1, STOP_KEY, STOP_KEY, STOP_KEY));
    }

    private static Scan scan(byte prefix, byte[] key1, byte[] key2) {
        return HalyardTableUtils.scan(HalyardTableUtils.concat(prefix, false, key1, key2), HalyardTableUtils.concat(prefix, true, key1, key2, STOP_KEY, STOP_KEY));
    }

    private static Scan scan(byte prefix, byte[] key1, byte[] key2, byte[] key3) {
        return HalyardTableUtils.scan(HalyardTableUtils.concat(prefix, false, key1, key2, key3), HalyardTableUtils.concat(prefix, true, key1, key2, key3, STOP_KEY));
    }

    private static Scan scan(byte prefix, byte[] key1, byte[] key2, byte[] key3, byte[] key4) {
        return HalyardTableUtils.scan(HalyardTableUtils.concat(prefix, false, key1, key2, key3, key4), HalyardTableUtils.concat(prefix, true, key1, key2, key3, key4));
    }

    static {
        Arrays.fill(START_KEY, (byte)0);
        Arrays.fill(STOP_KEY, (byte)-1);
        DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.GZ;
        DEFAULT_DATABLOCK_ENCODING = DataBlockEncoding.PREFIX;
        MD = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                return HalyardTableUtils.getMessageDigest(HalyardTableUtils.MD_ALGORITHM);
            }
        };
    }
}

