/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum SqlJetEncoding {
    UTF8(StandardCharsets.UTF_8, 1),
    UTF16LE(StandardCharsets.UTF_16LE, 2),
    UTF16BE(StandardCharsets.UTF_16BE, 3),
    UTF16(StandardCharsets.UTF_16, 4);

    private final Charset charset;
    private final int value;

    private SqlJetEncoding(Charset charset, int value) {
        this.charset = charset;
        this.value = value;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSupported() {
        return this == UTF8 || this == UTF16LE || this == UTF16BE;
    }

    public static SqlJetEncoding decode(String s) {
        SqlJetEncoding[] sqlJetEncodingArray = SqlJetEncoding.values();
        int n = sqlJetEncodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlJetEncoding e = sqlJetEncodingArray[n2];
            if (e.getCharset().name().equalsIgnoreCase(s)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static SqlJetEncoding decodeInt(int value) {
        SqlJetEncoding[] sqlJetEncodingArray = SqlJetEncoding.values();
        int n = sqlJetEncodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlJetEncoding e = sqlJetEncodingArray[n2];
            if (e.value == value) {
                return e;
            }
            ++n2;
        }
        return null;
    }
}

