/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetResultWithOffset;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursors;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetPtrMapType;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetBtree
implements ISqlJetBtree {
    private static final String SQLJET_LOG_BTREE_PROP = "SQLJET_LOG_BTREE";
    private static Logger btreeLogger = Logger.getLogger("SQLJET_LOG_BTREE");
    private static final boolean SQLJET_LOG_BTREE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_BTREE", false);
    private static final ISqlJetMemoryPointer PAGE1_21 = SqlJetUtility.wrapPtr(new byte[]{64, 32, 32});
    protected final ISqlJetDbHandle db;
    protected final SqlJetBtreeShared pBt;
    private boolean readOnly;
    protected final SqlJetBtreeCursors cursors = new SqlJetBtreeCursors();
    protected TransMode inTrans = TransMode.NONE;
    private SqlJetTransactionMode transMode = null;
    private SqlJetSchema pSchema;

    static void TRACE(String format, Object ... args) {
        if (SQLJET_LOG_BTREE) {
            SqlJetUtility.log(btreeLogger, format, args);
        }
    }

    static void traceInt(String format, long ... args) {
        if (SQLJET_LOG_BTREE) {
            SqlJetUtility.log(btreeLogger, format, new Object[]{args});
        }
    }

    public SqlJetBtree(File filename, ISqlJetDbHandle db, Set<SqlJetBtreeFlags> flags, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        boolean isMemdb;
        boolean bl = isMemdb = filename != null && ":memory:".equals(filename.getPath());
        assert (db != null);
        ISqlJetFileSystem pVfs = db.getFileSystem();
        this.db = db;
        this.pBt = new SqlJetBtreeShared();
        this.pBt.pPager = new SqlJetPager(pVfs, filename, SqlJetBtreeFlags.toPagerFlags(flags), type, permissions);
        try {
            int nReserve;
            ISqlJetMemoryPointer zDbHeader = SqlJetUtility.memoryManager.allocatePtr(100);
            this.pBt.pPager.readFileHeader(zDbHeader.remaining(), zDbHeader);
            this.pBt.pPager.setBusyhandler(this::invokeBusyHandler);
            this.pBt.pPager.setReiniter(page -> this.pageReinit(page));
            this.readOnly = this.pBt.pPager.isReadOnly();
            int pageSize = zDbHeader.getShortUnsigned(16);
            if (pageSize < 512 || pageSize > 32768 || (pageSize - 1 & pageSize) != 0) {
                pageSize = this.pBt.pPager.setPageSize(1024);
                if (filename != null && !isMemdb) {
                    this.pBt.autoVacuumMode = SQLJET_DEFAULT_AUTOVACUUM;
                }
                nReserve = 0;
            } else {
                nReserve = zDbHeader.getByteUnsigned(20);
                this.pBt.autoVacuumMode = SqlJetAutoVacuumMode.selectVacuumMode(zDbHeader.getInt(52) != 0, zDbHeader.getInt(64) != 0);
            }
            this.pBt.usableSize = pageSize - nReserve;
            assert ((pageSize & 7) == 0);
            this.pBt.setPageSize(this.pBt.pPager.setPageSize(pageSize));
        }
        catch (SqlJetException e) {
            this.pBt.pPager.close();
            throw e;
        }
    }

    @Override
    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    @Override
    public SqlJetTransactionMode getTransMode() {
        return this.transMode;
    }

    public boolean invokeBusyHandler(int number) {
        assert (this.db.getMutex().held());
        ISqlJetBusyHandler busyHandler = this.db.getBusyHandler();
        if (busyHandler == null) {
            return false;
        }
        return busyHandler.call(number);
    }

    @Override
    public void close() throws SqlJetException {
        assert (this.db.getMutex().held());
        this.cursors.close();
        this.rollback();
        assert (this.cursors.isEmpty());
        this.pBt.pPager.close();
        this.pSchema = null;
    }

    @Override
    public void setCacheSize(int mxPage) {
        assert (this.db.getMutex().held());
        this.pBt.pPager.setCacheSize(mxPage);
    }

    @Override
    public int getCacheSize() {
        return this.pBt.pPager.getCacheSize();
    }

    @Override
    public void setSafetyLevel(SqlJetSafetyLevel level) {
        assert (this.db.getMutex().held());
        this.pBt.pPager.setSafetyLevel(level);
    }

    @Override
    public SqlJetSafetyLevel getSafetyLevel() {
        return this.pBt.pPager.getSafetyLevel();
    }

    @Override
    public void setJournalMode(SqlJetPagerJournalMode mode) {
        assert (this.db.getMutex().held());
        this.pBt.pPager.setJournalMode(mode);
    }

    @Override
    public SqlJetPagerJournalMode getJournalMode() {
        return this.pBt.pPager.getJournalMode();
    }

    @Override
    public SqlJetAutoVacuumMode getAutoVacuum() {
        return this.pBt.autoVacuumMode;
    }

    private void lockBtree() throws SqlJetException {
        if (this.pBt.pPage1 != null) {
            return;
        }
        SqlJetMemPage pPage1 = this.pBt.getPage(1, false);
        try {
            int nPage = this.pBt.pPager.getPageCount();
            if (nPage > 0) {
                int pageSize;
                ISqlJetMemoryPointer page1 = pPage1.getData();
                SqlJetAssert.assertTrue(SqlJetUtility.memcmp(page1, zMagicHeader, 16) == 0, SqlJetErrorCode.NOTADB);
                if (page1.getByteUnsigned(18) > 1) {
                    this.readOnly = true;
                }
                if (((pageSize = page1.getShortUnsigned(16)) - 1 & pageSize) != 0 || pageSize < 512) {
                    throw new SqlJetException(SqlJetErrorCode.NOTADB);
                }
                assert ((pageSize & 7) == 0);
                int usableSize = pageSize - page1.getByteUnsigned(20);
                if (pageSize != this.pBt.getPageSize()) {
                    pPage1.releasePage();
                    this.pBt.usableSize = usableSize;
                    this.pBt.setPageSize(this.pBt.pPager.setPageSize(pageSize));
                    return;
                }
                SqlJetAssert.assertTrue(usableSize >= 500, SqlJetErrorCode.NOTADB);
                this.pBt.usableSize = usableSize;
                this.pBt.autoVacuumMode = SqlJetAutoVacuumMode.selectVacuumMode(page1.getInt(52) > 0, page1.getInt(64) > 0);
            }
            assert (this.pBt.getMaxLeaf() + 23 <= this.pBt.mxCellSize());
            this.pBt.pPage1 = pPage1;
        }
        catch (SqlJetException e) {
            pPage1.releasePage();
            throw e;
        }
    }

    private void newDatabase() throws SqlJetException {
        int nPage = this.pBt.pPager.getPageCount();
        if (nPage > 0) {
            return;
        }
        assert (this.pBt.pPage1 != null);
        ISqlJetMemoryPointer data = this.pBt.pPage1.getData();
        this.pBt.pPage1.pDbPage.write();
        data.copyFrom(zMagicHeader, zMagicHeader.remaining());
        assert (zMagicHeader.remaining() == 16);
        data.putShortUnsigned(16, this.pBt.getPageSize());
        data.putByteUnsigned(18, 1);
        data.putByteUnsigned(19, 1);
        assert (this.pBt.usableSize <= this.pBt.getPageSize() && this.pBt.usableSize + 255 >= this.pBt.getPageSize());
        data.putByteUnsigned(20, (byte)(this.pBt.getPageSize() - this.pBt.usableSize));
        data.putByteUnsigned(21, 64);
        data.putByteUnsigned(22, 32);
        data.putByteUnsigned(23, 32);
        data.fill(24, 76, (byte)0);
        this.pBt.pPage1.zeroPage(13);
        data.putIntUnsigned(52, this.pBt.autoVacuumMode.isAutoVacuum() ? 1 : 0);
        data.putIntUnsigned(64, this.pBt.autoVacuumMode.isIncrVacuum() ? 1 : 0);
    }

    @Override
    public void beginTrans(SqlJetTransactionMode mode) throws SqlJetException {
        SqlJetException rc = null;
        if (this.inTrans == TransMode.WRITE || this.inTrans == TransMode.READ && mode == SqlJetTransactionMode.READ_ONLY) {
            return;
        }
        SqlJetAssert.assertFalse(this.readOnly && mode != SqlJetTransactionMode.READ_ONLY, SqlJetErrorCode.READONLY);
        this.transMode = mode;
        int nBusy = 0;
        do {
            rc = null;
            try {
                while (this.pBt.pPage1 == null) {
                    this.lockBtree();
                }
                if (mode == SqlJetTransactionMode.READ_ONLY) continue;
                SqlJetAssert.assertFalse(this.readOnly, SqlJetErrorCode.READONLY);
                this.pBt.pPager.begin(mode == SqlJetTransactionMode.EXCLUSIVE);
                this.newDatabase();
            }
            catch (SqlJetException e) {
                btreeLogger.log(Level.WARNING, "Busy?", e);
                rc = e;
                this.unlockBtreeIfUnused();
            }
        } while (rc != null && rc.getErrorCode() == SqlJetErrorCode.BUSY && this.inTrans == TransMode.NONE && this.invokeBusyHandler(nBusy) && nBusy++ > -1);
        if (rc != null) {
            throw rc;
        }
        this.inTrans = mode != SqlJetTransactionMode.READ_ONLY ? TransMode.WRITE : TransMode.READ;
    }

    private void commitPhaseOne() throws SqlJetException {
        if (this.inTrans == TransMode.WRITE) {
            if (this.pBt.autoVacuumMode.isAutoVacuum()) {
                this.pBt.autoVacuumCommit();
            }
            this.pBt.pPager.commitPhaseOne(false);
        }
    }

    private void commitPhaseTwo() throws SqlJetException {
        if (this.inTrans == TransMode.WRITE) {
            this.pBt.pPager.commitPhaseTwo();
        }
        this.inTrans = TransMode.NONE;
        this.unlockBtreeIfUnused();
    }

    @Override
    public void commit() throws SqlJetException {
        this.commitPhaseOne();
        this.commitPhaseTwo();
        this.transMode = null;
    }

    @Override
    public void rollback() throws SqlJetException {
        block8: {
            try {
                this.cursors.saveAllCursors(0, null);
            }
            catch (SqlJetException e) {
                this.tripAllCursors(e.getErrorCode());
            }
            try {
                if (this.inTrans != TransMode.WRITE) break block8;
                try {
                    this.pBt.pPager.rollback();
                }
                finally {
                    this.pBt.getPage(1, false).releasePage();
                }
            }
            finally {
                this.inTrans = TransMode.NONE;
                this.unlockBtreeIfUnused();
            }
        }
        this.transMode = null;
    }

    protected void pageReinit(ISqlJetPage page) throws SqlJetException {
        SqlJetMemPage pPage = page.getExtra();
        if (pPage != null && pPage.isInit) {
            pPage.isInit = false;
            if (page.getRefCount() > 0) {
                pPage.initPage();
            }
        }
    }

    @Override
    public int createTable(Set<SqlJetBtreeTableCreateFlags> flags) throws SqlJetException {
        return this.doCreateTable(flags);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private int doCreateTable(Set<SqlJetBtreeTableCreateFlags> flags) throws SqlJetException {
        SqlJetMemPage pRoot;
        int pgnoRoot;
        assert (this.inTrans == TransMode.WRITE);
        assert (!this.readOnly);
        if (this.pBt.autoVacuumMode.isAutoVacuum()) {
            int[] pgnoMove = new int[1];
            pgnoRoot = this.getMeta(4);
            ++pgnoRoot;
            while (pgnoRoot == this.pBt.ptrmapPageNo(pgnoRoot) || pgnoRoot == this.pBt.pendingBytePage()) {
                ++pgnoRoot;
            }
            assert (pgnoRoot >= 3);
            SqlJetMemPage pPageMove = this.pBt.allocatePage(pgnoMove, pgnoRoot, true);
            if (pgnoMove[0] != pgnoRoot) {
                SqlJetMemPage.releasePage(pPageMove);
                pRoot = this.pBt.getPage(pgnoRoot, false);
                SqlJetResultWithOffset<SqlJetPtrMapType> eType = this.pBt.ptrmapGet(pgnoRoot);
                if (eType.getValue() == SqlJetPtrMapType.PTRMAP_ROOTPAGE || eType.getValue() == SqlJetPtrMapType.PTRMAP_FREEPAGE) {
                    pRoot.releasePage();
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                assert (eType.getValue() != SqlJetPtrMapType.PTRMAP_ROOTPAGE);
                assert (eType.getValue() != SqlJetPtrMapType.PTRMAP_FREEPAGE);
                try {
                    pRoot.pDbPage.write();
                    this.pBt.relocatePage(pRoot, eType.getValue(), eType.getOffset(), pgnoMove[0], false);
                }
                finally {
                    pRoot.releasePage();
                }
                pRoot = this.pBt.getPage(pgnoRoot, false);
                try {
                    pRoot.pDbPage.write();
                }
                catch (SqlJetException e) {
                    pRoot.releasePage();
                    throw e;
                }
            }
            pRoot = pPageMove;
            try {
                this.pBt.ptrmapPut(pgnoRoot, SqlJetPtrMapType.PTRMAP_ROOTPAGE, 0);
                this.updateMeta(4, pgnoRoot);
            }
            catch (SqlJetException e) {
                SqlJetMemPage.releasePage(pRoot);
                throw e;
            }
        }
        int[] a = new int[1];
        pRoot = this.pBt.allocatePage(a, 1, false);
        pgnoRoot = a[0];
        try {
            pRoot.zeroPage(SqlJetBtreeTableCreateFlags.toByte(flags) | 8);
        }
        finally {
            pRoot.pDbPage.unref();
        }
        return pgnoRoot;
    }

    @Override
    public boolean isInTrans() {
        assert (this.db.getMutex().held());
        return this.inTrans == TransMode.WRITE;
    }

    @Override
    public SqlJetSchema getSchema() {
        return this.pSchema;
    }

    @Override
    public void setSchema(SqlJetSchema schema) {
        this.pSchema = schema;
    }

    @Override
    public int dropTable(int table) throws SqlJetException {
        return this.doDropTable(table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doDropTable(int iTable) throws SqlJetException {
        SqlJetMemPage pPage = null;
        assert (this.inTrans == TransMode.WRITE);
        SqlJetAssert.assertTrue(this.cursors.isEmpty(), SqlJetErrorCode.LOCKED);
        pPage = this.pBt.getPage(iTable, false);
        try {
            this.clearTable(iTable, null);
        }
        catch (SqlJetException e) {
            pPage.releasePage();
            throw e;
        }
        int piMoved = 0;
        if (iTable > 1) {
            if (this.pBt.autoVacuumMode.isAutoVacuum()) {
                int maxRootPgno;
                try {
                    maxRootPgno = this.getMeta(4);
                }
                catch (SqlJetException e) {
                    pPage.releasePage();
                    throw e;
                }
                if (iTable == maxRootPgno) {
                    try {
                        pPage.freePage();
                    }
                    finally {
                        pPage.releasePage();
                    }
                }
                pPage.releasePage();
                SqlJetMemPage pMove = this.pBt.getPage(maxRootPgno, false);
                try {
                    this.pBt.relocatePage(pMove, SqlJetPtrMapType.PTRMAP_ROOTPAGE, 0, iTable, false);
                }
                finally {
                    pMove.releasePage();
                }
                pMove = this.pBt.getPage(maxRootPgno, false);
                try {
                    pMove.freePage();
                }
                finally {
                    pMove.releasePage();
                }
                piMoved = maxRootPgno;
                if (--maxRootPgno == this.pBt.pendingBytePage()) {
                    --maxRootPgno;
                }
                if (maxRootPgno == this.pBt.ptrmapPageNo(maxRootPgno)) {
                    --maxRootPgno;
                }
                assert (maxRootPgno != this.pBt.pendingBytePage());
                this.updateMeta(4, maxRootPgno);
                return piMoved;
            }
            try {
                pPage.freePage();
                return piMoved;
            }
            finally {
                pPage.releasePage();
            }
        }
        try {
            pPage.zeroPage(9);
            return piMoved;
        }
        finally {
            pPage.releasePage();
        }
    }

    @Override
    public void clearTable(int table, int[] change) throws SqlJetException {
        assert (this.inTrans == TransMode.WRITE);
        this.cursors.saveAllCursors(table, null);
        this.pBt.clearDatabasePage(table, false, change);
    }

    @Override
    public int getMeta(int idx) throws SqlJetException {
        ISqlJetMemoryPointer pP1;
        ISqlJetPage pDbPage = null;
        assert (idx >= 0 && idx <= 15);
        if (this.pBt.pPage1 != null) {
            pP1 = this.pBt.pPage1.getData();
        } else {
            pDbPage = this.pBt.pPager.acquirePage(1, true);
            pP1 = pDbPage.getData();
        }
        int pMeta = pP1.getInt(36 + idx * 4);
        if (pDbPage != null) {
            pDbPage.unref();
        }
        return pMeta;
    }

    @Override
    public void updateMeta(int idx, int value) throws SqlJetException {
        assert (idx >= 1 && idx <= 15);
        assert (this.inTrans == TransMode.WRITE);
        assert (this.pBt.pPage1 != null);
        ISqlJetMemoryPointer pP1 = this.pBt.pPage1.getData();
        this.pBt.pPage1.pDbPage.write();
        pP1.putIntUnsigned(36 + idx * 4, value);
        if (idx == 7) {
            assert (this.pBt.autoVacuumMode.isAutoVacuum() || value == 0);
            assert (value == 0 || value == 1);
            this.pBt.autoVacuumMode = this.pBt.autoVacuumMode.changeIncrMode(value != 0);
        }
    }

    @Override
    public void tripAllCursors(SqlJetErrorCode errCode) throws SqlJetException {
        this.cursors.tripAllCursors(errCode);
    }

    @Override
    public ISqlJetPager getPager() {
        return this.pBt.pPager;
    }

    @Override
    public ISqlJetBtreeCursor getCursor(int table, boolean wrFlag, ISqlJetKeyInfo keyInfo) throws SqlJetException {
        return new SqlJetBtreeCursor(this, table, wrFlag, keyInfo);
    }

    void lockWithRetry() throws SqlJetException {
        if (this.inTrans == TransMode.NONE) {
            try {
                this.beginTrans(SqlJetTransactionMode.READ_ONLY);
            }
            finally {
                this.inTrans = TransMode.NONE;
            }
        }
    }

    @Override
    public void closeAllCursors() throws SqlJetException {
        this.cursors.close();
    }

    public void unlockBtreeIfUnused() throws SqlJetException {
        if (this.inTrans == TransMode.NONE && this.cursors.isEmpty() && this.pBt.pPage1 != null) {
            if (this.pBt.pPager.getRefCount() >= 1) {
                assert (this.pBt.pPage1.getData() != null);
                this.pBt.pPage1.releasePage();
            }
            this.pBt.pPage1 = null;
        }
    }

    protected static enum TransMode {
        NONE,
        READ,
        WRITE;

    }
}

