/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetCursorState;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetIndexedMemPages;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;

public class SqlJetBtreeCursor
extends SqlJetCloneable
implements ISqlJetBtreeCursor {
    private final SqlJetBtree pBtree;
    private final ISqlJetKeyInfo pKeyInfo;
    protected final int pgnoRoot;
    protected SqlJetBtreeCellInfo info = new SqlJetBtreeCellInfo(null, 0, 0, 0, 0, 0, 0);
    private final boolean wrFlag;
    private boolean atLast;
    private boolean validNKey;
    protected SqlJetCursorState eState;
    private ISqlJetMemoryPointer pKey;
    private long nKey;
    protected SqlJetErrorCode error;
    protected int skip;
    private final SqlJetIndexedMemPages pages;

    public SqlJetBtreeCursor(SqlJetBtree btree, int table, boolean wrFlag, ISqlJetKeyInfo keyInfo) throws SqlJetException {
        if (wrFlag) {
            SqlJetAssert.assertFalse(btree.isReadOnly(), SqlJetErrorCode.READONLY);
        }
        SqlJetBtreeShared pBt = btree.pBt;
        if (pBt.pPage1 == null) {
            btree.lockWithRetry();
        }
        this.pBtree = btree;
        this.pgnoRoot = table;
        int nPage = pBt.pPager.getPageCount();
        this.pages = new SqlJetIndexedMemPages(this.pBtree.pBt.usableSize * 2 / 3, this.pBtree.pBt.getPageSize());
        try {
            SqlJetAssert.assertFalse(table == 1 && nPage == 0, SqlJetErrorCode.EMPTY);
            this.pages.addNewPage(pBt.getAndInitPage(this.pgnoRoot));
        }
        catch (SqlJetException e) {
            this.pBtree.unlockBtreeIfUnused();
            throw e;
        }
        this.pKeyInfo = keyInfo;
        this.wrFlag = wrFlag;
        this.pBtree.cursors.add(this);
        this.eState = SqlJetCursorState.INVALID;
    }

    @Override
    public void clearCursor() {
        this.pKey = null;
        this.eState = SqlJetCursorState.INVALID;
    }

    @Override
    public void closeCursor() throws SqlJetException {
        this.clearCursor();
        this.pBtree.cursors.remove(this);
        this.pages.releaseAllPages();
        this.pBtree.unlockBtreeIfUnused();
    }

    @Override
    public int moveTo(ISqlJetMemoryPointer pKey, long nKey, boolean bias) throws SqlJetException {
        SqlJetUnpackedRecord pIdxKey;
        if (pKey != null) {
            assert (nKey == (long)((int)nKey));
            pIdxKey = this.pKeyInfo.recordUnpack((int)nKey, pKey);
        } else {
            pIdxKey = null;
        }
        return this.moveToUnpacked(pIdxKey, nKey, bias);
    }

    private void moveToRoot() throws SqlJetException {
        SqlJetAssert.assertFalse(this.eState == SqlJetCursorState.FAULT, this.error);
        if (this.eState == SqlJetCursorState.REQUIRESEEK) {
            this.clearCursor();
        }
        if (this.pages.hasCurrentPage()) {
            this.pages.releaseAfter(0);
        } else {
            try {
                this.pages.addNewPage(this.pBtree.pBt.getAndInitPage(this.pgnoRoot));
            }
            catch (SqlJetException e) {
                this.eState = SqlJetCursorState.INVALID;
                throw e;
            }
        }
        SqlJetMemPage pRoot = this.pages.getCurrentPage();
        assert (pRoot.pgno == this.pgnoRoot);
        this.pages.setIndexOnCurrentPage(0);
        this.info.nSize = 0;
        this.atLast = false;
        this.validNKey = false;
        if (pRoot.nCell == 0 && !pRoot.leaf) {
            assert (pRoot.pgno == 1);
            int subpage = pRoot.getData().getInt(pRoot.getHdrOffset() + 8);
            assert (subpage > 0);
            this.eState = SqlJetCursorState.VALID;
            this.moveToChild(subpage);
        } else {
            this.eState = pRoot.nCell > 0 ? SqlJetCursorState.VALID : SqlJetCursorState.INVALID;
        }
    }

    private void moveToChild(int newPgno) throws SqlJetException {
        assert (this.eState.isValid());
        SqlJetMemPage pNewPage = this.pBtree.pBt.getAndInitPage(newPgno);
        this.pages.addNewPage(pNewPage);
        this.info.nSize = 0;
        this.validNKey = false;
        SqlJetAssert.assertTrue(pNewPage.nCell > 0, SqlJetErrorCode.CORRUPT);
    }

    private void getCellInfo() {
        if (this.info.nSize == 0) {
            this.info = this.pages.getCurrentPage().parseCell(this.pages.getIndexOnCurrentPage());
            this.validNKey = true;
        }
    }

    private ISqlJetMemoryPointer fetchPayload(int[] pAmt, boolean skipKey) {
        int nLocal;
        int nKey;
        assert (this.pages.hasCurrentPage());
        assert (this.eState.isValid());
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        assert (this.pages.getIndexOnCurrentPage() < pPage.nCell);
        this.getCellInfo();
        ISqlJetMemoryPointer aPayload = this.info.pCell.pointer(this.info.nHeader);
        int n = nKey = pPage.intKey ? 0 : (int)this.info.getnKey();
        if (skipKey) {
            aPayload.movePointer(nKey);
            nLocal = this.info.nLocal - nKey;
        } else {
            nLocal = Integer.min(nKey, this.info.nLocal);
        }
        pAmt[0] = nLocal;
        return aPayload;
    }

    @Override
    public int moveToUnpacked(ISqlJetUnpackedRecord pIdxKey, long intKey, boolean biasRight) throws SqlJetException {
        assert (this.pBtree.db.getMutex().held());
        if (this.eState.isValid() && this.validNKey && this.pages.getFirstPage().intKey) {
            if (this.info.getnKey() == intKey) {
                return 0;
            }
            if (this.atLast && this.info.getnKey() < intKey) {
                return -1;
            }
        }
        this.moveToRoot();
        assert (this.pages.getCurrentPage() != null);
        assert (this.pages.getCurrentPage().isInit);
        if (this.eState.isInvalid()) {
            assert (this.pages.getCurrentPage().nCell == 0);
            return -1;
        }
        assert (this.pages.getFirstPage().intKey || pIdxKey != null);
        while (true) {
            SqlJetMemPage pPage = this.pages.getCurrentPage();
            int c = -1;
            int lwr = 0;
            int upr = pPage.nCell - 1;
            SqlJetAssert.assertFalse(!pPage.intKey && pIdxKey == null || upr < 0, SqlJetErrorCode.CORRUPT);
            if (biasRight) {
                this.pages.setIndexOnCurrentPage(upr);
            } else {
                this.pages.setIndexOnCurrentPage((upr + lwr) / 2);
            }
            while (true) {
                long key = 0L;
                int idx = this.pages.getIndexOnCurrentPage();
                this.info.nSize = 0;
                this.validNKey = true;
                if (pPage.intKey) {
                    ISqlJetMemoryPointer pCell = pPage.findCell(idx).pointer(pPage.getChildPtrSize());
                    if (pPage.hasData) {
                        pCell.movePointer(pCell.getVarint32().getOffset());
                    }
                    key = pCell.getVarint().getValue();
                    c = Long.compare(key, intKey);
                } else {
                    int[] available = new int[1];
                    ISqlJetMemoryPointer pCellKey = this.fetchPayload(available, false);
                    key = this.info.getnKey();
                    if ((long)available[0] >= key) {
                        c = pIdxKey.recordCompare((int)key, pCellKey);
                    } else {
                        pCellKey = SqlJetUtility.memoryManager.allocatePtr((int)key);
                        try {
                            this.key(0, (int)key, pCellKey);
                        }
                        finally {
                            c = pIdxKey.recordCompare((int)key, pCellKey);
                        }
                    }
                }
                if (c == 0) {
                    this.info.setnKey(key);
                    if (pPage.intKey && !pPage.leaf) {
                        lwr = idx;
                        upr = lwr - 1;
                        break;
                    }
                    return 0;
                }
                if (c < 0) {
                    lwr = idx + 1;
                } else {
                    upr = idx - 1;
                }
                if (lwr > upr) {
                    this.info.setnKey(key);
                    break;
                }
                this.pages.setIndexOnCurrentPage((lwr + upr) / 2);
            }
            assert (lwr == upr + 1);
            assert (pPage.isInit);
            int chldPg = pPage.leaf ? 0 : (lwr >= pPage.nCell ? pPage.getData().getInt(pPage.getHdrOffset() + 8) : pPage.findCell(lwr).getInt());
            if (chldPg == 0) {
                assert (this.pages.getIndexOnCurrentPage() < this.pages.getCurrentPage().nCell);
                return c;
            }
            this.pages.setIndexOnCurrentPage(lwr);
            this.info.nSize = 0;
            this.validNKey = false;
            this.moveToChild(chldPg);
        }
    }

    @Override
    public void restoreCursorPosition() throws SqlJetException {
        if (this.eState.isValidOrInvalid()) {
            return;
        }
        SqlJetAssert.assertFalse(this.eState == SqlJetCursorState.FAULT, this.error);
        this.eState = SqlJetCursorState.INVALID;
        this.skip = this.moveTo(this.pKey, this.nKey, false);
        this.pKey = null;
        assert (this.eState.isValidOrInvalid());
    }

    @Override
    public boolean cursorHasMoved() {
        try {
            this.restoreCursorPosition();
        }
        catch (SqlJetException e) {
            return true;
        }
        return !this.eState.isValid() || this.skip != 0;
    }

    @Override
    public void delete() throws SqlJetException {
        SqlJetBtreeShared pBt = this.pBtree.pBt;
        assert (this.pBtree.inTrans == SqlJetBtree.TransMode.WRITE);
        assert (!this.pBtree.isReadOnly());
        assert (this.wrFlag);
        if (this.pages.getIndexOnCurrentPage() >= this.pages.getCurrentPage().nCell || !this.eState.isValid()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.pBtree.cursors.saveAllCursors(this.pgnoRoot, this);
        int iCellDepth = this.pages.getNumberOfPages();
        int iCellIdx = this.pages.getIndexOnCurrentPage();
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        ISqlJetMemoryPointer pCell = pPage.findCell(iCellIdx);
        if (!pPage.leaf) {
            this.previous();
        }
        pPage.pDbPage.write();
        pPage.clearCell(pCell);
        pPage.dropCell(iCellIdx, pPage.cellSizePtr(pCell));
        if (!pPage.leaf) {
            SqlJetMemPage pLeaf = this.pages.getCurrentPage();
            int n = this.pages.getPage((int)iCellDepth).pgno;
            pCell = pLeaf.findCell(pLeaf.nCell - 1);
            int nCell = pLeaf.cellSizePtr(pCell);
            assert (pBt.mxCellSize() >= nCell);
            ISqlJetMemoryPointer pTmp = pBt.allocateTempSpace();
            pLeaf.pDbPage.write();
            pPage.insertCell(iCellIdx, pCell.getMoved(-4), nCell + 4, pTmp, n);
            pLeaf.dropCell(pLeaf.nCell - 1, nCell);
        }
        this.pages.balance(false);
        if (this.pages.releaseAfter(iCellDepth - 1)) {
            this.pages.balance(false);
        }
        this.moveToRoot();
    }

    @Override
    public void insert(ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int zero, boolean bias) throws SqlJetException {
        SqlJetBtreeShared pBt = this.pBtree.pBt;
        assert (this.pBtree.inTrans == SqlJetBtree.TransMode.WRITE);
        assert (!this.pBtree.isReadOnly());
        assert (this.wrFlag);
        SqlJetAssert.assertFalse(this.eState == SqlJetCursorState.FAULT, this.error);
        this.pBtree.cursors.saveAllCursors(this.pgnoRoot, this);
        int loc = this.moveTo(pKey, nKey, bias);
        assert (this.eState.isValid() || this.eState.isInvalid() && loc != 0);
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        assert (pPage.intKey || nKey >= 0L);
        assert (pPage.leaf || !pPage.intKey);
        SqlJetBtree.TRACE("INSERT: table=%d nkey=%d ndata=%b page=%d %s\n", this.pgnoRoot, nKey, pData, pPage.pgno, loc == 0 ? "overwrite" : "new entry");
        assert (pPage.isInit);
        ISqlJetMemoryPointer newCell = pBt.allocateTempSpace();
        int szNew = pPage.fillInCell(newCell, pKey, nKey, pData, nData, zero);
        assert (szNew == pPage.cellSizePtr(newCell));
        assert (szNew <= pBt.mxCellSize());
        int idx = this.pages.getIndexOnCurrentPage();
        if (loc == 0 && this.eState.isValid()) {
            assert (idx < pPage.nCell);
            pPage.pDbPage.write();
            ISqlJetMemoryPointer oldCell = pPage.findCell(idx);
            if (!pPage.leaf) {
                newCell.copyFrom(oldCell, 4);
            }
            int szOld = pPage.cellSizePtr(oldCell);
            pPage.clearCell(oldCell);
            pPage.dropCell(idx, szOld);
        } else if (loc < 0 && pPage.nCell > 0) {
            assert (pPage.leaf);
            idx = this.pages.getCurrentIndexedPage().incrIndex();
        } else assert (pPage.leaf);
        try {
            pPage.insertCell(idx, newCell, szNew, null, 0);
            assert (pPage.nCell > 0 || !pPage.aOvfl.isEmpty());
        }
        finally {
            this.info.nSize = 0;
            this.validNKey = false;
        }
        if (!pPage.aOvfl.isEmpty()) {
            try {
                this.pages.balance(true);
            }
            finally {
                this.pages.getCurrentPage().aOvfl.clear();
                this.eState = SqlJetCursorState.INVALID;
            }
        }
        assert (this.pages.getCurrentPage().aOvfl.isEmpty());
    }

    @Override
    public boolean first() throws SqlJetException {
        assert (this.pBtree.db.getMutex().held());
        this.moveToRoot();
        if (this.eState.isInvalid()) {
            assert (this.pages.getCurrentPage().nCell == 0);
            return true;
        }
        assert (this.pages.getCurrentPage().nCell > 0);
        this.moveToLeftmost();
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void moveToLeftmost() throws SqlJetException {
        if (SqlJetBtreeCursor.$assertionsDisabled || this.eState.isValid()) ** GOTO lbl7
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (!SqlJetBtreeCursor.$assertionsDisabled && this.pages.getIndexOnCurrentPage() >= pPage.nCell) {
                throw new AssertionError();
            }
            pgno = pPage.findCell(this.pages.getIndexOnCurrentPage()).getInt();
            this.moveToChild(pgno);
lbl7:
            // 2 sources

            pPage = this.pages.getCurrentPage();
            ** while (!pPage.leaf)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void moveToRightmost() throws SqlJetException {
        pPage = null;
        if (SqlJetBtreeCursor.$assertionsDisabled || this.eState.isValid()) ** GOTO lbl7
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            pgno = pPage.getData().getInt(pPage.getHdrOffset() + 8);
            this.pages.setIndexOnCurrentPage(pPage.nCell);
            this.moveToChild(pgno);
lbl7:
            // 2 sources

            pPage = this.pages.getCurrentPage();
            ** while (!pPage.leaf)
        }
lbl9:
        // 1 sources

        this.pages.setIndexOnCurrentPage(pPage.nCell - 1);
        this.info.nSize = 0;
        this.validNKey = false;
    }

    @Override
    public boolean last() throws SqlJetException {
        assert (this.pBtree.db.getMutex().held());
        this.moveToRoot();
        if (this.eState.isInvalid()) {
            assert (this.pages.getCurrentPage().nCell == 0);
            return true;
        }
        assert (this.eState.isValid());
        try {
            try {
                this.moveToRightmost();
            }
            catch (SqlJetException e) {
                this.atLast = false;
                throw e;
            }
        }
        finally {
            this.getCellInfo();
        }
        this.atLast = true;
        return false;
    }

    @Override
    public boolean next() throws SqlJetException {
        this.restoreCursorPosition();
        if (this.eState.isInvalid()) {
            return true;
        }
        if (this.skip > 0) {
            this.skip = 0;
            return false;
        }
        this.skip = 0;
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        int idx = this.pages.getCurrentIndexedPage().incrIndex();
        assert (pPage.isInit);
        assert (idx <= pPage.nCell);
        this.info.nSize = 0;
        this.validNKey = false;
        if (idx >= pPage.nCell) {
            if (!pPage.leaf) {
                this.moveToChild(pPage.getData().getInt(pPage.getHdrOffset() + 8));
                this.moveToLeftmost();
                return false;
            }
            do {
                if (this.pages.hasExactlyOnePage()) {
                    this.eState = SqlJetCursorState.INVALID;
                    return true;
                }
                this.moveToParent();
                pPage = this.pages.getCurrentPage();
            } while (this.pages.getIndexOnCurrentPage() >= pPage.nCell);
            if (pPage.intKey) {
                return this.next();
            }
            return false;
        }
        if (pPage.leaf) {
            return false;
        }
        this.moveToLeftmost();
        return false;
    }

    private void moveToParent() throws SqlJetException {
        assert (this.eState.isValid());
        assert (this.pages.getNumberOfPages() > 1);
        SqlJetMemPage currentPage = this.pages.popCurrentPage();
        assert (currentPage != null);
        this.pages.getCurrentPage().assertParentIndex(this.pages.getIndexOnCurrentPage(), currentPage.pgno);
        SqlJetMemPage.releasePage(currentPage);
        this.info.nSize = 0;
        this.validNKey = false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean previous() throws SqlJetException {
        block6: {
            this.restoreCursorPosition();
            this.atLast = false;
            if (this.eState.isInvalid()) {
                return true;
            }
            if (this.skip < 0) {
                this.skip = 0;
                return false;
            }
            this.skip = 0;
            pPage = this.pages.getCurrentPage();
            if (!SqlJetBtreeCursor.$assertionsDisabled && !pPage.isInit) {
                throw new AssertionError();
            }
            if (pPage.leaf) ** GOTO lbl21
            idx = this.pages.getIndexOnCurrentPage();
            this.moveToChild(pPage.findCell(idx).getInt());
            this.moveToRightmost();
            break block6;
lbl-1000:
            // 1 sources

            {
                if (this.pages.hasExactlyOnePage()) {
                    this.eState = SqlJetCursorState.INVALID;
                    return true;
                }
                this.moveToParent();
lbl21:
                // 2 sources

                ** while (this.pages.getIndexOnCurrentPage() == 0)
            }
lbl22:
            // 1 sources

            this.info.nSize = 0;
            this.validNKey = false;
            this.pages.getCurrentIndexedPage().decrIndex();
            pPage = this.pages.getCurrentPage();
            if (pPage.intKey && !pPage.leaf) {
                return this.previous();
            }
        }
        return false;
    }

    @Override
    public boolean eof() {
        return !this.eState.isValid();
    }

    @Override
    public int flags() throws SqlJetException {
        this.restoreCursorPosition();
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        assert (pPage != null);
        assert (pPage.pBt == this.pBtree.pBt);
        return pPage.getData().getByteUnsigned(pPage.getHdrOffset());
    }

    @Override
    public long getKeySize() throws SqlJetException {
        this.restoreCursorPosition();
        assert (this.eState.isValidOrInvalid());
        if (this.eState.isInvalid()) {
            return 0L;
        }
        this.getCellInfo();
        return this.info.getnKey();
    }

    @Override
    public void key(int offset, int amt, ISqlJetMemoryPointer buf) throws SqlJetException {
        this.restoreCursorPosition();
        assert (this.eState.isValid());
        assert (this.pages.hasCurrentPage());
        SqlJetAssert.assertFalse(this.pages.getFirstPage().intKey, SqlJetErrorCode.CORRUPT);
        assert (this.pages.getIndexOnCurrentPage() < this.pages.getCurrentPage().nCell);
        this.accessPayload(offset, amt, buf, 0, false);
    }

    private void accessPayload(int offset, int amt, ISqlJetMemoryPointer pBuf, int skipKey, boolean eOp) throws SqlJetException {
        int nKey;
        pBuf = SqlJetUtility.pointer(pBuf);
        SqlJetMemPage pPage = this.pages.getCurrentPage();
        assert (this.eState.isValid());
        assert (this.pages.getIndexOnCurrentPage() < pPage.nCell);
        this.getCellInfo();
        ISqlJetMemoryPointer aPayload = this.info.pCell.pointer(this.info.nHeader);
        int n = nKey = pPage.intKey ? 0 : (int)this.info.getnKey();
        if (skipKey != 0) {
            offset += nKey;
        }
        if (offset + amt > nKey + this.info.nData || aPayload.getPointer() + this.info.nLocal > pPage.getData().getPointer() + this.pBtree.pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (offset < this.info.nLocal) {
            int a = amt;
            if (a + offset > this.info.nLocal) {
                a = this.info.nLocal - offset;
            }
            this.copyPayload(aPayload, offset, pBuf, 0, a, eOp, pPage.pDbPage);
            offset = 0;
            pBuf.movePointer(a);
            amt -= a;
        } else {
            offset -= this.info.nLocal;
        }
        if (amt > 0) {
            int ovflSize = this.pBtree.pBt.usableSize - 4;
            int nextPage = aPayload.getInt(this.info.nLocal);
            while (amt > 0 && nextPage != 0) {
                if (offset >= ovflSize) {
                    nextPage = this.pBtree.pBt.getOverflowPage(nextPage, null, nextPage);
                    offset -= ovflSize;
                    continue;
                }
                int a = amt;
                ISqlJetPage pDbPage = this.pBtree.pBt.pPager.getPage(nextPage);
                aPayload = pDbPage.getData();
                nextPage = aPayload.getInt();
                if (a + offset > ovflSize) {
                    a = ovflSize - offset;
                }
                this.copyPayload(aPayload, offset + 4, pBuf, 0, a, eOp, pDbPage);
                pDbPage.unref();
                offset = 0;
                amt -= a;
                pBuf.movePointer(a);
            }
        }
        if (amt > 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void copyPayload(ISqlJetMemoryPointer pPayload, int payloadOffset, ISqlJetMemoryPointer pBuf, int bufOffset, int nByte, boolean eOp, ISqlJetPage pDbPage) throws SqlJetException {
        if (eOp) {
            pDbPage.write();
            pPayload.copyFrom(payloadOffset, pBuf, bufOffset, nByte);
        } else {
            pBuf.copyFrom(bufOffset, pPayload, payloadOffset, nByte);
        }
    }

    @Override
    public ISqlJetDbHandle getCursorDb() {
        assert (this.pBtree.db.getMutex().held());
        return this.pBtree.db;
    }

    @Override
    public ISqlJetMemoryPointer keyFetch(int[] amt) {
        if (this.eState.isValid()) {
            return this.fetchPayload(amt, false);
        }
        return null;
    }

    @Override
    public ISqlJetMemoryPointer dataFetch(int[] amt) {
        if (this.eState.isValid()) {
            return this.fetchPayload(amt, true);
        }
        return null;
    }

    @Override
    public int getDataSize() throws SqlJetException {
        this.restoreCursorPosition();
        assert (this.eState.isValidOrInvalid());
        if (this.eState.isInvalid()) {
            return 0;
        }
        this.getCellInfo();
        return this.info.nData;
    }

    @Override
    public void data(int offset, int amt, ISqlJetMemoryPointer buf) throws SqlJetException {
        SqlJetAssert.assertFalse(this.eState.isInvalid(), SqlJetErrorCode.ABORT);
        this.restoreCursorPosition();
        assert (this.eState.isValid());
        assert (this.pages.hasCurrentPage());
        assert (this.pages.getIndexOnCurrentPage() < this.pages.getCurrentPage().nCell);
        this.accessPayload(offset, amt, buf, 1, false);
    }

    @Override
    public void putData(int offset, int amt, ISqlJetMemoryPointer data) throws SqlJetException {
        assert (this.pBtree.db.getMutex().held());
        this.restoreCursorPosition();
        SqlJetAssert.assertTrue(this.eState.isValid(), SqlJetErrorCode.ABORT);
        SqlJetAssert.assertTrue(this.wrFlag, SqlJetErrorCode.READONLY);
        assert (!this.pBtree.isReadOnly() && this.pBtree.inTrans == SqlJetBtree.TransMode.WRITE);
        SqlJetAssert.assertTrue(this.pages.getCurrentPage().intKey, SqlJetErrorCode.ERROR);
        this.accessPayload(offset, amt, data, 0, true);
    }

    @Override
    public void saveCursorPosition() throws SqlJetException {
        assert (this.eState.isValid());
        assert (this.pKey == null);
        this.nKey = this.getKeySize();
        if (!this.pages.getFirstPage().intKey) {
            ISqlJetMemoryPointer pKey = SqlJetUtility.memoryManager.allocatePtr((int)this.nKey);
            this.key(0, (int)this.nKey, pKey);
            this.pKey = pKey;
        }
        assert (!this.pages.getFirstPage().intKey || this.pKey == null);
        this.pages.clearAllPages();
        this.eState = SqlJetCursorState.REQUIRESEEK;
    }

    public void releaseAllPages() throws SqlJetException {
        this.pages.releaseAllPages();
        this.pages.clearAllPages();
    }
}

