/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.internal.SqlJetResultWithOffset;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetPtrMapType;

public class SqlJetBtreeShared {
    ISqlJetPager pPager;
    SqlJetMemPage pPage1;
    SqlJetAutoVacuumMode autoVacuumMode = SqlJetAutoVacuumMode.NONE;
    private int pageSize;
    int usableSize;

    public int getMaxLocal() {
        return (this.usableSize - 12) * 64 / 255 - 23;
    }

    public int getMinLocal() {
        return (this.usableSize - 12) * 32 / 255 - 23;
    }

    public int getMaxLeaf() {
        return this.usableSize - 35;
    }

    public int getMinLeaf() {
        return (this.usableSize - 12) * 32 / 255 - 23;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int pendingBytePage() {
        return (int)(0x40000000L / (long)this.pageSize) + 1;
    }

    public int mxCellSize() {
        return this.pageSize - 8;
    }

    public int mxCell() {
        return (this.pageSize - 8) / 6;
    }

    public int ptrmapPageNo(int pgno) {
        int nPagesPerMapPage = this.usableSize / 5 + 1;
        int iPtrMap = (pgno - 2) / nPagesPerMapPage;
        int ret = iPtrMap * nPagesPerMapPage + 2;
        if (ret == this.pendingBytePage()) {
            ++ret;
        }
        return ret;
    }

    protected boolean ptrmapIsPage(int pgno) {
        return this.ptrmapPageNo(pgno) == pgno;
    }

    private int ptrmapPtrOffset(int pgptrmap, int pgno) {
        return 5 * (pgno - pgptrmap - 1);
    }

    private int getPageCount() throws SqlJetException {
        assert (this.pPage1 != null);
        return this.pPager.getPageCount();
    }

    public void ptrmapPut(int key, SqlJetPtrMapType eType, int parent) throws SqlJetException {
        assert (!this.ptrmapIsPage(this.pendingBytePage()));
        assert (this.autoVacuumMode.isAutoVacuum());
        SqlJetAssert.assertFalse(key == 0, SqlJetErrorCode.CORRUPT);
        int iPtrmap = this.ptrmapPageNo(key);
        ISqlJetPage pDbPage = this.pPager.getPage(iPtrmap);
        int offset = this.ptrmapPtrOffset(iPtrmap, key);
        ISqlJetMemoryPointer pPtrmap = pDbPage.getData();
        if (eType.getValue() != pPtrmap.getByteUnsigned(offset) || pPtrmap.getInt(offset + 1) != parent) {
            SqlJetBtree.TRACE("PTRMAP_UPDATE: %d->(%s,%d)\n", key, eType.toString(), parent);
            pDbPage.write();
            pPtrmap.putByteUnsigned(offset, eType.getValue());
            pPtrmap.putIntUnsigned(offset + 1, parent);
        }
        pDbPage.unref();
    }

    public SqlJetResultWithOffset<SqlJetPtrMapType> ptrmapGet(int key) throws SqlJetException {
        int iPtrmap = this.ptrmapPageNo(key);
        ISqlJetPage pDbPage = this.pPager.acquirePage(iPtrmap, true);
        ISqlJetMemoryPointer pPtrmap = pDbPage.getData();
        int offset = this.ptrmapPtrOffset(iPtrmap, key);
        int result = pPtrmap.getByteUnsigned(offset);
        int pgno = pPtrmap.getInt(offset + 1);
        pDbPage.unref();
        return new SqlJetResultWithOffset<SqlJetPtrMapType>(SqlJetPtrMapType.fromValue(result), pgno);
    }

    private SqlJetMemPage pageFromDbPage(ISqlJetPage pDbPage, int pgno) {
        if (pDbPage.getExtra() == null) {
            pDbPage.setExtra(new SqlJetMemPage(pDbPage));
        }
        SqlJetMemPage pPage = pDbPage.getExtra();
        pPage.pBt = this;
        pPage.pgno = pgno;
        return pPage;
    }

    public SqlJetMemPage getPage(int pgno, boolean noContent) throws SqlJetException {
        ISqlJetPage pDbPage = this.pPager.acquirePage(pgno, !noContent);
        return this.pageFromDbPage(pDbPage, pgno);
    }

    public SqlJetMemPage allocatePage(int[] pPgno, int nearby, boolean exact) throws SqlJetException {
        SqlJetMemPage ppPage = null;
        SqlJetMemPage pTrunk = null;
        SqlJetMemPage pPrevTrunk = null;
        long n = this.pPage1.getData().getIntUnsigned(36);
        try {
            if (n > 0L) {
                boolean searchList = false;
                if (exact && nearby <= this.getPageCount()) {
                    assert (nearby > 0);
                    assert (this.autoVacuumMode.isAutoVacuum());
                    if (this.ptrmapGet(nearby).getValue() == SqlJetPtrMapType.PTRMAP_FREEPAGE) {
                        searchList = true;
                    }
                    pPgno[0] = nearby;
                }
                this.pPage1.pDbPage.write();
                this.pPage1.getData().putIntUnsigned(36, n - 1L);
                do {
                    int iTrunk = (pPrevTrunk = pTrunk) != null ? pPrevTrunk.getData().getInt(0) : this.pPage1.getData().getInt(32);
                    try {
                        pTrunk = this.getPage(iTrunk, false);
                    }
                    catch (SqlJetException e) {
                        pTrunk = null;
                        throw e;
                    }
                    int k = pTrunk.getData().getInt(4);
                    if (k == 0 && !searchList) {
                        assert (pPrevTrunk == null);
                        pTrunk.pDbPage.write();
                        pPgno[0] = iTrunk;
                        this.pPage1.getData().copyFrom(32, pTrunk.getData(), 0, 4);
                        ppPage = pTrunk;
                        pTrunk = null;
                        SqlJetBtree.traceInt("ALLOCATE: %d trunk - %d free pages left\n", pPgno[0], n - 1L);
                    } else {
                        if (k > this.usableSize / 4 - 2) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (searchList && nearby == iTrunk) {
                            assert (pPgno[0] == iTrunk);
                            ppPage = pTrunk;
                            searchList = false;
                            pTrunk.pDbPage.write();
                            if (k == 0) {
                                if (pPrevTrunk == null) {
                                    this.pPage1.getData().copyFrom(32, pTrunk.getData(), 0, 4);
                                } else {
                                    pPrevTrunk.getData().copyFrom(0, pTrunk.getData(), 0, 4);
                                }
                            } else {
                                int iNewTrunk = pTrunk.getData().getInt(8);
                                SqlJetMemPage pNewTrunk = this.getPage(iNewTrunk, false);
                                try {
                                    pNewTrunk.pDbPage.write();
                                    pNewTrunk.getData().copyFrom(0, pTrunk.getData(), 0, 4);
                                    pNewTrunk.getData().putIntUnsigned(4, k - 1);
                                    pNewTrunk.getData().copyFrom(8, pTrunk.getData(), 12, (k - 1) * 4);
                                }
                                finally {
                                    pNewTrunk.releasePage();
                                }
                                if (pPrevTrunk == null) {
                                    this.pPage1.getData().putIntUnsigned(32, iNewTrunk);
                                } else {
                                    pPrevTrunk.pDbPage.write();
                                    pPrevTrunk.getData().putIntUnsigned(0, iNewTrunk);
                                }
                            }
                            pTrunk = null;
                            SqlJetBtree.traceInt("ALLOCATE: %d trunk - %d free pages left\n", pPgno[0], n - 1L);
                        } else {
                            int closest = 0;
                            ISqlJetMemoryPointer aData = pTrunk.getData();
                            pTrunk.pDbPage.write();
                            if (nearby > 0) {
                                int dist = Math.abs(aData.getInt(8) - nearby);
                                int i = 1;
                                while (i < k) {
                                    int d2 = Math.abs(aData.getInt(8 + i * 4) - nearby);
                                    if (d2 < dist) {
                                        closest = i;
                                        dist = d2;
                                    }
                                    ++i;
                                }
                            }
                            int iPage = aData.getInt(8 + closest * 4);
                            if (!searchList || iPage == nearby) {
                                pPgno[0] = iPage;
                                int nPage = this.getPageCount();
                                if (pPgno[0] > nPage) {
                                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                                }
                                SqlJetBtree.traceInt("ALLOCATE: %d was leaf %d of %d on trunk %d: %d more free pages\n", pPgno[0], closest + 1, k, pTrunk.pgno, n - 1L);
                                if (closest < k - 1) {
                                    aData.copyFrom(8 + closest * 4, aData, 4 + k * 4, 4);
                                }
                                aData.putIntUnsigned(4, k - 1);
                                ppPage = this.getPage(pPgno[0], true);
                                ppPage.pDbPage.dontRollback();
                                try {
                                    ppPage.pDbPage.write();
                                }
                                catch (SqlJetException e) {
                                    ppPage.releasePage();
                                }
                                searchList = false;
                            }
                        }
                    }
                    SqlJetMemPage.releasePage(pPrevTrunk);
                    pPrevTrunk = null;
                } while (searchList);
            } else {
                int nPage = this.getPageCount();
                pPgno[0] = nPage + 1;
                if (this.autoVacuumMode.isAutoVacuum() && this.ptrmapIsPage(pPgno[0])) {
                    SqlJetBtree.traceInt("ALLOCATE: %d from end of file (pointer-map page)\n", pPgno[0]);
                    assert (pPgno[0] != this.pendingBytePage());
                    pPgno[0] = pPgno[0] + 1;
                    if (pPgno[0] == this.pendingBytePage()) {
                        pPgno[0] = pPgno[0] + 1;
                    }
                }
                assert (pPgno[0] != this.pendingBytePage());
                ppPage = this.getPage(pPgno[0], false);
                try {
                    ppPage.pDbPage.write();
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(ppPage);
                }
                SqlJetBtree.traceInt("ALLOCATE: %d from end of file\n", pPgno[0]);
            }
            assert (pPgno[0] != this.pendingBytePage());
        }
        catch (Throwable throwable) {
            SqlJetMemPage.releasePage(pTrunk);
            SqlJetMemPage.releasePage(pPrevTrunk);
            throw throwable;
        }
        SqlJetMemPage.releasePage(pTrunk);
        SqlJetMemPage.releasePage(pPrevTrunk);
        if (ppPage.pDbPage.getRefCount() > 1) {
            SqlJetMemPage.releasePage(ppPage);
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        ppPage.isInit = false;
        return ppPage;
    }

    public void relocatePage(SqlJetMemPage pDbPage, SqlJetPtrMapType s, int iPtrPage, int iFreePage, boolean isCommit) throws SqlJetException {
        int iDbPage = pDbPage.pgno;
        assert (s != SqlJetPtrMapType.PTRMAP_FREEPAGE);
        assert (pDbPage.pBt == this);
        SqlJetBtree.TRACE("AUTOVACUUM: Moving %d to free page %d (ptr page %d type %d)\n", new Object[]{iDbPage, iFreePage, iPtrPage, s});
        pDbPage.pDbPage.move(iFreePage, isCommit);
        pDbPage.pgno = iFreePage;
        if (s == SqlJetPtrMapType.PTRMAP_BTREE || s == SqlJetPtrMapType.PTRMAP_ROOTPAGE) {
            pDbPage.setChildPtrmaps();
        } else {
            int nextOvfl = pDbPage.getData().getInt();
            if (nextOvfl != 0) {
                this.ptrmapPut(nextOvfl, SqlJetPtrMapType.PTRMAP_OVERFLOW2, iFreePage);
            }
        }
        if (s != SqlJetPtrMapType.PTRMAP_ROOTPAGE) {
            SqlJetMemPage pPtrPage = this.getPage(iPtrPage, false);
            try {
                pPtrPage.pDbPage.write();
                pPtrPage.modifyPagePointer(iDbPage, iFreePage, s);
            }
            finally {
                pPtrPage.releasePage();
            }
            this.ptrmapPut(iFreePage, s, iPtrPage);
        }
    }

    public void incrVacuumStep(int nFin, int iLastPg) throws SqlJetException {
        if (!this.ptrmapIsPage(iLastPg) && iLastPg != this.pendingBytePage()) {
            int[] iFreePg;
            int nFreeList = this.pPage1.getData().getInt(36);
            if (nFreeList == 0 || nFin == iLastPg) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            SqlJetResultWithOffset<SqlJetPtrMapType> eType = this.ptrmapGet(iLastPg);
            if (eType.getValue() == SqlJetPtrMapType.PTRMAP_ROOTPAGE) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            if (eType.getValue() == SqlJetPtrMapType.PTRMAP_FREEPAGE) {
                if (nFin == 0) {
                    iFreePg = new int[1];
                    SqlJetMemPage pFreePg = this.allocatePage(iFreePg, iLastPg, true);
                    assert (iFreePg[0] == iLastPg);
                    SqlJetMemPage.releasePage(pFreePg);
                }
            } else {
                iFreePg = new int[1];
                SqlJetMemPage pLastPg = this.getPage(iLastPg, false);
                do {
                    SqlJetMemPage pFreePg;
                    try {
                        pFreePg = this.allocatePage(iFreePg, 0, false);
                    }
                    catch (SqlJetException e) {
                        SqlJetMemPage.releasePage(pLastPg);
                        throw e;
                    }
                    SqlJetMemPage.releasePage(pFreePg);
                } while (nFin != 0 && iFreePg[0] > nFin);
                assert (iFreePg[0] < iLastPg);
                pLastPg.pDbPage.write();
                try {
                    this.relocatePage(pLastPg, eType.getValue(), eType.getOffset(), iFreePg[0], nFin != 0);
                }
                finally {
                    SqlJetMemPage.releasePage(pLastPg);
                }
            }
        }
        if (nFin == 0) {
            --iLastPg;
            while (iLastPg == this.pendingBytePage() || this.ptrmapIsPage(iLastPg)) {
                --iLastPg;
            }
            this.pPager.truncateImage(iLastPg);
        }
    }

    public void autoVacuumCommit() throws SqlJetException {
        int nref = this.pPager.getRefCount();
        assert (this.autoVacuumMode.isAutoVacuum());
        if (!this.autoVacuumMode.isIncrVacuum()) {
            int nOrig = this.getPageCount();
            SqlJetAssert.assertFalse(this.ptrmapIsPage(nOrig), SqlJetErrorCode.CORRUPT);
            if (nOrig == this.pendingBytePage()) {
                --nOrig;
            }
            int nFree = this.pPage1.getData().getInt(36);
            int nPtrmap = (nFree - nOrig + this.ptrmapPageNo(nOrig) + this.pageSize / 5) / (this.pageSize / 5);
            int nFin = nOrig - nFree - nPtrmap;
            if (nOrig > this.pendingBytePage() && nFin <= this.pendingBytePage()) {
                --nFin;
            }
            while (this.ptrmapIsPage(nFin) || nFin == this.pendingBytePage()) {
                --nFin;
            }
            try {
                block12: {
                    try {
                        int iFree = nOrig;
                        while (iFree > nFin) {
                            this.incrVacuumStep(nFin, iFree);
                            --iFree;
                        }
                    }
                    catch (SqlJetException e) {
                        if (e.getErrorCode() == SqlJetErrorCode.DONE) break block12;
                        throw e;
                    }
                }
                if (nFree > 0) {
                    this.pPage1.pDbPage.write();
                    this.pPage1.getData().putIntUnsigned(32, 0L);
                    this.pPage1.getData().putIntUnsigned(36, 0L);
                    this.pPager.truncateImage(nFin);
                }
            }
            catch (SqlJetException e) {
                this.pPager.rollback();
                throw e;
            }
        }
        assert (nref == this.pPager.getRefCount());
    }

    public void clearDatabasePage(int pgno, boolean freePageFlag, int[] pnChange) throws SqlJetException {
        SqlJetAssert.assertFalse(pgno > this.pPager.getPageCount(), SqlJetErrorCode.CORRUPT);
        SqlJetMemPage pPage = this.getAndInitPage(pgno);
        try {
            int i = 0;
            while (i < pPage.nCell) {
                ISqlJetMemoryPointer pCell = pPage.findCell(i);
                if (!pPage.leaf) {
                    this.clearDatabasePage(pCell.getInt(), true, pnChange);
                }
                pPage.clearCell(pCell);
                ++i;
            }
            if (!pPage.leaf) {
                this.clearDatabasePage(pPage.getData().getInt(8), true, pnChange);
            } else if (pnChange != null) {
                assert (pPage.intKey);
                pnChange[0] = pnChange[0] + pPage.nCell;
            }
            if (freePageFlag) {
                pPage.freePage();
            } else {
                pPage.pDbPage.write();
                pPage.zeroPage(pPage.getData().getByteUnsigned(0) | 8);
            }
        }
        finally {
            SqlJetMemPage.releasePage(pPage);
        }
    }

    protected SqlJetMemPage getAndInitPage(int pgno) throws SqlJetException {
        ISqlJetPage pDbPage = null;
        SqlJetMemPage pPage = null;
        SqlJetAssert.assertFalse(pgno == 0, SqlJetErrorCode.CORRUPT);
        try {
            pDbPage = this.pPager.lookupPage(pgno);
            if (pDbPage != null) {
                pPage = this.pageFromDbPage(pDbPage, pgno);
            } else {
                if (pgno > this.pPager.getPageCount()) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                pPage = this.getPage(pgno, false);
            }
            pPage.initPage();
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pPage);
            throw e;
        }
        return pPage;
    }

    public int getOverflowPage(int ovfl, SqlJetMemPage[] ppPage, int pPgnoNext) throws SqlJetException {
        int next = 0;
        assert (ppPage != null && ppPage.length != 0);
        if (pPgnoNext == 0) {
            ppPage[0] = this.getPage(ovfl, true);
            return 0;
        }
        if (this.autoVacuumMode.isAutoVacuum()) {
            SqlJetResultWithOffset<SqlJetPtrMapType> eType;
            int iGuess = ovfl + 1;
            while (this.ptrmapIsPage(iGuess) || iGuess == this.pendingBytePage()) {
                ++iGuess;
            }
            if (iGuess <= this.pPager.getPageCount() && (eType = this.ptrmapGet(iGuess)).getValue() == SqlJetPtrMapType.PTRMAP_OVERFLOW2 && eType.getOffset() == ovfl) {
                next = iGuess;
            }
        }
        if (next == 0 || ppPage != null && ppPage.length != 0) {
            SqlJetMemPage pPage = null;
            try {
                pPage = this.getPage(ovfl, next != 0);
            }
            finally {
                if (next == 0 && pPage != null) {
                    next = pPage.getData().getInt();
                }
                if (ppPage != null && ppPage.length != 0) {
                    ppPage[0] = pPage;
                } else {
                    SqlJetMemPage.releasePage(pPage);
                }
            }
        }
        return next;
    }

    public ISqlJetMemoryPointer allocateTempSpace() {
        return SqlJetUtility.memoryManager.allocatePtr(this.pageSize);
    }
}

