/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetIndexedMemPage;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetPtrMapType;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;

public class SqlJetIndexedMemPages {
    private static final int NN = 1;
    private static final int NB = 3;
    private final int nMin;
    private final int pageSize;
    private int iPage = -1;
    private final SqlJetIndexedMemPage[] apPage = new SqlJetIndexedMemPage[20];

    public SqlJetIndexedMemPages(int nMin, int pageSize) {
        this.nMin = nMin;
        this.pageSize = pageSize;
    }

    public void addNewPage(SqlJetMemPage pPage) throws SqlJetException {
        SqlJetAssert.assertTrue(this.iPage < this.apPage.length - 1, SqlJetErrorCode.CORRUPT);
        ++this.iPage;
        this.apPage[this.iPage] = new SqlJetIndexedMemPage(pPage);
    }

    public SqlJetIndexedMemPage getCurrentIndexedPage() {
        return this.apPage[this.iPage];
    }

    public SqlJetMemPage getCurrentPage() {
        return this.getCurrentIndexedPage().getPage();
    }

    public SqlJetMemPage getPage(int num) {
        return this.apPage[num].getPage();
    }

    public SqlJetMemPage getFirstPage() {
        return this.getPage(0);
    }

    public void setIndexOnCurrentPage(int index) {
        this.apPage[this.iPage].setIndex(index);
    }

    public boolean hasCurrentPage() {
        return this.iPage >= 0 && this.getCurrentPage() != null;
    }

    public boolean hasExactlyOnePage() {
        return this.iPage == 0;
    }

    public SqlJetMemPage popCurrentPage() {
        SqlJetMemPage currentPage = this.getCurrentIndexedPage().getPage();
        --this.iPage;
        return currentPage;
    }

    public List<SqlJetMemPage> getAllPages() {
        ArrayList<SqlJetMemPage> result = new ArrayList<SqlJetMemPage>();
        int i = 0;
        while (i <= this.iPage) {
            result.add(this.apPage[i].getPage());
            ++i;
        }
        return result;
    }

    public void releaseAllPages() throws SqlJetException {
        for (SqlJetMemPage mp : this.getAllPages()) {
            SqlJetMemPage.releasePage(mp);
        }
    }

    public boolean releaseAfter(int num) throws SqlJetException {
        boolean result = false;
        while (this.iPage > num) {
            result = true;
            SqlJetMemPage.releasePage(this.popCurrentPage());
        }
        return result;
    }

    public void clearAllPages() {
        int i = 0;
        while (i <= this.iPage) {
            this.apPage[i] = null;
            ++i;
        }
        this.iPage = -1;
    }

    public int getIndexOnCurrentPage() {
        return this.getCurrentIndexedPage().getIndex();
    }

    public int getNumberOfPages() {
        return this.iPage + 1;
    }

    public void balance(boolean isInsert) throws SqlJetException {
        ISqlJetMemoryPointer aBalanceQuickSpace = SqlJetUtility.memoryManager.allocatePtr(13);
        int balance_quick_called = 0;
        int balance_deeper_called = 0;
        while (true) {
            SqlJetMemPage pPage = this.getCurrentPage();
            if (this.hasExactlyOnePage()) {
                if (pPage.aOvfl.size() <= 0) break;
                assert (balance_deeper_called++ == 0);
                this.addNewPage(SqlJetIndexedMemPages.balanceDeeper(pPage));
                this.apPage[0].setIndex(0);
                assert (!this.apPage[1].getPage().aOvfl.isEmpty());
                continue;
            }
            if (pPage.aOvfl.isEmpty() && pPage.nFree <= this.nMin) break;
            SqlJetMemPage pParent = this.apPage[this.iPage - 1].getPage();
            int iIdx = this.apPage[this.iPage - 1].getIndex();
            pParent.pDbPage.write();
            if (pPage.hasData && pPage.aOvfl.size() == 1 && pPage.aOvfl.get(0).getIdx() == pPage.nCell && pParent.pgno != 1 && pParent.nCell == iIdx) {
                assert (balance_quick_called++ == 0);
                SqlJetIndexedMemPages.balanceQuick(pParent, pPage, aBalanceQuickSpace);
            } else {
                ISqlJetMemoryPointer pSpace = SqlJetUtility.memoryManager.allocatePtr(this.pageSize);
                SqlJetIndexedMemPages.balanceNonroot(pParent, iIdx, pSpace, this.iPage == 1);
            }
            pPage.aOvfl.clear();
            pPage.releasePage();
            --this.iPage;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void balanceNonroot(SqlJetMemPage pParent, int iParentIdx, ISqlJetMemoryPointer aOvflSpace, boolean isRoot) throws SqlJetException {
        nCell = 0;
        nMaxCells = 0;
        nNew = 0;
        nOld = 0;
        iSpace1 = 0;
        iOvflSpace = 0;
        apOld = new SqlJetMemPage[3];
        apCopy = new SqlJetMemPage[3];
        apNew = new SqlJetMemPage[5];
        apDiv = new ISqlJetMemoryPointer[2];
        szNew = new int[5];
        pBt = pParent.pBt;
        if (!SqlJetIndexedMemPages.$assertionsDisabled && !pParent.pDbPage.isWriteable()) {
            throw new AssertionError();
        }
        if (!SqlJetIndexedMemPages.$assertionsDisabled && pParent.aOvfl.size() > 1) {
            throw new AssertionError();
        }
        if (!SqlJetIndexedMemPages.$assertionsDisabled && !pParent.aOvfl.isEmpty() && pParent.aOvfl.get(0).getIdx() != iParentIdx) {
            throw new AssertionError();
        }
        try {
            block97: {
                block96: {
                    i = pParent.aOvfl.size() + pParent.nCell;
                    if (i < 2) {
                        nxDiv = 0;
                        nOld = i + 1;
                    } else {
                        nOld = 3;
                        nxDiv = iParentIdx == 0 ? 0 : (iParentIdx == i ? i - 2 : iParentIdx - 1);
                        i = 2;
                    }
                    pRight = i + nxDiv - pParent.aOvfl.size() == pParent.nCell ? pParent.getData().getMoved(pParent.getHdrOffset() + 8) : pParent.findCell(i + nxDiv - pParent.aOvfl.size());
                    pgno = pRight.getInt();
                    while (true) {
                        apOld[i] = pBt.getAndInitPage(pgno);
                        nMaxCells += 1 + apOld[i].nCell + apOld[i].aOvfl.size();
                        if (i-- == 0) break;
                        if (!pParent.aOvfl.isEmpty() && i + nxDiv == pParent.aOvfl.get(0).getIdx()) {
                            apDiv[i] = pParent.aOvfl.get(0).getpCell();
                            pgno = apDiv[i].getInt();
                            szNew[i] = pParent.cellSizePtr(apDiv[i]);
                            pParent.aOvfl.clear();
                            continue;
                        }
                        apDiv[i] = pParent.findCell(i + nxDiv - pParent.aOvfl.size());
                        pgno = apDiv[i].getInt();
                        szNew[i] = pParent.cellSizePtr(apDiv[i]);
                        if (ISqlJetConfig.SECURE_DELETE) {
                            iOff = apDiv[i].getPointer() - pParent.getData().getPointer();
                            if (iOff + szNew[i] > pBt.usableSize) {
                                Arrays.fill(apOld, 0, i, null);
                                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                            }
                            aOvflSpace.copyFrom(iOff, apDiv[i], 0, szNew[i]);
                            apDiv[i] = aOvflSpace.getMoved(apDiv[i].getPointer() - pParent.getData().getPointer());
                        }
                        try {
                            pParent.dropCell(i + nxDiv - pParent.aOvfl.size(), szNew[i]);
                        }
                        catch (SqlJetException e) {
                            SqlJetBtree.TRACE("exception in dropCell call: %s", new Object[]{e.getMessage()});
                        }
                    }
                    nMaxCells = nMaxCells + 3 & -4;
                    apCell = new SqlJetMemoryPointer[nMaxCells];
                    szCell = new int[nMaxCells];
                    leafCorrection = apOld[0].leaf != false ? 4 : 0;
                    leafData = apOld[0].hasData;
                    i = 0;
                    while (i < nOld) {
                        pOld = apCopy[i] = SqlJetUtility.memcpy(apOld[i]);
                        pOld.getData().copyFrom(apOld[i].getData(), pBt.getPageSize());
                        limit = pOld.nCell + pOld.aOvfl.size();
                        if (!pOld.aOvfl.isEmpty()) {
                            j = 0;
                            while (j < limit) {
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && nCell >= nMaxCells) {
                                    throw new AssertionError();
                                }
                                apCell[nCell] = pOld.findOverflowCell(j);
                                szCell[nCell] = pOld.cellSizePtr(apCell[nCell]);
                                ++nCell;
                                ++j;
                            }
                        } else {
                            aData = pOld.getData();
                            maskPage = pOld.maskPage;
                            cellOffset = pOld.cellOffset;
                            j = 0;
                            while (j < limit) {
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && nCell >= nMaxCells) {
                                    throw new AssertionError();
                                }
                                apCell[nCell] = SqlJetIndexedMemPages.findCellv2(aData, maskPage, cellOffset, j);
                                szCell[nCell] = pOld.cellSizePtr(apCell[nCell]);
                                ++nCell;
                                ++j;
                            }
                        }
                        if (i < nOld - 1 && !leafData) {
                            sz = szNew[i];
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && nCell >= nMaxCells) {
                                throw new AssertionError();
                            }
                            szCell[nCell] = sz;
                            pTemp = SqlJetUtility.memoryManager.allocatePtr(sz);
                            iSpace1 += sz;
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && sz > pBt.getMaxLocal() + 23) {
                                throw new AssertionError();
                            }
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && iSpace1 > pBt.getPageSize()) {
                                throw new AssertionError();
                            }
                            pTemp.copyFrom(apDiv[i], sz);
                            apCell[nCell] = pTemp.getMoved(leafCorrection);
                            szCell[nCell] = szCell[nCell] - leafCorrection;
                            if (!pOld.leaf) {
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && leafCorrection != 0) {
                                    throw new AssertionError();
                                }
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && pOld.getHdrOffset() != 0) {
                                    throw new AssertionError();
                                }
                                apCell[nCell].copyFrom(0, pOld.getData(), 8, 4);
                            } else {
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && leafCorrection != 4) {
                                    throw new AssertionError();
                                }
                                if (szCell[nCell] < 4) {
                                    szCell[nCell] = 4;
                                }
                            }
                            ++nCell;
                        }
                        ++i;
                    }
                    cntNew = new int[5];
                    usableSpace = pBt.usableSize - 12 + leafCorrection;
                    i = 0;
                    k = 0;
                    subtotal = 0;
                    while (i < nCell) {
                        if (!SqlJetIndexedMemPages.$assertionsDisabled && i >= nMaxCells) {
                            throw new AssertionError();
                        }
                        if ((subtotal += szCell[i] + 2) > usableSpace) {
                            szNew[k] = subtotal - szCell[i];
                            cntNew[k] = i--;
                            if (leafData) {
                                // empty if block
                            }
                            subtotal = 0;
                            if (++k > 4) {
                                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                            }
                        }
                        ++i;
                    }
                    szNew[k] = subtotal;
                    cntNew[k] = nCell;
                    i = ++k - 1;
                    while (i > 0) {
                        szRight = szNew[i];
                        szLeft = szNew[i - 1];
                        r = cntNew[i - 1] - 1;
                        d = r + 1 - (leafData != false ? 1 : 0);
                        if (!SqlJetIndexedMemPages.$assertionsDisabled && d >= nMaxCells) {
                            throw new AssertionError();
                        }
                        if (SqlJetIndexedMemPages.$assertionsDisabled || r < nMaxCells) ** GOTO lbl153
                        throw new AssertionError();
lbl-1000:
                        // 1 sources

                        {
                            szRight += szCell[d] + 2;
                            szLeft -= szCell[r] + 2;
                            v0 = i - 1;
                            cntNew[v0] = cntNew[v0] - 1;
                            r = cntNew[i - 1] - 1;
                            d = r + 1 - (leafData != false ? 1 : 0);
lbl153:
                            // 2 sources

                            ** while (szRight == 0 || szRight + szCell[d] + 2 <= szLeft - (szCell[r] + 2))
                        }
lbl154:
                        // 1 sources

                        szNew[i] = szRight;
                        szNew[i - 1] = szLeft;
                        --i;
                    }
                    if (!(SqlJetIndexedMemPages.$assertionsDisabled || cntNew[0] > 0 || pParent.pgno == 1 && pParent.nCell == 0)) {
                        throw new AssertionError();
                    }
                    SqlJetBtree.traceInt("BALANCE: old: %d %d %d  ", new long[]{apOld[0].pgno, nOld >= 2 ? apOld[1].pgno : 0, nOld >= 3 ? apOld[2].pgno : 0});
                    if (apOld[0].pgno <= 1) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    pageFlags = apOld[0].getData().getByteUnsigned(0);
                    i = 0;
                    while (i < k) {
                        if (i < nOld) {
                            pNew = apNew[i] = apOld[i];
                            apOld[i] = null;
                            ++nNew;
                            pNew.pDbPage.write();
                        } else {
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && i <= 0) {
                                throw new AssertionError();
                            }
                            p = new int[1];
                            pNew = pBt.allocatePage(p, pgno, false);
                            pgno = p[0];
                            apNew[i] = pNew;
                            ++nNew;
                            if (pBt.autoVacuumMode.isAutoVacuum()) {
                                pBt.ptrmapPut(pNew.pgno, SqlJetPtrMapType.PTRMAP_BTREE, pParent.pgno);
                            }
                        }
                        ++i;
                    }
                    while (i < nOld) {
                        apOld[i].freePage();
                        apOld[i].releasePage();
                        apOld[i] = null;
                        ++i;
                    }
                    i = 0;
                    while (i < k - 1) {
                        minV = apNew[i].pgno;
                        minI = i;
                        j = i + 1;
                        while (j < k) {
                            if (apNew[j].pgno < minV) {
                                minI = j;
                                minV = apNew[j].pgno;
                            }
                            ++j;
                        }
                        if (minI > i) {
                            pT = apNew[i];
                            apNew[i] = apNew[minI];
                            apNew[minI] = pT;
                        }
                        ++i;
                    }
                    SqlJetBtree.traceInt("new: %d(%d) %d(%d) %d(%d) %d(%d) %d(%d)\n", new long[]{apNew[0].pgno, szNew[0], nNew >= 2 ? apNew[1].pgno : 0, nNew >= 2 ? szNew[1] : 0, nNew >= 3 ? apNew[2].pgno : 0, nNew >= 3 ? szNew[2] : 0, nNew >= 4 ? apNew[3].pgno : 0, nNew >= 4 ? szNew[3] : 0, nNew >= 5 ? apNew[4].pgno : 0, nNew >= 5 ? szNew[4] : 0});
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && !pParent.pDbPage.isWriteable()) {
                        throw new AssertionError();
                    }
                    pRight.putIntUnsigned(0, apNew[nNew - 1].pgno);
                    j = 0;
                    i = 0;
                    while (i < nNew) {
                        pNew = apNew[i];
                        if (!SqlJetIndexedMemPages.$assertionsDisabled && j >= nMaxCells) {
                            throw new AssertionError();
                        }
                        pNew.zeroPage(pageFlags);
                        pNew.assemblePage(cntNew[i] - j, apCell, j, szCell, j);
                        if (!(SqlJetIndexedMemPages.$assertionsDisabled || pNew.nCell > 0 || nNew == 1 && cntNew[0] == 0)) {
                            throw new AssertionError();
                        }
                        if (!SqlJetIndexedMemPages.$assertionsDisabled && !pNew.aOvfl.isEmpty()) {
                            throw new AssertionError();
                        }
                        j = cntNew[i];
                        if (!SqlJetIndexedMemPages.$assertionsDisabled && i >= nNew - 1 && j != nCell) {
                            throw new AssertionError();
                        }
                        if (j < nCell) {
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && j >= nMaxCells) {
                                throw new AssertionError();
                            }
                            pCell = apCell[j];
                            sz = szCell[j] + leafCorrection;
                            pTemp = aOvflSpace.getMoved(iOvflSpace);
                            if (!pNew.leaf) {
                                pNew.getData().copyFrom(8, pCell, 0, 4);
                            } else if (leafData) {
                                info = pNew.parseCellPtr(apCell[--j]);
                                pCell = pTemp;
                                sz = 4 + pCell.getMoved(4).putVarint(info.getnKey());
                                pCell.putIntUnsigned(0, pNew.pgno);
                                pTemp = null;
                            } else {
                                pCell = SqlJetUtility.getMoved(j > 0 ? apCell[j - 1] : null, pCell, -4);
                                if (szCell[j] == 4) {
                                    if (!SqlJetIndexedMemPages.$assertionsDisabled && leafCorrection != 4) {
                                        throw new AssertionError();
                                    }
                                    sz = pParent.cellSizePtr(pCell);
                                }
                            }
                            iOvflSpace += sz;
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && sz > pBt.getMaxLocal() + 23) {
                                throw new AssertionError();
                            }
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && iOvflSpace > pBt.getPageSize()) {
                                throw new AssertionError();
                            }
                            pParent.insertCell(nxDiv, pCell, sz, pTemp, pNew.pgno);
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && !pParent.pDbPage.isWriteable()) {
                                throw new AssertionError();
                            }
                            ++j;
                            ++nxDiv;
                        }
                        ++i;
                    }
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && j != nCell) {
                        throw new AssertionError();
                    }
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && nOld <= 0) {
                        throw new AssertionError();
                    }
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && nNew <= 0) {
                        throw new AssertionError();
                    }
                    if ((pageFlags & 8) == 0) {
                        apNew[nNew - 1].getData().copyFrom(8, apCopy[nOld - 1].getData(), 8, 4);
                    }
                    if (!isRoot || pParent.nCell != 0 || pParent.getHdrOffset() > apNew[0].nFree) break block96;
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && nNew != 1) {
                        throw new AssertionError();
                    }
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && apNew[0].nFree != apNew[0].getData().getShortUnsigned(5) - apNew[0].cellOffset - apNew[0].nCell * 2) {
                        throw new AssertionError();
                    }
                    apNew[0].copyNodeContent(pParent);
                    apNew[0].freePage();
                    break block97;
                }
                if (!pBt.autoVacuumMode.isAutoVacuum()) break block97;
                pNew = apNew[0];
                pOld = apCopy[0];
                nOverflow = pOld.aOvfl.size();
                iNextOld = pOld.nCell + nOverflow;
                iOverflow = nOverflow > 0 ? pOld.aOvfl.get(0).getIdx() : -1;
                j = 0;
                k = 0;
                isDivider = false;
                i = 0;
                ** GOTO lbl321
                {
                    if (!SqlJetIndexedMemPages.$assertionsDisabled && j + 1 >= apCopy.length) {
                        throw new AssertionError();
                    }
                    pOld = apCopy[++j];
                    iNextOld = i + (leafData == false ? 1 : 0) + pOld.nCell + pOld.aOvfl.size();
                    if (!pOld.aOvfl.isEmpty()) {
                        nOverflow = pOld.aOvfl.size();
                        iOverflow = i + (leafData == false ? 1 : 0) + pOld.aOvfl.get(0).getIdx();
                    }
                    v1 = isDivider = leafData == false;
                    do {
                        block99: {
                            block98: {
                                if (i == iNextOld) continue block17;
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && nOverflow <= 0 && iOverflow >= i) {
                                    throw new AssertionError();
                                }
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && nOverflow >= 2 && pOld.aOvfl.get(1).getIdx() != pOld.aOvfl.get(0).getIdx() - 1) {
                                    throw new AssertionError();
                                }
                                if (!SqlJetIndexedMemPages.$assertionsDisabled && nOverflow >= 3 && pOld.aOvfl.get(2).getIdx() != pOld.aOvfl.get(1).getIdx() - 1) {
                                    throw new AssertionError();
                                }
                                if (i == iOverflow) {
                                    isDivider = true;
                                    if (--nOverflow > 0) {
                                        ++iOverflow;
                                    }
                                }
                                if (i != cntNew[k]) break block98;
                                pNew = apNew[++k];
                                if (!leafData) break block99;
                            }
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && j >= nOld) {
                                throw new AssertionError();
                            }
                            if (!SqlJetIndexedMemPages.$assertionsDisabled && k >= nNew) {
                                throw new AssertionError();
                            }
                            if (isDivider || pOld.pgno != pNew.pgno) {
                                if (leafCorrection <= 0) {
                                    pBt.ptrmapPut(apCell[i].getInt(), SqlJetPtrMapType.PTRMAP_BTREE, pNew.pgno);
                                }
                                if (szCell[i] > pNew.minLocal) {
                                    pNew.ptrmapPutOvflPtr(apCell[i]);
                                }
                            }
                        }
                        ++i;
lbl321:
                        // 2 sources

                    } while (i < nCell);
                }
                if (leafCorrection <= 0) {
                    i = 0;
                    while (i < nNew) {
                        key = apNew[i].getData().getInt(8);
                        pBt.ptrmapPut(key, SqlJetPtrMapType.PTRMAP_BTREE, apNew[i].pgno);
                        ++i;
                    }
                }
            }
            if (!SqlJetIndexedMemPages.$assertionsDisabled && !pParent.isInit) {
                throw new AssertionError();
            }
            SqlJetBtree.traceInt("BALANCE: finished: old=%d new=%d cells=%d\n", new long[]{nOld, nNew, nCell});
        }
        finally {
            i = 0;
            ** while (i < nOld)
        }
lbl-1000:
        // 1 sources

        {
            SqlJetMemPage.releasePage((SqlJetMemPage)apOld[i]);
            ++i;
            continue;
        }
lbl340:
        // 1 sources

        i = 0;
        while (i < nNew) {
            SqlJetMemPage.releasePage(apNew[i]);
            ++i;
        }
    }

    private static ISqlJetMemoryPointer findCellv2(ISqlJetMemoryPointer d, int M, int O, int I) {
        return d.getMoved(M & d.getShortUnsigned(O + 2 * I));
    }

    private static void balanceQuick(SqlJetMemPage pParent, SqlJetMemPage pPage, ISqlJetMemoryPointer pSpace) throws SqlJetException {
        SqlJetBtreeShared pBt = pPage.pBt;
        int[] pgnoNew = new int[1];
        assert (pParent.pDbPage.isWriteable());
        assert (pPage.aOvfl.size() == 1);
        SqlJetAssert.assertTrue(pPage.nCell > 0, SqlJetErrorCode.CORRUPT);
        SqlJetMemPage pNew = pBt.allocatePage(pgnoNew, 0, false);
        try {
            boolean b;
            ISqlJetMemoryPointer pOut = pSpace.getMoved(4);
            ISqlJetMemoryPointer pCell = pPage.aOvfl.get(0).getpCell();
            int szCell = pPage.cellSizePtr(pCell);
            assert (pNew.pDbPage.isWriteable());
            assert (pPage.getData().getByteUnsigned(0) == 13);
            pNew.zeroPage(13);
            pNew.assemblePage(1, new ISqlJetMemoryPointer[]{pCell}, 0, new int[]{szCell}, 0);
            if (pBt.autoVacuumMode.isAutoVacuum()) {
                pBt.ptrmapPut(pgnoNew[0], SqlJetPtrMapType.PTRMAP_BTREE, pParent.pgno);
                if (szCell > pNew.minLocal) {
                    pNew.ptrmapPutOvflPtr(pCell);
                }
            }
            pCell = pPage.findCell(pPage.nCell - 1);
            ISqlJetMemoryPointer pStop = pCell.getMoved(9);
            do {
                b = (pCell.getByteUnsigned() & 0x80) == 0;
                pCell.movePointer(1);
            } while (!b && pCell.getPointer() < pStop.getPointer());
            pStop = pCell.getMoved(9);
            do {
                pOut.putByteUnsigned(pCell.getByteUnsigned());
                pOut.movePointer(1);
                b = (pCell.getByteUnsigned() & 0x80) == 0;
                pCell.movePointer(1);
            } while (!b && pCell.getPointer() < pStop.getPointer());
            pParent.insertCell(pParent.nCell, pSpace, pOut.getPointer() - pSpace.getPointer(), null, pPage.pgno);
            pParent.getData().putIntUnsigned(pParent.getHdrOffset() + 8, pgnoNew[0]);
        }
        finally {
            SqlJetMemPage.releasePage(pNew);
        }
    }

    private static SqlJetMemPage balanceDeeper(SqlJetMemPage pRoot) throws SqlJetException {
        SqlJetMemPage pChild = null;
        int[] pgnoChild = new int[1];
        SqlJetBtreeShared pBt = pRoot.pBt;
        assert (!pRoot.aOvfl.isEmpty());
        pRoot.pDbPage.write();
        try {
            pChild = pBt.allocatePage(pgnoChild, pRoot.pgno, false);
            pRoot.copyNodeContent(pChild);
            if (pBt.autoVacuumMode.isAutoVacuum()) {
                pBt.ptrmapPut(pgnoChild[0], SqlJetPtrMapType.PTRMAP_BTREE, pRoot.pgno);
            }
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pChild);
            throw e;
        }
        assert (pChild.pDbPage.isWriteable());
        assert (pRoot.pDbPage.isWriteable());
        assert (pChild.nCell == pRoot.nCell);
        SqlJetBtree.traceInt("BALANCE: copy root %d into %d\n", pRoot.pgno, pChild.pgno);
        pChild.aOvfl = pRoot.aOvfl.clone();
        pRoot.zeroPage(pChild.getData().getByteUnsigned(0) & 0xFFFFFFF7);
        pRoot.getData().putIntUnsigned(pRoot.getHdrOffset() + 8, pgnoChild[0]);
        return pChild;
    }
}

