/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetOvflCell;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetOvflCells;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetPtrMapType;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult32;

public class SqlJetMemPage
extends SqlJetCloneable {
    public static final byte PTF_INTKEY = 1;
    public static final byte PTF_ZERODATA = 2;
    public static final byte PTF_LEAFDATA = 4;
    public static final byte PTF_LEAF = 8;
    protected boolean isInit;
    protected boolean intKey;
    protected boolean leaf;
    protected boolean hasData;
    private int maxLocal;
    protected int minLocal;
    protected int cellOffset;
    protected int nFree;
    protected int nCell;
    protected int maskPage;
    protected SqlJetOvflCells aOvfl = new SqlJetOvflCells();
    protected SqlJetBtreeShared pBt;
    private ISqlJetMemoryPointer aData;
    protected final ISqlJetPage pDbPage;
    protected int pgno = 0;

    protected int getHdrOffset() {
        return this.pgno == 1 ? 100 : 0;
    }

    public SqlJetMemPage(ISqlJetPage pDbPage) {
        this.pDbPage = pDbPage;
        this.aData = pDbPage.getData();
    }

    private void decodeFlags(int flagByte) throws SqlJetException {
        boolean bl = this.leaf = (flagByte & 8) > 0;
        if ((flagByte &= 0xFFFFFFF7) == 5) {
            this.intKey = true;
            this.hasData = this.leaf;
            this.maxLocal = this.pBt.getMaxLeaf();
            this.minLocal = this.pBt.getMinLeaf();
        } else if (flagByte == 2) {
            this.intKey = false;
            this.hasData = false;
            this.maxLocal = this.pBt.getMaxLocal();
            this.minLocal = this.pBt.getMinLocal();
        } else {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public void initPage() throws SqlJetException {
        if (!this.isInit) {
            assert (this.pBt != null);
            assert (this.pgno == this.pDbPage.getPageNumber());
            assert (this == this.pDbPage.getExtra());
            assert (this.aData.getBuffer() == this.pDbPage.getData().getBuffer());
            int hdr = this.getHdrOffset();
            this.decodeFlags(this.aData.getByteUnsigned(hdr));
            this.maskPage = this.pBt.getPageSize() - 1;
            this.aOvfl.clear();
            int usableSize = this.pBt.usableSize;
            this.cellOffset = hdr + 12 - 4 * (this.leaf ? 1 : 0);
            int top = this.aData.getShortUnsigned(hdr + 5);
            this.nCell = this.aData.getShortUnsigned(hdr + 3);
            if (this.nCell > this.pBt.mxCell()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            int iCellFirst = this.cellOffset + 2 * this.nCell;
            int pc = this.aData.getShortUnsigned(hdr + 1);
            int nFree = this.aData.getByteUnsigned(hdr + 7) + top;
            while (pc > 0) {
                SqlJetAssert.assertTrue(pc <= usableSize - 4, SqlJetErrorCode.CORRUPT);
                int next = this.aData.getShortUnsigned(pc);
                int size = this.aData.getShortUnsigned(pc + 2);
                if (next > 0 && next <= pc + size + 3) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                nFree += size;
                pc = next;
            }
            if (nFree > usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.nFree = nFree - iCellFirst;
            this.isInit = true;
        }
    }

    public static void releasePage(SqlJetMemPage pPage) throws SqlJetException {
        if (pPage != null) {
            pPage.releasePage();
        }
    }

    public void releasePage() throws SqlJetException {
        assert (this.aData != null);
        assert (this.pBt != null);
        assert (this.pDbPage.getExtra() == this);
        assert (this.pDbPage.getData().getBuffer() == this.aData.getBuffer());
        this.pDbPage.unref();
    }

    public void setChildPtrmaps() throws SqlJetException {
        boolean isInitOrig = this.isInit;
        try {
            this.initPage();
            int nCell = this.nCell;
            int i = 0;
            while (i < nCell) {
                ISqlJetMemoryPointer pCell = this.findCell(i);
                this.ptrmapPutOvflPtr(pCell);
                if (!this.leaf) {
                    int childPgno = pCell.getInt();
                    this.pBt.ptrmapPut(childPgno, SqlJetPtrMapType.PTRMAP_BTREE, this.pgno);
                }
                ++i;
            }
            if (!this.leaf) {
                int childPgno = this.aData.getInt(this.getHdrOffset() + 8);
                this.pBt.ptrmapPut(childPgno, SqlJetPtrMapType.PTRMAP_BTREE, this.pgno);
            }
        }
        catch (SqlJetException e) {
            this.isInit = isInitOrig;
            throw e;
        }
    }

    public void modifyPagePointer(int iFrom, int iTo, SqlJetPtrMapType s) throws SqlJetException {
        if (s == SqlJetPtrMapType.PTRMAP_OVERFLOW2) {
            if (this.aData.getInt() != iFrom) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.aData.putIntUnsigned(0, iTo);
        } else {
            boolean isInitOrig = this.isInit;
            this.initPage();
            int nCell = this.nCell;
            int i = 0;
            while (i < nCell) {
                ISqlJetMemoryPointer pCell = this.findCell(i);
                if (s == SqlJetPtrMapType.PTRMAP_OVERFLOW1) {
                    SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
                    if (info.iOverflow > 0 && iFrom == pCell.getInt(info.iOverflow)) {
                        pCell.putIntUnsigned(info.iOverflow, iTo);
                        break;
                    }
                } else if (pCell.getInt() == iFrom) {
                    pCell.putIntUnsigned(0, iTo);
                    break;
                }
                ++i;
            }
            if (i == nCell) {
                if (s != SqlJetPtrMapType.PTRMAP_BTREE || this.aData.getInt(this.getHdrOffset() + 8) != iFrom) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                this.aData.putIntUnsigned(this.getHdrOffset() + 8, iTo);
            }
            this.isInit = isInitOrig;
        }
    }

    public ISqlJetMemoryPointer findCell(int i) {
        return this.aData.pointer(this.maskPage & this.aData.getShortUnsigned(this.cellOffset + 2 * i));
    }

    public void ptrmapPutOvflPtr(ISqlJetMemoryPointer pCell) throws SqlJetException {
        assert (pCell != null);
        SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
        assert ((long)info.nData + (this.intKey ? 0L : info.getnKey()) == (long)info.nPayload);
        if ((long)info.nData + (this.intKey ? 0L : info.getnKey()) > (long)info.nLocal) {
            int ovfl = pCell.getInt(info.iOverflow);
            this.pBt.ptrmapPut(ovfl, SqlJetPtrMapType.PTRMAP_OVERFLOW1, this.pgno);
        }
    }

    SqlJetBtreeCellInfo parseCellPtr(ISqlJetMemoryPointer pCell) {
        int iOverflow;
        int nLocal;
        int nSize;
        int nData;
        long nKey;
        int nPayload;
        SqlJetVarintResult32 res;
        int n = this.getChildPtrSize();
        if (this.intKey) {
            if (this.hasData) {
                res = pCell.getVarint32(n);
                nPayload = res.getValue();
                n += res.getOffset();
            } else {
                nPayload = 0;
            }
            SqlJetVarintResult varint = pCell.getVarint(n);
            n += varint.getOffset();
            nKey = varint.getValue();
            nData = nPayload;
        } else {
            nData = 0;
            res = pCell.getVarint32(n);
            n += res.getOffset();
            nPayload = res.getValue();
            nKey = nPayload;
        }
        if (nPayload <= this.maxLocal) {
            nSize = nPayload + n;
            nLocal = nPayload;
            iOverflow = 0;
            if ((nSize & 0xFFFFFFFC) == 0) {
                nSize = 4;
            }
        } else {
            int surplus = this.minLocal + (nPayload - this.minLocal) % (this.pBt.usableSize - 4);
            nLocal = surplus <= this.maxLocal ? surplus : this.minLocal;
            iOverflow = nLocal + n;
            nSize = iOverflow + 4;
        }
        SqlJetBtreeCellInfo pInfo = new SqlJetBtreeCellInfo(pCell, n, nData, nPayload, iOverflow, nLocal, nSize);
        pInfo.setnKey(nKey);
        return pInfo;
    }

    public SqlJetBtreeCellInfo parseCell(int iCell) {
        return this.parseCellPtr(this.findCell(iCell));
    }

    protected void zeroPage(int flags) throws SqlJetException {
        int hdr = this.getHdrOffset();
        assert (this.pDbPage.getPageNumber() == this.pgno);
        assert (this.pDbPage.getExtra() == this);
        assert (this.pDbPage.getData().getBuffer() == this.aData.getBuffer());
        this.aData.putByteUnsigned(hdr, (short)flags);
        int first = hdr + 8 + 4 * ((flags & 8) == 0 ? 1 : 0);
        this.aData.putIntUnsigned(hdr + 1, 0L);
        this.aData.putByteUnsigned(hdr + 7, 0);
        this.aData.putShortUnsigned(hdr + 5, this.pBt.usableSize);
        this.nFree = this.pBt.usableSize - first;
        this.decodeFlags(flags);
        this.cellOffset = first;
        this.aOvfl.clear();
        this.maskPage = this.pBt.getPageSize() - 1;
        this.nCell = 0;
        this.isInit = true;
    }

    public void freePage() throws SqlJetException {
        SqlJetMemPage pPage1 = this.pBt.pPage1;
        assert (this.pgno > 1);
        this.isInit = false;
        pPage1.pDbPage.write();
        int n = pPage1.aData.getInt(36);
        pPage1.aData.putIntUnsigned(36, n + 1);
        if (ISqlJetConfig.SECURE_DELETE) {
            this.pDbPage.write();
            this.aData.fill(this.pBt.getPageSize(), (byte)0);
        }
        if (this.pBt.autoVacuumMode.isAutoVacuum()) {
            this.pBt.ptrmapPut(this.pgno, SqlJetPtrMapType.PTRMAP_FREEPAGE, 0);
        }
        if (n == 0) {
            this.pDbPage.write();
            this.aData.fill(8, (byte)0);
            pPage1.aData.putIntUnsigned(32, this.pgno);
            SqlJetBtree.traceInt("FREE-PAGE: %d first\n", this.pgno);
        } else {
            SqlJetMemPage pTrunk = this.pBt.getPage(pPage1.aData.getInt(32), false);
            int k = pTrunk.aData.getInt(4);
            if (k >= this.pBt.usableSize / 4 - 8) {
                this.pDbPage.write();
                this.aData.putIntUnsigned(0, pTrunk.pgno);
                this.aData.putIntUnsigned(4, 0L);
                pPage1.aData.putIntUnsigned(32, this.pgno);
                SqlJetBtree.traceInt("FREE-PAGE: %d new trunk page replacing %d\n", this.pgno, pTrunk.pgno);
            } else {
                if (k < 0) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                pTrunk.pDbPage.write();
                pTrunk.aData.putIntUnsigned(4, k + 1);
                pTrunk.aData.putIntUnsigned(8 + k * 4, this.pgno);
                if (ISqlJetConfig.SECURE_DELETE) {
                    this.pDbPage.dontWrite();
                }
                SqlJetBtree.traceInt("FREE-PAGE: %d leaf on trunk page %d\n", this.pgno, pTrunk.pgno);
            }
            pTrunk.releasePage();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clearCell(ISqlJetMemoryPointer pCell) throws SqlJetException {
        info = this.parseCellPtr(pCell);
        if (info.iOverflow == 0) {
            return;
        }
        ovflPgno = pCell.getInt(info.iOverflow);
        ovflPageSize = this.pBt.usableSize - 4;
        nOvfl = (info.nPayload - info.nLocal + ovflPageSize - 1) / ovflPageSize;
        if (SqlJetMemPage.$assertionsDisabled || ovflPgno == 0 || nOvfl > 0) ** GOTO lbl15
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            pOvfl = new SqlJetMemPage[1];
            if (ovflPgno < 2 || ovflPgno > this.pBt.pPager.getPageCount()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            ovflPgno = this.pBt.getOverflowPage(ovflPgno, pOvfl, nOvfl == 0 ? 0 : ovflPgno);
            pOvfl[0].freePage();
            pOvfl[0].pDbPage.unref();
lbl15:
            // 2 sources

            ** while (nOvfl-- != 0)
        }
lbl16:
        // 1 sources

    }

    int cellSize(int iCell) {
        return this.cellSizePtr(this.findCell(iCell));
    }

    int cellSizePtr(ISqlJetMemoryPointer pCell) {
        ISqlJetMemoryPointer pIter = pCell.getMoved(this.getChildPtrSize());
        int nSize = 0;
        if (this.intKey) {
            if (this.hasData) {
                SqlJetVarintResult32 res = pIter.getVarint32();
                nSize = res.getValue();
                pIter.movePointer(res.getOffset());
            }
            int pEnd = pIter.getPointer() + 9;
            while (pIter.getPointer() < pEnd) {
                int b = pIter.getByteUnsigned();
                pIter.movePointer(1);
                if ((b & 0x80) != 0) {
                    continue;
                }
                break;
            }
        } else {
            SqlJetVarintResult32 res = pIter.getVarint32();
            nSize = res.getValue();
            pIter.movePointer(res.getOffset());
        }
        if (nSize > this.maxLocal) {
            int minLocal = this.minLocal;
            if ((nSize = minLocal + (nSize - minLocal) % (this.pBt.usableSize - 4)) > this.maxLocal) {
                nSize = minLocal;
            }
            nSize += 4;
        }
        return Integer.max(4, nSize += pIter.getPointer() - pCell.getPointer());
    }

    public void dropCell(int idx, int sz) throws SqlJetException {
        assert (idx >= 0 && idx < this.nCell);
        assert (sz == this.cellSize(idx));
        ISqlJetMemoryPointer ptr = this.aData.pointer(this.cellOffset + 2 * idx);
        int pc = ptr.getShortUnsigned();
        if (pc < this.getHdrOffset() + 6 + (this.leaf ? 0 : 4) || pc + sz > this.pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.freeSpace(pc, sz);
        int endPtr = this.aData.getAbsolute(this.cellOffset + 2 * this.nCell - 2);
        while (ptr.getPointer() < endPtr) {
            ptr.putShortUnsigned(ptr.getShortUnsigned(2));
            ptr.movePointer(2);
        }
        --this.nCell;
        this.aData.putShortUnsigned(this.getHdrOffset() + 3, this.nCell);
        this.nFree += 2;
    }

    private void freeSpace(int start, int size) throws SqlJetException {
        int pbegin;
        int hdr = this.getHdrOffset();
        assert (this.pBt != null);
        assert (start >= hdr + 6 + (this.leaf ? 0 : 4));
        assert (start + size <= this.pBt.usableSize);
        assert (size >= 0);
        if (ISqlJetConfig.SECURE_DELETE) {
            this.aData.fill(start, size, (byte)0);
        }
        int addr = hdr + 1;
        while ((pbegin = this.aData.getShortUnsigned(addr)) < start && pbegin > 0) {
            assert (pbegin <= this.pBt.usableSize - 4);
            if (pbegin <= addr) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            addr = pbegin;
        }
        if (pbegin > this.pBt.usableSize - 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (pbegin > addr || pbegin == 0);
        this.aData.putShortUnsigned(addr, start);
        this.aData.putShortUnsigned(start, pbegin);
        this.aData.putShortUnsigned(start + 2, size);
        this.nFree += size;
        addr = hdr + 1;
        while ((pbegin = this.aData.getShortUnsigned(addr)) > 0) {
            assert (pbegin > addr);
            assert (pbegin <= this.pBt.usableSize - 4);
            int pnext = this.aData.getShortUnsigned(pbegin);
            int psize = this.aData.getShortUnsigned(pbegin + 2);
            if (pbegin + psize + 3 >= pnext && pnext > 0) {
                int frag = pnext - (pbegin + psize);
                if (frag < 0 || frag > this.aData.getByteUnsigned(hdr + 7)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                this.aData.putByteUnsigned(hdr + 7, (byte)(this.aData.getByteUnsigned(hdr + 7) - (byte)frag));
                int x = this.aData.getShortUnsigned(pnext);
                this.aData.putShortUnsigned(pbegin, x);
                x = pnext + this.aData.getShortUnsigned(pnext + 2) - pbegin;
                this.aData.putShortUnsigned(pbegin + 2, x);
                continue;
            }
            addr = pbegin;
        }
        if (this.aData.getByteUnsigned(hdr + 1) == this.aData.getByteUnsigned(hdr + 5) && this.aData.getByteUnsigned(hdr + 2) == this.aData.getByteUnsigned(hdr + 6)) {
            pbegin = this.aData.getShortUnsigned(hdr + 1);
            this.aData.copyFrom(hdr + 1, this.aData, pbegin, 2);
            int top = this.aData.getShortUnsigned(hdr + 5) + this.aData.getShortUnsigned(pbegin + 2);
            this.aData.putShortUnsigned(hdr + 5, top);
        }
        assert (this.pDbPage.isWriteable());
    }

    public void insertCell(int i, ISqlJetMemoryPointer pCell, int sz, ISqlJetMemoryPointer pTemp, int iChild) throws SqlJetException {
        int nSkip;
        int n = nSkip = iChild > 0 ? 4 : 0;
        assert (i >= 0 && i <= this.nCell + this.aOvfl.size());
        assert (this.nCell <= this.pBt.mxCell() && this.pBt.mxCell() <= 5460);
        assert (sz == this.cellSizePtr(pCell) || sz == 8 && iChild > 0);
        if (!this.aOvfl.isEmpty() || sz + 2 > this.nFree) {
            if (pTemp != null) {
                pTemp.copyFrom(nSkip, pCell, nSkip, sz - nSkip);
                pCell = pTemp;
            }
            if (iChild > 0) {
                pCell.putIntUnsigned(0, iChild);
            }
            this.aOvfl.add(new SqlJetOvflCell(pCell, i));
        } else {
            this.pDbPage.write();
            assert (this.pDbPage.isWriteable());
            int hdr = this.getHdrOffset();
            int top = this.aData.getShortUnsigned(hdr + 5);
            int end = this.cellOffset + 2 * this.nCell + 2;
            int ins = this.cellOffset + 2 * i;
            if (end > top - sz) {
                this.defragmentPage();
                top = this.aData.getShortUnsigned(hdr + 5);
                assert (end + sz <= top);
            }
            int idx = this.allocateSpace(sz);
            assert (idx > 0);
            assert (end <= this.aData.getShortUnsigned(hdr + 5));
            SqlJetAssert.assertTrue(idx + sz <= this.pBt.usableSize, SqlJetErrorCode.CORRUPT);
            ++this.nCell;
            this.nFree -= 2 + sz;
            this.aData.copyFrom(idx + nSkip, pCell, nSkip, sz - nSkip);
            if (iChild > 0) {
                this.aData.putIntUnsigned(idx, iChild);
            }
            int j = end - 2;
            while (j > ins) {
                this.aData.putByteUnsigned(j, this.aData.getByteUnsigned(j - 2));
                this.aData.putByteUnsigned(j + 1, this.aData.getByteUnsigned(j - 1));
                j -= 2;
            }
            this.aData.putShortUnsigned(ins, idx);
            this.aData.putShortUnsigned(hdr + 3, this.nCell);
            if (this.pBt.autoVacuumMode.isAutoVacuum()) {
                SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
                assert ((long)info.nData + (this.intKey ? 0L : info.getnKey()) == (long)info.nPayload);
                if ((long)info.nData + (this.intKey ? 0L : info.getnKey()) > (long)info.nLocal) {
                    int pgnoOvfl = pCell.getInt(info.iOverflow);
                    this.pBt.ptrmapPut(pgnoOvfl, SqlJetPtrMapType.PTRMAP_OVERFLOW1, this.pgno);
                }
            }
        }
    }

    private int allocateSpace(int nByte) throws SqlJetException {
        assert (this.pDbPage.isWriteable());
        assert (this.pBt != null);
        assert (nByte >= 0);
        assert (this.nFree >= nByte);
        assert (this.aOvfl.isEmpty());
        int usableSize = this.pBt.usableSize;
        assert (nByte < usableSize - 8);
        int hdr = this.getHdrOffset();
        int nFrag = this.aData.getByteUnsigned(hdr + 7);
        assert (this.cellOffset == hdr + 12 - 4 * (this.leaf ? 1 : 0));
        int gap = this.cellOffset + 2 * this.nCell;
        int top = this.aData.getShortUnsigned(hdr + 5);
        if (gap > top) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (nFrag >= 60) {
            this.defragmentPage();
            top = this.aData.getShortUnsigned(hdr + 5);
        } else if (gap + 2 <= top) {
            int pc;
            int addr = hdr + 1;
            while ((pc = this.aData.getShortUnsigned(addr)) > 0) {
                if (pc > usableSize - 4 || pc < addr + 4) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                int size = this.aData.getShortUnsigned(pc + 2);
                if (size >= nByte) {
                    int x = size - nByte;
                    if (x < 4) {
                        this.aData.copyFrom(addr, this.aData, pc, 2);
                        this.aData.putByteUnsigned(hdr + 7, nFrag + x);
                    } else {
                        if (size + pc > usableSize) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        this.aData.putShortUnsigned(pc + 2, x);
                    }
                    return pc + x;
                }
                addr = pc;
            }
        }
        if (gap + 2 + nByte > top) {
            this.defragmentPage();
            top = this.aData.getShortUnsigned(hdr + 5);
            assert (gap + nByte <= top);
        }
        this.aData.putShortUnsigned(hdr + 5, top -= nByte);
        assert (top + nByte <= this.pBt.usableSize);
        return top;
    }

    private void defragmentPage() throws SqlJetException {
        assert (this.pDbPage.isWriteable());
        assert (this.pBt != null);
        assert (this.pBt.usableSize <= 32768);
        assert (this.aOvfl.isEmpty());
        ISqlJetMemoryPointer temp = this.pBt.pPager.getTempSpace();
        int hdr = this.getHdrOffset();
        int cellOffset = this.cellOffset;
        int nCell = this.nCell;
        assert (nCell == this.aData.getShortUnsigned(hdr + 3));
        int usableSize = this.pBt.usableSize;
        int cbrk = this.aData.getShortUnsigned(hdr + 5);
        temp.copyFrom(cbrk, this.aData, cbrk, usableSize - cbrk);
        cbrk = usableSize;
        int iCellFirst = cellOffset + 2 * nCell;
        int iCellLast = usableSize - 4;
        ISqlJetMemoryPointer pAddr = this.aData.getBuffer().getPointer(cellOffset);
        int i = 0;
        while (i < nCell) {
            int pc = pAddr.getShortUnsigned(i * 2);
            if (pc < iCellFirst || pc > iCellLast) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (pc >= iCellFirst && pc <= iCellLast);
            int size = this.cellSizePtr(temp.getBuffer().getPointer(pc));
            if ((cbrk -= size) < iCellFirst || pc + size > usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (cbrk + size <= usableSize && cbrk >= iCellFirst);
            this.aData.copyFrom(cbrk, temp, pc, size);
            pAddr.putShortUnsigned(i * 2, cbrk);
            ++i;
        }
        assert (cbrk >= iCellFirst);
        this.aData.putShortUnsigned(hdr + 5, cbrk);
        this.aData.putByteUnsigned(hdr + 1, 0);
        this.aData.putByteUnsigned(hdr + 2, 0);
        this.aData.putByteUnsigned(hdr + 7, 0);
        this.aData.fill(iCellFirst, cbrk - iCellFirst, (byte)0);
        assert (this.pDbPage.isWriteable());
        if (cbrk - iCellFirst != this.nFree) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public ISqlJetMemoryPointer findOverflowCell(int iCell) {
        for (SqlJetOvflCell pOvfl : this.aOvfl) {
            int k = pOvfl.getIdx();
            if (k > iCell) continue;
            if (k == iCell) {
                return pOvfl.getpCell();
            }
            --iCell;
        }
        return this.findCell(iCell);
    }

    public void assemblePage(int nCell, ISqlJetMemoryPointer[] apCell, int apCellPos, int[] aSize, int aSizePos) throws SqlJetException {
        int hdr = this.getHdrOffset();
        int nUsable = this.pBt.usableSize;
        assert (this.aOvfl.isEmpty());
        assert (nCell >= 0 && nCell <= this.pBt.mxCell() && this.pBt.mxCell() <= 10921);
        assert (this.pDbPage.isWriteable());
        assert (this.nCell == 0);
        assert (this.aData.getShortUnsigned(hdr + 5) == nUsable);
        int pCellOffset = this.cellOffset + nCell * 2;
        int cellbody = nUsable;
        int i = nCell - 1;
        while (i >= 0) {
            int sz = aSize[apCellPos + i];
            this.aData.putShortUnsigned(pCellOffset -= 2, cellbody -= sz);
            this.aData.copyFrom(cellbody, apCell[apCellPos + i], 0, sz);
            --i;
        }
        this.aData.putShortUnsigned(hdr + 3, nCell);
        this.aData.putShortUnsigned(hdr + 5, cellbody);
        this.nFree -= 2 * nCell + this.pBt.usableSize - cellbody;
        this.nCell = nCell;
    }

    public void assertParentIndex(int iIdx, int iChild) {
        assert (iIdx <= this.nCell);
        if (iIdx == this.nCell ? !$assertionsDisabled && this.aData.getInt(this.getHdrOffset() + 8) != iChild : !$assertionsDisabled && this.findCell(iIdx).getInt() != iChild) {
            throw new AssertionError();
        }
    }

    public int fillInCell(ISqlJetMemoryPointer pCell, ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int nZero) throws SqlJetException {
        int nSrc;
        ISqlJetMemoryPointer pSrc;
        SqlJetMemPage pOvfl = null;
        SqlJetMemPage pToRelease = null;
        SqlJetBtreeShared pBt = this.pBt;
        int[] pgnoOvfl = new int[1];
        assert (pCell.getBuffer() != this.aData.getBuffer() || this.pDbPage.isWriteable());
        int nHeader = 0;
        if (!this.leaf) {
            nHeader += 4;
        }
        if (this.hasData) {
            nHeader += pCell.pointer(nHeader).putVarint(nData + nZero);
        } else {
            nZero = 0;
            nData = 0;
        }
        nHeader += pCell.pointer(nHeader).putVarint(nKey);
        SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
        assert (info.nHeader == nHeader);
        assert (info.getnKey() == nKey);
        assert (info.nData == nData + nZero);
        int nPayload = nData + nZero;
        if (this.intKey) {
            pSrc = pData;
            nSrc = nData;
            nData = 0;
        } else {
            nPayload += (int)nKey;
            pSrc = pKey;
            nSrc = (int)nKey;
        }
        int pnSize = info.nSize;
        int spaceLeft = info.nLocal;
        ISqlJetMemoryPointer pPayload = pCell.pointer(nHeader);
        ISqlJetMemoryPointer pPrior = pCell.pointer(info.iOverflow);
        while (nPayload > 0) {
            int n;
            if (spaceLeft == 0) {
                int pgnoPtrmap = pgnoOvfl[0];
                if (pBt.autoVacuumMode.isAutoVacuum()) {
                    do {
                        pgnoOvfl[0] = pgnoOvfl[0] + 1;
                    } while (pBt.ptrmapIsPage(pgnoOvfl[0]) || pgnoOvfl[0] == pBt.pendingBytePage());
                }
                try {
                    pOvfl = pBt.allocatePage(pgnoOvfl, pgnoOvfl[0], false);
                    if (pBt.autoVacuumMode.isAutoVacuum()) {
                        SqlJetPtrMapType eType = pgnoPtrmap != 0 ? SqlJetPtrMapType.PTRMAP_OVERFLOW2 : SqlJetPtrMapType.PTRMAP_OVERFLOW1;
                        try {
                            pBt.ptrmapPut(pgnoOvfl[0], eType, pgnoPtrmap);
                        }
                        catch (SqlJetException e) {
                            SqlJetMemPage.releasePage(pOvfl);
                        }
                    }
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(pToRelease);
                    throw e;
                }
                assert (pToRelease == null || pToRelease.pDbPage.isWriteable());
                assert (pPrior.getBuffer() != this.aData.getBuffer() || this.pDbPage.isWriteable());
                pPrior.putIntUnsigned(0, pgnoOvfl[0]);
                SqlJetMemPage.releasePage(pToRelease);
                pToRelease = pOvfl;
                pPrior = pOvfl.aData;
                pPrior.putIntUnsigned(0, 0L);
                pPayload = pOvfl.aData.pointer(4);
                spaceLeft = pBt.usableSize - 4;
            }
            if ((n = nPayload) > spaceLeft) {
                n = spaceLeft;
            }
            assert (pToRelease == null || pToRelease.pDbPage.isWriteable());
            assert (pPayload.getBuffer() != this.aData.getBuffer() || this.pDbPage.isWriteable());
            if (nSrc > 0) {
                if (n > nSrc) {
                    n = nSrc;
                }
                assert (pSrc != null);
                pPayload.copyFrom(pSrc, n);
            } else {
                pPayload.fill(n, (byte)0);
            }
            nPayload -= n;
            pPayload.movePointer(n);
            pSrc = pSrc.pointer(n);
            spaceLeft -= n;
            if ((nSrc -= n) != 0) continue;
            nSrc = nData;
            pSrc = pData;
        }
        SqlJetMemPage.releasePage(pToRelease);
        return pnSize;
    }

    public void ptrmapPutOvfl(int iCell) throws SqlJetException {
        ISqlJetMemoryPointer pCell = this.findOverflowCell(iCell);
        this.ptrmapPutOvflPtr(pCell);
    }

    public void copyNodeContent(SqlJetMemPage pTo) throws SqlJetException {
        int iToHdr;
        SqlJetBtreeShared pBt = this.pBt;
        ISqlJetMemoryPointer aFrom = this.aData;
        ISqlJetMemoryPointer aTo = pTo.aData;
        int iFromHdr = this.getHdrOffset();
        int n = iToHdr = pTo.pgno == 1 ? 100 : 0;
        assert (this.isInit);
        assert (this.nFree >= iToHdr);
        int iData = aFrom.getShortUnsigned(iFromHdr + 5);
        assert (iData <= pBt.usableSize);
        aTo.copyFrom(iData, aFrom, iData, pBt.usableSize - iData);
        aTo.copyFrom(iToHdr, aFrom, iFromHdr, this.cellOffset + 2 * this.nCell);
        pTo.isInit = false;
        pTo.initPage();
        if (pBt.autoVacuumMode.isAutoVacuum()) {
            pTo.setChildPtrmaps();
        }
    }

    @Override
    public SqlJetMemPage clone() throws CloneNotSupportedException {
        SqlJetMemPage clone = (SqlJetMemPage)super.clone();
        clone.aData = SqlJetUtility.memoryManager.allocatePtr(clone.pBt.getPageSize());
        clone.aOvfl = this.aOvfl.clone();
        return clone;
    }

    public byte getChildPtrSize() {
        return this.leaf ? (byte)0 : 4;
    }

    public ISqlJetMemoryPointer getData() {
        return this.aData;
    }
}

