/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetNoLockFile;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

public class SqlJetFile
extends SqlJetNoLockFile
implements ISqlJetFile {
    private static final Map<String, OpenFile> openFiles = new HashMap<String, OpenFile>();
    private File filePath;
    private String filePathResolved;
    private SqlJetLockType lockType = SqlJetLockType.NONE;
    private Map<SqlJetLockType, FileLock> locks = new ConcurrentHashMap<SqlJetLockType, FileLock>();
    private OpenFile openCount = null;
    private LockInfo lockInfo = null;
    private SqlJetFileLockManager fileLockManager;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$tmatesoft$sqljet$core$internal$SqlJetLockType;

    private String getpid() {
        return "thread ['" + Thread.currentThread().getName() + "]";
    }

    private String locktypeName(SqlJetLockType lockType) {
        return lockType != null ? lockType.name() : null;
    }

    public SqlJetFile(SqlJetFileSystem fileSystem, RandomAccessFile file, File filePath, Set<SqlJetFileOpenPermission> permissions) {
        super(fileSystem, file, filePath, permissions);
        this.filePath = filePath;
        this.filePathResolved = filePath.getAbsolutePath();
        this.fileLockManager = new SqlJetFileLockManager(this.filePathResolved, this.channel);
        this.findLockInfo();
        SqlJetFile.OSTRACE("OPEN    %s\n", this.filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SqlJetException {
        if (this.file == null) {
            return;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            this.unlock(SqlJetLockType.NONE);
            if (this.openCount != null && this.openCount.lockInfoMap != null && this.openCount.lockInfoMap.size() > 0) {
                for (LockInfo l : this.openCount.lockInfoMap.values()) {
                    if (l.sharedLockCount <= 0) continue;
                    this.openCount.pending.add(this.file);
                    return;
                }
            }
            this.releaseLockInfo();
            try {
                try {
                    this.file.close();
                    this.channel.close();
                }
                catch (IOException e) {
                    throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
                }
            }
            finally {
                this.file = null;
                this.channel = null;
            }
        }
        if (this.filePath != null && this.permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE) && !SqlJetFileUtil.deleteFile(this.filePath)) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE, String.format("Can't delete file '%s'", this.filePath.getPath()));
        }
        SqlJetFile.OSTRACE("CLOSE   %s\n", this.filePath);
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized boolean lock(SqlJetLockType lockType) throws SqlJetIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 13[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean unlock(SqlJetLockType lockType) throws SqlJetIOException {
        assert (lockType != null);
        assert (this.file != null);
        SqlJetFile.OSTRACE("UNLOCK  %s %s was %s(%s,%s) pid=%s\n", this.filePath, this.locktypeName(lockType), this.locktypeName(this.lockType), this.locktypeName(this.lockInfo.lockType), this.lockInfo.sharedLockCount, this.getpid());
        assert (SqlJetLockType.SHARED.compareTo(lockType) >= 0);
        if (this.lockType.compareTo(lockType) <= 0) {
            return true;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            assert (this.lockInfo != null);
            assert (this.lockInfo.sharedLockCount > 0);
            try {
                if (SqlJetLockType.SHARED.compareTo(this.lockType) < 0) {
                    FileLock pendingLock;
                    FileLock reservedLock;
                    if (SqlJetLockType.SHARED == lockType) {
                        FileLock exclusiveLock = this.locks.get((Object)SqlJetLockType.EXCLUSIVE);
                        if (exclusiveLock != null) {
                            exclusiveLock.release();
                            this.locks.remove((Object)SqlJetLockType.EXCLUSIVE);
                        }
                        if (this.locks.get((Object)SqlJetLockType.SHARED) == null) {
                            FileLock sharedLock = this.fileLockManager.lock(0x40000002L, 510L, true);
                            if (sharedLock == null) {
                                return false;
                            }
                            this.locks.put(SqlJetLockType.SHARED, sharedLock);
                            this.lockInfo.sharedLock = sharedLock;
                        }
                    }
                    if ((reservedLock = this.locks.get((Object)SqlJetLockType.RESERVED)) != null) {
                        reservedLock.release();
                        this.locks.remove((Object)SqlJetLockType.RESERVED);
                    }
                    if ((pendingLock = this.locks.get((Object)SqlJetLockType.PENDING)) != null) {
                        pendingLock.release();
                        this.locks.remove((Object)SqlJetLockType.PENDING);
                    }
                    this.lockInfo.lockType = SqlJetLockType.SHARED;
                }
                if (lockType == SqlJetLockType.NONE) {
                    Iterator<FileLock> iterator;
                    LockInfo lockInfo = this.lockInfo;
                    lockInfo.sharedLockCount = lockInfo.sharedLockCount - 1;
                    if (this.lockInfo.sharedLockCount == 0) {
                        this.lockInfo.sharedLockCount = 1;
                        iterator = this.locks.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.locks.clear();
                                this.lockInfo.sharedLockCount = 0;
                                this.lockInfo.lockType = SqlJetLockType.NONE;
                                break;
                            }
                            FileLock l = iterator.next();
                            l.release();
                        }
                    }
                    OpenFile openFile = this.openCount;
                    openFile.numLock = openFile.numLock - 1;
                    assert (this.openCount.numLock >= 0);
                    if (this.openCount.numLock == 0 && this.openCount.pending != null && this.openCount.pending.size() > 0) {
                        iterator = this.openCount.pending.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.openCount.pending.clear();
                                break;
                            }
                            RandomAccessFile f = (RandomAccessFile)((Object)iterator.next());
                            f.close();
                        }
                    }
                }
                this.lockType = lockType;
            }
            catch (IOException e) {
                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)e);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean checkReservedLock() {
        boolean reserved;
        block11: {
            reserved = false;
            if (this.file != null && this.lockInfo != null) break block11;
            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
            return false;
        }
        try {
            FileLock reservedLock;
            block13: {
                block12: {
                    Map<String, OpenFile> map = openFiles;
                    // MONITORENTER : map
                    if (SqlJetLockType.SHARED.compareTo(this.lockInfo.lockType) >= 0) break block12;
                    // MONITOREXIT : map
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : map
                            throw throwable;
                        }
                    }
                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                    return true;
                }
                reservedLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
                if (reservedLock != null) break block13;
                reserved = true;
                // MONITOREXIT : map
                SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                return true;
            }
            try {
                reservedLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
            throw throwable;
        }
        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findLockInfo() {
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            LockInfo fileLockInfo;
            if (this.openCount == null) {
                OpenFile fileOpenCount = openFiles.get(this.filePathResolved);
                if (fileOpenCount != null) {
                    OpenFile openFile = this.openCount = fileOpenCount;
                    openFile.numRef = openFile.numRef + 1;
                } else {
                    this.openCount = new OpenFile();
                    openFiles.put(this.filePathResolved, this.openCount);
                }
            }
            if ((fileLockInfo = (LockInfo)this.openCount.lockInfoMap.get(Thread.currentThread())) != null) {
                LockInfo lockInfo = this.lockInfo = fileLockInfo;
                lockInfo.numRef = lockInfo.numRef + 1;
            } else {
                this.lockInfo = new LockInfo();
                this.openCount.lockInfoMap.put(Thread.currentThread(), this.lockInfo);
            }
        }
    }

    private void releaseLockInfo() {
        if (this.lockInfo != null) {
            LockInfo lockInfo = this.lockInfo;
            lockInfo.numRef = lockInfo.numRef - 1;
            if (this.lockInfo.numRef == 0) {
                if (this.openCount != null) {
                    this.openCount.lockInfoMap.remove(Thread.currentThread());
                }
                this.lockInfo = null;
            }
        }
        if (this.openCount != null) {
            OpenFile openFile = this.openCount;
            openFile.numRef = openFile.numRef - 1;
            if (this.openCount.numRef == 0) {
                openFiles.remove(this.filePathResolved);
                this.openCount = null;
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$tmatesoft$sqljet$core$internal$SqlJetLockType() {
        if ($SWITCH_TABLE$org$tmatesoft$sqljet$core$internal$SqlJetLockType != null) {
            return $SWITCH_TABLE$org$tmatesoft$sqljet$core$internal$SqlJetLockType;
        }
        int[] nArray = new int[SqlJetLockType.values().length];
        try {
            nArray[SqlJetLockType.EXCLUSIVE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SqlJetLockType.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SqlJetLockType.PENDING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SqlJetLockType.RESERVED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SqlJetLockType.SHARED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$tmatesoft$sqljet$core$internal$SqlJetLockType = nArray;
        return nArray;
    }

    private static class LockInfo {
        private SqlJetLockType lockType = SqlJetLockType.NONE;
        private int sharedLockCount = 0;
        private int numRef = 1;
        private FileLock sharedLock = null;

        private LockInfo() {
        }

        static /* synthetic */ FileLock access$3(LockInfo lockInfo) {
            return lockInfo.sharedLock;
        }
    }

    private static class OpenFile {
        private int numRef = 1;
        private int numLock = 0;
        private Map<Thread, LockInfo> lockInfoMap = new ConcurrentHashMap<Thread, LockInfo>();
        private List<RandomAccessFile> pending = new ArrayList<RandomAccessFile>();

        private OpenFile() {
        }
    }
}

