/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLock;

public class SqlJetFileLockManager {
    private String filePath;
    private FileChannel fileChannel;
    private static final Map<String, List<SqlJetFileLock>> locks = new ConcurrentHashMap<String, List<SqlJetFileLock>>();
    private ILockCreator tryLockCreator = (position, size, shared) -> this.fileChannel.tryLock(position, size, shared);
    private ILockCreator lockCreator = (position, size, shared) -> this.fileChannel.lock(position, size, shared);

    public SqlJetFileLockManager(String filePath, FileChannel fileChannel) {
        this.filePath = filePath;
        this.fileChannel = fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock createLock(long position, long size, boolean shared, ILockCreator lockCreator) throws IOException {
        Map<String, List<SqlJetFileLock>> map = locks;
        synchronized (map) {
            block5: {
                SqlJetFileLock lock = this.getLock(position, size);
                if (lock == null) break block5;
                if (shared) {
                    lock.addLock();
                    return lock;
                }
                return null;
            }
            return this.addLock(lockCreator.createLock(position, size, shared));
        }
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.createLock(position, size, shared, this.tryLockCreator);
    }

    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.createLock(position, size, shared, this.lockCreator);
    }

    private SqlJetFileLock getLock(long position, long size) {
        if (locks.containsKey(this.filePath)) {
            for (SqlJetFileLock fl : locks.get(this.filePath)) {
                if (!fl.overlaps(position, size)) continue;
                return fl;
            }
        }
        return null;
    }

    private SqlJetFileLock addLock(FileLock lock) {
        if (lock != null) {
            SqlJetFileLock l = new SqlJetFileLock(this, lock);
            if (!locks.containsKey(this.filePath)) {
                locks.put(this.filePath, new ArrayList());
            }
            locks.get(this.filePath).add(l);
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLock(SqlJetFileLock lock) {
        Map<String, List<SqlJetFileLock>> map = locks;
        synchronized (map) {
            if (locks.containsKey(this.filePath)) {
                List<SqlJetFileLock> list = locks.get(this.filePath);
                list.remove(lock);
                if (list.size() == 0) {
                    locks.remove(this.filePath);
                }
            }
        }
    }

    private static interface ILockCreator {
        public FileLock createLock(long var1, long var3, boolean var5) throws IOException;
    }
}

