/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;

public class SqlJetFileUtil {
    public static final int ATTEMPTS_COUNT = SqlJetUtility.getIntSysProp("sqljet.fs.win32_retry_count", 100);
    public static final SqlJetOsType OS = new SqlJetOsType();

    public static boolean deleteFile(File file) {
        return SqlJetFileUtil.deleteFile(file, false);
    }

    public static boolean deleteFile(File file, boolean sync) {
        if (file == null) {
            return true;
        }
        if (OS.isWindows() && !sync) {
            file.deleteOnExit();
        }
        if (!sync || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        long sleep = 1L;
        int i = 0;
        while (i < ATTEMPTS_COUNT) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (sleep < 128L) {
                sleep *= 2L;
            }
            ++i;
        }
        return false;
    }

    public static RandomAccessFile openFile(File file, String mode) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (OS.isWindows()) {
            long sleep = 1L;
            int i = 0;
            while (i < ATTEMPTS_COUNT) {
                try {
                    return new RandomAccessFile(file, mode);
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e1) {
                        return null;
                    }
                    if (sleep < 128L) {
                        sleep *= 2L;
                    }
                    ++i;
                }
            }
        }
        return new RandomAccessFile(file, mode);
    }

    private static class SqlJetOsType {
        private final boolean windows;

        public SqlJetOsType() {
            String osNameLC;
            String osName = System.getProperty("os.name");
            this.windows = osName == null ? false : (osNameLC = osName.toLowerCase()).indexOf("windows") >= 0 || osNameLC.indexOf("os/2") >= 0;
        }

        public boolean isWindows() {
            return this.windows;
        }
    }
}

