/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.lang;

import java.io.File;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetExecCallback;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetPreparedStatement;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetConnection
implements AutoCloseable {
    private final SqlJetDb db;

    protected SqlJetConnection(String fileName) throws SqlJetException {
        this.db = SqlJetDb.open(new File(fileName), false);
    }

    public static SqlJetConnection open(String fileName) throws SqlJetException {
        return new SqlJetConnection(fileName);
    }

    public SqlJetPreparedStatement prepare(String sql) throws SqlJetException {
        if (sql == null || sql.trim().length() == 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "SQL statement is empty");
        }
        return new SqlJetPreparedStatement(this.db, sql);
    }

    public void exec(String sql, SqlJetExecCallback callback) throws SqlJetException {
        this.db.runWithLock(db -> {
            try (SqlJetPreparedStatement stmt = this.prepare(sql);){
                while (stmt.step()) {
                    if (callback == null) continue;
                    callback.processRow(stmt);
                }
            }
            return null;
        });
    }

    @Override
    public void close() throws SqlJetException {
        this.db.close();
    }

    public ISqlJetSchema getSchema(String databaseName) throws SqlJetException {
        return this.db.getSchema();
    }
}

