/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapCursor;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTable;
import org.tmatesoft.sqljet.core.map.ISqlJetMap;
import org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTable;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;

public class SqlJetMap
implements ISqlJetMap {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;
    private ISqlJetMapTable mapTable;

    public SqlJetMap(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    @Override
    public ISqlJetMapCursor getCursor() throws SqlJetException {
        return this.mapDb.runSynchronized(engine -> new SqlJetMapCursor(this.mapDb, this.btree, this.mapDef, this.writable));
    }

    @Override
    public void put(Object[] key, Object[] value) throws SqlJetException {
        this.mapDb.write().as(mapDb -> {
            try (ISqlJetMapCursor cursor = this.getCursor();){
                cursor.put(key, value);
                return null;
            }
        });
    }

    @Override
    public Object[] get(Object[] key) throws SqlJetException {
        return this.mapDb.read().as(mapDb -> {
            try (ISqlJetMapCursor cursor = this.getCursor();){
                if (cursor.goToKey(key)) {
                    Object[] objectArray2 = cursor.getValue();
                    return objectArray2;
                }
                return null;
            }
        });
    }

    @Override
    public synchronized ISqlJetMapTable getMapTable() throws SqlJetException {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTable(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }
}

