/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;

public class SqlJetMapCursor
implements ISqlJetMapCursor {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private final boolean writable;
    private ISqlJetMapTableCursor mapTable;
    private ISqlJetMapIndexCursor mapIndex;

    public SqlJetMapCursor(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) throws SqlJetException {
        SqlJetAssert.assertTrue(mapDb.isInTransaction(), SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    @Override
    public synchronized ISqlJetMapTableCursor getMapTable() throws SqlJetException {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTableCursor(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }

    @Override
    public synchronized ISqlJetMapIndexCursor getMapIndex() throws SqlJetException {
        if (this.mapIndex == null) {
            ISqlJetIndexDef indexDef = this.mapDef.getIndexDef();
            this.mapIndex = new SqlJetMapIndexCursor(this.mapDb, this.btree, indexDef, this.writable);
        }
        return this.mapIndex;
    }

    @Override
    public synchronized void close() throws SqlJetException {
        if (this.mapTable != null) {
            this.mapTable.close();
            this.mapTable = null;
        }
        if (this.mapIndex != null) {
            this.mapIndex.close();
            this.mapIndex = null;
        }
    }

    @Override
    public Object[] getKey() throws SqlJetException {
        return this.getMapIndex().getKey();
    }

    @Override
    public Object[] getValue() throws SqlJetException {
        return this.getMapTable().getValue();
    }

    @Override
    public boolean goToKey(Object[] key) throws SqlJetException {
        if (this.getMapIndex().goToKey(key)) {
            return this.getMapTable().goToKey(this.getMapIndex().getValue());
        }
        return false;
    }

    @Override
    public void put(Object[] key, Object[] value) throws SqlJetException {
        this.getMapIndex().put(key, this.getMapTable().put(0L, value));
    }

    @Override
    public boolean eof() throws SqlJetException {
        return this.getMapIndex().eof();
    }

    @Override
    public boolean first() throws SqlJetException {
        return this.getMapIndex().first();
    }

    @Override
    public boolean last() throws SqlJetException {
        return this.getMapIndex().last();
    }

    @Override
    public boolean next() throws SqlJetException {
        return this.getMapIndex().next();
    }

    @Override
    public boolean previous() throws SqlJetException {
        return this.getMapIndex().previous();
    }
}

